<?php
namespace CryptocurrencyWidgetsProREG;
if(!class_exists("CryptocurrencyWidgetsPROBase")) {
	class CryptocurrencyWidgetsPROBase {
    	public $key = "A6A5758D3FBB2506";
    	private $product_id = "4";
    	private $product_base = "ccpwp";
    	private $server_host = "https://license.coolplugins.net/wp-json/licensor/";
    	private $has_check_update=true;
    	private $isEncryptUpdate=true;
    	private $plugin_file;
        private static $selfobj=null;
        private $version="";
        private $is_theme=false;
        private $email_address = "";
        private static $_on_delete_license = array();
		function __construct($plugin_base_file='')
		{
			$this->plugin_file=$plugin_base_file;
            $dir=dirname($plugin_base_file);
            $dir=str_replace('\\','/',$dir);
            if(strpos($dir,'wp-content/themes')!==FALSE){
                $this->is_theme=true;
            }
			$this->version=$this->get_current_version();
			if($this->has_check_update) {
				if(function_exists("add_action")){
					add_action( 'admin_post_ccpwp_fupc', function(){
						update_option('_site_transient_update_plugins','');
						update_option('_site_transient_update_themes','');
						set_site_transient('update_themes', null);
                        delete_transient($this->product_base."_up");
						wp_redirect(  admin_url( 'plugins.php' ) );
						exit;
					});
					add_action( 'init', [$this,"init_action_handler"]);

				}
				if(function_exists("add_filter")) {
					//
					if($this->is_theme){
						add_filter('pre_set_site_transient_update_themes', [$this, "plugin_update"]);
						add_filter('themes_api', [$this, 'check_update_info'], 10, 3);
					}else{
						add_filter('pre_set_site_transient_update_plugins', [$this, "plugin_update"]);
						add_filter('plugins_api', [$this, 'check_update_info'], 10, 3);
						add_filter( 'plugin_row_meta', function($links, $plugin_file ){
							if ( $plugin_file == plugin_basename( $this->plugin_file ) ) {
								$links[] = " <a class='edit coption' href='" . esc_url( admin_url( 'admin-post.php' ) . '?action=ccpwp_fupc' ) . "'>Update Check</a>";
							}
							return $links;
						}, 10, 2 );
						add_action( "in_plugin_update_message-".plugin_basename( $this->plugin_file ), [$this,'update_message_cb'], 20, 2 );
					}



				}


			}
		}
		public function set_email_address( $email_address ) {
            $this->email_address = $email_address;
        }
		function init_action_handler(){
			$handler=hash("crc32b",$this->product_id.$this->key.$this->get_domain())."_handle";
			if(isset($_GET['action']) && $_GET['action']==$handler){
				$this->handle_server_request();
				exit;
			}
		}
		function handle_server_request(){
			$type=isset($_GET['type'])?strtolower($_GET['type']):"";
			switch ($type) {
				case "rl": //remove license
					$this->clean_update_info();
					$this->remove_old_wp_response();
					$obj          = new \stdClass();
					$obj->product = $this->product_id;
					$obj->status  = true;
					echo $this->encrypt_obj( $obj );
					
					return;
				case "rc": //remove license
					$key  = $this->get_key_name();
					delete_option( $key );
					$obj          = new \stdClass();
					$obj->product = $this->product_id;
					$obj->status  = true;
					echo $this->encrypt_obj( $obj );
					return;
				case "dl": //delete plugins
					$obj          = new \stdClass();
					$obj->product = $this->product_id;
					$obj->status  = false;
					$this->remove_old_wp_response();
					require_once( ABSPATH . 'wp-admin/includes/file.php' );
					if ( $this->is_theme ) {
						$res = delete_theme( $this->plugin_file );
						if ( ! is_wp_error( $res ) ) {
							$obj->status = true;
						}
						echo $this->encrypt_obj( $obj );
					} else {
					    deactivate_plugins( [ plugin_basename( $this->plugin_file ) ] );
						$res = delete_plugins( [ plugin_basename( $this->plugin_file ) ] );
						if ( ! is_wp_error( $res ) ) {
							$obj->status = true;
						}
						echo $this->encrypt_obj( $obj );
					}
					
					return;
				default:
					return;
			}
		}
		/**
         * @param callable $func
         */
        static function add_on_delete( $func ) {
			self::$_on_delete_license[] = $func;
		}
		function get_current_version(){
			if( !function_exists('get_plugin_data') ){
				require_once( ABSPATH . 'wp-admin/includes/plugin.php' );
			}
			$data=get_plugin_data($this->plugin_file,true,false);
			if(isset($data['Version'])){
				return $data['Version'];
			}
			return 0;
		}
		public function clean_update_info(){
            update_option('_site_transient_update_plugins','');
            update_option('_site_transient_update_themes','');
            delete_transient($this->product_base."_up");
        }
        public function update_message_cb($data, $response){
            if(is_array($data)){
                $data=(object)$data;
            }
            if(isset($data->package) && empty($data->package)) {
                if(empty($data->update_denied_type)) {
                    print  "<br/><span style='display: block; border-top: 1px solid #ccc;padding-top: 5px; margin-top: 10px;'>Please <strong>active product</strong> or  <strong>renew support period</strong> to get latest version</span>";
                }elseif($data->update_denied_type=="L"){
                    print  "<br/><span style='display: block; border-top: 1px solid #ccc;padding-top: 5px; margin-top: 10px;'>Please <strong>active product</strong> to get latest version</span>";
                }elseif($data->update_denied_type=="S"){
                    print  "<br/><span style='display: block; border-top: 1px solid #ccc;padding-top: 5px; margin-top: 10px;'>Please <strong>renew support period</strong> to get latest version</span>";
                }
            }
        }
		function __plugin_updateInfo(){
            if(function_exists("wp_remote_get")) {
                $response = get_transient( $this->product_base."_up" );
                $oldFound = false;
                if ( ! empty( $response['data'] ) ) {
                    $response = unserialize( $this->decrypt( $response['data'] ) );
                    if ( is_array( $response ) ) {
                        $oldFound = true;
                    }
                }

                if ( ! $oldFound ) {
                    $licenseInfo=self::GetRegisterInfo();
                    $url=$this->server_host . "product/update/" . $this->product_id;
                    if(!empty($licenseInfo->license_key)) {
                        $url.="/".$licenseInfo->license_key."/".$this->version;
                    }
                    $args=[
                        'sslverify' => true,
                        'timeout' => 120,
                        'redirection' => 5,
                        'cookies' => array()
                    ];
                    $response = wp_remote_get( $url,$args);
                    if (is_wp_error($response)) {
                        $args['sslverify']=false;
                        $response = wp_remote_get( $url,$args);
                    }
                }

                if (!is_wp_error($response)) {
                    $body         = $response['body'];
                    $response_json = @json_decode( $body );
                    if ( ! $oldFound ) {
                        set_transient( $this->product_base."_up", [ "data" => $this->encrypt( serialize( [ 'body' => $body ] ) ) ], DAY_IN_SECONDS );
                    }

                    if(!(is_object( $response_json ) && isset($response_json->status )) && $this->isEncryptUpdate){
                        $body=$this->decrypt($body,$this->key);
                        $response_json = json_decode( $body );
                    }

                    if ( is_object( $response_json ) && ! empty( $response_json->status ) && ! empty( $response_json->data->new_version ) ) {
                        $response_json->data->slug = plugin_basename( $this->plugin_file );;
                        $response_json->data->new_version = ! empty( $response_json->data->new_version ) ? $response_json->data->new_version : "";
                        $response_json->data->url         = ! empty( $response_json->data->url ) ? $response_json->data->url : "";
                        $response_json->data->package     = ! empty( $response_json->data->download_link ) ? $response_json->data->download_link : "";
                        $response_json->data->update_denied_type     = ! empty( $response_json->data->update_denied_type ) ? $response_json->data->update_denied_type : "";

                        $response_json->data->sections    = (array) $response_json->data->sections;
                        $response_json->data->plugin      = plugin_basename( $this->plugin_file );
                        $response_json->data->icons       = (array) $response_json->data->icons;
                        $response_json->data->banners     = (array) $response_json->data->banners;
                        $response_json->data->banners_rtl = (array) $response_json->data->banners_rtl;
                        unset( $response_json->data->is_stopped_update );

                        return $response_json->data;
                    }
                }
            }

            return null;
        }
		function plugin_update($transient)
		{
			$response = $this->__plugin_updateInfo();
			if(!empty($response->plugin)){
                if($this->is_theme){
                    $theme_data = wp_get_theme();
                    $index_name="".$theme_data->get_template();
                }else{
                    $index_name=$response->plugin;
                }
                if (!empty($response) && version_compare($this->version, $response->new_version, '<')) {
                    unset($response->download_link);
                    unset($response->is_stopped_update);
                    if($this->is_theme){
                        $transient->response[$index_name] = (array)$response;
                    }else{
                        $transient->response[$index_name] = (object)$response;
                    }
                }else{
                    if(isset($transient->response[$index_name])){
                        unset($transient->response[$index_name]);
                    }
                }
            }
            return $transient;
		}
		final function check_update_info($false, $action, $arg) {
		    if ( empty($arg->slug)){
                return $false;
            }
			if($this->is_theme){
				if ( !empty($arg->slug) && $arg->slug === $this->product_base){
					$response =$this->__plugin_updateInfo();
					if ( !empty($response)) {
						return $response;
					}
				}
			}else{
				if ( !empty($arg->slug) && $arg->slug === plugin_basename($this->plugin_file) ) {
					$response =$this->__plugin_updateInfo();
					if ( !empty($response)) {
						return $response;
					}
				}
			}

			return $false;
		}

		/**
		 * @param $plugin_base_file
		 *
		 * @return self|null
		 */
			// phpcs:ignore WordPress.NamingConventions.ValidFunctionName
            public static function &getInstance($plugin_base_file=null) {
	            return self::get_instance($plugin_base_file);
		}
		/**
		 * @param $plugin_base_file
		 *
		 * @return self|null
		 */
		public static function &get_instance($plugin_base_file=null) {
			if ( empty( self::$selfobj ) ) {
				if ( ! empty( $plugin_base_file ) ) {
					self::$selfobj = new self( $plugin_base_file );
				}
			}
			
			return self::$selfobj;
		}

        static function get_renew_link($response_obj,$type="s"){
			if(empty($response_obj->renew_link)){
                return "";
            }
            $is_show_button=false;
            if($type=="s") {
                $support_str=strtolower( trim( $response_obj->support_end ) );
                if ( strtolower( trim( $response_obj->support_end ) ) == "no support" ) {
                    $is_show_button = true;
                } elseif ( !in_array($support_str, ["unlimited"] ) ) {
                    if ( strtotime( 'ADD 30 DAYS', strtotime( $response_obj->support_end ) ) < time() ) {
                        $is_show_button = true;
                    }
                }
                if ( $is_show_button ) {
                    return $response_obj->renew_link.(strpos($response_obj->renew_link,"?")===FALSE?'?type=s&lic='.rawurlencode($response_obj->license_key):'&type=s&lic='.rawurlencode($response_obj->license_key));
                }
                return '';
            }else{
                $is_show_button=false;
                $expire_str=strtolower( trim( $response_obj->expire_date ) );
                if ( !in_array($expire_str, ["unlimited","no expiry"] )) {
                    if ( strtotime( 'ADD 30 DAYS', strtotime( $response_obj->expire_date ) ) < time() ) {
                        $is_show_button = true;
                    }
                }
                if ( $is_show_button ) {
                    return $response_obj->renew_link.(strpos($response_obj->renew_link,"?")===FALSE?'?type=l&lic='.rawurlencode($response_obj->license_key):'&type=l&lic='.rawurlencode($response_obj->license_key));
                }
                return '';
            }
		}

		private function encrypt($plainText,$password='') {
			if(empty($password)){
				$password=$this->key;
			}
			$plainText=rand(10,99).$plainText.rand(10,99);
			$method = 'aes-256-cbc';
			$key = substr( hash( 'sha256', $password, true ), 0, 32 );
			$iv = substr(strtoupper(md5($password)),0,16);
			return base64_encode( openssl_encrypt( $plainText, $method, $key, OPENSSL_RAW_DATA, $iv ) );
		}
		private function decrypt($encrypted,$password='') {
			if(empty($password)){
				$password=$this->key;
			}
			$method = 'aes-256-cbc';
			$key = substr( hash( 'sha256', $password, true ), 0, 32 );
			$iv = substr(strtoupper(md5($password)),0,16);
			$plaintext=openssl_decrypt( base64_decode( $encrypted ), $method, $key, OPENSSL_RAW_DATA, $iv );
			return substr($plaintext,2,-2);
		}

		function encrypt_obj( $obj ) {
			$text = serialize( $obj );

			return $this->encrypt( $text );
		}

		private function decrypt_obj( $ciphertext ) {
			$text = $this->decrypt( $ciphertext );

			return unserialize( $text );
		}

		
		private function get_domain() {
			if ( defined( 'WPINC' ) && function_exists( 'get_bloginfo' ) ) {
				$server_name = get_bloginfo( 'url' );
				$domain      = $this->get_domains( $server_name );
				return $domain;
			} else {
				$base_url  = ( ( isset( $_SERVER['HTTPS'] ) && $_SERVER['HTTPS'] == 'on' ) ? 'https' : 'http' );
				$base_url .= '://' . $_SERVER['HTTP_HOST'];
				$base_url .= str_replace( basename( $_SERVER['SCRIPT_NAME'] ), '', $_SERVER['SCRIPT_NAME'] );

				return $base_url;
			}
		}
		private function get_domains( $url ) {
			$pieces = parse_url( $url );
			$domain = isset( $pieces['host'] ) ? $pieces['host'] : $pieces['path'];
			if ( preg_match( '/(?P<domain>[a-z0-9][a-z0-9\-]{1,63}\.[a-z\.]{2,6})$/i', $domain, $regs ) ) {
				return $regs['domain'];
			}
			return $domain;
		}

		private function get_eml() {
            return $this->email_address;
        }
		private function processs_response($response){
			$resbk="";
			if ( ! empty( $response ) ) {
				if ( ! empty( $this->key ) ) {
					$resbk=$response;
					$response = $this->decrypt( $response );
				}
				$response = json_decode( $response );

				if ( is_object( $response ) ) {
					return $response;
				} else {
					$response=new \stdClass();
					$response->status = false;
					$response->msg    = "Response Error, contact with the author or update the plugin or theme";
					if(!empty($bkjson)){
                        $bkjson=@json_decode($resbk);
                        if(!empty($bkjson->msg)){
                            $response->msg    = $bkjson->msg;
                        }
					}
					$response->data = NULL;
					return $response;

				}
			}
			$response=new \stdClass();
			$response->msg    = "unknown response";
			$response->status = false;
			$response->data = NULL;

			return $response;
		}
		private function _request( $relative_url, $data, &$error = '' ) {
            $response         = new \stdClass();
            $response->status = false;
            $response->msg    = "Empty Response";
            $response->is_request_error = false;
            $final_data        = json_encode( $data );
            if ( ! empty( $this->key ) ) {
                $final_data = $this->encrypt( $final_data );
            }
            $url = rtrim( $this->server_host, '/' ) . "/" . ltrim( $relative_url, '/' );
            if(function_exists('wp_remote_post')) {
                $rq_params=[
                    'method' => 'POST',
                    'sslverify' => true,
                    'timeout' => 120,
                    'redirection' => 5,
                    'httpversion' => '1.0',
                    'blocking' => true,
                    'headers' => [],
                    'body' => $final_data,
                    'cookies' => []
                ];
                $server_response = wp_remote_post($url, $rq_params);

                if (is_wp_error($server_response)) {
                    $rq_params['sslverify']=false;
                    $server_response = wp_remote_post($url, $rq_params);
                     if (is_wp_error($server_response)) {
                        $response->msg    = $server_response->get_error_message();;
                        $response->status = false;
                        $response->data = NULL;
                        $response->is_request_error = true;
                        return $response;
                    }else{
                         if(!empty($server_response['body']) && (is_array($server_response) && 200 === (int) wp_remote_retrieve_response_code( $server_response )) && $server_response['body']!="GET404" ){
                            return $this->processs_response($server_response['body']);
                        }
                    }
                } else {
                    if(!empty($server_response['body']) && (is_array($server_response) && 200 === (int) wp_remote_retrieve_response_code( $server_response )) && $server_response['body']!="GET404" ){
                        return $this->processs_response($server_response['body']);
                    }
                }

            }
            if(!extension_loaded('curl')){
                $response->msg    = "Curl extension is missing";
                $response->status = false;
                $response->data = NULL;
                $response->is_request_error = true;
                return $response;
            }
            //curl when fall back
            $curlParams=[
                CURLOPT_URL            => $url,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_SSL_VERIFYPEER => true,
                CURLOPT_ENCODING       => "",
                CURLOPT_MAXREDIRS      => 10,
                CURLOPT_TIMEOUT        => 120,
                CURLOPT_CUSTOMREQUEST  => "POST",
                CURLOPT_POSTFIELDS     => $final_data,
                CURLOPT_HTTPHEADER     => array(
                    "Content-Type: text/plain",
                    "cache-control: no-cache"
                )
            ];
            $curl             = curl_init();
            curl_setopt_array( $curl, $curlParams);
            $server_response = curl_exec( $curl );
            $curlErrorNo=curl_errno($curl);
            $error = curl_error( $curl );
            curl_close( $curl );
            if (!$curlErrorNo) {
                if ( ! empty( $server_response ) ) {
                    return $this->processs_response($server_response);
                }
            }else{
                $curl  = curl_init();
                $curlParams[CURLOPT_SSL_VERIFYPEER]=false;
                $curlParams[CURLOPT_SSL_VERIFYHOST]=false;
                curl_setopt_array( $curl, $curlParams);
                $server_response = curl_exec( $curl );
                $curlErrorNo=curl_errno($curl);
                $error = curl_error( $curl );
                curl_close( $curl );
                if(!$curlErrorNo){
                    if ( ! empty( $server_response ) ) {
                        return $this->processs_response($server_response);
                    }
                }else{
                    $response->msg    = $error;
                    $response->status = false;
                    $response->data = NULL;
                    $response->is_request_error = true;
                    return $response;
                }
            }
            $response->msg    = "unknown response";
            $response->status = false;
            $response->data = NULL;
            $response->is_request_error = true;
            return $response;
        }

		private function get_param( $purchase_key, $app_version, $admin_email = '' ) {
			$req               = new \stdClass();
			$req->license_key  = $purchase_key;
			$req->email        = ! empty( $admin_email ) ? $admin_email : $this->get_eml();
			$req->domain       = $this->get_domain();
			$req->app_version  = $app_version;
			$req->product_id   = $this->product_id;
			$req->product_base = $this->product_base;

			return $req;
		}

		private function get_key_name() {
            return hash( 'crc32b', $this->get_domain() . $this->plugin_file . $this->product_id . $this->product_base . $this->key . "LIC" );
        }

        private function save_wp_response( $response ) {
            $key  = $this->get_key_name();
            $data = $this->encrypt( serialize( $response ), $this->get_domain() );
            update_option( $key, $data ) OR add_option( $key, $data );
        }

        private function get_old_wp_response() {
            $key  = $this->get_key_name();
            $response = get_option( $key, NULL );
            if ( empty( $response ) ) {
                return NULL;
            }

            return unserialize( $this->decrypt( $response, $this->get_domain() ) );
        }

		private function remove_old_wp_response() {
			$key       = $this->get_key_name();
			$isDeleted = delete_option( $key );
			foreach ( self::$_on_delete_license as $func ) {
				if ( is_callable( $func ) ) {
					call_user_func( $func );
				}
			}

			return $isDeleted;
		}
		public static function RemoveLicenseKey($plugin_base_file,&$message = "") {
			$obj=self::getInstance($plugin_base_file);
            $obj->clean_update_info();
			return $obj->_removeWPPluginLicense($message);
		}
		public static function CheckWPPlugin($purchase_key, $email,&$error = "", &$response_obj = null,$plugin_base_file="") {
			$obj=self::getInstance($plugin_base_file);
			$obj->set_email_address($email);
			return $obj->_check_wp_plugin($purchase_key, $error, $response_obj);
		}
		final function _removeWPPluginLicense(&$message=''){
			$oldRespons=$this->get_old_wp_response();
			if(!empty($oldRespons->is_valid)) {
				if ( ! empty( $oldRespons->license_key ) ) {
					$param    = $this->get_param( $oldRespons->license_key, $this->version );
					$response = $this->_request( 'product/deactive/'.$this->product_id, $param, $message );
					if ( empty( $response->code ) ) {
						if ( ! empty( $response->status ) ) {
							$message = $response->msg;
							$this->remove_old_wp_response();
							return true;
						}else{
							return;
						}
					}else{
						$message=$response->message;
					}
				}
			}else{
                $this->remove_old_wp_response();
				return true;
			}
			return false;

		}
		public static function GetRegisterInfo() {
			if(!empty(self::$selfobj)){
				return self::$selfobj->get_old_wp_response();
			}
			return null;

		}

		final function _check_wp_plugin( $purchase_key, &$error = "", &$response_obj = null ) {
            if(empty($purchase_key)){
                $this->remove_old_wp_response();
                $error="";
                return false;
            }
            $oldRespons=$this->get_old_wp_response();
            $isForce=false;
            if(!empty($_POST['action']) && sanitize_key($_POST['action']) == 'ccpw_refresh_license_ajax'){
				$isForce = true;
				$ajax_sent = 'yes';
				// Force refresh license verification
				$res = $this->ccpwp_verify_license( $purchase_key, $oldRespons,$ajax_sent);
				$response_obj = $this->get_old_wp_response();
				return $res;
            }
            else if(!empty($oldRespons)) {
                if ( ! empty( $oldRespons->expire_date ) && strtolower( $oldRespons->expire_date ) != 'no expiry' && strtotime( $oldRespons->expire_date ) < time() ||  ! empty( $oldRespons->support_end) && strtolower( $oldRespons->support_end ) != 'unlimited' && strtotime( $oldRespons->support_end ) < time()) {
				
					$valid = $this->ccpwp_verify_license( $purchase_key, $oldRespons,'no');
                    $response_obj = $this->get_old_wp_response();
					return $valid;
				}
                if ( ! $isForce && ! empty( $oldRespons->is_valid ) && $oldRespons->next_request > time() && ( ! empty( $oldRespons->license_key ) && $purchase_key == $oldRespons->license_key ) ) {
				
					$response_obj = clone $oldRespons;
					unset( $response_obj->next_request );
					return true;
                }
            }
        
            $param    = $this->get_param( $purchase_key, $this->version );
            $response = $this->_request( 'product/active/'.$this->product_id, $param, $error );
            $error = $this->isLicenseError($response->msg );
			if($error){
				return;
			}
            if(empty($response->is_request_error)) {
                if ( empty( $response->code ) ) {
                    if ( ! empty( $response->status ) ) {
                        if ( ! empty( $response->data ) ) {
                            $serialObj = $this->decrypt( $response->data, $param->domain );

                            $licenseObj = unserialize( $serialObj );
                            if ( $licenseObj->is_valid ) {
                                $response_obj           = new \stdClass();
                                $response_obj->is_valid = $licenseObj->is_valid;
                                if ( $licenseObj->request_duration > 0 ) {
                                    $response_obj->next_request = strtotime( "+ {$licenseObj->request_duration} hour" );
                                } else {
                                    $response_obj->next_request = time();
                                }
                                $response_obj->expire_date        = $licenseObj->expire_date;
								$response_obj->support_end        = $licenseObj->support_end;
								$response_obj->license_title      = $licenseObj->license_title;
								$response_obj->license_key        = $purchase_key;
								$response_obj->market             = $licenseObj->market;
								$response_obj->msg                = $response->msg;
								$response_obj->re_tried              = 0;
							
								$this->save_wp_response( $response_obj );
								unset( $response_obj->next_request );
								delete_transient( $this->product_base . '_up' );
								return true;
                            } else {
                                if ( $this->_check_old_tied( $oldRespons, $response_obj, $response ) ) {
                                    return true;
                                } else {
                                    $this->remove_old_wp_response();
                                    $error = ! empty( $response->msg ) ? $response->msg : "";
                                }
                            }
                        } else {

                            if ( $this->_check_old_tied( $oldRespons, $response_obj,$response ) ) {
                                return true;
                            } else {
                                    $this->remove_old_wp_response();
                                    $error = 'Invalid data';
                            }
                    }
                } else {
                         $res = $this->ccpwp_verify_license( $purchase_key, $oldRespons, 'no' );
                        if($res === 'wrong_license_status'){
                            
                            $error = $res;
                            if($error){
                                return;
                            }	
                        }
                        elseif ($res === 'domain_exceeded'){
                            $error = $res;
                            if($error){
                                return;
                            }	
                        }
                        elseif ($res === 'inactive_license'){
                            $error = $res;
                            if($error){
                                return;
                            }	
                        }
                        elseif ($res === 'refunded_license'){
                            $error = $res;
                            if($error){
                                return;
                            }	
                        }
                        elseif ($res === true) {
                            // Get the updated license info from cache after Atlt_verify_license
                            $updatedResponse = $this->get_old_wp_response();
                            if ($updatedResponse) {
                                $response_obj = clone $updatedResponse;
                                unset($response_obj->next_request);
                                if (isset($response_obj->re_tried)) {
                                    unset($response_obj->re_tried);
                                }
                            }
                        }
                        return $res;
                }
            } else {
                
                    if ( $this->_check_old_tied( $oldRespons, $response_obj, $response ) ) {

                        return true;

                    } else {
                            $this->remove_old_wp_response();
                            $error = $response->message;
                    }
                }
        } else {
        
            if ( $this->_check_old_tied( $oldRespons, $response_obj, $response ) ) {
                return true;
            } else {
                $this->remove_old_wp_response();
                $error = ! empty( $response->msg ) ? $response->msg : '';
            }
        }
        return $this->_check_old_tied( $oldRespons, $response_obj );
    }
        private function _check_old_tied(&$oldRespons,&$response_obj){
            if(!empty($oldRespons) && (empty($oldRespons->tried) || $oldRespons->tried<=2)){
                $oldRespons->next_request = strtotime("+ 1 hour");
                $oldRespons->tried=empty($oldRespons->tried)?1:($oldRespons->tried+1);
                $response_obj = clone $oldRespons;
                unset( $response_obj->next_request );
                if(isset($response_obj->tried)) {
                    unset( $response_obj->tried );
                }
                $this->save_wp_response($oldRespons);
                return true;
            }
            return false;
        }
    /**
	 * Check if the response contains a known license error.
	 *
	 * @param string $response The response string from the API.
	 * @return bool True if license error exists, false otherwise.
	 */
	private function isLicenseError( $response ) {
		if ( ! empty( $response ) ) {

			$license_errors = [
				'Invalid license code',
				'License quota has been over, you can not add more domain with this license key',
				'Your purchase key has been temporary inactivated',
				'Your key has been installed on another domain',
				'License information is invalid',
				'invalid_license_details',
				'wrong_license_status',
				'domain_exceeded',
				'Your purchase key has been refunded',
				'inactive_license',
				'refunded_license',
				'Response Error, contact with the author or update the plugin or theme'
			];

			foreach ( $license_errors as $error ) {
				if ( strpos( $response, $error ) !== false ) {
					$this->remove_old_wp_response();
					return $response;
				}
			}
		}
	}
	/**
	 * Verify license with the remote server
	 * 
	 * @param string $purchase_key The license key to verify
	 * @param object|null $oldRespons Previous response object from cache
	 * @param object|null $response Response object from previous request
	 * @param string $ajax_sent Whether this is an AJAX request ('yes' or 'null')
	 * @return bool|void Returns true if license is valid, false if invalid, void if license is inactive/revoked
	 */
	public function ccpwp_verify_license( $purchase_key, $oldRespons = null, $ajax_sent = 'no' ) {

		if(empty($purchase_key)){

			return;
		}
	
		// 1. Use cached valid response if still within the allowed window
		if($ajax_sent==='no'){
		
			if ( ! empty( $oldRespons->is_valid ) &&
					! empty( $oldRespons->next_request ) &&
					$oldRespons->next_request > time() &&
					! empty( $oldRespons->license_key ) &&
					$purchase_key === $oldRespons->license_key ) {
					
						$response_obj = clone $oldRespons;
						unset( $response_obj->next_request );
						return true;
			} 

			// 2. Block if too many failed attempts

			if ( ! empty( $oldRespons->re_tried ) && $oldRespons->re_tried >= 120 ) {

					$oldRespons->msg = 'limit_reached';

					// Save the updated object
					$this->save_wp_response( $oldRespons );
				
				return true;
			}
		}
		$param    = $this->get_param( $purchase_key, $this->version );
		// 3. Make remote API request
		$api_url = $this->server_host . 'product/v1/license-view';
		$response = wp_remote_post($api_url, [
			'headers' => [
				'Content-Type' => 'application/json',
			],
			'body' => json_encode([
				'license_key' => $purchase_key,
				'product_id' => $this->product_id,
				'param'     => $param,
			]),
		]);
		
		if ( is_wp_error( $response ) ) {

			$response_obj = new \stdClass();
			$response_obj->is_valid = false;
			$response_obj->msg = 'License server unavailable';
			$this->save_wp_response( $response_obj );
			return false;
		}
       
		// 4. Handle response from server
		$body = wp_remote_retrieve_body( $response );
		$body_data = json_decode($body);
		if($body_data && ! empty($body_data->message) && ($body_data->message == "Max domain exceeded." || $body_data->message == "Maximum domain limit reached.")){
			$error = $this->isLicenseError( 'domain_exceeded' );
			if($error){
				return $error;
			}
		}else if($body_data && ! empty($body_data->status) && $body_data->status == "I"){
			$error = $this->isLicenseError( 'inactive_license' );
			if($error){
				return $error;
			}
		}else if($body_data && ! empty($body_data->status) && $body_data->status == "R"){
			$error = $this->isLicenseError( 'refunded_license' );
			if($error){
				return $error;
			}
		}
		if (!is_wp_error($response)) {
			$body = wp_remote_retrieve_body($response);
			$data = json_decode($body, true);
		}
		// Check for API response success and data structure
		if (empty($data['success']) || empty($data['data']) || empty($data['data']['status'])) {
			$err_msg = 'invalid_license_details';
    		$error = $this->isLicenseError($err_msg);
			
			return false;
		}
		
		$max_domains = '';
		$active_domains_count = '';
		
		// Handle infinity case for max_domain
		if ( ! empty( $data['data']['max_domain'] ) ) {

				$max_domains = (int) $data['data']['max_domain'];
				$active_domains_count = ! empty( $data['data']['active_domain_count'] ) ? (int) $data['data']['active_domain_count'] : 0;

				if($max_domains  === '∞' ){

					$max_domains = ''; 
					$active_domains_count = ''; 
				}
		}
		if($data['data']['status']=='I' || $data['data']['status']=='R' || ( $max_domains !== '' && $active_domains_count > $max_domains ) ){
			$error = $this->isLicenseError('wrong_license_status' );
		   if($error){
				return $error;
		   }
			
		}else{

			$status = true;
			$current_time = new \DateTime();


			if($data['data']['has_support']=='Y'){

				$support_end_time = $data['data']['support_end_time'];
				$support_expire = new \DateTime($support_end_time);
				
				if($current_time > $support_expire){

					$status 		= "support_expired";
					$support_end 	= $support_end_time;
				}else{
					$support_end = $support_end_time;
				}

			}elseif($data['data']['has_support']=='U'){

				$support_end = 'unlimited';

			}else{
				$status 		= "support_expired";
				$support_end 	= 'no support';
			}
			if($data['data']['has_expiry']=='Y'){

				$expiry_time = $data['data']['expiry_time'];
				$expiry_date = new \DateTime($expiry_time);
				
				if ($current_time > $expiry_date) {

					$status = "license_expired";
					$expire_date = $expiry_time;

				}elseif($current_time < $expiry_date){
					
					$expire_date = $expiry_time;
				}
				
			}
			
			$response_obj = new \stdClass();
			$response_obj->is_valid     = $status;
			$response_obj->license_key  = $purchase_key;
			$response_obj->msg          = '';
			$response_obj->next_request = strtotime( '+6 hours' );
			

			// 5. Add retry counter if license is invalid
			if ($response_obj->is_valid === 'license_expired' || $response_obj->is_valid === 'support_expired'  ) {

				$response_obj->re_tried = empty( $oldRespons->re_tried ) ? 1 : ( $oldRespons->re_tried + 1 );

				if ( $response_obj->re_tried >= 120 ) {
					$response_obj->msg = 'Maximum verification attempts reached';
				}
			}

			// 6. Store additional license info
			if ( ! empty( $data['data'] ) ) {
				$response_obj->expire_date   = isset($expire_date)?$expire_date:'no expiry';
				$response_obj->support_end   = $support_end;
				$response_obj->market       = $data['data']['market'];
				$response_obj->license_title = $data['data']['license_title'];
				$response_obj->status 		= $data['data']['status'];
			}
			
			// Save response
			$this->save_wp_response( $response_obj );


			return true;
		}
		
	}

	}
}
