<?php
/**
 * Prohibit direct script loading.
 *
 * @package Convert_Plus.
 */

// Add new input type "gradient-colorpicker".
if ( function_exists( 'smile_add_input_type' ) ) {
	smile_add_input_type( 'gradient-colorpicker', 'gradient_color_picker_settings_field' );
}
add_action( 'admin_enqueue_scripts', 'framework_gradient_color_picker_admin_styles' );

/**
 * Function Name:framework_gradient_color_picker_admin_styles description.
 *
 * @param  array $hook ap page list.
 */
function framework_gradient_color_picker_admin_styles( $hook ) {
	$cp_page = strpos( $hook, CP_PLUS_SLUG );
	$data    = get_option( 'convert_plug_debug' );

	if ( false !== $cp_page && ( isset( $data['cp-dev-mode'] ) && '1' === $data['cp-dev-mode'] ) && isset( $_GET['style-view'] ) && ( 'edit' === $_GET['style-view'] || 'variant' === $_GET['style-view'] ) ) {
		wp_enqueue_script( 'smile-gd-colorpicker-script', SMILE_FRAMEWORK_URI . '/lib/fields/gradient-colorpicker/gradient-color-picker.min.js', array(), '1.0.0', true );
	}

}

/**
 * Function Name:gradient_color_picker_settings_field Function to handle new input type "gradient-colorpicker".
 *
 * @param  string $name     settings provided when using the input type "gradient-colorpicker".
 * @param  string $settings holds the default / updated value.
 * @param  string $value    html output generated by the function.
 * @return string           html output generated by the function.
 */
function gradient_color_picker_settings_field( $name, $settings, $value ) {
	$page           = isset( $_GET['page'] ) ? esc_attr( $_GET['page'] ) : '';
	$input_name     = $name;
	$type           = isset( $settings['type'] ) ? $settings['type'] : '';
	$class          = isset( $settings['class'] ) ? $settings['class'] : '';
	$prefix         = '%';
	$min            = isset( $settings['min'] ) ? $settings['min'] : '0';
	$max            = isset( $settings['max'] ) ? $settings['max'] : '200';
	$step           = isset( $settings['step'] ) ? $settings['step'] : '1';
	$suffix         = isset( $settings['suffix'] ) ? $settings['suffix'] : '%';
	$uid            = uniqid();
	$val_arr        = explode( '|', $value );
	$first_color    = isset( $val_arr[0] ) ? $val_arr[0] : '';
	$sec_color      = isset( $val_arr[1] ) ? $val_arr[1] : '';
	$first_deg      = isset( $val_arr[2] ) ? $val_arr[2] : '';
	$sec_deg        = isset( $val_arr[3] ) ? $val_arr[3] : '';
	$gradient_type  = isset( $val_arr[4] ) ? $val_arr[4] : '';
	$direction_type = isset( $val_arr[5] ) ? $val_arr[5] : '';
	$output         = '';
	$tooltipclass   = '';

	$dir_arr = array(
		'top_center'    => 'Top Center',
		'top_left'      => 'Top Left',
		'top_right'     => 'Top Right',
		'center_center' => 'Center Center',
		'center_left'   => 'Center Left',
		'center_Right'  => 'Center Right',
		'bottom_center' => 'Bottom Center',
		'bottom_left'   => 'Bottom Left',
		'bottom_right'  => 'Bottom Right',
	);
	// Apply partials.
	$partials = generate_partial_atts( $settings );

	// Gradient type.
	$output .= '<p><strong><label>Gradient Type </label></strong></p>';
	$output .= '<p><select id="smile_' . $input_name . '-type" class="cp-grad-' . $uid . ' form-control smile-input smile-select cp-gradient-type" name="' . $input_name . '-type" data-element = "' . $input_name . '">';

	if ( 'linear' === $gradient_type ) {
		$linear_selected = 'selected';
		$rad_selected    = '';
	} else {
		$rad_selected    = 'selected';
		$linear_selected = '';
	}
	$output .= '<option ' . $linear_selected . ' value="linear" >Linear</option>';
	$output .= '<option ' . $rad_selected . ' value="radial" >Radial</option>';
	$output .= '</select></p>';

	// First color.
	$output .= '<p><strong><label>First Color</label></strong></p>';
	$output .= '<p><input type="text" id="smile_' . $input_name . '_one" data-default-color="' . $first_color . '" class="cs-wp-color-picker smile-input smile-' . $type . '_one ' . $input_name . '_one ' . $type . '_one ' . $class . '" name="' . $input_name . '_one" value="' . $first_color . '"  data-element = "' . $input_name . '"/></p>';

	// Sec color.
	$output .= '<p><strong><label>Second Color</label></strong></p>';
	$output .= '<p><input type="text" id="smile_' . $input_name . '_sec" data-default-color="' . $sec_color . '" class="cs-wp-color-picker smile-input smile-' . $type . '_sec ' . $input_name . '_sec ' . $type . '_sec ' . $class . '" name="' . $input_name . '_sec" value="' . $sec_color . '"  data-element = "' . $input_name . '"/></p>';

	// Gradient Direction.
	$output .= '<p><strong><label>Gradient Direction </label></strong></p>';
	$output .= '<p><select id="smile_' . $input_name . '-direction" class="cp-grad-' . $uid . ' form-control smile-input cp-gradient-direction smile-select" name="' . $input_name . '-direction" data-element = "' . $input_name . '">';
	foreach ( $dir_arr as $title => $dir ) {

		if ( $direction_type === $dir ) {
			$selected = 'selected';
		} else {
			$selected = '';
		}

		$output .= '<option ' . $selected . ' value="' . $title . '">' . $dir . '</option>';
	}
	$output .= '</select></p>';

	// First slider.
	$grad_input = $input_name . '_' . 'start';
	$grad_type  = 'slider';
	$output    .= '<p><strong><label>Gradient Direction Start </label></strong></p>';
	$output    .= '<div class="setting-block"><div class="row">';
	$output    .= '<label class="align-right slider-label " for="' . $grad_input . '">' . $suffix . '</label>';

	$output .= '<div class="text-1 slider-input ' . $tooltipclass . '"><input id="smile_' . $grad_input . '_' . $uid . '" type="number"  step="' . $step . '" class="form-control smile-input smile-' . $grad_type . ' ' . $grad_input . ' ' . $grad_type . ' ' . $class . '" name="' . $grad_input . '" value="' . $first_deg . '" data-min="' . $min . '" data-max="' . $max . '" min="' . $min . '" max="' . $max . '" data-step="' . $step . '"  data-element = "' . $input_name . '"></div></div>';

	$output .= '<div id="slider_' . $grad_input . '_' . $uid . '" class="slider-bar large ui-slider ui-slider-horizontal ui-widget ui-widget-content ' . $grad_input . ' ' . $grad_type . ' ' . $class . '" data-element = "' . $input_name . '" ><a class="ui-slider-handle ui-state-default" href="#"></a><span class="range-quantity" ></span></div></div>';

	// second slider.
	$grad_sec_input = $input_name . '_' . 'end';
	$output        .= '<p><strong><label>Gradient Direction End </label></strong></p>';
	$output        .= '<div class="setting-block"><div class="row">';
	$output        .= '<label class="align-right slider-label " for="' . $grad_sec_input . '">' . $suffix . '</label>';

	$output .= '<div class="text-1 slider-input ' . $tooltipclass . '"><input id="smile_' . $grad_sec_input . '_' . $uid . '" type="number"  step="' . $step . '" class="form-control smile-input smile-' . $grad_type . ' ' . $grad_sec_input . ' ' . $grad_type . ' ' . $class . '" name="' . $grad_sec_input . '" value="' . $sec_deg . '" data-min="' . $min . '" data-max="' . $max . '" min="' . $min . '" max="' . $max . '" data-step="' . $step . '"  data-element = "' . $input_name . '"></div></div>';

	$output .= '<div id="slider_' . $grad_sec_input . '_' . $uid . '" class="slider-bar large ui-slider ui-slider-horizontal ui-widget ui-widget-content ' . $grad_sec_input . ' ' . $grad_type . ' ' . $class . '" data-element = "' . $input_name . '"><a class="ui-slider-handle ui-state-default" href="#"></a><span class="range-quantity" ></span></div></div>';

	$output .= '<p><input type="hidden" id="smile_' . $input_name . '_' . $uid . '" data-first-color="' . $first_color . '"  data-sec-color="' . $sec_color . '"  data-first-deg="' . $first_deg . '"  data-sec-deg="' . $sec_deg . '" data-grad-type="' . $gradient_type . '" data-grad-direction="' . $direction_type . '" class="smile-input smile-' . $type . ' ' . $input_name . ' ' . $type . ' ' . $class . '" name="' . $input_name . '" value="' . $value . '" ' . $partials . ' data-style-for = "' . $page . '" data-element = "' . $input_name . '"/></p>';

	return $output;
}
