<?php
// Add new input type "mailer"
if ( function_exists('smile_add_input_type'))
{
	smile_add_input_type('mailer' , 'mailer_settings_field' );
}

/**
* Function to handle new input type "mailer"
*
* @param $settings		- settings provided when using the input type "mailer"
* @param $value			- holds the default / updated value
* @return string/html 	- html output generated by the function
*/
function mailer_settings_field($name, $settings, $value)
{
	$input_name = $name;
	$type = isset($settings['type']) ? $settings['type'] : '';
	$class = isset($settings['class']) ? $settings['class'] : '';
	$options = get_option('smile_lists');
	
	$lists = array();
	if( !empty( $options ) ){

	    foreach( $options as $key => $list ){
	    	$provider = $list['list-provider'];
	    	// to unset deactivated / inactive mailer addons
	        if( isset( Smile_Framework::$addon_list[strtolower($provider)] ) || $provider == 'Convert Plug' ) {
		       $lists[$list['list-name']] = $key;
			}
	    }
		
		$output = '<p><select name="' . $input_name . '" id="smile_'.$input_name.'" class="form-control smile-input smile-select ' . $input_name . ' ' . $type . '">';
		foreach ( $lists as $text_val => $val ) {
			if ( is_numeric( $text_val ) && ( is_string( $val ) || is_numeric( $val ) ) ) {
				$text_val = $val;
			}
			$text_val = __( $text_val, "smile" );
			$selected = '';
			if ( $value !== '' && (string)$val === (string)$value ) {
				$selected = ' selected="selected"';
			}
			$output .= '<option class="smile_' . $val . '" value="' . $val . '"' . $selected . '>' . htmlspecialchars( $text_val ) . '</option>';
		}
		if($value == 'custom-form')
			$output .= '<option value="custom-form" selected="selected">Custom Form</option>';
		else
			$output .= '<option value="custom-form" >Custom Form</option>';

		$output .= '</select></p>';
	} else {
		$output = '<p><select name="' . $input_name . '" id="smile_'.$input_name.'" class="form-control smile-input smile-select ' . $input_name . ' ' . $type . '">';
		$output .= '<option value="custom-form" selected="selected">Custom Form</option>';
		$output .= '</select></p>';
		$output .= "<p>". __( "It seems that you don't have any campaigns yet!", "smile" ).' <a href="'.admin_url('admin.php?page=contact-manager').'" target=\"_blank\">'. __( "Click here", "smile" ) . "</a> to create a new campaign.</p>";
	}
	return $output;
}