<?php
/**
Plugin Name: Content Manager
Plugin URI: http://OTWthemes.com
Description:  Build custom responsive layouts. Insert shortcodes and sidebars anywhere. Tons of shortcodes with interface. Add left and right sidebars to your pages and layouts. Edit your content in the front-end of your site. Create and Import your own shortcodes.
Author: پرشین اسکریپت
Version: 2.17
Author URI: http://www.persianscript.ir
*/

load_plugin_textdomain('otw_cm',false,dirname(plugin_basename(__FILE__)) . '/languages/');

load_plugin_textdomain('otw-shortcode-widget',false,dirname(plugin_basename(__FILE__)) . '/languages/');

$wp_cm_tmc_items = array(
	'page'              => array( array(), __( 'Pages', 'otw_cm' ) ),
	'post'              => array( array(), __( 'Posts', 'otw_cm' ) ),
	'cpt'               => array( array(), __( 'Custom Post Types', 'otw_cm' ) )
);

$wp_cm_agm_items = array(
	'page'              => array( array(), __( 'Pages', 'otw_cm' ) ),
	'post'              => array( array(), __( 'Posts', 'otw_cm' ) ),
	'cpt'               => array( array(), __( 'Custom Post Types', 'otw_cm' ) )
);

$wp_cm_cs_items = array(
	'page'              => array( array(), __( 'Pages', 'otw_cm' ) ),
	'post'              => array( array(), __( 'Posts', 'otw_cm' ) ),
	'cpt'               => array( array(), __( 'Custom Post Types', 'otw_cm' ) )
);

$otw_import_shortcode_field_types = array(
	'text_input'        => __( 'Text field', 'otw_cm' ),
	'select'            => __( 'Dropdown', 'otw_cm' ),
	'text_area'         => __( 'Text area', 'otw_cm' ),
	'html_area'         => __( 'HTML area', 'otw_cm' ),
	'checkbox'          => __( 'Checkbox', 'otw_cm' ),
	'uploader'          => __( 'Medial upload', 'otw_cm' ),
	'color_picker'      => __( 'Color picker', 'otw_cm' )
);

$otw_cm_skins = array(

);

$otw_custom_shortcode_field_types = array(
	'h1'               => __( 'Title h1', 'otw_cm' ),
	'h2'               => __( 'Title h2', 'otw_cm' ),
	'h3'               => __( 'Title h3', 'otw_cm' ),
	'h4'               => __( 'Title h4', 'otw_cm' ),
	'h5'               => __( 'Title h5', 'otw_cm' ),
	'h6'               => __( 'Title h6', 'otw_cm' ),
	'title_icon'       => __( 'Title with icon', 'otw_cm' ),
	'text_area'        => __( 'Text area', 'otw_cm' ),
	'link'             => __( 'Link', 'otw_cm' ),
	'button'           => __( 'Button', 'otw_cm' ),
	'image_full'       => __( 'Image Full Width', 'otw_cm' ),
	'image_hfl'        => __( '1/2 Image Floating Left', 'otw_cm' ),
	'image_hfr'        => __( '1/2 Image Floating Right', 'otw_cm' ),
	'image_hl'         => __( '1/2 Image on the Left', 'otw_cm' ),
	'image_hr'         => __( '1/2 Image on the Right', 'otw_cm' ),
	'divider'          => __( 'Divider line', 'otw_cm' ),
	'divider_empty'    => __( 'Divider empty', 'otw_cm' ),
	'bg_color'         => __( 'Background color', 'otw_cm' ),
	'pattern_url'      => __( 'Pattern URL', 'otw_cm' ),
	'border'           => __( 'Border', 'otw_cm' ),
	'shadow'           => __( 'Shadow', 'otw_cm' ),
	'rounded_corners'  => __( 'Rounded corners', 'otw_cm' ),
	'css_class'        => __( 'CSS Class', 'otw_cm' )
);

$otw_cm_import_shortcodes = array();

$otw_cm_plugin_id = '42be8271f7a3cf66e7beb620347af2c8';
$otw_cm_plugin_url = plugins_url( substr( dirname( __FILE__ ), strlen( dirname( dirname( __FILE__ ) ) ) ) );
$otw_cm_css_version = '3.1';
$otw_cm_js_version = '3.1';

$otw_cm_plugin_options = get_option( 'otw_cm_plugin_options' );

//include functons
require_once( plugin_dir_path( __FILE__ ).'/include/otw_cm_functions.php' );

$otw_cm_skin = '';

$otw_cm_skins_path = plugin_dir_path( __FILE__ ).'/skins/';

$otw_cm_skins = otw_cm_load_skins( $otw_cm_skins_path );

if( isset( $otw_cm_plugin_options['otw_cm_skin'] ) && array_key_exists( $otw_cm_plugin_options['otw_cm_skin'], $otw_cm_skins ) ){
	$otw_cm_skin = $otw_cm_plugin_options['otw_cm_skin'];
}

//otw components
$otw_cm_grid_manager_component = false;
$otw_cm_grid_manager_object = false;
$otw_cm_shortcode_component = false;
$otw_cm_form_component = false;
$otw_cm_validator_component = false;
$otw_cm_content_sidebars_component = false;
$otw_cm_front_end_grid_manager_component = false;
$otw_cm_front_end_grid_manager_object = false;
$otw_cm_image_component = false;
$otw_cm_image_object = false;
$otw_cm_image_profile = false;
$otw_cm_factory_component = false;
$otw_cm_factory_object = false;


//load core component functions
@include_once( 'include/otw_components/otw_functions/otw_functions.php' );
include_once( 'include/otw_cm_custom_post_types.php' );

if( !function_exists( 'otw_register_component' ) ){
	wp_die( 'Please include otw components' );
}

otw_set_up_memory_limit( '124M' );

//register grid manager component
otw_register_component( 'otw_grid_manager', dirname( __FILE__ ).'/include/otw_components/otw_grid_manager/', $otw_cm_plugin_url.'/include/otw_components/otw_grid_manager/' );

//register front end grid manager component
otw_register_component( 'otw_front_end_grid_manager', dirname( __FILE__ ).'/include/otw_components/otw_front_end_grid_manager/', $otw_cm_plugin_url.'/include/otw_components/otw_front_end_grid_manager/' );

//register form component
otw_register_component( 'otw_form', dirname( __FILE__ ).'/include/otw_components/otw_form/', $otw_cm_plugin_url.'/include/otw_components/otw_form/' );

//register factory component
otw_register_component( 'otw_factory', dirname( __FILE__ ).'/include/otw_components/otw_factory/', $otw_cm_plugin_url.'/include/otw_components/otw_factory/' );

//register validator component
otw_register_component( 'otw_validator', dirname( __FILE__ ).'/include/otw_components/otw_validator/', $otw_cm_plugin_url.'/include/otw_components/otw_validator/' );

//register shortcode component
otw_register_component( 'otw_shortcode', dirname( __FILE__ ).'/include/otw_components/otw_shortcode/', $otw_cm_plugin_url.'/include/otw_components/otw_shortcode/' );

//register content sidebars component
otw_register_component( 'otw_content_sidebars', dirname( __FILE__ ).'/include/otw_components/otw_content_sidebars/', $otw_cm_plugin_url.'/include/otw_components/otw_content_sidebars/' );

//register image component
otw_register_component( 'otw_image', dirname( __FILE__ ).'/include/otw_components/otw_image/', '/include/otw_components/otw_image/' );

/** 
 *call init plugin function
 */
add_action('init', 'otw_cm_init' );
add_action('widgets_init', 'otw_cm_widgets_init' );
register_activation_hook( __FILE__, 'otw_cm_flush_rewrites' );
?>