var otw_custom_shortcode = null;
var otw_custom_shortcode_types = {};

jQuery(document).ready(function() {
	init_custom_shortcode_page();
});

function init_custom_shortcode_page(){
	
	otw_custom_shortcode = new otw_custom_shortcode_object();
	
};

function otw_custom_shortcode_object(){
	
	this.container = jQuery( '#otw_custom_shortcode_fields' );
	
	this.fields = new Array();
	
	this.fields_key = 0;
	
	this.load_types();
	
	this.load_from_json();
	
	this.init_controls();
};

otw_custom_shortcode_object.prototype.load_types = function(){
	
	if( jQuery( '#custom_shortcode_field_type').size() ){
		
		jQuery( '#custom_shortcode_field_type').find( 'option' ).each( function(){
			
			otw_custom_shortcode_types[ this.value ] = this.text;
		});
	};
}

otw_custom_shortcode_object.prototype.load_from_json = function(){
	
	if( jQuery( '#otw_cm_custom_shortcode_code' ).size() ){
		
		var json_code = jQuery( '#otw_cm_custom_shortcode_code' ).val();
		
		if( json_code.length ){
			
			try{
				var json_object = jQuery.parseJSON( json_code );
				
				this.fields_key = Number( json_object.fields_key );
				
				for( var json_field_key in json_object.fields ){
					
					this.fields[ json_field_key ] = new otw_custom_shortcode_field( json_object.fields[ json_field_key].type );
					
					this.fields[ json_field_key ].field_key = json_object.fields[ json_field_key ].key;
					
					this.fields[ json_field_key ].title = json_object.fields[ json_field_key].title;
					
					this.fields[ json_field_key ].description = json_object.fields[ json_field_key].description;
					
					this.container.append( this.fields[ json_field_key ].get_html_code() );
					
				};
				this.init_controls();
				
			}catch( e ){}
		};
	};
};

otw_custom_shortcode_object.prototype.save_shortcodes = function(){
	
	var shortcodes = {};
	shortcodes.fields = {};
	shortcodes.fields_key = this.fields_key;
	var shortcodes_key = 0;
	
	var fields  = this.container.find('div.custom_shortcode_field');
	
	for( var cF = 0; cF < fields.size(); cF++ ){
		
		var field_object = jQuery( fields[cF] );
		
		shortcodes.fields[ shortcodes_key ] = {};
		shortcodes.fields[ shortcodes_key ].key = field_object.find( 'input.field_key' ).val();
		shortcodes.fields[ shortcodes_key ].type = field_object.find( 'input.field_type' ).val();
		shortcodes.fields[ shortcodes_key ].title = field_object.find( 'input.field_title' ).val();
		shortcodes.fields[ shortcodes_key ].description = field_object.find( 'input.field_description' ).val();
		
		shortcodes_key++;
	}
	
	jQuery( '#otw_cm_custom_shortcode_code' ).val( JSON.stringify( shortcodes ) );
};

otw_custom_shortcode_object.prototype.init_controls = function(){
	
	with( this ){
		
		jQuery( '#add_control' ).unbind( 'click' );
		jQuery( '#add_control' ).click( function(){
			add_field( jQuery( '#custom_shortcode_field_type' ).val() );
			return false;
		} );
		
		jQuery( '#otw_custom_shortcodes_form' ).unbind( 'submit' );
		jQuery( '#otw_custom_shortcodes_form' ).submit( function( event ){
			save_shortcodes();
		} );
		
		this.container.find( 'a.remove_field' ).unbind( 'click' );
		this.container.find( 'a.remove_field' ).click( function(){
			
			jQuery( this ).parents( '.custom_shortcode_field' ).remove();
		});
		
		container.sortable( {
			opacity: 0.6,
			cursor: 'move',
			placeholder: 'custom_shortcode_field_placeholder',
			forcePlaceholderSize: true,
			handle: '.custom_shortcode_field_header',
			items: 'div.custom_shortcode_field',
			dropOnEmpty: true
		} );
	};
};
otw_custom_shortcode_object.prototype.add_field = function( field_type ){
	
	var field_key = this.fields_key;
	
	this.fields[ field_key ] = new otw_custom_shortcode_field( field_type );
	this.fields[ field_key ].field_key = field_key;
	
	this.container.append( this.fields[ field_key ].get_html_code() );
	
	this.fields_key++;
	
	this.init_controls();
};

function otw_custom_shortcode_field( field_type ){

	this.type = field_type;
	
	this.title = '';
	
	this.field_key = '';
	
	this.description = '';
};

otw_custom_shortcode_field.prototype.get_html_code = function(){

	var html = '<div class="custom_shortcode_field">';
	
	html = html + '<div class="custom_shortcode_field_header">';
	if( typeof( otw_custom_shortcode_types[ this.type ] ) == 'string' ){
		html = html + '<span>' + otw_custom_shortcode_types[ this.type ] + '</span>';
	}else{
		html = html + '<span>' + this.type + '</span>';
	}
	html = html + '<a href="javascript:;" class="remove_field"></a>';
	html = html + '</div>';
	html = html + '<div class="custom_shortcode_field_content">';
	html = html + '<input type="hidden" class="field_key" value="' + this.field_key + '"/>';
	html = html + '<p><label>Title</label><input type="text" class="field_title" value="' + this.title + '" /></p>';
	html = html + '<p><label>Description</label><input type="text" class="field_description" value="' + this.description + '" /><input type="hidden" class="field_type" value="' + this.type + '" /></p>';
	html = html + '</div>';
	html = html + '</div>';
	return html;
};