<?php
class OTW_Shortcode_WP_Embed_Content extends OTW_Shortcodes{
	
	public function __construct(){
		
		$this->has_custom_options = true;
		
		parent::__construct();
	}
	
	/**
	 * apply settings
	 */
	public function apply_settings(){
		
	}
	
	/**
	 * Shortcode admin interface
	 */
	public function build_shortcode_editor_options(){
		
		$html = '';
		
		$source = array();
		if( isset( $_POST['shortcode_object'] ) ){
			$source = $_POST['shortcode_object'];
		}
		
		$html .= OTW_Form::text_input( array( 'id' => 'otw-shortcode-element-title', 'label' => $this->get_label( 'Title' ), 'description' => $this->get_label( 'Optional title.' ), 'parse' => $source )  );
		
		$html .= OTW_Form::text_input( array( 'id' => 'otw-shortcode-element-content', 'label' => $this->get_label( 'Embed URL' ), 'description' => $this->get_label( 'URL to embed content. Supported formats: <a href="http://codex.wordpress.org/Embeds#Okay.2C_So_What_Sites_Can_I_Embed_From.3F" target="_blank">WordPress codex page</a>.' ), 'parse' => $source )  );
		
		$html .= OTW_Form::text_input( array( 'id' => 'otw-shortcode-element-width', 'label' => $this->get_label( 'Width' ), 'description' => $this->get_label( 'Optional width.' ), 'parse' => $source )  );
		
		$html .= OTW_Form::text_input( array( 'id' => 'otw-shortcode-element-height', 'label' => $this->get_label( 'Height' ), 'description' => $this->get_label( 'Optional height.' ), 'parse' => $source )  );
		
		return $html;
	}
	
	/**
	 * Shortcode admin interface custom options
	 */
	public function build_shortcode_editor_custom_options(){
		
		$html = '';
		
		$source = array();
		if( isset( $_POST['shortcode_object'] ) ){
			$source = $_POST['shortcode_object'];
		}
		
		$html .= OTW_Form::text_input( array( 'id' => 'otw-shortcode-element-css_class', 'label' => $this->get_label( 'CSS Class' ), 'description' => $this->get_label( 'If you\'d like to style this element separately enter a name here. A CSS class with this name will be available for you to style this particular element..' ), 'parse' => $source )  );
		
		return $html;
	}
	
	/** build shortcode
	 *
	 *  @param array
	 *  @return string
	 */
	public function build_shortcode_code( $attributes ){
		
		$code = '';
		
		if( !$this->has_error ){
		
			$code = '[otw_shortcode_wp_embed_content';
			
			$code .= $this->format_attribute( 'title', 'title', $attributes, false, '', true );
			
			$code .= $this->format_attribute( 'css_class', 'css_class', $attributes, false, '', true  );
			
			$code .= $this->format_attribute( 'width', 'width', $attributes, false, '', true );
			
			$code .= $this->format_attribute( 'height', 'height', $attributes, false, '', true );
			
			$code .= ']';
			
			$code .= strip_tags( $this->format_attribute( '', 'content', $attributes ) );
			
			$code .= '[/otw_shortcode_wp_embed_content]';
		}
		
		return $code;

	}
	
	/**
	 * Display shortcode
	 */
	public function display_shortcode( $attributes, $content ){
		
		global $wp_embed;
		
		$html = '<div';
		
		/*class attributes*/
		$class = '';
		
		$class .= $this->format_attribute( '', 'css_class', $attributes, false, $class );
		
		if( strlen( $class ) ){
			$html .= ' class="'.$class.'"';
		}
		/*end class attributes*/
		
		$html .= '>';
		
		if( $title = $this->format_attribute( '', 'title', $attributes, false, '' ) ){
			$html .= '<h2>'.$title.'</h2>';
		}
		
		$embed_attributes = array();
		
		if( $att_value = $this->format_attribute( '', 'width', $attributes, false, '' ) ){
			$embed_attributes['width'] = $att_value;
		}
		
		if( $att_value = $this->format_attribute( '', 'height', $attributes, false, '' ) ){
			$embed_attributes['height'] = $att_value;
		}
		
		$html .= wp_oembed_get( $content, $embed_attributes );
		
		$html .= '</div>';
		
		return $this->format_shortcode_output( $html );
	}
}
