<?php
class OTW_Shortcode_Twitter_Stream extends OTW_Shortcodes{
	
	public function __construct(){
		
		$this->has_custom_options = true;
		
		$this->preview = 'div';
		
		parent::__construct();
	}
	/**
	 * register external libs
	 */
	public function register_external_libs(){
		
		$this->add_external_lib( 'css', 'otw-shortcode', $this->component_url.'css/otw_shortcode.css', 'front', 100 );
		
	}
	/**
	 * apply settings
	 */
	public function apply_settings(){
		
		$this->settings = array(
			
			'theme' => array(
					'light'   => $this->get_label( 'light(default)' ),
					'dark'    => $this->get_label( 'dark' )
				),
			'default_theme' => 'light',
			
			'noheader' => array(
					'noheader'     => $this->get_label( 'yes' ),
					''   => $this->get_label( 'no(default)' )
				),
			'default_noheader' => '',
			
			'nofooter' => array(
					'nofooter'     => $this->get_label( 'yes' ),
					''   => $this->get_label( 'no(default)' )
				),
			'default_nofooter' => '',
			
			'noborders' => array(
					'noborders'     => $this->get_label( 'yes' ),
					''   => $this->get_label( 'no(default)' )
				),
			'default_noborders' => '',
			
			'noscrollbar' => array(
					'noscrollbar'     => $this->get_label( 'yes' ),
					''   => $this->get_label( 'no(default)' )
				),
			'default_noscrollbar' => '',
			
			'transparent' => array(
					'transparent'     => $this->get_label( 'yes' ),
					''   => $this->get_label( 'no(default)' )
				),
			'default_transparent' => '',
			
			'lang' => array(
					'en'          => $this->get_label( 'english (Default)' ),
					'fr'    => $this->get_label( 'fr' ),
					'de'   => $this->get_label( 'de' ),
					'it'   => $this->get_label( 'it' ),
					'es'   => $this->get_label( 'es' ),
					'js'   => $this->get_label( 'js' ),
					'ko'   => $this->get_label( 'ko' ),
					'ja'   => $this->get_label( 'ja' )
				),
			'default_lang' => 'en',
			
			'limit' => array(
					'1'    => $this->get_label( '1' ),
					'2'    => $this->get_label( '2' ),
					'3'    => $this->get_label( '3' ),
					'4'    => $this->get_label( '4' ),
					'5'    => $this->get_label( '5(default)' ),
					'6'    => $this->get_label( '6' ),
					'7'    => $this->get_label( '7' ),
					'8'    => $this->get_label( '8' ),
					'9'    => $this->get_label( '9' ),
					'10'   => $this->get_label( '10' ),
					'11'   => $this->get_label( '11' ),
					'12'   => $this->get_label( '12' ),
					'13'   => $this->get_label( '13' ),
					'14'   => $this->get_label( '14' ),
					'15'   => $this->get_label( '15' ),
					'16'   => $this->get_label( '16' ),
					'17'   => $this->get_label( '17' ),
					'18'   => $this->get_label( '18' ),
					'19'   => $this->get_label( '19' ),
					'20'   => $this->get_label( '20' )
				),
			'default_limit' => '5',
			
			'aria_polite' => array(
					'polite'          => $this->get_label( 'polite (Default)' ),
					'assertive'    => $this->get_label( 'assertive' )
				),
			'default_aria_polite' => 'polite',
			
			'show_replies' => array(
					'false'          => $this->get_label( 'no (Default)' ),
					'true'    => $this->get_label( 'yes' )
				),
			'default_show_replies' => 'false'
		);
	}
	
	/**
	 * Shortcode admin interface
	 */
	public function build_shortcode_editor_options(){
		
		$html = '';
		
		$source = array();
		if( isset( $_POST['shortcode_object'] ) ){
			$source = $_POST['shortcode_object'];
		}
		
		$html .= OTW_Form::text_input( array( 'id' => 'otw-shortcode-element-widget_id', 'label' => $this->get_label( 'Widget id' ), 'description' => $this->get_label( 'To create a timeline you must be signed in to twitter.com and visit the <a class="ext" href="https://twitter.com/settings/widgets" target="_blank">widgets section of your settings page.</a>' ), 'parse' => $source )  );
		
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-theme', 'label' => $this->get_label( 'Theme' ), 'description' => $this->get_label( 'The light theme is for pages that use a white or light colored background and follows the twitter.com aesthetic, while the dark theme is for pages that use a black or dark color background and looks more like Tweetdeck.' ), 'parse' => $source, 'options' => $this->settings['theme'], 'value' => $this->settings['default_theme'] )  );
		
		$html .= OTW_Form::color_picker( array( 'id' => 'otw-shortcode-element-link_color', 'label' => $this->get_label( 'Link color' ), 'description' => $this->get_label( 'Link color. Note that some icons in the widget will also appear this color.' ), 'parse' => $source )  );
		
		$html .= OTW_Form::text_input( array( 'id' => 'otw-shortcode-element-width', 'label' => $this->get_label( 'Width' ), 'description' => $this->get_label( 'Units are pixels.' ), 'parse' => $source )  );
		
		$html .= OTW_Form::text_input( array( 'id' => 'otw-shortcode-element-height', 'label' => $this->get_label( 'Height' ), 'description' => $this->get_label( 'Units are pixels.' ), 'parse' => $source )  );
		
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-noheader', 'label' => $this->get_label( 'Hide header' ), 'description' => $this->get_label( 'Hides the timeline header.' ), 'parse' => $source, 'options' => $this->settings['noheader'], 'value' => $this->settings['default_noheader'] ) );
		
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-nofooter', 'label' => $this->get_label( 'Hide footer' ), 'description' => $this->get_label( 'Hides the footer.' ), 'parse' => $source, 'options' => $this->settings['nofooter'], 'value' => $this->settings['default_nofooter'] ) );
		
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-noborders', 'label' => $this->get_label( 'Hide borders' ), 'description' => $this->get_label( 'Removes all borders within the widget (between Tweets, cards, around the widget.)' ), 'parse' => $source, 'options' => $this->settings['noborders'], 'value' => $this->settings['default_noborders'] ) );
		
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-noscrollbar', 'label' => $this->get_label( 'Hide scrollbars' ), 'description' => $this->get_label( 'Crops and hides the main timeline scrollbar, if visible.' ), 'parse' => $source, 'options' => $this->settings['noscrollbar'], 'value' => $this->settings['default_noscrollbar'] ) );
		
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-transparent', 'label' => $this->get_label( 'Transparent' ), 'description' => $this->get_label( 'Removes the background color.' ), 'parse' => $source, 'options' => $this->settings['transparent'], 'value' => $this->settings['default_transparent'] ) );
		
		$html .= OTW_Form::color_picker( array( 'id' => 'otw-shortcode-element-border_color', 'label' => $this->get_label( 'Border color' ), 'description' => $this->get_label( 'Change the border color used by the widget.' ), 'parse' => $source )  );
		
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-lang', 'label' => $this->get_label( 'Language' ), 'description' => $this->get_label( 'Select the language in which you want to display the button (English, French, German, Italian, Spanish, Korean, Japanese).' ), 'parse' => $source, 'options' => $this->settings['lang'], 'value' => $this->settings['default_lang'] ) );
		
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-limit', 'label' => $this->get_label( 'Tweet limit' ), 'description' => $this->get_label( 'Preset number of Tweets' ), 'parse' => $source, 'options' => $this->settings['limit'], 'value' => $this->settings['default_limit'] ) );
		
		$html .= OTW_Form::text_input( array( 'id' => 'otw-shortcode-element-related_users', 'label' => $this->get_label( 'Web Intent Related Users' ), 'description' => $this->get_label( 'As per the Tweet and follow buttons, you may provide a comma-separated list of user screen names as suggested followers to a user after they reply, Retweet, or favorite a Tweet in the timeline.' ), 'parse' => $source )  );
		
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-aria_polite', 'label' => $this->get_label( 'ARIA politeness.' ), 'description' => $this->get_label( 'ARIA is an accessibility system that aids people using assistive technology interacting with dynamic web content.' ), 'parse' => $source, 'options' => $this->settings['aria_polite'], 'value' => $this->settings['default_aria_polite'] ) );
		
		$html .= OTW_Form::text_input( array( 'id' => 'otw-shortcode-element-user_timeline', 'label' => $this->get_label( 'User timeline' ), 'description' => $this->get_label( 'User whose timeline you want to display.' ), 'parse' => $source )  );
		
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-show_replies', 'label' => $this->get_label( 'Show replies' ), 'description' => $this->get_label( 'Toggle the ‘Show Replies’ option on a per-timeline basis.' ), 'parse' => $source, 'options' => $this->settings['show_replies'], 'value' => $this->settings['default_show_replies'] ) );
		
		$html .= OTW_Form::text_input( array( 'id' => 'otw-shortcode-element-custom_timeline', 'label' => $this->get_label( 'Custom timeline ID' ), 'description' => $this->get_label( 'Custom timeline you want to render. Use only the integer portion of the custom timeline ID.' ), 'parse' => $source )  );
		
		$html .= OTW_Form::text_input( array( 'id' => 'otw-shortcode-element-favorites', 'label' => $this->get_label( 'Favorites' ), 'description' => $this->get_label( 'Favorites timeline you want to render.' ), 'parse' => $source )  );
		
		$html .= OTW_Form::text_input( array( 'id' => 'otw-shortcode-element-list_owner_name', 'label' => $this->get_label( 'Lists owners' ), 'description' => $this->get_label( 'To render a list, you must specify the list owner or list slug below' ), 'parse' => $source )  );
		
		$html .= OTW_Form::text_input( array( 'id' => 'otw-shortcode-element-list_slug', 'label' => $this->get_label( 'List slug' ), 'description' => $this->get_label( 'List identifier.' ), 'parse' => $source )  );
		
		return $html;
	}
	
	/**
	 * Shortcode admin interface custom options
	 */
	public function build_shortcode_editor_custom_options(){
		
		$html = '';
		
		$source = array();
		if( isset( $_POST['shortcode_object'] ) ){
			$source = $_POST['shortcode_object'];
		}
		
		$html .= OTW_Form::text_input( array( 'id' => 'otw-shortcode-element-css_class', 'label' => $this->get_label( 'CSS Class' ), 'description' => $this->get_label( 'If you\'d like to style this element separately enter a name here. A CSS class with this name will be available for you to style this particular element..' ), 'parse' => $source )  );
		
		return $html;
	}
	
	/** build shortcode
	 *
	 *  @param array
	 *  @return string
	 */
	public function build_shortcode_code( $attributes ){
		
		$code = '';
		
		if( !$this->has_error ){
		
			$code = '[otw_shortcode_twitter_stream';
			
			$code .= $this->format_attribute( 'widget_id', 'widget_id', $attributes, false, '', true );
			$code .= $this->format_attribute( 'theme', 'theme', $attributes, false, '', true );
			$code .= $this->format_attribute( 'link_color', 'link_color', $attributes, false, '', true );
			$code .= $this->format_attribute( 'width', 'width', $attributes, false, '', true );
			$code .= $this->format_attribute( 'height', 'height', $attributes, false, '', true );
			$code .= $this->format_attribute( 'noheader', 'noheader', $attributes, false, '', true );
			$code .= $this->format_attribute( 'nofooter', 'nofooter', $attributes, false, '', true );
			$code .= $this->format_attribute( 'noborders', 'noborders', $attributes, false, '', true );
			$code .= $this->format_attribute( 'noscrollbar', 'noscrollbar', $attributes, false, '', true );
			$code .= $this->format_attribute( 'transparent', 'transparent', $attributes, false, '', true );
			$code .= $this->format_attribute( 'border_color', 'border_color', $attributes, false, '', true );
			$code .= $this->format_attribute( 'lang', 'lang', $attributes, false, '', true );
			$code .= $this->format_attribute( 'limit', 'limit', $attributes, false, '', true );
			$code .= $this->format_attribute( 'related_users', 'related_users', $attributes, false, '', true );
			$code .= $this->format_attribute( 'aria_polite', 'aria_polite', $attributes, false, '', true );
			$code .= $this->format_attribute( 'user_timeline', 'user_timeline', $attributes, false, '', true );
			$code .= $this->format_attribute( 'show_replies', 'show_replies', $attributes, false, '', true );
			$code .= $this->format_attribute( 'custom_timeline', 'custom_timeline', $attributes, false, '', true );
			$code .= $this->format_attribute( 'favorites', 'favorites', $attributes, false, '', true );
			$code .= $this->format_attribute( 'list_owner_name', 'list_owner_name', $attributes, false, '', true );
			$code .= $this->format_attribute( 'list_slug', 'list_slug', $attributes, false, '', true );
			
			$code .= ']';
			
			$code .= '[/otw_shortcode_twitter_stream]';
		}
		
		return $code;

	}
	
	/**
	 * Display shortcode
	 */
	public function display_shortcode( $attributes, $content ){
		
		$html = '<div';
		
		/*class attributes*/
		$class = 'otw-widget-twitter';
		
		$class .= $this->format_attribute( '', 'css_class', $attributes, false, $class );
		
		if( strlen( $class ) ){
			$html .= ' class="'.$class.'"';
		}
		/*end class attributes*/
		
		/*style attribute*/
		$style = '';
		
		if( strlen( $style ) ){
			$html .= ' style="'.$style.'"';
		}
		
		$html .= '>';
		
		$html .= '<a class="twitter-timeline" href="https://twitter.com/twitterapi" data-widget-id="'.$this->format_attribute( '', 'widget_id', $attributes, false, '' ).'"';
		
		if( $att_value = $this->format_attribute( '', 'theme', $attributes, false, '' ) ){
			$html .= ' data-theme="'.$att_value.'"';
		}
		
		if( $att_value = $this->format_attribute( '', 'link_color', $attributes, false, '' ) ){
			$html .= ' data-link-color="'.$att_value.'"';
		}
		
		if( $att_value = $this->format_attribute( '', 'width', $attributes, false, '' ) ){
			$html .= ' width="'.$att_value.'"';
		}
		
		if( $att_value = $this->format_attribute( '', 'height', $attributes, false, '' ) ){
			$html .= ' height="'.$att_value.'"';
		}
		
		if( $att_value = $this->format_attribute( '', 'border_color', $attributes, false, '' ) ){
			$html .= ' data-border-color="'.$att_value.'"';
		}
		
		if( $att_value = $this->format_attribute( '', 'lang', $attributes, false, '' ) ){
			$html .= ' lang="'.$att_value.'"';
		}
		
		if( $att_value = $this->format_attribute( '', 'limit', $attributes, false, '' ) ){
			$html .= ' data-tweet-limit="'.$att_value.'"';
		}
		
		if( $att_value = $this->format_attribute( '', 'related_users', $attributes, false, '' ) ){
			$html .= ' data-related="'.$att_value.'"';
		}
		
		if( $att_value = $this->format_attribute( '', 'aria_polite', $attributes, false, '' ) ){
			$html .= ' data-aria-polite="'.$att_value.'"';
		}
		
		if( $att_value = $this->format_attribute( '', 'user_timeline', $attributes, false, '' ) ){
			$html .= ' data-screen-name="'.$att_value.'"';
		}
		
		if( $att_value = $this->format_attribute( '', 'show_replies', $attributes, false, '' ) ){
			$html .= ' data-show-replies="'.$att_value.'"';
		}
		
		if( $att_value = $this->format_attribute( '', 'custom_timeline', $attributes, false, '' ) ){
			$html .= ' data-custom-timeline-id="'.$att_value.'"';
		}
		
		if( $att_value = $this->format_attribute( '', 'favorites', $attributes, false, '' ) ){
			$html .= ' data-favorites-screen-name="'.$att_value.'"';
		}
		
		if( $att_value = $this->format_attribute( '', 'list_owner_name', $attributes, false, '' ) ){
			$html .= ' data-list-owner-screen-name="'.$att_value.'"';
		}
		
		if( $att_value = $this->format_attribute( '', 'list_slug', $attributes, false, '' ) ){
			$html .= ' data-list-slug="'.$att_value.'"';
		}
		
		$chrome_settings = '';
		
		$chrome_settings .= $this->format_attribute( '', 'noheader', $attributes, false, $chrome_settings );
		$chrome_settings .= $this->format_attribute( '', 'nofooter', $attributes, false, $chrome_settings );
		$chrome_settings .= $this->format_attribute( '', 'noborders', $attributes, false, $chrome_settings );
		$chrome_settings .= $this->format_attribute( '', 'noscrollbar', $attributes, false, $chrome_settings );
		$chrome_settings .= $this->format_attribute( '', 'transparent', $attributes, false, $chrome_settings );
		
		if( strlen( $chrome_settings ) ){
			$html .= ' data-chrome="'.$chrome_settings.'"';
		}
		
		$html .= '></a>';
		
		$html .= '</div>';
		
		$html .= '<script class="otw-twttr" type="text/javascript">!function(d,s,id){var js,fjs=d.getElementsByTagName(s)[0];if(!d.getElementById(id)){js=d.createElement(s);js.id=id;js.src="//platform.twitter.com/widgets.js";fjs.parentNode.insertBefore(js,fjs);}}(document,"script","twitter-wjs");</script>';
		
		return $this->format_shortcode_output( $html );
	}
}