<?php
class OTW_Shortcode_Testimonials extends OTW_Shortcodes{
	
	public function __construct(){
		
		$this->has_custom_options = true;
		
		parent::__construct();
	}
	/**
	 * register external libs
	 */
	public function register_external_libs(){
	
		$this->add_external_lib( 'css', 'otw-shortcode', $this->component_url.'css/otw_shortcode.css', 'all', 100 );
		
		$this->add_external_lib( 'js', 'otw-shortcode-core', $this->component_url.'js/otw_shortcode_core.js', 'all', 99, array( 'jquery' ) );
		$this->add_external_lib( 'js', 'otw-shortcode', $this->component_url.'js/otw_shortcode.js', 'front', 100 );
		$this->add_external_lib( 'js', 'otw-shortcode_live_preview', $this->component_url.'js/otw_shortcode_live_preview.js', 'live_preview', 200 );
	}
	/**
	 * apply settings
	 */
	public function apply_settings(){
		
		$this->settings = array(
		
			'number' => array(
				'1'           => $this->get_label( '1 Testimonial' ),
				'2'           => $this->get_label( '2 Testimonials' ),
				'3'           => $this->get_label( '3 Testimonials' ),
				'4'           => $this->get_label( '4 Testimonials' ),
				'5'           => $this->get_label( '5 Testimonials' ),
				'6'           => $this->get_label( '6 Testimonials(default)' ),
				'7'           => $this->get_label( '7 Testimonials' ),
				'8'           => $this->get_label( '8 Testimonials' ),
				'9'           => $this->get_label( '9 Testimonials' ),
				'10'          => $this->get_label( '10 Testimonials' ),
				'11'          => $this->get_label( '11 Testimonials' ),
				'12'          => $this->get_label( '12 Testimonials' )
			),
			'default_number' => 6,
			
			'size' => array(
				'1'           => $this->get_label( '1 Testimonial' ),
				'2'           => $this->get_label( '2 Testimonials(default)' ),
				'3'           => $this->get_label( '3 Testimonials' ),
				'4'           => $this->get_label( '4 Testimonials' ),
				'5'           => $this->get_label( '5 Testimonials' ),
				'6'           => $this->get_label( '6 Testimonials' ),
				'7'           => $this->get_label( '7 Testimonials' ),
				'8'           => $this->get_label( '8 Testimonials' ),
				'9'           => $this->get_label( '9 Testimonials' ),
				'10'          => $this->get_label( '10 Testimonials' ),
				'11'          => $this->get_label( '11 Testimonials' ),
				'12'          => $this->get_label( '12 Testimonials' )
			),
			'default_size' => 2
			
		);
		
	}
	
	/**
	 * Shortcode admin interface
	 */
	public function build_shortcode_editor_options(){
		
		$html = '';
		
		$source = array();
		if( isset( $_POST['shortcode_object'] ) ){
			$source = $_POST['shortcode_object'];
		}
		
		$html .= OTW_Form::text_input( array( 'id' => 'otw-shortcode-element-title', 'label' => $this->get_label( 'Title' ), 'description' => $this->get_label( 'Optional title.' ), 'parse' => $source )  );
		
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-number', 'label' => $this->get_label( 'Total number of testimonials' ), 'description' => $this->get_label( 'This is the total number of testimonials.' ), 'parse' => $source, 'options' => $this->settings['number'], 'value' => $this->settings['default_number'], 'data-reload' => '1' ) );
		
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-size', 'label' => $this->get_label( 'Number of testimonials to show' ), 'description' => $this->get_label( 'Number of testimonials to show in a slide. The rest will be available with next previous button.' ), 'parse' => $source, 'options' => $this->settings['size'], 'value' => $this->settings['default_size'] ) );
		
		$total_number = $this->settings['default_number'];
		
		if( isset( $source['otw-shortcode-element-number'] ) ){
			$total_number = $source['otw-shortcode-element-number'];
		}
		
		for( $cT = 1; $cT <= $total_number; $cT++ )
		{
			$html .= OTW_Form::text_input( array( 'id' => 'otw-shortcode-element-item_'.$cT.'_name', 'label' => $this->get_label( 'Testimonial '.$cT.' name' ), 'description' => $this->get_label( 'Enter client name.' ), 'parse' => $source )  );
			
			$html .= OTW_Form::text_input( array( 'id' => 'otw-shortcode-element-item_'.$cT.'_company', 'label' => $this->get_label( 'Testimonial '.$cT.' company' ), 'description' => $this->get_label( 'Enter company.' ), 'parse' => $source )  );
			
			$html .= OTW_Form::text_input( array( 'id' => 'otw-shortcode-element-item_'.$cT.'_company_url', 'label' => $this->get_label( 'Testimonial '.$cT.' company URL' ), 'description' => $this->get_label( 'Enter company URL.' ), 'parse' => $source )  );
			
			$html .= OTW_Form::text_area( array( 'id' => 'otw-shortcode-element-item_'.$cT.'_text', 'label' => $this->get_label( 'Testimonial '.$cT.' text' ), 'description' => $this->get_label( 'Enter testimonial text. HTML is allowed.' ), 'parse' => $source )  );
		}
		
		return $html;
	}
	
	/**
	 * Shortcode admin interface custom options
	 */
	public function build_shortcode_editor_custom_options(){
		
		$html = '';
		
		$source = array();
		if( isset( $_POST['shortcode_object'] ) ){
			$source = $_POST['shortcode_object'];
		}
		
		$html .= OTW_Form::text_input( array( 'id' => 'otw-shortcode-element-css_class', 'label' => $this->get_label( 'CSS Class' ), 'description' => $this->get_label( 'If you\'d like to style this element separately enter a name here. A CSS class with this name will be available for you to style this particular element..' ), 'parse' => $source )  );
		
		return $html;
	}
	
	/** build shortcode
	 *
	 *  @param array
	 *  @return string
	 */
	public function build_shortcode_code( $attributes ){
		
		$code = '';
		
		if( !$this->has_error ){
		
			$code = '[otw_shortcode_testimonials';
			
			$code .= $this->format_attribute( 'number', 'number', $attributes );
			
			$code .= $this->format_attribute( 'size', 'size', $attributes, false, '', true );
			
			$code .= $this->format_attribute( 'title', 'title', $attributes, false, '', true );
			
			if( $items = $this->format_attribute( '', 'number', $attributes ) ){
				
				for( $cT = 1; $cT <= $items; $cT++ ){
					
					$code .= $this->format_attribute( 'item_'.$cT.'_name', 'item_'.$cT.'_name', $attributes, false, '', true );
					
					$code .= $this->format_attribute( 'item_'.$cT.'_company', 'item_'.$cT.'_company', $attributes, false, '', true );
					
					$code .= $this->format_attribute( 'item_'.$cT.'_company_url', 'item_'.$cT.'_company_url', $attributes, false, '', true );
					
					$code .= $this->format_attribute( 'item_'.$cT.'_text', 'item_'.$cT.'_text', $attributes, false, '', true );
				}
			}
			
			$code .= $this->format_attribute( 'css_class', 'css_class', $attributes, false, '', true  );
			
			$code .= ']';
			
			$code .= '[/otw_shortcode_testimonials]';
		}
		
		return $code;

	}
	
	/**
	 * Display shortcode
	 */
	public function display_shortcode( $attributes, $content ){
		
		$html = '<div';
		
		/*class attributes*/
		$class = 'otw-sc-testimonials';
		
		$class .= $this->format_attribute( '', 'css_class', $attributes, false, $class );
		
		if( strlen( $class ) ){
			$html .= ' class="'.$class.'"';
		}
		/*end class attributes*/
		
		/*style attribute*/
		$style = '';
		
		if( strlen( $style ) ){
			$html .= ' style="'.$style.'"';
		}
		
		$html .= '>';
		
		if( $title = $this->format_attribute( '', 'title', $attributes, false, '' ) ){
			$html .= '<h3 class="widget-title">'.$title.'</h3>';
		}
		
		$html .= '<div class="control-nav">
			<div class="testimonials-prev"></div>
			<div class="testimonials-next"></div>
		</div>';
		
		if( $items = $this->format_attribute( '', 'number', $attributes, false, '' ) ){
			
			$html .= '<div class="testimonials-box">';
			$box_status = 0;
			
			for( $cT = 1; $cT <= $items; $cT++ ){
				
				if( $box_status == 0 ){
					$html .= '<div class="testimonials-slide';
					if( $cT == 1 ){
						$html .= ' active" style="display: block;">';
					}else{
						$html .= '" style="display: none;">';
					}
				}
				
				$html .= '<div class="testimonials-row">';
					
					$html .= '<div class="testimonial-client">';
					
						if( $item_name = $this->format_attribute( '', 'item_'.$cT.'_name', $attributes, false, '' ) ){
							$html .= $item_name.', ';
						}
						
						if( $item_company = $this->format_attribute( '', 'item_'.$cT.'_company', $attributes, false, '' ) ){
						
							if( $item_company_url = $this->format_attribute( '', 'item_'.$cT.'_company_url', $attributes, false, '' ) ){
								$html .= '<a href="'.$item_company_url.'">'.$item_company.'</a>';
							}else{
								$html .= $item_company;
							}
						}
					
					$html .= '</div>';
					
					$html .= '<div class="testimonial-text">';
						if( $item_text = $this->format_attribute( '', 'item_'.$cT.'_text', $attributes, false, '' ) ){
							$html .= '<p>'.nl2br( otw_htmlentities_decode( $item_text ) ).'</p>';
						}
					$html .= '</div>';
				
				$html .= '</div>';
				
				$box_status++;
				
				if( $box_status == $this->format_attribute( '', 'size', $attributes, false, '' ) ){
					$html .= '</div>';
					$box_status = 0;
				}
			}
			if( $box_status > 0 && $box_status < $this->format_attribute( '', 'size', $attributes, false, '' ) ){
				$html .= '</div>';
			}
			$html .= '</div>';
		}
		
		$html .= '</div>';
		
		return $this->format_shortcode_output( $html );
	}
}
