<?php
class OTW_Shortcode_Social_Twitter_Follow extends OTW_Shortcodes{
	
	public function __construct(){
		
		$this->has_custom_options = true;
		
		$this->preview = 'div';
		
		parent::__construct();
	}
	/**
	 * register external libs
	 */
	public function register_external_libs(){
	
		$this->add_external_lib( 'css', 'otw-shortcode', $this->component_url.'css/otw_shortcode.css', 'front', 100 );
	}
	/**
	 * apply settings
	 */
	public function apply_settings(){
		
		$this->settings = array(
			
			'lang' => array(
					'en'          => $this->get_label( 'english (Default)' ),
					'fr'    => $this->get_label( 'fr' ),
					'de'   => $this->get_label( 'de' ),
					'it'   => $this->get_label( 'it' ),
					'es'   => $this->get_label( 'es' ),
					'js'   => $this->get_label( 'js' ),
					'ko'   => $this->get_label( 'ko' ),
					'ja'   => $this->get_label( 'ja' )
				),
			'default_lang' => 'en',
			
			'size' => array(
					'medium'     => $this->get_label( 'medium(default)' ),
					'large'    => $this->get_label( 'large' )
				),
			'default_size' => 'medium',
			
			'show_screen_name' => array(
					'true'     => $this->get_label( 'true(default)' ),
					'false'    => $this->get_label( 'false' )
				),
			'default_show_screen_name' => 'true',
			
			'counter' => array(
					'true'     => $this->get_label( 'true(default)' ),
					'false'    => $this->get_label( 'false' )
				),
			'default_counter' => 'true',
			
			'opt_out' => array(
					'true'     => $this->get_label( 'true' ),
					'false'    => $this->get_label( 'false(default)' )
				),
			'default_opt_out' => 'false',
			
			'align' => array(
					''          => $this->get_label( 'none(default)' ),
					'left'    => $this->get_label( 'Left' ),
					'right'   => $this->get_label( 'Right' )
				),
			'default_align' => '',
			
			'float' => array(
					''          => $this->get_label( 'none(default)' ),
					'left'    => $this->get_label( 'Left' ),
					'right'   => $this->get_label( 'Right' )
				),
			'default_float' => ''
		);
	}
	
	/**
	 * Shortcode admin interface
	 */
	public function build_shortcode_editor_options(){
		
		$html = '';
		
		$source = array();
		if( isset( $_POST['shortcode_object'] ) ){
			$source = $_POST['shortcode_object'];
		}
		
		$html .= OTW_Form::text_input( array( 'id' => 'otw-shortcode-element-username', 'label' => $this->get_label( 'Twitter Username' ), 'description' => $this->get_label( 'Place your twitter username here. This would be http://twitter.com/otwthemes.' ), 'parse' => $source )  );
		
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-size', 'label' => $this->get_label( 'Button Size' ), 'description' => $this->get_label( 'The size of the button can render in either "medium", which is the default size, or in "large" - which is the larger button.' ), 'parse' => $source, 'options' => $this->settings['size'], 'value' => $this->settings['default_size'] ) );
		
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-show_screen_name', 'label' => $this->get_label( 'Show Screen Name' ), 'description' => $this->get_label( 'The user\'s screen name shows up by default, but you can opt not to show the screen name in the button.' ), 'parse' => $source, 'options' => $this->settings['show_screen_name'], 'value' => $this->settings['default_show_screen_name'] ) );
		
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-counter', 'label' => $this->get_label( 'Include Counter' ), 'description' => $this->get_label( 'Change the button color between the default blue and a grey option.' ), 'parse' => $source, 'options' => $this->settings['counter'], 'value' => $this->settings['default_counter'] ) );
		
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-lang', 'label' => $this->get_label( 'Language' ), 'description' => $this->get_label( 'Select the language in which you want to display the button (English, French, German, Italian, Spanish, Korean, Japanese).' ), 'parse' => $source, 'options' => $this->settings['lang'], 'value' => $this->settings['default_lang'] ) );
		
		$html .= OTW_Form::text_input( array( 'id' => 'otw-shortcode-element-width', 'label' => $this->get_label( 'Width' ), 'description' => $this->get_label( 'An optional width, in percentage (50%50px) format.' ), 'parse' => $source )  );
		
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-align', 'label' => $this->get_label( 'Align' ), 'description' => $this->get_label( 'Used in conjunction with \'width\' to align the button within the shortcode container DIV tag.' ), 'parse' => $source, 'options' => $this->settings['align'], 'value' => $this->settings['default_align'] ) );
		
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-opt_out', 'label' => $this->get_label( 'Opt-out of tailoring Twitter' ), 'description' => $this->get_label( 'Twitter buttons on your site can help us tailor content and suggestions for Twitter users.' ), 'parse' => $source, 'options' => $this->settings['opt_out'], 'value' => $this->settings['default_opt_out'] ) );
		
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-float', 'label' => $this->get_label( 'Float' ), 'description' => $this->get_label( 'Optionally float your icon to the left or right.' ), 'parse' => $source, 'options' => $this->settings['float'], 'value' => $this->settings['default_float'] ) );
		
		return $html;
	}
	
	/**
	 * Shortcode admin interface custom options
	 */
	public function build_shortcode_editor_custom_options(){
		
		$html = '';
		
		$source = array();
		if( isset( $_POST['shortcode_object'] ) ){
			$source = $_POST['shortcode_object'];
		}
		
		$html .= OTW_Form::text_input( array( 'id' => 'otw-shortcode-element-css_class', 'label' => $this->get_label( 'CSS Class' ), 'description' => $this->get_label( 'If you\'d like to style this element separately enter a name here. A CSS class with this name will be available for you to style this particular element..' ), 'parse' => $source )  );
		
		return $html;
	}
	
	/** build shortcode
	 *
	 *  @param array
	 *  @return string
	 */
	public function build_shortcode_code( $attributes ){
		
		$code = '';
		
		if( !$this->has_error ){
		
			$code = '[otw_shortcode_social_twitter_follow';
			
			$code .= $this->format_attribute( 'username', 'username', $attributes, false, '', true );
			$code .= $this->format_attribute( 'size', 'size', $attributes, false, '', true );
			$code .= $this->format_attribute( 'show_screen_name', 'show_screen_name', $attributes, false, '', true );
			$code .= $this->format_attribute( 'counter', 'counter', $attributes, false, '', true );
			$code .= $this->format_attribute( 'lang', 'lang', $attributes, false, '', true );
			$code .= $this->format_attribute( 'width', 'width', $attributes, false, '', true );
			$code .= $this->format_attribute( 'align', 'align', $attributes, false, '', true );
			$code .= $this->format_attribute( 'opt_out', 'opt_out', $attributes, false, '', true );
			$code .= $this->format_attribute( 'float', 'float', $attributes, false, '', true );
			$code .= $this->format_attribute( 'css_class', 'css_class', $attributes, false, '', true  );
			
			$code .= ']';
			
			$code .= '[/otw_shortcode_social_twitter_follow]';
		}
		
		return $code;

	}
	
	/**
	 * Display shortcode
	 */
	public function display_shortcode( $attributes, $content ){
		
		$html = '<div';
		
		/*class attributes*/
		$class = 'shortcode-twitter-follow';
		
		$class .= $this->format_attribute( '', 'css_class', $attributes, false, $class );
		
		if( strlen( $class ) ){
			$html .= ' class="'.$class.'"';
		}
		/*end class attributes*/
		
		/*style attribute*/
		$style = '';
		
		if( $float = $this->format_attribute( '', 'float', $attributes, false, '' ) ){
		
			$style = $this->append_attribute( $style, 'float: '.$float.';' );
		}
		
		if( strlen( $style ) ){
			$html .= ' style="'.$style.'"';
		}
		
		$html .= '>';
		
		$html .= '<a href="https://twitter.com/'.$this->format_attribute( '', 'username', $attributes, false, '' ).'" class="twitter-follow-button"';
		
		if( $attr_value = $this->format_attribute( '', 'opt_out', $attributes, false, '' ) ){
			$html .= ' data-dnt="'.$attr_value.'"';
		}
		
		if( $attr_value = $this->format_attribute( '', 'size', $attributes, false, '' ) ){
			$html .= ' data-size="'.$attr_value.'"';
		}
		
		if( $attr_value = $this->format_attribute( '', 'show_screen_name', $attributes, false, '' ) ){
			$html .= ' data-show-screen-name="'.$attr_value.'"';
		}
		
		if( $attr_value = $this->format_attribute( '', 'width', $attributes, false, '' ) ){
			$html .= ' data-width="'.$attr_value.'"';
		}
		
		if( $attr_value = $this->format_attribute( '', 'align', $attributes, false, '' ) ){
			$html .= ' data-align="'.$attr_value.'"';
		}
		
		if( $attr_value = $this->format_attribute( '', 'lang', $attributes, false, '' ) ){
			$html .= ' data-lang="'.$attr_value.'"';
		}
		
		if( $attr_value = $this->format_attribute( '', 'counter', $attributes, false, '' ) ){
			$html .= ' data-show-count="'.$attr_value.'"';
		}
		
		$html .= '>'.$this->get_label('Follow').' '.$this->format_attribute( '', 'username', $attributes, false, '' );
		
		$html .= '</a>';
		
		$html .= '<script>!function(d,s,id){var js,fjs=d.getElementsByTagName(s)[0];if(!d.getElementById(id)){js=d.createElement(s);js.id=id;js.src="//platform.twitter.com/widgets.js";fjs.parentNode.insertBefore(js,fjs);}}(document,"script","twitter-wjs");</script>';
		
		$html .= '</div>';
		
		return $this->format_shortcode_output( $html );
	}
}
