<?php
class OTW_Shortcode_Social_Icons extends OTW_Shortcodes{
	
	public function __construct(){
		
		$this->has_custom_options = true;
		
		parent::__construct();
	}
	/**
	 * register external libs
	 */
	public function register_external_libs(){
	
		$this->add_external_lib( 'css', 'otw-shortcode', $this->component_url.'css/otw_shortcode.css', 'all', 100 );
	
		$this->add_external_lib( 'css', 'otw-shortcode-social_foundicons', $this->component_url.'css/social_foundicons.css', 'all', 20 );
	}
	/**
	 * apply settings
	 */
	public function apply_settings(){
		
		$this->settings = array(
		
			'number' => array(
				'1'           => $this->get_label( '1 Icon' ),
				'2'           => $this->get_label( '2 Icons(default)' ),
				'3'           => $this->get_label( '3 Icons' ),
				'4'           => $this->get_label( '4 Icons' ),
				'5'           => $this->get_label( '5 Icons' ),
				'6'           => $this->get_label( '6 Icons' ),
				'7'           => $this->get_label( '7 Icons' ),
				'8'           => $this->get_label( '8 Icons' ),
				'9'           => $this->get_label( '9 Icons' ),
				'10'          => $this->get_label( '10 Icons' ),
				'11'          => $this->get_label( '11 Icons' ),
				'12'          => $this->get_label( '12 Icons' ),
				'13'          => $this->get_label( '13 Icons' ),
				'14'          => $this->get_label( '14 Icons' ),
				'15'          => $this->get_label( '15 Icons' )
				
				
			),
			'default_number' => 2,
			
			'icon_types' => array(
				
				''                                 => $this->get_label( 'none (Default)' ),
				'social foundicon-thumb-up'       => $this->get_label( 'Thumb up' ),
				'social foundicon-thumb-down'     => $this->get_label( 'Thumb down' ),
				'social foundicon-rss'            => $this->get_label( 'Rss' ),
				'social foundicon-facebook'       => $this->get_label( 'Facebook' ),
				'social foundicon-twitter'        => $this->get_label( 'Twitter' ),
				'social foundicon-pinterest'      => $this->get_label( 'Pinterest' ),
				'social foundicon-github'         => $this->get_label( 'Github' ),
				'social foundicon-path'           => $this->get_label( 'Path' ),
				'social foundicon-linkedin'       => $this->get_label( 'LinkedIn' ),
				'social foundicon-dribbble'       => $this->get_label( 'Dribbble' ),
				'social foundicon-stumble-upon'   => $this->get_label( 'Stumble upon' ),
				'social foundicon-behance'        => $this->get_label( 'Behance' ),
				'social foundicon-reddit'         => $this->get_label( 'Reddit' ),
				'social foundicon-google-plus'    => $this->get_label( 'Google plus' ),
				'social foundicon-youtube'        => $this->get_label( 'Youtube' ),
				'social foundicon-vimeo'          => $this->get_label( 'Vimeo' ),
				'social foundicon-clickr'         => $this->get_label( 'Clickr' ),
				'social foundicon-slideshare'     => $this->get_label( 'Slideshare' ),
				'social foundicon-picassa'        => $this->get_label( 'Picassa' ),
				'social foundicon-skype'          => $this->get_label( 'Skype' ),
				'social foundicon-instagram'      => $this->get_label( 'instagram' ),
				'social foundicon-foursquare'     => $this->get_label( 'Foursquare' ),
				'social foundicon-delicious'      => $this->get_label( 'Delicious' ),
				'social foundicon-chat'           => $this->get_label( 'Chat' ),
				'social foundicon-torso'          => $this->get_label( 'Torso' ),
				'social foundicon-tumblr'         => $this->get_label( 'Tumblr' ),
				'social foundicon-video-chat'     => $this->get_label( 'Video chat' ),
				'social foundicon-digg'           => $this->get_label( 'Digg' ),
				'social foundicon-wordpress'      => $this->get_label( 'Wordpress' )
			),
			'default_icon_type' => '',
			
			'icon_sizes' => array(
				''       => $this->get_label( 'Small' ),
				'medium' => $this->get_label( 'Medium' ),
				'large'  => $this->get_label( 'Large' ),
				'xlarge' => $this->get_label( 'Extra Large' )
			),
			'default_icon_size' => '',
			
			'icon_color_classes' => array(
				''                      => $this->get_label( 'none (Default)' ),
				'otw-red'                   => $this->get_label( 'Red' ),
				'otw-orange'                => $this->get_label( 'Orange' ),
				'otw-green'                 => $this->get_label( 'Green' ),
				'otw-greenish'              => $this->get_label( 'Greenish' ),
				'otw-aqua'                  => $this->get_label( 'Aqua' ),
				'otw-blue'                  => $this->get_label( 'Blue' ),
				'otw-pink'                  => $this->get_label( 'Pink' ),
				'otw-silver'                => $this->get_label( 'Silver' ),
				'otw-brown'                 => $this->get_label( 'Brown' ),
				'otw-black'                 => $this->get_label( 'Black' )
			),
			'default_icon_color_class' => ''
		);
		
	}
	
	/**
	 * Shortcode admin interface
	 */
	public function build_shortcode_editor_options(){
		
		$html = '';
		
		$source = array();
		if( isset( $_POST['shortcode_object'] ) ){
			$source = $_POST['shortcode_object'];
		}
		
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-number', 'label' => $this->get_label( 'Number' ), 'description' => $this->get_label( 'Select number of social icons.' ), 'parse' => $source, 'options' => $this->settings['number'], 'value' => $this->settings['default_number'], 'data-reload' => '1' ) );
	
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-icon_size', 'label' => $this->get_label( 'Icon size' ), 'description' => $this->get_label( 'The size of the icon.' ), 'parse' => $source, 'options' => $this->settings['icon_sizes'], 'value' => $this->settings['default_icon_size'] )  );
		
		$total_items = $this->settings['default_number'];
		
		if( isset( $source['otw-shortcode-element-number'] ) ){
			$total_items = $source['otw-shortcode-element-number'];
		}
		
		for( $cT = 1; $cT <= $total_items; $cT++ )
		{
			$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-icon_'.$cT.'_type', 'label' => $this->get_label( 'Icon '.$cT.' type' ), 'description' => $this->get_label( 'The icons here are based on foundation icon fonts.' ), 'parse' => $source, 'options' => $this->settings['icon_types'], 'value' => $this->settings['default_icon_type'] )  );
			
			$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-icon_'.$cT.'_color_class', 'label' => $this->get_label( 'Icon '.$cT.' color' ), 'description' => $this->get_label( 'The color for the icon.' ), 'parse' => $source, 'options' => $this->settings['icon_color_classes'], 'value' => $this->settings['default_icon_color_class'] )  );
			
			$html .= OTW_Form::color_picker( array( 'id' => 'otw-shortcode-element-icon_'.$cT.'_color', 'label' => $this->get_label( 'Icon '.$cT.' Custom Color' ), 'description' => $this->get_label( 'The custom color for the icon.' ), 'parse' => $source )  );
			
			$html .= OTW_Form::text_input( array( 'id' => 'otw-shortcode-element-icon_'.$cT.'_link', 'label' => $this->get_label( 'Icon '.$cT.' link' ), 'description' => $this->get_label( 'The link to this icon’s social network.' ), 'parse' => $source )  );
		}
		
		return $html;
	}
	
	/**
	 * Shortcode admin interface custom options
	 */
	public function build_shortcode_editor_custom_options(){
		
		$html = '';
		
		$source = array();
		if( isset( $_POST['shortcode_object'] ) ){
			$source = $_POST['shortcode_object'];
		}
		
		$html .= OTW_Form::text_input( array( 'id' => 'otw-shortcode-element-css_class', 'label' => $this->get_label( 'CSS Class' ), 'description' => $this->get_label( 'If you\'d like to style this element separately enter a name here. A CSS class with this name will be available for you to style this particular element..' ), 'parse' => $source )  );
		
		return $html;
	}
	
	/** build shortcode
	 *
	 *  @param array
	 *  @return string
	 */
	public function build_shortcode_code( $attributes ){
		
		$code = '';
		
		if( !$this->has_error ){
		
			$code = '[otw_shortcode_social_icons';
			
			$code .= $this->format_attribute( 'number', 'number', $attributes );
			
			$code .= $this->format_attribute( 'icon_size', 'icon_size', $attributes );
			
			if( $items = $this->format_attribute( '', 'number', $attributes ) ){
				
				for( $cT = 1; $cT <= $items; $cT++ ){
					
					$code .= $this->format_attribute( 'icon_'.$cT.'_type', 'icon_'.$cT.'_type', $attributes, false, '', true );
					
					$code .= $this->format_attribute( 'icon_'.$cT.'_color_class', 'icon_'.$cT.'_color_class', $attributes, false, '', true );
					
					$code .= $this->format_attribute( 'icon_'.$cT.'_color', 'icon_'.$cT.'_color', $attributes, false, '', true );
					
					$code .= $this->format_attribute( 'icon_'.$cT.'_link', 'icon_'.$cT.'_link', $attributes, false, '', true );
				}
			}
			
			$code .= $this->format_attribute( 'css_class', 'css_class', $attributes, false, '', true  );
			
			$code .= ']';
			
			$code .= '[/otw_shortcode_social_icons]';
		}
		
		return $code;

	}
	
	/**
	 * Display shortcode
	 */
	public function display_shortcode( $attributes, $content ){
		
		$html = '<div';
		
		/*class attributes*/
		$class = 'otw-sc-social-icons';
		
		$class .= $this->format_attribute( '', 'icon_size', $attributes, false, $class );
		
		$class .= $this->format_attribute( '', 'css_class', $attributes, false, $class );
		
		if( strlen( $class ) ){
			$html .= ' class="'.$class.'"';
		}
		/*end class attributes*/
		
		/*style attribute*/
		$style = '';
		
		if( strlen( $style ) ){
			$html .= ' style="'.$style.'"';
		}
		$html .= '>';
		
		$html .= '<ul';
		
		$html .= '>';
		
		if( $items = $this->format_attribute( '', 'number', $attributes, false, '' ) ){
		
			for( $cI = 1; $cI <= $items; $cI++ ){
				
				$has_link = $this->format_attribute( '', 'icon_'.$cI.'_link', $attributes, false, '' );
				
				$html .= '<li';
				
				$li_class = '';
				
				if( $icon_color_class = $this->format_attribute( '', 'icon_'.$cI.'_color_class', $attributes, false, '' ) ){
				
					if( $has_link ){
						$li_class .= $icon_color_class.'-link';
					}else{
						$li_class .= $icon_color_class.'-text';
					}
				
				}
				
				if( strlen( $li_class ) ){
					$html .= ' class="'.$li_class.'"';
				}
				
				$html .= '>';
				
				
				if( $has_link ){
					$html .= '<a href="'.$has_link.'">';
				}
				
				$html .= '<i';
				
				$icon_class = '';
				
				$icon_class .= $this->format_attribute( '', 'icon_'.$cI.'_type', $attributes, false, $icon_class );
				
				if( strlen( $icon_class ) ){
					$html .= ' class="'.$icon_class.'"';
				}
				
				$icon_style = '';
				
				if( $icon_color = $this->format_attribute( '', 'icon_'.$cI.'_color', $attributes, false, '' ) ){
					$icon_style = $this->append_attribute( $icon_style, 'color: '.$icon_color.' !important;' );
				}
				
				if( strlen( $icon_style ) ){
					$html .= ' style="'.$icon_style.'"';
				}
				
				
				$html .= '>';
				
				$html .= '</i>';
				
				if( $has_link ){
					$html .= '</a>';
				}
				
				$html .= '</li>';
			}
		}
		
		$html .= '</ul>';
		
		$html .= '</div>';
		
		return $this->format_shortcode_output( $html );
	}
}
