<?php
class OTW_Shortcode_Scroll_To_Top extends OTW_Shortcodes{
	
	public function __construct(){
		
		$this->has_custom_options = true;
		
		parent::__construct();
	}
	/**
	 * register external libs
	 */
	public function register_external_libs(){
	
		$this->add_external_lib( 'css', 'otw-shortcode', $this->component_url.'css/otw_shortcode.css', 'all', 100 );
	}
	
	/**
	 * apply settings
	 */
	public function apply_settings(){
		
		$this->settings = array(
			
			'default_margin_top_bottom' => '50',
			
			'text_position' => array(
				'left'    => $this->get_label( 'left' ),
				'center'  => $this->get_label( 'center(default)' ),
				'right'   => $this->get_label( 'right' )
			),
			'default_text_position' => 'center'
			
		);
		
	}
	
	/**
	 * Shortcode admin interface
	 */
	public function build_shortcode_editor_options(){
		
		$html = '';
		
		$source = array();
		if( isset( $_POST['shortcode_object'] ) ){
			$source = $_POST['shortcode_object'];
		}
		
		$html .= OTW_Form::text_input( array( 'id' => 'otw-shortcode-element-margin_top_bottom', 'label' => $this->get_label( 'Margin top and Bottom' ), 'description' => $this->get_label( 'Set the top and bottom margin in pixels. Default is 50px.' ), 'parse' => $source, 'value' => $this->settings['default_margin_top_bottom'] ) );
		
		$html .= OTW_Form::text_input( array( 'id' => 'otw-shortcode-element-link_text', 'label' => $this->get_label( 'Top Button Text' ), 'description' => $this->get_label( 'The text for the top button. Default is "Top".' ), 'parse' => $source ) );
		
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-text_position', 'label' => $this->get_label( 'Top Button Position' ), 'description' => $this->get_label( 'The position for the top button.' ), 'parse' => $source, 'options' => $this->settings['text_position'], 'value' => $this->settings['default_text_position'] ) );
		
		return $html;
	}
	
	/**
	 * Shortcode admin interface custom options
	 */
	public function build_shortcode_editor_custom_options(){
		
		$html = '';
		
		$source = array();
		if( isset( $_POST['shortcode_object'] ) ){
			$source = $_POST['shortcode_object'];
		}
		
		$html .= OTW_Form::text_input( array( 'id' => 'otw-shortcode-element-css_class', 'label' => $this->get_label( 'CSS Class' ), 'description' => $this->get_label( 'If you\'d like to style this element separately enter a name here. A CSS class with this name will be available for you to style this particular element..' ), 'parse' => $source )  );
		
		return $html;
	}
	
	/** build shortcode
	 *
	 *  @param array
	 *  @return string
	 */
	public function build_shortcode_code( $attributes ){
		
		$code = '';
		
		if( !$this->has_error ){
		
			$code = '[otw_shortcode_scroll_to_top';
			
			$code .= $this->format_attribute( 'margin_top_bottom', 'margin_top_bottom', $attributes, false, '', true );
			
			$code .= $this->format_attribute( 'link_text', 'link_text', $attributes, false, '', true );
			
			$code .= $this->format_attribute( 'text_position', 'text_position', $attributes );
			
			$code .= $this->format_attribute( 'css_class', 'css_class', $attributes, false, '', true  );
			
			$code .= ']';
			
			$code .= '[/otw_shortcode_scroll_to_top]';
		
		}
		
		return $code;

	}
	
	/**
	 * Display shortcode
	 */
	public function display_shortcode( $attributes, $content ){
		
		$html = '<div';
		
		/*class attributes*/
		$class = 'otw-sc-divider scroll-top';
		
		$class .= $this->format_attribute( '', 'css_class', $attributes, false, $class );
		
		if( strlen( $class ) ){
			$html .= ' class="'.$class.'"';
		}
		/*end class attributes*/
		
		/*style attribute*/
		$style = '';
		
		if( $margin_top_bottom = $this->format_attribute( '', 'margin_top_bottom', $attributes, false, '' ) ){
			
			$style = $this->append_attribute( $style, 'margin-top: '.$margin_top_bottom.'px; margin-bottom: '.$margin_top_bottom.'px;' );
		}
		
		if( strlen( $style ) ){
			$html .= ' style="'.$style.'"';
		}
		
		$html .= '>';
		
		$link_text = $this->get_label( 'Top' );
		
		if( $link_text_att = $this->format_attribute( '', 'link_text', $attributes, false, '' ) ){
			$link_text = $link_text_att;
		}
		
		$dot_class = 'dot';
		
		$dot_class .= $this->format_attribute( '', 'text_position', $attributes, false, $dot_class );
		
		$html .= '<a class="'.$dot_class.'" href="#top">'.$link_text.'</a>';
		
		$html .= '</div>';
		
		return $this->format_shortcode_output( $html );
	}
}
?>
