<?php

/**
 * @author Станимир | OTW Design
 * @ver 1.0
 */
class Otw_Shortcode_Promotion extends OTW_Shortcodes {

    function __construct() {
        parent::__construct();
        $this->has_custom_options = true;
    }

    /**
     * Register externel lybs 
     */
    function register_external_libs() {
        $this->add_external_lib('css', 'otw-shortcode-general_foundicons', $this->component_url . 'css/general_foundicons.css', 'all', 10);
        $this->add_external_lib('css', 'otw-shortcode-social_foundicons', $this->component_url . 'css/social_foundicons.css', 'all', 20);
        $this->add_external_lib('css', 'otw-shortcode', $this->component_url . 'css/otw_shortcode.css', 'all', 30);
        $this->add_external_lib('css', 'otw-grid', $this->component_url . '../' . 'otw_grid_manager/' . 'css/otw-grid.css', 'all', 100);
        $this->add_external_lib('css', 'otw-shortcode_scrolling', $this->component_url . 'css/scroll_for_preview.css?' . md5(time()), 'all', 130);
        return $this;
    }

    /**
     * Applay all settings to shortcode
     */
    public function apply_settings() {
        $this->_applyBoxAnimations();
        $this->_applyBoxBackgroundPattern();
        $this->_applyBoxBackgrounds();
        $this->_applyBoxBorderColors();
        $this->_applyBoxBorderStyle();
        $this->_applyBoxBorderType();
        $this->_applyBoxBorderWidth();
        $this->_applyBoxRoundedCourners();
        $this->_applyBoxShadow();
        $this->_applyBoxType();
        $this->_applyCallActions();
        $this->_applyImagePossition();
        $this->_applyButtonBackgrounds();
        $this->_applyContentLinkColor();
        $this->_applyContentColor();
        $this->_applyContentTitleColor();
        $this->_applyContentSubtitleColor();
        $this->_applyContentType();
        $this->_applyNumItems();
        $this->_applyImagePossition();
    }

    /**
     * Set the settings for content color
     */
    private function _applyContentColor() {
        $this->settings['content_color'] = $this->getColors();
        $this->settings['default_content_color'] = '';
    }

    /**
     * Set the settings for content color
     */
    private function _applyContentTitleColor() {
        $this->settings['title_color'] = $this->getColors();
        $this->settings['default_title_color'] = '';
    }

    /**
     * Set the settings for content color
     */
    private function _applyContentSubtitleColor() {
        $this->settings['subtitle_color'] = $this->getColors();
        $this->settings['default_subtitle_color'] = '';
    }

    /**
     * Get all image possitions 
     * @return array
     */
    public function getImagePossition() {
        return array(
            'top' => $this->get_label('Top(Default)'),
            'right' => $this->get_label('Right'),
            'bottom' => $this->get_label('Bottom'),
            'left' => $this->get_label('Left'),
        );
    }

    public function getContentType() {
        return array(
            'text' => $this->get_label('Text(Default)'),
            'list' => $this->get_label('List'),
        );
    }

    private function _applyContentType() {
        $this->settings['content_type'] = $this->getContentType();
        $this->settings['default_content_type'] = 'text';
    }

    /**
     * Apply the settings for num items 
     */
    private function _applyNumItems() {
        $this->settings['num_items'] = $this->_getNumItems();
        $this->settings['default_num_items'] = 2;
    }

    /**
     * Settings for num items 
     * @return void
     */
    private function _getNumItems() {
        return array(
            '1' => $this->get_label('1 Items'),
            '2' => $this->get_label('2 Items(default)'),
            '3' => $this->get_label('3 Items'),
            '4' => $this->get_label('4 Items'),
            '5' => $this->get_label('5 Items'),
            '6' => $this->get_label('6 Items'),
            '7' => $this->get_label('7 Items'),
            '8' => $this->get_label('8 Items'),
            '9' => $this->get_label('9 Items'),
            '10' => $this->get_label('10 Items')
        );
    }

    /**
     * Set all possitions for dropdowns settings
     * @return \OTW_ShortCode_Animatedimg
     */
    function _applyImagePossition() {
        $this->settings['imgpossition'] = $this->getImagePossition();
        $this->settings['default_imgpossition'] = 'top';
        return $this;
    }

    /**
     * Set dropdown settings for "Call Actions"
     * @return \Otw_Shortcode_Info_List
     */
    protected function _applyCallActions() {
        $this->settings['call_to_action'] = array(
            'none' => $this->get_label('None'),
            '' => $this->get_label('Text Link(default)'),
            'otw-button' => $this->get_label('Button'),
        );
        $this->settings['default_call_to_action'] = 'none';
        return $this;
    }

    /**
     * Set dropdown settings for "Box Animations"
     * @return \Otw_Shortcode_Info_List
     */
    protected function _applyBoxAnimations() {
        $this->settings['box_animations'] = $this->getAnimations();
        $this->settings['default_box_animations'] = '';
        return $this;
    }

    /**
     * Get All allowed animations
     * @return array
     */
    public function getAnimations() {
        return array(
            '' => $this->get_label('None(Default)'),
            'animated-b animated-b-rotate' => $this->get_label('Rotate'),
            'animated-b animated-b-bounce' => $this->get_label('Bounce'),
            'animated-b animated-b-wobble' => $this->get_label('Wobble'),
            'animated-b animated-b-rubberBand' => $this->get_label('RubberBand'),
            'animated-b animated-b-swing' => $this->get_label('Swing'),
            'animated-b animated-b-tada' => $this->get_label('Tada'),
            'animated-b animated-b-rubberBand' => $this->get_label('RubberBand')
        );
    }

    /**
     * 
     * @param type $attributes
     * @return string
     */
    public function build_shortcode_code($attributes) {
        $code = '';

        if (!$this->has_error) {
            $code .= '[otw_shortcode_promotion';
            $code .= $this->format_attribute('title', 'title', $attributes);
            $code .= $this->format_attribute('title_color', 'title_color', $attributes);
            $code .= $this->format_attribute('subtitle', 'subtitle', $attributes);
            $code .= $this->format_attribute('subtitle_color', 'subtitle_color', $attributes);
            $code .= $this->format_attribute('content_type', 'content_type', $attributes);

            //Get default value for items in init time
            $content_type = $this->format_attribute('', 'content_type', $attributes);
            //check for set items
            if ($content_type == 'list') {
                $code .= $this->format_attribute('num_items', 'num_items', $attributes);
                $total_elements = $this->format_attribute('', 'num_items', $attributes);

                for ($ni = 1; $ni <= $total_elements; $ni++) {
                    $code .= $this->format_attribute('item_' . $ni . '_content', 'item_' . $ni . '_content', $attributes, false, '', true);
                }
            } else {
                $code .= $this->format_attribute('content', 'content', $attributes, false, '', true);
            }

            $code .= $this->format_attribute('content_color', 'content_color', $attributes);
            $code .= $this->format_attribute('name', 'name', $attributes);
            $code .= $this->format_attribute('call_to_action', 'call_to_action', $attributes);
            $code .= $this->format_attribute('image', 'image', $attributes);
            $code .= $this->format_attribute('imgpossition', 'imgpossition', $attributes);
            $call_to = $this->format_attribute('', 'call_to_action', $attributes);

            if ($call_to != 'none') {
                $code .= $this->format_attribute('action_text', 'action_text', $attributes);
                $code .= $this->format_attribute('href', 'href', $attributes);
                $code .= $this->format_attribute('content_link_color', 'content_link_color', $attributes);
                $code .= $this->format_attribute('content_button_background', 'content_button_background', $attributes);
            }
//            $code .= $this->format_attribute('box_brd_width', 'box_brd_width', $attributes);
            $code .= $this->format_attribute('box_brd_style', 'box_brd_style', $attributes);
            $code .= $this->format_attribute('box_brd_type', 'box_brd_type', $attributes);
            $code .= $this->format_attribute('box_brd_color', 'box_brd_color', $attributes);
            $code .= $this->format_attribute('box_shadow', 'box_shadow', $attributes);
            $code .= $this->format_attribute('box_rounded_corners', 'box_rounded_corners', $attributes);
            $code .= $this->format_attribute('box_bgr', 'box_bgr', $attributes);
            $code .= $this->format_attribute('box_bgr_pattern', 'box_bgr_pattern', $attributes);
            $code .= $this->format_attribute('box_custom_border_color', 'box_custom_border_color', $attributes);
            $code .= $this->format_attribute('box_custom_bgr_color', 'box_custom_bgr_color', $attributes);
            $code .= $this->format_attribute('box_custom_bgr_pattern', 'box_custom_bgr_pattern', $attributes);
            $code .= $this->format_attribute('custom_class', 'custom_class', $attributes);
            $code .= $this->format_attribute('box_custom_border_color', 'box_custom_border_color', $attributes);
            $code .= $this->format_attribute('box_custom_bgr_color', 'box_custom_bgr_color', $attributes);
            $code .= $this->format_attribute('box_custom_bgr_pattern', 'box_custom_bgr_pattern', $attributes);
            $code .= ']';
            $code .= '[/otw_shortcode_promotion]';
        }


        return $code;
    }

    /**
     * Set the additional settings
     * @return string
     */
    public function build_shortcode_editor_custom_options() {
        $html = '';

        $source = array();
        if (isset($_POST['shortcode_object'])) {
            $source = $_POST['shortcode_object'];
        }

        $html .= $this->_generatePicker('box_custom_border_color', 'Border Color Custom', 'Choose a custom box border color.', $source);
        $html .= $this->_generatePicker('box_custom_bgr_color', 'Background Color Custom', 'Choose a custom box background color.', $source);
        $html .= $this->_generateUploader('box_custom_bgr_pattern', 'Background Pattern URL', 'URL to a custom box background pattern. ', $source);
        $html .= $this->_generateText('custom_class', 'CSS Class', 'If you\'d like to style this element separately enter a name here. A CSS class with this name will be available for you to style this particular element..', $source);

        return $html;
    }

    /**
     * Generate options as HTML string 
     * @return string
     */
    public function build_shortcode_editor_options() {
        $html = '';

        $source = array();
        if (isset($_POST['shortcode_object'])) {
            $source = $_POST['shortcode_object'];
        }

        $html .= $this->_generateText('title', 'Title', 'Enter title.', $source);
        $html .= $this->_generateSelect('title_color', 'Title Color', 'Choose title color', $source, 'title_color', 'default_title_color');
        $html .= $this->_generateText('subtitle', 'Sub Title', 'Enter sub title.', $source);
        $html .= $this->_generateSelect('subtitle_color', 'Sub Title color', 'Choose sub title color', $source, 'subtitle_color', 'default_subtitle_color');
        $html .= $this->_generateSelect('content_type', 'Content Type', 'Choose content type.', $source, 'content_type', 'default_content_type', 1);

        //Get default value for items in init time
        $content_type = $this->settings['default_content_type'];
        //check for set items
        if (isset($source['otw-shortcode-element-content_type'])) {
            $content_type = $source['otw-shortcode-element-content_type'];
        }
        if ($content_type == 'list') {
            $html .= $this->_generateSelect('num_items', 'Number of items', 'Choose the item for animation.', $source, 'num_items', 'default_num_items', 1);

            //Get default value for items in init time
            $total_elements = $this->settings['default_num_items'];
            //check for set items
            if (isset($source['otw-shortcode-element-num_items'])) {
                $total_elements = $source['otw-shortcode-element-num_items'];
            }
            /* @var $ni int Iterate the lists */
            for ($ni = 1; $ni <= $total_elements; $ni++) {
                $html .= $this->_generateText('item_' . $ni . '_content', 'Item ' . $ni . ' - Content', 'Set up your content', $source);
            }
        } else {
            $html .= $this->_generateTextArea('content', 'Content', 'The content text. HTML is allowed.', $source);
        }
        $html .= $this->_generateSelect('content_color', 'Conetnt Color', 'Choose content color', $source, 'content_color', 'default_content_color');
        $html .= $this->_generateSelect('call_to_action', 'Call to Action', 'Choose the type of the call to action.', $source, 'call_to_action', 'default_call_to_action', 1);
        if (isset($source['otw-shortcode-element-call_to_action']) && trim($source['otw-shortcode-element-call_to_action']) != 'none') {
            $html .= $this->_generateText('action_text', 'Call to Action Text', 'This is the text in the button or the text link..', $source);
            $html .= $this->_generateText('href', 'Call to Action Link ', 'The link your call to action leads to.', $source);
            $html .= $this->_generateSelect('content_link_color', 'Call to Action Text Color ', 'Choose text color.', $source, 'content_link_color', 'default_content_link_color');
            $html .= $this->_generateSelect('content_button_background', 'Call to Action Button Color', 'Choose button color.', $source, 'content_button_background', 'default_content_button_background');
        }
        $html .= $this->_generateUploader('image', 'Image', 'Upload an image.', $source);
        $html .= $this->_generateSelect('imgpossition', 'Image Position', 'Choose image position.', $source, 'imgpossition', 'default_imgpossition');
//        $html .= $this->_generateSelect('box_brd_width', 'Box Border Width', 'Choose box border width.', $source, 'box_brd_width', 'default_box_brd_width');
        $html .= $this->_generateSelect('box_brd_style', 'Box Border Style', 'Choose box border style.', $source, 'box_brd_style', 'default_box_brd_style');
        $html .= $this->_generateSelect('box_brd_type', 'Box Border Type', 'Choose box border type.', $source, 'box_brd_type', 'default_box_brd_type');
        $html .= $this->_generateSelect('box_brd_color', 'Box Border Color', 'Choose box border color.', $source, 'box_brd_color', 'default_box_brd_color');
        $html .= $this->_generateSelect('box_shadow', 'Box Shadow', 'Choose box shadow.', $source, 'box_shadow', 'default_box_shadow');
        $html .= $this->_generateSelect('box_rounded_corners', 'Box Rounded Corners', 'Choose box rounded corners.', $source, 'box_rounded_corners', 'default_box_rounded_corners');
        $html .= $this->_generateSelect('box_bgr', 'Box Background Color', 'Choose box background color.', $source, 'box_bgr', 'default_box_bgr');
        $html .= $this->_generateSelect('box_bgr_pattern', 'Box Background Pattern', 'Choose box background pattern.', $source, 'box_bgr_pattern', 'default_box_bgr_pattern');
        return $html;
    }

    /**
     * Export end shortcode
     * @param array $attributes
     * @param string $content
     * @return string
     */
    public function display_shortcode($attributes, $content) {

        $html = '';
        $master_class = '';
        $master_class = $this->append_attribute($master_class, 'otw-b-promotion');
        $master_class = $this->append_attribute($master_class, 'otw-b-promotion-padding');
//        $master_class = $this->append_attribute($master_class, $this->format_attribute('', 'box_brd_width', $attributes));
        $master_class = $this->append_attribute($master_class, $this->format_attribute('', 'box_brd_style', $attributes));
        $master_class = $this->append_attribute($master_class, $this->format_attribute('', 'box_brd_type', $attributes));
        $master_class = $this->append_attribute($master_class, $this->format_attribute('', 'box_brd_color', $attributes));
        $master_class = $this->append_attribute($master_class, $this->format_attribute('', 'box_shadow', $attributes));
        $master_class = $this->append_attribute($master_class, $this->format_attribute('', 'box_rounded_corners', $attributes));
        $master_class = $this->append_attribute($master_class, $this->format_attribute('', 'box_bgr', $attributes));
        $master_class = $this->append_attribute($master_class, $this->format_attribute('', 'box_bgr_pattern', $attributes));
        $master_class = $this->append_attribute($master_class, $this->format_attribute('', 'custom_class', $attributes));



        $style_master = '';
        if (strlen($this->format_attribute('', 'box_custom_border_color', $attributes)) > 0) {
            $style_master .= $this->append_attribute($style_master, 'border-color: ' . $this->format_attribute('', 'box_custom_border_color', $attributes) . '!important;');
        }
        if (strlen($this->format_attribute('', 'box_custom_bgr_color', $attributes)) > 0) {
            $style_master .= $this->append_attribute($style_master, 'background-color: ' . $this->format_attribute('', 'box_custom_bgr_color', $attributes) . '!important;');
        }
        if (strlen($this->format_attribute('', 'box_custom_bgr_pattern', $attributes)) > 0) {
            $style_master .= $this->append_attribute($style_master, 'background-image: url(' . $this->format_attribute('', 'box_custom_bgr_pattern', $attributes) . ')!important;');
        }

        $html .= '<div style="' . $style_master . '" class="' . $master_class . '">';

        //chose when is displayed this image
        $first_image_classes = $this->append_attribute($first_image_classes, 'otw-b-promotion-image');
        if (in_array($this->format_attribute('', 'imgpossition', $attributes), array('right', 'bottom'))) {
            $first_image_classes = $this->append_attribute($first_image_classes, 'otw-b-hide');
        }
        if ($this->format_attribute('', 'imgpossition', $attributes) == 'left') {
            $first_image_classes = $this->append_attribute($first_image_classes, ' otw-twelve otw-columns');
        }
        $html .= '<div class="' . $first_image_classes . '">';
        if (in_array($this->format_attribute('', 'imgpossition', $attributes), array('right', 'left'))) {
            $html .= '<div class="otw-row" >';
            $html .= '<img src="' . $this->format_attribute('', 'image', $attributes) . '" alt="">';
            $html .= '</div>';
        } else {
            $html .= '<img src="' . $this->format_attribute('', 'image', $attributes) . '" alt="">';
        }

        $html .= '</div>';

        if (in_array($this->format_attribute('', 'imgpossition', $attributes), array('right', 'left'))) {
            $container_class = '';
            $container_class = $this->append_attribute($container_class, ' otw-twelve otw-columns');
        }
        $html .= '<div class="otw-b-promotion-content ' . $container_class . '">';
        $title_class = $this->append_attribute($title_class, 'otw-b-promotion-title');
        $title_class = $this->append_attribute($title_class, $this->format_attribute('', 'title_color', $attributes));
        $html .= '<h2 class="' . $title_class . '">' . $this->format_attribute('', 'title', $attributes) . '</h2>';
        $subtitle_class = $this->append_attribute($subtitle_class, 'otw-b-promotion-subtitle');
        $subtitle_class = $this->append_attribute($subtitle_class, $this->format_attribute('', 'subtitle_color', $attributes));
        $html .= '<h3 class="' . $subtitle_class . '">' . $this->format_attribute('', 'subtitle', $attributes) . '</h3>';
        if ($this->format_attribute('', 'content_type', $attributes) == 'list') {
            $html .= '<ul>';
            $total_elements = $this->format_attribute('', 'num_items', $attributes);
            for ($ni = 1; $ni <= $total_elements; $ni++) {
                $html .= '<li class="' . $this->format_attribute('', 'content_color', $attributes) . '" >' . $this->format_attribute('', 'item_' . $ni . '_content', $attributes) . '</li>';
            }
            $html .= '</ul>';
        } else {
            $html .= '<p class="' . $this->format_attribute('', 'content_color', $attributes) . '" > ' .  nl2br(otw_htmlentities_decode(stripslashes($this->format_attribute('', 'content', $attributes)))) . '</p>';
        }
        $html .= '<div class="otw-b-promotion-cta">';
        $cal_to_action = $this->format_attribute('', 'call_to_action', $attributes);
        if (trim($cal_to_action) != 'none') {
            $ca_class = $this->append_attribute($ca_class, $this->format_attribute('', 'content_link_color', $attributes));
            $ca_class = $this->append_attribute($ca_class, $this->format_attribute('', 'content_button_background', $attributes));
            $ca_class = $this->append_attribute($ca_class, $cal_to_action);
            $html .= '<a href="' . $this->format_attribute('', 'href', $attributes) . '" class="' . $ca_class . '" >' . $this->format_attribute('', 'action_text', $attributes) . '</a>';
        }
        $html .= '</div>';
        $html .= '</div>';
        //chose when is displayed this image
        $second_image_classes = $this->append_attribute($second_image_classes, 'otw-b-promotion-image');
        if (in_array($this->format_attribute('', 'imgpossition', $attributes), array('left', 'top'))) {
            $second_image_classes = $this->append_attribute($second_image_classes, 'otw-b-hide');
        }
        if ($this->format_attribute('', 'imgpossition', $attributes) == 'right') {
            $second_image_classes = $this->append_attribute($second_image_classes, ' otw-twelve otw-columns');
        }
        $html .= '<div class="' . $second_image_classes . '">';
        if (in_array($this->format_attribute('', 'imgpossition', $attributes), array('right', 'left'))) {
            $html .= '<div class="otw-row" >';
            $html .= '<img src="' . $this->format_attribute('', 'image', $attributes) . '" alt="">';
            $html .= '</div>';
        } else {
            $html .= '<img src="' . $this->format_attribute('', 'image', $attributes) . '" alt="">';
        } 
        $html .= '</div>';
        $html .= ' </div>';
        return $this->format_shortcode_output($html);
    }

}
