<?php
class OTW_Shortcode_Message_Box extends OTW_Shortcodes{
	
	public function __construct(){
		
		$this->has_custom_options = true;
		
		parent::__construct();
	}
	/**
	 * register external libs
	 */
	public function register_external_libs(){
	
		$this->add_external_lib( 'css', 'otw-shortcode', $this->component_url.'css/otw_shortcode.css', 'all', 100 );
		$this->add_external_lib( 'css', 'otw-shortcode-general_foundicons', $this->component_url.'css/general_foundicons.css', 'all', 10 );
		
		$this->add_external_lib( 'js', 'otw-shortcode-core', $this->component_url.'js/otw_shortcode_core.js', 'all', 99, array( 'jquery' ) );
		$this->add_external_lib( 'js', 'otw-shortcode', $this->component_url.'js/otw_shortcode.js', 'front', 100 );
	}
	/**
	 * apply settings
	 */
	public function apply_settings(){
		
		$this->settings = array(
			
			'type' => array(
				'otw-success'  => $this->get_label( 'success' ),
				'otw-error'  => $this->get_label( 'error' ),
				'otw-warning'  => $this->get_label( 'warning' ),
				'otw-tip'  => $this->get_label( 'tip' ),
				'otw-neutral'  => $this->get_label( 'neutral' )
			),
			'default_type' => 'success',
			
			'close_button' => array(
				'closable-message'  => $this->get_label( 'yes(default)' ),
				''                  => $this->get_label( 'no' )
			),
			'default_close_button' => '',
		);
		
	}
	
	/**
	 * Shortcode admin interface
	 */
	public function build_shortcode_editor_options(){
		
		$html = '';
		
		$source = array();
		if( isset( $_POST['shortcode_object'] ) ){
			$source = $_POST['shortcode_object'];
		}
		
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-type', 'label' => $this->get_label( 'Type' ), 'description' => $this->get_label( 'Choose message type.' ), 'parse' => $source, 'options' => $this->settings['type'], 'value' => $this->settings['default_type'] ) );
		
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-close_button', 'label' => $this->get_label( 'Enable close button' ), 'description' => $this->get_label( 'Enables the close button.' ), 'parse' => $source, 'options' => $this->settings['close_button'], 'value' => $this->settings['default_close_button'] ) );
		
		$html .= OTW_Form::text_input( array( 'id' => 'otw-shortcode-element-title', 'label' => $this->get_label( 'Title' ), 'description' => $this->get_label( 'The title of your message box.' ), 'parse' => $source )  );
		
		$html .= OTW_Form::text_area( array( 'id' => 'otw-shortcode-element-content', 'label' => $this->get_label( 'Content' ), 'description' => $this->get_label( 'The content of your message box. HTML is allowed.' ), 'parse' => $source )  );
		
		
		return $html;
	}
	
	/**
	 * Shortcode admin interface custom options
	 */
	public function build_shortcode_editor_custom_options(){
		
		$html = '';
		
		$source = array();
		if( isset( $_POST['shortcode_object'] ) ){
			$source = $_POST['shortcode_object'];
		}
		
		$html .= OTW_Form::text_input( array( 'id' => 'otw-shortcode-element-css_class', 'label' => $this->get_label( 'CSS Class' ), 'description' => $this->get_label( 'If you\'d like to style this element separately enter a name here. A CSS class with this name will be available for you to style this particular element..' ), 'parse' => $source )  );
		
		return $html;
	}
	
	/** build shortcode
	 *
	 *  @param array
	 *  @return string
	 */
	public function build_shortcode_code( $attributes ){
		
		$code = '';
		
		if( !$this->has_error ){
		
			$code = '[otw_shortcode_message_box';
			
			$code .= $this->format_attribute( 'type', 'type', $attributes );
			
			$code .= $this->format_attribute( 'close_button', 'close_button', $attributes );
			
			$code .= $this->format_attribute( 'title', 'title', $attributes, false, '', true  );
			
			$code .= $this->format_attribute( 'css_class', 'css_class', $attributes, false, '', true  );
			
			$code .= ']';
			
			$code .= $attributes['content'];
			
			$code .= '[/otw_shortcode_message_box]';
		}
		
		return $code;

	}
	
	/**
	 * Display shortcode
	 */
	public function display_shortcode( $attributes, $content ){
		
		$html = '<div';
		
		/*class attributes*/
		$class = 'otw-sc-message';
		
		$class .= $this->format_attribute( '', 'type', $attributes, false, $class );
		
		$class .= $this->format_attribute( '', 'close_button', $attributes, false, $class );
		
		$class .= $this->format_attribute( '', 'css_class', $attributes, false, $class );
		
		if( strlen( $class ) ){
			$html .= ' class="'.$class.'"';
		}
		/*end class attributes*/
		
		$html .= '>';
		$html .= '<p>';
		switch( $this->format_attribute( '', 'type', $attributes, false, '' ) ){
			
			case 'otw-success':
					$html .= '<i class="general foundicon-checkmark"></i>';
				break;
			case 'otw-error':
					$html .= '<i class="general foundicon-remove"></i>';
				break;
			case 'otw-warning':
					$html .= '<i class="general foundicon-error"></i>';
				break;
			case 'otw-tip':
					$html .= '<i class="general foundicon-idea"></i>';
				break;
			case 'otw-neutral':
					$html .= '<i class="general foundicon-tools"></i>';
				break;
		
		}
		
		if( $title = $this->format_attribute( '', 'title', $attributes, false, '' ) ){
			$html .= '<strong>'.$title.'</strong> ';
		}
		
		$html .= nl2br( $content );
		
		$html .= '</p>';
		
		if( $this->format_attribute( '', 'close_button', $attributes, false, '' ) ){
			$html .= '<div class="close-message">x</div>';
		}
		$html .= '</div>';
		
		return $this->format_shortcode_output( $html );
	}
}
