<?php
class OTW_Shortcode_Import_Shortcode extends OTW_Shortcodes{
	
	/**
	 * Imported shortcode options key
	*/
	public $import_shortcodes_option = 'otw_import_shortcodes';
	
	/**
	 * saved info about the imported shortcode
	*/
	private $import_shortcode_data = array();
	
	public function __construct(){
		
		$this->has_custom_options = false;
		
		$this->has_preview = false;
		
		parent::__construct();
		
		$import_shortcodes = get_option( $this->import_shortcodes_option );
		
		if( !$this->shortcode_key ){
			
			if( isset( $_GET['shortcode'] ) ){
				
				$this->shortcode_key = $_GET['shortcode'];
			}
			
		}
		if( $this->shortcode_key ){
		
			if( preg_match( "/^import_shortcode_/", $this->shortcode_key ) ){
				$key = preg_replace( "/^import_shortcode_/", "", $this->shortcode_key );
				$this->import_shortcode_data = $import_shortcodes[ $key ];
			}
		}
	}
	
	/**
	 * Shortcode admin interface
	 */
	public function build_shortcode_editor_options(){
		
		$html = '';
		
		$source = array();
		if( isset( $_POST['shortcode_object'] ) ){
			$source = $_POST['shortcode_object'];
		}
		
		if( isset( $this->import_shortcode_data['params'] ) ){
		
			foreach( $this->import_shortcode_data['params'] as $field_key => $field_data ){
			
				switch( $field_data['type'] ){
					
					case 'text_input':
					case 'color_picker':
					case 'text_area':
					case 'html_area':
					case 'checkbox':
					case 'uploader':
							$html .= call_user_func_array( array( 'OTW_Form', $field_data['type'] ), array( array( 'id' => 'otw-shortcode-element-'.$field_key, 'label' => $field_data['name'], 'description' => $field_data['description'], 'value' => $field_data['default_value'], 'parse' => $source ) ) );
						break;
					case 'select':
							$options = array();
							
							if( isset( $field_data['options'] ) ){
								$options = $field_data['options'];
							}
							
							$html .= call_user_func_array( array( 'OTW_Form', $field_data['type'] ), array( array( 'id' => 'otw-shortcode-element-'.$field_key, 'label' => $field_data['name'], 'description' => $field_data['description'], 'value' => $field_data['default_value'], 'parse' => $source, 'options' => $options ) ) );
						break;
				}
			}
		}
		
		if( isset( $this->import_shortcode_data['content'] ) ){
			
			switch( $this->import_shortcode_data['content'] ){
				
				case 'text_input':
				case 'color_picker':
				case 'text_area':
				case 'html_area':
				case 'checkbox':
				case 'uploader':
						$html .= call_user_func_array( array( 'OTW_Form', $this->import_shortcode_data['content'] ), array( array( 'id' => 'otw-shortcode-element-otwcscontent', 'label' => $this->get_label( 'Content' ), 'description' => $this->get_label( 'The content' ), 'value' => '', 'parse' => $source ) ) );
					break;
			}
		}
		
		return $html;
	}
	
	/**
	 * Shortcode admin interface custom options
	 */
	public function build_shortcode_editor_custom_options(){
		
		$html = '';
		
		$source = array();
		if( isset( $_POST['shortcode_object'] ) ){
			$source = $_POST['shortcode_object'];
		}
		
		return $html;
	}
	
	/** build shortcode
	 *
	 *  @param array
	 *  @return string
	 */
	public function build_shortcode_code( $attributes ){
		
		$code = '';
		
		if( !$this->has_error ){
		
			$code = '[otw_shortcode_import_shortcode';
			
			//add the custom shor-tcode as key
			$code .= ' key="'.preg_replace( "/^import_shortcode_/", "", $this->shortcode_key ).'"';
			
			if( isset( $this->import_shortcode_data['params'] ) ){
				
				foreach( $this->import_shortcode_data['params'] as $field_key => $field_data ){
					$code .= $this->format_attribute( $field_key, $field_key, $attributes, false, '', true );
				}
			}
			
			$code .= ']';
			
			if( isset( $attributes['otwcscontent'] ) ){
				$code .= $attributes['otwcscontent'];
			}
			
			$code .= '[/otw_shortcode_import_shortcode]';
			
		}
		
		return $code;
	}
	
	/**
	 * Display shortcode
	 */
	public function display_shortcode( $attributes, $content ){
		
		$html = '';
		
		if( isset( $attributes['key'] ) && strlen( trim( $attributes['key'] ) ) ){
		
			$code = '['.$attributes['key'];
			
			foreach( $attributes as $a_key => $a_value ){
			
				if( $a_key != 'key' ){
					$code .= ' '.$a_key.'="'.$a_value.'"';
				}
			}
			$code .= ']';
			
			$code .= $content;
			
			$code .= '[/'.$attributes['key'].']';
			
			ob_start();
			$html .= do_shortcode( $code );
			$html .= ob_get_contents();
			ob_end_clean();
		}
		
		return $this->format_shortcode_output( $html );
	}
}
?>