<?php
class OTW_Shortcode_Highlight extends OTW_Shortcodes{
	
	public function __construct(){
		
		$this->has_custom_options = true;
		
		parent::__construct();
	}
	
	public function register_external_libs(){
		$this->add_external_lib( 'css', 'otw-shortcode', $this->component_url.'css/otw_shortcode.css', 'all', 100 );
	}
	/**
	 * apply settings
	 */
	public function apply_settings(){
	
		$this->settings = array(
		
			'types' => array(
				''            => $this->get_label( 'colored(default)' ),
				'with-border' => $this->get_label( 'underlined' )
			),
			'default_type' => '',
			
			'background_color_classes' => array(
				'otw-red'                   => $this->get_label( 'Red' ),
				'otw-orange'                => $this->get_label( 'Orange' ),
				'otw-green'                 => $this->get_label( 'Green' ),
				'otw-greenish'              => $this->get_label( 'Greenish' ),
				'otw-aqua'                  => $this->get_label( 'Aqua(default)' ),
				'otw-blue'                  => $this->get_label( 'Blue' ),
				'otw-pink'                  => $this->get_label( 'Pink' ),
				'otw-silver'                => $this->get_label( 'Silver' ),
				'otw-brown'                 => $this->get_label( 'Brown' ),
				'otw-black'                 => $this->get_label( 'Black' ),
				'otw-white'                 => $this->get_label( 'White' )
			),
			'default_background_color_class' => 'aqua',
			
			'color_classes' => array(
				''                      => $this->get_label( 'none (Default)' ),
				'otw-red-text'                   => $this->get_label( 'Red' ),
				'otw-orange-text'                => $this->get_label( 'Orange' ),
				'otw-green-text'                 => $this->get_label( 'Green' ),
				'otw-greenish-text'              => $this->get_label( 'Greenish' ),
				'otw-aqua-text'                  => $this->get_label( 'Aqua' ),
				'otw-blue-text'                  => $this->get_label( 'Blue' ),
				'otw-pink-text'                  => $this->get_label( 'Pink' ),
				'otw-silver-text'                => $this->get_label( 'Silver' ),
				'otw-brown-text'                 => $this->get_label( 'Brown' ),
				'otw-black-text'                 => $this->get_label( 'Black' )
			),
			'default_color_class' => ''
		);
		
	}
	
	/**
	 * Shortcode admin interface
	 */
	public function build_shortcode_editor_options(){
		
		$html = '';
		
		$source = array();
		if( isset( $_POST['shortcode_object'] ) ){
			$source = $_POST['shortcode_object'];
		}
		
		$html .= OTW_Form::text_area( array( 'id' => 'otw-shortcode-element-content', 'label' => $this->get_label( 'Highlight' ), 'description' => $this->get_label( 'The highlight text.' ), 'parse' => $source )  );
		
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-type', 'label' => $this->get_label( 'Type' ), 'description' => $this->get_label( 'Colored is a highlight with a background. Underlined is a highlight with underlined text.' ), 'parse' => $source, 'options' => $this->settings['types'], 'value' => $this->settings['default_type'] ) );
		
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-background_color_class', 'label' => $this->get_label( 'Highlight color' ), 'description' => $this->get_label( 'The highlight color.' ), 'parse' => $source, 'options' => $this->settings['background_color_classes'], 'value' => $this->settings['default_background_color_class'] )  );
		
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-color_class', 'label' => $this->get_label( 'Text Color' ), 'description' => $this->get_label( 'The color for the highlight text. None means default text color.' ), 'parse' => $source, 'options' => $this->settings['color_classes'], 'value' => $this->settings['default_color_class'] )  );
		
		return $html;
	}
	
	/**
	 * Shortcode admin interface custom options
	 */
	public function build_shortcode_editor_custom_options(){
		
		$html = '';
		
		$source = array();
		if( isset( $_POST['shortcode_object'] ) ){
			$source = $_POST['shortcode_object'];
		}
		
		$html .= OTW_Form::color_picker( array( 'id' => 'otw-shortcode-element-background_color', 'label' => $this->get_label( 'Highlight color custom' ), 'description' => $this->get_label( 'Choose a custom highlight color.' ), 'parse' => $source )  );
		
		$html .= OTW_Form::color_picker( array( 'id' => 'otw-shortcode-element-color', 'label' => $this->get_label( 'Text color custom' ), 'description' => $this->get_label( 'Choose a custom text color.' ), 'parse' => $source )  );
		
		$html .= OTW_Form::text_input( array( 'id' => 'otw-shortcode-element-css_class', 'label' => $this->get_label( 'CSS Class' ), 'description' => $this->get_label( 'If you\'d like to style this element separately enter a name here. A CSS class with this name will be available for you to style this particular element..' ), 'parse' => $source )  );
		
		return $html;
	}
	
	/** build shortcode
	 *
	 *  @param array
	 *  @return string
	 */
	public function build_shortcode_code( $attributes ){
		
		$code = '';
		
		if( !isset( $attributes['content'] ) || !strlen( trim( $attributes['content'] ) ) ){
			$this->add_error( $this->get_label( 'Content is required field' ) );
		}
		
		if( !$this->has_error ){
		
			$code = '[otw_shortcode_highlight';
			
			$code .= $this->format_attribute( 'type', 'type', $attributes );
			$code .= $this->format_attribute( 'background_color_class', 'background_color_class', $attributes );
			$code .= $this->format_attribute( 'color_class', 'color_class', $attributes );
			
			$code .= $this->format_attribute( 'background_color', 'background_color', $attributes );
			$code .= $this->format_attribute( 'color', 'color', $attributes );
			
			$code .= $this->format_attribute( 'css_class', 'css_class', $attributes, false, '', true  );
			
			$code .= ']';
			
			$code .= strip_tags( $attributes['content'] );
			
			$code .= '[/otw_shortcode_highlight]';
		}
		
		return $code;

	}
	
	/**
	 * Display shortcode
	 */
	public function display_shortcode( $attributes, $content ){
		
		$html = '<span';
		
		/*class attributes*/
		$class = 'otw-sc-highlight';
		
		$class .= $this->format_attribute( '', 'type', $attributes, false, $class );
		if( $bg_color = $this->format_attribute( '', 'background_color_class', $attributes, false, '' ) ){
			
			switch( $this->format_attribute( '', 'type', $attributes, false, '' ) ){
			
				case 'with-border':
						$class = $this->append_attribute( $class, $bg_color.'-border' );
					break;
				default:
						$class = $this->append_attribute( $class, $bg_color.'-background' );
					break;
			}
		}
		$class .= $this->format_attribute( '', 'color_class', $attributes, false, $class );
		
		$class .= $this->format_attribute( '', 'css_class', $attributes, false, $class );
		
		if( strlen( $class ) ){
			$html .= ' class="'.$class.'"';
		}
		/*end class attributes*/
		
		/*style attribute*/
		$style = '';
		
		if( $bgcolor = $this->format_attribute( '', 'background_color', $attributes, false, '' ) ){
			
			switch( $this->format_attribute( '', 'type', $attributes, false, '' ) ){
			
				case 'with-border':
						$style = $this->append_attribute( $style, 'border-color: '.$bgcolor.';' );
					break;
				default:
						$style = $this->append_attribute( $style, 'background-color: '.$bgcolor.';' );
					break;
			}
		}
		
		if( $text_color = $this->format_attribute( '', 'color', $attributes, false, '' ) ){
		
			$style = $this->append_attribute( $style, 'color: '.$text_color.' !important;' );
		}
		
		if( strlen( $style ) ){
			$html .= ' style="'.$style.'"';
		}
		
		$html .= '>';
		
		$html .= nl2br( $content );
		
		$html .= '</span>';
		
		return $this->format_shortcode_output( $html );
	}
}
