<?php

/**
 *
 * @author Станимир | OTW Design
 * @ver 1.0
 */
class OTW_ShortCode_flipbox extends OTW_Shortcodes {

    function __construct() {
        parent::__construct();
        $this->has_custom_options = true;
    }

    function register_external_libs() {
        $this->add_external_lib('css', 'otw-shortcode-general_foundicons', $this->component_url . 'css/general_foundicons.css', 'all', 10);
        $this->add_external_lib('css', 'otw-shortcode-social_foundicons', $this->component_url . 'css/social_foundicons.css', 'all', 20);
        $this->add_external_lib('css', 'otw-grid', $this->component_url . '../' . 'otw_grid_manager/' . 'css/otw-grid.css', 'all', 100);
        $this->add_external_lib('css', 'otw-shortcode', $this->component_url . 'css/otw_shortcode.css', 'all', 120);
        $this->add_external_lib('css', 'otw-shortcode_scrolling', $this->component_url . 'css/scroll_for_preview.css?' . md5(time()), 'all', 130);
    }

    /**
     * Applay all settings to shortcode
     * @return \OTW_ShortCode_flipbox
     */
    public function apply_settings() {
        $this->_applyBoxAnimations();
        $this->_applyBoxBackgroundPattern();
        $this->_applyBoxBackgrounds();
        $this->_applyBoxBorderColors();
        $this->_applyBoxBorderStyle();
        $this->_applyBoxBorderType();
        $this->_applyBoxBorderWidth();
        $this->_applyBoxRoundedCourners();
        $this->_applyBoxShadow();
        $this->_applyBoxType();
        $this->_applyButtonBackgrounds();
        $this->_applyCallActions();
        $this->_applyContentLinkColor();
        $this->_applyIconAnimations();
        $this->_applyIconBackgroundColors();
        $this->_applyIconBorderStyle();
        $this->_applyIconBorderWidth();
        $this->_applyIconColorBorders();
        $this->_applyIconColors();
        $this->_applyIconSizes();
        $this->_applyIconTypes();
        $this->_applyIconBoxRounds();
    }

    protected function _applyCallActions() {
        $this->settings['call_action'] = array(
            'none' => $this->get_label('None'),
            '' => $this->get_label('Text Link(default)'),
            'round otw-button ' => $this->get_label('Button')
        );
        $this->settings['default_call_action'] = '';
        return $this;
    }

    /**
     * Get All allowed animations
     * @return array
     */
    public function getAnimations() {
        return array(
            'otw-b-flip-side' => $this->get_label('Side (Default)'),
            'otw-b-flip-upside' => $this->get_label('Upside'),
        );
    }

    /**
     * 
     * @param type $attributes
     * @return string
     */
    public function build_shortcode_code($attributes) {
        $code = '';
        if (!$this->has_error) {


            $code = '[otw_shortcode_flipbox';
            $code .= $this->format_attribute('box_animations', 'box_animations', $attributes);
            $code .= $this->format_attribute('front_title', 'front_title', $attributes);
            $code .= $this->format_attribute('front_content', 'front_content', $attributes, false, '', true);
            $code .= $this->format_attribute('front_icon_types', 'front_icon_types', $attributes);
            $code .= $this->format_attribute('front_icon_custom_content', 'front_icon_custom_content', $attributes);
            $code .= $this->format_attribute('front_icon_colors', 'front_icon_colors', $attributes);
            $code .= $this->format_attribute('front_icon_bgr_colors', 'front_icon_bgr_colors', $attributes);
            $code .= $this->format_attribute('front_icon_sizes', 'front_icon_sizes', $attributes);
            $code .= $this->format_attribute('front_icon_brd_style', 'front_icon_brd_style', $attributes);
            $code .= $this->format_attribute('front_icon_brd_width', 'front_icon_brd_width', $attributes);
            $code .= $this->format_attribute('front_icon_brd_color', 'front_icon_brd_color', $attributes);
            $code .= $this->format_attribute('front_icon_brd_round', 'front_icon_brd_round', $attributes);
//            $code .= $this->format_attribute('front_box_brd_width', 'front_box_brd_width', $attributes);
            $code .= $this->format_attribute('front_box_brd_style', 'front_box_brd_style', $attributes);
            $code .= $this->format_attribute('front_box_brd_type', 'front_box_brd_type', $attributes);
            $code .= $this->format_attribute('front_box_brd_color', 'front_box_brd_color', $attributes);
            $code .= $this->format_attribute('front_box_shadow', 'front_box_shadow', $attributes);
            $code .= $this->format_attribute('front_box_rounded_corners', 'front_box_rounded_corners', $attributes);
            $code .= $this->format_attribute('front_box_animations', 'front_box_animations', $attributes);
            $code .= $this->format_attribute('front_box_bgr', 'front_box_bgr', $attributes);
            $code .= $this->format_attribute('front_box_bgr_pattern', 'front_box_bgr_pattern', $attributes);
            $code .= $this->format_attribute('back_title', 'back_title', $attributes);
            $code .= $this->format_attribute('back_content', 'back_content', $attributes, false, '', true);
            $code .= $this->format_attribute('back_call_to_action', 'back_call_to_action', $attributes);
            $code .= $this->format_attribute('back_action_text', 'back_action_text', $attributes);
            $code .= $this->format_attribute('back_href', 'back_href', $attributes);
            $code .= $this->format_attribute('back_content_link_color', 'back_content_link_color', $attributes);
            $code .= $this->format_attribute('back_content_button_background', 'back_content_button_background', $attributes);
//            $code .= $this->format_attribute('back_box_brd_width', 'back_box_brd_width', $attributes);
            $code .= $this->format_attribute('back_box_brd_style', 'back_box_brd_style', $attributes);
            $code .= $this->format_attribute('back_box_brd_type', 'back_box_brd_type', $attributes);
            $code .= $this->format_attribute('back_box_brd_color', 'back_box_brd_color', $attributes);
            $code .= $this->format_attribute('back_box_shadow', 'back_box_shadow', $attributes);
            $code .= $this->format_attribute('back_box_rounded_corners', 'back_box_rounded_corners', $attributes);
            $code .= $this->format_attribute('back_box_animations', 'back_box_animations', $attributes);
            $code .= $this->format_attribute('back_box_bgr', 'back_box_bgr', $attributes);
            $code .= $this->format_attribute('back_box_bgr_pattern', 'back_box_bgr_pattern', $attributes);
            //custom checks
            $code .= $this->format_attribute('front_box_css_class', 'front_box_css_class', $attributes);
            $code .= $this->format_attribute('icon_custom_url', 'icon_custom_url', $attributes);
            $code .= $this->format_attribute('front_icon_custom_color', 'front_icon_custom_color', $attributes);
            $code .= $this->format_attribute('front_icon_custom_box_bgr_color', 'front_icon_custom_box_bgr_color', $attributes);
            $code .= $this->format_attribute('front_icon_custom_brd_color', 'front_icon_custom_brd_color', $attributes);
            $code .= $this->format_attribute('front_box_custom_border_color', 'front_box_custom_border_color', $attributes);
            $code .= $this->format_attribute('front_box_custom_bgr_color', 'front_box_custom_bgr_color', $attributes);
            $code .= $this->format_attribute('front_box_custom_bgr_pattern', 'front_box_custom_bgr_pattern', $attributes);
            $code .= $this->format_attribute('back_box_custom_border_color', 'back_box_custom_border_color', $attributes);
            $code .= $this->format_attribute('back_box_custom_bgr_color', 'back_box_custom_bgr_color', $attributes);
            $code .= $this->format_attribute('back_box_custom_bgr_pattern', 'back_box_custom_bgr_pattern', $attributes);
            $code .= ']';
            $code .= '[/otw_shortcode_flipbox]';
            return $code;
        }
    }

    /**
     * Set the additional settings
     * @return string
     */
    public function build_shortcode_editor_custom_options() {
        $html = '';

        $source = array();
        if (isset($_POST['shortcode_object'])) {
            $source = $_POST['shortcode_object'];
        }


        $html .= '<div class="otw-form-control" >'
                . '<h4>Custom Options for Front of the Box'
                . '<div class="otw_separator"> </div></div>';
        $html .= $this->_generateUploader('icon_custom_url', 'Icon URL', 'URL to a custom icon. (Recommended size: 128x128px)', $source);
        $html .= $this->_generatePicker('front_icon_custom_color', 'Icon Color Custom', 'Choose a custom Icon color.', $source);
        $html .= $this->_generatePicker('front_icon_custom_box_bgr_color', 'Icon Box Background Color Custom', 'Choose a custom box background color.', $source);
        $html .= $this->_generatePicker('front_icon_custom_brd_color', 'Icon Box Border Color Custom', 'Choose a custom icon box border color.', $source);
        $html .= $this->_generatePicker('front_box_custom_border_color', 'Box Border Color Custom', 'Choose a custom box border color.', $source);
        $html .= $this->_generatePicker('front_box_custom_bgr_color', 'Box Background Color Custom', 'Choose a custom box background color.', $source);
        $html .= $this->_generateUploader('front_box_custom_bgr_pattern', 'Box Background Pattern URL', 'URL to a custom box background pattern. ', $source);
        $html .= '<div class="otw-form-control" >'
                . '<h4>Custom Options for Back of the Box'
                . '<div class="otw_separator"> </div></div>';
        $html .= $this->_generatePicker('back_box_custom_border_color', 'Box Border Color Custom', 'Choose a custom box border color.', $source);
        $html .= $this->_generatePicker('back_box_custom_bgr_color', 'Box Background Color Custom', 'Choose a custom box background color.', $source);
        $html .= $this->_generateUploader('back_box_custom_bgr_pattern', 'Box Background Pattern URL', 'URL to a custom box background pattern. ', $source);

        $html .= '<div class="otw-form-control" >'
                . '<h4> Global Custom Options '
                . '<div class="otw_separator"> </div></div>';
        $html .= $this->_generateText('front_box_css_class', 'CSS Class', 'If you\'d like to style this element separately enter a name here. A CSS class with this name will be available for you to style this particular element..', $source);



        return $html;
    }

    /**
     * Generate options as HTML string 
     * @return string
     */
    public function build_shortcode_editor_options() {
        $html = '';

        $source = array();
        if (isset($_POST['shortcode_object'])) {
            $source = $_POST['shortcode_object'];
        }

        $html .= $this->_generateSelect('box_animations', 'Box Animation', 'Choose Box Animation.', $source, 'box_animations', 'default_box_animations');
        $html .= '<div class="otw-form-control" >'
                . '<h4>Front of the Box Options'
                . '<div class="otw_separator"> </div></div>';
        $html .= $this->_generateText('front_title', 'Title', 'The title for the Flip box.', $source);
        $html .= $this->_generateTextArea('front_content', 'Content', 'The content text for front of the box . HTML is allowed.', $source);
        $html .= $this->_generateSelect('front_icon_types', 'Icon Type', 'The icons here are based on foundation icon fonts.', $source, 'icon_types', 'default_icon_types', 1);
        if (!empty($source['otw-shortcode-element-front_icon_types']) && $source['otw-shortcode-element-front_icon_types'] == 'custom') {
            $html .= $this->_generateText('front_icon_custom_content', 'Custom Icon Text', 'Instead of an icon you can enter some text like: A, B, 1, 2, 3, etc.', $source);
        }


        $html .= $this->_generateSelect('front_icon_bgr_colors', 'Icon Box Background Color', 'Choose Icon Box Background Color.', $source, 'icon_bgr_colors', 'default_icon_bgr_colors', 1);
        if (empty($source['otw-shortcode-element-front_icon_bgr_colors'])) {
            $html .= $this->_generateSelect('front_icon_colors', 'Icon Color', 'Choose icon color.', $source, 'icon_colors', 'default_icon_colors');
        }
        $html .= $this->_generateSelect('front_icon_sizes', 'Icon Size', 'Choose icon size.', $source, 'icon_sizes', 'default_icon_sizes');
        $html .= $this->_generateSelect('front_icon_brd_style', 'Icon Box Border Style', 'Choose Icon Box Border Style.', $source, 'icon_brd_style', 'default_icon_brd_style');
        $html .= $this->_generateSelect('front_icon_brd_width', 'Icon Box Border Width', 'Choose Icon Box Border Width.', $source, 'icon_brd_width', 'default_icon_brd_width');
        $html .= $this->_generateSelect('front_icon_brd_color', 'Icon Box Border Color', 'Choose Icon Box Border Color.', $source, 'icon_brd_color', 'default_icon_brd_color');
        $html .= $this->_generateSelect('front_icon_brd_round', 'Icon Box Rounded Corners', 'Choose Icon Box Rounded Corners.', $source, 'icon_brd_round', 'default_icon_brd_round');

//        $html .= $this->_generateSelect('front_box_brd_width', 'Box Border Width', 'Choose Box Border Width.', $source, 'box_brd_width', 'default_box_brd_width');
        $html .= $this->_generateSelect('front_box_brd_style', 'Box Border Style', 'Choose Box Border Style.', $source, 'box_brd_style', 'default_box_brd_style');
        $html .= $this->_generateSelect('front_box_brd_type', 'Box Border Type', 'Choose Box Border Type.', $source, 'box_brd_type', 'default_box_brd_type');
        $html .= $this->_generateSelect('front_box_brd_color', 'Box Border Color', 'Choose Box Border Color.', $source, 'box_brd_color', 'default_box_brd_color');
        $html .= $this->_generateSelect('front_box_shadow', 'Box Shadow', 'Choose Box Shadow.', $source, 'box_shadow', 'default_box_shadow');
        $html .= $this->_generateSelect('front_box_rounded_corners', 'Box Rounded Corners', 'Choose Box Rounded Corners.', $source, 'box_rounded_corners', 'default_box_rounded_corners');
        $html .= $this->_generateSelect('front_box_bgr', 'Box Background Color', 'Choose Box Background Color.', $source, 'box_bgr', 'default_box_bgr');
        $html .= $this->_generateSelect('front_box_bgr_pattern', 'Box Background Pattern', 'Choose Box Background Pattern.', $source, 'box_bgr_pattern', 'default_box_bgr_pattern');

        $html .= '<div class="otw-form-control" >'
                . '<h4>Back of the Box Options'
                . '<div class="otw_separator"> </div></div>';

        $html .= $this->_generateText('back_title', 'Title', 'The title for the Flip box.', $source);
        $html .= $this->_generateTextArea('back_content', 'Content', 'The content text for front of the box . HTML is allowed.', $source);

        $html .= $this->_generateSelect('back_call_to_action', 'Call to Action', 'Choose the type of the call to action.', $source, 'call_action', 'default_call_action');
        $html .= $this->_generateText('back_action_text', 'Call to Action Text', 'This is the text in the button or the text link.', $source);
        $html .= $this->_generateText('back_href', 'Call to Action Link', 'The link your call to action leads to.', $source);
        $html .= $this->_generateSelect('back_content_link_color', 'Call to Action Text Color', 'Choose text color.', $source, 'content_link_color', 'default_content_link_color');
        $html .= $this->_generateSelect('back_content_button_background', 'Call to Action Button Color', 'Choose button color.', $source, 'content_button_background', 'default_content_button_background');

//        $html .= $this->_generateSelect('back_box_brd_width', 'Box Border Width', 'Choose Box Border Width.', $source, 'box_brd_width', 'default_box_brd_width');
        $html .= $this->_generateSelect('back_box_brd_style', 'Box Border Style', 'Choose Box Border Style.', $source, 'box_brd_style', 'default_box_brd_style');
        $html .= $this->_generateSelect('back_box_brd_type', 'Box Border Type', 'Choose Box Border Type.', $source, 'box_brd_type', 'default_box_brd_type');
        $html .= $this->_generateSelect('back_box_brd_color', 'Box Border Color', 'Choose Box Border Color.', $source, 'box_brd_color', 'default_box_brd_color');
        $html .= $this->_generateSelect('back_box_shadow', 'Box Shadow', 'Choose Box Shadow.', $source, 'box_shadow', 'default_box_shadow');
        $html .= $this->_generateSelect('back_box_rounded_corners', 'Box Rounded Corners', 'Choose Box Rounded Corners.', $source, 'box_rounded_corners', 'default_box_rounded_corners');
        $html .= $this->_generateSelect('back_box_bgr', 'Box Background Color', 'Choose Box Background Color.', $source, 'box_bgr', 'default_box_bgr');
        $html .= $this->_generateSelect('back_box_bgr_pattern', 'Box Background Pattern', 'Choose Box Background Pattern.', $source, 'box_bgr_pattern', 'default_box_bgr_pattern');



        return $html;
    }

    /**
     * Export end shortcode
     * @param array $attributes
     * @param string $content
     * @return string
     */
    public function display_shortcode($attributes, $content) {
        //$html = '<div class="otw-row">';
        $html .= '<div class="otw-b-flip-box ' . $this->format_attribute('', 'box_animations', $attributes) . ' ' . $this->format_attribute('', 'front_box_css_class', $attributes) . '">';
        //format front side 
        $front_dom_classes = 'otw-b-box otw-b-flip-box-front';
//        $front_dom_classes = $this->append_attribute($front_dom_classes, $this->format_attribute('', 'front_box_brd_width', $attributes));
        $front_dom_classes = $this->append_attribute($front_dom_classes, $this->format_attribute('', 'front_box_brd_style', $attributes));
        $front_dom_classes = $this->append_attribute($front_dom_classes, $this->format_attribute('', 'front_box_brd_type', $attributes));
        $front_dom_classes = $this->append_attribute($front_dom_classes, $this->format_attribute('', 'front_box_brd_color', $attributes));
        $front_dom_classes = $this->append_attribute($front_dom_classes, $this->format_attribute('', 'front_box_shadow', $attributes));
        $front_dom_classes = $this->append_attribute($front_dom_classes, $this->format_attribute('', 'front_box_rounded_corners', $attributes));
        $front_box_bgr = $this->format_attribute('', 'front_box_bgr', $attributes);
        if (empty($front_box_bgr)) {
            $front_box_bgr = 'otw-b-white-bgr';
        }
        $front_dom_classes = $this->append_attribute($front_dom_classes, $front_box_bgr);
        $front_dom_classes = $this->append_attribute($front_dom_classes, $this->format_attribute('', 'front_box_bgr_pattern', $attributes));
        $front_dom_classes = $this->append_attribute($front_dom_classes, 'otw-text-center');

        $front_box_style = '';
        $front_box_custom_border_color = $this->format_attribute('', 'front_box_custom_border_color', $attributes);
        if (!empty($front_box_custom_border_color)) {
            $front_box_style = $this->append_attribute($front_box_style, 'border-color:  ' . $front_box_custom_border_color . ' !important;');
        }
        //custom color
        $front_box_custom_bgr_color = $this->format_attribute('', 'front_box_custom_bgr_color', $attributes);
        if (!empty($front_box_custom_bgr_color)) {
            $front_box_style = $this->append_attribute($front_box_style, 'background-color:  ' . $front_box_custom_bgr_color . ' !important;');
        }
        //custom pattern
        $front_box_custom_bgr_pattern = $this->format_attribute('', 'front_box_custom_bgr_pattern', $attributes);
        if (!empty($front_box_custom_bgr_pattern)) {
            $front_box_style = $this->append_attribute($front_box_style, 'background-image:  url(' . $front_box_custom_bgr_pattern . ') !important;');
        }

        $html .= '<div style="' . $front_box_style . '" class = "' . $front_dom_classes . '">';


        //set all icon classes 
        $classes_for_icon = 'otw-b-icon';
        $classes_for_icon = $this->append_attribute($classes_for_icon, $this->format_attribute('', 'front_icon_colors', $attributes));
        $classes_for_icon = $this->append_attribute($classes_for_icon, $this->format_attribute('', 'front_icon_bgr_colors', $attributes));
        $classes_for_icon = $this->append_attribute($classes_for_icon, $this->format_attribute('', 'front_icon_sizes', $attributes));
        $classes_for_icon = $this->append_attribute($classes_for_icon, $this->format_attribute('', 'front_icon_brd_style', $attributes));
        $classes_for_icon = $this->append_attribute($classes_for_icon, $this->format_attribute('', 'front_icon_brd_width', $attributes));
        $classes_for_icon = $this->append_attribute($classes_for_icon, $this->format_attribute('', 'front_icon_brd_color', $attributes));
        $classes_for_icon = $this->append_attribute($classes_for_icon, $this->format_attribute('', 'front_icon_brd_round', $attributes));


	$icon_custom_style = '';
        //set the icon custom color
        $front_icon_custom_color = $this->format_attribute('', 'front_icon_custom_color', $attributes);
        if (!empty($front_icon_custom_color)) {
            $icon_custom_style = $this->append_attribute($icon_custom_style, 'color:  ' . $front_icon_custom_color . ' !important;');
        }
        //set the icon background
        $front_icon_custom_box_bgr_color = $this->format_attribute('', 'front_icon_custom_box_bgr_color', $attributes);
        if (!empty($front_icon_custom_box_bgr_color)) {
            $icon_custom_style = $this->append_attribute($icon_custom_style, 'background-color:  ' . $front_icon_custom_box_bgr_color . ' !important;');
        }
        //set the icon border color
        $front_icon_custom_brd_color = $this->format_attribute('', 'front_icon_custom_brd_color', $attributes);
        if (!empty($front_icon_custom_brd_color)) {
            $icon_custom_style = $this->append_attribute($icon_custom_style, 'border-color:  ' . $front_icon_custom_brd_color . ' !important;');
        }

        $html .= '<span style="' . $icon_custom_style . '"  class = "' . $classes_for_icon . '">';
        $custom_url_icon = $this->format_attribute('', 'icon_custom_url', $attributes);
        if ($this->format_attribute('', 'front_icon_types', $attributes) == 'custom') {
            $html .=$this->format_attribute('', 'front_icon_custom_content', $attributes);
        } else if (!empty($custom_url_icon)) {
            $html .='<img src="' . $custom_url_icon . '" alt="" />';
        } else {
            $html .='<i class = "' . $this->format_attribute('', 'front_icon_types', $attributes) . '"></i>';
        }
        $html .= '</span>';

        $html .= '<div>';
        //set the content of flipbox  for backside

        $html .= '<h3>' . $this->format_attribute('', 'front_title', $attributes) . '</h3>';
        $html .= '<p>' . nl2br(otw_htmlentities_decode(stripslashes($this->format_attribute('', 'front_content', $attributes)))) . '</p>';
        $html .= '</div>';
        $html .= '</div>';
        //set the backside classes
        $backside_classes = 'otw-b-box otw-b-flip-box-back otw-text-center';
        $backside_classes = $this->append_attribute($backside_classes, 'otw-text-center');
//        $backside_classes = $this->append_attribute($backside_classes, $this->format_attribute('', 'back_box_brd_width', $attributes));
        $backside_classes = $this->append_attribute($backside_classes, $this->format_attribute('', 'back_box_brd_style', $attributes));
        $backside_classes = $this->append_attribute($backside_classes, $this->format_attribute('', 'back_box_brd_type', $attributes));
        $backside_classes = $this->append_attribute($backside_classes, $this->format_attribute('', 'back_box_brd_color', $attributes));
        $backside_classes = $this->append_attribute($backside_classes, $this->format_attribute('', 'back_box_shadow', $attributes));
        $backside_classes = $this->append_attribute($backside_classes, $this->format_attribute('', 'back_box_rounded_corners', $attributes));
        $back_bgr = $this->format_attribute('', 'back_box_bgr', $attributes);
        if (empty($back_bgr)) {
            $back_bgr = 'otw-b-white-bgr';
        }
        $backside_classes = $this->append_attribute($backside_classes, $back_bgr);
        $backside_classes = $this->append_attribute($backside_classes, $this->format_attribute('', 'back_box_bgr_pattern', $attributes));


        $back_box_style = '';
        $back_box_custom_border_color = $this->format_attribute('', 'back_box_custom_border_color', $attributes);
        if (!empty($back_box_custom_border_color)) {
            $back_box_style = $this->append_attribute($back_box_style, 'border-color:  ' . $back_box_custom_border_color . ' !important;');
        }
        //custom color
        $back_box_custom_bgr_color = $this->format_attribute('', 'back_box_custom_bgr_color', $attributes);
        if (!empty($back_box_custom_bgr_color)) {
            $back_box_style = $this->append_attribute($back_box_style, 'background-color:  ' . $back_box_custom_bgr_color . ' !important;');
        }
        //custom pattern
        $back_box_custom_bgr_pattern = $this->format_attribute('', 'back_box_custom_bgr_pattern', $attributes);
        if (!empty($back_box_custom_bgr_pattern)) {
            $back_box_style = $this->append_attribute($back_box_style, 'background-image:  url(' . $back_box_custom_bgr_pattern . ') !important;');
        }


        $html .= '<div style="' . $back_box_style . '" class = "' . $backside_classes . '">';
        $html .= '<div>';
        $html .= '<h3>' . $this->format_attribute('', 'back_title', $attributes) . '</h3>';
        $html .= '<p>' . nl2br(otw_htmlentities_decode(stripslashes($this->format_attribute('', 'back_content', $attributes)))) . '</p>';

        //format if exist any link action 
        if ($this->format_attribute('', 'back_call_to_action', $attributes) !== 'none') {
            $link_classes = '';
            $link_classes = $this->append_attribute($link_classes, $this->format_attribute('', 'back_call_to_action', $attributes));
            $link_classes = $this->append_attribute($link_classes, $this->format_attribute('', 'back_content_link_color', $attributes));
            $link_classes = $this->append_attribute($link_classes, $this->format_attribute('', 'back_content_button_background', $attributes));
            $html .= '<a href="' . $this->format_attribute('', 'back_href', $attributes) . '" class="' . $link_classes . '">' . $this->format_attribute('', 'back_action_text', $attributes) . '</a>';
        }
        $html .= '</div>';
        $html .= '</div>';
        $html .= '</div>';
        //$html .= '</div>';
        return $this->format_shortcode_output($html);
    }

}
