<?php
class OTW_Shortcode_FAQ extends OTW_Shortcodes{
	
	public function __construct(){
		
		$this->has_custom_options = true;
		
		parent::__construct();
	}
	/**
	 * register external libs
	 */
	public function register_external_libs(){
		
		$this->add_external_lib( 'css', 'otw-shortcode', $this->component_url.'css/otw_shortcode.css', 'all', 100 );
		
		$this->add_external_lib( 'js', 'otw-shortcode-core', $this->component_url.'js/otw_shortcode_core.js', 'all', 99, array( 'jquery' ) );
		$this->add_external_lib( 'js', 'otw-shortcode', $this->component_url.'js/otw_shortcode.js', 'front', 100 );
		
		$this->add_external_lib( 'js', 'otw-shortcode_live_preview', $this->component_url.'js/otw_shortcode_live_preview.js', 'live_preview', 200 );
	}
	/**
	 * apply settings
	 */
	public function apply_settings(){
		
		$this->settings = array(
		
			'number' => array(
				'1'           => $this->get_label( '1' ),
				'2'           => $this->get_label( '2(default)' ),
				'3'           => $this->get_label( '3' ),
				'4'           => $this->get_label( '4' ),
				'5'           => $this->get_label( '5' ),
				'6'           => $this->get_label( '6' ),
				'7'           => $this->get_label( '7' ),
				'8'           => $this->get_label( '8' ),
				'9'           => $this->get_label( '9' ),
				'10'          => $this->get_label( '10' )
			),
			'default_number' => 2,
			
			'opened' => array(
				''   => $this->get_label( 'yes(default)' ),
				'open-faq'     => $this->get_label( 'no' )
			),
			'default_opened' => '',
		);
		
	}
	
	/**
	 * Shortcode admin interface
	 */
	public function build_shortcode_editor_options(){
		
		$html = '';
		
		$source = array();
		if( isset( $_POST['shortcode_object'] ) ){
			$source = $_POST['shortcode_object'];
		}
		
		$html .= OTW_Form::text_input( array( 'id' => 'otw-shortcode-element-title', 'label' => $this->get_label( 'FAQ title' ), 'description' => $this->get_label( 'FAQ title' ), 'parse' => $source )  );
		
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-number', 'label' => $this->get_label( 'Number' ), 'description' => $this->get_label( 'Select number of FAQs.' ), 'parse' => $source, 'options' => $this->settings['number'], 'value' => $this->settings['default_number'], 'data-reload' => '1' ) );
		
		$total_number = $this->settings['default_number'];
		
		if( isset( $source['otw-shortcode-element-number'] ) ){
			$total_number = $source['otw-shortcode-element-number'];
		}
		
		for( $cT = 1; $cT <= $total_number; $cT++ )
		{
			$html .= OTW_Form::text_input( array( 'id' => 'otw-shortcode-element-item_'.$cT.'_title', 'label' => $this->get_label( 'FAQ '.$cT.' title' ), 'description' => $this->get_label( 'The FAQ title.' ), 'parse' => $source )  );
			
			$html .= OTW_Form::text_area( array( 'id' => 'otw-shortcode-element-item_'.$cT.'_content', 'label' => $this->get_label( 'FAQ '.$cT.' content' ), 'description' => $this->get_label( 'The FAQ content. HTML is allowed.' ), 'parse' => $source )  );
			
			$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-item_'.$cT.'_opened', 'label' => $this->get_label( 'FAQ '.$cT.' opened' ), 'description' => $this->get_label( 'Opened or closed on page load.' ), 'parse' => $source, 'options' => $this->settings['opened'], 'value' => $this->settings['default_opened'] ) );
		}
		
		return $html;
	}
	
	/**
	 * Shortcode admin interface custom options
	 */
	public function build_shortcode_editor_custom_options(){
		
		$html = '';
		
		$source = array();
		if( isset( $_POST['shortcode_object'] ) ){
			$source = $_POST['shortcode_object'];
		}
		
		$html .= OTW_Form::text_input( array( 'id' => 'otw-shortcode-element-css_class', 'label' => $this->get_label( 'CSS Class' ), 'description' => $this->get_label( 'If you\'d like to style this element separately enter a name here. A CSS class with this name will be available for you to style this particular element..' ), 'parse' => $source )  );
		
		return $html;
	}
	
	/** build shortcode
	 *
	 *  @param array
	 *  @return string
	 */
	public function build_shortcode_code( $attributes ){
		
		$code = '';
		
		if( !$this->has_error ){
		
			$code = '[otw_shortcode_faq';
			
			$code .= $this->format_attribute( 'title', 'title', $attributes, false, '', true );
			
			$code .= $this->format_attribute( 'number', 'number', $attributes );
			
			if( $number = $this->format_attribute( '', 'number', $attributes ) ){
				
				for( $cT = 1; $cT <= $number; $cT++ ){
					$code .= $this->format_attribute( 'item_'.$cT.'_title', 'item_'.$cT.'_title', $attributes, false, '', true );
					$code .= $this->format_attribute( 'item_'.$cT.'_content', 'item_'.$cT.'_content', $attributes, false, '', true );
					$code .= $this->format_attribute( 'item_'.$cT.'_opened', 'item_'.$cT.'_opened', $attributes );
				}
			}
			
			$code .= $this->format_attribute( 'css_class', 'css_class', $attributes, false, '', true  );
			
			$code .= ']';
			
			$code .= '[/otw_shortcode_faq]';
		}
		
		return $code;

	}
	
	/**
	 * Display shortcode
	 */
	public function display_shortcode( $attributes, $content ){
		
		$html = '<div';
		
		/*class attributes*/
		$class = 'otw-sc-faq';
		
		$class .= $this->format_attribute( '', 'css_class', $attributes, false, $class );
		
		if( strlen( $class ) ){
			$html .= ' class="'.$class.'"';
		}
		/*end class attributes*/
		
		/*style attribute*/
		$style = '';
		
		if( strlen( $style ) ){
			$html .= ' style="'.$style.'"';
		}
		
		$html .= '>';
		
		$html .= '<h3';
		
		$title_class = 'widget-title';
		
		if( strlen( $title_class ) ){
			$html .= ' class="'.$title_class.'"';
		}
		
		$html .= '>'.$this->format_attribute( '', 'title', $attributes, false, '' );
		
		$html .= '</h3>';
		
		if( $number = $this->format_attribute( '', 'number', $attributes, false, '' ) ){
			
			$html .= '<dl>';
			for( $cT = 1; $cT <= $number; $cT++ ){
				
				$html .= '<dt';
				
				$dt_class = '';
				
				$dt_class .= $this->format_attribute( '', 'item_'.$cT.'_opened', $attributes, false, $dt_class );
				
				if( strlen( $dt_class ) ){
					$html .= ' class="'.$dt_class.'"';
				}
				
				$html .= '><span></span>';
				if( $item_title = $this->format_attribute( '', 'item_'.$cT.'_title', $attributes, false, '' ) ){
					$html .= $item_title;
				}
				$html .= '</dt>';
				$html .= '<dd';
				
				if( $this->format_attribute( '', 'item_'.$cT.'_opened', $attributes, false, '' ) ){
					$html .= ' style="display:none;"';
				}else{
					$html .= ' style="display:block;"';
				}
				
				$html .= '>';
				
				if( $item_content = $this->format_attribute( '', 'item_'.$cT.'_content', $attributes, false, '' ) ){
					$html .= '<p>'.nl2br( otw_htmlentities_decode( $item_content ) ).'</p>';
				}
				$html .= '</dd>';
			}
			$html .= '</dl>';
		}
		
		$html .= '</div>';
		
		return $this->format_shortcode_output( $html );
	}
}