<?php
class OTW_Shortcode_Custom_Shortcode extends OTW_Shortcodes{
	
	/**
	 * Imported shortcode options key
	*/
	public $custom_shortcodes_option = 'otw_custom_shortcodes';
	
	/**
	 * saved info about the custom shortcode
	*/
	private $custom_shortcode_data = array();
	
	public function register_external_libs(){
		
		$this->add_external_lib( 'css', 'otw-shortcode-general_foundicons', $this->component_url.'css/general_foundicons.css', 'all', 10 );
		$this->add_external_lib( 'css', 'otw-shortcode-social_foundicons', $this->component_url.'css/social_foundicons.css', 'all', 20 );
		$this->add_external_lib( 'css', 'otw-shortcode', $this->component_url.'css/otw_shortcode.css', 'all', 100 );
	}
	
	public function __construct(){
		
		$this->has_custom_options = false;
		
		parent::__construct();
		
		$custom_shortcodes = get_option( $this->custom_shortcodes_option );
		
		if( !$this->shortcode_key ){
			
			if( isset( $_GET['shortcode'] ) ){
				
				$this->shortcode_key = $_GET['shortcode'];
			}
			
		}
		if( $this->shortcode_key ){
		
			if( preg_match( "/^custom_shortcode_/", $this->shortcode_key ) ){
				$key = preg_replace( "/^custom_shortcode_/", "", $this->shortcode_key );
				
				if( isset( $custom_shortcodes['shortcodes'] ) && isset( $custom_shortcodes['shortcodes'][ $key ] ) ){
					$this->custom_shortcode_data = $custom_shortcodes['shortcodes'][ $key ];
				}
			}
		}
	}
	
	public function apply_settings(){
		
		$this->settings = array(
			'icon_types' => array(
				''                      => $this->get_label( 'none (Default)' ),
				'general foundicon-settings'      => $this->get_label( 'Settings' ),
				'general foundicon-heart'         => $this->get_label( 'Heart' ),
				'general foundicon-star'          => $this->get_label( 'Star' ),
				'general foundicon-plus'          => $this->get_label( 'Plus' ),
				'general foundicon-minus'         => $this->get_label( 'Minus' ),
				'general foundicon-checkmark'     => $this->get_label( 'Checkmark' ),
				'general foundicon-remove'        => $this->get_label( 'Remove' ),
				'general foundicon-mail'          => $this->get_label( 'Mail' ),
				'general foundicon-calendar'      => $this->get_label( 'Calendar' ),
				'general foundicon-page'          => $this->get_label( 'Page' ),
				'general foundicon-tools'         => $this->get_label( 'Tools' ),
				'general foundicon-globe'         => $this->get_label( 'Globe' ),
				'general foundicon-cloud'         => $this->get_label( 'Cloud' ),
				'general foundicon-error'         => $this->get_label( 'Error' ),
				'general foundicon-right-arrow'   => $this->get_label( 'Right arrow' ),
				'general foundicon-left-arrow'    => $this->get_label( 'Left arrow' ),
				'general foundicon-up-arrow'      => $this->get_label( 'Up arrow' ),
				'general foundicon-down-arrow'    => $this->get_label( 'Down arrow' ),
				'general foundicon-trash'         => $this->get_label( 'Trash' ),
				'general foundicon-add-doc'       => $this->get_label( 'Add Doc' ),
				'general foundicon-edit'          => $this->get_label( 'Edit' ),
				'general foundicon-lock'          => $this->get_label( 'Lock' ),
				'general foundicon-unlock'        => $this->get_label( 'Unlock' ),
				'general foundicon-refresh'       => $this->get_label( 'Refresh' ),
				'general foundicon-paper-clip'    => $this->get_label( 'Paper clip' ),
				'general foundicon-video'         => $this->get_label( 'Video' ),
				'general foundicon-photo'         => $this->get_label( 'Photo' ),
				'general foundicon-graph'         => $this->get_label( 'Graph' ),
				'general foundicon-idea'          => $this->get_label( 'Idea' ),
				'general foundicon-mic'           => $this->get_label( 'Mic' ),
				'general foundicon-cart'          => $this->get_label( 'Cart' ),
				'general foundicon-address-book'  => $this->get_label( 'Address book' ),
				'general foundicon-compass'       => $this->get_label( 'Compass' ),
				'general foundicon-flag'          => $this->get_label( 'Flag' ),
				'general foundicon-location'      => $this->get_label( 'Location' ),
				'general foundicon-clock'         => $this->get_label( 'Clock' ),
				'general foundicon-folder'        => $this->get_label( 'Folder' ),
				'general foundicon-inbox'         => $this->get_label( 'Inbox' ),
				'general foundicon-website'       => $this->get_label( 'Website' ),
				'general foundicon-smiley'        => $this->get_label( 'Smiley' ),
				'general foundicon-search'        => $this->get_label( 'Search' ),
				'general foundicon-phone'         => $this->get_label( 'Phone' ),
				
				'social foundicon-thumb-up'       => $this->get_label( 'Thumb up' ),
				'social foundicon-thumb-down'     => $this->get_label( 'Thumb down' ),
				'social foundicon-rss'            => $this->get_label( 'Rss' ),
				'social foundicon-facebook'       => $this->get_label( 'Facebook' ),
				'social foundicon-twitter'        => $this->get_label( 'Twitter' ),
				'social foundicon-pinterest'      => $this->get_label( 'Pinterest' ),
				'social foundicon-github'         => $this->get_label( 'Github' ),
				'social foundicon-path'           => $this->get_label( 'Path' ),
				'social foundicon-linkedin'       => $this->get_label( 'LinkedIn' ),
				'social foundicon-dribbble'       => $this->get_label( 'Dribbble' ),
				'social foundicon-stumble-upon'   => $this->get_label( 'Stumble upon' ),
				'social foundicon-behance'        => $this->get_label( 'Behance' ),
				'social foundicon-reddit'         => $this->get_label( 'Reddit' ),
				'social foundicon-google-plus'    => $this->get_label( 'Google plus' ),
				'social foundicon-youtube'        => $this->get_label( 'Youtube' ),
				'social foundicon-vimeo'          => $this->get_label( 'Vimeo' ),
				'social foundicon-clickr'         => $this->get_label( 'Clickr' ),
				'social foundicon-slideshare'     => $this->get_label( 'Slideshare' ),
				'social foundicon-picassa'        => $this->get_label( 'Picassa' ),
				'social foundicon-skype'          => $this->get_label( 'Skype' ),
				'social foundicon-instagram'      => $this->get_label( 'instagram' ),
				'social foundicon-foursquare'     => $this->get_label( 'Foursquare' ),
				'social foundicon-delicious'      => $this->get_label( 'Delicious' ),
				'social foundicon-chat'           => $this->get_label( 'Chat' ),
				'social foundicon-torso'          => $this->get_label( 'Torso' ),
				'social foundicon-tumblr'         => $this->get_label( 'Tumblr' ),
				'social foundicon-video-chat'     => $this->get_label( 'Video chat' ),
				'social foundicon-digg'           => $this->get_label( 'Digg' ),
				'social foundicon-wordpress'      => $this->get_label( 'Wordpress' )
			),
			
			'default_icon_type' => '',
			
			'title_sizes' => array(
				
				'h1' => 'H1',
				'h2' => 'H2',
				'h3' => 'H3',
				'h4' => 'H4',
				'h5' => 'H5',
				'h6' => 'H6'
			),
			'default_title_size' => 'h1',
			
			'border_types' => array(
				''       => $this->get_label( 'none(default)' ),
				'bordered'          => $this->get_label( 'All sides' ),
				'border-top-bottom' => $this->get_label( 'Top and Bottom' ),
				'border-left-right' => $this->get_label( 'Left and Right' )
			),
			'default_border_type' => '',
			
			'border_styles' => array(
				'bordered'   => $this->get_label( 'solid(default)' ),
				'dashed'     => $this->get_label( 'dashed' ),
				'dotted'     => $this->get_label( 'dotted' )
			),
			'default_border_style' => 'bordered',
			
			'shadows' => array(
				''       => $this->get_label( 'none(default)' ),
				'shadow-inner'      => $this->get_label( 'inner' ),
				'shadow-outer'      => $this->get_label( 'outer' ),
				'shadow-down-left'  => $this->get_label( 'Left and Down' ),
				'shadow-down-right' => $this->get_label( 'Right and Down' )
			),
			'default_shadow' => '',
			
			'rounded_corners' => array(
				''     => $this->get_label( 'none(default)' ),
				'rounded-3'      => $this->get_label( '3px' ),
				'rounded-5'      => $this->get_label( '5px' ),
				'rounded-10'     => $this->get_label( '10px' )
			),
			'default_rounded_corner' => '',
			
			'icon_sizes' => array(
				'tiny'   => $this->get_label( 'Tiny' ),
				'small'  => $this->get_label( 'Small' ),
				'medium' => $this->get_label( 'Medium' ),
				'large'  => $this->get_label( 'Large' ),
			),
			'default_icon_size' => 'small',
			
			'yes_no_options' => array(
				'yes'   => $this->get_label( 'Yes(default)' ),
				'no'  => $this->get_label( 'No' )
			),
			'default_yes_no' => 'yes'
			
		);
	}
	

	
	/**
	 * Shortcode admin interface
	 */
	public function build_shortcode_editor_options(){
		
		$html = '';
		
		$source = array();
		if( isset( $_POST['shortcode_object'] ) ){
			$source = $_POST['shortcode_object'];
		}
		
		if( isset( $this->custom_shortcode_data['code'] ) ){
			$code_object = json_decode( $this->custom_shortcode_data['code'] );
			
			foreach( $code_object->fields as $field ){
			
				switch( $field->type ){
					
					case 'title_icon':
							$html .= '<div class="otw-control-group">';
								$html .= OTW_Form::select( ( array( 'id' => 'otw-shortcode-element-f'.$field->key.'_s3', 'label' => $this->concat_label( $field->title, $this->get_label( 'size' ) ), 'parse' => $source, 'options' => $this->settings['title_sizes'], 'value' => $this->settings['default_title_size'], 'show_empty_label' => true ) ) );
								$html .= OTW_Form::text_input( ( array( 'id' => 'otw-shortcode-element-f'.$field->key.'_s1', 'label' => $this->concat_label( $field->title, $this->get_label( 'text' ) ), 'parse' => $source, 'show_empty_label' => true ) ) );
								$html .= OTW_Form::select( ( array( 'id' => 'otw-shortcode-element-f'.$field->key.'_s4', 'label' => $this->concat_label( $field->title, $this->get_label( 'icon size' ) ), 'parse' => $source, 'options' => $this->settings['icon_sizes'], 'value' => $this->settings['default_icon_size'], 'show_empty_label' => true ) ) );
								$html .= OTW_Form::select( ( array( 'id' => 'otw-shortcode-element-f'.$field->key.'_s2', 'label' => $this->concat_label( $field->title, $this->get_label( 'icon type' ) ), 'description' => $field->description, 'parse' => $source, 'options' => $this->settings['icon_types'], 'value' => $this->settings['default_icon_type'], 'show_empty_label' => true ) ) );
							$html .= '</div>';
						break;
					case 'text_area':
							$html .= '<div class="otw-control-group">';
								$html .= OTW_Form::text_area( ( array( 'id' => 'otw-shortcode-element-f'.$field->key, 'label' => $field->title, 'description' => $field->description, 'parse' => $source, 'show_empty_label' => true ) ) );
							$html .= '</div>';
						break;
					case 'link':
							$html .= '<div class="otw-control-group">';
								$html .= OTW_Form::text_input( ( array( 'id' => 'otw-shortcode-element-f'.$field->key.'_s1', 'label' => $this->concat_label( $field->title, $this->get_label( 'text' ) ), 'parse' => $source, 'show_empty_label' => true ) ) );
								$html .= OTW_Form::text_input( ( array( 'id' => 'otw-shortcode-element-f'.$field->key.'_s2', 'label' => $this->concat_label( $field->title, $this->get_label( 'URL' ) ), 'description' => $field->description, 'parse' => $source, 'show_empty_label' => true ) ) );
							$html .= '</div>';
						break;
					case 'button':
							$html .= '<div class="otw-control-group">'; 
								$html .= OTW_Form::text_input( ( array( 'id' => 'otw-shortcode-element-f'.$field->key.'_s1', 'label' => $this->concat_label( $field->title, $this->get_label( 'text' ) ), 'parse' => $source, 'show_empty_label' => true ) ) );
								$html .= OTW_Form::text_input( ( array( 'id' => 'otw-shortcode-element-f'.$field->key.'_s2', 'label' => $this->concat_label( $field->title, $this->get_label( 'link' ) ), 'parse' => $source, 'show_empty_label' => true ) ) );
								$html .= OTW_Form::color_picker( ( array( 'id' => 'otw-shortcode-element-f'.$field->key.'_s3', 'label' => $this->concat_label( $field->title, $this->get_label( 'color' ) ), 'description' => $field->description, 'parse' => $source, 'show_empty_label' => true ) ) );
							$html .= '</div>';
						break;
					case 'image_full':
							$html .= '<div class="otw-control-group">';
								$html .= OTW_Form::uploader( ( array( 'id' => 'otw-shortcode-element-f'.$field->key, 'label' => $field->title, 'description' => $field->description, 'parse' => $source, 'show_empty_label' => true ) ) );
							$html .= '</div>';
						break;
					case 'image_hfl':
					case 'image_hfr':
					case 'image_hl':
					case 'image_hr':
							$html .= '<div class="otw-control-group">';
								$html .= OTW_Form::uploader( ( array( 'id' => 'otw-shortcode-element-f'.$field->key.'_s1', 'label' => $this->concat_label( $field->title, $this->get_label( 'Image' ) ), 'parse' => $source, 'show_empty_label' => true ) ) );
								$html .= OTW_Form::text_area( ( array( 'id' => 'otw-shortcode-element-f'.$field->key.'_s2', 'label' => $this->concat_label( $field->title, $this->get_label( 'Text' ) ), 'description' => $field->description, 'parse' => $source, 'show_empty_label' => true ) ) );
							$html .= '</div>';
						break;
					case 'bg_color':
							$html .= '<div class="otw-control-group">';
								$html .= OTW_Form::color_picker( ( array( 'id' => 'otw-shortcode-element-f'.$field->key, 'label' => $field->title, 'description' => $field->description, 'parse' => $source, 'show_empty_label' => true ) ) );
							$html .= '</div>';
						break;
					case 'border':
							$html .= '<div class="otw-control-group">';
								$html .= OTW_Form::select( ( array( 'id' => 'otw-shortcode-element-f'.$field->key.'_s1', 'label' => $this->concat_label( $field->title, $this->get_label( 'Type' ) ), 'parse' => $source, 'options' => $this->settings['border_types'], 'value' => $this->settings['default_border_type'], 'show_empty_label' => true ) ) );
								$html .= OTW_Form::color_picker( ( array( 'id' => 'otw-shortcode-element-f'.$field->key.'_s2', 'label' => $this->concat_label( $field->title, $this->get_label( 'Color' ) ), 'parse' => $source, 'show_empty_label' => true ) ) );
								$html .= OTW_Form::select( ( array( 'id' => 'otw-shortcode-element-f'.$field->key.'_s3', 'label' => $this->concat_label( $field->title, $this->get_label( 'Style' ) ), 'description' => $field->description, 'parse' => $source, 'options' => $this->settings['border_styles'], 'value' => $this->settings['default_border_style'], 'show_empty_label' => true ) ) );
							$html .= '</div>';
						break;
					case 'shadow':
							$html .= '<div class="otw-control-group">';
								$html .= OTW_Form::select( ( array( 'id' => 'otw-shortcode-element-f'.$field->key, 'label' => $field->title, 'description' => $field->description, 'parse' => $source, 'options' => $this->settings['shadows'], 'value' => $this->settings['default_shadow'], 'show_empty_label' => true ) ) );
							$html .= '</div>';
						break;
					case 'rounded_corners':
							$html .= '<div class="otw-control-group">';
								$html .= OTW_Form::select( ( array( 'id' => 'otw-shortcode-element-f'.$field->key, 'label' => $field->title, 'description' => $field->description, 'parse' => $source, 'options' => $this->settings['rounded_corners'], 'value' => $this->settings['default_rounded_corner'], 'show_empty_label' => true ) ) );
							$html .= '</div>';
						break;
					case 'divider':
					case 'divider_empty':
							$html .= '<div class="otw-control-group">';
								$html .= OTW_Form::select( ( array( 'id' => 'otw-shortcode-element-f'.$field->key, 'label' => $field->title, 'description' => $field->description, 'parse' => $source, 'options' => $this->settings['yes_no_options'], 'value' => $this->settings['default_yes_no'], 'show_empty_label' => true ) ) );
							$html .= '</div>';
						break;
					case 'css_class':
					default:
							$html .= '<div class="otw-control-group">';
								$html .= OTW_Form::text_input( ( array( 'id' => 'otw-shortcode-element-f'.$field->key, 'label' => $field->title, 'description' => $field->description, 'parse' => $source, 'show_empty_label' => true ) ) );
							$html .= '</div>';
						break;
				}
			}
		}
		return $html;
	}
	
	/**
	 * Shortcode admin interface custom options
	 */
	public function build_shortcode_editor_custom_options(){
		
		$html = '';
		
		$source = array();
		if( isset( $_POST['shortcode_object'] ) ){
			$source = $_POST['shortcode_object'];
		}
		
		return $html;
	}
	
	/** build shortcode
	 *
	 *  @param array
	 *  @return string
	 */
	public function build_shortcode_code( $attributes ){
		
		$code = '';
		
		if( !$this->has_error ){
		
			$code = '[otw_shortcode_custom_shortcode';
			
			//add the custom shor-tcode as key
			$inner_code = ' key="'.preg_replace( "/^custom_shortcode_/", "", $this->shortcode_key ).'"';
			
			if( isset( $this->custom_shortcode_data['code'] ) ){
				
				$code_object = json_decode( $this->custom_shortcode_data['code'] );
				
				if( isset( $code_object->fields ) ){
				
					foreach( $code_object->fields as $field_data ){
						
						switch( $field_data->type ){
							
							case 'title_icon':
									$inner_code .= $this->format_attribute( 'f'.$field_data->key.'_s1', 'f'.$field_data->key.'_s1', $attributes, false, '', true );
									$inner_code .= $this->format_attribute( 'f'.$field_data->key.'_s2', 'f'.$field_data->key.'_s2', $attributes, false, '', true );
									$inner_code .= $this->format_attribute( 'f'.$field_data->key.'_s3', 'f'.$field_data->key.'_s3', $attributes, false, '', true );
									$inner_code .= $this->format_attribute( 'f'.$field_data->key.'_s4', 'f'.$field_data->key.'_s4', $attributes, false, '', true );
								break;
							case 'button':
							case 'border':
									$inner_code .= $this->format_attribute( 'f'.$field_data->key.'_s1', 'f'.$field_data->key.'_s1', $attributes, false, '', true );
									$inner_code .= $this->format_attribute( 'f'.$field_data->key.'_s2', 'f'.$field_data->key.'_s2', $attributes, false, '', true );
									$inner_code .= $this->format_attribute( 'f'.$field_data->key.'_s3', 'f'.$field_data->key.'_s3', $attributes, false, '', true );
								break;
							case 'link':
							case 'image_hfl':
							case 'image_hfr':
							case 'image_hl':
							case 'image_hr':
									$inner_code .= $this->format_attribute( 'f'.$field_data->key.'_s1', 'f'.$field_data->key.'_s1', $attributes, false, '', true );
									$inner_code .= $this->format_attribute( 'f'.$field_data->key.'_s2', 'f'.$field_data->key.'_s2', $attributes, false, '', true );
								break;
							case 'divider':
							case 'divider_empty':
									$inner_code .= $this->format_attribute( 'f'.$field_data->key, 'f'.$field_data->key, $attributes, true, '', true );
								break;
							case 'text_area':
							case 'image_full':
							case 'shadow':
							case 'rounded_corners':
							case 'css_class':
							default:
									$inner_code .= $this->format_attribute( 'f'.$field_data->key, 'f'.$field_data->key, $attributes, false, '', true );
								break;
						}
					}
				}
			}
			
			$inner_code = otw_encode_wp_shortcodes( $inner_code );
			
			$code .= $inner_code;
			
			$code .= ']';
			
			$code .= '[/otw_shortcode_custom_shortcode]';
			
		}
		
		return $code;
	}
	
	/**
	 * Display shortcode
	 */
	public function display_shortcode( $attributes, $content ){
		
		$inner_html = '';
		$html = '<div';
		
		/*class attributes*/
		$class = 'otw-custom-shortcode';
		
		/*style attribute*/
		$style = '';
		
		$custom_shortcodes = get_option( $this->custom_shortcodes_option );
		
		$fields_assoc = array();
		
		$s_key = '';
		
		if( isset( $attributes['key'] ) && strlen( trim( $attributes['key'] ) ) ){
		
			$class .= ' otw-custom-shortcode-s'.$attributes['key'];
			
			$s_key = 's'.$attributes['key'];
			
			if( isset( $custom_shortcodes['shortcodes'] ) && isset( $custom_shortcodes['shortcodes'][ $attributes['key'] ] ) && isset( $custom_shortcodes['shortcodes'][ $attributes['key'] ]['code'] ) ){
				
				$code_object = json_decode( $custom_shortcodes['shortcodes'][ $attributes['key'] ]['code'] );
				
				foreach( $code_object->fields as $field ){
				
					$fields_assoc[ $field->key ] = $field;
				}
			}
		}
		
		foreach( $attributes as $a_key => $a_value ){
			
			if( preg_match( "/^f([0-9]+)$/", $a_key, $matches ) && isset( $fields_assoc[ $matches[1] ] ) ){
				
				$field_type = $fields_assoc[ $matches[1] ]->type;
				
				switch( $field_type ){
					case 'text_area':
							$inner_html .= '<p class="otw-custom-shortcode-'.$field_type.' otw-custom-shortcode-'.$field_type.$s_key.$a_key.'">'.nl2br( otw_htmlentities_decode( $a_value ) ).'</p>';
						break;
					case 'image_full':
							$inner_html .= '<div class="otw-custom-shortcode-'.$field_type.' otw-custom-shortcode-'.$field_type.$s_key.$a_key.'">';
							$inner_html .= '<img src="'.$a_value.'" alt="" />';
							$inner_html .= '</div>';
						break;
					case 'divider':
							if( $a_value == 'yes' ){
								$inner_html .= '<div class="otw-custom-shortcode-'.$field_type.' otw-sc-divider otw-custom-shortcode-'.$field_type.$s_key.$a_key.'">';
								
								$inner_html .= '</div>';
							}
						break;
					case 'divider_empty':
							if( $a_value == 'yes' ){
								$inner_html .= '<div class="otw-custom-shortcode-'.$field_type.' otw-sc-divider empty otw-custom-shortcode-'.$field_type.$s_key.$a_key.'">';
								
								$inner_html .= '</div>';
							}
						break;
					case 'h1':
					case 'h2':
					case 'h3':
					case 'h4':
					case 'h5':
					case 'h6':
							$inner_html .= '<'.$field_type.' class="otw-custom-shortcode-'.$field_type.' otw-custom-shortcode-'.$field_type.$s_key.$a_key.'">'.$a_value.'</'.$field_type.'>';
						break;
					case 'bg_color':
							if( $a_value ){
								$style = $this->append_attribute( $style, 'background-color: '.$a_value.';' );
							}
						break;
					case 'pattern_url':
							if( $a_value ){
								$style = $this->append_attribute( $style, 'background-image: url(\''.$a_value.'\');' );
							}
						break;
					case 'shadow':
							if( $a_value ){
								$class .= $this->format_attribute( '', $matches[0], $attributes, false, $class );
							}
						break;
					case 'rounded_corners':
							if( $a_value ){
								$class .= $this->format_attribute( '', $matches[0], $attributes, false, $class );
							}
						break;
					case 'css_class':
							if( $a_value ){
								$class .= $this->format_attribute( '', $matches[0], $attributes, false, $class );
							}
						break;
				}
			}
			elseif( preg_match( "/^f([0-9]+)_s1$/", $a_key, $matches ) && isset( $fields_assoc[ $matches[1] ] ) ){
				
				$field_type = $fields_assoc[ $matches[1] ]->type;
				
				switch( $field_type ){
				
					case 'title_icon':
							$inner_html .= '<'.$this->format_attribute( '', 'f'.$matches[1].'_s3', $attributes, false, '' ).' class="otw-custom-shortcode-'.$field_type.' otw-custom-shortcode-'.$field_type.$s_key.$a_key.'">';
							if( $icon_type = $this->format_attribute( '', 'f'.$matches[1].'_s2', $attributes, false, '' ) ){
								
								$i_class = $icon_type;
								
								if( $icon_size = $this->format_attribute( '', 'f'.$matches[1].'_s4', $attributes, false, '' ) ){
									$i_class .= ' '.$icon_size;
								}
								
								$inner_html .= '<i class="'.$i_class.'"></i>';
							}
							$inner_html .= $this->format_attribute( '', 'f'.$matches[1].'_s1', $attributes, false, '' );
							
							$inner_html .= '</'.$this->format_attribute( '', 'f'.$matches[1].'_s3', $attributes, false, '' ).'>';
						break;
					case 'link';
							$inner_html .= '<p class="otw-custom-shortcode-'.$field_type.'-wrapper">';
								$inner_html .= '<a class="otw-custom-shortcode-'.$field_type.' otw-custom-shortcode-'.$field_type.$s_key.$a_key.'" href="'.$this->format_attribute( '', 'f'.$matches[1].'_s2', $attributes, false, '' ).'">'.$a_value.'</a>';
							$inner_html .= '</p>';
						break;
					case 'button':
							$inner_html .= '<p class="otw-custom-shortcode-'.$field_type.'-wrapper">';
							$inner_html .= '<a class="otw-custom-shortcode-'.$field_type.' otw-button otw-custom-shortcode-'.$field_type.$s_key.$a_key.'" href="'.$this->format_attribute( '', 'f'.$matches[1].'_s2', $attributes, false, '' ).'"';
							
							if( $bg_color = $this->format_attribute( '', 'f'.$matches[1].'_s3', $attributes, false, '' ) ){
								$inner_html .= ' style="background-color: '.$bg_color.'"';
							}
							
							$inner_html .= '>'.$a_value;
							$inner_html .= '</a>';
							$inner_html .= '</p>';
						break;
					case 'image_hfl':
					case 'image_hfr':
							$inner_html .= '<div class="otw-custom-shortcode-'.$field_type.' otw-custom-shortcode-'.$field_type.$s_key.$a_key.'">';
							$inner_html .= '<div class="otw-cs-image"><img src="'.$a_value.'" alt="" /></div>';
							if( $text = $this->format_attribute( '', 'f'.$matches[1].'_s2', $attributes, false, '' ) ){
								$inner_html .= nl2br( otw_htmlentities_decode( $text ) );
							}
							$inner_html .= '</div>';
						break;
					case 'image_hl':
					case 'image_hr':
							$inner_html .= '<div class="otw-custom-shortcode-'.$field_type.' otw-custom-shortcode-'.$field_type.$s_key.$a_key.'">';
							$inner_html .= '<div class="otw-cs-image"><img src="'.$a_value.'" alt="" /></div>';
							if( $text = $this->format_attribute( '', 'f'.$matches[1].'_s2', $attributes, false, '' ) ){
								$inner_html .= '<div class="otw-cs-text">'.nl2br( otw_htmlentities_decode( $text ) ).'</div>';
							}
							$inner_html .= '</div>';
						break;
					case 'border':
							if( $a_value ){
								$class .= $this->format_attribute( '', 'f'.$matches[1].'_s1', $attributes, false, $class );
								$class .= $this->format_attribute( '', 'f'.$matches[1].'_s3', $attributes, false, $class );
								
								if( $border_color = $this->format_attribute( '', 'f'.$matches[1].'_s2', $attributes, false, '' ) ){
									$style = $this->append_attribute( $style, 'border-color: '.$border_color.';' );
								}
							}
						break;
				}
			}
		}
		
		if( strlen( $class ) ){
			$html .= ' class="'.$class.'"';
		}
		
		if( strlen( $style ) ){
			$html .= ' style="'.$style.'"';
		}
		
		$html .= '>'.$inner_html;
		
		$html .= '</div>';
		
		return $this->format_shortcode_output( otw_decode_wp_shortcodes( $html ) );
	}
	
	public function concat_label( $label, $post_label ){
		
		$result = $label;
		
		if( strlen( $result ) && strlen( $post_label ) ){
			$result = $result.' '.$post_label;
		}
		
		return $result;
	}
}
