<?php

/**
 * General Workflow for Otw_Shortcode_Countdown
 *
 * @author Станимир | OTW Design
 * @ver 1.0
 */
class Otw_Shortcode_Countdown extends OTW_Shortcodes {

    function __construct() {
        parent::__construct();
        $this->has_custom_options = true;
    }

    function register_external_libs() {
        $this->add_external_lib('css', 'otw-shortcode-general_foundicons', $this->component_url . 'css/general_foundicons.css', 'all', 10);
        $this->add_external_lib('css', 'otw-shortcode-social_foundicons', $this->component_url . 'css/social_foundicons.css', 'all', 20);
        $this->add_external_lib('css', 'otw-grid', $this->component_url . '../' . 'otw_grid_manager/' . 'css/otw-grid.css', 'all', 100);
        $this->add_external_lib('css', 'otw-shortcode', $this->component_url . 'css/otw_shortcode.css', 'all', 120);
        $this->add_external_lib('css', 'otw-shortcode_scrolling', $this->component_url . 'css/scroll_for_preview.css?' . md5(time()), 'all', 130);

        $this->add_external_lib('js', 'otw-shortcode-makeplugin', $this->component_url . 'js/jquery.plugin.min.js', 'all', 95, array('jquery'));
        $this->add_external_lib('js', 'otw-shortcode-countdown', $this->component_url . 'js/jquery.countdown.min.js', 'all', 96, array('jquery', 'otw-shortcode-makeplugin'));
        $this->add_external_lib('js', 'otw-shortcode-core', $this->component_url . 'js/otw_shortcode_core.js', 'all', 99, array('jquery'));
        $this->add_external_lib('js', 'otw-shortcode', $this->component_url . 'js/otw_shortcode.js', 'all', 100);
        $this->add_external_lib('js', 'otw-shortcode_live_preview', $this->component_url . 'js/otw_shortcode_live_preview.js', 'live_preview', 200);
    }

    /**
     * Applay all settings to shortcode
     * @return \Otw_Shortcode_Countdown
     */
    public function apply_settings() {
        $this->_applyBoxShadow();
        $this->_applyCountdownBordersColor();
        $this->_applyCountdownBordersRounded();
        $this->_applyCountdownBordersStyle();
        $this->_applyCountdownBordersWidth();
        $this->_applyCountdownPatterns();
        $this->_applySize();
        $this->_applyBackgrounds();
        $this->_applyClockColors();
        $this->_applyLabelColors();
        $this->_applyTimezones();
    }

    /**
     * Set dropdown settings for "Icon Colors"
     * @return \Otw_Shortcode_Clientslider
     */
    protected function _applyClockColors() {
        $this->settings['clock_colors'] = $this->getColors();
        $this->settings['default_clock_colors'] = '';
        return $this;
    }

    protected function _applyLabelColors() {
        $this->settings['label_colors'] = $this->getColorsLabels();
        $this->settings['default_label_colors'] = '';
        return $this;
    }

    protected function _applyTimezones() {
        $this->settings['timezone'] = $this->getTimezones();
        $this->settings['default_timezone'] = '';
        return $this;
    }

    protected function getTimezones() {
        $zones = timezone_identifiers_list();
        $locations = array();
        $locations[''] = '';
        foreach ($zones as $zone) {
            $zone_exploded = explode('/', $zone); // 0 => Continent, 1 => City
            
            if (
                    $zone_exploded[0] == 'Africa' ||
                    $zone_exploded[0] == 'America' ||
                    $zone_exploded[0] == 'Antarctica' ||
                    $zone_exploded[0] == 'Arctic' ||
                    $zone_exploded[0] == 'Asia' ||
                    $zone_exploded[0] == 'Atlantic' ||
                    $zone_exploded[0] == 'Australia' ||
                    $zone_exploded[0] == 'Europe' ||
                    $zone_exploded[0] == 'Indian' ||
                    $zone_exploded[0] == 'Pacific'
            ) {
                if (isset($zone_exploded[1]) != '') {
                    $locations[$zone] = $zone_exploded[0] . ' - ' . $zone_exploded[1]; // Creates array(DateTimeZone => 'Friendly name')
                }
            }
        }

        return $locations;
    }

    /**
     * Get text colors types
     * @return array
     */
    public function getColors() {
        return array(
            '' => $this->get_label('Default'),
            'otw-b-countdown-white-text' => $this->get_label('White Flat'),
            'otw-b-countdown-blue-flat-text' => $this->get_label('Blue Flat'),
            'otw-b-countdown-bluesky-flat-text' => $this->get_label('Bluesky Flat'),
            'otw-b-countdown-darkblue-flat-text' => $this->get_label('Darkblue Flat'),
            'otw-b-countdown-purple-flat-text' => $this->get_label('Purple Flat'),
            'otw-b-countdown-magenta-flat-text' => $this->get_label('Magenta Flat'),
            'otw-b-countdown-pink-flat-text' => $this->get_label('Pink Flat'),
            'otw-b-countdown-yellow-flat-text' => $this->get_label('Yellow Flat'),
            'otw-b-countdown-green-flat-text' => $this->get_label('Green Flat'),
            'otw-b-countdown-greenyellow-flat-text' => $this->get_label('Greenyellow Flat'),
            'otw-b-countdown-orange-flat-text' => $this->get_label('Orange Flat'),
            'otw-b-countdown-red-flat-text' => $this->get_label('Red Flat')
        );
    }

    /**
     * Get text colors types
     * @return array
     */
    public function getColorsLabels() {
        return array(
            '' => $this->get_label('Default'),
            'otw-b-countdown-white-text-period' => $this->get_label('White Flat'),
            'otw-b-countdown-blue-flat-text-period' => $this->get_label('Blue Flat'),
            'otw-b-countdown-bluesky-flat-text-period ' => $this->get_label('Bluesky Flat'),
            'otw-b-countdown-darkblue-flat-text-period ' => $this->get_label('Darkblue Flat'),
            'otw-b-countdown-purple-flat-text-period ' => $this->get_label('Purple Flat'),
            'otw-b-countdown-magenta-flat-text-period' => $this->get_label('Magenta Flat'),
            'otw-b-countdown-pink-flat-text-period ' => $this->get_label('Pink Flat'),
            'otw-b-countdown-yellow-flat-text-period' => $this->get_label('Yellow Flat'),
            'otw-b-countdown-green-flat-text-period ' => $this->get_label('Green Flat'),
            'otw-b-countdown-greenyellow-flat-text-period ' => $this->get_label('Greenyellow Flat'),
            'otw-b-countdown-orange-flat-text-period' => $this->get_label('Orange Flat'),
            'otw-b-countdown-red-flat-text-period' => $this->get_label('Red Flat')
        );
    }

    /**
     * Get Backgrounds
     * @return array
     */
    public function getBackgrounds() {
        return array(
            '' => $this->get_label('Default'),
            'otw-b-countdown-white-bgr' => $this->get_label('White Flat'),
            'otw-b-countdown-blue-flat-bgr' => $this->get_label('Blue Flat'),
            'otw-b-countdown-bluesky-flat-bgr' => $this->get_label('Bluesky Flat'),
            'otw-b-countdown-darkblue-flat-bgr' => $this->get_label('Darkblue Flat'),
            'otw-b-countdown-purple-flat-bgr' => $this->get_label('Purple Flat'),
            'otw-b-countdown-magenta-flat-bgr' => $this->get_label('Magenta Flat'),
            'otw-b-countdown-pink-flat-bgr' => $this->get_label('Pink Flat'),
            'otw-b-countdown-yellow-flat-bgr' => $this->get_label('Yellow Flat'),
            'otw-b-countdown-green-flat-bgr' => $this->get_label('Green Flat'),
            'otw-b-countdown-greenyellow-flat-bgr' => $this->get_label('Greenyellow Flat'),
            'otw-b-countdown-orange-flat-bgr' => $this->get_label('Orange Flat'),
            'otw-b-countdown-red-flat-bgr' => $this->get_label('Red Flat')
        );
    }

    /**
     * Set dropdown settings for "Button Backgrounds"
     * @return \Otw_Shortcode_Clientslider
     */
    protected function _applyBackgrounds() {
        $this->settings['content_button_background'] = $this->getBackgrounds();
        $this->settings['default_content_button_background'] = '';
        return $this;
    }

    /**
     * Set dropdown settings for "Box Shadow"
     * @return \Otw_Shortcode_Clientslider
     */
    protected function _applyBoxShadow() {
        $this->settings['box_shadow'] = $this->getShadows();
        $this->settings['default_box_shadow'] = '';
        return $this;
    }

    /**
     * Get general shadows
     * @return array
     */
    function getShadows() {
        return array(
            '' => $this->get_label('None(default)'),
            'shadow-b-small' => $this->get_label('Small'),
            'shadow-b-medium' => $this->get_label('Medium'),
            'shadow-b-large' => $this->get_label('Large'),
            'shadow-b-giant' => $this->get_label('Giant')
        );
    }

    /**
     * Return border rounded style 
     * 
     * @return array
     */
    private function _getCountdownBordersRounded() {
        return array(
            '' => $this->get_label('None (Default)'),
            'otw-b-countdown-rounded-small' => $this->get_label('Small'),
            'otw-b-countdown-rounded-medium' => $this->get_label('Medium'),
            'otw-b-countdown-rounded-large' => $this->get_label('Large'),
            'otw-b-countdown-circle' => $this->get_label('circle'),
        );
    }

    /**
     * Apply settings for countdown rounded styles
     * @return void;
     */
    private function _applyCountdownBordersRounded() {
        $this->settings['c_bd_rounded'] = $this->_getCountdownBordersRounded();
        $this->settings['default_c_bd_rounded'] = '';
    }

    /**
     * Return Countdown borders width
     * @return array
     */
    private function _getCountdownBordersWidth() {
        return array(
            '' => $this->get_label('None (Default)'),
            'otw-b-countdown-bd-1px' => $this->get_label('1px'),
            'otw-b-countdown-bd-2px' => $this->get_label('2px'),
            'otw-b-countdown-bd-3px' => $this->get_label('3px'),
        );
    }

    /**
     * Apply settings for border widths
     * @return void
     */
    private function _applyCountdownBordersWidth() {
        $this->settings['c_bd_width'] = $this->_getCountdownBordersWidth();
        $this->settings['default_c_bd_width'] = '';
    }

    /**
     * Return border styles
     * @return array
     */
    private function _getCountdownBordersStyle() {
        return array(
            '' => $this->get_label('None (Default)'),
            'otw-b-countdown-bd-solid' => $this->get_label('Solid'),
            'otw-b-countdown-bd-dashed' => $this->get_label('Dashed'),
            'otw-b-countdown-bd-dotted' => $this->get_label('Dotted'),
        );
    }

    /**
     * Apply settings for border style
     * @return void
     */
    private function _applyCountdownBordersStyle() {
        $this->settings['c_bd_style'] = $this->_getCountdownBordersStyle();
        $this->settings['default_c_bd_style'] = '';
    }

    /**
     * Return border colors for countdowns
     * @return array
     */
    private function _getCountdownBordersColor() {
        return array(
            '' => $this->get_label('None (Default)'),
            'otw-b-countdown-grey-bd' => $this->get_label(' Grey Flat'),
            'otw-b-countdown-white-bd' => $this->get_label('White Flat'),
            'otw-b-countdown-blue-flat-bd' => $this->get_label('Blue Flat'),
            'otw-b-countdown-bluesky-flat-bd' => $this->get_label('Bluesky Flat'),
            'otw-b-countdown-darkblue-flat-bd' => $this->get_label('Darkblue Flat'),
            'otw-b-countdown-purple-flat-bd' => $this->get_label('Purple Flat'),
            'otw-b-countdown-magenta-flat-bd' => $this->get_label('Magenta Flat'),
            'otw-b-countdown-pink-flat-bd' => $this->get_label('Pink Flat'),
            'otw-b-countdown-yellow-flat-bd' => $this->get_label('Yellow Flat'),
            'otw-b-countdown-green-flat-bd' => $this->get_label('Green Flat'),
            'otw-b-countdown-greenyellow-flat-bd' => $this->get_label('Greenyellow Flat'),
            'otw-b-countdown-orange-flat-bd' => $this->get_label('Orange Flat'),
            'otw-b-countdown-red-flat-bd' => $this->get_label('Red Flat'),
        );
    }

    /**
     * Apply settings for borders color
     * @return void
     */
    private function _applyCountdownBordersColor() {

        $this->settings['c_bd_color'] = $this->_getCountdownBordersColor();
        $this->settings['default_c_bd_color'] = '';
    }

    /**
     * Register external libs to admin and front side
     * @return void;
     */
    private function _getCountdownPatterns() {
        return array(
            '' => $this->get_label('None (Default)'),
            'otw-b-countdown-pattern otw-b-countdown-pattern-1' => $this->get_label('Pattern 1'),
            'otw-b-countdown-pattern otw-b-countdown-pattern-2' => $this->get_label('Pattern 2'),
            'otw-b-countdown-pattern otw-b-countdown-pattern-3' => $this->get_label('Pattern 3'),
            'otw-b-countdown-pattern otw-b-countdown-pattern-4' => $this->get_label('Pattern 4'),
            'otw-b-countdown-pattern otw-b-countdown-pattern-5' => $this->get_label('Pattern 5'),
            'otw-b-countdown-pattern otw-b-countdown-pattern-6' => $this->get_label('Pattern 6'),
            'otw-b-countdown-pattern otw-b-countdown-pattern-7' => $this->get_label('Pattern 7'),
            'otw-b-countdown-pattern otw-b-countdown-pattern-8' => $this->get_label('Pattern 8'),
            'otw-b-countdown-pattern otw-b-countdown-pattern-9' => $this->get_label('Pattern 9'),
            'otw-b-countdown-pattern otw-b-countdown-pattern-10' => $this->get_label('Pattern 10'),
        );
    }

    /**
     * Apply settings for patterns
     * @return void
     */
    private function _applyCountdownPatterns() {
        $this->settings['c_patterns'] = $this->_getCountdownPatterns();
        $this->settings['default_c_patterns'] = '';
    }

    /**
     * Apply settings for clock sizes
     */
    private function _applySize() {
        $this->settings['c_bd_size'] = $this->_getCountdownSize();
        $this->settings['default_c_bd_sizes'] = '';
    }

    /**
     * Return clock sizes 
     * @return array
     */
    private function _getCountdownSize() {
        return array(
            '' => $this->get_label('Normal (Default)'),
            'otw-b-countdown-large ' => $this->get_label('Large'),
        );
    }

    /**
     * 
     * @param type $attributes
     * @return string
     */
    public function build_shortcode_code($attributes) {
        $code = '';

        if (!empty($attributes['countdown_days']) && !is_numeric($attributes['countdown_days'])) {
            $this->add_error($this->get_label('The field with days is not correct'));
        }
        if (!empty($attributes['countdown_hours']) && !is_numeric($attributes['countdown_hours'])) {
            $this->add_error($this->get_label('The field with hours is not correct'));
        }
        if (!empty($attributes['countdown_minutes']) && !is_numeric($attributes['countdown_minutes'])) {
            $this->add_error($this->get_label('The field with minutes is not correct'));
        }
        if (!empty($attributes['countdown_seconds']) && !is_numeric($attributes['countdown_seconds'])) {
            $this->add_error($this->get_label('The field with seconds is not correct'));
        }
        if (empty($attributes['timezone'])) {
            $this->add_error($this->get_label('Timezone is required field'));
        }




        if (!$this->has_error) {
            date_default_timezone_set($attributes['timezone']);
            if (version_compare(PHP_VERSION, '5.3.0', '>=')) {
                $date = new DateTime(date('Y/m/d H:i:s', time()));
                //$date->setTimestamp(time());
                if (!empty($attributes['countdown_days'])) {
                    $day = 'P' . $attributes['countdown_days'] . 'D';
                    $date->add(new DateInterval($day)); //add days
                }
                if (!empty($attributes['countdown_hours'])) {
                    $hours = 'PT' . $attributes['countdown_hours'] . 'H';
                    $date->add(new DateInterval($hours)); //add hours
                }

                if (!empty($attributes['countdown_minutes'])) {
                    $minutes = 'PT' . $attributes['countdown_minutes'] . 'M';
                    $date->add(new DateInterval($minutes)); //add min
                }
                if (!empty($attributes['countdown_seconds'])) {
                    $seconds = 'PT' . $attributes['countdown_seconds'] . 'S';
                    $date->add(new DateInterval($seconds)); //add seconds
                }

                if (empty($attributes['countdown_time'])) {
                    $attributes['countdown_time'] = $date->getTimestamp();
                }
            } else {

                $date = date('Y-m-d H:i:s', time());
                $mask = '';
                if (!empty($attributes['countdown_days'])) {
                    $mask .= ' + ' . $attributes['countdown_days'] . ' days';
                }
                if (!empty($attributes['countdown_hours'])) {
                    $mask .= $attributes['countdown_hours'] . ' hours';
                }
                if (!empty($attributes['countdown_minutes'])) {
                    $mask .= $attributes['countdown_minutes'] . ' minutes';
                }
                if (!empty($attributes['countdown_seconds'])) {
                    $mask .= $attributes['countdown_seconds'] . ' seconds';
                }
                if (!empty($mask)) {
                    $date = strtotime($date . $mask);
                }
                if (empty($attributes['countdown_time'])) {
                    $attributes['countdown_time'] = $date;
                }
            }

            $code = '[otw_shortcode_countdown';
            $code .= $this->format_attribute('countdown_time', 'countdown_time', $attributes);
            $code .= $this->format_attribute('countdown_id_name', 'countdown_id_name', $attributes);
            $code .= $this->format_attribute('countdown_days', 'countdown_days', $attributes);
            $code .= $this->format_attribute('countdown_hours', 'countdown_hours', $attributes);
            $code .= $this->format_attribute('countdown_minutes', 'countdown_minutes', $attributes);
            $code .= $this->format_attribute('countdown_seconds', 'countdown_seconds', $attributes);
            $code .= $this->format_attribute('timezone', 'timezone', $attributes);
            $code .= $this->format_attribute('c_bd_width', 'c_bd_width', $attributes);
            $code .= $this->format_attribute('c_bd_style', 'c_bd_style', $attributes);
            $code .= $this->format_attribute('c_bd_color', 'c_bd_color', $attributes);
            $code .= $this->format_attribute('c_bd_size', 'c_bd_size', $attributes);
            $code .= $this->format_attribute('c_bd_rounded', 'c_bd_rounded', $attributes);
            $code .= $this->format_attribute('content_button_background', 'content_button_background', $attributes);
            $code .= $this->format_attribute('clock_colors', 'clock_colors', $attributes);
            $code .= $this->format_attribute('label_colors', 'label_colors', $attributes);
            $code .= $this->format_attribute('c_patterns', 'c_patterns', $attributes);
//            $code .= $this->format_attribute('c_box_shadow', 'c_box_shadow', $attributes);
            $code .= $this->format_attribute('clock_custom_brd_color', 'clock_custom_brd_color', $attributes);
            $code .= $this->format_attribute('clock_custom_bgr_color', 'clock_custom_bgr_color', $attributes);
            $code .= $this->format_attribute('clock_custom_pattern_url', 'clock_custom_pattern_url', $attributes);
            $code .= $this->format_attribute('custom_class', 'custom_class', $attributes);
            $code .= ']';
            $code .= '[/otw_shortcode_countdown]';
            return $code;
        }
    }

    /**
     * Set the additional settings
     * @return string
     */
    public function build_shortcode_editor_custom_options() {
        $html = '';

        $source = array();
        if (isset($_POST['shortcode_object'])) {
            $source = $_POST['shortcode_object'];
        }

        $html .= parent::_generatePicker('clock_custom_brd_color', 'Clock  Custom border color', 'Choose your favorite color for border on this item', $source);
        $html .= parent::_generatePicker('clock_custom_bgr_color', 'Clock Custom background color', 'Choose your color for background on this item', $source);
        $html .= parent::_generateUploader('clock_custom_pattern_url', 'Clock Box Background Pattern URL', 'URL to a custom box background pattern.', $source);
        $html .= $this->_generateText('custom_class', 'Set your custom class', 'Extend style with your own CSS class', $source);

        return $html;
    }

    /**
     * Generate options as HTML string 
     * @return string
     */
    public function build_shortcode_editor_options() {
        $html = '';

        $source = array();
        if (isset($_POST['shortcode_object'])) {
            $source = $_POST['shortcode_object'];
        }
        if (empty($source['countdown_start'])) {
            $source['countdown_start'] = time();
        }
        $html .= $this->_generateSelect('timezone', 'Timezone', 'Set your timezone.', $source, 'timezone', 'default_tomezone');

//        $html .= $this->_generateText('countdown_id_name', 'Unique slug name', 'Set the unique ID for this contdown element. e.g( contdown-1, countdown-2)', $source);
        $html .= $this->_generateText('countdown_days', 'Set start day', 'Set day for countdown', $source);
        $html .= $this->_generateText('countdown_hours', 'Set start hours', 'Set hours for countdown', $source);
        $html .= $this->_generateText('countdown_minutes', 'Set start minutes', 'Set minutes for minutes', $source);
        $html .= $this->_generateText('countdown_seconds', 'Set start seconds', 'Set seconds for countdown', $source);
        $html .= $this->_generateSelect('c_bd_width', 'Border width', 'Set border width.', $source, 'c_bd_width', 'default_c_bd_width');
        $html .= $this->_generateSelect('c_bd_style', 'Border style', 'Choose border style.', $source, 'c_bd_style', 'default_c_bd_style');
        $html .= $this->_generateSelect('c_bd_color', 'Border color', 'Choose border color', $source, 'c_bd_color', 'default_c_bd_color');
        $html .= $this->_generateSelect('c_bd_rounded', 'Border rounded', 'Choose border rounded style', $source, 'c_bd_rounded', 'default_c_bd_rounded');
        $html .= $this->_generateSelect('c_bd_size', 'Box size', 'Choose size of clock', $source, 'c_bd_size', 'default_c_size');
        $html .= $this->_generateSelect('content_button_background', 'Background colors for clock', 'Choose background colors for clock items', $source, 'content_button_background', 'default_content_button_background');
        $html .= $this->_generateSelect('clock_colors', 'Clock font color', 'Choose your favorite color for clock', $source, 'clock_colors', 'default_clock_colors');
        $html .= $this->_generateSelect('label_colors', 'Clock Label font color', 'Choose your favorite color for clock labels', $source, 'label_colors', 'default_label_colors');
        $html .= $this->_generateSelect('c_patterns', 'Item pattern', 'Set the patterns for clock', $source, 'c_patterns', 'default_c_patterns');
//        $html .= $this->_generateSelect('c_box_shadow', 'Item shadow', 'Set shadow for clock', $source, 'box_shadow', 'default_box_shadow');


        return $html;
    }

    /**
     * Export end shortcode
     * @param array $attributes
     * @param string $content
     * @return string
     */
    public function display_shortcode($attributes, $content) {
        date_default_timezone_set($this->format_attribute('', 'timezone', $attributes));
        $html = '';
        $class = '';
        $ID = 'otw-' . rand(1, 1000000);
        $clock_custom_brd_color = false;
        $clock_custom_bgr_color = false;
        $clock_custom_pattern_url = false;
        $class = $this->append_attribute($class, $this->format_attribute('', 'c_bd_width', $attributes));
        $class = $this->append_attribute($class, $this->format_attribute('', 'c_bd_style', $attributes));
        $class = $this->append_attribute($class, $this->format_attribute('', 'c_bd_color', $attributes));
        $class = $this->append_attribute($class, $this->format_attribute('', 'c_bd_rounded', $attributes));
        $class = $this->append_attribute($class, $this->format_attribute('', 'c_bd_size', $attributes));
        $class = $this->append_attribute($class, $this->format_attribute('', 'c_patterns', $attributes));
//        $class = $this->append_attribute($class, $this->format_attribute('', 'c_box_shadow', $attributes));
        $class = $this->append_attribute($class, $this->format_attribute('', 'content_button_background', $attributes));
        $class = $this->append_attribute($class, $this->format_attribute('', 'clock_colors', $attributes));
        $class = $this->append_attribute($class, $this->format_attribute('', 'custom_class', $attributes));

        $ccolor = 'clock_custom_brd_color_' . microtime(false) . rand(1, 100302);
        $$ccolor = $this->format_attribute('', 'clock_custom_brd_color', $attributes);
        $html .= '<style>';
        if (!empty($$ccolor)) {
            $html .= '.' . $ID . ' .otw-countdown .otw_b_countdown-amount{ border-color: ' . $$ccolor . '!important;}' . PHP_EOL;
        }
        $cbgr = 'clock_custom_bgr_color_' . microtime(false) . rand(1, 100302);
        $$cbgr = $this->format_attribute('', 'clock_custom_bgr_color', $attributes);
        if (!empty($cbgr)) {
            $html .= '.' . $ID . ' .otw-countdown .otw_b_countdown-amount{ background-color: ' . $$cbgr . '!important;}' . PHP_EOL;
        }
        $cptu = 'clock_custom_pattern_url_' . microtime(false) . rand(1, 100302);
        $$cptu = $this->format_attribute('', 'clock_custom_pattern_url', $attributes);
        if (!empty($$cptu)) {
            $html .= '.' . $ID . ' .otw-countdown .otw_b_countdown-amount{ background: url(' . $$cptu . ') repeat!important;}' . PHP_EOL;
        }
        $html .= '</style>';

        $html .= '<div class="' . $this->format_attribute('', 'label_colors', $attributes) . ' otw-row ' . $ID . '">';
        $html .= '<div ';
        $html .= 'data-time="' . date('Y/m/d H:i:s', $this->format_attribute('', 'countdown_time', $attributes)) . '" ';
//        $html .= 'id="' . $this->format_attribute('', 'countdown_id_name', $attributes) . '"';
        $html .= ' class=" otw-countdown  ' . $class . ' "';
        $html .='></div>';
        $html .= '</div>';

        return $this->format_shortcode_output($html);
    }

}
