<?php
class OTW_Shortcode_Content_Box extends OTW_Shortcodes{
	
	public function __construct(){
		
		$this->has_custom_options = true;
		
		parent::__construct();
	}
	/**
	 * register external libs
	 */
	public function register_external_libs(){
	
		$this->add_external_lib( 'css', 'otw-shortcode-general_foundicons', $this->component_url.'css/general_foundicons.css', 'all', 10 );
		$this->add_external_lib( 'css', 'otw-shortcode-social_foundicons', $this->component_url.'css/social_foundicons.css', 'all', 20 );
		$this->add_external_lib( 'css', 'otw-shortcode', $this->component_url.'css/otw_shortcode.css', 'all', 100 );
	}
	/**
	 * apply settings
	 */
	public function apply_settings(){
		
		$this->settings = array(
		
			'title_style' => array(
				'otw-regular-title'  => $this->get_label( 'regular(default)' ),
				'otw-red-title-gradient'  => $this->get_label( 'red gradient' ),
				'otw-green-title-gradient'  => $this->get_label( 'green gradient' ),
				'otw-black-title-gradient'  => $this->get_label( 'black gradient' ),
				'otw-aqua-title-gradient'  => $this->get_label( 'aqua gradient' ),
				'otw-brown-title-gradient"'  => $this->get_label( 'brown gradient"' ),
				'otw-greenish-title-gradient'  => $this->get_label( 'greenish gradient' ),
				'otw-blue-title-gradient'  => $this->get_label( 'blue gradient' ),
				'otw-pink-title-gradient'  => $this->get_label( 'pink gradient' ),
				'otw-purple-title-gradient' => $this->get_label( 'purple gradient' ),
				'otw-silver-title-gradient' => $this->get_label( 'silver gradient' )
			),
			'default_title_style' => 'regular-title',
			
			'content_link_color' => array(
				'' => $this->get_label( 'default' ),
				'otw-red-link' => $this->get_label( 'red' ),
				'otw-orange-link' => $this->get_label( 'orange' ),
				'otw-green-link' => $this->get_label( 'green' ),
				'otw-greenish-link' => $this->get_label( 'greenish' ),
				'otw-aqua-link' => $this->get_label( 'aqua' ),
				'otw-blue-link' => $this->get_label( 'blue' ),
				'otw-pink-link' => $this->get_label( 'pink' ),
				'otw-purple-link' => $this->get_label( 'purple' ),
				'otw-silver-link' => $this->get_label( 'silver' ),
				'otw-brown-link' => $this->get_label( 'brown' ),
				'otw-black-link' => $this->get_label( 'black' )
			),
			'default_content_link_color' => '',
			
			'content_title_color' => array(
				'' => $this->get_label( 'default' ),
				'otw-red-title' => $this->get_label( 'red' ),
				'otw-orange-title' => $this->get_label( 'orange' ),
				'otw-green-title' => $this->get_label( 'green' ),
				'otw-greenish-title' => $this->get_label( 'greenish' ),
				'otw-aqua-title' => $this->get_label( 'aqua' ),
				'otw-blue-title' => $this->get_label( 'blue' ),
				'otw-pink-title' => $this->get_label( 'pink' ),
				'otw-purple-title' => $this->get_label( 'purple' ),
				'otw-silver-title' => $this->get_label( 'silver' ),
				'otw-brown-title' => $this->get_label( 'brown' ),
				'otw-black-title' => $this->get_label( 'black' )
			),
			'default_content_title_color' => '',
			
			'title_color' => array(
				'' => $this->get_label( 'default' ),
				'otw-white-text' => $this->get_label( 'white' ),
				'otw-red-text' => $this->get_label( 'red' ),
				'otw-orange-text' => $this->get_label( 'orange' ),
				'otw-green-text' => $this->get_label( 'green' ),
				'otw-greenish-text' => $this->get_label( 'greenish' ),
				'otw-aqua-text' => $this->get_label( 'aqua' ),
				'otw-blue-text' => $this->get_label( 'blue' ),
				'otw-pink-text' => $this->get_label( 'pink' ),
				'otw-purple-text' => $this->get_label( 'purple' ),
				'otw-silver-text' => $this->get_label( 'silver' ),
				'otw-brown-text' => $this->get_label( 'brown' ),
				'otw-black-text' => $this->get_label( 'black' )
			),
			'default_title_color' => '',
			
			'content_pattern' => array(
				'' => $this->get_label( 'none' ),
				'otw-pattern-1' => $this->get_label( 'pattern 1' ),
				'otw-pattern-2' => $this->get_label( 'pattern 2' ),
				'otw-pattern-3' => $this->get_label( 'pattern 3' ),
				'otw-pattern-4' => $this->get_label( 'pattern 4' ),
				'otw-pattern-5' => $this->get_label( 'pattern 5' )
			),
			'default_content_pattern' => '',
			
			'icon_types' => array(
				
				''                      => $this->get_label( 'none (Default)' ),
				'general foundicon-settings'      => $this->get_label( 'Settings' ),
				'general foundicon-heart'         => $this->get_label( 'Heart' ),
				'general foundicon-star'          => $this->get_label( 'Star' ),
				'general foundicon-plus'          => $this->get_label( 'Plus' ),
				'general foundicon-minus'         => $this->get_label( 'Minus' ),
				'general foundicon-checkmark'     => $this->get_label( 'Checkmark' ),
				'general foundicon-remove'        => $this->get_label( 'Remove' ),
				'general foundicon-mail'          => $this->get_label( 'Mail' ),
				'general foundicon-calendar'      => $this->get_label( 'Calendar' ),
				'general foundicon-page'          => $this->get_label( 'Page' ),
				'general foundicon-tools'         => $this->get_label( 'Tools' ),
				'general foundicon-globe'         => $this->get_label( 'Globe' ),
				'general foundicon-cloud'         => $this->get_label( 'Cloud' ),
				'general foundicon-error'         => $this->get_label( 'Error' ),
				'general foundicon-right-arrow'   => $this->get_label( 'Right arrow' ),
				'general foundicon-left-arrow'    => $this->get_label( 'Left arrow' ),
				'general foundicon-up-arrow'      => $this->get_label( 'Up arrow' ),
				'general foundicon-down-arrow'    => $this->get_label( 'Down arrow' ),
				'general foundicon-trash'         => $this->get_label( 'Trash' ),
				'general foundicon-add-doc'       => $this->get_label( 'Add Doc' ),
				'general foundicon-edit'          => $this->get_label( 'Edit' ),
				'general foundicon-lock'          => $this->get_label( 'Lock' ),
				'general foundicon-unlock'        => $this->get_label( 'Unlock' ),
				'general foundicon-refresh'       => $this->get_label( 'Refresh' ),
				'general foundicon-paper-clip'    => $this->get_label( 'Paper clip' ),
				'general foundicon-video'         => $this->get_label( 'Video' ),
				'general foundicon-photo'         => $this->get_label( 'Photo' ),
				'general foundicon-graph'         => $this->get_label( 'Graph' ),
				'general foundicon-idea'          => $this->get_label( 'Idea' ),
				'general foundicon-mic'           => $this->get_label( 'Mic' ),
				'general foundicon-cart'          => $this->get_label( 'Cart' ),
				'general foundicon-address-book'  => $this->get_label( 'Address book' ),
				'general foundicon-compass'       => $this->get_label( 'Compass' ),
				'general foundicon-flag'          => $this->get_label( 'Flag' ),
				'general foundicon-location'      => $this->get_label( 'Location' ),
				'general foundicon-clock'         => $this->get_label( 'Clock' ),
				'general foundicon-folder'        => $this->get_label( 'Folder' ),
				'general foundicon-inbox'         => $this->get_label( 'Inbox' ),
				'general foundicon-website'       => $this->get_label( 'Website' ),
				'general foundicon-smiley'        => $this->get_label( 'Smiley' ),
				'general foundicon-search'        => $this->get_label( 'Search' ),
				'general foundicon-phone'         => $this->get_label( 'Phone' ),
				
				'social foundicon-thumb-up'       => $this->get_label( 'Thumb up' ),
				'social foundicon-thumb-down'     => $this->get_label( 'Thumb down' ),
				'social foundicon-rss'            => $this->get_label( 'Rss' ),
				'social foundicon-facebook'       => $this->get_label( 'Facebook' ),
				'social foundicon-twitter'        => $this->get_label( 'Twitter' ),
				'social foundicon-pinterest'      => $this->get_label( 'Pinterest' ),
				'social foundicon-github'         => $this->get_label( 'Github' ),
				'social foundicon-path'           => $this->get_label( 'Path' ),
				'social foundicon-linkedin'       => $this->get_label( 'LinkedIn' ),
				'social foundicon-dribbble'       => $this->get_label( 'Dribbble' ),
				'social foundicon-stumble-upon'   => $this->get_label( 'Stumble upon' ),
				'social foundicon-behance'        => $this->get_label( 'Behance' ),
				'social foundicon-reddit'         => $this->get_label( 'Reddit' ),
				'social foundicon-google-plus'    => $this->get_label( 'Google plus' ),
				'social foundicon-youtube'        => $this->get_label( 'Youtube' ),
				'social foundicon-vimeo'          => $this->get_label( 'Vimeo' ),
				'social foundicon-clickr'         => $this->get_label( 'Clickr' ),
				'social foundicon-slideshare'     => $this->get_label( 'Slideshare' ),
				'social foundicon-picassa'        => $this->get_label( 'Picassa' ),
				'social foundicon-skype'          => $this->get_label( 'Skype' ),
				'social foundicon-instagram'      => $this->get_label( 'instagram' ),
				'social foundicon-foursquare'     => $this->get_label( 'Foursquare' ),
				'social foundicon-delicious'      => $this->get_label( 'Delicious' ),
				'social foundicon-chat'           => $this->get_label( 'Chat' ),
				'social foundicon-torso'          => $this->get_label( 'Torso' ),
				'social foundicon-tumblr'         => $this->get_label( 'Tumblr' ),
				'social foundicon-video-chat'     => $this->get_label( 'Video chat' ),
				'social foundicon-digg'           => $this->get_label( 'Digg' ),
				'social foundicon-wordpress'      => $this->get_label( 'Wordpress' )
			),
			'default_icon_type' => '',

		);
		
	}
	
	/**
	 * Shortcode admin interface
	 */
	public function build_shortcode_editor_options(){
		
		$html = '';
		
		$source = array();
		if( isset( $_POST['shortcode_object'] ) ){
			$source = $_POST['shortcode_object'];
		}
		
		$html .= OTW_Form::text_input( array( 'id' => 'otw-shortcode-element-title', 'label' => $this->get_label( 'Title' ), 'description' => $this->get_label( 'The title for the box.' ), 'parse' => $source  )  );
		
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-title_style', 'label' => $this->get_label( 'Title style' ), 'description' => $this->get_label( 'The style for the title.' ), 'parse' => $source, 'options' => $this->settings['title_style'], 'value' => $this->settings['default_title_style'] ) );
		
		$html .= OTW_Form::text_input( array( 'id' => 'otw-shortcode-element-sub_title', 'label' => $this->get_label( 'Content title' ), 'description' => $this->get_label( 'The sub title for the box.' ), 'parse' => $source  )  );
		
		$html .= OTW_Form::text_area( array( 'id' => 'otw-shortcode-element-content', 'label' => $this->get_label( 'Content' ), 'description' => $this->get_label( 'The content text. HTML is allowed.' ), 'parse' => $source )  );
		
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-title_color', 'label' => $this->get_label( 'Title color' ), 'description' => $this->get_label( 'The titles color. None means site default color.' ), 'parse' => $source, 'options' => $this->settings['title_color'], 'value' => $this->settings['default_title_color'] ) );
		
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-content_title_color', 'label' => $this->get_label( 'Content title color' ), 'description' => $this->get_label( 'The content titles color. None means site default color.' ), 'parse' => $source, 'options' => $this->settings['content_title_color'], 'value' => $this->settings['default_content_title_color'] ) );
		
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-content_link_color', 'label' => $this->get_label( 'Content link color' ), 'description' => $this->get_label( 'The content link color. None means site default link color.' ), 'parse' => $source, 'options' => $this->settings['content_link_color'], 'value' => $this->settings['default_content_link_color'] ) );
		
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-content_pattern', 'label' => $this->get_label( 'Content pattern' ), 'description' => $this->get_label( 'Choose a pattern for the content.' ), 'parse' => $source, 'options' => $this->settings['content_pattern'], 'value' => $this->settings['default_content_pattern'] ) );
		
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-icon_type', 'label' => $this->get_label( 'Icon Type' ), 'description' => $this->get_label( 'The icons here are based on foundation icon fonts.' ), 'parse' => $source, 'options' => $this->settings['icon_types'], 'value' => $this->settings['default_icon_type'] )  );
		
		
		return $html;
	}
	
	/**
	 * Shortcode admin interface custom options
	 */
	public function build_shortcode_editor_custom_options(){
		
		$html = '';
		
		$source = array();
		if( isset( $_POST['shortcode_object'] ) ){
			$source = $_POST['shortcode_object'];
		}
		
		$html .= OTW_Form::uploader( array( 'id' => 'otw-shortcode-element-icon_url', 'label' => $this->get_label( 'Icon URL' ), 'description' => $this->get_label( 'Url to a custom icon.' ), 'alternative_description' => $this->get_label( 'URL to your own icon. Note that the icon size will be displayed accordingly to the font size.' ), 'parse' => $source )  );
		
		$html .= OTW_Form::text_input( array( 'id' => 'otw-shortcode-element-css_class', 'label' => $this->get_label( 'CSS Class' ), 'description' => $this->get_label( 'If you\'d like to style this element separately enter a name here. A CSS class with this name will be available for you to style this particular element..' ), 'parse' => $source )  );
		
		return $html;
	}
	
	/** build shortcode
	 *
	 *  @param array
	 *  @return string
	 */
	public function build_shortcode_code( $attributes ){
		
		$code = '';
		
		if( !$this->has_error ){
		
			$code = '[otw_shortcode_content_box';
			
			$code .= $this->format_attribute( 'title', 'title', $attributes, false, '', true );
			
			$code .= $this->format_attribute( 'title_style', 'title_style', $attributes );
			
			$code .= $this->format_attribute( 'sub_title', 'sub_title', $attributes, false, '', true );
			
			$code .= $this->format_attribute( 'content_link_color', 'content_link_color', $attributes );
			
			$code .= $this->format_attribute( 'title_color', 'title_color', $attributes );
			
			$code .= $this->format_attribute( 'content_title_color', 'content_title_color', $attributes );
			
			$code .= $this->format_attribute( 'content_pattern', 'content_pattern', $attributes, false, '', true );
			
			$code .= $this->format_attribute( 'icon_type', 'icon_type', $attributes, false, '', true );
			
			$code .= $this->format_attribute( 'icon_url', 'icon_url', $attributes );
			
			$code .= $this->format_attribute( 'css_class', 'css_class', $attributes, false, '', true  );	
			
			$code .= ']';
			
			$code .= ( $attributes['content'] );
			
			
			$code .= '[/otw_shortcode_content_box]';
		}
		
		return $code;

	}
	
	/**
	 * Display shortcode
	 */
	public function display_shortcode( $attributes, $content ){
		
		$html = '<div';
		
		/*class attributes*/
		$class = 'otw-sc-contentbox';
		
		$class .= $this->format_attribute( '', 'css_class', $attributes, false, $class );
		
		if( strlen( $class ) ){
			$html .= ' class="'.$class.'"';
		}
		/*end class attributes*/
		
		/*style attribute*/
		$style = '';
		
		if( strlen( $style ) ){
			$html .= ' style="'.$style.'"';
		}
		
		$html .= '>';
		$html .= '<h3';
		
		$title_class = 'otw-contentbox-title';
		
		$title_class .= $this->format_attribute( '', 'title_style', $attributes, false, $title_class );
		
		$title_class .= $this->format_attribute( '', 'title_color', $attributes, false, $title_class );
		
		if( strlen( $title_class ) ){
			$html .= ' class="'.$title_class.'"';
		}
		
		$html .= '>';
		
		if( $icon_type = $this->format_attribute( '', 'icon_type', $attributes, false, '' ) ){
			$html .= '<i class="'.$icon_type.'"> </i>';
		}
		
		if( $icon_url = $this->format_attribute( '', 'icon_url', $attributes, false, '' ) ){
			$html .= '<img src="'.$icon_url.'" alt="icon" title="icon" />';
		}
		
		$html .= $this->format_attribute( '', 'title', $attributes, false, '' );
		
		$html .= '</h3>';
		
		$html .= '<div';
		
		$content_class = 'contentbox-content';
		
		$content_class .= $this->format_attribute( '', 'content_pattern', $attributes, false, $content_class );
		
		$content_class .= $this->format_attribute( '', 'content_link_color', $attributes, false, $content_class );
		
		$content_class .= $this->format_attribute( '', 'content_title_color', $attributes, false, $content_class );
		
		if( strlen( $content_class ) ){
			$html .= ' class="'.$content_class.'"';
		}
		
		$html .= '>';
		
		if( $sub_title = $this->format_attribute( '', 'sub_title', $attributes, false, '' ) ){
			$html .= '<h5>'.$sub_title.'</h5>';
		}
		
		$html .= '<p>'.nl2br( $content ).'</p>';
		
		$html .= '</div>';
		
		$html .= '</div>';
		
		return $this->format_shortcode_output( $html );
	}
}
