<?php

/**
 * General Workflow for Otw_Shortcode_Clientslider
 *
 * @author Станимир | OTW Design
 * @ver 1.0
 */
class Otw_Shortcode_Clientslider extends OTW_Shortcodes {

    function __construct() {
        parent::__construct();
        $this->has_custom_options = true;
    }

    /**
     * Register externel lybs 
     */
    function register_external_libs() {
        $this->add_external_lib('css', 'otw-shortcode-general_foundicons', $this->component_url . 'css/general_foundicons.css', 'all', 10);
        $this->add_external_lib('css', 'otw-shortcode-social_foundicons', $this->component_url . 'css/social_foundicons.css', 'all', 20);
        $this->add_external_lib('css', 'otw-grid', $this->component_url . '../' . 'otw_grid_manager/' . 'css/otw-grid.css', 'all', 100);
        $this->add_external_lib('css', 'otw-shortcode', $this->component_url . 'css/otw_shortcode.css', 'all', 120);
        $this->add_external_lib('css', 'otw-caroucel', $this->component_url . 'css/owl.carousel.css', 'all', 5);
        $this->add_external_lib('css', 'otw-lifeprev', $this->component_url . 'css/otw_shortcode_preview.css', 'live_preview', 130, array('otw-shortcode'));

        $this->add_external_lib('js', 'otw-anish', $this->component_url . 'js/jquery.animate-shadow-min.js', 'all', 98, array('jquery'));
        $this->add_external_lib('js', 'otw-quicks', $this->component_url . 'js/jquery.quicksand.js', 'all', 99, array('otw-anish'));
        $this->add_external_lib('js', 'otw-carouceljs', $this->component_url . 'js/owl.carousel.min.js', 'all', 100, array('otw-quicks'));
        $this->add_external_lib('js', 'otw-shortcode-core', $this->component_url . 'js/otw_shortcode_core.js', 'all', 129, array('otw-carouceljs'));
        $this->add_external_lib('js', 'otw-shortcode', $this->component_url . 'js/otw_shortcode.js', 'all', 130, array('otw-shortcode-core'));
        $this->add_external_lib('js', 'otw-shortcode_live_preview', $this->component_url . 'js/otw_shortcode_live_preview.js', 'live_preview', 200, array('otw-shortcode'));
//        $this->add_external_lib('css', 'otw-shortcode_scrolling', $this->component_url . 'css/scroll_for_preview.css?' . md5(time()), 'all', 130);

        return $this;
    }

    /**
     * Settings for num items 
     * @return void
     */
    private function _getNumItems() {
        return array(
            '1' => $this->get_label('1 Items'),
            '2' => $this->get_label('2 Items(default)'),
            '3' => $this->get_label('3 Items'),
            '4' => $this->get_label('4 Items'),
            '5' => $this->get_label('5 Items'),
            '6' => $this->get_label('6 Items'),
            '7' => $this->get_label('7 Items'),
            '8' => $this->get_label('8 Items'),
            '9' => $this->get_label('9 Items'),
            '10' => $this->get_label('10 Items'),
            '11' => $this->get_label('11 Items'),
            '12' => $this->get_label('12 Items'),
            '13' => $this->get_label('13 Items'),
            '14' => $this->get_label('14 Items'),
            '15' => $this->get_label('15 Items'),
            '16' => $this->get_label('16 Items'),
            '17' => $this->get_label('17 Items'),
            '18' => $this->get_label('18 Items'),
            '19' => $this->get_label('19 Items'),
            '20' => $this->get_label('20 Items')
        );
    }

    /**
     * Apply the settings for num items 
     */
    private function _applyNumItems() {
        $this->settings['num_items'] = $this->_getNumItems();
        $this->settings['default_num_items'] = 2;
    }

    /**
     * Get All allowed animations
     * @return array
     */
    public function getAnimations() {
        return array(
            '' => $this->get_label('None(Default)'),
            'animated-b animated-b-rotate' => $this->get_label('Rotate'),
            'animated-b animated-b-bounce' => $this->get_label('Bounce'),
            'animated-b animated-b-wobble' => $this->get_label('Wobble'),
            'animated-b animated-b-rubberBand' => $this->get_label('RubberBand'),
            'animated-b animated-b-swing' => $this->get_label('Swing'),
            'animated-b animated-b-tada' => $this->get_label('Tada'),
            'animated-b animated-b-rubberBand' => $this->get_label('RubberBand')
        );
    }

    /**
     * Set dropdown settings for "Logo Animations"
     * @return \Otw_Shortcode_Clientslider
     */
    protected function _applyLogoAnimations() {
        $this->settings['logo_animations'] = $this->getAnimations();
        $this->settings['default_logo_animations'] = '';
        return $this;
    }

    /**
     * get settings for auto scrolling
     * @return array
     */
    public function getAutoScrolling() {
        return array(
            'true' => $this->get_label('Yes(Default)'),
            'false' => $this->get_label('No'),
        );
    }

    /**
     * Apply settings
     * @return \Otw_Shortcode_Clientslider
     */
    protected function _applyAutoScrolling() {
        $this->settings['auto_scolling'] = $this->getAutoScrolling();
        $this->settings['default_auto_scolling'] = 'true';
        return $this;
    }

    /**
     * Get options for show navi
     * @return array
     */
    public function getShowNavigation() {
        return array(
            'true' => $this->get_label('Yes(Default)'),
            'false' => $this->get_label('No'),
        );
    }

    /**
     * Apply show navi
     * @return \Otw_Shortcode_Clientslider
     */
    protected function _applyShowNavigations() {
        $this->settings['show_navigations'] = $this->getAutoScrolling();
        $this->settings['default_show_navigations'] = 'true';
        return $this;
    }

    /**
     * Applay all settings to shortcode
     */
    public function apply_settings() {
        $this->_applyAutoScrolling();
        $this->_applyLogoAnimations();
        $this->_applyNumItems();
        $this->_applyShowNavigations();
    }

    /**
     * 
     * @param type $attributes
     * @return string
     */
    public function build_shortcode_code($attributes) {
        $code = '';
        if (!$this->has_error) {
            $code .= '[otw_shortcode_clientslider';
            $total_elements = $this->format_attribute('', 'num_items', $attributes);
            $code .= $this->format_attribute('num_items', 'num_items', $attributes);
            for ($ni = 1; $ni <= $total_elements; $ni++) {
                $code .= $this->format_attribute('upload_logo_' . $ni . '_url', 'upload_logo_' . $ni . '_url', $attributes);
            }
            $code .= $this->format_attribute('logo_animations', 'logo_animations', $attributes);
            $code .= $this->format_attribute('auto_scolling', 'auto_scolling', $attributes);
            $code .= $this->format_attribute('show_navigations', 'show_navigations', $attributes);
            $code .= $this->format_attribute('custom_class', 'custom_class', $attributes);
            $code .= ']';
            $code .= '[/otw_shortcode_clientslider]';
            return $code;
        }
    }

    /**
     * Set the additional settings
     * @return string
     */
    public function build_shortcode_editor_custom_options() {
        $html = '';

        $source = array();
        if (isset($_POST['shortcode_object'])) {
            $source = $_POST['shortcode_object'];
        }
        $html .= $this->_generateText('custom_class', 'Custom CSS Class ', 'If you\'d like to style this element separately enter a name here. A CSS class with this name will be available for you to style this particular element..', $source);
        return $html;
    }

    /**
     * Generate options as HTML string 
     * @return string
     */
    public function build_shortcode_editor_options() {
        $html = '';

        $source = array();
        if (isset($_POST['shortcode_object'])) {
            $source = $_POST['shortcode_object'];
        }

        //Get default value for items in init time
        $total_elements = $this->settings['default_num_items'];
        //check for set items
        if (isset($source['otw-shortcode-element-num_items'])) {
            $total_elements = $source['otw-shortcode-element-num_items'];
        }
        $html .= $this->_generateSelect('num_items', 'Number of Itmes', 'Select number of items.', $source, 'num_items', 'default_num_items', 1); //$this->format_attribute('num_items', 'num_items', $attributes);
        for ($ni = 1; $ni <= $total_elements; $ni++) {
            $html .= $this->_generateUploader('upload_logo_' . $ni . '_url', 'logo ' . $ni, 'Upload Logo ' . $ni, $source);
        }
        $html .= $this->_generateSelect('logo_animations', 'Animation', 'Choose animation type.', $source, 'logo_animations', 'default_logo_animations'); //$this->format_attribute('num_items', 'num_items', $attributes);
        $html .= $this->_generateSelect('auto_scolling', 'Enable Auto Scroll', 'Enable auto scroll.', $source, 'auto_scolling', 'default_auto_scolling'); //$this->format_attribute('num_items', 'num_items', $attributes);
        $html .= $this->_generateSelect('show_navigations', 'Show Navigation', 'Display navigation arrows.', $source, 'show_navigations', 'default_show_navigations'); //$this->format_attribute('num_items', 'num_items', $attributes);
        return $html;
    }

    /**
     * Export end shortcode
     * @param array $attributes
     * @param string $content
     * @return string
     */
    public function display_shortcode($attributes, $content) {
        $html  = '';
        $html .= '<div class="otw-b-carousel otw-b-logo-carousel ' . $this->format_attribute('', 'custom_class', $attributes) . '" data-nav="' . (string) $this->format_attribute('', 'show_navigations', $attributes) . '" data-autoloop="' . (string) $this->format_attribute('', 'auto_scolling', $attributes) . '" >';
        $total_elements = $this->format_attribute('', 'num_items', $attributes);
        for ($ni = 1; $ni <= $total_elements; $ni++) {
            if (strlen($this->format_attribute('', 'upload_logo_' . $ni . '_url', $attributes)) > 0) {
                $html .= '<div class="otw-b-logo-carousel-item">'
                         . '<a href="#" class="' . $this->format_attribute('', 'logo_animations', $attributes) . '">'
                        . '<img src="' . $this->format_attribute('', 'upload_logo_' . $ni . '_url', $attributes) . '" alt="">'
                         . '</a>'
                        . '</div>';
            }
        }
        $html .= '</div>';
        return $this->format_shortcode_output($html);
    }

}
