<?php
class OTW_Shortcode_Blog_Manager extends OTW_Shortcodes{
	
	public function __construct(){
		
		$this->has_custom_options = false;
		
		$this->has_preview = false;
		
		parent::__construct();
	}
	
	/**
	 * apply settings
	 */
	public function apply_settings(){
		
		$this->settings = array();
		
		$this->settings['bloglists_options'] = array( '' => '--/--' );
		
		$this->otwBMQuery = new OTWBMQuery();
		$this->otwDispatcher = new OTWDispatcher();
		$this->otwCSS = new OTWCss();
		
		$lists = $this->otwBMQuery->getLists();
		
		if( isset($lists['otw-bm-list'] ) && is_array($lists['otw-bm-list'] ) ){
			foreach( $lists['otw-bm-list'] as $optionData ){
				if( isset( $optionData['id'] ) ){
					$this->settings['bloglists_options'][ $optionData['id'] ] = $optionData['list_name'];
				}
			}
		}
		
		$this->settings['default_bloglist'] = '';
		
	}
	/**
	 * Shortcode icon_link admin interface
	 */
	public function build_shortcode_editor_options(){
		
		$this->apply_settings();
		
		$html = '';
		
		$source = array();
		if( isset( $_POST['shortcode_object'] ) ){
			$source = $_POST['shortcode_object'];
		}
		$html .= '<br />';
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-bloglist_id', 'label' => $this->get_label( 'Select bloglist' ), 'parse' => $source, 'options' => $this->settings['bloglists_options'], 'value' => $this->settings['default_bloglist'] )  );
		
		return $html;
	}
	
	/** build icon link shortcode
	 *
	 *  @param array
	 *  @return string
	 */
	public function build_shortcode_code( $attributes ){
		
		$code = '';
		
		if( !isset( $attributes['bloglist_id'] ) || !strlen( trim( $attributes['bloglist_id'] ) ) ){
			$this->add_error( $this->get_label( 'Bloglist is required field' ) );
		}
		
		if( !$this->has_error ){
		
			$code = '[otw_shortcode_blog_manager';
			
			$code .= $this->format_attribute( 'bloglist_id', 'bloglist_id', $attributes );
			
			$code .= ']';
			
			$code .= '[/otw_shortcode_blog_manager]';
			
		}
		
		return $code;
	}
	
	/**
	 * Process shortcode icon link
	 */
	public function display_shortcode( $attributes, $content ){
		
		$html = '';
		
		if( is_admin() ){
			$html = '<img src="'.$this->component_url.'images/sidebars-icon-placeholder.png'.'" alt=""/>';
		}elseif( isset( $attributes['bloglist_id'] ) ){
			$html = do_shortcode( '[otw-bm-list id="'.$attributes['bloglist_id'].'"]' );
		}
		
		return $this->format_shortcode_output( $html );
	}
}
?>