<?php
class OTW_Shortcode_Blog_Author_Info extends OTW_Shortcodes{
	
	public function __construct(){
		
		$this->has_custom_options = true;
		
		parent::__construct();
	}
	/**
	 * register external libs
	 */
	public function register_external_libs(){
	
		$this->add_external_lib( 'css', 'otw-shortcode', $this->component_url.'css/otw_shortcode.css', 'all', 100 );
		
		$this->add_external_lib( 'js', 'otw-shortcode-core', $this->component_url.'js/otw_shortcode_core.js', 'all', 99, array( 'jquery' ) );
		$this->add_external_lib( 'js', 'otw-shortcode', $this->component_url.'js/otw_shortcode.js', 'front', 100 );
		$this->add_external_lib( 'js', 'otw-shortcode_live_preview', $this->component_url.'js/otw_shortcode_live_preview.js', 'live_preview', 200 );
	}
	/**
	 * apply settings
	 */
	public function apply_settings(){
		
		$this->settings = array(
			
			'animate' => array(
					'animate-on-hover'  => $this->get_label( 'yes(default)' ),
					''   => $this->get_label( 'no' )
				),
			'default_animate' => 'animate-on-hover'
		);
	}
	
	/**
	 * Shortcode admin interface
	 */
	public function build_shortcode_editor_options(){
		
		$html = '';
		
		$source = array();
		if( isset( $_POST['shortcode_object'] ) ){
			$source = $_POST['shortcode_object'];
		}
		
		$html .= OTW_Form::text_input( array( 'id' => 'otw-shortcode-element-title', 'label' => $this->get_label( 'Title' ), 'description' => $this->get_label( 'Title or name of the author.' ), 'parse' => $source )  );
		
		$html .= OTW_Form::text_area( array( 'id' => 'otw-shortcode-element-bio', 'label' => $this->get_label( 'Bio' ), 'description' => $this->get_label( 'Bio info. HTML is allowed.' ), 'parse' => $source )  );
		
		$html .= OTW_Form::text_input( array( 'id' => 'otw-shortcode-element-email', 'label' => $this->get_label( 'Email' ), 'description' => $this->get_label( 'Email address. It will automatically get the gravatar for that email address. <a href="http://www.gravatar.com/">Gravatar</a>' ), 'parse' => $source )  );
		
		$html .= OTW_Form::text_input( array( 'id' => 'otw-shortcode-element-gravatar_size', 'label' => $this->get_label( 'Gravatar Size' ), 'description' => $this->get_label( 'The size of the gravatar in px.' ), 'parse' => $source, 'value' => 48 )  );
		
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-gravatar_animate', 'label' => $this->get_label( 'Animate gravatar' ), 'description' => $this->get_label( 'Animate gravatar on hover' ), 'parse' => $source, 'options' => $this->settings['animate'], 'value' => $this->settings['default_animate'] )  );
		
		$html .= OTW_Form::text_input( array( 'id' => 'otw-shortcode-element-read_more_text', 'label' => $this->get_label( 'Read More Text' ), 'description' => $this->get_label( 'Optional read more text.' ), 'parse' => $source )  );
		
		$html .= OTW_Form::text_input( array( 'id' => 'otw-shortcode-element-read_more_url', 'label' => $this->get_label( 'Read More Url' ), 'description' => $this->get_label( 'Optional read more URL.' ), 'parse' => $source )  );
			
		return $html;
	}
	
	/**
	 * Shortcode admin interface custom options
	 */
	public function build_shortcode_editor_custom_options(){
		
		$html = '';
		
		$source = array();
		if( isset( $_POST['shortcode_object'] ) ){
			$source = $_POST['shortcode_object'];
		}
		
		$html .= OTW_Form::text_input( array( 'id' => 'otw-shortcode-element-css_class', 'label' => $this->get_label( 'CSS Class' ), 'description' => $this->get_label( 'If you\'d like to style this element separately enter a name here. A CSS class with this name will be available for you to style this particular element..' ), 'parse' => $source )  );
		
		return $html;
	}
	
	/** build shortcode
	 *
	 *  @param array
	 *  @return string
	 */
	public function build_shortcode_code( $attributes ){
		
		$code = '';
		
		if( !$this->has_error ){
		
			$code = '[otw_shortcode_blog_author_info';
			
			$code .= $this->format_attribute( 'title', 'title', $attributes, false, '', true );
			$code .= $this->format_attribute( 'email', 'email', $attributes, false, '', true );
			$code .= $this->format_attribute( 'gravatar_size', 'gravatar_size', $attributes, false, '', true );
			$code .= $this->format_attribute( 'gravatar_animate', 'gravatar_animate', $attributes, false, '', true );
			$code .= $this->format_attribute( 'read_more_text', 'read_more_text', $attributes, false, '', true );
			$code .= $this->format_attribute( 'read_more_url', 'read_more_url', $attributes, false, '', true );
			$code .= $this->format_attribute( 'css_class', 'css_class', $attributes, false, '', true  );
			
			$code .= ']';
			
			$code .= $this->format_attribute( '', 'bio', $attributes );
			
			$code .= '[/otw_shortcode_blog_author_info]';
		}
		
		return $code;

	}
	
	/**
	 * Display shortcode
	 */
	public function display_shortcode( $attributes, $content ){
		
		$html = '<div';
		
		/*class attributes*/
		$class = 'otw-widget-blogauthorinfo';
		
		$class .= $this->format_attribute( '', 'css_class', $attributes, false, $class );
		
		$class .= $this->format_attribute( '', 'gravatar_animate', $attributes, false, $class );
		
		if( strlen( $class ) ){
			$html .= ' class="'.$class.'"';
		}
		/*end class attributes*/
		
		/*style attribute*/
		$style = '';
		
		if( strlen( $style ) ){
			$html .= ' style="'.$style.'"';
		}
		
		$html .= '>';
		
		$html .= '<a class="image"';
		if( $attr_value = $this->format_attribute( '', 'read_more_url', $attributes, false, '' ) ){
			$html .= ' href="'.$attr_value.'"';
		}else{
			$html .= ' href="#"';
		}
		$html .= '>';
		$html .= get_avatar( $this->format_attribute( '', 'email', $attributes, false, '' ), $this->format_attribute( '', 'gravatar_size', $attributes, false, '' ) );
		$html .= '<span class="shadow-overlay hide-for-small"></span>';
		$html .= '</a>';
		
		$html .= '<div class="author-contents" style="margin-left: '.( $this->format_attribute( '', 'gravatar_size', $attributes, false, '' ) + 10 ).'px;">';
		$html .= '<h3 class="widget-title">'.$this->format_attribute( '', 'title', $attributes, false, '' ).'</h3>';
		
		$html .= '<p>'.nl2br( $content ).'</p>';
		
		if( $attr_value = $this->format_attribute( '', 'read_more_text', $attributes, false, '' ) ){
			
			$html .= '<div class="read-more"><a href="'.$this->format_attribute( '', 'read_more_url', $attributes, false, '' ).'">'.$this->format_attribute( '', 'read_more_text', $attributes, false, '' ).'</a></div>';
		}
		
		$html .= '</div>';
		$html .= '</div>';
		
		return $this->format_shortcode_output( $html );
	}
}
