<?php

/**
 * General Workflow for Otw_Shortcode_Progressbar
 *
 * @author Станимир | OTW Design
 * @ver 1.0
 */
class Otw_Shortcode_Animatedtestimonials extends OTW_Shortcodes {

    function __construct() {
        parent::__construct();
        $this->has_custom_options = true;
    }

    /**
     * Register externel lybs 
     */
    function register_external_libs() {
        $this->add_external_lib('css', 'otw-shortcode-general_foundicons', $this->component_url . 'css/general_foundicons.css', 'all', 10);
        $this->add_external_lib('css', 'otw-shortcode-social_foundicons', $this->component_url . 'css/social_foundicons.css', 'all', 20);
        $this->add_external_lib('css', 'otw-shortcode', $this->component_url . 'css/otw_shortcode.css', 'all', 30);
        $this->add_external_lib('css', 'otw-grid', $this->component_url . '../' . 'otw_grid_manager/' . 'css/otw-grid.css', 'all', 100);
        return $this;
    }

    /**
     * Applay all settings to shortcode
     */
    public function apply_settings() {
        $this->_applyBoxAnimations();
        $this->_applyBoxBackgroundPattern();
        $this->_applyBoxBackgrounds();
        $this->_applyBoxBorderColors();
        $this->_applyBoxBorderStyle();
        $this->_applyBoxBorderType();
        $this->_applyBoxBorderWidth();
        $this->_applyBoxRoundedCourners();
        $this->_applyBoxShadow();
        $this->_applyBoxType();
        $this->_applyTrigger();
    }

    protected function _applyTrigger() {
        $this->settings['trigger'] = $this->getTriggers();
        $this->settings['default_trigger'] = '';
        return $this;
    }

    function getTriggers() {
        return array(
            'animated-b-onload' => 'On Load',
            '' => 'On Hover (Default)'
        );
    }

    /**
     * Set dropdown settings for "Box Animations"
     * @return \Otw_Shortcode_Info_List
     */
    protected function _applyBoxAnimations() {
        $this->settings['box_animations'] = $this->getAnimations();
        $this->settings['default_box_animations'] = '';
        return $this;
    }

    /**
     * Get All allowed animations
     * @return array
     */
    public function getAnimations() {
        return array(
            '' => $this->get_label('None(Default)'),
            'animated-b animated-b-rotate' => $this->get_label('Rotate'),
            'animated-b animated-b-bounce' => $this->get_label('Bounce'),
            'animated-b animated-b-wobble' => $this->get_label('Wobble'),
            'animated-b animated-b-rubberBand' => $this->get_label('RubberBand'),
            'animated-b animated-b-swing' => $this->get_label('Swing'),
            'animated-b animated-b-tada' => $this->get_label('Tada'),
            'animated-b animated-b-rubberBand' => $this->get_label('RubberBand')
        );
    }

    /**
     * 
     * @param type $attributes
     * @return string
     */
    public function build_shortcode_code($attributes) {
        $code = '';

        if (!$this->has_error) {
            $code .= '[otw_shortcode_animatedtestimonials';
            $code .= $this->format_attribute('content', 'content', $attributes);
            $code .= $this->format_attribute('name', 'name', $attributes);
            $code .= $this->format_attribute('position', 'position', $attributes);
            $code .= $this->format_attribute('company', 'company', $attributes);
            $code .= $this->format_attribute('website', 'website', $attributes);
            $code .= $this->format_attribute('image', 'image', $attributes);
            $code .= $this->format_attribute('animations', 'animations', $attributes);
            $code .= $this->format_attribute('animation_trigger', 'animation_trigger', $attributes);
//            $code .= $this->format_attribute('box_brd_width', 'box_brd_width', $attributes);
            $code .= $this->format_attribute('box_brd_style', 'box_brd_style', $attributes);
            $code .= $this->format_attribute('box_brd_type', 'box_brd_type', $attributes);
            $code .= $this->format_attribute('box_brd_color', 'box_brd_color', $attributes);
            $code .= $this->format_attribute('box_shadow', 'box_shadow', $attributes);
            $code .= $this->format_attribute('box_rounded_corners', 'box_rounded_corners', $attributes);
            $code .= $this->format_attribute('box_bgr', 'box_bgr', $attributes);
            $code .= $this->format_attribute('box_bgr_pattern', 'box_bgr_pattern', $attributes);
            $code .= $this->format_attribute('box_custom_border_color', 'box_custom_border_color', $attributes);
            $code .= $this->format_attribute('box_custom_bgr_color', 'box_custom_bgr_color', $attributes);
            $code .= $this->format_attribute('box_custom_bgr_pattern', 'box_custom_bgr_pattern', $attributes);
            $code .= $this->format_attribute('custom_class', 'custom_class', $attributes);
            $code .= ']';
            $code .= '[/otw_shortcode_animatedtestimonials]';
        }


        return $code;
    }

    /**
     * Set the additional settings
     * @return string
     */
    public function build_shortcode_editor_custom_options() {
        $html = '';

        $source = array();
        if (isset($_POST['shortcode_object'])) {
            $source = $_POST['shortcode_object'];
        }

        $html .= $this->_generatePicker('box_custom_border_color', 'Border Color Custom', 'Choose a custom box border color.', $source);
        $html .= $this->_generatePicker('box_custom_bgr_color', 'Background Color Custom', 'Choose a custom box background color.', $source);
        $html .= $this->_generateUploader('box_custom_bgr_pattern', 'Background Pattern URL', 'URL to a custom box background pattern. ', $source);
        $html .= $this->_generateText('custom_class', 'CSS Class', 'If you\'d like to style this element separately enter a name here. A CSS class with this name will be available for you to style this particular element..', $source);

        return $html;
    }

    /**
     * Generate options as HTML string 
     * @return string
     */
    public function build_shortcode_editor_options() {
        $html = '';

        $source = array();
        if (isset($_POST['shortcode_object'])) {
            $source = $_POST['shortcode_object'];
        }
        $html .= $this->_generateTextArea('content', 'Content', 'The content text. HTML is allowed.', $source);
        $html .= $this->_generateText('name', 'Name', 'Enter name.', $source);
        $html .= $this->_generateText('position', 'Position', 'Enter positon.', $source);
        $html .= $this->_generateText('company', 'Company Name', 'Enter company name.', $source);
        $html .= $this->_generateText('website', 'Company Website', 'Enter company website URL.', $source);
        $html .= $this->_generateUploader('image', 'Image', 'Upload an image.', $source);
        $html .= $this->_generateSelect('animations', 'Animation', 'Choose animation.', $source, 'box_animations', 'default_box_animations');
        $html .= $this->_generateSelect('animation_trigger', 'Animation Trigger', 'Animation trigger.', $source, 'trigger', 'default_trigger');
//        $html .= $this->_generateSelect('box_brd_width', 'Box Border Width', 'Choose box border width.', $source, 'box_brd_width', 'default_box_brd_width');
        $html .= $this->_generateSelect('box_brd_style', 'Box Border Style', 'Choose box border style.', $source, 'box_brd_style', 'default_box_brd_style');
        $html .= $this->_generateSelect('box_brd_type', 'Box Border Type', 'Choose box border type.', $source, 'box_brd_type', 'default_box_brd_type');
        $html .= $this->_generateSelect('box_brd_color', 'Box Border Color', 'Choose box border color.', $source, 'box_brd_color', 'default_box_brd_color');
        $html .= $this->_generateSelect('box_shadow', 'Box Shadow', 'Choose box shadow.', $source, 'box_shadow', 'default_box_shadow');
        $html .= $this->_generateSelect('box_rounded_corners', 'Box Rounded Corners', 'Choose box rounded corners.', $source, 'box_rounded_corners', 'default_box_rounded_corners');
        $html .= $this->_generateSelect('box_bgr', 'Box Background Color', 'Choose box background color.', $source, 'box_bgr', 'default_box_bgr');
        $html .= $this->_generateSelect('box_bgr_pattern', 'Box Background Pattern', 'Choose box background pattern.', $source, 'box_bgr_pattern', 'default_box_bgr_pattern');
        return $html;
    }

    /**
     * Export end shortcode
     * @param array $attributes
     * @param string $content
     * @return string
     */
    public function display_shortcode($attributes, $content) {
        $html = '';
        $class_for_master = '';
        $class_for_master = $this->append_attribute($class_for_master, 'otw-row');
        $class_for_master = $this->append_attribute($class_for_master, 'otw-b-animated-testimonial');
        $class_for_master = $this->append_attribute($class_for_master, 'clearfix');
        $class_for_master = $this->append_attribute($class_for_master, $this->format_attribute('', 'box_brd_style', $attributes));
//        $class_for_master = $this->append_attribute($class_for_master, $this->format_attribute('', 'box_brd_width', $attributes));
        $class_for_master = $this->append_attribute($class_for_master, $this->format_attribute('', 'box_brd_type', $attributes));
        $class_for_master = $this->append_attribute($class_for_master, $this->format_attribute('', 'box_brd_color', $attributes));
        $class_for_master = $this->append_attribute($class_for_master, $this->format_attribute('', 'box_shadow', $attributes));
        $class_for_master = $this->append_attribute($class_for_master, $this->format_attribute('', 'box_rounded_corners', $attributes));
        $class_for_master = $this->append_attribute($class_for_master, $this->format_attribute('', 'box_bgr', $attributes));
        $class_for_master = $this->append_attribute($class_for_master, $this->format_attribute('', 'box_bgr_pattern', $attributes));
        $class_for_master = $this->append_attribute($class_for_master, $this->format_attribute('', 'custom_class', $attributes));

        $style_master = '';
        if (strlen($this->format_attribute('', 'box_custom_border_color', $attributes)) > 0) {
            $style_master .= $this->append_attribute($style_master, 'border-color: ' . $this->format_attribute('', 'box_custom_border_color', $attributes) . '!important;');
        }
        if (strlen($this->format_attribute('', 'box_custom_bgr_color', $attributes)) > 0) {
            $style_master .= $this->append_attribute($style_master, 'background-color: ' . $this->format_attribute('', 'box_custom_bgr_color', $attributes) . '!important;');
        }
        if (strlen($this->format_attribute('', 'box_custom_bgr_pattern', $attributes)) > 0) {
            $style_master .= $this->append_attribute($style_master, 'background-image: url(' . $this->format_attribute('', 'box_custom_bgr_pattern', $attributes) . ')!important;');
        }

        $html .= '<div style="' . $style_master . '" class="' . $class_for_master . '">';
        $html .= '<div class="otw-six otw-columns">';
        $class_for_images = '';
        $class_for_images = $this->append_attribute($class_for_images, 'otw-b-icon');
        $class_for_images = $this->append_attribute($class_for_images, 'otw-b-icon-giant');
        $class_for_images = $this->append_attribute($class_for_images, 'otw-b-rounded-circle');
        $class_for_images = $this->append_attribute($class_for_images, $this->format_attribute('', 'animations', $attributes));
        $class_for_images = $this->append_attribute($class_for_images, $this->format_attribute('', 'animation_trigger', $attributes));

        $html .= '<span class="' . $class_for_images . '">';
        $html .= '<img class="otw-b-animate-in otw-b-animate-in-left" src="' . $this->format_attribute('', 'image', $attributes) . '" alt="">';
        $html .= '</span>';

        $html .= '</div>';
        $html .= ' <div class="otw-eighteen otw-columns">';
        $html .= '<p>' . $this->format_attribute('', 'content', $attributes) . '</p>';
        $html .= '<p><strong>' . $this->format_attribute('', 'name', $attributes) . '</strong><br>';
        $html .= '<em>' . $this->format_attribute('', 'position', $attributes) . '</em>';
        if (strlen($this->format_attribute('', 'position', $attributes)) > 0 && strlen($this->format_attribute('', 'company', $attributes)) > 0) {
            $html .= ' - ';
        }

        if (strlen($this->format_attribute('', 'website', $attributes)) > 0) {
            $html .= '<a href="' . $this->format_attribute('', 'website', $attributes) . '">';
            $html .= $this->format_attribute('', 'company', $attributes);
            $html .= '</a>';
        } else {
            $html .= $this->format_attribute('', 'company', $attributes);
        }

        $html .= '</p>';
        $html .= '</div>';
        $html .= '</div>';
        return $this->format_shortcode_output($html);
    }

}
