<?php
/**
 * Shortcode for Animated image content
 * @author Станимир | OTW Design
 * @ver 1.0
 */
class OTW_ShortCode_Animatedimg extends OTW_Shortcodes {

    function __construct() {
        parent::__construct();
        $this->has_custom_options = true;
    }

    /**
     * Register all libs for shortcode
     * @return \OTW_ShortCode_Animatedimg
     */
    function register_external_libs() {
        $this->add_external_lib('css', 'otw-shortcode-general_foundicons', $this->component_url . 'css/general_foundicons.css', 'all', 10);
        $this->add_external_lib('css', 'otw-shortcode-social_foundicons', $this->component_url . 'css/social_foundicons.css', 'all', 20);
        $this->add_external_lib('css', 'otw-grid', $this->component_url . '../' . 'otw_grid_manager/' . 'css/otw-grid.css', 'all', 100);
        $this->add_external_lib('css', 'otw-shortcode', $this->component_url . 'css/otw_shortcode.css', 'all', 120);
        $this->add_external_lib('css', 'otw-shortcode_scrolling', $this->component_url . 'css/scroll_for_preview.css?' . md5(time()), 'all', 130);
        $this->add_external_lib('css', 'otw-shortcode', $this->component_url . 'css/otw_shortcode.css', 'all', 120);

        $this->add_external_lib('js', 'otw-animate-shadow', $this->component_url . 'js/jquery.animate-shadow-min.js', 'all', 99, array('jquery'));
        $this->add_external_lib('js', 'otw-quizsand', $this->component_url . 'js/jquery.quicksand.js', 'all', 100, array('jquery', 'otw-animate-shadow'));
        $this->add_external_lib('js', 'otw-waypoints', $this->component_url . 'js/waypoints.min.js', 'all', 101);

        $this->add_external_lib('js', 'otw-shortcode-core', $this->component_url . 'js/otw_shortcode_core.js', 'all', 102, array('jquery'));
        $this->add_external_lib('js', 'otw-shortcode', $this->component_url . 'js/otw_shortcode.js', 'all', 103);
        $this->add_external_lib('js', 'otw-shortcode_live_preview', $this->component_url . 'js/otw_shortcode_live_preview.js', 'live_preview', 200);
        return $this;
    }

    /**
     * Apply all settings for dropdowns
     * @return \OTW_ShortCode_Animatedimg
     */
    public function apply_settings() {
        $this->_applyBoxAnimations();
        $this->_applyImagePossition();
        return $this;
    }

    /**
     * Apply settings for animations
     * @return \OTW_ShortCode_Animatedimg
     */
    protected function _applyBoxAnimations() {
        $this->settings['imageanimation'] = $this->getAnimations();
        $this->settings['default_imageanimation'] = '';
        return $this;
    }

    /**
     * Get all enabled animations for this item
     * @return array
     */
    public function getAnimations() {
        return array(
            '' => $this->get_label('None(Default)'),
            'otw-b-animate-in otw-b-animate-in-left' => $this->get_label('Left'),
            'otw-b-animate-in otw-b-animate-in-right' => $this->get_label('Right'),
            'otw-b-animate-in otw-b-animate-in-top' => $this->get_label('Top'),
            'otw-b-animate-in otw-b-animate-in-Bottom' => $this->get_label('Bottom'),
        );
    }

    /**
     * Get all image possitions fot this animations
     * @return array
     */
    public function getImagePossition() {
        return array(
            'left' => $this->get_label('Left(Default)'),
            'right' => $this->get_label('Right'),
        );
    }

    /**
     * Set all possitions for dropdowns settings
     * @return \OTW_ShortCode_Animatedimg
     */
    function _applyImagePossition() {
        $this->settings['imgpossition'] = $this->getImagePossition();
        $this->settings['default_imgpossition'] = '';
        return $this;
    }

    /**
     * Return formated shortcode
     * @param array $attributes
     * @return string
     */
    public function build_shortcode_code($attributes) {
        $code = '';
        if (!$this->has_error) {
            $code = '[otw_shortcode_animatedimg';
            $code .= $this->format_attribute('title', 'title', $attributes);
            $code .= $this->format_attribute('content', 'content', $attribute, false, '', trues);
            $code .= $this->format_attribute('image', 'image', $attributes);
            $code .= $this->format_attribute('imgpossition', 'imgpossition', $attributes);
            $code .= $this->format_attribute('imageannimation', 'imageannimation', $attributes);
            $code .= $this->format_attribute('textannimation', 'textannimation', $attributes);
            $code .= $this->format_attribute('css_class', 'css_class', $attributes);
            $code .= ']';
            $code .= '[/otw_shortcode_animatedimg]';
            return $code;
        }
    }

    /**
     * Return shortcode DOM settings in modal *CUSTOM*
     * @return string
     */
    public function build_shortcode_editor_custom_options() {
        $html = '';
        $source = array();
        if (isset($_POST['shortcode_object'])) {
            $source = $_POST['shortcode_object'];
        }
        $html .= $this->_generateText('css_class', 'CSS Class', 'If you\'d like to style this element separately enter a name here. A CSS class with this name will be available for you to style this particular element..', $source);
        return $html;
    }

    /**
     * Return shortcode DOM settings in modal *NORMAL*
     * @return string
     */
    public function build_shortcode_editor_options() {
        $html = '';
        $source = array();
        if (isset($_POST['shortcode_object'])) {
            $source = $_POST['shortcode_object'];
        }
        $html .= $this->_generateText('title', 'Title', 'Enter title.', $source);
        $html .= $this->_generateTextArea('content', 'Content', 'The content text. HTML is allowed. ', $source);
        $html .= $this->_generateUploader('image', 'Image ', 'Upload an image. ', $source);
        $html .= $this->_generateSelect('imgpossition', 'Image Potion', 'Choose image postion.', $source, 'imgpossition', 'default_imgpossition');
        $html .= $this->_generateSelect('imageannimation', 'Image Animation', 'Choose image animation.', $source, 'imageanimation', 'default_imageanimation');
        $html .= $this->_generateSelect('textannimation', 'Text Animation', 'Choose text animation.', $source, 'imageanimation', 'default_imageanimation');
        return $html;
    }

    /**
     * Return formated shortcode
     * @param array $attributes
     * @param string $content
     * @return string
     */
    public function display_shortcode($attributes, $content) {
        $image_url = $this->format_attribute('', 'image', $attributes);
        $imagepossition = $this->format_attribute('', 'imgpossition', $attributes);
        $imageannimation = $this->format_attribute('', 'imageannimation', $attributes);
        $textannimation = $this->format_attribute('', 'textannimation', $attributes);
        $image = '';
        $image .= '<div class="otw-eight otw-columns ' . $this->format_attribute('', 'css_class', $attributes) . '">';
        if (!empty($image_url)) {
            $image .= '<img class="' . $imageannimation . '" src="' . $image_url . '" alt="" />';
        }
        $image .= '</div>';
        $text = '';
        $text .= '<div class="otw-sixteen otw-columns ' . $textannimation . '" >';
        $text .= '<h2>' . $this->format_attribute('', 'title', $attributes) . '</h2>';
        $text .='<p>' . nl2br(otw_htmlentities_decode(stripslashes($this->format_attribute('', 'content', $attributes)))) . '</p>';
        $text .='</div>';

        $html = '';
        $html .= '<div class="otw-row otw-b-animated-image clearfix">';

        if ($imagepossition == 'left') {
            $html.= $image;
        }
        $html.= $text;
        if ($imagepossition == 'right') {
            $html.= $image;
        }
        $html .= '</div>';
        return $this->format_shortcode_output($html);
    }

}
