<?php
class OTW_Shortcode_Abbreviation extends OTW_Shortcodes{
	
	public function __construct(){
		
		$this->has_custom_options = true;
		
		parent::__construct();
	}
	
	public function register_external_libs(){
		$this->add_external_lib( 'css', 'otw-shortcode', $this->component_url.'css/otw_shortcode.css', 'all', 100 );
	}
	
	/**
	 * apply settings
	 */
	public function apply_settings(){
	
		$this->settings = array(
		
		);
		
	}
	
	/**
	 * Shortcode admin interface
	 */
	public function build_shortcode_editor_options(){
		
		$html = '';
		
		$source = array();
		if( isset( $_POST['shortcode_object'] ) ){
			$source = $_POST['shortcode_object'];
		}
		
		$html .= OTW_Form::text_area( array( 'id' => 'otw-shortcode-element-content', 'label' => $this->get_label( 'Abbreviation' ), 'description' => $this->get_label( 'The abbreviated text.' ), 'parse' => $source )  );
		
		$html .= OTW_Form::text_area( array( 'id' => 'otw-shortcode-element-full_content', 'label' => $this->get_label( 'The full, unabbreviated, text.' ), 'description' => $this->get_label( 'The full, unabbreviated, text.' ), 'parse' => $source )  );
		
		$html .= OTW_Form::text_area( array( 'id' => 'otw-shortcode-element-before_content', 'label' => $this->get_label( 'Text before abbreviation' ), 'description' => $this->get_label( 'The text before the abbreviated text.' ), 'parse' => $source )  );
		
		$html .= OTW_Form::text_area( array( 'id' => 'otw-shortcode-element-after_content', 'label' => $this->get_label( 'Text after abbreviation' ), 'description' => $this->get_label( 'The text after the abbreviated text.' ), 'parse' => $source )  );
		
		return $html;
	}
	
	/**
	 * Shortcode admin interface custom options
	 */
	public function build_shortcode_editor_custom_options(){
		
		$html = '';
		
		$source = array();
		if( isset( $_POST['shortcode_object'] ) ){
			$source = $_POST['shortcode_object'];
		}
		
		$html .= OTW_Form::text_input( array( 'id' => 'otw-shortcode-element-css_class', 'label' => $this->get_label( 'CSS Class' ), 'description' => $this->get_label( 'If you\'d like to style this element separately enter a name here. A CSS class with this name will be available for you to style this particular element..' ), 'parse' => $source )  );
		
		return $html;
	}
	
	/** build shortcode
	 *
	 *  @param array
	 *  @return string
	 */
	public function build_shortcode_code( $attributes ){
		
		$code = '';
		
		if( !isset( $attributes['content'] ) || !strlen( trim( $attributes['content'] ) ) ){
			$this->add_error( $this->get_label( 'Content is required field' ) );
		}
		
		if( !$this->has_error ){
		
			$code = '[otw_shortcode_abbreviation';
			
			$code .= $this->format_attribute( 'full_content', 'full_content', $attributes, false, '', true );
			$code .= $this->format_attribute( 'before_content', 'before_content', $attributes, false, '', true );
			$code .= $this->format_attribute( 'after_content', 'after_content', $attributes, false, '', true );
			$code .= $this->format_attribute( 'css_class', 'css_class', $attributes, false, '', true  );
			
			$code .= ']';
			
			$code .= strip_tags( $attributes['content'] );
			
			$code .= '[/otw_shortcode_abbreviation]';
		}
		return $code;

	}
	
	/**
	 * Display shortcode
	 */
	public function display_shortcode( $attributes, $content ){
		
		$html = '';
		
		if( $before_content = $this->format_attribute( '', 'before_content', $attributes, false, '' ) ){
		
			$html .= $before_content.' ';
		}
		
		$html .= '<abbr';
		
		/*class attributes*/
		$class = '';
		
		$class .= $this->format_attribute( '', 'css_class', $attributes, false, $class );
		
		if( strlen( $class ) ){
			$html .= ' class="'.$class.'"';
		}
		/*end class attributes*/
		
		/*style attribute*/
		$style = '';
		
		if( strlen( $style ) ){
			$html .= ' style="'.$style.'"';
		}
		
		if( $full_content = $this->format_attribute( '', 'full_content', $attributes, false, '' ) ){
		
			$html .= ' title="'.$full_content.'"';
		}
		
		$html .= '>';
		
		$html .= nl2br( $content );
		
		$html .= '</abbr>';
		
		if( $after_content = $this->format_attribute( '', 'after_content', $attributes, false, '' ) ){
		
			$html .= ' '.$after_content;
		}
		
		return $this->format_shortcode_output( $html );
	}
}
