<?php
global $otw_cm_skins, $otw_cm_skins_path, $_wp_column_headers;

$_wp_column_headers['toplevel_page_otw-cm-skins'] = array(
	'name' => __( 'Skin Name', 'otw_cm' ),
	'file' => __( 'Skin File', 'otw_cm' )
);

$is_writable = otw_cm_skins_wirable( $otw_cm_skins_path );

$message = '';
$massages = array();
$messages[1] = __( 'Skin saved', 'otw_cm' );
$messages[2] = __( 'Skin deleted', 'otw_cm' );

if( isset( $_GET['message'] ) && isset( $messages[ $_GET['message'] ] ) ){
	$message .= $messages[ $_GET['message'] ];
}
?>
<?php if ( $message ) : ?>
<div id="message" class="updated"><p><?php echo $message; ?></p></div>
<?php endif; ?>
<?php if ( !$is_writable ) : ?>
<div id="message" class="error">
	<?php _e( 'The skin directory is not writable!!!<br />You will not be able to create/update/delete skins.', 'otw_cm')?>
</div>
<?php endif; ?>
<div class="wrap">
	<div id="icon-edit" class="icon32"><br/></div>
	<h2>
		<?php _e('Skins', 'otw_cm') ?>
		<a class="button add-new-h2" href="admin.php?page=otw-cm-skins-manage"><?php _e('Create New', 'otw_cm') ?></a>
	</h2>
	
	<form class="search-form form-wrap" action="" method="get">
		<?php include_once( 'otw_cm_help.php' );?>
	</form>
	<div class="updated">
		<p><?php _e( 'Here is a list of all skins created. You can create as many skins as you like.<br />If you want to load a skin in your site go to Content Manager -> Settings -> Default Skin and select the skin.', 'otw_cm' );?></p>
	</div>
	<br class="clear" />
	<?php if( is_array( $otw_cm_skins ) && count( $otw_cm_skins ) ){?>
		<table class="widefat fixed" cellspacing="0">
			<thead>
				<tr>
					<?php foreach( $_wp_column_headers['toplevel_page_otw-cm-skins'] as $key => $name ){?>
						<th><?php echo $name?></th>
					<?php }?>
				</tr>
			</thead>
			<tfoot>
				<tr>
					<?php foreach( $_wp_column_headers['toplevel_page_otw-cm-skins'] as $key => $name ){?>
						<th><?php echo $name?></th>
					<?php }?>
				</tr>
			</tfoot>
			<tbody>
			<?php foreach( $otw_cm_skins as $skin_item ){?>
				<tr>
					<?php foreach( $_wp_column_headers['toplevel_page_otw-cm-skins'] as $column_name => $column_title ){
						
						$edit_link = admin_url( 'admin.php?page=otw-cm-skins-manage&amp;action=edit&amp;skin='.$skin_item[0] );
						$delete_link = admin_url( 'admin.php?page=otw-cm-skins-delete&amp;skin='.$skin_item[0] );
						
						switch($column_name) {
						
							case 'name':
								
									echo '<td><strong><a href="'.$edit_link.'" title="'.esc_attr(sprintf(__('Edit &#8220;%s&#8221;', 'otw_cm'), $skin_item[0])).'">'.$skin_item[0].'</a></strong><br />';
									
									echo '<div class="row-actions">';
									echo '<a href="'.$edit_link.'">' . __('Edit', 'otw_cm') . '</a>';
									echo ' | <a href="'.$delete_link.'">' . __('Delete', 'otw_cm'). '</a>';
									
									echo '</div>';
									
									echo '</td>';
								break;
							case 'file':
									echo '<td>skins/'.$skin_item[0].'.css</td>';
								break;
						}
					?>
					
					<?php }?>
				</tr>
			<?php }?>
			</tbody>
		</table>
		
	<?php }else{ ?>
		<p><?php _e('No skins found.', 'otw_cm' )?></p>
	<?php } ?>
</div>