<?php get_header(); ?>
<div id="primary" class="site-content">
	<div id="content" role="main">
		<?php while ( have_posts() ) : the_post(); ?>
		<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
			<div class="otw_gm_content">
				<div class="otw-row">
					<div class="otw-eighteen otw-columns">
						<header class="entry-header">
							<?php if ( is_single() ) : ?>
								<h1 class="entry-title"><?php the_title(); ?></h1>
							<?php else : ?>
								<h1 class="entry-title">
								<a href="<?php the_permalink(); ?>" rel="bookmark"><?php the_title(); ?></a>
								</h1>
							<?php endif; // is_single() ?>
							<?php if ( comments_open() ) : ?>
								<div class="comments-link">
									<?php comments_popup_link( '<span class="leave-reply">' . __( 'Leave a reply', 'twentytwelve' ) . '</span>', __( '1 Reply', 'twentytwelve' ), __( '% Replies', 'twentytwelve' ) ); ?>
								</div><!-- .comments-link -->
							<?php endif; // comments_open() ?>
						</header><!-- .entry-header -->
						<div class="entry-content">
							<?php the_content() ?>
						</div>
					</div>
					<div class="otw-six otw-columns end">
						<?php get_sidebar(); ?>
					</div>
				</div>
			</div>
		</article>
		<?php endwhile; // end of the loop. ?>
	</div>
</div>
<?php get_footer(); ?>
