<?php
	global $wp_cm_tmc_items, $wp_cm_agm_items, $otw_cm_skins, $wp_cm_cs_items, $otw_cm_plugin_id;
	
	$otw_cm_plugin_options = get_option( 'otw_cm_plugin_options' );
	
	//pupulate form values
	$db_values = array();
	$db_values['shortcode_editor_button_for'] = array();
	$db_values['grid_for'] = array();
	$db_values['cs_for'] = array();
	$db_values['otw_cm_skin'] = 'carbon';
	$db_values['otw_cm_grid_previews'] = 'no';
	$db_values['otw_cm_portfolio_slug'] = 'otw_cm_portfolio';
	$db_values['otw_cm_portfolio_tax_slug'] = 'otw_cm_portfolio_category';
	$db_values['otw_cm_front_grid'] = 'yes';
	$db_values['otw_cm_front_grid_previews'] = 'no';
	$db_values['otw_cm_theme_css'] = '';
	$db_values['otw_cm_portfolio_template'] = 'otw';
	
	$db_values['otw_cm_promotions'] = get_option( $otw_cm_plugin_id.'_dnms' );
	
	if( empty( $db_values['otw_cm_promotions'] ) ){
		$db_values['otw_cm_promotions'] = 'on';
	}
	
	if( isset( $_POST['otw_cm_skin'] ) ){
		$db_values['otw_cm_skin'] = $_POST['otw_cm_skin'];
	}elseif( isset( $otw_cm_plugin_options['otw_cm_skin'] ) ){
		$db_values['otw_cm_skin'] = $otw_cm_plugin_options['otw_cm_skin'];
	}
	
	if( isset( $_POST['otw_cm_grid_previews'] ) ){
		$db_values['otw_cm_grid_previews'] = $_POST['otw_cm_grid_previews'];
	}elseif( isset( $otw_cm_plugin_options['otw_cm_grid_previews'] ) && strlen( $otw_cm_plugin_options['otw_cm_grid_previews'] ) ){
		$db_values['otw_cm_grid_previews'] = $otw_cm_plugin_options['otw_cm_grid_previews'];
	}
	
	if( isset( $_POST['otw_cm_portfolio_slug'] ) ){
		$db_values['otw_cm_portfolio_slug'] = $_POST['otw_cm_portfolio_slug'];
	}elseif( isset( $otw_cm_plugin_options['otw_cm_portfolio_slug'] ) && strlen( $otw_cm_plugin_options['otw_cm_portfolio_slug'] ) ){
		$db_values['otw_cm_portfolio_slug'] = $otw_cm_plugin_options['otw_cm_portfolio_slug'];
	}
	
	if( isset( $_POST['otw_cm_portfolio_template'] ) ){
		$db_values['otw_cm_portfolio_template'] = $_POST['otw_cm_portfolio_template'];
	}elseif( isset( $otw_cm_plugin_options['otw_cm_portfolio_template'] ) && strlen( $otw_cm_plugin_options['otw_cm_portfolio_template'] ) ){
		$db_values['otw_cm_portfolio_template'] = $otw_cm_plugin_options['otw_cm_portfolio_template'];
	}
	
	if( isset( $_POST['otw_cm_portfolio_tax_slug'] ) ){
		$db_values['otw_cm_portfolio_tax_slug'] = $_POST['otw_cm_portfolio_tax_slug'];
	}elseif( isset( $otw_cm_plugin_options['otw_cm_portfolio_tax_slug'] ) && strlen( $otw_cm_plugin_options['otw_cm_portfolio_tax_slug'] ) ){
		$db_values['otw_cm_portfolio_tax_slug'] = $otw_cm_plugin_options['otw_cm_portfolio_tax_slug'];
	}
	
	if( isset( $_POST['otw_cm_front_grid'] ) ){
		$db_values['otw_cm_front_grid'] = $_POST['otw_cm_front_grid'];
	}elseif( isset( $otw_cm_plugin_options['otw_cm_front_grid'] ) && strlen( $otw_cm_plugin_options['otw_cm_front_grid'] ) ){
		$db_values['otw_cm_front_grid'] = $otw_cm_plugin_options['otw_cm_front_grid'];
	}
	
	if( isset( $_POST['otw_cm_front_grid_previews'] ) ){
		$db_values['otw_cm_front_grid_previews'] = $_POST['otw_cm_front_grid_previews'];
	}elseif( isset( $otw_cm_plugin_options['otw_cm_front_grid_previews'] ) && strlen( $otw_cm_plugin_options['otw_cm_front_grid_previews'] ) ){
		$db_values['otw_cm_front_grid_previews'] = $otw_cm_plugin_options['otw_cm_front_grid_previews'];
	}
	
	if( isset( $_POST['otw_cm_theme_css'] ) ){
		$db_values['otw_cm_theme_css'] = $_POST['otw_cm_theme_css'];
	}elseif( isset( $otw_cm_plugin_options['otw_cm_theme_css'] ) ){
		$db_values['otw_cm_theme_css'] = $otw_cm_plugin_options['otw_cm_theme_css'];
	}
	
	foreach( $wp_cm_tmc_items as $item_key => $wpItem ){
		
		//shortcode editor values
		$db_values['shortcode_editor_button_for'][ $item_key ] = '';
		
		if( isset( $_POST['otw_cm_editor_shortcodes'] ) ){
			
			if( isset( $_POST['otw_cm_editor_shortcodes'][ $item_key ] ) && $_POST['otw_cm_editor_shortcodes'][ $item_key ] == 1  ){
				$db_values['shortcode_editor_button_for'][ $item_key ] = ' checked="checked"';
			}
			
		}elseif( isset( $otw_cm_plugin_options['shortcode_editor_button_for'] ) && isset( $otw_cm_plugin_options['shortcode_editor_button_for'][ $item_key ] ) ){
			
			if( $otw_cm_plugin_options['shortcode_editor_button_for'][ $item_key ] == 1 ){
				$db_values['shortcode_editor_button_for'][ $item_key ] = ' checked="checked"';
			}
			
		}elseif( !isset( $otw_cm_plugin_options['shortcode_editor_button_for'] ) || !isset( $otw_cm_plugin_options['shortcode_editor_button_for'][ $item_key ] ) ){
			
			$db_values['shortcode_editor_button_for'][ $item_key ] = ' checked="checked"';
		}
		
	}
	
	foreach( $wp_cm_agm_items as $item_key => $wpItem ){
		
		//grid values
		$db_values['grid_for'][ $item_key ] = '';
		
		if( isset( $_POST['otw_cm_grid'] ) ){
			
			if( isset( $_POST['otw_cm_grid'][ $item_key ] ) && $_POST['otw_cm_grid'][ $item_key ] == 1  ){
				$db_values['grid_for'][ $item_key ] = ' checked="checked"';
			}
			
		}elseif( isset( $otw_cm_plugin_options['grid_for'] ) && isset( $otw_cm_plugin_options['grid_for'][ $item_key ] ) ){
			
			if( $otw_cm_plugin_options['grid_for'][ $item_key ] == 1 ){
				$db_values['grid_for'][ $item_key ] = ' checked="checked"';
			}
			
		}elseif( !isset( $otw_cm_plugin_options['grid_for'] ) || !isset( $otw_cm_plugin_options['grid_for'][ $item_key ] ) ){
			
			$db_values['grid_for'][ $item_key ] = ' checked="checked"';
		}
	}
	
	foreach( $wp_cm_cs_items as $item_key => $wpItem ){
		
		//grid values
		$db_values['cs_for'][ $item_key ] = '';
		
		if( isset( $_POST['otw_cm_cs'] ) ){
			
			if( isset( $_POST['otw_cm_cs'][ $item_key ] ) && $_POST['otw_cm_cs'][ $item_key ] == 1  ){
				$db_values['cs_for'][ $item_key ] = ' checked="checked"';
			}
			
		}elseif( isset( $otw_cm_plugin_options['cs_for'] ) && isset( $otw_cm_plugin_options['cs_for'][ $item_key ] ) ){
			
			if( $otw_cm_plugin_options['cs_for'][ $item_key ] == 1 ){
				$db_values['cs_for'][ $item_key ] = ' checked="checked"';
			}
			
		}elseif( !isset( $otw_cm_plugin_options['cs_for'] ) || !isset( $otw_cm_plugin_options['cs_for'][ $item_key ] ) ){
			
			$db_values['cs_for'][ $item_key ] = ' checked="checked"';
		}
	}
	
$message = '';
$massages = array();
$messages[1] = __( 'Settings saved', 'otw_cm' );

if( isset( $_GET['message'] ) && isset( $messages[ $_GET['message'] ] ) ){
	$message .= $messages[ $_GET['message'] ];
	flush_rewrite_rules();
}
?>
<?php if ( $message ) : ?>
<div id="message" class="updated"><p><?php echo $message; ?></p></div>
<?php endif; ?>
<div class="wrap">
	<div id="icon-edit" class="icon32"><br/></div>
	<h2>
		<?php _e('Plugin Settings', 'otw_cm') ?>
	</h2>
	<div class="form-wrap otw_cm_options" id="poststuff">
		<form method="post" action="" class="validate">
			<input type="hidden" name="otw_cm_action" value="otw_cm_settings_action" />
			<?php wp_original_referer_field(true, 'previous'); wp_nonce_field('otw-cm-settings'); ?>
			<div id="post-body">
				<div id="post-body-content">
					<?php include_once( 'otw_cm_help.php' );?>
					<div class="otw-form-settings-field">
						<label for="otw_cm_editor_shortcodes"><?php _e( 'Show Insert OTW shortcodes button in', 'otw_cm' )?></label>
						<div class="otw_cm_left_labels">
							<?php foreach( $wp_cm_tmc_items as $wp_item_type => $wpItem){?>
								<span>
									<input type="checkbox"<?php echo $db_values['shortcode_editor_button_for'][ $wp_item_type ]?> id="otw_cm_editor_shortcodes_<?php echo $wp_item_type;?>" name="otw_cm_editor_shortcodes[<?php echo $wp_item_type;?>]" value="1"/>
									<label for="otw_cm_editor_shortcodes_<?php echo $wp_item_type;?>"><?php echo $wpItem[1];?></label>
								</span>
							<?php }?>
						</div>
						<p><?php _e( 'Enables Insert OTW ShortCodes button in the WYSIWYG editor.', 'otw_cm' );?></p>
					</div>
					<div class="otw-form-settings-field">
						<label for="otw_cm_activate_grid"><?php _e( 'Show Grid Manager in', 'otw_cm' )?></label>
						<div class="otw_cm_left_labels">
							<?php foreach( $wp_cm_agm_items as $wp_item_type => $wpItem){?>
								<span>
									<input type="checkbox"<?php echo $db_values['grid_for'][ $wp_item_type ]?> id="otw_cm_grid_<?php echo $wp_item_type;?>" name="otw_cm_grid[<?php echo $wp_item_type;?>]" value="1"/>
									<label for="otw_cm_grid_<?php echo $wp_item_type;?>"><?php echo $wpItem[1];?></label>
								</span>
							<?php }?>
						</div>
						<p><?php _e( 'Enables OTW Grid Manager metabox so you can be able to use the visual interface for the Grid.', 'otw_cm' );?></p>
					</div>
					<div class="otw-form-settings-field">
						<label for="otw_cm_activate_cs"><?php _e( 'Show OTW Content Sidebars metabox in', 'otw_cm' )?></label>
						<div class="otw_cm_left_labels">
							<?php foreach( $wp_cm_cs_items as $wp_item_type => $wpItem){?>
								<span>
									<input type="checkbox"<?php echo $db_values['cs_for'][ $wp_item_type ]?> id="otw_cm_cs_<?php echo $wp_item_type;?>" name="otw_cm_cs[<?php echo $wp_item_type;?>]" value="1"/>
									<label for="otw_cm_cs_<?php echo $wp_item_type;?>"><?php echo $wpItem[1];?></label>
								</span>
							<?php }?>
						</div>
						<p><?php _e( 'Enables OTW Content Sidebars metabox so you can be able to use the visual interface for the content sidebars.', 'otw_cm' );?></p>
					</div>
					<div class="otw-form-settings-field">
						<label for="otw_cm_promotions"><?php _e('Show OTW Promotion Messages in my WordPress admin', 'otw_cm'); ?></label>
						<select id="otw_cm_promotions" name="otw_cm_promotions">
							<option value="on" <?php echo ( isset( $db_values['otw_cm_promotions'] ) && ( $db_values['otw_cm_promotions'] == 'on' ) )? 'selected="selected"':''?>>on(default)</option>
							<option value="off"<?php echo ( isset( $db_values['otw_cm_promotions'] ) && ( $db_values['otw_cm_promotions'] == 'off' ) )? 'selected="selected"':''?>>off</option>
						</select>
					</div>
					<div class="otw-form-settings-field">
						<label for="otw_cm_skin"><?php _e( 'Default skin', 'otw_cm' )?></label>
						<select id="otw_cm_skin" name="otw_cm_skin" style="width: 150px;">
							<option value=""><?php _e( 'Default skin', 'otw_cm')?></option>
							<?php foreach( $otw_cm_skins as $skin_key => $skin ){?>
								<?php
									if( $db_values['otw_cm_skin'] == $skin_key ){
										$selected = ' selected="selected"';
									}else{
										$selected = '';
									}
								?>
								<option<?php echo $selected;?> value="<?php echo $skin_key?>"><?php echo $skin[1]?></option>
							<?php }?>
						</select>
						<p><?php _e( 'Select a skin form the list. If you\'d like to create a new skin go to Content Manager -> Add Skin.', 'otw_cm' );?></p>
					</div>
					<div class="otw-form-settings-field">
						<label for="otw_cm_grid_previews"><?php _e( 'Enable Previews for OTW Grid Manager', 'otw_cm' )?></label>
						<select id="otw_cm_grid_previews" name="otw_cm_grid_previews" style="width: 100px;">
							<option<?php echo ($db_values['otw_cm_grid_previews'] =='yes' )?' selected="selected"':'';?> value="yes"><?php _e( 'Yes', 'otw_cm' )?></option>
							<option<?php echo ($db_values['otw_cm_grid_previews'] =='no' )?' selected="selected"':'';?> value="no"><?php _e( 'No', 'otw_cm' )?></option>
						</select>
						<p><?php _e( 'Enables shortcode previews in OTW Grid Manager on your pages\' edit screen.', 'otw_cm' );?></p>
					</div>
					<div class="otw-form-settings-field">
						<label for="otw_cm_theme_css"><?php _e( 'Theme default CSS file URL or relative path', 'otw_cm' )?></label>
						<input type="text" id="otw_cm_theme_css" name="otw_cm_theme_css" style="width: 550px;" value="<?php echo $db_values['otw_cm_theme_css']?>" />
						<p><?php _e( 'The full URL or relative path to your theme\'s css file. Example: /stylesheets/my-theme.css. Where /stylesheets is a folder in your theme\'s folder. This will help the shortcodes previews in the back-end to look like the front-end of your site. Leave empty if your theme uses the WordPress standard file name styles.css in the main theme folder.', 'otw_cm' );?></p>
					</div>
					<div class="otw-form-settings-field">
						<label for="otw_cm_front_grid"><?php _e( 'Enable OTW Front-end Grid Manager', 'otw_cm' )?></label>
						<select id="otw_cm_front_grid" name="otw_cm_front_grid" style="width: 100px;">
							<option<?php echo ($db_values['otw_cm_front_grid'] =='yes' )?' selected="selected"':'';?> value="yes"><?php _e( 'Yes', 'otw_cm' )?></option>
							<option<?php echo ($db_values['otw_cm_front_grid'] =='no' )?' selected="selected"':'';?> value="no"><?php _e( 'No', 'otw_cm' )?></option>
						</select>
						<p><?php _e( 'The OTW Front-end Grid Manager will let you edit your layout and its content while you are in the front of your site.', 'otw_cm' );?></p>
					</div>
					<div class="otw-form-settings-field">
						<label for="otw_cm_front_grid_previews"><?php _e( 'Enable Previews for OTW Front-end Grid Manage', 'otw_cm' )?></label>
						<select id="otw_cm_front_grid_previews" name="otw_cm_front_grid_previews" style="width: 100px;">
							<option<?php echo ($db_values['otw_cm_front_grid_previews'] =='yes' )?' selected="selected"':'';?> value="yes"><?php _e( 'Yes', 'otw_cm' )?></option>
							<option<?php echo ($db_values['otw_cm_front_grid_previews'] =='no' )?' selected="selected"':'';?> value="no"><?php _e( 'No', 'otw_cm' )?></option>
						</select>
						<p><?php _e( 'Enables shortcode previews in OTW Front-end Grid Manager on your pages\' front-end.', 'otw_cm' );?></p>
					</div>
					<div class="otw-form-settings-field">
						<label for="otw_cm_portfolio_slug"><?php _e( 'Portfolio lists single posts slug', 'otw_cm' )?></label>
						<input type="text" id="otw_cm_portfolio_slug" name="otw_cm_portfolio_slug" style="width:300px" value="<?php echo $db_values['otw_cm_portfolio_slug']?>" />
					</div>
					<div class="otw-form-settings-field">
						<label for="otw_cm_portfolio_tax_slug"><?php _e( 'Portfolio lists category slug', 'otw_cm' )?></label>
						<input type="text" id="otw_cm_portfolio_tax_slug" name="otw_cm_portfolio_tax_slug" style="width:300px" value="<?php echo $db_values['otw_cm_portfolio_tax_slug']?>" />
					</div>
					<div class="otw-form-settings-field">
						<label for="otw_cm_portfolio_template"><?php _e( 'Portfolio single page template', 'otw_cm' )?></label>
						<select id="otw_cm_portfolio_template" name="otw_cm_portfolio_template" style="width: 250px;">
							<option<?php echo ($db_values['otw_cm_portfolio_template'] =='theme' )?' selected="selected"':'';?> value="theme"><?php _e( 'Default theme post template', 'otw_cm' )?></option>
							<option<?php echo ($db_values['otw_cm_portfolio_template'] =='otw' )?' selected="selected"':'';?> value="otw"><?php _e( 'OTW Template (default)', 'otw_cm' )?></option>
						</select>
					</div>
					<p class="submit">
						<input type="submit" value="<?php _e( 'Save Settings', 'otw_cm') ?>" name="submit" class="button"/>
					</p>
				</div>
			</div>
		</form>
	</div>
</div>

