<?php
/**
 * Process otw cm actions
 *
 */
if( isset( $_POST['otw_cm_action'] ) && current_user_can( 'manage_options' ) ){
	
	require_once( ABSPATH . WPINC . '/pluggable.php' );
	
	if( !$otw_cm_factory_object->is_plugin_active( $otw_cm_plugin_id ) ){
		
		$validate_messages[] = __( 'The plugin is not activated.', 'otw_cm' );
		return;
	}
	switch( $_POST['otw_cm_action'] ){
		
		case 'delete_otw_cm_custom_shortcode':
				
				if( check_admin_referer( 'otw-cm-custom-shortcode-delete' ) ){
					
					$otw_cm_custom_shortcodes = get_option( 'otw_custom_shortcodes' );
					
					if( isset( $otw_cm_custom_shortcodes ) && isset( $otw_cm_custom_shortcodes['shortcodes'] ) && isset( $otw_cm_custom_shortcodes['shortcodes'][ $_POST['otw_custom_shortcode_key'] ] ) ){
						unset( $otw_cm_custom_shortcodes['shortcodes'][ $_POST['otw_custom_shortcode_key'] ] );
					}
					
					update_option( 'otw_custom_shortcodes', $otw_cm_custom_shortcodes );
					
					wp_redirect( 'admin.php?page=otw-cm-custom-shortcodes&message=1' );
				}
			break;
			
		case 'manage_otw_cm_custom_shortcode':
				global $validate_messages;
				
				if( check_admin_referer( 'otw-cm-custom-shortcodes-manage' ) ){
					
					$validate_messages = array();
					
					$otw_cm_custom_shortcodes = get_option( 'otw_custom_shortcodes' );
					
					if( !is_array( $otw_cm_custom_shortcodes ) || !isset( $otw_cm_custom_shortcodes['index'] ) ){
						$otw_cm_custom_shortcodes = array();
						$otw_cm_custom_shortcodes['index'] = 0;
						$otw_cm_custom_shortcodes['shortcodes'] = array();
					}
					
					$valid_page = true;
					
					if( !isset( $_POST['otw_custom_shortcode_title'] ) || !strlen( trim( $_POST['otw_custom_shortcode_title'] ) ) ){
						$valid_page = false;
						$validate_messages[] = __( 'Please type valid shortcode name', 'otw_cm' );
					}
					
					
					if( $valid_page ){
						
						$tmp_shortcodes = $otw_cm_custom_shortcodes['shortcodes'];
						
						$otw_cm_custom_shortcodes['shortcodes'] = array();
						
						$is_new = true;
						
						foreach( $tmp_shortcodes as $cs_key => $cs_data ){
							
							if( isset( $_POST['otw_custom_shortcode_edit'] ) && $_POST['otw_custom_shortcode_edit'] && ( $_POST['otw_custom_shortcode_edit'] == $cs_key ) && isset( $tmp_shortcodes[ $_POST['otw_custom_shortcode_edit'] ] ) ){
								$otw_cm_custom_shortcodes['shortcodes'][ $_POST['otw_custom_shortcode_edit'] ] = $cs_data;
								$is_new = false;
							}else{
								$otw_cm_custom_shortcodes['shortcodes'][ $cs_key ] = $cs_data;
							}
						}
						
						if( !$is_new ){
						
							$otw_cm_custom_shortcodes['shortcodes'][ $_POST['otw_custom_shortcode_edit'] ] = array();
							$otw_cm_custom_shortcodes['shortcodes'][ $_POST['otw_custom_shortcode_edit'] ]['title'] = $_POST['otw_custom_shortcode_title'];
							$otw_cm_custom_shortcodes['shortcodes'][ $_POST['otw_custom_shortcode_edit'] ]['code'] = otw_stripslashes( $_POST['otw_cm_custom_shortcode_code'] );
							
						}else{
							$new_custom_shortcode = array();
							$new_custom_shortcode['title'] = $_POST['otw_custom_shortcode_title'];
							$new_custom_shortcode['code'] = otw_stripslashes( $_POST['otw_cm_custom_shortcode_code'] );
							$otw_cm_custom_shortcodes['index']++;
							$otw_cm_custom_shortcodes['shortcodes'][ $otw_cm_custom_shortcodes['index'] ] = $new_custom_shortcode;
						}
						
						update_option( 'otw_custom_shortcodes', $otw_cm_custom_shortcodes );
						
						wp_redirect( 'admin.php?page=otw-cm-custom-shortcodes&message=1' );
					}
				}
			break;
		case 'manage_otw_cm_import_shortcode_field_option':
				global $validate_messages;
				
				if( check_admin_referer( 'otw_import_shortcode_field_option_edit' ) ){
					
					$validate_messages = array();
					
					$otw_cm_import_shortcodes = get_option( 'otw_import_shortcodes' );
					
					if( !is_array( $otw_cm_import_shortcodes ) ){
						$otw_cm_import_shortcodes = array();
					}
					
					$otw_import_shortcode_key = '';
					
					if( isset( $_GET['import_shortcode'] ) && strlen( trim( $_GET['import_shortcode'] ) ) ){
						$otw_import_shortcode_key = $_GET['import_shortcode'];
					}
					
					$otw_import_shortcode_field_key = '';
					
					if( isset( $_GET['import_shortcode_field'] ) && strlen( trim( $_GET['import_shortcode_field'] ) ) ){
						$otw_import_shortcode_field_key = $_GET['import_shortcode_field'];
					}
					
					$valid_page = true;
					
					if( !isset( $otw_cm_import_shortcodes[ $otw_import_shortcode_key ] ) ){
						$valid_page = false;
						$validate_messages[] = __( 'Invalid imported shortcode', 'otw_cm' );
					}elseif( !isset( $otw_cm_import_shortcodes[ $otw_import_shortcode_key ]['params'][ $otw_import_shortcode_field_key ] ) ){
						$valid_page = false;
						$validate_messages[] = __( 'Invalid imported shortcode field', 'otw_cm' );
					}
					
					if( $valid_page ){
						if( !isset( $_POST['otw_import_shortcode_field_option_key'] ) || !strlen( trim( $_POST['otw_import_shortcode_field_option_key'] ) ) ){
							$valid_page = false;
							$validate_messages[] = __( 'Please type valid option value', 'otw_cm' );
						}
						if( !isset( $_POST['otw_import_shortcode_field_option_name'] ) || !strlen( trim( $_POST['otw_import_shortcode_field_option_name'] ) ) ){
							$valid_page = false;
							$validate_messages[] = __( 'Please type valid option name', 'otw_cm' );
						}
					}
					
					if( $valid_page ){
					
						$option_edit_key = '';
						if( isset( $_POST['otw_import_shortcode_field_option_edit'] ) ){
							$option_edit_key = $_POST['otw_import_shortcode_field_option_edit'];
						}
						
						if( !isset( $otw_cm_import_shortcodes[ $otw_import_shortcode_key ]['params'][ $otw_import_shortcode_field_key ]['options'] ) ){
							$otw_cm_import_shortcodes[ $otw_import_shortcode_key ]['params'][ $otw_import_shortcode_field_key ]['options'] = array();
						}
						
						if( $option_edit_key && ( $option_edit_key != $_POST['otw_import_shortcode_field_option_key'] ) && isset( $otw_cm_import_shortcodes[ $otw_import_shortcode_key ]['params'][ $otw_import_shortcode_field_key ]['options'][ $option_edit_key ] ) ){
							unset( $otw_cm_import_shortcodes[ $otw_import_shortcode_key ]['params'][ $otw_import_shortcode_field_key ]['options'][ $option_edit_key ] );
						}
						
						$otw_cm_import_shortcodes[ $otw_import_shortcode_key ]['params'][ $otw_import_shortcode_field_key ]['options'][ $_POST['otw_import_shortcode_field_option_key'] ] = $_POST['otw_import_shortcode_field_option_name'];
						
						update_option( 'otw_import_shortcodes', $otw_cm_import_shortcodes );
						
						wp_redirect( 'admin.php?page=otw-cm-import-shortcodes-fields-options&import_shortcode='.urlencode( $otw_import_shortcode_key ).'&import_shortcode_field='.urlencode( $otw_import_shortcode_field_key ).'&message=1' );
					}
				}
			break;
		case 'delete_otw_cm_import_shortcode_field':
				
				if( check_admin_referer( 'otw-cm-import-shortcode-field-delete' ) ){
					
					$otw_cm_import_shortcodes = get_option( 'otw_import_shortcodes' );
					
					if( !is_array( $otw_cm_import_shortcodes ) ){
						$otw_cm_import_shortcodes = array();
					}
					
					$otw_import_shortcode_key = '';
					
					if( isset( $_GET['import_shortcode'] ) && strlen( trim( $_GET['import_shortcode'] ) ) ){
						$otw_import_shortcode_key = $_GET['import_shortcode'];
					}
					
					if( isset( $otw_cm_import_shortcodes[ $otw_import_shortcode_key ] ) ){
						
						if( isset( $_POST['otw_import_shortcode_field_key'] ) && isset( $otw_cm_import_shortcodes[ $otw_import_shortcode_key ]['params'][ $_POST['otw_import_shortcode_field_key'] ] ) ){
						
							unset( $otw_cm_import_shortcodes[ $otw_import_shortcode_key ]['params'][ $_POST['otw_import_shortcode_field_key'] ] );
							
							update_option( 'otw_import_shortcodes', $otw_cm_import_shortcodes );
						}
					}
					wp_redirect( 'admin.php?page=otw-cm-import-shortcodes-fields&import_shortcode='.urlencode( $otw_import_shortcode_key ).'&message=1' );
				}
			break;
		case 'manage_otw_cm_import_shortcode_field':
				global $validate_messages;
				
				if( check_admin_referer( 'otw-cm-import-shortcodes-fields-manage' ) ){
					
					$validate_messages = array();
					
					$otw_cm_import_shortcodes = get_option( 'otw_import_shortcodes' );
					
					if( !is_array( $otw_cm_import_shortcodes ) ){
						$otw_cm_import_shortcodes = array();
					}
					
					$otw_import_shortcode_key = '';
					
					if( isset( $_GET['import_shortcode'] ) && strlen( trim( $_GET['import_shortcode'] ) ) ){
						$otw_import_shortcode_key = $_GET['import_shortcode'];
					}
					
					$valid_page = true;
					
					if( !isset( $otw_cm_import_shortcodes[ $otw_import_shortcode_key ] ) ){
						$valid_page = false;
						$validate_messages[] = __( 'Invalid imported shortcode', 'otw_cm' );
					}
					if( $valid_page ){
						if( !isset( $_POST['otw_import_shortcode_field_name'] ) || !strlen( trim( $_POST['otw_import_shortcode_field_name'] ) ) ){
							$valid_page = false;
							$validate_messages[] = __( 'Please type valid field name', 'otw_cm' );
						}
						if( !isset( $_POST['otw_import_shortcode_field_key'] ) || !strlen( trim( $_POST['otw_import_shortcode_field_key'] ) ) ){
							$valid_page = false;
							$validate_messages[] = __( 'Please type valid field key', 'otw_cm' );
						}elseif( isset( $_POST['otw_import_shortcode_field_key'] ) && !preg_match( "/^([0-9a-zA-Z\-\_]+)$/", $_POST['otw_import_shortcode_field_key'] ) ){
							$valid_page = false;
							$validate_messages[] = __( 'Please type valid field key', 'otw_cm' );
						}
					}
					
					if( $valid_page ){
					
						$field_edit_key = '';
						if( isset( $_POST['otw_import_shortcode_field_edit'] ) ){
							$field_edit_key = $_POST['otw_import_shortcode_field_edit'];
						}
						
						$field_key = $_POST['otw_import_shortcode_field_key'];
						if( !isset( $otw_cm_import_shortcodes[ $otw_import_shortcode_key ]['params'] ) ){
							$otw_cm_import_shortcodes[ $otw_import_shortcode_key ]['params'] = array();
						}
						$otw_cm_import_shortcodes[ $otw_import_shortcode_key ]['params'][ $field_key ] = array();
						$otw_cm_import_shortcodes[ $otw_import_shortcode_key ]['params'][ $field_key ]['key'] = $_POST['otw_import_shortcode_field_key'];
						$otw_cm_import_shortcodes[ $otw_import_shortcode_key ]['params'][ $field_key ]['name'] = $_POST['otw_import_shortcode_field_name'];
						$otw_cm_import_shortcodes[ $otw_import_shortcode_key ]['params'][ $field_key ]['description'] = $_POST['otw_import_shortcode_field_description'];
						$otw_cm_import_shortcodes[ $otw_import_shortcode_key ]['params'][ $field_key ]['type'] = $_POST['otw_import_shortcode_field_type'];
						$otw_cm_import_shortcodes[ $otw_import_shortcode_key ]['params'][ $field_key ]['default_value'] = $_POST['otw_import_shortcode_field_default_value'];
						
						if( $field_edit_key && ( $field_edit_key != $field_key ) && isset( $otw_cm_import_shortcodes[ $otw_import_shortcode_key ]['params'][ $field_edit_key ] ) ){
							unset( $otw_cm_import_shortcodes[ $otw_import_shortcode_key ]['params'][ $field_edit_key ] );
						}
						
						update_option( 'otw_import_shortcodes', $otw_cm_import_shortcodes );
						
						wp_redirect( 'admin.php?page=otw-cm-import-shortcodes-fields&import_shortcode='.urlencode( $otw_import_shortcode_key ).'&message=1' );
					}
				}
			break;
		case 'delete_otw_cm_import_shortcode':
				
				if( check_admin_referer( 'otw-cm-import-shortcode-delete' ) ){
					
					$otw_cm_import_shortcodes = get_option( 'otw_import_shortcodes' );
					
					if( !is_array( $otw_cm_import_shortcodes ) ){
						$otw_cm_import_shortcodes = array();
					}
					
					if( $otw_cm_import_shortcodes[ $_POST['otw_import_shortcode_key'] ] ){
						unset( $otw_cm_import_shortcodes[ $_POST['otw_import_shortcode_key'] ] );
					}
					
					update_option( 'otw_import_shortcodes', $otw_cm_import_shortcodes );
					
					wp_redirect( 'admin.php?page=otw-cm-import-shortcodes&message=1' );
				}
			break;
		case 'manage_otw_cm_import_shortcode':
				global $validate_messages;
				
				if( check_admin_referer( 'otw-cm-import-shortcodes-manage' ) ){
					
					$validate_messages = array();
					
					$otw_cm_import_shortcodes = get_option( 'otw_import_shortcodes' );
					
					if( !is_array( $otw_cm_import_shortcodes ) ){
						$otw_cm_import_shortcodes = array();
					}
					
					$valid_page = true;
					
					if( !isset( $_POST['otw_import_shortcode_title'] ) || !strlen( trim( $_POST['otw_import_shortcode_title'] ) ) ){
						$valid_page = false;
						$validate_messages[] = __( 'Please type valid shortcode name', 'otw_cm' );
					}
					if( !isset( $_POST['otw_import_shortcode_key'] ) || !strlen( trim( $_POST['otw_import_shortcode_key'] ) ) ){
						$valid_page = false;
						$validate_messages[] = __( 'Please type valid shortcode key', 'otw_cm' );
					}elseif( isset( $_POST['otw_import_shortcode_key'] ) && !preg_match( "/^([0-9a-zA-Z\-\_]+)$/", $_POST['otw_import_shortcode_key'] ) ){
						$valid_page = false;
						$validate_messages[] = __( 'Please type valid shortcode key', 'otw_cm' );
					}elseif( isset( $_POST['otw_import_shortcode_edit'] ) && !$_POST['otw_import_shortcode_edit'] && array_key_exists( $_POST['otw_import_shortcode_key'], $otw_cm_import_shortcodes ) ){
						$valid_page = false;
						$validate_messages[] = __( 'This shortcode already exists', 'otw_cm' );
					}
					
					if( $valid_page ){
						
						$tmp_shortcodes = $otw_cm_import_shortcodes;
						
						$otw_cm_import_shortcodes = array();
						
						$is_new = true;
						
						foreach( $tmp_shortcodes as $cs_key => $cs_data ){
							
							if( isset( $_POST['otw_import_shortcode_edit'] ) && $_POST['otw_import_shortcode_edit'] && ( $_POST['otw_import_shortcode_edit'] == $cs_key ) ){
								$otw_cm_import_shortcodes[ $_POST['otw_import_shortcode_key'] ] = $cs_data;
								$is_new = false;
							}else{
								$otw_cm_import_shortcodes[ $cs_key ] = $cs_data;
							}
						}
						
						if( $is_new ){
							$otw_cm_import_shortcodes[ $_POST['otw_import_shortcode_key'] ] = array();
							$otw_cm_import_shortcodes[ $_POST['otw_import_shortcode_key'] ]['title'] = $_POST['otw_import_shortcode_title'];
							$otw_cm_import_shortcodes[ $_POST['otw_import_shortcode_key'] ]['content'] = $_POST['otw_import_shortcode_content'];
							$otw_cm_import_shortcodes[ $_POST['otw_import_shortcode_key'] ]['params'] = array();
						}else{
							$otw_cm_import_shortcodes[ $_POST['otw_import_shortcode_key'] ]['content'] = $_POST['otw_import_shortcode_content'];
							$otw_cm_import_shortcodes[ $_POST['otw_import_shortcode_key'] ]['title'] = $_POST['otw_import_shortcode_title'];
						}
						update_option( 'otw_import_shortcodes', $otw_cm_import_shortcodes );
						
						wp_redirect( 'admin.php?page=otw-cm-import-shortcodes&message=1' );
					}
				}
			break;
		case 'delete_otw_cm_skin':
				
				global $otw_cm_skins, $otw_cm_skins_path, $validate_messages;
				
				$validate_messages = array();
				
				if( check_admin_referer( 'otw-cm-skin-delete' ) ){
					
					$skin_to_delete = '';
					
					if( isset( $_POST['otw_skin_title'] ) ){
						$skin_to_delete = $_POST['otw_skin_title'];
					}
					
					if( isset( $skin_to_delete ) && array_key_exists( $skin_to_delete, $otw_cm_skins ) ){
						@unlink( $otw_cm_skins_path.$skin_to_delete.'.css' );
						
						$plugin_options = get_option( 'otw_cm_plugin_options' );
						
						if( isset( $plugin_options['otw_cm_skin'] ) && ( $plugin_options['otw_cm_skin'] == $skin_to_delete ) ){
						
							$plugin_options['otw_cm_skin'] = '';
							update_option( 'otw_cm_plugin_options', $plugin_options );
						}
						
						wp_redirect( 'admin.php?page=otw-cm-skins&message=2' );
					}else{
						$validate_messages[] = __( 'Invalid skin to delete', 'otw_cm' );
					}
				}
			break;
		case 'manage_otw_cm_skin':
				global $otw_cm_skins, $otw_cm_skins_path, $validate_messages;
				
				$validate_messages = array();
				
				if( check_admin_referer( 'otw-cm-skin-manage' ) ){
					
					$valid_page = true;
					
					if( !isset( $_POST['otw_skin_title'] ) || !strlen( trim( $_POST['otw_skin_title'] ) ) ){
						$valid_page = false;
						$validate_messages[] = __( 'Please type valid skin name', 'otw_cm' );
					}elseif( !otw_cm_valid_skin_name( $_POST['otw_skin_title'] ) ){
						$valid_page = false;
						$validate_messages[] = __( 'Please type valid skin name', 'otw_cm' );
					}elseif( isset( $_POST['otw_skin_edit'] ) && !$_POST['otw_skin_edit'] && array_key_exists( $_POST['otw_skin_title'], $otw_cm_skins ) ){
						$valid_page = false;
						$validate_messages[] = __( 'The skin with same name already exists', 'otw_cm' );
					}
					
					if( $valid_page ){
						
						
						$fp = @fopen( $otw_cm_skins_path.$_POST['otw_skin_title'].'.css', 'w' );
						
						if( $fp ){
							fwrite( $fp, otw_stripslashes( $_POST['otw_skin_content'] ) );
							fclose( $fp );
						}else{
							$valid_page = false;
							$validate_messages[] = __( 'Error, can not safe the skin file. Check folder perimitions.', 'otw_cm' );
						}
						wp_redirect( 'admin.php?page=otw-cm-skins&message=1' );
					}
				}
			break;
		case 'otw_cm_settings_action':
				
				global $wp_cm_tmc_items, $wp_cm_agm_items, $otw_cm_skins, $wp_cm_cs_items;
				
				if( check_admin_referer( 'otw-cm-settings' ) ){
					
					$options = array();
					
					$options['shortcode_editor_button_for'] = array();
					
					foreach( $wp_cm_tmc_items as $wp_item_type => $wpItem ){
						if( isset( $_POST['otw_cm_editor_shortcodes'] ) && is_array( $_POST['otw_cm_editor_shortcodes'] ) && isset( $_POST['otw_cm_editor_shortcodes'][ $wp_item_type ] ) ){
							$options['shortcode_editor_button_for'][ $wp_item_type ] = $_POST['otw_cm_editor_shortcodes'][ $wp_item_type ];
						}else{
							$options['shortcode_editor_button_for'][ $wp_item_type ] = 0;
						}
					}
					
					foreach( $wp_cm_agm_items as $wp_item_type => $wpItem ){
						if( isset( $_POST['otw_cm_grid'] ) && is_array( $_POST['otw_cm_grid'] ) && isset( $_POST['otw_cm_grid'][ $wp_item_type ] ) ){
							$options['grid_for'][ $wp_item_type ] = $_POST['otw_cm_grid'][ $wp_item_type ];
						}else{
							$options['grid_for'][ $wp_item_type ] = 0;
						}
					}
					
					foreach( $wp_cm_cs_items as $wp_item_type => $wpItem ){
						if( isset( $_POST['otw_cm_cs'] ) && is_array( $_POST['otw_cm_cs'] ) && isset( $_POST['otw_cm_cs'][ $wp_item_type ] ) ){
							$options['cs_for'][ $wp_item_type ] = $_POST['otw_cm_cs'][ $wp_item_type ];
						}else{
							$options['cs_for'][ $wp_item_type ] = 0;
						}
					}
					
					$options['otw_cm_skin'] = '';
					if( isset( $_POST['otw_cm_skin'] ) && array_key_exists( $_POST['otw_cm_skin'], $otw_cm_skins ) ){
						$options['otw_cm_skin'] = $_POST['otw_cm_skin'];
					}
					
					$options['otw_cm_grid_previews'] = '';
					if( isset( $_POST['otw_cm_grid_previews'] ) ){
						$options['otw_cm_grid_previews'] = $_POST['otw_cm_grid_previews'];
					}
					
					$options['otw_cm_portfolio_slug'] = '';
					if( isset( $_POST['otw_cm_portfolio_slug'] ) ){
						$options['otw_cm_portfolio_slug'] = $_POST['otw_cm_portfolio_slug'];
					}
					
					$options['otw_cm_portfolio_template'] = '';
					if( isset( $_POST['otw_cm_portfolio_template'] ) ){
						$options['otw_cm_portfolio_template'] = $_POST['otw_cm_portfolio_template'];
					}
					
					$options['otw_cm_portfolio_tax_slug'] = '';
					if( isset( $_POST['otw_cm_portfolio_tax_slug'] ) ){
						$options['otw_cm_portfolio_tax_slug'] = $_POST['otw_cm_portfolio_tax_slug'];
					}
					
					$options['otw_cm_front_grid_previews'] = '';
					if( isset( $_POST['otw_cm_front_grid_previews'] ) ){
						$options['otw_cm_front_grid_previews'] = $_POST['otw_cm_front_grid_previews'];
					}
					
					$options['otw_cm_front_grid'] = '';
					if( isset( $_POST['otw_cm_front_grid'] ) ){
						$options['otw_cm_front_grid'] = $_POST['otw_cm_front_grid'];
					}
					
					$options['otw_cm_theme_css'] = '';
					if( isset( $_POST['otw_cm_theme_css'] ) ){
						$options['otw_cm_theme_css'] = $_POST['otw_cm_theme_css'];
					}
					
					update_option( 'otw_cm_plugin_options', $options );
					
					if( isset( $_POST['otw_cm_promotions'] ) && !empty( $_POST['otw_cm_promotions'] ) ){
						
						global $otw_cm_factory_object, $otw_cm_plugin_id;
						
						update_option( $otw_cm_plugin_id.'_dnms', $_POST['otw_cm_promotions'] );
						
						if( is_object( $otw_cm_factory_object ) ){
							$otw_cm_factory_object->retrive_plungins_data( true );
						}
					}
					
					wp_redirect( admin_url( 'admin.php?page=otw-cm-settings&message=1' ) );
				}
			break;
	}
}
?>