<?php
global $validate_messages, $otw_import_shortcode_field_types;

$page_title = __( 'Import Shortcode', 'otw_cm' );

$otw_cm_import_shortcodes = get_option( 'otw_import_shortcodes' );

if( !is_array( $otw_cm_import_shortcodes ) ){
	$otw_cm_import_shortcodes = array();
}

$otw_import_shortcode_values = array();
$otw_import_shortcode_values['name'] = '';
$otw_import_shortcode_values['key'] = '';
$otw_import_shortcode_values['content'] = '';

$requested_shortcode = '';
if( isset( $_GET['import_shortcode'] ) && array_key_exists( urldecode( $_GET['import_shortcode'] ), $otw_cm_import_shortcodes ) ){
	$requested_shortcode = urldecode( $_GET['import_shortcode'] );
	$otw_import_shortcode_values['key'] = urldecode( $_GET['import_shortcode'] );
	$otw_import_shortcode_values['name'] =  $otw_cm_import_shortcodes[ urldecode( $_GET['import_shortcode'] ) ]['title'];
	$otw_import_shortcode_values['content'] =  $otw_cm_import_shortcodes[ urldecode( $_GET['import_shortcode'] ) ]['content'];
	$page_title = __( 'Edit imported shortcode', 'otw_cm' );
}

if( isset( $_POST['otw_import_shortcode_title'] ) ){
	$otw_import_shortcode_values['name'] = otw_stripslashes( $_POST['otw_import_shortcode_title'] );
}
if( isset( $_POST['otw_import_shortcode_key'] ) ){
	$otw_import_shortcode_values['key'] = otw_stripslashes( $_POST['otw_import_shortcode_key'] );
}
if( isset( $_POST['otw_import_shortcode_content'] ) ){
	$otw_import_shortcode_values['content'] = otw_stripslashes( $_POST['otw_import_shortcode_content'] );
}
?>
<div class="wrap">
	<div id="icon-edit" class="icon32"><br/></div>
	<h2>
		<?php echo $page_title; ?>
		<a class="button add-new-h2" href="<?php echo admin_url( 'admin.php?page=otw-cm-import-shortcodes' )?>" ><?php _e('Back to available imported shortcodes', 'otw_cm')?></a>
	</h2>
	<?php if( isset( $validate_messages ) && count( $validate_messages ) ){?>
		<div id="message" class="error">
			<?php foreach( $validate_messages as $v_message ){
				echo '<p>'.$v_message.'</p>';
			}?>
		</div>
	<?php }?>
	<div class="form-wrap" id="poststuff">
		<?php include_once( 'otw_cm_help.php' );?>
		<div class="updated">
			<p><?php _e( 'Import shortcodes from other plugins and your theme so you can use them in the Content Manager plugin interfaces.<br />For example you have a [mygallery] shortcode that generates a gallery and you want to use that gallery in a custom page layout created with the Content Manager plugin.<br />Import that shortcode so you can have it in the interface along with the other OTW shortcodes.', 'otw_cm' );?></p>
		</div>
		<form method="post" action="" class="validate">
			<input type="hidden" name="otw_cm_action" value="manage_otw_cm_import_shortcode" />
			<input type="hidden" name="otw_import_shortcode_edit" value="<?php echo $requested_shortcode?>" />
			<?php wp_original_referer_field(true, 'previous'); wp_nonce_field('otw-cm-import-shortcodes-manage'); ?>
			<div id="post-body">
				<div id="post-body-content">
					<div class="form-field form-required">
						<label for="otw_import_shortcode_title"><?php _e( 'Shortcode label', 'otw_cm' );?></label>
						<input type="text" id="otw_import_shortcode_title" value="<?php echo $otw_import_shortcode_values['name']?>" tabindex="1" style="width: 460px;" size="100" name="otw_import_shortcode_title"/>
						<p><?php _e( 'The label is how you are going to see your shortcode in the OTW interface.', 'otw_cm' );?></p>
					</div>
					<div class="form-field form-required">
						<label for="otw_import_shortcode_key"><?php _e( 'Shortcode name/key', 'otw_cm' );?></label>
						<input type="text" id="otw_import_shortcode_key" value="<?php echo $otw_import_shortcode_values['key']?>" tabindex="2" style="width: 460px;" size="100" name="otw_import_shortcode_key"/>
						<p><?php _e( 'The name/key of the shortcode. For example mygallery if you call the shortcode by [mygallery] or [mygallery]content[/mygallery].', 'otw_cm' );?></p>
					</div>
					<div class="form-field form-required">
						<label for="otw_import_shortcode_content"><?php _e( 'Shortcode content', 'otw_cm' );?></label>
						<select id="otw_import_shortcode_content" tabindex="3"  name="otw_import_shortcode_content">
							<option value="no"<?php echo ( $otw_import_shortcode_values['content'] == 'no' )?' selected="selected"':'' ?>><?php _e('--No content--','otw_cm')?></option>
							<?php foreach( $otw_import_shortcode_field_types as $field_type => $field_name ){?>
								<?php if( !in_array( $field_type, array( 'uploader', 'checkbox', 'select' ) ) ){?>
									<option value="<?php echo $field_type?>"<?php echo ( $otw_import_shortcode_values['content'] == $field_type )?' selected="selected"':'' ?>><?php echo $field_name?></option>
								<?php }?>
							<?php }?>
							
						</select>
						<p><?php _e( 'Example [mygallery]content[/mygallery]. This field will help you easily place your content once you select this shortcode in the OTW interface.', 'otw_cm' );?></p>
					</div>
					<p class="submit">
						<input type="submit" value="<?php _e( 'Save', 'otw_cm') ?>" name="submit" class="button" tabindex="4"/>
					</p>
				</div>
			</div>
		</form>
	</div>
</div>
