<?php
global $_wp_column_headers, $otw_import_shortcode_field_types;

$otw_cm_import_shortcodes = get_option( 'otw_import_shortcodes' );
$otw_cm_import_shortcode_key = '';
$otw_cm_import_shortcode = false;

if( isset( $_GET['import_shortcode'] ) ){
	$otw_cm_import_shortcode_key = urldecode( $_GET['import_shortcode'] );
}

if( !is_array( $otw_cm_import_shortcodes ) ){
	$otw_cm_import_shortcodes = array();
}

if( isset( $otw_cm_import_shortcodes[ $otw_cm_import_shortcode_key ] ) ){
	$otw_cm_import_shortcode = $otw_cm_import_shortcodes[ $otw_cm_import_shortcode_key ];
}else{
	wp_die( __( 'Invalid imported shortcode', 'otw_cm' ) );
}

$_wp_column_headers['toplevel_page_otw-cm-import-shortcodes'] = array(
	'name' => __( 'Field Name', 'otw_cm' ),
	'type' => __( 'Field Type', 'otw_cm' ),
	'description' => __( 'Field Description', 'otw_cm' ),
	'default_value' => __( 'Default Value', 'otw_cm' )
);

$message = '';
$massages = array();
$messages[1] = __( 'Imported shortcode field saved', 'otw_cm' );
$messages[2] = __( 'Imported shortcode field deleted', 'otw_cm' );

if( isset( $_GET['message'] ) && isset( $messages[ $_GET['message'] ] ) ){
	$message .= $messages[ $_GET['message'] ];
}
?>
<?php if ( $message ) : ?>
<div id="message" class="updated"><p><?php echo $message; ?></p></div>
<?php endif ?>
<div class="wrap">
	<div id="icon-edit" class="icon32"><br/></div>
	<h2>
		<?php _e('Imported Shortcodes Fields', 'otw_cm') ?>
		<a class="button add-new-h2" href="admin.php?page=otw-cm-import-shortcodes"><?php _e('Back To Shortcodes', 'otw_cm') ?></a>
		<a class="button add-new-h2" href="admin.php?page=otw-cm-import-shortcodes-fields-manage&import_shortcode=<?php echo urlencode( $otw_cm_import_shortcode_key) ?>""><?php _e('Add Shortcode Field', 'otw_cm') ?></a>
	</h2>
	<h3>
		<?php _e( 'Imported Shortcode:', 'otw_cm' )?> <?php echo $otw_cm_import_shortcode['title'];?>
	</h3>
	<form class="search-form form-wrap" action="" method="get">
		<?php include_once( 'otw_cm_help.php' );?>
	</form>
	
	<br class="clear" />
	<?php if( is_array( $otw_cm_import_shortcode['params'] ) && count( $otw_cm_import_shortcode['params'] ) ){?>
		<table class="widefat fixed" cellspacing="0">
			<thead>
				<tr>
					<?php foreach( $_wp_column_headers['toplevel_page_otw-cm-import-shortcodes'] as $key => $name ){?>
						<th><?php echo $name?></th>
					<?php }?>
				</tr>
			</thead>
			<tfoot>
				<tr>
					<?php foreach( $_wp_column_headers['toplevel_page_otw-cm-import-shortcodes'] as $key => $name ){?>
						<th><?php echo $name?></th>
					<?php }?>
				</tr>
			</tfoot>
			<tbody>
			<?php foreach( $otw_cm_import_shortcode['params'] as $import_shortcode_field_key => $import_shortcode_field_item ){?>
				<tr>
					<?php foreach( $_wp_column_headers['toplevel_page_otw-cm-import-shortcodes'] as $column_name => $column_title ){
						
						$edit_link = admin_url( 'admin.php?page=otw-cm-import-shortcodes-fields-manage&amp;action=edit&amp;import_shortcode='.urlencode( $otw_cm_import_shortcode_key ).'&amp;import_shortcode_field='.urlencode( $import_shortcode_field_key ) );
						$delete_link = admin_url( 'admin.php?page=otw-cm-import-shortcodes-fields-delete&amp;import_shortcode='.urlencode( $otw_cm_import_shortcode_key ).'&amp;import_shortcode_field='.urlencode( $import_shortcode_field_key ) );
						$options_link = admin_url( 'admin.php?page=otw-cm-import-shortcodes-fields-options&amp;import_shortcode='.urlencode( $otw_cm_import_shortcode_key ).'&amp;import_shortcode_field='.urlencode( $import_shortcode_field_key ) );
						
						switch($column_name) {
						
							case 'name':
								
									echo '<td><strong><a href="'.$edit_link.'" title="'.esc_attr(sprintf(__('Edit &#8220;%s&#8221;', 'otw_cm'), $otw_cm_import_shortcode_key)).'">'.$import_shortcode_field_item['name'].'</a></strong><br />';
									
									echo '<div class="row-actions">';
									echo '<a href="'.$edit_link.'">' . __('Edit', 'otw_cm') . '</a>';
									echo ' | <a href="'.$delete_link.'">' . __('Delete', 'otw_cm'). '</a>';
									
									echo '</div>';
									
									echo '</td>';
								break;
							case 'key':
									echo '<td>'.$import_shortcode_field_key.'</td>';
								break;
							case 'type':
									echo '<td>';
									
									if( isset( $otw_import_shortcode_field_types[ $import_shortcode_field_item['type'] ] ) ){
										echo $otw_import_shortcode_field_types[ $import_shortcode_field_item['type'] ];
										
										if( $import_shortcode_field_item['type'] == 'select' ){
											echo '<div>';
												echo '<a href="'.$options_link.'">' . __('Options', 'otw_cm') . '</a>';
											echo '</div>';
										}
									}
									
									echo '</td>';
								break;
							case 'description':
									echo '<td>'.$import_shortcode_field_item['description'].'</td>';
								break;
							case 'default_value':
									echo '<td>'.$import_shortcode_field_item['default_value'].'</td>';
								break;
						}
					?>
					
					<?php }?>
				</tr>
			<?php }?>
			</tbody>
		</table>
		
	<?php }else{ ?>
		<p><?php _e('No custom fields for this shortcode found.', 'otw_cm' )?></p>
	<?php } ?>
</div>