<?php
global $_wp_column_headers;

$otw_cm_import_shortcodes = get_option( 'otw_import_shortcodes' );

if( !is_array( $otw_cm_import_shortcodes ) ){
	$otw_cm_import_shortcodes = array();
}

$_wp_column_headers['toplevel_page_otw-cm-import-shortcodes'] = array(
	'name' => __( 'Shortcode Label', 'otw_cm' ),
	'key' => __( 'Shortcode Name', 'otw_cm' )
);

$message = '';
$massages = array();
$messages[1] = __( 'Imported shortcode saved', 'otw_cm' );
$messages[2] = __( 'Imported shortcode deleted', 'otw_cm' );

if( isset( $_GET['message'] ) && isset( $messages[ $_GET['message'] ] ) ){
	$message .= $messages[ $_GET['message'] ];
}
?>
<?php if ( $message ) : ?>
<div id="message" class="updated"><p><?php echo $message; ?></p></div>
<?php endif ?>
<div class="wrap">
	<div id="icon-edit" class="icon32"><br/></div>
	<h2>
		<?php _e('Imported Shortcodes', 'otw_cm') ?>
		<a class="button add-new-h2" href="admin.php?page=otw-cm-import-shortcodes-manage"><?php _e('Import shortcode', 'otw_cm') ?></a>
	</h2>
	
	<form class="search-form form-wrap" action="" method="get">
		<?php include_once( 'otw_cm_help.php' );?>
	</form>
	<div class="updated">
		<p><?php _e( 'Import shortcodes from other plugins and your theme so you can use them in the Content Manager plugin interfaces.<br />For example you have a [mygallery] shortcode that generates a gallery and you want to use that gallery in a custom page layout created with the Content Manager plugin.<br />Import that shortcode so you can have it in the interface along with the other OTW shortcodes.', 'otw_cm' );?></p>
	</div>
	<br class="clear" />
	<?php if( is_array( $otw_cm_import_shortcodes ) && count( $otw_cm_import_shortcodes ) ){?>
		<table class="widefat fixed" cellspacing="0">
			<thead>
				<tr>
					<?php foreach( $_wp_column_headers['toplevel_page_otw-cm-import-shortcodes'] as $key => $name ){?>
						<th><?php echo $name?></th>
					<?php }?>
				</tr>
			</thead>
			<tfoot>
				<tr>
					<?php foreach( $_wp_column_headers['toplevel_page_otw-cm-import-shortcodes'] as $key => $name ){?>
						<th><?php echo $name?></th>
					<?php }?>
				</tr>
			</tfoot>
			<tbody>
			<?php foreach( $otw_cm_import_shortcodes as $import_shortcode_key => $import_shortcode_item ){?>
				<tr>
					<?php foreach( $_wp_column_headers['toplevel_page_otw-cm-import-shortcodes'] as $column_name => $column_title ){
						
						$edit_link = admin_url( 'admin.php?page=otw-cm-import-shortcodes-manage&amp;action=edit&amp;import_shortcode='.urlencode( $import_shortcode_key ) );
						$delete_link = admin_url( 'admin.php?page=otw-cm-import-shortcodes-delete&amp;import_shortcode='.urlencode( $import_shortcode_key ) );
						$fields_link = admin_url( 'admin.php?page=otw-cm-import-shortcodes-fields&amp;import_shortcode='.urlencode( $import_shortcode_key ) );
						
						switch($column_name) {
						
							case 'name':
								
									echo '<td><strong><a href="'.$edit_link.'" title="'.esc_attr(sprintf(__('Edit &#8220;%s&#8221;', 'otw_cm'), $import_shortcode_key)).'">'.$import_shortcode_item['title'].'</a></strong><br />';
									
									echo '<div class="row-actions">';
									echo '<a href="'.$edit_link.'">' . __('Edit', 'otw_cm') . '</a>';
									echo ' | <a href="'.$fields_link.'">' . __('Fields', 'otw_cm'). '</a>';
									echo ' | <a href="'.$delete_link.'">' . __('Delete', 'otw_cm'). '</a>';
									
									echo '</div>';
									
									echo '</td>';
								break;
							case 'key':
								
									echo '<td>'.$import_shortcode_key.'</td>';
								break;
						}
					?>
					
					<?php }?>
				</tr>
			<?php }?>
			</tbody>
		</table>
		
	<?php }else{ ?>
		<p><?php _e('No imported shortcodes found.', 'otw_cm' )?></p>
	<?php } ?>
</div>