<?php

/**
 * Init function
 */
if (!function_exists('otw_cm_widgets_init')) {

    function otw_cm_widgets_init() {

        global $otw_components;

        if (isset($otw_components['registered']) && isset($otw_components['registered']['otw_shortcode'])) {

            $shortcode_components = $otw_components['registered']['otw_shortcode'];
            arsort($shortcode_components);

            foreach ($shortcode_components as $shortcode) {
                if (is_file($shortcode['path'] . '/widgets/otw_shortcode_widget.class.php')) {

                    include_once( $shortcode['path'] . '/widgets/otw_shortcode_widget.class.php' );
                    break;
                }
            }
        }
        register_widget('OTW_Shortcode_Widget');
    }

}
/**
 * Init function
 */
if (!function_exists('otw_cm_init')) {

    function otw_cm_init() {

        global $otw_cm_plugin_url, $otw_cm_plugin_options, $otw_cm_grid_manager_component, $otw_cm_front_end_grid_manager_component, $otw_cm_shortcode_component, $otw_cm_shortcode_object, $otw_cm_form_component, $otw_cm_validator_component, $otw_cm_form_object, $otw_cm_content_sidebars_object, $otw_cm_skin, $wp_cm_cs_items, $otw_cm_js_version, $otw_cm_css_version, $wp_widget_factory, $otw_cm_image_component, $otw_cm_image_profile, $otw_cm_image_object, $otw_cm_plugin_id, $otw_cm_factory_object;

        if (is_admin()) {


            add_action('admin_menu', 'otw_cm_init_admin_menu');

            add_action('admin_print_styles', 'otw_cm_enqueue_admin_styles');

            add_action('admin_enqueue_scripts', 'otw_cm_enqueue_admin_scripts');
            
            add_action( 'add_meta_boxes', 'cm_portfolio_meta_box', 10, 2 );
            
            add_action( 'save_post', 'cm_save_portfolio_meta_box' );
            
	    add_filter( 'otwfcr_notice', 'otw_cm_factory_message' );
        }
        
	otw_cm_register_portfolio_custom_types();
	
	if( !isset( $otw_cm_plugin_options['otw_cm_portfolio_template'] ) || ( $otw_cm_plugin_options['otw_cm_portfolio_template'] != 'theme' ) ){
		add_filter('single_template', 'otw_cm_portfolio_template');
	}
	add_filter('the_content', 'otw_cm_simple_portfolio_template');
	add_filter( 'get_post_metadata', 'otw_cm_portfolio_thumbnail_metadata', 99, 5 );
	add_filter( 'post_thumbnail_html', 'otw_cm_portfolio_thumbnail', 99, 5 );
	

        //get the custom shortcodes
        $otw_cm_custom_shortcodes = get_option('otw_custom_shortcodes');

        if (!is_array($otw_cm_custom_shortcodes)) {
            $otw_cm_custom_shortcodes = array();
        }

        //get the imported shortcodes
        $otw_cm_import_shortcodes = get_option('otw_import_shortcodes');

        if (!is_array($otw_cm_import_shortcodes)) {
            $otw_cm_import_shortcodes = array();
        }

        //otw grid manager component
        $otw_cm_front_end_grid_manager_component = otw_load_component('otw_front_end_grid_manager');
        $otw_cm_front_end_grid_manager_object = otw_get_component($otw_cm_front_end_grid_manager_component);
        $otw_cm_front_end_grid_manager_object->js_version = $otw_cm_js_version;
        $otw_cm_front_end_grid_manager_object->css_version = $otw_cm_css_version;
        if (isset($otw_cm_plugin_options['otw_cm_front_grid']) && ( $otw_cm_plugin_options['otw_cm_front_grid'] == 'no' )) {
            $otw_cm_front_end_grid_manager_object->enabled = false;
        } else {
            $otw_cm_front_end_grid_manager_object->enabled = true;
        }

        if (isset($otw_cm_plugin_options['otw_cm_front_grid_previews']) && ( $otw_cm_plugin_options['otw_cm_front_grid_previews'] == 'yes' )) {
            $otw_cm_front_end_grid_manager_object->shortcode_preview_in_grid = true;
        } else {
            $otw_cm_front_end_grid_manager_object->shortcode_preview_in_grid = false;
        }
        $otw_cm_front_end_grid_manager_object->init();

        //otw grid manager component
        $otw_cm_grid_manager_component = otw_load_component('otw_grid_manager');
        $otw_cm_grid_manager_object = otw_get_component($otw_cm_grid_manager_component);
        $otw_cm_grid_manager_object->js_version = $otw_cm_js_version;
        $otw_cm_grid_manager_object->css_version = $otw_cm_css_version;
        $otw_cm_grid_manager_object->active_for['page'] = false;
        $otw_cm_grid_manager_object->active_for['post'] = false;
        $otw_cm_grid_manager_object->active_for['cpt'] = false;
        $otw_cm_grid_manager_object->front_editor = $otw_cm_front_end_grid_manager_object;

        if (isset($otw_cm_plugin_options['otw_cm_grid_previews']) && ( $otw_cm_plugin_options['otw_cm_grid_previews'] == 'yes' )) {
            $otw_cm_grid_manager_object->shortcode_preview_in_grid = true;
        } else {
            $otw_cm_grid_manager_object->shortcode_preview_in_grid = false;
        }

        if (isset($otw_cm_plugin_options['grid_for']) && isset($otw_cm_plugin_options['grid_for']['page']) && $otw_cm_plugin_options['grid_for']['page']) {
            $otw_cm_grid_manager_object->active_for['page'] = true;
        } elseif (!isset($otw_cm_plugin_options['grid_for'])) {
            $otw_cm_grid_manager_object->active_for['page'] = true;
        }

        if (isset($otw_cm_plugin_options['grid_for']) && isset($otw_cm_plugin_options['grid_for']['post']) && $otw_cm_plugin_options['grid_for']['post']) {
            $otw_cm_grid_manager_object->active_for['post'] = true;
        } elseif (!isset($otw_cm_plugin_options['grid_for'])) {
            $otw_cm_grid_manager_object->active_for['post'] = true;
        }

        if (isset($otw_cm_plugin_options['grid_for']) && isset($otw_cm_plugin_options['grid_for']['cpt']) && $otw_cm_plugin_options['grid_for']['cpt']) {
            $otw_cm_grid_manager_object->active_for['cpt'] = true;
        } elseif (!isset($otw_cm_plugin_options['grid_for'])) {
            $otw_cm_grid_manager_object->active_for['cpt'] = true;
        }

        include_once( plugin_dir_path(__FILE__) . 'otw_labels/otw_cm_grid_manager_object.labels.php' );
        $otw_cm_grid_manager_object->init();
        
        $otw_cm_factory_component = otw_load_component( 'otw_factory' );
	$otw_cm_factory_object = otw_get_component( $otw_cm_factory_component );
	$otw_cm_factory_object->add_plugin( $otw_cm_plugin_id, dirname( dirname( __FILE__ ) ).'/otw_content_manager.php', array( 'menu_parent' => 'otw-cm-settings', 'lc_name' => __( 'License Manager', 'otw_cm' ), 'menu_key' => 'otw-cm' ) );
	
	include_once( plugin_dir_path( __FILE__ ).'otw_labels/otw_cm_factory_object.labels.php' );
	$otw_cm_factory_object->init();



        //shortcode component
        $otw_cm_shortcode_component = otw_load_component('otw_shortcode');
        $otw_cm_shortcode_object = otw_get_component($otw_cm_shortcode_component);
        $otw_cm_shortcode_object->js_version = $otw_cm_js_version;
        $otw_cm_shortcode_object->css_version = $otw_cm_css_version;
        $otw_cm_shortcode_object->editor_button_active_for['page'] = false;
        $otw_cm_shortcode_object->editor_button_active_for['post'] = false;
        $otw_cm_shortcode_object->editor_button_active_for['cpt'] = false;

        //in case of front grid manager
        if ($otw_cm_front_end_grid_manager_object->enabled) {
            $otw_cm_shortcode_object->init_in_front = is_user_logged_in();
        }

        if (isset($otw_cm_plugin_options['shortcode_editor_button_for']) && isset($otw_cm_plugin_options['shortcode_editor_button_for']['page']) && $otw_cm_plugin_options['shortcode_editor_button_for']['page']) {
            $otw_cm_shortcode_object->editor_button_active_for['page'] = true;
        } elseif (!isset($otw_cm_plugin_options['shortcode_editor_button_for'])) {
            $otw_cm_shortcode_object->editor_button_active_for['page'] = true;
        }

        if (isset($otw_cm_plugin_options['shortcode_editor_button_for']) && isset($otw_cm_plugin_options['shortcode_editor_button_for']['post']) && $otw_cm_plugin_options['shortcode_editor_button_for']['post']) {
            $otw_cm_shortcode_object->editor_button_active_for['post'] = true;
        } elseif (!isset($otw_cm_plugin_options['shortcode_editor_button_for'])) {
            $otw_cm_shortcode_object->editor_button_active_for['post'] = true;
        }

        if (isset($otw_cm_plugin_options['shortcode_editor_button_for']) && isset($otw_cm_plugin_options['shortcode_editor_button_for']['cpt']) && $otw_cm_plugin_options['shortcode_editor_button_for']['cpt']) {
            $otw_cm_shortcode_object->editor_button_active_for['cpt'] = true;
        } elseif (!isset($otw_cm_plugin_options['shortcode_editor_button_for'])) {
            $otw_cm_shortcode_object->editor_button_active_for['cpt'] = true;
        }

        $otw_cm_shortcode_object->add_default_external_lib('css', 'style', get_stylesheet_directory_uri() . '/style.css', 'live_preview', 10);

        if (isset($otw_cm_plugin_options['otw_cm_theme_css']) && strlen($otw_cm_plugin_options['otw_cm_theme_css'])) {

            if (preg_match("/^http(s)?\:\/\//", $otw_cm_plugin_options['otw_cm_theme_css'])) {
                $otw_cm_shortcode_object->add_default_external_lib('css', 'theme_style', $otw_cm_plugin_options['otw_cm_theme_css'], 'live_preview', 11);
            } else {
                $otw_cm_shortcode_object->add_default_external_lib('css', 'theme_style', get_stylesheet_directory_uri() . '/' . $otw_cm_plugin_options['otw_cm_theme_css'], 'live_preview', 11);
            }
        }

        if ($otw_cm_skin) {
            $otw_cm_shortcode_object->add_default_external_lib('css', 'otw_content_manager', $otw_cm_plugin_url . '/skins/' . $otw_cm_skin . '.css', 'live_preview', 200);
        }
        $otw_cm_shortcode_object->shortcodes['icon_box'] = array('title' => __('Icon Box', 'otw_cm'), 'enabled' => true, 'children' => false, 'parent' => false, 'order' => -12, 'path' => dirname(__FILE__) . '/otw_components/otw_shortcode/', 'url' => $otw_cm_plugin_url . '/include/otw_components/otw_shortcode/');
//        $otw_cm_shortcode_object->shortcodes['login'] = array('title' => __('Login', 'otw_cm'), 'enabled' => true, 'children' => false, 'parent' => false, 'order' => -13, 'path' => dirname(__FILE__) . '/otw_components/otw_shortcode/', 'url' => $otw_cm_plugin_url . '/include/otw_components/otw_shortcode/');
        $otw_cm_shortcode_object->shortcodes['info_list'] = array('title' => __('Info List', 'otw_cm'), 'enabled' => true, 'children' => false, 'parent' => false, 'order' => -11, 'path' => dirname(__FILE__) . '/otw_components/otw_shortcode/', 'url' => $otw_cm_plugin_url . '/include/otw_components/otw_shortcode/');
        $otw_cm_shortcode_object->shortcodes['flipbox'] = array('title' => __(' Flip Box', 'otw_cm'), 'enabled' => true, 'children' => false, 'parent' => false, 'order' => -10, 'path' => dirname(__FILE__) . '/otw_components/otw_shortcode/', 'url' => $otw_cm_plugin_url . '/include/otw_components/otw_shortcode/');
        $otw_cm_shortcode_object->shortcodes['countdown'] = array('title' => __('Count Down', 'otw_cm'), 'enabled' => true, 'children' => false, 'parent' => false, 'order' => -9, 'path' => dirname(__FILE__) . '/otw_components/otw_shortcode/', 'url' => $otw_cm_plugin_url . '/include/otw_components/otw_shortcode/');
        $otw_cm_shortcode_object->shortcodes['progressbar'] = array('title' => __('Progress Bar', 'otw_cm'), 'enabled' => true, 'children' => false, 'parent' => false, 'order' => -8, 'path' => dirname(__FILE__) . '/otw_components/otw_shortcode/', 'url' => $otw_cm_plugin_url . '/include/otw_components/otw_shortcode/');
        $otw_cm_shortcode_object->shortcodes['animatedimg'] = array('title' => __('Animated Image', 'otw_cm'), 'enabled' => true, 'children' => false, 'parent' => false, 'order' => -7, 'path' => dirname(__FILE__) . '/otw_components/otw_shortcode/', 'url' => $otw_cm_plugin_url . '/include/otw_components/otw_shortcode/');
        $otw_cm_shortcode_object->shortcodes['gallery'] = array('title' => __('Gallery', 'otw_cm'), 'enabled' => true, 'children' => false, 'parent' => false, 'order' => -6, 'path' => dirname(__FILE__) . '/otw_components/otw_shortcode/', 'url' => $otw_cm_plugin_url . '/include/otw_components/otw_shortcode/');
        $otw_cm_shortcode_object->shortcodes['clientslider'] = array('title' => __('Clients Slider', 'otw_cm'), 'enabled' => true, 'children' => false, 'parent' => false, 'order' => -5, 'path' => dirname(__FILE__) . '/otw_components/otw_shortcode/', 'url' => $otw_cm_plugin_url . '/include/otw_components/otw_shortcode/');
        $otw_cm_shortcode_object->shortcodes['animatedtestimonials'] = array('title' => __('Testimonial Animated', 'otw_cm'), 'enabled' => true, 'children' => false, 'parent' => false, 'order' => -4, 'path' => dirname(__FILE__) . '/otw_components/otw_shortcode/', 'url' => $otw_cm_plugin_url . '/include/otw_components/otw_shortcode/');
        $otw_cm_shortcode_object->shortcodes['testimonialsslider'] = array('title' => __('Testimonials Slider', 'otw_cm'), 'enabled' => true, 'children' => false, 'parent' => false, 'order' => -3, 'path' => dirname(__FILE__) . '/otw_components/otw_shortcode/', 'url' => $otw_cm_plugin_url . '/include/otw_components/otw_shortcode/');
        $otw_cm_shortcode_object->shortcodes['promotion'] = array('title' => __('Promotion', 'otw_cm'), 'enabled' => true, 'children' => false, 'parent' => false, 'order' => -2, 'path' => dirname(__FILE__) . '/otw_components/otw_shortcode/', 'url' => $otw_cm_plugin_url . '/include/otw_components/otw_shortcode/');
        $otw_cm_shortcode_object->shortcodes['contactuspage'] = array('title' => __('Contact Us Page', 'otw_cm'), 'enabled' => true, 'children' => false, 'parent' => false, 'order' => -1, 'path' => dirname(__FILE__) . '/otw_components/otw_shortcode/', 'url' => $otw_cm_plugin_url . '/include/otw_components/otw_shortcode/');
        $otw_cm_shortcode_object->shortcodes['button'] = array('title' => __('Button', 'otw_cm'), 'enabled' => true, 'children' => false, 'parent' => false, 'order' => 0, 'path' => dirname(__FILE__) . '/otw_components/otw_shortcode/', 'url' => $otw_cm_plugin_url . '/include/otw_components/otw_shortcode/');
        $otw_cm_shortcode_object->shortcodes['icon_link'] = array('title' => __('Icon Link', 'otw_cm'), 'enabled' => true, 'children' => false, 'parent' => false, 'order' => 1, 'path' => dirname(__FILE__) . '/otw_components/otw_shortcode/', 'url' => $otw_cm_plugin_url . '/include/otw_components/otw_shortcode/');
        $otw_cm_shortcode_object->shortcodes['info_box'] = array('title' => __('Info Box', 'otw_cm'), 'enabled' => true, 'children' => false, 'parent' => false, 'order' => 2, 'path' => dirname(__FILE__) . '/otw_components/otw_shortcode/', 'url' => $otw_cm_plugin_url . '/include/otw_components/otw_shortcode/');
        $otw_cm_shortcode_object->shortcodes['dropcap'] = array('title' => __('Dropcaps', 'otw_cm'), 'enabled' => true, 'children' => false, 'parent' => false, 'order' => 3, 'path' => dirname(__FILE__) . '/otw_components/otw_shortcode/', 'url' => $otw_cm_plugin_url . '/include/otw_components/otw_shortcode/');
        $otw_cm_shortcode_object->shortcodes['quote'] = array('title' => __('Quote', 'otw_cm'), 'enabled' => true, 'children' => false, 'parent' => false, 'order' => 4, 'path' => dirname(__FILE__) . '/otw_components/otw_shortcode/', 'url' => $otw_cm_plugin_url . '/include/otw_components/otw_shortcode/');
        $otw_cm_shortcode_object->shortcodes['highlight'] = array('title' => __('Highlight', 'otw_cm'), 'enabled' => true, 'children' => false, 'parent' => false, 'order' => 5, 'path' => dirname(__FILE__) . '/otw_components/otw_shortcode/', 'url' => $otw_cm_plugin_url . '/include/otw_components/otw_shortcode/');
        $otw_cm_shortcode_object->shortcodes['abbreviation'] = array('title' => __('Abbreviation', 'otw_cm'), 'enabled' => true, 'children' => false, 'parent' => false, 'order' => 6, 'path' => dirname(__FILE__) . '/otw_components/otw_shortcode/', 'url' => $otw_cm_plugin_url . '/include/otw_components/otw_shortcode/');
        $otw_cm_shortcode_object->shortcodes['tabslayout'] = array('title' => __('Tabs Layout', 'otw_cm'), 'enabled' => true, 'children' => false, 'parent' => false, 'order' => 7, 'path' => dirname(__FILE__) . '/otw_components/otw_shortcode/', 'url' => $otw_cm_plugin_url . '/include/otw_components/otw_shortcode/');
        $otw_cm_shortcode_object->shortcodes['content_toggle'] = array('title' => __('Content toggle', 'otw_cm'), 'enabled' => true, 'children' => false, 'parent' => false, 'order' => 8, 'path' => dirname(__FILE__) . '/otw_components/otw_shortcode/', 'url' => $otw_cm_plugin_url . '/include/otw_components/otw_shortcode/');
        $otw_cm_shortcode_object->shortcodes['accordion'] = array('title' => __('Accordion', 'otw_cm'), 'enabled' => true, 'children' => false, 'parent' => false, 'order' => 9, 'path' => dirname(__FILE__) . '/otw_components/otw_shortcode/', 'url' => $otw_cm_plugin_url . '/include/otw_components/otw_shortcode/');
        $otw_cm_shortcode_object->shortcodes['faq'] = array('title' => __('FAQ', 'otw_cm'), 'enabled' => true, 'children' => false, 'parent' => false, 'order' => 10, 'path' => dirname(__FILE__) . '/otw_components/otw_shortcode/', 'url' => $otw_cm_plugin_url . '/include/otw_components/otw_shortcode/');
        $otw_cm_shortcode_object->shortcodes['contact_form'] = array('title' => __('Contact Form', 'otw_cm'), 'enabled' => true, 'children' => false, 'parent' => false, 'order' => 11, 'path' => dirname(__FILE__) . '/otw_components/otw_shortcode/', 'url' => $otw_cm_plugin_url . '/include/otw_components/otw_shortcode/');
        $otw_cm_shortcode_object->shortcodes['services'] = array('title' => __('Services', 'otw_cm'), 'enabled' => true, 'children' => false, 'parent' => false, 'order' => 12, 'path' => dirname(__FILE__) . '/otw_components/otw_shortcode/', 'url' => $otw_cm_plugin_url . '/include/otw_components/otw_shortcode/');
        $otw_cm_shortcode_object->shortcodes['about_us'] = array('title' => __('About us', 'otw_cm'), 'enabled' => true, 'children' => false, 'parent' => false, 'order' => 13, 'path' => dirname(__FILE__) . '/otw_components/otw_shortcode/', 'url' => $otw_cm_plugin_url . '/include/otw_components/otw_shortcode/');
        $otw_cm_shortcode_object->shortcodes['image_style'] = array('title' => __('Image style', 'otw_cm'), 'enabled' => true, 'children' => false, 'parent' => false, 'order' => 14, 'path' => dirname(__FILE__) . '/otw_components/otw_shortcode/', 'url' => $otw_cm_plugin_url . '/include/otw_components/otw_shortcode/');
        $otw_cm_shortcode_object->shortcodes['unordered_list'] = array('title' => __('Unordered list', 'otw_cm'), 'enabled' => true, 'children' => false, 'parent' => false, 'order' => 15, 'path' => dirname(__FILE__) . '/otw_components/otw_shortcode/', 'url' => $otw_cm_plugin_url . '/include/otw_components/otw_shortcode/');
        $otw_cm_shortcode_object->shortcodes['ordered_list'] = array('title' => __('Ordered list', 'otw_cm'), 'enabled' => true, 'children' => false, 'parent' => false, 'order' => 16, 'path' => dirname(__FILE__) . '/otw_components/otw_shortcode/', 'url' => $otw_cm_plugin_url . '/include/otw_components/otw_shortcode/');
        $otw_cm_shortcode_object->shortcodes['divider'] = array('title' => __('Divider', 'otw_cm'), 'enabled' => true, 'children' => false, 'parent' => false, 'order' => 17, 'path' => dirname(__FILE__) . '/otw_components/otw_shortcode/', 'url' => $otw_cm_plugin_url . '/include/otw_components/otw_shortcode/');

        $otw_cm_shortcode_object->shortcodes['social_icons'] = array('title' => __('Social Icons', 'otw_cm'), 'enabled' => true, 'children' => false, 'parent' => 'social_buttons', 'order' => 18, 'path' => dirname(__FILE__) . '/otw_components/otw_shortcode/', 'url' => $otw_cm_plugin_url . '/include/otw_components/otw_shortcode/');
        $otw_cm_shortcode_object->shortcodes['social_tweet'] = array('title' => __('Tweet', 'otw_cm'), 'enabled' => true, 'children' => false, 'parent' => 'social_buttons', 'order' => 20, 'path' => dirname(__FILE__) . '/otw_components/otw_shortcode/', 'url' => $otw_cm_plugin_url . '/include/otw_components/otw_shortcode/');
        $otw_cm_shortcode_object->shortcodes['social_twitter_follow'] = array('title' => __('Twitter Follow', 'otw_cm'), 'enabled' => true, 'children' => false, 'parent' => 'social_buttons', 'order' => 21, 'path' => dirname(__FILE__) . '/otw_components/otw_shortcode/', 'url' => $otw_cm_plugin_url . '/include/otw_components/otw_shortcode/');
        $otw_cm_shortcode_object->shortcodes['twitter_stream'] = array('title' => __('Twitter Stream', 'otw_cm'), 'enabled' => true, 'children' => false, 'parent' => 'social_buttons', 'order' => 22, 'path' => dirname(__FILE__) . '/otw_components/otw_shortcode/', 'url' => $otw_cm_plugin_url . '/include/otw_components/otw_shortcode/');
        $otw_cm_shortcode_object->shortcodes['flickr'] = array('title' => __('Flickr', 'otw_cm'), 'enabled' => true, 'children' => false, 'parent' => 'social_buttons', 'order' => 23, 'path' => dirname(__FILE__) . '/otw_components/otw_shortcode/', 'url' => $otw_cm_plugin_url . '/include/otw_components/otw_shortcode/');
        $otw_cm_shortcode_object->shortcodes['social_digg'] = array('title' => __('Digg', 'otw_cm'), 'enabled' => true, 'children' => false, 'parent' => 'social_buttons', 'order' => 24, 'path' => dirname(__FILE__) . '/otw_components/otw_shortcode/', 'url' => $otw_cm_plugin_url . '/include/otw_components/otw_shortcode/');
        $otw_cm_shortcode_object->shortcodes['social_facebook_like'] = array('title' => __('Facebook Like button', 'otw_cm'), 'enabled' => true, 'children' => false, 'parent' => 'social_buttons', 'order' => 25, 'path' => dirname(__FILE__) . '/otw_components/otw_shortcode/', 'url' => $otw_cm_plugin_url . '/include/otw_components/otw_shortcode/');
        $otw_cm_shortcode_object->shortcodes['social_facebook_share'] = array('title' => __('Facebook share button', 'otw_cm'), 'enabled' => true, 'children' => false, 'parent' => 'social_buttons', 'order' => 26, 'path' => dirname(__FILE__) . '/otw_components/otw_shortcode/', 'url' => $otw_cm_plugin_url . '/include/otw_components/otw_shortcode/');
        $otw_cm_shortcode_object->shortcodes['social_facebook_likebox'] = array('title' => __('Facebook Like box', 'otw_cm'), 'enabled' => true, 'children' => false, 'parent' => 'social_buttons', 'order' => 25, 'path' => dirname(__FILE__) . '/otw_components/otw_shortcode/', 'url' => $otw_cm_plugin_url . '/include/otw_components/otw_shortcode/');
        $otw_cm_shortcode_object->shortcodes['social_linkedin_share'] = array('title' => __('Share on Linkedin', 'otw_cm'), 'enabled' => true, 'children' => false, 'parent' => 'social_buttons', 'order' => 27, 'path' => dirname(__FILE__) . '/otw_components/otw_shortcode/', 'url' => $otw_cm_plugin_url . '/include/otw_components/otw_shortcode/');
        $otw_cm_shortcode_object->shortcodes['social_google_plus'] = array('title' => __('Google +1 Button', 'otw_cm'), 'enabled' => true, 'children' => false, 'parent' => 'social_buttons', 'order' => 28, 'path' => dirname(__FILE__) . '/otw_components/otw_shortcode/', 'url' => $otw_cm_plugin_url . '/include/otw_components/otw_shortcode/');

        $social_buttons_chilren = array('social_icons', 'social_tweet', 'social_twitter_follow', 'flickr', 'twitter_stream', 'social_digg', 'social_facebook_like', 'social_facebook_share', 'social_facebook_likebox', 'social_linkedin_share', 'social_google_plus');

        $otw_cm_shortcode_object->shortcodes['social_buttons'] = array('title' => __('Social', 'otw_cm'), 'enabled' => true, 'children' => $social_buttons_chilren, 'parent' => false, 'order' => 119, 'path' => dirname(__FILE__) . '/otw_components/otw_shortcode/', 'url' => $otw_cm_plugin_url . '/include/otw_components/otw_shortcode/');

        $otw_cm_shortcode_object->shortcodes['message_box'] = array('title' => __('Message box', 'otw_cm'), 'enabled' => true, 'children' => false, 'parent' => false, 'order' => 121, 'path' => dirname(__FILE__) . '/otw_components/otw_shortcode/', 'url' => $otw_cm_plugin_url . '/include/otw_components/otw_shortcode/');
        $otw_cm_shortcode_object->shortcodes['content_box'] = array('title' => __('Content box', 'otw_cm'), 'enabled' => true, 'children' => false, 'parent' => false, 'order' => 122, 'path' => dirname(__FILE__) . '/otw_components/otw_shortcode/', 'url' => $otw_cm_plugin_url . '/include/otw_components/otw_shortcode/');
        $otw_cm_shortcode_object->shortcodes['clients'] = array('title' => __('Clients', 'otw_cm'), 'enabled' => true, 'children' => false, 'parent' => false, 'order' => 123, 'path' => dirname(__FILE__) . '/otw_components/otw_shortcode/', 'url' => $otw_cm_plugin_url . '/include/otw_components/otw_shortcode/');
        $otw_cm_shortcode_object->shortcodes['testimonials'] = array('title' => __('Testimonials', 'otw_cm'), 'enabled' => true, 'children' => false, 'parent' => false, 'order' => 124, 'path' => dirname(__FILE__) . '/otw_components/otw_shortcode/', 'url' => $otw_cm_plugin_url . '/include/otw_components/otw_shortcode/');
        $otw_cm_shortcode_object->shortcodes['html_editor'] = array('title' => __('HTML Editor', 'otw_cm'), 'enabled' => true, 'children' => false, 'parent' => false, 'order' => 125, 'path' => dirname(__FILE__) . '/otw_components/otw_shortcode/', 'url' => $otw_cm_plugin_url . '/include/otw_components/otw_shortcode/');
        $otw_cm_shortcode_object->shortcodes['plain_text'] = array('title' => __('Plain Text', 'otw_cm'), 'enabled' => true, 'children' => false, 'parent' => false, 'order' => 126, 'path' => dirname(__FILE__) . '/otw_components/otw_shortcode/', 'url' => $otw_cm_plugin_url . '/include/otw_components/otw_shortcode/');
        $otw_cm_shortcode_object->shortcodes['wp_embed_content'] = array('title' => __('WP Embed Content', 'otw_cm'), 'enabled' => true, 'children' => false, 'parent' => false, 'order' => 127, 'path' => dirname(__FILE__) . '/otw_components/otw_shortcode/', 'url' => $otw_cm_plugin_url . '/include/otw_components/otw_shortcode/');
        $otw_cm_shortcode_object->shortcodes['blog_author_info'] = array('title' => __('Blog Author Info', 'otw_cm'), 'enabled' => true, 'children' => false, 'parent' => false, 'order' => 128, 'path' => dirname(__FILE__) . '/otw_components/otw_shortcode/', 'url' => $otw_cm_plugin_url . '/include/otw_components/otw_shortcode/');

        $otw_cm_shortcode_object->shortcodes['post_tabs'] = array('title' => __('Post Tabs', 'otw_cm'), 'enabled' => true, 'children' => false, 'parent' => false, 'order' => 130, 'path' => dirname(__FILE__) . '/otw_components/otw_shortcode/', 'url' => $otw_cm_plugin_url . '/include/otw_components/otw_shortcode/');
        $otw_cm_shortcode_object->shortcodes['editor_content'] = array('title' => __('Editor content', 'otw_cm'), 'enabled' => true, 'children' => false, 'parent' => false, 'order' => 131, 'path' => dirname(__FILE__) . '/otw_components/otw_shortcode/', 'url' => $otw_cm_plugin_url . '/include/otw_components/otw_shortcode/');
        $otw_cm_shortcode_object->shortcodes['scroll_to_top'] = array('title' => __('Scroll to Top', 'otw_cm'), 'enabled' => true, 'children' => false, 'parent' => false, 'order' => 132, 'path' => dirname(__FILE__) . '/otw_components/otw_shortcode/', 'url' => $otw_cm_plugin_url . '/include/otw_components/otw_shortcode/');
        $otw_cm_shortcode_object->shortcodes['price_box'] = array('title' => __('Price box', 'otw_cm'), 'enabled' => true, 'children' => false, 'parent' => false, 'order' => 133, 'path' => dirname(__FILE__) . '/otw_components/otw_shortcode/', 'url' => $otw_cm_plugin_url . '/include/otw_components/otw_shortcode/');
        $otw_cm_shortcode_object->shortcodes['price_table'] = array('title' => __('Price table', 'otw_cm'), 'enabled' => true, 'children' => false, 'parent' => false, 'order' => 134, 'path' => dirname(__FILE__) . '/otw_components/otw_shortcode/', 'url' => $otw_cm_plugin_url . '/include/otw_components/otw_shortcode/');
        $otw_cm_shortcode_object->shortcodes['sortable_table'] = array('title' => __('Sortable table', 'otw_cm'), 'enabled' => true, 'children' => false, 'parent' => false, 'order' => 135, 'path' => dirname(__FILE__) . '/otw_components/otw_shortcode/', 'url' => $otw_cm_plugin_url . '/include/otw_components/otw_shortcode/');

        $otw_cm_shortcode_object->shortcodes['sidebars'] = array('title' => __('Sidebars', 'otw_cm'), 'enabled' => true, 'children' => false, 'order' => 132, 'parent' => false, 'path' => dirname(__FILE__) . '/otw_components/otw_shortcode/', 'url' => $otw_cm_plugin_url . '/include/otw_components/otw_shortcode/');
        
        if( class_exists( 'OTWBMQuery' ) ){
    		$otw_cm_shortcode_object->shortcodes['blog_manager'] = array('title' => __('Blog Manager', 'otw_cm'), 'enabled' => true, 'children' => false, 'order' => 133, 'parent' => false, 'path' => dirname(__FILE__) . '/otw_components/otw_shortcode/', 'url' => $otw_cm_plugin_url . '/include/otw_components/otw_shortcode/');
        }
        if( class_exists( 'OTWPMQuery' ) ){
    		$otw_cm_shortcode_object->shortcodes['portfolio_manager'] = array('title' => __('Portfolio Manager', 'otw_cm'), 'enabled' => true, 'children' => false, 'order' => 134, 'parent' => false, 'path' => dirname(__FILE__) . '/otw_components/otw_shortcode/', 'url' => $otw_cm_plugin_url . '/include/otw_components/otw_shortcode/');
        }
        
        $otw_cm_shortcode_object->shortcodes['blog_lists'] = array( 'title' => __('Blog Lists', 'otw_cm'),'enabled' => true,'children' => false, 'parent' => false, 'order' => 135,'path' => dirname( __FILE__ ).'/otw_components/otw_shortcode/', 'url' => $otw_cm_plugin_url.'/include/otw_components/otw_shortcode/' );
        $otw_cm_shortcode_object->shortcodes['portfolio_lists'] = array( 'title' => __('Portfolio Lists', 'otw_cm'),'enabled' => true,'children' => false, 'parent' => false, 'order' => 136,'path' => dirname( __FILE__ ).'/otw_components/otw_shortcode/', 'url' => $otw_cm_plugin_url.'/include/otw_components/otw_shortcode/' );
	
        $import_shortcode_order = 10001;
        $imported_shortcodes_children = array();
        foreach ($otw_cm_import_shortcodes as $cs_key => $cs_data) {

            $otw_cm_shortcode_object->shortcodes['import_shortcode_' . $cs_key] = array('title' => __($cs_data['title'], 'otw_cm'), 'enabled' => true, 'children' => false, 'parent' => 'imported_shortcodes', 'order' => $import_shortcode_order++, 'path' => dirname(__FILE__) . '/otw_components/otw_shortcode/', 'url' => $otw_cm_plugin_url . '/include/otw_components/otw_shortcode/');
            $imported_shortcodes_children[] = 'import_shortcode_' . $cs_key;
        }
        if (count($imported_shortcodes_children)) {
            $otw_cm_shortcode_object->shortcodes['imported_shortcodes'] = array('title' => __('Imported Shortcodes', 'otw_cm'), 'enabled' => true, 'children' => $imported_shortcodes_children, 'parent' => false, 'order' => $import_shortcode_order, 'path' => dirname(__FILE__) . '/otw_components/otw_shortcode/', 'url' => $otw_cm_plugin_url . '/include/otw_components/otw_shortcode/');
        }

        $custom_shortcode_order = 20001;
        $custom_shortcodes_children = array();
        if (isset($otw_cm_custom_shortcodes['shortcodes']) && is_array($otw_cm_custom_shortcodes['shortcodes'])) {

            foreach ($otw_cm_custom_shortcodes['shortcodes'] as $cs_key => $cs_data) {
                $otw_cm_shortcode_object->shortcodes['custom_shortcode_' . $cs_key] = array('title' => __($cs_data['title'], 'otw_cm'), 'enabled' => true, 'children' => false, 'parent' => 'imported_shortcodes', 'order' => $import_shortcode_order++, 'path' => dirname(__FILE__) . '/otw_components/otw_shortcode/', 'url' => $otw_cm_plugin_url . '/include/otw_components/otw_shortcode/');
                $custom_shortcodes_children[] = 'custom_shortcode_' . $cs_key;
            }
            if (count($custom_shortcodes_children)) {
                $otw_cm_shortcode_object->shortcodes['custom_shortcodes'] = array('title' => __('Custom Shortcodes', 'otw_cm'), 'enabled' => true, 'children' => $custom_shortcodes_children, 'parent' => false, 'order' => $custom_shortcode_order, 'path' => dirname(__FILE__) . '/otw_components/otw_shortcode/', 'url' => $otw_cm_plugin_url . '/include/otw_components/otw_shortcode/');
            }
        }

        if (isset($wp_widget_factory->widgets) && count($wp_widget_factory->widgets)) {

            $widgets_order = 30001;
            $widgets_children = array();
            foreach ($wp_widget_factory->widgets as $wp_widget_class => $wp_widget) {

                if (preg_match("/^WP_Widget_/", $wp_widget_class) || preg_match("/^WP_Nav_Menu_Widget/", $wp_widget_class)) {

                    if (!in_array('widget_shortcode_' . $wp_widget->id_base, $widgets_children)) {

                        $otw_cm_shortcode_object->shortcodes['widget_shortcode_' . $wp_widget->id_base] = array('title' => $wp_widget->name, 'enabled' => true, 'children' => false, 'parent' => 'imported_shortcodes', 'order' => $import_shortcode_order++, 'path' => dirname(__FILE__) . '/otw_components/otw_shortcode/', 'url' => $otw_cm_plugin_url . '/include/otw_components/otw_shortcode/');
                        $widgets_children[] = 'widget_shortcode_' . $wp_widget->id_base;
                    }
                }
            }

            if (count($widgets_children)) {
                $otw_cm_shortcode_object->shortcodes['wp_widgets'] = array('title' => __('WordPress Widgets', 'otw_cm'), 'enabled' => true, 'children' => $widgets_children, 'parent' => false, 'order' => $widgets_order, 'path' => dirname(__FILE__) . '/otw_components/otw_shortcode/', 'url' => $otw_cm_plugin_url . '/include/otw_components/otw_shortcode/');
            }
        }

        include_once( plugin_dir_path(__FILE__) . 'otw_labels/otw_cm_shortcode_object.labels.php' );
        if( $otw_cm_factory_object->is_plugin_active( $otw_cm_plugin_id ) ){
    	    $otw_cm_shortcode_object->init();
        }

        //form component
        $otw_cm_form_component = otw_load_component('otw_form');
        $otw_cm_form_object = otw_get_component($otw_cm_form_component);
        $otw_cm_form_object->js_version = $otw_cm_js_version;
        $otw_cm_form_object->css_version = $otw_cm_css_version;
        //in case of front grid manager
        if ($otw_cm_front_end_grid_manager_object->enabled) {
            $otw_cm_form_object->init_in_front = is_user_logged_in();
        }

        include_once( plugin_dir_path(__FILE__) . 'otw_labels/otw_cm_form_object.labels.php' );
        $otw_cm_form_object->init();

        //content sidebars component
        if( $otw_cm_factory_object->is_plugin_active( $otw_cm_plugin_id ) ){
            $otw_cm_content_sidebars_component = otw_load_component('otw_content_sidebars');
            $otw_cm_content_sidebars_object = otw_get_component($otw_cm_content_sidebars_component);
            $otw_cm_content_sidebars_object->meta_name = 'otw_content_sidebars_settings';
            $otw_cm_content_sidebars_object->js_version = $otw_cm_js_version;
            $otw_cm_content_sidebars_object->css_version = $otw_cm_css_version;

  
            foreach ($wp_cm_cs_items as $item_key => $item_data) {

  
                $otw_cm_content_sidebars_object->show_metabox_for[$item_key] = false;

  
                if (isset($otw_cm_plugin_options['cs_for']) && isset($otw_cm_plugin_options['cs_for'][$item_key]) && $otw_cm_plugin_options['cs_for'][$item_key]) {
                    $otw_cm_content_sidebars_object->show_metabox_for[$item_key] = true;
                } elseif (!isset($otw_cm_plugin_options['cs_for'])) {
                    $otw_cm_content_sidebars_object->show_metabox_for[$item_key] = true;
                }
            }

  
            include_once( plugin_dir_path(__FILE__) . 'otw_labels/otw_cm_content_sidebars_object.labels.php' );
            $otw_cm_content_sidebars_object->init();
        }

        //validator component
        $otw_cm_validator_component = otw_load_component('otw_validator');
        $otw_cm_validator_object = otw_get_component($otw_cm_validator_component);
        $otw_cm_validator_object->init();
	
	$otw_cm_image_component = otw_load_component( 'otw_image' );
	$otw_cm_image_object = otw_get_component( $otw_cm_image_component );
	$otw_cm_image_object->init();
	
	$img_location = wp_upload_dir();
	
	$otw_cm_image_profile = $otw_cm_image_object->add_profile( $img_location['basedir'].'/', $img_location['baseurl'].'/', 'otwcm' );
	
	if( is_admin() ){
		
		if( $otw_cm_factory_object->is_plugin_active( $otw_cm_plugin_id ) ){
			include_once( 'otw_cm_process_actions.php' );
		}
	}
	
	add_action( 'wp_enqueue_scripts', 'otw_cm_enqueue_styles', 10000 );
	add_action( 'wp_enqueue_scripts', 'otw_cm_enqueue_scripts', 10001 );
	
	otw_rewrite_rules();
    }

}

/**
 * include needed styles
 */
if (!function_exists('otw_cm_enqueue_styles')) {

    function otw_cm_enqueue_styles() {
        global $otw_cm_plugin_url, $otw_cm_css_version, $otw_cm_skin;
        
        if (!is_admin() && is_single() && ( get_post_type() == 'otw_cm_portfolio' ) ) {
    	    wp_enqueue_style('otw_cm_portfolio_flexslider_style', $otw_cm_plugin_url . '/js/flexslider/flexslider.css', array(), $otw_cm_css_version);
    	    wp_enqueue_style('otw_cm_portfolio_flexslider_custom_style', $otw_cm_plugin_url . '/js/flexslider-custom/flexslider.css', array(), $otw_cm_css_version);
    	    wp_enqueue_style('otw_cm_portfolio_style', $otw_cm_plugin_url . '/css/otw_portfolio.css', array(), $otw_cm_css_version);
        }
        
        if (!is_admin() && $otw_cm_skin) {
            wp_enqueue_style('otw_content_manager', $otw_cm_plugin_url . '/skins/' . $otw_cm_skin . '.css', array(), $otw_cm_css_version);
        }
    }
    

}

/**
 * include needed scripts
 */
if (!function_exists('otw_cm_enqueue_scripts')) {

    function otw_cm_enqueue_scripts() {
	
        global $otw_cm_plugin_url, $otw_cm_js_version;
        
        if (!is_admin() && is_single() && ( get_post_type() == 'otw_cm_portfolio' ) ) {
    		
    		wp_enqueue_script('otw_cm_portfoio_flexslider', $otw_cm_plugin_url . '/js/flexslider/jquery.flexslider-min.js', array('jquery' ), $otw_cm_js_version);
    		wp_enqueue_script('otw_cm_portfoio', $otw_cm_plugin_url . '/js/otw_portfolio.js', array('jquery' ), $otw_cm_js_version);
        }
    }

}


/**
 * Admin styles
 */
if (!function_exists('otw_cm_enqueue_admin_styles')) {

    function otw_cm_enqueue_admin_styles() {

        global $otw_cm_plugin_url, $otw_cm_css_version;

        wp_enqueue_style('otw_cm_admin', $otw_cm_plugin_url . '/css/otw_cm_admin.css', array('thickbox'), $otw_cm_css_version);
    }

}

/**
 * Admin scripts
 */
if (!function_exists('otw_cm_enqueue_admin_scripts')) {

    function otw_cm_enqueue_admin_scripts($requested_page) {

        global $otw_cm_plugin_url, $otw_cm_js_version;
        
        switch ($requested_page) {

	    case 'post-new.php':
	    case 'post.php':
			    wp_enqueue_script("otw_cm_portfoio_admin", $otw_cm_plugin_url . '/js/otw_portfolio_admin.js', array('jquery' ), $otw_cm_js_version);
		break;
            case 'content-manager_page_otw-cm-custom-shortcodes-manage':
                wp_enqueue_script("otw_cm_custom_shortcodes", $otw_cm_plugin_url . '/js/otw_custom_shortcodes_admin.js', array('jquery', 'jquery-ui-sortable'), $otw_cm_js_version);
                break;
            case 'widgets.php':
                wp_enqueue_script("otw_shotcode_widget_admin", $otw_cm_plugin_url . '/include/otw_components/otw_shortcode/js/otw_shortcode_widget_admin.js', array('jquery', 'thickbox'), $otw_cm_js_version);

                if (function_exists('wp_enqueue_media')) {
                    wp_enqueue_media();
                } else {
                    wp_enqueue_style('thickbox');
                    wp_enqueue_script('media-upload');
                    wp_enqueue_script('thickbox');
                }
                break;
        }
    }

}

/**
 * Init admin menu
 */
if (!function_exists('otw_cm_init_admin_menu')) {

    function otw_cm_init_admin_menu() {

        global $otw_cm_plugin_url, $menu, $otw_cm_plugin_id, $otw_cm_factory_object;

        add_menu_page(__('Content Manager', 'otw_cm'), __('Content Manager', 'otw_cm'), 'manage_options', 'otw-cm-settings', 'otw_cm_settings', $otw_cm_plugin_url . '/images/otw-sbm-icon.png');
        if( $otw_cm_factory_object->is_plugin_active( $otw_cm_plugin_id ) ){
	    add_submenu_page('otw-cm-settings', __('Settings', 'otw_cm'), __('Settings', 'otw_cm'), 'manage_options', 'otw-cm-settings', 'otw_cm_settings');
            add_submenu_page('otw-cm-settings', __('Skins', 'otw_cm'), __('Skins', 'otw_cm'), 'manage_options', 'otw-cm-skins', 'otw_cm_skins');
            add_submenu_page('otw-cm-settings', __('Add Skin', 'otw_cm'), __('Add Skin', 'otw_cm'), 'manage_options', 'otw-cm-skins-manage', 'otw_cm_skins_manage');
            $menu_hook_1 = add_submenu_page(__FILE__, __('Delete skin', 'otw_cm'), __('Delete skin', 'otw_cm'), 'manage_options', 'otw-cm-skins-delete', 'otw_cm_skins_delete');
            add_submenu_page('otw-cm-settings', __('Custom shortcodes', 'otw_cm'), __('Custom shortcodes', 'otw_cm'), 'manage_options', 'otw-cm-custom-shortcodes', 'otw_cm_custom_shortcodes');
            add_submenu_page('otw-cm-settings', __('Add custom shortcode', 'otw_cm'), __('Add custom shortcode', 'otw_cm'), 'manage_options', 'otw-cm-custom-shortcodes-manage', 'otw_cm_custom_shortcodes_manage');
            add_submenu_page('otw-cm-settings', __('Imported shortcodes', 'otw_cm'), __('Imported shortcodes', 'otw_cm'), 'manage_options', 'otw-cm-import-shortcodes', 'otw_cm_import_shortcodes');
            add_submenu_page('otw-cm-settings', __('Import shortcodes', 'otw_cm'), __('Import shortcodes', 'otw_cm'), 'manage_options', 'otw-cm-import-shortcodes-manage', 'otw_cm_import_shortcodes_manage');
            $menu_hook_2 = add_submenu_page(__FILE__, __('Imported Shortcode Delete', 'otw_cm'), __('Imported Shortcode Delete', 'otw_cm'), 'manage_options', 'otw-cm-import-shortcodes-delete', 'otw_cm_import_shortcodes_delete');
            $menu_hook_3 = add_submenu_page(__FILE__, __('Imported Shortcode Fields', 'otw_cm'), __('Imported Shortcode Fields', 'otw_cm'), 'manage_options', 'otw-cm-import-shortcodes-fields', 'otw_cm_import_shortcodes_fields');
            $menu_hook_4 = add_submenu_page(__FILE__, __('Add Imported Shortcode Field', 'otw_cm'), __('Add Imported Shortcode Field', 'otw_cm'), 'manage_options', 'otw-cm-import-shortcodes-fields-manage', 'otw_cm_import_shortcodes_fields_manage');
            $menu_hook_5 = add_submenu_page(__FILE__, __('Delete Shortcode Field', 'otw_cm'), __('Delete Imported Shortcode Field', 'otw_cm'), 'manage_options', 'otw-cm-import-shortcodes-fields-delete', 'otw_cm_import_shortcodes_fields_delete');
            $menu_hook_6 = add_submenu_page(__FILE__, __('Add Imported Shortcode Field Options', 'otw_cm'), __('Add Imported Shortcode Field Options', 'otw_cm'), 'manage_options', 'otw-cm-import-shortcodes-fields-options', 'otw_cm_import_shortcodes_fields_options');
            $menu_hook_7 = add_submenu_page(__FILE__, __('Custom Shortcode Delete', 'otw_cm'), __('Custom Shortcode Delete', 'otw_cm'), 'manage_options', 'otw-cm-custom-shortcodes-delete', 'otw_cm_custom_shortcodes_delete');

  
            add_action('load-' . $menu_hook_1, 'otw_open_cm_menu');
            add_action('load-' . $menu_hook_2, 'otw_open_cm_menu');
            add_action('load-' . $menu_hook_3, 'otw_open_cm_menu');
            add_action('load-' . $menu_hook_4, 'otw_open_cm_menu');
            add_action('load-' . $menu_hook_5, 'otw_open_cm_menu');
            add_action('load-' . $menu_hook_6, 'otw_open_cm_menu');
            add_action('load-' . $menu_hook_7, 'otw_open_cm_menu');
	}    
    }

}

/**
 * Settings page
 */
if (!function_exists('otw_cm_settings')) {

    function otw_cm_settings() {
        require_once( 'otw_cm_settings.php' );
    }

}

/**
 * Edit Skins page
 */
if (!function_exists('otw_cm_skins_manage')) {

    function otw_cm_skins_manage() {
        require_once( 'otw_cm_skins_manage.php' );
    }

}

/**
 * Delete skins page
 */
if (!function_exists('otw_cm_skins_delete')) {

    function otw_cm_skins_delete() {
        require_once( 'otw_cm_skins_delete.php' );
    }

}

/**
 * Skins page
 */
if (!function_exists('otw_cm_skins')) {

    function otw_cm_skins() {
        require_once( 'otw_cm_skins.php' );
    }

}

/**
 * Edit imported shortcodes page
 */
if (!function_exists('otw_cm_import_shortcodes_manage')) {

    function otw_cm_import_shortcodes_manage() {
        require_once( 'otw_cm_import_shortcodes_manage.php' );
    }

}

/**
 * Delete imported shortcodes page
 */
if (!function_exists('otw_cm_import_shortcodes_delete')) {

    function otw_cm_import_shortcodes_delete() {
        require_once( 'otw_cm_import_shortcodes_delete.php' );
    }

}

/**
 * Imported shortcodes page
 */
if (!function_exists('otw_cm_import_shortcodes')) {

    function otw_cm_import_shortcodes() {
        require_once( 'otw_cm_import_shortcodes.php' );
    }

}

/**
 * Edit Imported shortcodes fields page
 */
if (!function_exists('otw_cm_import_shortcodes_fields')) {

    function otw_cm_import_shortcodes_fields() {
        require_once( 'otw_cm_import_shortcodes_fields.php' );
    }

}

/**
 * Delete Custm shortcodes page
 */
if (!function_exists('otw_cm_import_shortcodes_fields_delete')) {

    function otw_cm_import_shortcodes_fields_delete() {
        require_once( 'otw_cm_import_shortcodes_fields_delete.php' );
    }

}

/**
 * Imported shortcodes page
 */
if (!function_exists('otw_cm_import_shortcodes_fields_manage')) {

    function otw_cm_import_shortcodes_fields_manage() {
        require_once( 'otw_cm_import_shortcodes_fields_manage.php' );
    }

}

/**
 * Imported shortcodes field options
 */
if (!function_exists('otw_cm_import_shortcodes_fields_options')) {

    function otw_cm_import_shortcodes_fields_options() {
        require_once( 'otw_cm_import_shortcodes_fields_options.php' );
    }

}

/**
 * Check if Skins directory is writable
 */
if (!function_exists('otw_cm_skins_wirable')) {

    function otw_cm_skins_wirable($skins_path) {

        return is_writable($skins_path);
    }

}

/**
 * Check for valid skin name
 */
if (!function_exists('otw_cm_valid_skin_name')) {

    function otw_cm_valid_skin_name($skin_name) {

        if (preg_match("/^[a-z\_]{3,15}$/", $skin_name, $matches)) {
            return true;
        }
        return false;
    }

}

/**
 * Load skins
 */
if (!function_exists('otw_cm_load_skins')) {

    function otw_cm_load_skins($skins_path) {

        $skins = array();
        $dp = opendir($skins_path);

        if ($dp) {
            while ($file = readdir($dp)) {

                if (preg_match("/^([a-z\-\_]+)\.css$/", $file, $matches)) {

                    if (otw_cm_valid_skin_name($matches[1])) {
                        $skins[$matches[1]] = array($matches[1], $matches[1]);
                    }
                }
            }
            closedir($dp);
        }

        return $skins;
    }

}

/**
 * Keep the admin menu open
 */
if (!function_exists('otw_open_cm_menu')) {

    function otw_open_cm_menu($params) {

        global $menu;

        foreach ($menu as $key => $item) {
            if ($item[2] == 'otw-cm-settings') {
                $menu[$key][4] = $menu[$key][4] . ' wp-has-submenu wp-has-current-submenu wp-menu-open menu-top otw-menu-open';
            }
        }
    }

}

/**
 * Edit custom shortcodes page
 */
if (!function_exists('otw_cm_custom_shortcodes_manage')) {

    function otw_cm_custom_shortcodes_manage() {

        require_once( 'otw_cm_custom_shortcodes_manage.php' );
    }

}

/**
 * listcustom shortcodes page
 */
if (!function_exists('otw_cm_custom_shortcodes')) {

    function otw_cm_custom_shortcodes() {

        require_once( 'otw_cm_custom_shortcodes.php' );
    }

}

/**
 * Delete custom shortcodes page
 */
if (!function_exists('otw_cm_custom_shortcodes_delete')) {

    function otw_cm_custom_shortcodes_delete() {
        require_once( 'otw_cm_custom_shortcodes_delete.php' );
    }

}

/**
 * Resize media
 */
if (!function_exists('otw_resize_media')) {
	
	function otw_resize_media( $params ) {
		
		global $otw_cm_image_object, $otw_cm_image_profile;
		
		if( isset( $params['type'] ) && ( $params['type'] == 'img' ) ){
			
			if( isset( $params['path'] ) ){
				
				$resizeWidth = 0;
				$resizeHeight = 0;
				$crop         = false;
				$white_spaces = true;
				$background   = '#FFFFFF';
				
				if( isset( $params['width'] ) ){
					$resizeWidth = $params['width'];
				}
				if( isset( $params['height'] ) ){
					$resizeHeight = $params['height'];
				}
				if( isset( $params['crop'] ) ){
					$crop = $params['crop'];
				}
				if( isset( $params['white_spaces'] ) ){
					$white_spaces = $params['white_spaces'];
				}
				if( isset( $params['background'] ) ){
					$background = $params['background'];
				}
				
				return $otw_cm_image_object->resize( $otw_cm_image_profile, $params['path'], $resizeWidth, $resizeHeight, $crop , false, $white_spaces, $background );
			
			}
		}
		
		return false;
	}
}

if( !function_exists( 'cm_portfolio_meta_box' ) ){
	
	function cm_portfolio_meta_box(){
		
		add_meta_box( 'otw-cm-portfolio-meta-box', __('OTW Portfolio Images', 'otw_cm' ),  'otw_cm_portfolio_media_meta_box', 'otw_cm_portfolio', 'normal', 'default' );
		
	}
}
if( !function_exists( 'otw_cm_portfolio_media_meta_box' ) ){
	
	function otw_cm_portfolio_media_meta_box( $post ){
		
		$otw_saved_data = array();
		
		if( isset( $post->ID ) ){
			$otw_saved_data = get_post_meta( $post->ID, 'otw_cm_portfolio_meta_data', true );
		}
		
		require_once( 'otw_cm_portfolio_meta_box.php' );
	}
}

if( !function_exists( 'cm_save_portfolio_meta_box' ) ){

	function cm_save_portfolio_meta_box( $post_id ){
		
		if ( defined('DOING_AUTOSAVE') && DOING_AUTOSAVE ){
			return;
		}
		
		if( $post_id && isset( $_POST['otw-cm-list-slider_url'] ) ){
			
			$otw_meta_data = array(
				'media_type'      => 'slider',
				'slider_url'      => $_POST['otw-cm-list-slider_url']
			);
			
			add_post_meta($post_id, 'otw_cm_portfolio_meta_data', $otw_meta_data, true);
			
			update_post_meta($post_id, 'otw_cm_portfolio_meta_data', $otw_meta_data);
		}
	}
}
if( !function_exists( 'otw_cm_simple_portfolio_template' ) ){
	
	function otw_cm_simple_portfolio_template( $content ){
		global $post;
		
		if( $post->post_type == 'otw_cm_portfolio' ){
			
			if( file_exists( plugin_dir_path( __FILE__ ).'/otw_cm_single_portfolio.php' ) ){
				
				$otw_portfolio_meta_data = get_post_meta( $post->ID, 'otw_cm_portfolio_meta_data', true );
				
				$otw_portfolio_slider_images = array();
				
				if( isset( $otw_portfolio_meta_data['slider_url'] ) && strlen( trim( $otw_portfolio_meta_data['slider_url'] ) ) ){
					$otw_portfolio_slider_images = explode( ',', $otw_portfolio_meta_data['slider_url'] );
				}
				
				$otw_portfolio_cats = wp_get_post_terms(  $post->ID, 'otw_cm_portfolio_category' );
				
				ob_start();
				include_once( plugin_dir_path( __FILE__ ).'/otw_cm_single_portfolio.php' );
				$content = ob_get_contents();
				ob_end_clean();
			}
		}
		
		return $content;
	}
}

if( !function_exists( 'otw_rewrite_rules' ) ){
	
	function otw_rewrite_rules(){
		
		$last_update = get_option( 'otw_rewrite_rules' );
		
		if( !$last_update || ( $last_update < strtotime( 'now -24 hours' ) ) ){
			flush_rewrite_rules();
			$last_update = time();
			update_option( 'otw_rewrite_rules', $last_update );
		}
	}
}
if( !function_exists( 'otw_cm_portfolio_thumbnail' ) ){
	
	function otw_cm_portfolio_thumbnail( $html, $post_id, $post_thumbnail_id, $size, $attr ){
		
		if( get_post_type( $post_id ) == 'otw_cm_portfolio' ){
			
			$otw_portfolio_meta_data = get_post_meta( $post_id, 'otw_cm_portfolio_meta_data', true );
			
			$otw_portfolio_slider_images = array();
			
			if( isset( $otw_portfolio_meta_data['slider_url'] ) && strlen( trim( $otw_portfolio_meta_data['slider_url'] ) ) ){
				$otw_portfolio_slider_images = explode( ',', $otw_portfolio_meta_data['slider_url'] );
			}
			if( isset( $otw_portfolio_slider_images[0] ) ){
				
				global $_wp_additional_image_sizes;
				
				if( isset( $_wp_additional_image_sizes[ $size ] ) ){
					
					$image_data = parse_url( $otw_portfolio_slider_images[0] );
					$thumb_params = array();
					$thumb_params['type'] = 'img';
					$thumb_params['path'] = $image_data['path'];
					$thumb_params['width'] = $_wp_additional_image_sizes[ $size ]['width'];
					$thumb_params['height'] = $_wp_additional_image_sizes[ $size ]['height'];
					
					if( $_wp_additional_image_sizes[ $size ]['crop'] ){
						$thumb_params['crop'] = 'center_center';
					}else{
						$thumb_params['crop'] = false;
					}
					
					$thumb_src = otw_resize_media( $thumb_params );
					
					if( $thumb_src ){
						$html = '<img src="'.$thumb_src.'" />';
					}
				}
			}
		}
		return $html;
	}
}
if( !function_exists( 'otw_cm_portfolio_thumbnail_metadata' ) ){
	
	function otw_cm_portfolio_thumbnail_metadata( $value, $post_id, $meta_key, $single ){
		
		if( ( get_post_type( $post_id ) == 'otw_cm_portfolio' ) && ( $meta_key == '_thumbnail_id' ) ){
			
			if( is_archive() ){
				
				$otw_portfolio_meta_data = get_post_meta( $post_id, 'otw_cm_portfolio_meta_data', true );
				
				if( count( $otw_portfolio_meta_data ) ){
					return 1;
				}
			}
		}
		return $value;
	}
}
if( !function_exists( 'otw_cm_factory_message' ) ){
	function otw_cm_factory_message( $params ){
	
		global $otw_cm_plugin_id;
		
		if( isset( $params['plugin'] ) && $otw_cm_plugin_id == $params['plugin'] ){
			
			//filter out some messages if need it
		}
		if( isset( $params['message'] ) )
		{
			return $params['message'];
		}
		return $params;
	}
}
?>