<?php
global $validate_messages;

$page_title = __( 'Delete Custom Shortcode', 'otw_cm' );

$otw_cm_custom_shortcodes = get_option( 'otw_custom_shortcodes' );


if( !is_array( $otw_cm_custom_shortcodes ) || !isset( $otw_cm_custom_shortcodes['index'] ) || !isset( $otw_cm_custom_shortcodes['shortcodes'] ) ){
	$otw_cm_custom_shortcodes = array();
	$otw_cm_custom_shortcodes['index'] = 0;
	$otw_cm_custom_shortcodes['shortcodes'] = array();
}

$otw_custom_shortcode_values = array();
$otw_custom_shortcode_values['name'] = '';
$otw_custom_shortcode_values['key'] = '';

$requested_shortcode = '';
if( isset( $_GET['custom_shortcode'] ) && array_key_exists( urldecode( $_GET['custom_shortcode'] ), $otw_cm_custom_shortcodes['shortcodes'] ) ){
	$requested_shortcode = urldecode( $_GET['custom_shortcode'] );
	$otw_custom_shortcode_values['key'] = urldecode( $_GET['custom_shortcode'] );
	$otw_custom_shortcode_values['name'] =  $otw_cm_custom_shortcodes['shortcodes'][ urldecode( $_GET['custom_shortcode'] ) ]['title'];
}
else
{
	wp_die( __( 'Invalid shortcode', 'otw_cm' ) );
}
?>
<div class="wrap">
	<div id="icon-edit" class="icon32"><br/></div>
	<h2>
		<?php echo $page_title; ?>
		<a class="button add-new-h2" href="<?php echo admin_url( 'admin.php?page=otw-cm-custom-shortcodes' )?>" ><?php _e('Back To Available Custom Shortcodes', 'otw_cm')?></a>
	</h2>
	<?php if( isset( $validate_messages ) && count( $validate_messages ) ){?>
		<div id="message" class="error">
			<?php foreach( $validate_messages as $v_message ){
				echo '<p>'.$v_message.'</p>';
			}?>
		</div>
	<?php }?>
	<div class="form-wrap" id="poststuff">
		<?php include_once( 'otw_cm_help.php' );?>
		
		<form method="post" action="" class="validate">
			<input type="hidden" name="otw_cm_action" value="delete_otw_cm_custom_shortcode" />
			<?php wp_original_referer_field(true, 'previous'); wp_nonce_field('otw-cm-custom-shortcode-delete'); ?>
			<div id="post-body">
				<div id="post-body-content">
					<div class="form-field form-required">
						<input type="hidden" name="otw_custom_shortcode_key" value="<?php echo $otw_custom_shortcode_values['key']?>" />
						<p><?php _e( 'Please confirm to delete the the custom shortcode  \''.$otw_custom_shortcode_values['name'].'\'.', 'otw_cm' );?></p>
					</div>
					<p class="submit">
						<input type="submit" value="<?php _e( 'Yes, delete it!', 'otw_cm') ?>" name="submit" class="button"/>
					</p>
				</div>
			</div>
		</form>
	</div>
</div>
