<?php
global $_wp_column_headers;

$otw_cm_custom_shortcodes = get_option( 'otw_custom_shortcodes' );

if( !is_array( $otw_cm_custom_shortcodes ) || !isset( $otw_cm_custom_shortcodes['index'] ) || !isset( $otw_cm_custom_shortcodes['shortcodes'] ) ){
	$otw_cm_custom_shortcodes = array();
	$otw_cm_custom_shortcodes['index'] = 0;
	$otw_cm_custom_shortcodes['shortcodes'] = array();
}

$_wp_column_headers['toplevel_page_otw-cm-custom-shortcodes'] = array(
	'name' => __( 'Shortcode Label', 'otw_cm' )
);

$message = '';
$massages = array();
$messages[1] = __( 'Custom shortcode saved', 'otw_cm' );
$messages[2] = __( 'Custom shortcode deleted', 'otw_cm' );

if( isset( $_GET['message'] ) && isset( $messages[ $_GET['message'] ] ) ){
	$message .= $messages[ $_GET['message'] ];
}
?>
<?php if ( $message ) : ?>
<div id="message" class="updated"><p><?php echo $message; ?></p></div>
<?php endif ?>
<div class="wrap">
	<div id="icon-edit" class="icon32"><br/></div>
	<h2>
		<?php _e('Custom Shortcodes', 'otw_cm') ?>
		<a class="button add-new-h2" href="admin.php?page=otw-cm-custom-shortcodes-manage"><?php _e('Add Custom shortcode', 'otw_cm') ?></a>
	</h2>
	
	<form class="search-form form-wrap" action="" method="get">
		<?php include_once( 'otw_cm_help.php' );?>
	</form>
	<div class="updated">
		<p><?php _e( 'Custom Shortcodes are an easy way to add your own shortcode that you will be able to use in the OTW interface along with the other OTW shortcodes.', 'otw_cm' );?></p>
	</div>
	<br class="clear" />
	<?php if( is_array( $otw_cm_custom_shortcodes['shortcodes'] ) && count( $otw_cm_custom_shortcodes['shortcodes'] ) ){?>
		<table class="widefat fixed" cellspacing="0">
			<thead>
				<tr>
					<?php foreach( $_wp_column_headers['toplevel_page_otw-cm-custom-shortcodes'] as $key => $name ){?>
						<th><?php echo $name?></th>
					<?php }?>
				</tr>
			</thead>
			<tfoot>
				<tr>
					<?php foreach( $_wp_column_headers['toplevel_page_otw-cm-custom-shortcodes'] as $key => $name ){?>
						<th><?php echo $name?></th>
					<?php }?>
				</tr>
			</tfoot>
			<tbody>
			<?php foreach( $otw_cm_custom_shortcodes['shortcodes'] as $custom_shortcode_key => $custom_shortcode_item ){?>
				<tr>
					<?php foreach( $_wp_column_headers['toplevel_page_otw-cm-custom-shortcodes'] as $column_name => $column_title ){
						
						$edit_link = admin_url( 'admin.php?page=otw-cm-custom-shortcodes-manage&amp;action=edit&amp;custom_shortcode='.urlencode( $custom_shortcode_key ) );
						$delete_link = admin_url( 'admin.php?page=otw-cm-custom-shortcodes-delete&amp;custom_shortcode='.urlencode( $custom_shortcode_key ) );
						
						switch($column_name) {
						
							case 'name':
								
									echo '<td><strong><a href="'.$edit_link.'" title="'.esc_attr(sprintf(__('Edit &#8220;%s&#8221;', 'otw_cm'), $custom_shortcode_key)).'">'.$custom_shortcode_item['title'].'</a></strong><br />';
									
									echo '<div class="row-actions">';
									echo '<a href="'.$edit_link.'">' . __('Edit', 'otw_cm') . '</a>';
									echo ' | <a href="'.$delete_link.'">' . __('Delete', 'otw_cm'). '</a>';
									
									echo '</div>';
									
									echo '</td>';
								break;
						}
					?>
					
					<?php }?>
				</tr>
			<?php }?>
			</tbody>
		</table>
		
	<?php }else{ ?>
		<p><?php _e('No custom shortcodes found.', 'otw_cm' )?></p>
	<?php } ?>
</div>