<form action="#" method="post" novalidate="novalidate">

    <table class="form-table">
        <tbody>

            <?php

                $field->add('checkbox',
                    array(
                        'label'         => esc_html__('Smart Popup', 'wp-any-contact-us'),
                        'name'          => 'wacu_smart_popup[is_popup]',
                        'value'         => esc_attr($wacu_smart_popup['is_popup']),
                        'tooltip'       => esc_attr__('Enable or disable smart popup.', 'wp-any-contact-us'),
                        'checkbox_text' => esc_html__('Enable/ Disable', 'wp-any-contact-us'),
                    )
                );

                $field->add('number',
                    array(
                        'label'   => esc_html__('Popup Display After', 'wp-any-contact-us'),
                        'name'    => 'wacu_smart_popup[popup_after]',
                        'value'   => esc_attr($wacu_smart_popup['popup_after']),
                        'tooltip' => esc_attr__('You can set the smart auto popup time in seconds.', 'wp-any-contact-us'),
                        'desc'    => esc_html__('In Seconds, Default 5 seconds', 'wp-any-contact-us'),
                        'min'     => '1',
                        'step'    => '1',
                    )
                );

                $field->add('number',
                    array(
                        'label'   => esc_html__('Popup Interval', 'wp-any-contact-us'),
                        'name'    => 'wacu_smart_popup[popup_interval]',
                        'value'   => esc_attr($wacu_smart_popup['popup_interval']),
                        'tooltip' => esc_attr__('You can set the time interval between smart popups. Example: If you set 60 then next smart popup will show after 60 seconds when closed.', 'wp-any-contact-us'),
                        'desc'    => esc_html__('In Seconds, Default 300 (5 minutes)', 'wp-any-contact-us'),
                        'min'     => '1',
                        'step'    => '1',
                    )
                );

                $field->add('wp_editor',
                    array(
                        'id'               => 'wacu_smart_popup_text_default',
                        'label'            => esc_html__('Default Text', 'wp-any-contact-us'),
                        'tooltip'          => esc_attr__('This is the text that visitor sees the first time.', 'wp-any-contact-us'),
                        'name'             => 'wacu_smart_popup[text][default]',
                        'value'            => wp_kses_post($wacu_smart_popup['text']['default']),
                        'wp_editor_height' => '100',
                    )
                );

                $field->add('wp_editor',
                    array(
                        'id'               => 'wacu_smart_popup_text_woo_product',
                        'label'            => esc_html__('Woo Product Page', 'wp-any-contact-us'),
                        'tooltip'          => esc_attr__('This is the text that visitor sees when a visitor is on WooCommerce product page.', 'wp-any-contact-us'),
                        'name'             => 'wacu_smart_popup[text][woo_product]',
                        'value'            => $wacu_smart_popup['text']['woo_product'],
                        'desc'             => sprintf(wp_kses_post(__('Use tag %1$s for product name on WooCommerce product name.', 'wp-any-contact-us')), '<code>{{product_name}}</code>'),
                        'wp_editor_height' => '100',
                    )
                );

            ?>

        </tbody>
    </table>

    <?php submit_button(esc_attr__('Save Changes', 'wp-any-contact-us'), 'primary', 'wacu_smart_popup_submit');?>

</form>