<?php
// Preventing to direct access
defined('ABSPATH') OR die('Direct access not acceptable!');

if ( ! class_exists('WACU_Public_Popup')) {

    class WACU_Public_Popup {

        public function __construct() {

            add_action('wp_head', array($this, 'display_popup'));

        }

        /**
         * Display the widget on the website
         * @since 1.0
         */
        public function display_popup() {

            if (get_option('wacu_license_key') == '') {
                return;
            }

            $wacu_appearance  = get_option('wacu_appearance', array());
            $wacu_smart_popup = get_option('wacu_smart_popup', array());

            require_once WACU_PATH . 'views/public/view-popup.php';

        }

    } // .WACU_Public_Popup

    new WACU_Public_Popup;

}
