<?php

// Preventing to direct access
defined('ABSPATH') OR die('Direct access not acceptable!');

class WACU_Public_Ajax {

    public function __construct() {

        add_action("wp_ajax_wacu_public_email_form_ajax", array($this, 'wacu_public_email_form_ajax'));
        add_action("wp_ajax_nopriv_wacu_public_email_form_ajax", array($this, 'wacu_public_email_form_ajax'));

        add_action("wp_ajax_wacu_contact_media_ajax", array($this, 'contact_media_ajax'));
        add_action("wp_ajax_nopriv_wacu_contact_media_ajax", array($this, 'contact_media_ajax'));

        add_action("wp_ajax_wacu_public_schedule_a_call_ajax", array($this, 'wacu_public_schedule_a_call_ajax'));
        add_action("wp_ajax_nopriv_wacu_public_schedule_a_call_ajax", array($this, 'wacu_public_schedule_a_call_ajax'));

        add_action("wp_ajax_wacu_public_send_email_ajax", array($this, 'wacu_public_send_email_ajax'));
        add_action("wp_ajax_nopriv_wacu_public_send_email_ajax", array($this, 'wacu_public_send_email_ajax'));

        add_action("wp_ajax_wacu_public_send_schedule_email_ajax", array($this, 'wacu_public_send_schedule_email_ajax'));
        add_action("wp_ajax_nopriv_wacu_public_send_schedule_email_ajax", array($this, 'wacu_public_send_schedule_email_ajax'));

    }

    public function contact_media_ajax() {

        // Get plugin basic option
        $wacu_basic_setting  = get_option('wacu_basic_setting', array());
        $wacu_contact_medium = get_option('wacu_contact_medium', array());
        $wacu_gdpr_setting   = get_option('wacu_gdpr_setting', array());

        require_once WACU_PATH . 'views/public/ajax/view-ajax-contact-media.php';
        wp_die();
    }

    public function wacu_public_email_form_ajax() {

        $wacu_contact_medium = get_option('wacu_contact_medium', array());

        require_once WACU_PATH . 'views/public/ajax/view-ajax-email-form.php';
        wp_die();
    }

    public function wacu_public_schedule_a_call_ajax() {

        $wacu_contact_medium = get_option('wacu_contact_medium', array());

        require_once WACU_PATH . 'views/public/ajax/view-ajax-schedule-a-call.php';
        wp_die();
    }

    public function wacu_public_send_email_ajax() {

        // get schedule a call option
        $wacu_contact_medium = get_option('wacu_contact_medium', array());
        // thank you message
        $thank_you_message = $wacu_contact_medium['email']['thank_you_message'];
        // email data
        $email_data = $wacu_contact_medium['email']['email'];

        // POST data
        $name    = $_POST['name'];
        $email   = $_POST['email'];
        $message = $_POST['message'];

        // Send an email
        $to        = $email_data['to'];
        $subject   = str_replace('{{name}}', $name, $email_data['subject']);
        $body      = str_replace(array('{{name}}', '{{email}}', '{{message}}'), array($name, $email, $message), $email_data['body']);
        $headers[] = 'Content-Type: text/html; charset=UTF-8';
        $headers[] = 'Reply-To: ' . $name . ' < ' . $email . ' >';
        $headers[] = 'From: ' . get_bloginfo('name') . ' <' . get_option('admin_email') . '>';

        wp_mail($to, $subject, $body, $headers);

        // Return thank you message to user
        echo str_replace('{{name}}', $name, $thank_you_message);

        wp_die();
    }

    public function wacu_public_send_schedule_email_ajax() {

        // get schedule a call option
        $wacu_contact_medium = get_option('wacu_contact_medium', array());
        // thank you message
        $thank_you_message = $wacu_contact_medium['schedule_a_call']['thank_you_message'];
        // email data
        $email_data = $wacu_contact_medium['schedule_a_call']['email'];

        // POST values
        $name            = $_POST['name'];
        $country         = $_POST['country'];
        $callback_number = $_POST['callback_number'];
        $month           = $_POST['month'];
        $date            = $_POST['date'];
        $time            = $_POST['time'];
        $message         = $_POST['message'];

        // Date format
        $callback_time = "$month $date, $time";

        // Send an email
        $to        = $email_data['to'];
        $subject   = str_replace('{{name}}', $name, $email_data['subject']);
        $body      = str_replace(array('{{name}}', '{{country}}', '{{callback_number}}', '{{callback_time}}', '{{message}}'), array($name, $country, $callback_number, $callback_time, $message), $email_data['body']);
        $headers[] = 'Content-Type: text/html; charset=UTF-8';
        $headers[] = 'From: ' . get_bloginfo('name') . ' <' . get_option('admin_email') . '>';

        wp_mail($to, $subject, $body, $headers);

        // Return thank you message to user
        echo str_replace('{{name}}', $name, $thank_you_message);

        wp_die();
    }

}

new WACU_Public_Ajax;