<?php

// Preventing to direct access
defined( 'ABSPATH' ) OR die( 'Direct access not acceptable!' );

if ( ! class_exists ( 'WACU_Admin_Notification' ) ) : 

    class WACU_Admin_Notification {

        public function __construct() {

            add_action( 'wacu_admin_notifications', array( $this, 'save_setting_notification' ) );
            add_action( 'wacu_admin_notifications', array( $this, 'admin_plugin_review' ) );

        }

        /**
         * Display all the save settings notifications
         * @since 1.0
         */
        public function save_setting_notification() {

            if ( isset( $_POST['wacu_appearance'] ) 
                || isset( $_POST['wacu_basic_setting'] )
                || isset( $_POST['wacu_contact_medium'] )
                || isset( $_POST['wacu_smart_popup'] )
                || isset( $_POST['wacu_developer_setting'] )
                || isset( $_POST['wacu_social_media'] )
                || isset( $_POST['wacu_gdpr_setting'] ) ) { 
                ?>
                <div class="notice notice-success is-dismissible"> 
                    <p><strong><?php esc_html_e( 'Settings saved.', 'wp-any-contact-us' ) ?></strong></p>
                    <button type="button" class="notice-dismiss">
                        <span class="screen-reader-text"><?php esc_html_e( 'Dismiss this notice.', 'wp-any-contact-us' ) ?></span>
                    </button>
                </div>
                <?php 
            }

        }


        public function admin_plugin_review() {
            if ( get_option( 'wacu_admin_review' ) == '1' ) {
                return;
            }

            ?>

            <div class="notice notice-warning is-dismissible" >
            <h3><?php esc_html_e( 'Leave A Review?', 'wp-any-contact-us' ) ?></h3>
                        <p>
                            <?php
                                printf(
                                    wp_kses_post(__('We hope you\'ve enjoyed using %s Would you consider leaving us a review on %s', 'wp-any-contact-us')),
                                    '<strong>WordPress Any Contact Us</strong>',
                                    '<a href="https://codecanyon.net/downloads/">codecanyon.net?</a>'
                                )
                            ?>
                        </p>
            
            <ul class="wws-inline-ul">
                <li>
                    <span class="wws-admin-icon dashicons dashicons-external"></span> 
                        <a href="https://codecanyon.net/downloads/">
                            <strong><?php esc_html_e( 'Sure! I\'d love to!', 'wp-any-contact-us' ) ?></strong>
                        </a>
                </li>
                <li>
                    <span class="wws-admin-icon dashicons dashicons-smiley"></span>
                        <a href="?wacu_admin_review=1"><?php esc_html_e( 'I\'ve already left a review', 'wp-any-contact-us' ) ?></a>
                </li>
                <li>
                    <span class="wws-admin-icon dashicons dashicons-dismiss"></span>
                        <a href="?wacu_admin_review=1"><?php esc_html_e( 'Never show again', 'wp-any-contact-us' ) ?></a>
                </li>
            </ul>
                </div>

            <?php

        }

    } // end WACU_Admin_Notification

    new WACU_Admin_Notification;


endif;



