<?php

// Preventing to direct access
defined('ABSPATH') OR die('Direct access not acceptable!');

if ( ! class_exists('Wecreativez_Core_Register_Setting')):

    class Wecreativez_Core_Register_Setting {

        /**
         * array_merge_recursive does indeed merge arrays, but it converts values with duplicate
         * keys to arrays rather than overwriting the value in the first array with the duplicate
         * value in the second array, as array_merge does. I.e., with array_merge_recursive,
         * this happens (documented behavior):
         *
         * array_merge_recursive(array('key' => 'org value'), array('key' => 'new value'));
         *     => array('key' => array('org value', 'new value'));
         *
         * array_merge_recursive_distinct does not change the datatypes of the values in the arrays.
         * Matching keys' values in the second array overwrite those in the first array, as is the
         * case with array_merge, i.e.:
         *
         * array_merge_recursive_distinct(array('key' => 'org value'), array('key' => 'new value'));
         *     => array('key' => array('new value'));
         *
         * Parameters are passed by reference, though only for performance reasons. They're not
         * altered by this function.
         *
         * @param array $array1
         * @param array $array2
         *
         * @return array
         */
        protected static function array_merge_recursive_distinct(array &$array1, array &$array2) {
            $merged = $array1;
            foreach ($array2 as $key => &$value) {
                if (is_array($value) && isset($merged[$key]) && is_array($merged[$key])) {
                    $merged[$key] = self::array_merge_recursive_distinct($merged[$key], $value);
                } else {
                    $merged[$key] = $value;
                }
            }
            return $merged;
        }

        /**
         * WeCreativez core method to register admin settings
         * @param  string $option_name
         * @param  array  $settings
         * @since 1.0
         */
        public static function register($option_name, $settings = array()) {

            // add plugin settings in wp_options table
            $db_setting    = get_option($option_name, array());
            $merge_setting = self::array_merge_recursive_distinct( $settings, $db_setting );
            update_option($option_name, $merge_setting);

        }

    } // end Wecreativez_Core_Register_Setting

endif;
