<?php
ArContactUsLoader::loadModel('ArContactUsConfigModel');

abstract class ArContactUsConfigButtonAbstract extends ArContactUsConfigModel
{
    public $mode;
    public $button_icon;
    public $button_color;
    public $button_size;
    public $position;
    public $storefront_pos;
    public $x_offset;
    public $y_offset;
    public $pulsate_speed;
    public $icon_speed;
    public $icon_animation_pause;
    public $text;
    public $drag;
    
    public function getFormTitle()
    {
        return __('Button settings', 'ar-contactus');
    }
    
    public function attributeDefaults()
    {
        return array(
            'mode' => 'regular',
            'button_icon' => 'hangouts',
            'button_size' => 'large',
            'button_color' => '008749',
            'position' => 'right',
            'storefront_pos' => 4,
            'x_offset' => '20',
            'y_offset' => '20',
            'pulsate_speed' => 2000,
            'icon_speed' => 600,
            'icon_animation_pause' => 2000,
            'text' => __('Contact us', 'ar-contactus'),
            'drag' => 0,
        );
    }
}
