<?php
/*
Plugin Name: Product password protector for WooCommerce
Plugin URI: http://themeforest.net/user/alex91ckua
Description: Plugin that can be used to enable password protection for your products by creating a password for them.
Version: 1.6.3
Author: Alex Masliychuk (alex91ckua)
Author URI: http://alex-masliychuk.com/
Text Domain: product-protector
Domain Path: /languages
*/

if (!defined('PRODUCT_PROTECTOR_VERSION_NUM'))
	define('PRODUCT_PROTECTOR_VERSION_NUM', '1.6.3');

if ( !defined( 'PRODUCT_PROTECTOR_PLUGIN_NAME' ) )
	define( 'PRODUCT_PROTECTOR_PLUGIN_NAME', 'Product password protector (WooCommerce)' );

if ( !defined( 'PRODUCT_PROTECTOR_TD' ) )
	define( 'PRODUCT_PROTECTOR_TD', 'product-protector' ); // = text domain (used for translations)

if ( !defined( 'PRODUCT_PROTECTOR_FILE' ) )
	define( 'PRODUCT_PROTECTOR_FILE', __FILE__ );

if ( !defined( 'PRODUCT_PROTECTOR_PATH' ) )
	define( 'PRODUCT_PROTECTOR_PATH', plugin_dir_path( __FILE__ ) );

if ( !defined( 'PRODUCT_PROTECTOR_URL' ) )
	define( 'PRODUCT_PROTECTOR_URL', plugin_dir_url( __FILE__ ) );

class Product_Protector_Init
{

	function __construct() {

		add_action( 'plugins_loaded', array( $this, 'product_protector_load_textdomain' ) );

		if ( is_admin() ) {
			add_action( 'plugins_loaded', array( $this, 'product_protector_admin_init' ), 14 );
		}
		else {
			add_action( 'plugins_loaded', array( $this, 'product_protector_frontend_init' ), 14 );
		}

    register_activation_hook ( PRODUCT_PROTECTOR_FILE, array( $this, 'product_protector_install' ) );
	}

  /**
    * Set default global password on activation
    */
	function product_protector_install() {
		update_option('product_protector_global_password', '1234');
	}

  /**
	 * Load plugin textdomain.
	 * @since 1.5
	 */
	function product_protector_load_textdomain() {
		load_plugin_textdomain( PRODUCT_PROTECTOR_TD, false, dirname( plugin_basename( PRODUCT_PROTECTOR_FILE ) ) . '/languages/' );
	}

	function product_protector_admin_init() {
		if (current_user_can('manage_options')) {
			require_once( PRODUCT_PROTECTOR_PATH . 'admin/class-admin.php' );
		}
	}

	function product_protector_frontend_init() {
		require_once( PRODUCT_PROTECTOR_PATH . 'frontend/class-frontend.php' );
	}

}

new Product_Protector_Init();