<?php

namespace ProApp\filters;

use App\baseClasses\KCBase;

class KCProBillingFilters extends KCBase{
    public $db;
    public function __construct() {
        global $wpdb;

        $this->db = $wpdb;
        add_filter('kcpro_get_bill_list', [$this, 'billList']);
        add_filter('kcpro_get_without_bill_encounter_list', [$this, 'getWithoutBillEncounterList']);
    }

    public function billList($request_data){

        $patient_encounter_table = $this->db->prefix . 'kc_patient_encounters';
        $bills_table = $this->db->prefix . 'kc_bills';
        $clinics_table           = $this->db->prefix . 'kc_clinics';
        $users_table             = $this->db->base_prefix . 'users';
        $login_id              = get_current_user_id();
        $current_user_login_role = $this->getLoginUserRole();
        $patient_user_condition = $doctor_user_condition = $clinic_condition = $search_condition = '';
        $orderByCondition = " ORDER BY {$bills_table}.id DESC ";
        $paginationCondition = ' ';
        if((int)$request_data['perPage'] > 0){
            $perPage = (int)$request_data['perPage'];
            $offset = ((int)$request_data['page'] - 1) * $perPage;
            $paginationCondition = " LIMIT {$perPage} OFFSET {$offset} ";
        }

        if(!empty($request_data['sort'])){
            $request_data['sort'] = kcRecursiveSanitizeTextField(json_decode(stripslashes($request_data['sort'][0]),true));
            if(!empty($request_data['sort']['field']) && !empty($request_data['sort']['type']) && $request_data['sort']['type'] !== 'none'){
                $sortField = esc_sql($request_data['sort']['field']);
                $sortByValue = esc_sql(strtoupper($request_data['sort']['type']));
                switch($request_data['sort']['field']){
                    case 'status':
                    case 'id':
                        $orderByCondition = " ORDER BY {$patient_encounter_table}.{$sortField} {$sortByValue} ";
                        break;
                    case 'doctor_name':
                        $orderByCondition = " ORDER BY doctors.display_name {$sortByValue} ";
                        break;
                    case 'clinic_name':
                        $orderByCondition = " ORDER BY {$clinics_table}.name {$sortByValue} ";
                        break;
                    case 'patient_name':
                        $orderByCondition = " ORDER BY patients.display_name {$sortByValue} ";
                        break;
                    case 'created_at':
                    case 'bill_id':
                    case 'total_amount':
                    case 'discount':
                    case 'actual_amount':
                        $sortField = $sortField == 'bill_id' ? 'id' : $sortField;
                        $search_condition.= " ORDER BY {$bills_table}.{$sortField} {$sortByValue}";
                        break;
                }
            }
        }

        if(isset($request_data['searchTerm']) && trim($request_data['searchTerm']) !== ''){
            $request_data['searchTerm'] = esc_sql(strtolower(trim($request_data['searchTerm'])));
            $search_condition.= " AND (
                           {$bills_table}.id LIKE '%{$request_data['searchTerm']}%' 
                           {$patient_encounter_table}.id LIKE '%{$request_data['searchTerm']}%' 
                           OR {$clinics_table}.name LIKE '%{$request_data['searchTerm']}%' 
                           OR doctors.display_name LIKE '%{$request_data['searchTerm']}%' 
                           OR patients.display_name LIKE '%{$request_data['searchTerm']}%'  
                           OR {$patient_encounter_table}.status LIKE '%{$request_data['searchTerm']}%' 
                           ) ";
        }else{
            if(!empty($request_data['columnFilters'])){
                $request_data['columnFilters'] = json_decode(stripslashes($request_data['columnFilters']),true);
                foreach ($request_data['columnFilters'] as $column => $searchValue){
                    $searchValue = $column !== 'created_at' ?  esc_sql(strtolower(trim($searchValue))) :$searchValue ;
                    $column = esc_sql($column);
                    if($searchValue === ''){
                        continue;
                    }
                    switch($column){
                        case 'status':
                        case 'id':
                            $search_condition.= " AND {$patient_encounter_table}.{$column} LIKE '%{$searchValue}%' ";
                            break;
                        case 'doctor_name':
                            $search_condition.= " AND doctors.display_name LIKE '%{$searchValue}%' ";
                            break;
                        case 'clinic_name':
                            $search_condition.= " AND {$clinics_table}.name LIKE '%{$searchValue}%' ";
                            break;
                        case 'patient_name':
                            $search_condition.= " AND patients.display_name LIKE '%{$searchValue}%'";
                            break;
                        case 'bill_id':
                        case 'total_amount':
                        case 'discount':
                        case 'actual_amount':
                            $column = $column == 'bill_id' ? 'id' : $column;
                            $search_condition.= " AND {$bills_table}.{$column} LIKE '%{$searchValue}%'";
                            break;
                        case 'created_at':
                            if(!empty($searchValue['start']) && !empty($searchValue['end'])){
                                $searchValue['start'] = esc_sql(strtolower(trim($searchValue['start'])));
                                $searchValue['end'] = esc_sql(strtolower(trim($searchValue['end'])));
                                $search_condition.= " AND CAST({$bills_table}.{$column} AS DATE )  BETWEEN '{$searchValue['start']}' AND '{$searchValue['end']}' ";
                            }
                            break;
                    }
                }
            }
        }
        if ($this->getPatientRole() === $current_user_login_role) {
            $patient_user_condition =  " AND {$patient_encounter_table}.patient_id = {$login_id} " ;
        }

        if(!empty($request_data['patient_id']) && $request_data['patient_id'] > 0) {
            $request_data['patient_id'] = (int)$request_data['patient_id'];
            $patient_user_condition =  " AND {$patient_encounter_table}.patient_id = {$request_data['patient_id']} " ;
        }

        if ($this->getDoctorRole() === $current_user_login_role) {
            $doctor_user_condition =  " AND {$patient_encounter_table}.doctor_id = {$login_id} " ;
        }

        if( $this->getClinicAdminRole() === $current_user_login_role) {
            $clinic_condition = " AND {$patient_encounter_table}.clinic_id=".kcGetClinicIdOfClinicAdmin();
        }

        if($this->getReceptionistRole() === $current_user_login_role){
            $clinic_condition = " AND {$patient_encounter_table}.clinic_id = " .kcGetClinicIdOfReceptionist() ;
        }


        if ($this->getDoctorRole() === $current_user_login_role) {
            $doctor_user_condition =  " AND {$patient_encounter_table}.doctor_id = {$login_id} " ;
        }

        if( $this->getClinicAdminRole() === $current_user_login_role) {
            $clinic_condition = " AND {$patient_encounter_table}.clinic_id=".kcGetClinicIdOfClinicAdmin();
        }

        if($this->getReceptionistRole() === $current_user_login_role){
            $clinic_condition = " AND {$patient_encounter_table}.clinic_id = " .kcGetClinicIdOfReceptionist() ;
        }

        $common_query = " FROM  {$bills_table}
			   INNER JOIN {$patient_encounter_table}
		              ON {$patient_encounter_table}.id = {$bills_table}.encounter_id
		       LEFT JOIN {$users_table} doctors
		              ON {$patient_encounter_table}.doctor_id = doctors.id
		       LEFT JOIN {$users_table} patients
		              ON {$patient_encounter_table}.patient_id = patients.id
		       LEFT JOIN {$clinics_table}
		              ON {$patient_encounter_table}.clinic_id = {$clinics_table}.id
            WHERE 0 = 0  {$patient_user_condition}  {$doctor_user_condition}  {$clinic_condition} {$search_condition} ";


        $bills_data = $this->db->get_results( "SELECT {$bills_table}.id as bill_id,
               {$bills_table}.title as bill_title,
               {$bills_table}.total_amount as total_amount,
               {$bills_table}.discount as discount,
               {$bills_table}.actual_amount as actual_amount,
               {$bills_table}.created_at as created_at,
               {$patient_encounter_table}.*,
		       doctors.display_name  AS doctor_name,
		       patients.display_name AS patient_name,
		       {$clinics_table}.name AS clinic_name
			   {$common_query} {$orderByCondition} {$paginationCondition} " );

        if ( ! count( $bills_data ) ) {
           return [
                'status'  => false,
                'message' => esc_html__('No encounter found', 'kiviCare-clinic-&-patient-management-system-pro'),
                'data'    => []
            ];
        }

        $total = $this->db->get_var( "SELECT count(*) {$common_query} ");

        $curreny_details = kcGetClinicCurrenyPrefixAndPostfix();
        $total_amount = $discount = $actual_amount = 0;
        foreach ($bills_data as $value){
            $total_amount += $value->total_amount;
            $value->total_amount = $curreny_details['prefix'] .$value->total_amount.$curreny_details['postfix'];
            $discount += $value->discount;
            $value->discount = $curreny_details['prefix'] .$value->discount.$curreny_details['postfix'];
            $actual_amount += $value->actual_amount;
            $value->actual_amount = $curreny_details['prefix'] .$value->actual_amount.$curreny_details['postfix'];
        }
        $total_amount =  $curreny_details['prefix'] .$total_amount.$curreny_details['postfix'];
        $discount =  $curreny_details['prefix'] .$discount.$curreny_details['postfix'];
        $actual_amount =  $curreny_details['prefix'] .$actual_amount.$curreny_details['postfix'];

        $total_data_row = $bills_data[0];
        $total_data_row = (object)array_map(function($item) { return '' ; }, (array)$total_data_row);
        $total_data_row->bill_id = 'Total Value';
        $total_data_row->total_amount = $total_amount;
        $total_data_row->discount = $discount;
        $total_data_row->actual_amount = $actual_amount;
        $total_data_row->last_row = 'yes';
        $bills_data[] =$total_data_row;
        return [
            'status'     => true,
            'message'    => esc_html__('Encounter list', 'kiviCare-clinic-&-patient-management-system-pro'),
            'data'       => $bills_data,
            'total_rows' => $total,
            "clinic_extra" => $curreny_details,
        ] ;

    }

    public function getWithoutBillEncounterList($request_data){
        $login_id              = get_current_user_id();
        $current_user_login_role = $this->getLoginUserRole();
        $patient_encounter_table = $this->db->prefix . 'kc_patient_encounters';
        $bills_table = $this->db->prefix . 'kc_bills';
        $clinics_table           = $this->db->prefix . 'kc_clinics';
        $users_table             = $this->db->base_prefix . 'users';

        $patient_user_condition = $doctor_user_condition = $clinic_condition = $encounter_condition = '';
        $all_bill_encounter = collect($this->db->get_results("SELECT encounter_id FROM {$bills_table}"))->pluck('encounter_id')->implode(',');
        if(!empty($all_bill_encounter)){
            $encounter_condition = " AND {$patient_encounter_table}.id NOT IN ({$all_bill_encounter}) ";
        }


        if ($this->getPatientRole() === $current_user_login_role) {
            $patient_user_condition =  " AND {$patient_encounter_table}.patient_id = {$login_id} " ;
        }

        if ($this->getDoctorRole() === $current_user_login_role) {
            $doctor_user_condition =  " AND {$patient_encounter_table}.doctor_id = {$login_id} " ;
        }

        if( $this->getClinicAdminRole() === $current_user_login_role) {
            $clinic_condition = " AND {$patient_encounter_table}.clinic_id=".kcGetClinicIdOfClinicAdmin();
        }

        if($this->getReceptionistRole() === $current_user_login_role){
            $clinic_condition = " AND {$patient_encounter_table}.clinic_id = " .kcGetClinicIdOfReceptionist() ;
        }

        if(!isKiviCareProActive()){
            $clinic_condition = " AND {$patient_encounter_table}.clinic_id = " .kcGetDefaultClinicId() ;
        }


        $encounters = $this->db->get_results( "SELECT {$patient_encounter_table}.*,
		       doctors.display_name  AS doctor_name,
		       patients.display_name AS patient_name,
		       {$clinics_table}.name AS clinic_name 
			  FROM  {$patient_encounter_table}
		       LEFT JOIN {$users_table} doctors
		              ON {$patient_encounter_table}.doctor_id = doctors.id
		       LEFT JOIN {$users_table} patients
		              ON {$patient_encounter_table}.patient_id = patients.id
		       LEFT JOIN {$clinics_table}
		              ON {$patient_encounter_table}.clinic_id = {$clinics_table}.id
            WHERE 0 = 0 {$encounter_condition} {$patient_user_condition}  {$doctor_user_condition}  {$clinic_condition} " );

        if(empty($encounters)){
            echo json_encode( [
                'status'  => false,
                'message' => esc_html__('No encounter found', 'kiviCare-clinic-&-patient-management-system-pro'),
                'data'    => []
            ] );
            wp_die();
        }

        echo json_encode( [
            'status'  => true,
            'message' => esc_html__('Encounter list without bills', 'kiviCare-clinic-&-patient-management-system-pro'),
            'data'    => $encounters
        ] );
        wp_die();
    }
}