﻿/*
 * ==========================================================
 * BOXCOIN SHOP ADDON SCRIPT
 * ==========================================================
 *
 * © 2022-2025 boxcoin.dev. All rights reserved.
 * 
 */

'use strict';
(function () {
    let _ = window._query;
    let analytics_area;
    let analytics_area_loaded = false;
    let analytics_area_chart;

    function bxc_(text) {
        return BXC_TRANSLATIONS && text in BXC_TRANSLATIONS ? BXC_TRANSLATIONS[text] : text;
    }

    document.addEventListener('DOMContentLoaded', () => {
        analytics_area = _(document.body).find('[data-area="analytics"]');
        analytics_area_chart = analytics_area.find('#bxc-analytics-chart');
    });

    document.addEventListener('BXCSettingsLoaded', function () {
        let shop_url = BXC_CLOUD.custom_domain ? BXC_CLOUD.custom_domain : (BXC_URL + 'shop.php' + (BXC_CLOUD.cloud ? '?cloud=' + BXC_CLOUD.cloud : ''));
        _(document.body).find('#shop-page > div > p').append(`<a href="${shop_url}" target="_blank">${shop_url}</a>.`);
    });

    var BXCAdminShop = { 
        chart_area: false,
        chart_data: false,
        currency: '',

        analytics: function (datepicker) {
            if (analytics_area_loaded) {
                BOXCoin.loading(analytics_area_chart);
                BOXCoin.ajax('analytics', {
                    status: analytics_area.find('.bxc-filter-status li.bxc-active').data('value'),
                    currency: analytics_area.find('.bxc-filter-cryptocurrency li.bxc-active').data('value'),
                    date_range: datepicker ? datepicker.getDates('yyyy-mm-dd') : false,
                    checkout_id: analytics_area.find('.bxc-filter-checkout li.bxc-active').data('value')
                }, (response) => {
                    this.chart(response.data);
                    this.currency = response.currency;
                    analytics_area.find('#bxc-analytics-earnings .bxc-title').html(response.currency.toUpperCase() + ' ' + response.total);
                    analytics_area.find('#bxc-analytics-sales .bxc-title').html(response.sales);
                    BOXCoin.loading(analytics_area_chart, false);
                    BOXCoin.loading(analytics_area, false);
                });
            } else {
                _.load(BXC_URL + 'apps/shop/chart.min.js', true, () => {
                    analytics_area_loaded = true;
                    this.analytics();
                });
            }
        },

        chart: function (data) {
            let values = [];
            let labels = [];
            for (var key in data) {
                values.push(data[key][0]);
                labels.push(key);
            }
            if (this.chart_area) {
                this.chart_area.destroy();
            }
            this.chart_data = data;
            this.chart_area = new Chart(analytics_area_chart.find('canvas').e[0], {
                type: 'bar',
                data: {
                    labels: labels,
                    datasets: [{
                        data: values,
                        backgroundColor: '#2bb0ba',
                        borderWidth: 0
                    }],
                },
                options: {
                    legend: {
                        display: false
                    },
                    tooltips: {
                        callbacks: {
                            label: (tooltipItem, chartData) => {
                                return this.currency.toUpperCase() + ' ' + this.chart_data[tooltipItem.label][0] + '   ' + this.chart_data[tooltipItem.label][1] + ' ' + bxc_('Sales');
                            },
                        },
                        displayColors: false
                    },
                    scales: {
                        yAxes: [{
                            ticks: {
                                beginAtZero: true
                            }
                        }],
                        xAxes: [{
                            ticks: {
                                beginAtZero: true
                            }
                        }],
                    },
                }
            });
        },

        checkoutOpen: function (checkout, area) {
            let settings = {};
            let downloads = checkout && checkout.downloads ? checkout.downloads : [];
            let image = area.find('#checkout-image .bxc-btn-icon');
            for (var i = 0; i < downloads.length; i++) {
                settings['checkout-file' + (i ? '-' + (i + 1) : '')] = downloads[i];
            }
            BXCAdmin.repeater.open(settings, area);
            area.find('#checkout-downloads input').e.forEach((e, i) => {
                if (i < downloads.length) {
                    _(e).val(downloads[i]);
                } else if (i > 0) {
                    _(e).parent().prev().remove();
                    _(e).parent().remove();
                } else {
                    _(e).val('');
                }
            });
            image.prev().val(checkout.image);
            if (checkout.image) {
                image.e[0].style.backgroundImage = 'url("' + BXC_URL + 'uploads' + BXC_CLOUD.path_part + '/' + checkout.image + '")';
            } else {
                image.attr('style', '');
            }
        },

        checkoutSave: function (checkout, area) {
            let downloads = [];
            area.find('#checkout-downloads input').e.forEach(e => {
                if (_(e).val()) {
                    downloads.push(_(e).val());
                }
            });
            checkout.downloads = downloads;
            checkout.image = checkout['checkout-image'];
            delete checkout['checkout-downloads'];
            delete checkout['checkout-image'];
            return checkout;
        }
    }

    window.BXCAdminShop = BXCAdminShop;
}());