<?php
use JsonRpc\Base\Response;

/*
 * ==========================================================
 * SHOP
 * ==========================================================
 *
 *  2022-2025 boxcoin.dev. All rights reserved.
 *
 */

define('BXC_SHOP', '1.0.0');

function bxc_shop_license_key_generate($customer_id, $checkout_id, $transaction_id) {
    if (empty($checkout_id) || empty($transaction_id)) {
        return false;
    }
    $response = bxc_isset(bxc_db_get('SELECT license_key FROM bxc_license_keys WHERE customer_id = ' . bxc_db_escape($customer_id, true) . ' AND checkout_id = ' . bxc_db_escape($checkout_id, true) . ' AND transaction_id = ' . bxc_db_escape($transaction_id, true)), 'license_key');
    if ($response) {
        return $response;
    }
    while (!$response) {
        $license_key = bxc_settings_get('shop-license-key-prefix') . bin2hex(random_bytes(20));
        $response = bxc_db_query('INSERT INTO bxc_license_keys (license_key, customer_id, checkout_id, transaction_id, status, creation_time) VALUES ("' . $license_key . '", "' . bxc_db_escape($customer_id, true) . '", "' . bxc_db_escape($checkout_id, true) . '", "' . bxc_db_escape($transaction_id, true) . '", 1, "' . gmdate('Y-m-d H:i:s') . '")');
    }
    return $response === true ? $license_key : $response;
}

function bxc_shop_license_key_validate($license_key) {
    $license_key = bxc_db_get('SELECT * FROM bxc_license_keys WHERE license_key = "' . bxc_db_escape($license_key) . '"');
    if ($license_key && isset($license_key['license_key'])) {
        return ['license_key' => $license_key, 'checkout' => bxc_checkout_get($license_key['checkout_id']), 'transaction' => bxc_transactions_get($license_key['transaction_id']), 'customer' => bxc_customers_get($license_key['customer_id'])];
    }
    return false;
}

function bxc_shop_license_key_update_status($transaction_id, $status) {
    return bxc_db_query('UPDATE bxc_license_keys SET `status` = ' . bxc_db_escape($status, true) . ' WHERE transaction_id = ' . bxc_db_escape($transaction_id, true));
}

function bxc_shop_db_update() {
    if (empty(bxc_db_get('SHOW TABLES LIKE "bxc_license_keys"'))) {
        bxc_db_query('CREATE TABLE IF NOT EXISTS bxc_license_keys (license_key VARCHAR(191), customer_id INT, checkout_id INT, transaction_id INT, status TINYINT NOT NULL, creation_time DATETIME NOT NULL, extra TINYTEXT, PRIMARY KEY (license_key), FOREIGN KEY (customer_id) REFERENCES bxc_customers(id) ON DELETE CASCADE, FOREIGN KEY (checkout_id) REFERENCES bxc_checkouts(id) ON DELETE CASCADE, FOREIGN KEY (transaction_id) REFERENCES bxc_transactions(id) ON DELETE CASCADE) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci');
        bxc_db_query('ALTER TABLE bxc_transactions ADD COLUMN customer_id INT, ADD CONSTRAINT FOREIGN KEY (customer_id) REFERENCES bxc_customers(id) ON DELETE CASCADE');
        bxc_db_query('ALTER TABLE bxc_transactions ADD COLUMN discount_code VARCHAR(50)');
        bxc_db_query('ALTER TABLE bxc_checkouts ADD COLUMN downloads TEXT, ADD COLUMN image VARCHAR(191), ADD COLUMN custom_fields TEXT');
    }
    if (!BXC_CLOUD && !file_exists(__DIR__ . '/../../shop.php')) {
        bxc_file(__DIR__ . '/../../shop.php', '<?php require_once(__DIR__ . \'/functions.php\'); $minify = isset($_GET[\'debug\']) ? false : (BXC_CLOUD || bxc_settings_get(\'minify\')); ?><!DOCTYPE html><html><head><meta charset="utf-8" /><meta http-equiv="X-UA-Compatible" content="IE=edge" /><meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1.0, user-scalable=no" /><title><?php echo bxc_settings_get(\'shop-page-name\', BXC_CLOUD ? CLOUD_NAME : \'Boxcoin\') ?></title><script src="<?php echo BXC_URL . \'js/client\' . ($minify ? \'.min\' : \'\') . \'.js?v=\' . BXC_VERSION ?>"></script><script src="<?php echo BXC_URL . \'apps/shop/shop.admin\' . ($minify ? \'.min\' : \'\') . \'.js?v=\' . BXC_VERSION ?>"></script><link rel="stylesheet" href="<?php echo BXC_URL . \'css/client.css?v=\' . BXC_VERSION ?>" type="text/css"><link rel="stylesheet" href="<?php echo BXC_URL . \'apps/shop/shop.css?v=\' . BXC_VERSION ?>" media="all" /><link rel="shortcut icon" type="image/svg" href="<?php echo (bxc_settings_get(\'logo-icon-url\', BXC_CLOUD ? CLOUD_ICON : BXC_URL . \'media/icon.svg\')) ?>" /><?php echo bxc_settings_get(\'color-1\') ? \'<style>#bxc-shop-grid > div:hover { border-color: \' .  bxc_settings_get(\'color-1\') . \'; } </style>\' : \'\' ?></head><body><?php echo bxc_shop_page() ?></body></html>');
    }
}

function bxc_shop_transaction_update($transaction_id, $user_details = false, $discount_code = false) {
    $customer_id = false;
    if ($user_details || $discount_code) {
        $query = [];
        if ($user_details) {
            if (is_numeric($user_details)) {
                $customer_id = $user_details;
            } else {
                $customer_id = empty($user_details['email']) ? false : bxc_isset(bxc_customers_get($user_details['email']), 'id');
                if (!$customer_id && (!empty($user_details['email']) || !empty($user_details['first-name']))) {
                    $customer_id = bxc_customers_add(bxc_isset($user_details, 'first-name'), bxc_isset($user_details, 'last-name'), bxc_isset($user_details, 'email', 'NULL'), bxc_isset($user_details, 'phone'), bxc_isset($user_details, 'country'), bxc_isset($user_details, 'country_code'), bxc_isset($user_details, 'extra'));
                }
            }
            if ($customer_id) {
                $query['customer_id'] = $customer_id;
            }
        }
        if ($discount_code) {
            $query['discount_code'] = $discount_code;
        }
        if (!empty($query)) {
            return bxc_transactions_update($transaction_id, $query);
        }
    }
    return false;
}

function bxc_shop_transaction_complete($customer_id, $transaction_id, $checkout_title = '') {
    if (empty($customer_id)) {
        return [''];
    }
    $license_key = '';
    $customer = bxc_customers_get($customer_id);
    $downloads_url = false;
    $transaction = bxc_transactions_get($transaction_id);
    $purchase_data = bxc_shop_transaction_complete_get_details($transaction['checkout_id'], $transaction_id, $customer_id);
    if ($customer['email']) {
        $subject = bxc_settings_get('shop-email-purchase-complete-subject');
        $body = nl2br(trim(bxc_settings_get('shop-email-purchase-complete-body')));
        $username = bxc_customers_username($customer);
        $invoice_url = bxc_get_url('invoice') . bxc_encryption($transaction_id);
        $invoice_url .= bxc_cloud_url_part(!strpos($invoice_url, '?'));
        bxc_email_send($customer['email'], str_replace(['{license_key}', '{user_name}', '{invoice_url}', '{checkout_title}', '{downloads_url}'], [$license_key, $username, $invoice_url, $checkout_title, $downloads_url], $subject), ['message' => str_replace(['{license_key}', '{user_name}', '{invoice_url}', '{checkout_title}', '{downloads_url}'], [$purchase_data['license_key'], $username, $invoice_url, $checkout_title, $purchase_data['downloads_url']], $body)], true);
    }
    return $purchase_data;
}

function bxc_shop_transaction_complete_get_details($checkout_or_id, $transaction_id, $customer_id) {
    $license_key = '';
    $downloads_url = false;
    if ($checkout_or_id) {
        $checkout = is_numeric($checkout_or_id) ? bxc_checkout_get($checkout_or_id) : $checkout_or_id;
        if (bxc_settings_get('shop-license-key')) {
            $license_key = bxc_shop_license_key_generate($customer_id, $checkout['id'], $transaction_id);
        }
        if (!empty($checkout['downloads'])) {
            $downloads_url = BXC_URL . 'pay.php?downloads=' . bxc_encryption($transaction_id);
        }
    }
    return ['license_key' => $license_key, 'downloads_url' => $downloads_url];
}

function bxc_shop_discounts_get($checkout_id = false) {
    $discount_codes = [];
    $items = bxc_settings_get_repeater(['shop-discount-code', 'shop-discount-code-checkout-ids', 'shop-discount-code-amount']);
    for ($i = 0; $i < count($items); $i++) {
        $checkout_ids = explode(',', str_replace(' ', '', $items[$i][1]));
        if (!$checkout_id || in_array($checkout_id, $checkout_ids) || in_array('all', $checkout_ids)) {
            array_push($discount_codes, ['discount_code' => trim($items[$i][0]), 'amount' => $items[$i][2], 'checkout_ids' => $checkout_ids]);
        }
    }
    return $discount_codes;
}

function bxc_shop_discounts_apply($discount_code, $checkout_id, $amount) {
    $discount_code = trim($discount_code);
    $discounts = bxc_shop_discounts_get($checkout_id);
    if ($discounts && !empty($amount)) {
        for ($i = 0; $i < count($discounts); $i++) {
            if ($discount_code == $discounts[$i]['discount_code']) {
                return round(floatval($amount) * floatval($discounts[$i]['amount']), 2);
            }
        }
    }
    return $amount;
}

function bxc_shop_transactions_download($transactions, $header) {
    $customers = bxc_customers_get();
    for ($i = 0; $i < count($transactions); $i++) {
        $customer_id = $transactions[$i]['customer_id'];
        unset($transactions[$i]['customer_id']);
        if ($customer_id) {
            for ($y = 0; $y < count($customers); $y++) {
                if ($customers[$y]['id'] == $customer_id) {
                    $transactions[$i] = array_merge($transactions[$i], ['license_key' => bxc_isset($transactions[$i], 'license_key', ''), 'license_key_status' => bxc_isset($transactions[$i], 'license_key_status', ''), 'customer_id' => $customer_id, 'first_name' => $customers[$y]['first_name'], 'last_name' => $customers[$y]['last_name'], 'email' => $customers[$y]['email'], 'phone' => $customers[$y]['phone'], 'country' => $customers[$y]['country'], 'country_code' => $customers[$y]['country_code']]);
                    break;
                }
            }
        } else {
            $transactions[$i] = array_merge($transactions[$i], ['license_key' => '', 'license_key_status' => '', 'customer_id' => '', 'first_name' => '', 'last_name' => '', 'email' => '', 'phone' => '', 'country' => '', 'country_code' => '']);
        }
    }
    $header = array_merge($header, ['Checkout ID', 'Discount code', 'License key', 'License key status', 'Customer ID', 'First name', 'Last name', 'Email', 'Phone', 'Country', 'Country code']);
    return [$transactions, $header];
}

function bxc_shop_analytics_area() { ?>
    <div data-area="analytics" class="bxc-loading">
        <div class="bxc-nav-wide">
            <div class="bxc-flex">
                <div id="bxc-analytics-earnings">
                    <div class="bxc-title"></div>
                    <div class="bxc-text">
                        <?php bxc_e('Earnings') ?>
                    </div>
                </div>
                <div id="bxc-analytics-sales">
                    <div class="bxc-title"></div>
                    <div class="bxc-text">
                        <?php bxc_e('Sales') ?>
                    </div>
                </div>
                <div id="bxc-filters" class="bxc-btn-icon">
                    <i class="bxc-icon-filters"></i>
                </div>
            </div>
            <?php bxc_admin_filters(false) ?>
        </div>
        <hr />
        <div id="bxc-analytics-chart">
            <canvas></canvas>
        </div>
    </div>
<?php }

function bxc_shop_checkout_area() { ?>
    <div id="checkout-image" class="bxc-input">
        <span>
            <?php bxc_e('Image') ?>
        </span>
        <div class="bxc-setting-input">
            <div id="checkout-image" data-type="upload-file" class="bxc-upload-image">
                <input type="text" readonly />
                <div class="bxc-btn-icon">
                    <i class="bxc-icon-image"></i>
                </div>
                <i class="bxc-icon-close"></i>
            </div>
        </div>
    </div>
    <div id="checkout-downloads" class="bxc-input">
        <span>
            <?php bxc_e('Downloads') ?>
        </span>
        <div class="bxc-setting-input">
            <div class="bxc-repater-line">
                <i class="bxc-icon-close bxc-first-repeater-item"></i>
            </div>
            <div id="checkout-file" data-type="upload-file" data-upload-target="checkout-file" class="bxc-flex">
                <input type="text" readonly />
                <div class="bxc-btn-icon">
                    <i class="bxc-icon-clip"></i>
                </div>
            </div>
            <div class="bxc-underline bxc-btn-repater" data-index="2">
                <?php bxc_e('Add file') ?>
            </div>
        </div>
    </div>
<?php }

function bxc_shop_checkout_init($checkout_id) {
    $shop_code = '';
    if (bxc_settings_get('shop-discount-field') && strpos($checkout_id, 'custom') === false && !empty(bxc_shop_discounts_get($checkout_id))) {
        $shop_code .= '<div id="bxc-discount-field" class="bxc-input bxc-input-btn"><span>' . bxc_('Discount code') . '</span><input type="text"><div class="bxc-btn bxc-btn-border">' . bxc_('Apply') . '</div></div>';
    }
    $user_fileds = [['first-name', 'First name'], ['last-name', 'Last name'], ['email', 'Email']];
    $user_details_code = '';
    for ($i = 0; $i < count($user_fileds); $i++) {
        $active = bxc_settings_get('shop-user-details-' . $user_fileds[$i][0]);
        if ($active) {
            $user_details_code .= '<div class="bxc-input"><span>' . bxc_($user_fileds[$i][1]) . '</span><input name="' . $user_fileds[$i][0] . '" type="text" required></div>';
        }
    }
    if ($user_details_code) {
        $shop_code .= '<div class="bxc-user-details"><div class="bxc-title">' . bxc_('Contact information') . '</div>' . $user_details_code . '</div>';
    }
    return $shop_code;
}

function bxc_shop_checkout_get_part($response) {
    $is_single = !isset($response[0]);
    if ($is_single) {
        $response = [$response];
    }
    for ($i = 0; $i < count($response); $i++) {
        $response[$i]['downloads'] = json_decode(bxc_isset($response[$i], 'downloads', '[]'), true);
    }
    return $is_single ? $response[0] : $response;
}

function bxc_shop_checkout_save_part($checkout, $is_new) {
    $slugs = ['downloads', 'image', 'custom_fields'];
    $shop = $is_new ? ['', ''] : '';
    for ($i = 0; $i < count($slugs); $i++) {
        $value = bxc_isset($checkout, $slugs[$i], '');
        if ($slugs[$i] == 'downloads') {
            $value = $value ? bxc_db_json_escape($value) : '[]';
        } else {
            $value = bxc_db_escape($value);
        }
        $shop = $is_new ? [$shop[0] . ', ' . $slugs[$i], $shop[1] . ', "' . $value . '"'] : $shop . ', ' . $slugs[$i] . ' = "' . $value . '"';
    }
    $all_downloads_db = bxc_db_get('SELECT downloads FROM bxc_checkouts', false);
    $all_downloads = [];
    array_push($all_downloads_db, ['downloads' => json_encode($checkout['downloads'])]);
    for ($i = 0; $i < count($all_downloads_db); $i++) {
        $all_downloads = array_merge($all_downloads, json_decode(bxc_isset($all_downloads_db[$i], 'downloads', '[]'), true));
    }
    $directory = __DIR__ . '/../../uploads' . bxc_cloud_path_part() . '/checkout';
    if (file_exists($directory)) {
        $files = scandir($directory);
        foreach ($files as $file) {
            $path = $directory . '/' . $file;
            if ($file != '.' && $file != '..' && $file != 'index.html' && !in_array($file, $all_downloads)) {
                unlink($path);
            }
        }
    }
    return $shop;
}

function bxc_shop_analytics($status = 'C', $currency = false, $date_range = false, $checkout_id = false) {
    $transactions = bxc_transactions_get_all(-1, false, $status, $currency, $date_range, $checkout_id, 'no_shop');
    $data = [];
    $data_final = [];
    $count = count($transactions);
    $total = 0;
    $sales = 0;
    $amount_slug = $currency && bxc_crypto_is($currency) ? 'amount' : 'amount_fiat';
    $is_amount = $amount_slug == 'amount';
    if ($count) {
        $currency = $currency ? $currency : $transactions[0]['currency'];
        for ($i = $count - 1; $i > -1; $i--) {
            $transaction = $transactions[$i];
            $creation_date = date('d/m/Y', strtotime($transaction['creation_time']));
            $is_new = empty($data[$creation_date]);
            $amount = bxc_isset($transaction, $amount_slug, 0);
            $total += $amount;
            $sales++;
            $data[$creation_date] = [($is_new ? 0 : $data[$creation_date][0]) + $amount, ($is_new ? 0 : $data[$creation_date][1]) + 1];
        }
        if (!$date_range || !$date_range[0]) {
            $keys = array_keys($data);
            $date_range = [date('Y-m-d', strtotime(str_replace('/', '-', $keys[0]))), date('Y-m-d', strtotime(str_replace('/', '-', $keys[count($data) - 1])))];
        }
        $period = new DatePeriod(new DateTime($date_range[0]), new DateInterval('P1D'), new DateTime(date('Y-m-d', strtotime($date_range[1] . '+1 days'))));
        $period = iterator_to_array($period);
        $period_count = count($period);
        $date_format = $period_count > 62 ? 'm/y' : 'd/m/y';
        for ($i = 0; $i < $period_count; $i++) {
            $key = $period[$i]->format($date_format);
            $key_original = $period[$i]->format('d/m/Y');
            $values = empty($data[$key_original]) ? [0, 0] : $data[$key_original];
            $is_new = empty($data_final[$key]);
            $amount_row = ($is_new ? 0 : $data_final[$key][0]) + $values[0];
            $data_final[$key] = [$is_amount ? $amount_row : number_format($amount_row, 2, '.', ''), ($is_new ? 0 : $data_final[$key][1]) + $values[1]];
        }
    }
    return ['data' => $data_final, 'currency' => $currency ? $currency : bxc_settings_get('currency', 'USD'), 'total' => $is_amount ? $total : number_format($total, 2, '.', ''), 'sales' => $sales];
}

function bxc_shop_page() {
    $title = bxc_settings_get('shop-page-title');
    $description = bxc_settings_get('shop-page-description');
    $footer = bxc_settings_get('shop-page-footer');
    $code = '<div id="bxc-shop-page" class="bxc-main"><div class="bxc-shop-logo"><img src="' . bxc_settings_get('logo-url', BXC_URL . 'media/logo.svg') . '" alt="" /></div>' . ($title ? '<div class="bxc-title bxc-shop-title">' . $title . '</div>' : '') . ($description ? '<div class="bxc-text bxc-shop-description">' . $description . '</div>' : '') . '<div id="bxc-shop-grid">';
    $checkouts = bxc_checkout_get();
    for ($i = 0; $i < count($checkouts); $i++) {
        $link = bxc_get_url('checkout') . bxc_isset($checkouts[$i], 'slug', $checkouts[$i]['id']);
        $link .= bxc_cloud_url_part(!strpos($link, '?'));
        $image = bxc_isset($checkouts[$i], 'image');
        $code .= '<div onclick="document.location = \'' . $link . '\'; return false;">' . ($image ? '<a href="' . $link . '"><img src="' . BXC_URL . 'uploads' . bxc_cloud_path_part() . '/' . $image . '" alt="' . $checkouts[$i]['title'] . '" /></a>' : '') . '<div><div class="bxc-title"><a href="' . $link . '">' . $checkouts[$i]['title'] . '</a></div><div class="bxc-text">' . bxc_render_text($checkouts[$i]['description']) . '</div><div class="bxc-text bxc-price">' . $checkouts[$i]['price'] . ' ' . $checkouts[$i]['currency'] . '</div></div></div>';
    }
    return $code . '</div>' . ($footer ? '<div class="bxc-text bxc-shop-footer">' . $footer . '</div>' : '') . '</div>';
}

function bxc_shop_create_transaction_part($transaction_id, $discount_code, $amount, $user_details) {
    $ip_info = bxc_ip_info('country,countryCode');
    $user_details['country'] = bxc_isset($ip_info, 'country', '');
    $user_details['country_code'] = bxc_isset($ip_info, 'countryCode', '');
    bxc_shop_transaction_update($transaction_id, $user_details, $discount_code);
    if (empty($amount)) {
        $transaction = bxc_transactions_get($transaction_id);
        $transaction['status'] = 'C';
        $invoice = bxc_isset($transaction, 'billing') && bxc_settings_get('invoice-active') ? bxc_transactions_invoice($transaction) : false;
        return bxc_transactions_complete($transaction, 0, '', $invoice);
    }
    return true;
}

function bxc_shop_get_download($file_name) {
    $path = __DIR__ . '/../../uploads' . bxc_cloud_path_part() . '/checkout/' . $file_name;
    if (BXC_CLOUD && defined('CLOUD_AWS_S3')) {
        $response = bxc_curl(bxc_cloud_aws_s3_url($file_name), '', [], 'FILE');
        if (is_array($response) && file_exists($response[0])) {
            $path = $response[0];
        }
    }
    if (file_exists($path)) {
        $random_name = bxc_random_string() . '.' . pathinfo($file_name)['extension'];
        $path_2 = __DIR__ . '/../../uploads/temp/';
        if (!file_exists($path_2)) {
            mkdir($path_2, 0755, true);
        }
        copy($path, $path_2 . $random_name);
        return [BXC_URL . 'uploads/temp/' . $random_name, $path_2, $random_name];
    }
    return false;
}

function bxc_shop_downloads($encrypted_transaction_id, $return = false) {
    $transaction_id = bxc_encryption($encrypted_transaction_id, false);
    if ($transaction_id) {
        $transaction = bxc_transactions_get($transaction_id);
        if ($transaction) {
            if ($transaction['status'] == 'C') {
                $checkout = bxc_checkout_get($transaction['checkout_id']);
                $code = '';
                $download_urls = [];
                if ($checkout) {
                    $downloads = $checkout['downloads'];
                    $file_names = '';
                    $count = count($downloads);
                    for ($i = 0; $i < $count; $i++) {
                        $file = bxc_shop_get_download($downloads[$i]);
                        $file_names .= $file[2] . ',';
                        if ($return) {
                            array_push($download_urls, $file[0]);
                        } else {
                            $code .= 'download("' . $file[0] . '");' . PHP_EOL;
                        }
                    }
                }
                if ($return) {
                    return [$download_urls, $file_names];
                } else {
                    die($code ? '<html lang="en"><body><script>function ajax() { let xhr = new XMLHttpRequest(); let fd = ""; xhr.open("POST", "' . BXC_URL . 'ajax.php' . '", true); fd = new FormData(); fd.append("data", JSON.stringify({ function: "shop-delete-downloads", file_names: "' . substr($file_names, 0, -1) . '" })); xhr.send(fd); } function download(url) { var anchor = document.createElement("a");anchor.href = url;anchor.download = url;document.body.appendChild(anchor);anchor.click();document.body.removeChild(anchor); }' . $code . 'setTimeout(() => { ajax(); setTimeout(() => { window.close("", "_parent", "");  }, 300) }, 300);</script></body><html>' : 'Now downloads found.');
                }
            } else {
                die('Transaction not completed.');
            }
        } else {
            die('Transaction not found.');
        }
    } else {
        die('Transaction ID not found.');
    }
}

function bxc_shop_downloads_delete($file_names) {
    ignore_user_abort();
    if (is_string($file_names)) {
        $file_names = explode(',', $file_names);
    }
    for ($i = 0; $i < count($file_names); $i++) {
        if ($file_names[$i]) {
            $path = __DIR__ . '/../../uploads/temp/' . $file_names[$i];
            if (file_exists($path)) {
                unlink($path);
            }
        }
    }
}

function bxc_shop_downloads_delete_old_files() {
    $path = __DIR__ . '/../../uploads/temp';
    $files = scandir($path);
    $now_less_1_hour = time() - 3600;
    foreach ($files as $file) {
        if ($file != '.' && $file != '..') {
            $path_file = $path . '/' . $file;
            if (filemtime($path_file) < $now_less_1_hour) {
                if (!is_dir($path_file)) {
                    unlink($path_file);
                }
            }
        }
    }
}

?>