<?php

/*
 * ==========================================================
 * WEBHOOK.PHP
 * ==========================================================
 *
 * Cloud version credits payment webhook.  2022-2025 boxcoin.dev. All rights reserved.
 *
 */

$response = json_decode(file_get_contents('php://input'), true);
$is_stripe = isset($response['id']);
if ($is_stripe || isset($response['key'])) {
    require('../functions.php');
    require('functions.php');
    $boxcoin_transaction_id = false;
    if ($is_stripe) {
        $response = json_decode(bxc_curl('https://api.stripe.com/v1/events/' . $response['id'], '',  [ 'Authorization: Basic ' . base64_encode(STRIPE_KEY) ], 'GET'), true);
        if (isset($response['data']) && isset($response['data']['object'])) {
            $boxcoin_transaction_id = $response['data']['object']['client_reference_id'];
        }
    } else if ($response['key'] === CLOUD_WEBHOOK_KEY) {
        $boxcoin_transaction_id = $response['transaction']['id'];
    }
    if ($boxcoin_transaction_id) {
        $response = json_decode(bxc_curl(CLOUD_URL . 'payment/api.php', ['function' => 'get-transaction', 'transaction_id' => $boxcoin_transaction_id, 'api-key' => CLOUD_WEBHOOK_API_KEY], '', 'POST'), true);
        if ($response && isset($response['success'])) {
            $response = $response['response'];
            if ($response['status'] === 'C') {
                $cloud_user_id = db_escape(bxc_cloud_encryption($response['external_reference'], false), true);
                $token = db_get('SELECT token FROM users WHERE id = "' . $cloud_user_id . '"');
                $amount = db_escape($response['amount_fiat'], true);
                require('config/' .  $token['token'] . '.php');
                db_query('INSERT INTO payment_history (user_id, amount, date, transaction_id, invoice) VALUES ("' . $cloud_user_id . '", "' . $amount . '", NOW(), "' . $response['id'] . '", ' . (empty($response['billing']) ? 'false' : 'true') . ')');
                bxc_db_query('UPDATE bxc_settings SET value = value + ' . $amount . ' WHERE name = "credit_balance"');
            }
        }
    }

}

?>