<?php

    // Function to generate breadcrumbs
    function ams_fetch_navbar_data() {
        $regions = ams_get_amazon_regions();
        $regionsL = ams_get_amazon_regions_limited();
        $regions_placeholder = get_option('ams_amazon_country');
        foreach ($regions as $key => $value) {
            if ($regions_placeholder == $key) {
                $regions_placeholder = $value['RegionName'];
                break;
            }
        }
        $category_placeholder = get_option('ams_default_category');
        $category_placeholder = $category_placeholder == "_auto_import_amazon" ? "Auto Import From Amazon" : $category_placeholder;
        $store_currency = get_woocommerce_currency();
        $currency_code_options = get_woocommerce_currencies();
        $currency_placeholder = $store_currency;
        foreach ($currency_code_options as $code => $value) {
            if ($store_currency == $code) {
                $currency_placeholder = $value;
                break;
            }
        }

        return array(
            'regions_placeholder' => $regions_placeholder,
            'category_placeholder' => $category_placeholder,
            'currency_placeholder' => $currency_placeholder
        );
    }

    function ams_generate_breadcrumbs() {
        $breadcrumbs = array(
            array(
                'title' => '<i class="fas fa-home me-1"></i>' . __('Home', 'ams-wc-amazon'), 
                'url' => admin_url('admin.php?page=wc-amazon-affiliate'),
                'icon' => 'fas fa-home'
            )
        );

        $current_page = isset($_GET['page']) ? $_GET['page'] : '';
        $current_tab = isset($_GET['tab']) ? $_GET['tab'] : '';

        switch ($current_page) {
            case 'wc-amazon-affiliate':
                $breadcrumbs[] = array(
                    'title' => '<i class="fas fa-chart-bar me-1"></i>' . __('Dashboard', 'ams-wc-amazon'), 
                    'url' => '',
                    'icon' => 'fas fa-chart-bar'
                );
                break;
            case 'wc-product-search':
                $breadcrumbs[] = array(
                    'title' => '<i class="fas fa-cloud-upload-alt me-1"></i>' . __('Import Products', 'ams-wc-amazon'), 
                    'url' => '',
                    'icon' => 'fas fa-cloud-upload-alt'
                );
                $breadcrumbs[] = array(
                    'title' => __('With Amazon API', 'ams-wc-amazon'), 
                    'url' => '',
                    'icon' => 'fas fa-key'
                );
                break;
            case 'product-import-by-url':
                $breadcrumbs[] = array(
                    'title' => '<i class="fas fa-cloud-upload-alt me-1"></i>' . __('Import Products', 'ams-wc-amazon'), 
                    'url' => '',
                    'icon' => 'fas fa-cloud-upload-alt'
                );
                $breadcrumbs[] = array(
                    'title' => __('By URL', 'ams-wc-amazon'), 
                    'url' => '',
                    'icon' => 'fas fa-link'
                );
                break;
            case 'products-search-without-api':
                $breadcrumbs[] = array(
                    'title' => '<i class="fas fa-cloud-upload-alt me-1"></i>' . __('Import Products', 'ams-wc-amazon'), 
                    'url' => '',
                    'icon' => 'fas fa-cloud-upload-alt'
                );
                $breadcrumbs[] = array(
                    'title' => __('Without API', 'ams-wc-amazon'), 
                    'url' => '',
                    'icon' => 'fas fa-search'
                );
                break;
            case 'amazon-bestsellers':
                $breadcrumbs[] = array(
                    'title' => '<i class="fas fa-cloud-upload-alt me-1"></i>' . __('Import Products', 'ams-wc-amazon'), 
                    'url' => '',
                    'icon' => 'fas fa-cloud-upload-alt'
                );
                $breadcrumbs[] = array(
                    'title' => __('Amazon Bestsellers', 'ams-wc-amazon'), 
                    'url' => '',
                    'icon' => 'fas fa-trophy'
                );
                break;
            case 'product-review-import':
                $breadcrumbs[] = array(
                    'title' => '<i class="fas fa-comments me-1"></i>' . __('Import Reviews', 'ams-wc-amazon'), 
                    'url' => '',
                    'icon' => 'fas fa-comments'
                );
                break;
            case 'view-logs':
                $breadcrumbs[] = array(
                    'title' => '<i class="fas fa-cog me-1"></i>' . __('Settings', 'ams-wc-amazon'), 
                    'url' => admin_url('admin.php?page=wc-product-setting-page'),
                    'icon' => 'fas fa-cog'
                );
                $breadcrumbs[] = array(
                    'title' => '<i class="fas fa-list-alt me-1"></i>' . __('View Logs', 'ams-wc-amazon'), 
                    'url' => '',
                    'icon' => 'fas fa-list-alt'
                );
                break;
            case 'amazon-bestsellers':
                $breadcrumbs[] = array(
                    'title' => '<i class="fas fa-cloud-upload-alt me-1"></i>' . __('Import Products', 'ams-wc-amazon'), 
                    'url' => '',
                    'icon' => 'fas fa-cloud-upload-alt'
                );
                $breadcrumbs[] = array(
                    'title' => __('Bestsellers', 'ams-wc-amazon'), 
                    'url' => '',
                    'icon' => 'fas fa-trophy'
                );
                break;
            case 'automation':
                $breadcrumbs[] = array(
                    'title' => '<i class="fas fa-robot me-1"></i>' . __('Automation', 'ams-wc-amazon'), 
                    'url' => '',
                    'icon' => 'fas fa-robot'
                );
                break;
            case 'automation-logs':
                $breadcrumbs[] = array(
                    'title' => '<i class="fas fa-robot me-1"></i>' . __('Automation', 'ams-wc-amazon'), 
                    'url' => admin_url('admin.php?page=automation'),
                    'icon' => 'fas fa-robot'
                );
                $breadcrumbs[] = array(
                    'title' => '<i class="fas fa-file-alt me-1"></i>' . __('System Logs', 'ams-wc-amazon'), 
                    'url' => '',
                    'icon' => 'fas fa-file-alt'
                );
                break;
            case 'wc-product-setting-page':
                $breadcrumbs[] = array(
                    'title' => '<i class="fas fa-cog me-1"></i>' . __('Settings', 'ams-wc-amazon'), 
                    'url' => '',
                    'icon' => 'fas fa-cog'
                );
                if ($current_tab) {
                    switch ($current_tab) {
                        case 'pills-general-tab':
                            $breadcrumbs[] = array(
                                'title' => '<i class="fas fa-file-text me-1"></i>' . __('Configuration', 'ams-wc-amazon'), 
                                'url' => '',
                                'icon' => 'fas fa-file-text'
                            );
                            break;
                        case 'pills-az-settings-tab':
                            $breadcrumbs[] = array(
                                'title' => '<i class="fas fa-key me-1"></i>' . __('Amazon API Settings', 'ams-wc-amazon'), 
                                'url' => '',
                                'icon' => 'fas fa-key'
                            );
                            break;
                        case 'pills-az-products-tab':
                            $breadcrumbs[] = array(
                                'title' => '<i class="fas fa-sync-alt me-1"></i>' . __('Auto Products Update', 'ams-wc-amazon'), 
                                'url' => '',
                                'icon' => 'fas fa-sync-alt'
                            );
                            break;
                    }
                }
                break;
        }

        return $breadcrumbs;
    }

    function get_wc_terms() {
        $categories = get_terms( array(
            'hide_empty' => false,
        ) );
        $cat = array();
        foreach ( $categories as $row ) {
            if ( $row->slug == "uncategorized" ) continue;
            if ( 'product_cat' === $row->taxonomy ) {
                $cat[] = array(
                    'term_id'  => $row->term_id,
                    'name'  => $row->name,
                );
            }
        }
        return array_reverse($cat);
    }

    /**
     * Define amazon RegionName and host and also RegionCode
     *
     * @return string[][]
     */
    function ams_get_amazon_regions() {
        $regions = array(
            'com.au' => array('RegionName' => 'Australia', 'Host' => 'webservices.amazon.com.au', 'RegionCode' => 'us-west-2'),
            'com.br' => array('RegionName' => 'Brazil', 'Host' => 'webservices.amazon.com.br', 'RegionCode' => 'us-east-1'),
            'ca' => array('RegionName' => 'Canada', 'Host' => 'webservices.amazon.ca', 'RegionCode' => 'us-east-1'),
            'cn' => array('RegionName' => 'China', 'Host' => 'webservices.amazon.cn', 'RegionCode' => 'us-west-2'),
            'fr' => array('RegionName' => 'France', 'Host' => 'webservices.amazon.fr', 'RegionCode' => 'eu-west-1'),
            'de' => array('RegionName' => 'Germany', 'Host' => 'webservices.amazon.de', 'RegionCode' => 'eu-west-1'),
            'in' => array('RegionName' => 'India', 'Host' => 'webservices.amazon.in', 'RegionCode' => 'eu-west-1'),
            'it' => array('RegionName' => 'Italy', 'Host' => 'webservices.amazon.it', 'RegionCode' => 'eu-west-1'),
            'jp' => array('RegionName' => 'Japan', 'Host' => 'webservices.amazon.co.jp', 'RegionCode' => 'us-west-2'),
            'mx' => array('RegionName' => 'Mexico', 'Host' => 'webservices.amazon.com.mx', 'RegionCode' => 'us-east-1'),
            'nl' => array('RegionName' => 'Netherlands', 'Host' => 'webservices.amazon.nl', 'RegionCode' => 'eu-west-1'),
            'sa' => array('RegionName' => 'Saudi Arabia', 'Host' => 'webservices.amazon.sa', 'RegionCode' => 'eu-west-1'),
            'sg' => array('RegionName' => 'Singapore', 'Host' => 'webservices.amazon.sg', 'RegionCode' => 'us-west-2'),
            'es' => array('RegionName' => 'Spain', 'Host' => 'webservices.amazon.es', 'RegionCode' => 'eu-west-1'),
            'com.tr' => array('RegionName' => 'Turkey', 'Host' => 'webservices.amazon.com.tr', 'RegionCode' => 'eu-west-1'),
            'ae' => array('RegionName' => 'United Arab Emirates', 'Host' => 'webservices.amazon.ae', 'RegionCode' => 'eu-west-1'),
            'co.uk' => array('RegionName' => 'United Kingdom', 'Host' => 'webservices.amazon.co.uk', 'RegionCode' => 'eu-west-1'),
            'com' => array('RegionName' => 'United States', 'Host' => 'webservices.amazon.com', 'RegionCode' => 'us-east-1'),
            'pl' => array('RegionName' => 'Poland', 'Host' => 'webservices.amazon.pl', 'RegionCode' => 'eu-west-1'),
        );
        return $regions;
    }

    /**
     * Get currency for Amazon region
     * 
     * @param string $region Amazon region code
     * @return string Currency code
     */
    function ams_get_currency_for_region($region) {
        $currency_map = array(
            'com.au' => 'AUD', // Australia
            'com.br' => 'BRL', // Brazil
            'ca' => 'CAD',      // Canada
            'cn' => 'CNY',      // China
            'fr' => 'EUR',      // France
            'de' => 'EUR',      // Germany
            'in' => 'INR',      // India
            'it' => 'EUR',      // Italy
            'jp' => 'JPY',      // Japan
            'mx' => 'MXN',      // Mexico
            'nl' => 'EUR',      // Netherlands
            'sa' => 'SAR',      // Saudi Arabia
            'sg' => 'SGD',      // Singapore
            'es' => 'EUR',      // Spain
            'com.tr' => 'TRY',  // Turkey
            'ae' => 'AED',      // United Arab Emirates
            'co.uk' => 'GBP',   // United Kingdom
            'com' => 'USD',     // United States
            'pl' => 'PLN',      // Poland
        );
        
        return isset($currency_map[$region]) ? $currency_map[$region] : 'USD';
    }

    /**
     * Get the correct marketplace value for Amazon API requests
     * 
     * @param string $locale Amazon locale code
     * @return string Marketplace value
     */
    function ams_get_marketplace_value($locale) {
        // Handle special cases for marketplace values
        if ($locale === 'mx') {
            return "www.amazon.com.mx";
        } elseif ($locale === 'br') {
            return "www.amazon.com.br";
        } elseif ($locale === 'tr') {
            return "www.amazon.com.tr";
        } elseif ($locale === 'au') {
            return "www.amazon.com.au";
        } else {
            return "www.amazon.{$locale}";
        }
    }

    function ams_get_amazon_regions_limited() {
        $regions = array(
            'ca' => array('RegionName' => 'Canada', 'Host' => 'webservices.amazon.ca', 'RegionCode' => 'us-east-1'),
            'fr' => array('RegionName' => 'France', 'Host' => 'webservices.amazon.fr', 'RegionCode' => 'eu-west-1'),
            'de' => array('RegionName' => 'Germany', 'Host' => 'webservices.amazon.de', 'RegionCode' => 'eu-west-1'),
            'jp' => array('RegionName' => 'Japan', 'Host' => 'webservices.amazon.co.jp', 'RegionCode' => 'us-west-2'),
            'co.uk' => array('RegionName' => 'United Kingdom', 'Host' => 'webservices.amazon.co.uk', 'RegionCode' => 'eu-west-1'),
            'com' => array('RegionName' => 'United States', 'Host' => 'webservices.amazon.com', 'RegionCode' => 'us-east-1'),
        );
        return $regions;
    }

    function no_api_active_country_url() {
        $default = 'com';
        $selected_country = get_option('ams_amazon_country') ?? $default;

        $regions = [
            'ca'        =>      'https://www.amazon.ca',
            'cn'        =>      'https://www.amazon.com',
            'fr'        =>      'https://www.amazon.fr',
            'de'        =>      'https://www.amazon.de',
            'in'        =>      'https://www.amazon.in',
            'it'        =>      'https://www.amazon.it',
            'nl'        =>      'https://www.amazon.nl',
            'sa'        =>      'https://www.amazon.sa',
            'sg'        =>      'https://www.amazon.sg',
            'es'        =>      'https://www.amazon.es',
            'ae'        =>      'https://www.amazon.ae',
            'pl'        =>      'https://www.amazon.pl',
            'com'       =>      'https://www.amazon.com',
            'jp'        =>      'https://www.amazon.co.jp',
            'mx'        =>      'https://www.amazon.com.mx',
            'co.uk'     =>      'https://www.amazon.co.uk',
            'com.au'    =>      'https://www.amazon.com.au',
            'com.br'    =>      'https://www.amazon.com.br',
            'com.tr'    =>      'https://www.amazon.com.tr',
        ];

        if( array_key_exists($selected_country, $regions) ) {
            return $regions[$selected_country];
        }

        return $regions[$default];
    }

    /**
     * Total products information is brought through this function
     *
     * @return array
     */
    function ams_get_all_products_info()
    {
        global $wpdb;
        $results = $wpdb->get_results(
            $wpdb->prepare(
                "SELECT DISTINCT $wpdb->posts.ID, $wpdb->postmeta.meta_value
                 FROM $wpdb->posts, $wpdb->postmeta
                 WHERE $wpdb->posts.ID  = $wpdb->postmeta.post_id
                 AND $wpdb->posts.post_type  = %s
                 AND $wpdb->posts.post_status != %s
                 AND $wpdb->postmeta.meta_key = %s
                 ",
                'product', 'trash', '_wca_amazon_affiliate_asin'
            )
        );
        $products_search_count = get_option('wca_products_search_count');
        $data = array();
        $data['asin'] = [];
        $total_view_count = 0;
        $total_product_direct_redirected = 0;
        $total_product_added_to_cart = 0;
        foreach ($results as $row) {
            if(empty($row->meta_value)) continue;
            $data['asin'][] = $row->meta_value;
            $data['id'][] = $row->ID;
            $data['product_id'][$row->ID]['method'] = get_post_meta($row->ID, '_import_method', true);
            $data['product_id'][$row->ID]['region'] = get_post_meta($row->ID, '_region', true);
            $data['product_id'][$row->ID]['url'] = get_post_meta($row->ID, '_detail_page_url', true);
            $view = get_post_meta($row->ID, 'ams_product_views_count', true);
            $total_view_count = $total_view_count + (int) $view;
            $product_direct_redirected = get_post_meta($row->ID, 'ams_product_direct_redirected', true);
            $total_product_direct_redirected = $total_product_direct_redirected + (int) $product_direct_redirected;
            $product_added_to_cart = get_post_meta($row->ID, 'ams_product_added_to_cart', true);
            $total_product_added_to_cart = $total_product_added_to_cart + (int) $product_added_to_cart;
        }
        $data['total_view_count'] = $total_view_count;
        $data['total_product_direct_redirected'] = $total_product_direct_redirected;
        $data['total_product_added_to_cart'] = $total_product_added_to_cart;
        $data['products_count'] = (isset($data['product_id'])) ? sizeof($data['product_id']) : 0;
        $data['products_search_count'] = $products_search_count;
        return $data;
    }

    /**
     * Total products information is brought through this function
     *
     * @return array
     */
    function ams_get_all_products_info_with_parent()
    {
        global $wpdb;
        $results = $wpdb->get_results(
            $wpdb->prepare(
                "SELECT DISTINCT $wpdb->posts.ID, $wpdb->postmeta.meta_value
                 FROM $wpdb->posts, $wpdb->postmeta
                 WHERE $wpdb->posts.ID  = $wpdb->postmeta.post_id
                 AND $wpdb->posts.post_type  = %s
                 AND $wpdb->posts.post_status != %s
                 AND ( $wpdb->postmeta.meta_key = %s || $wpdb->postmeta.meta_key = %s )
                 ",
                'product', 'trash', '_wca_amazon_affiliate_asin', '_wca_amazon_affiliate_parent_asin'
            )
        );
        $products_search_count = get_option('wca_products_search_count');
        $data = array();
        $data['asin'] = [];
        $total_view_count = 0;
        $total_product_direct_redirected = 0;
        $total_product_added_to_cart = 0;
        foreach ($results as $row) {
            if(empty($row->meta_value)) continue;
            $data['asin'][] = $row->meta_value;
            $data['id'][] = $row->ID;
            $data['product_id'][$row->ID]['method'] = get_post_meta($row->ID, '_import_method', true);
            $data['product_id'][$row->ID]['region'] = get_post_meta($row->ID, '_region', true);
            $data['product_id'][$row->ID]['url'] = get_post_meta($row->ID, '_detail_page_url', true);
            $view = get_post_meta($row->ID, 'ams_product_views_count', true);
            $total_view_count = $total_view_count + (int) $view;
            $product_direct_redirected = get_post_meta($row->ID, 'ams_product_direct_redirected', true);
            $total_product_direct_redirected = $total_product_direct_redirected + (int) $product_direct_redirected;
            $product_added_to_cart = get_post_meta($row->ID, 'ams_product_added_to_cart', true);
            $total_product_added_to_cart = $total_product_added_to_cart + (int) $product_added_to_cart;
        }
        $data['total_view_count'] = $total_view_count;
        $data['total_product_direct_redirected'] = $total_product_direct_redirected;
        $data['total_product_added_to_cart'] = $total_product_added_to_cart;
        $data['products_count'] = (isset($data['product_id'])) ? sizeof($data['product_id']) : 0;
        $data['products_search_count'] = $products_search_count;
        return $data;
    }

    /**
     * Track daily dashboard statistics for trend calculations
     * This function should be called daily via cron job
     */
    function ams_track_daily_dashboard_stats() {
        $products_info = ams_get_all_products_info_with_parent();
        
        $today = date('Y-m-d');
        $stats = array(
            'date' => $today,
            'products_count' => $products_info['products_count'],
            'total_view_count' => $products_info['total_view_count'],
            'total_product_added_to_cart' => $products_info['total_product_added_to_cart'],
            'total_product_direct_redirected' => $products_info['total_product_direct_redirected'],
            'products_search_count' => $products_info['products_search_count']
        );
        
        // Store today's stats
        update_option('ams_dashboard_stats_' . $today, $stats);
        
        // Keep only last 90 days of data
        $cutoff_date = date('Y-m-d', strtotime('-90 days'));
        $all_options = wp_load_alloptions();
        
        foreach ($all_options as $option_name => $option_value) {
            if (strpos($option_name, 'ams_dashboard_stats_') === 0) {
                $date_str = str_replace('ams_dashboard_stats_', '', $option_name);
                if ($date_str < $cutoff_date) {
                    delete_option($option_name);
                }
            }
        }
        
        return $stats;
    }
    
    /**
     * Calculate dashboard trends based on historical data
     */
    function ams_calculate_dashboard_trends($days_back = 30) {
        $current_stats = ams_get_all_products_info_with_parent();
        $compare_date = date('Y-m-d', strtotime("-{$days_back} days"));
        $previous_stats = get_option('ams_dashboard_stats_' . $compare_date, array());
        
        $trends = array();
        
        // Calculate trends for each metric
        $metrics = array(
            'products_count' => 'products_count',
            'total_view_count' => 'total_view_count', 
            'total_product_added_to_cart' => 'total_product_added_to_cart',
            'total_product_direct_redirected' => 'total_product_direct_redirected'
        );
        
        foreach ($metrics as $key => $current_key) {
            $current_value = isset($current_stats[$current_key]) ? $current_stats[$current_key] : 0;
            $previous_value = isset($previous_stats[$key]) ? $previous_stats[$key] : 0;
            
            if ($previous_value == 0) {
                $trends[$key] = $current_value > 0 ? '+100%' : '0%';
            } else {
                $percentage = (($current_value - $previous_value) / $previous_value) * 100;
                $sign = $percentage >= 0 ? '+' : '';
                $trends[$key] = $sign . round($percentage, 1) . '%';
            }
        }
        
        return $trends;
    }

    /**
     * Get dashboard statistics with real trends
     */
    function ams_get_dashboard_stats_with_trends() {
        $stats = ams_get_all_products_info_with_parent();
        $trends = ams_calculate_dashboard_trends(30); // 30-day trends
        
        return array_merge($stats, array('trends' => $trends));
    }
    
    /**
     * Setup daily cron job for dashboard statistics tracking
     */
    function ams_setup_dashboard_cron() {
        if (!wp_next_scheduled('ams_daily_dashboard_stats')) {
            wp_schedule_event(time(), 'daily', 'ams_daily_dashboard_stats');
        }
    }

    /**
     * Amazon affiliate departments country base
     *
     * @return string[][]
     */
    function ams_amazon_departments()
    {
        $cat = array(
            'com.au' => array(
                'All' => 'All Departments',
                'Automotive' => 'Automotive',
                'Baby' => 'Baby',
                'Beauty' => 'Beauty',
                'Books' => 'Books',
                'Computers' => 'Computers',
                'Electronics' => 'Electronics',
                'EverythingElse' => 'Everything Else',
                'Fashion' => 'Clothing & Shoes',
                'GiftCards' => 'Gift Cards',
                'HealthPersonalCare' => 'Health, Household & Personal Care',
                'HomeAndKitchen' => 'Home & Kitchen',
                'KindleStore' => 'Kindle Store',
                'Lighting' => 'Lighting',
                'Luggage' => 'Luggage & Travel Gear',
                'MobileApps' => 'Apps & Games',
                'MoviesAndTV' => 'Movies & TV',
                'Music' => 'CDs & Vinyl',
                'OfficeProducts' => 'Stationery & Office Products',
                'PetSupplies' => 'Pet Supplies',
                'Software' => 'Software',
                'SportsAndOutdoors' => 'Sports, Fitness & Outdoors',
                'ToolsAndHomeImprovement' => 'Home Improvement',
                'ToysAndGames' => 'Toys & Games',
                'VideoGames' => 'Video Games',
            ),
            'com.br' => array(
                'All' => 'Todos os departamentos',
                'Books' => 'Livros',
                'Computers' => 'Computadores e Informática',
                'Electronics' => 'Eletrônicos',
                'HomeAndKitchen' => 'Casa e Cozinha',
                'KindleStore' => 'Loja Kindle',
                'MobileApps' => 'Apps e Jogos',
                'OfficeProducts' => 'Material para Escritório e Papelaria',
                'ToolsAndHomeImprovement' => 'Ferramentas e Materiais de Construção',
                'VideoGames' => 'Games',
            ),
            'ca' => array(
                'All' => 'All Department',
                'Apparel' => 'Clothing & Accessories',
                'Automotive' => 'Automotive',
                'Baby' => 'Baby',
                'Beauty' => 'Beauty',
                'Books' => 'Books',
                'Classical' => 'Classical Music',
                'Electronics' => 'Electronics',
                'EverythingElse' => 'Everything Else',
                'ForeignBooks' => 'English Books',
                'GardenAndOutdoor' => 'Patio, Lawn & Garden',
                'GiftCards' => 'GiftCards',
                'GroceryAndGourmetFood' => 'Grocery & Gourmet Food',
                'Handmade' => 'Handmade',
                'HealthPersonalCare' => 'Health & Personal Care',
                'HomeAndKitchen' => 'Home & Kitchen',
                'Industrial' => 'Industrial & Scientific',
                'Jewelry' => 'Jewelry',
                'KindleStore' => 'Kindle Store',
                'Luggage' => 'Luggage & Bags',
                'LuxuryBeauty' => 'Luxury Beauty',
                'MobileApps' => 'Apps & Games',
                'MoviesAndTV' => 'Movies & TV',
                'Music' => 'Music',
                'MusicalInstruments' => 'Musical Instruments, Stage & Studio',
                'OfficeProducts' => 'Office Products',
                'PetSupplies' => 'Pet Supplies',
                'Shoes' => 'Shoes & Handbags',
                'Software' => 'Software',
                'SportsAndOutdoors' => 'Sports & Outdoors',
                'ToolsAndHomeImprovement' => 'Tools & Home Improvement',
                'ToysAndGames' => 'Toys & Games',
                'VHS' => 'VHS',
                'VideoGames' => 'Video Games',
                'Watches' => 'Watches',
            ),
            // 'cn' => array(
            //     'All' => 'All Departments',
            // ),
            'fr' => array(
                'All' => 'Toutes nos catégories',
                'Apparel' => 'Vêtements et accessoires',
                'Appliances' => 'Gros électroménager',
                'Automotive' => 'Auto et Moto',
                'Baby' => '  Bébés & Puériculture',
                'Beauty' => 'Beauté et Parfum',
                'Books' => 'Livres en français',
                'Computers' => 'Informatique',
                'DigitalMusic' => 'Téléchargement de musique',
                'Electronics' => 'High-Tech',
                'EverythingElse' => 'Autres',
                'Fashion' => 'Mode',
                'ForeignBooks' => 'Livres anglais et étrangers',
                'GardenAndOutdoor' => 'Jardin',
                'GiftCards' => 'Boutique chèques-cadeaux',
                'GroceryAndGourmetFood' => 'Epicerie',
                'Handmade' => 'Handmade',
                'HealthPersonalCare' => 'Hygiène et Santé',
                'HomeAndKitchen' => 'Cuisine & Maison',
                'Industrial' => 'Secteur industriel & scientifique',
                'Jewelry' => 'Bijoux',
                'KindleStore' => 'Boutique Kindle',
                'Lighting' => 'Luminaires et Eclairage',
                'Luggage' => 'Bagages',
                'LuxuryBeauty' => 'Beauté Prestige',
                'MobileApps' => 'Applis & Jeux',
                'MoviesAndTV' => 'DVD & Blu-ray',
                'Music' => 'Musique : CD & Vinyles',
                'MusicalInstruments' => 'Instruments de musique & Sono',
                'OfficeProducts' => 'Fournitures de bureau',
                'PetSupplies' => 'Animalerie',
                'Shoes' => 'Chaussures et Sacs',
                'Software' => 'Software',
                'SportsAndOutdoors' => 'Sports et Loisirs',
                'ToolsAndHomeImprovement' => 'Bricolage',
                'ToysAndGames' => 'Jeux et Jouets',
                'VHS' => 'VHS',
                'VideoGames' => 'Jeux vidéo',
                'Watches' => 'Montres',
            ),
            'de' => array(
                'All' => 'Alle Kategorien',
                'AmazonVideo' => 'Prime Video',
                'Apparel' => 'Bekleidung',
                'Appliances' => 'Elektro-Großgeräte',
                'Automotive' => 'Auto & Motorrad',
                'Baby' => 'Baby',
                'Beauty' => 'Beauty',
                'Books' => 'Bücher',
                'Classical' => 'Klassik',
                'Computers' => 'Computer & Zubehör',
                'DigitalMusic' => 'Musik-Downloads',
                'Electronics' => 'Elektronik & Foto',
                'EverythingElse' => 'Sonstiges',
                'Fashion' => 'Fashion',
                'ForeignBooks' => 'Bücher (Fremdsprachig)',
                'GardenAndOutdoor' => 'Garten',
                'GiftCards' => 'Geschenkgutscheine',
                'GroceryAndGourmetFood' => 'Lebensmittel & Getränke',
                'Handmade' => 'Handmade',
                'HealthPersonalCare' => 'Drogerie & Körperpflege',
                'HomeAndKitchen' => 'Küche, Haushalt & Wohnen',
                'Industrial' => 'Gewerbe, Industrie & Wissenschaft',
                'Jewelry' => 'Schmuck',
                'KindleStore' => 'Kindle-Shop',
                'Lighting' => 'Beleuchtung',
                'Luggage' => 'Koffer, Rucksäcke & Taschen',
                'LuxuryBeauty' => 'Luxury Beauty',
                'Magazines' => 'Zeitschriften',
                'MobileApps' => 'Apps & Spiele',
                'MoviesAndTV' => 'DVD & Blu-ray',
                'Music' => 'Musik-CDs & Vinyl',
                'MusicalInstruments' => 'Musikinstrumente & DJ-Equipment',
                'OfficeProducts' => 'Bürobedarf & Schreibwaren',
                'PetSupplies' => 'Haustier',
                'Photo' => 'Kamera & Foto',
                'Shoes' => 'Schuhe & Handtaschen',
                'Software' => 'Software',
                'SportsAndOutdoors' => 'Sport & Freizeit',
                'ToolsAndHomeImprovement' => 'Baumarkt',
                'ToysAndGames' => 'Spielzeug',
                'VHS' => 'VHS',
                'VideoGames' => 'Games',
                'Watches' => 'Uhren',
            ),
            'in' => array(
                'All' => 'All Categories',
                'Apparel' => 'Clothing & Accessories',
                'Appliances' => 'Appliances',
                'Automotive' => 'Car & Motorbike',
                'Beauty' => 'Beauty',
                'Books' => 'Books',
                'Collectibles' => 'Collectibles',
                'Computers' => 'Computers & Accessories',
                'Electronics' => 'Electronics',
                'EverythingElse' => 'Everything Else',
                'Fashion' => 'Amazon Fashion',
                'Furniture' => 'Furniture',
                'GardenAndOutdoor' => 'Garden & Outdoors',
                'GiftCards' => 'Gift Cards',
                'GroceryAndGourmetFood' => 'Grocery & Gourmet Foods',
                'HealthPersonalCare' => 'Health & Personal Care',
                'HomeAndKitchen' => 'Home & Kitchen',
                'Industrial' => 'Industrial & Scientific',
                'Jewelry' => 'Jewellery',
                'KindleStore' => 'Kindle Store',
                'Luggage' => 'Luggage & Bags',
                'LuxuryBeauty' => 'Luxury Beauty',
                'MobileApps' => 'Apps & Games',
                'MoviesAndTV' => 'Movies & TV Shows',
                'Music' => 'Music',
                'MusicalInstruments' => 'Musical Instruments',
                'OfficeProducts' => 'Office Products',
                'PetSupplies' => 'Pet Supplies',
                'Software' => 'Software',
                'SportsAndOutdoors' => 'Sports, Fitness & Outdoors',
                'ToolsAndHomeImprovement' => 'Tools & Home Improvement',
                'ToysAndGames' => 'Toys & Games',
                'VideoGames' => 'Video Games',
                'Watches' => 'Watches',
            ),
            'it' => array(
                'All' => 'Tutte le categorie',
                'Apparel' => 'Abbigliamento',
                'Appliances' => 'Grandi elettrodomestici',
                'Automotive' => 'Auto e Moto',
                'Baby' => 'Prima infanzia',
                'Beauty' => 'Bellezza',
                'Books' => 'Libri',
                'Computers' => 'Informatica',
                'DigitalMusic' => 'Musica Digitale',
                'Electronics' => 'Elettronica',
                'EverythingElse' => 'Altro',
                'Fashion' => 'Moda',
                'ForeignBooks' => 'Libri in altre lingue',
                'GardenAndOutdoor' => 'Giardino e giardinaggio',
                'GiftCards' => 'Buoni Regalo',
                'GroceryAndGourmetFood' => 'Alimentari e cura della casa',
                'Handmade' => 'Handmade',
                'HealthPersonalCare' => 'Salute e cura della persona',
                'HomeAndKitchen' => 'Casa e cucina',
                'Industrial' => 'Industria e Scienza',
                'Jewelry' => 'Gioielli',
                'KindleStore' => 'Kindle Store',
                'Lighting' => 'Illuminazione',
                'Luggage' => 'Valigeria',
                'MobileApps' => 'App e Giochi',
                'MoviesAndTV' => 'Film e TV',
                'Music' => 'CD e Vinili',
                'MusicalInstruments' => 'Strumenti musicali e DJ',
                'OfficeProducts' => 'Cancelleria e prodotti per ufficio',
                'PetSupplies' => 'Prodotti per animali domestici',
                'Shoes' => 'Scarpe e borse',
                'Software' => 'Software',
                'SportsAndOutdoors' => 'Sport e tempo libero',
                'ToolsAndHomeImprovement' => 'Fai da te',
                'ToysAndGames' => 'Giochi e giocattoli',
                'VideoGames' => 'Videogiochi',
                'Watches' => 'Orologi',
            ),
            'jp' => array(
                'All' => 'All Departments',
                'AmazonVideo' => 'Prime Video',
                'Apparel' => 'Clothing & Accessories',
                'Appliances' => 'Large Appliances',
                'Automotive' => 'Car & Bike Products',
                'Baby' => 'Baby & Maternity',
                'Beauty' => 'Beauty',
                'Books' => 'Japanese Books',
                'Computers' => 'Computers & Accessories',
                'CreditCards' => 'Credit Cards',
                'DigitalMusic' => 'Digital Music',
                'Electronics' => 'Electronics & Cameras',
                'EverythingElse' => 'Everything Else',
                'Fashion' => 'Fashion',
                'FashionBaby' => 'Kids & Baby',
                'FashionMen' => 'Men',
                'FashionWomen' => 'Women',
                'ForeignBooks' => 'English Books',
                'GiftCards' => 'Gift Cards',
                'GroceryAndGourmetFood' => 'Food & Beverage',
                'HealthPersonalCare' => 'Health & Personal Care',
                'Hobbies' => 'Hobby',
                'HomeAndKitchen' => 'Kitchen & Housewares',
                'Industrial' => 'Industrial & Scientific',
                'Jewelry' => 'Jewelry',
                'KindleStore' => 'Kindle Store',
                'MobileApps' => 'Apps & Games',
                'MoviesAndTV' => 'Movies & TV',
                'Music' => 'Music',
                'MusicalInstruments' => 'Musical Instruments',
                'OfficeProducts' => 'Stationery and Office Products',
                'PetSupplies' => 'Pet Supplies',
                'Shoes' => 'Shoes & Bags',
                'Software' => 'Software',
                'SportsAndOutdoors' => 'Sports',
                'ToolsAndHomeImprovement' => 'DIY, Tools & Garden',
                'Toys' => 'Toys',
                'VideoGames' => 'Computer & Video Games',
                'Watches' => 'Watches',
            ),
            'mx' => array(
                'All' => 'Todos los departamentos',
                'Automotive' => 'Auto',
                'Baby' => 'Bebé',
                'Books' => 'Libros',
                'Electronics' => 'Electrónicos',
                'Fashion' => 'Ropa, Zapatos y Accesorios',
                'FashionBaby' => 'Ropa, Zapatos y Accesorios Bebé',
                'FashionBoys' => 'Ropa, Zapatos y Accesorios Niños',
                'FashionGirls' => 'Ropa, Zapatos y Accesorios Niñas',
                'FashionMen' => 'Ropa, Zapatos y Accesorios Niñas',
                'FashionWomen' => 'Ropa, Zapatos y Accesorios Mujeres',
                'GroceryAndGourmetFood' => 'Alimentos y Bebidas',
                'Handmade' => 'Productos Handmade',
                'HealthPersonalCare' => 'Salud, Belleza y Cuidado Personal',
                'HomeAndKitchen' => 'Hogar y Cocina',
                'IndustrialAndScientific' => 'Industria y ciencia',
                'KindleStore' => 'Tienda Kindle',
                'MoviesAndTV' => 'Películas y Series de TV',
                'Music' => 'Música',
                'MusicalInstruments' => 'Instrumentos musicales',
                'OfficeProducts' => 'Oficina y Papelería',
                'PetSupplies' => 'Mascotas',
                'Software' => 'Software',
                'SportsAndOutdoors' => 'Deportes y Aire Libre',
                'ToolsAndHomeImprovement' => 'Herramientas y Mejoras del Hogar',
                'ToysAndGames' => 'Juegos y juguetes',
                'VideoGames' => 'Videojuegos',
                'Watches' => 'Relojes',
            ),
            'nl' => array(
                'All' => 'Alle afdelingen',
                'Automotive' => 'Auto en motor',
                'Baby' => 'Babyproducten',
                'Beauty' => 'Beauty en persoonlijke verzorging',
                'Books' => 'Boeken',
                'Electronics' => 'Elektronica',
                'EverythingElse' => 'Overig',
                'Fashion' => 'Kleding, schoenen en sieraden',
                'GardenAndOutdoor' => 'Tuin, terras en gazon',
                'GiftCards' => 'Cadeaubonnen',
                'GroceryAndGourmetFood' => 'Levensmiddelen',
                'HealthPersonalCare' => 'Gezondheid en persoonlijke verzorging',
                'HomeAndKitchen' => 'Wonen en keuken',
                'Industrial' => 'Zakelijk, industrie en wetenschap',
                'KindleStore' => 'Kindle Store',
                'MoviesAndTV' => 'Films en tv',
                'Music' => 'Cd\'s en lp\'s',
                'MusicalInstruments' => 'Muziekinstrumenten',
                'OfficeProducts' => 'Kantoorproducten',
                'PetSupplies' => 'Huisdierbenodigdheden',
                'Software' => 'Software',
                'SportsAndOutdoors' => 'Sport en outdoor',
                'ToolsAndHomeImprovement' => 'Klussen en gereedschap',
                'ToysAndGames' => 'Speelgoed en spellen',
                'VideoGames' => 'Videogames',
            ),
            'sa' => array(
                'All' => 'All Categories',
                'ArtsAndCrafts' => 'Arts, Crafts & Sewing',
                'Automotive' => 'Automotive Parts & Accessories',
                'Baby' => 'Baby',
                'Beauty' => 'Beauty & Personal Care',
                'Books' => 'Books',
                'Computers' => 'Computer & Accessories',
                'Electronics' => 'Electronics',
                'Fashion' => 'Clothing, Shoes & Jewelry',
                'GardenAndOutdoor' => 'Home & Garden',
                'GiftCards' => 'Gift Cards',
                'GroceryAndGourmetFood' => 'Grocery & Gourmet Food',
                'HealthPersonalCare' => 'Health, Household & Baby Care',
                'HomeAndKitchen' => 'Kitchen & Dining',
                'Industrial' => 'Industrial & Scientific',
                'KindleStore' => 'Kindle Store',
                'Miscellaneous' => 'Everything Else',
                'MoviesAndTV' => 'MoviesAndTV',
                'Music' => 'CDs & Vinyl',
                'MusicalInstruments ' => 'Musical Instruments',
                'OfficeProducts' => 'Office Productsd',
                'PetSupplies' => 'Pet Supplies',
                'Software' => 'Software',
                'SportsAndOutdoors' => 'Sports',
                'ToolsAndHomeImprovement' => 'Tools & Home Improvement',
                'ToysAndGames' => 'Toys & Games',
                'VideoGames' => 'Video Games',
            ),
            'sg' => array(
                'All' => 'All Departments',
                'Automotive' => 'Automotive',
                'Baby' => 'Baby',
                'Beauty' => 'Beauty & Personal Care',
                'Computers' => 'Computers',
                'Electronics' => 'Electronics',
                'GroceryAndGourmetFood' => 'Grocery',
                'HealthPersonalCare' => 'HealthPersonalCare',
                'HomeAndKitchen' => 'Home, Kitchen & Dining',
                'OfficeProducts' => 'Office Products',
                'PetSupplies' => 'Pet Supplies',
                'SportsAndOutdoors' => 'Sports & Outdoors',
                'ToolsAndHomeImprovement' => 'Tools & Home Improvement',
                'ToysAndGames' => 'Toys & Games',
                'VideoGames' => 'Video Games',
            ),
            'es' => array(
                'All' => 'Todos los departamentos',
                'Apparel' => 'Ropa y accesorios',
                'Appliances' => 'Appliances',
                'Automotive' => 'Coche y moto',
                'Baby' => 'Bebé',
                'Beauty' => 'Belleza',
                'Books' => 'Libros',
                'Computers' => 'Informática',
                'DigitalMusic' => 'Música Digital',
                'Electronics' => 'Electrónica',
                'EverythingElse' => 'Otros Productos',
                'Fashion' => 'Moda',
                'ForeignBooks' => 'Libros en idiomas extranjeros',
                'GardenAndOutdoor' => 'Jardín',
                'GiftCards' => 'Cheques regalo',
                'GroceryAndGourmetFood' => 'Alimentación y bebidas',
                'Handmade' => 'Handmade',
                'HealthPersonalCare' => 'Salud y cuidado personal',
                'HomeAndKitchen' => 'Hogar y cocina',
                'Industrial' => 'Industria y ciencia',
                'Jewelry' => 'Joyería',
                'KindleStore' => 'Tienda Kindle',
                'Lighting' => 'Iluminación',
                'Luggage' => 'Equipaje',
                'MobileApps' => 'Appstore para Android',
                'MoviesAndTV' => 'Películas y TV',
                'Music' => 'Música: CDs y vinilos',
                'MusicalInstruments ' => 'Instrumentos musicales',
                'OfficeProducts' => 'Oficina y papelería',
                'PetSupplies' => 'Productos para mascotas',
                'Shoes' => 'Zapatos y complementos',
                'Software' => 'Softwares',
                'SportsAndOutdoors' => 'Deportes y aire libre',
                'ToolsAndHomeImprovement' => 'Bricolaje y herramientas',
                'ToysAndGames' => 'Juguetes y juegos',
                'Vehicles' => 'Coche - renting',
                'VideoGames' => 'Videojuegos',
                'Watches' => 'Relojes',
            ),
            'com.tr' => array(
                'All' => 'Tüm Kategoriler',
                'Baby' => 'Bebek',
                'Books' => 'Kitaplar',
                'Computers' => 'Bilgisayarlar',
                'Electronics' => 'Elektronik',
                'EverythingElse' => 'Diğer Her Şey',
                'Fashion' => 'Moda',
                'HomeAndKitchen' => 'Ev ve Mutfak',
                'OfficeProducts' => 'Ofis Ürünleri',
                'SportsAndOutdoors' => 'Spor',
                'ToolsAndHomeImprovement' => 'Yapı Market',
                'ToysAndGames' => 'Oyuncaklar ve Oyunlar',
                'VideoGames' => 'PC ve Video Oyunları',
            ),
            'ae' => array(
                'All' => 'All Departments',
                'Appliances' => 'Appliances',
                'ArtsAndCrafts' => 'Arts, Crafts & Sewing',
                'Automotive' => 'Automotive Parts & Accessories',
                'Baby' => 'Baby',
                'Beauty ' => 'Beauty & Personal Care',
                'Books' => 'Books',
                'Computers' => 'Computers',
                'Electronics' => 'Electronics',
                'EverythingElse' => 'Everything Else',
                'Fashion' => 'Clothing, Shoes & Jewelry',
                'GardenAndOutdoor' => 'Home & Garden',
                'GroceryAndGourmetFood' => 'Grocery & Gourmet Food',
                'HealthPersonalCare' => 'Health, Household & Baby Care',
                'HomeAndKitchen' => 'Home & Kitchen',
                'Industrial' => 'Industrial & Scientific',
                'Lighting' => 'Lighting',
                'MusicalInstruments' => 'Musical Instruments',
                'OfficeProducts' => 'Office Products',
                'PetSupplies' => 'Pet Supplies',
                'Software' => 'Software',
                'SportsAndOutdoors' => 'Sports',
                'ToolsAndHomeImprovement' => 'Tools & Home Improvement',
                'ToysAndGames' => 'Toys & Games',
                'VideoGames' => 'Video Games',
            ),
            'co.uk' => array(
                'All' => 'All Departments',
                'AmazonVideo' => 'Amazon Video',
                'Apparel' => 'Clothing',
                'Appliances' => 'Large Appliances',
                'Automotive' => 'Car & Motorbike',
                'Baby' => 'Baby',
                'Beauty' => 'Beauty',
                'Books' => 'Books',
                'Classical' => 'Classical Music',
                'Computers' => 'Computers & Accessories',
                'DigitalMusic' => 'Digital Music',
                'Electronics' => 'Electronics & Photo',
                'EverythingElse' => 'Everything Else',
                'Fashion' => 'Fashion',
                'GardenAndOutdoor' => 'Garden & Outdoors',
                'GiftCards' => 'Gift Cards',
                'GroceryAndGourmetFood' => 'Grocery',
                'Handmade' => 'Handmade',
                'HealthPersonalCare' => 'Health & Personal Care',
                'HomeAndKitchen' => 'Home & Kitchen',
                'Industrial' => 'Industrial & Scientific',
                'Jewelry' => 'Industrial & Scientific',
                'KindleStore' => 'Kindle Store',
                'Luggage' => 'Luggage',
                'LuxuryBeauty' => 'Luxury Beauty',
                'MobileApps' => 'Apps & Games',
                'MoviesAndTV' => 'DVD & Blu-ray',
                'Music' => 'CDs & Vinyl',
                'MusicalInstruments' => 'Musical Instruments & DJ',
                'OfficeProducts' => 'Stationery & Office SuppliesJ',
                'PetSupplies' => 'Pet Supplies',
                'Shoes' => 'Shoes & Bags',
                'Software' => 'Software',
                'SportsAndOutdoors' => 'Sports & Outdoors',
                'ToolsAndHomeImprovement' => 'DIY & Tools',
                'ToysAndGames' => 'Toys & Games',
                'VHS' => 'VHS',
                'VideoGames' => 'PC & Video Games',
                'Watches' => 'Watches',
            ),
            'com' => array(
                'All' => 'All Departments',
                'AmazonVideo' => 'Prime Video',
                'Apparel' => 'Clothing & Accessories',
                'Appliances' => 'Appliances',
                'ArtsAndCrafts' => 'Arts, Crafts & Sewing',
                'Automotive' => 'Automotive Parts & Accessories',
                'Baby' => 'Baby',
                'Beauty' => 'Beauty & Personal Care',
                'Books' => 'Books',
                'Classical' => 'Classical',
                'Collectibles' => 'Collectibles & Fine Art',
                'Computers' => 'Computers',
                'DigitalMusic' => 'Digital Music',
                'DigitalEducationalResources' => 'Digital Educational Resources',
                'Electronics' => 'Electronics',
                'EverythingElse' => 'Everything Else',
                'Fashion' => 'Clothing, Shoes & Jewelry',
                'FashionBaby' => 'Clothing, Shoes & Jewelry Baby',
                'FashionBoys' => 'Clothing, Shoes & Jewelry Boys',
                'FashionGirls' => 'Clothing, Shoes & Jewelry Girls',
                'FashionMen' => 'Clothing, Shoes & Jewelry Men',
                'FashionWomen' => 'Clothing, Shoes & Jewelry Women',
                'GardenAndOutdoor' => 'Garden & Outdoor',
                'GiftCards' => 'Gift Cards',
                'GroceryAndGourmetFood' => 'Grocery & Gourmet Food',
                'Handmade' => 'Handmade',
                'HealthPersonalCare' => 'Health, Household & Baby Care',
                'HomeAndKitchen' => 'Home & Kitchen',
                'Industrial' => 'Industrial & Scientific',
                'Jewelry' => 'Jewelry',
                'KindleStore' => 'Kindle Store',
                'LocalServices' => 'Home & Business Services',
                'Luggage' => 'Luggage & Travel Gear',
                'LuxuryBeauty' => 'Luxury Beauty',
                'Magazines  ' => 'Magazine Subscriptions',
                'MobileAndAccessories' => 'Cell Phones & Accessories',
                'MobileApps' => 'Apps & Gamess',
                'MoviesAndTV' => 'Movies & TV',
                'Music' => 'CDs & Vinyl',
                'MusicalInstruments' => 'Musical Instruments',
                'OfficeProducts' => 'Office Products',
                'PetSupplies' => 'Pet Supplies',
                'Photo' => 'Camera & Photo',
                'Shoes' => 'Shoes',
                'Software' => 'Software',
                'SportsAndOutdoors' => 'Sports & Outdoors',
                'ToolsAndHomeImprovement' => 'Tools & Home Improvement',
                'ToysAndGames' => 'Toys & Games',
                'VHS' => 'VHS',
                'VideoGames' => 'Video Games',
                'Watches' => 'Watches',
            ),
            'pl' => array(
                'All' => 'All Departments',
                'AmazonVideo' => 'Prime Video',
                'Apparel' => 'Clothing & Accessories',
                'Appliances' => 'Appliances',
                'ArtsAndCrafts' => 'Arts, Crafts & Sewing',
                'Automotive' => 'Automotive Parts & Accessories',
                'Baby' => 'Baby',
                'Beauty' => 'Beauty & Personal Care',
                'Books' => 'Books',
                'Classical' => 'Classical',
                'Collectibles' => 'Collectibles & Fine Art',
                'Computers' => 'Computers',
                'DigitalMusic' => 'Digital Music',
                'DigitalEducationalResources' => 'Digital Educational Resources',
                'Electronics' => 'Electronics',
                'EverythingElse' => 'Everything Else',
                'Fashion' => 'Clothing, Shoes & Jewelry',
                'FashionBaby' => 'Clothing, Shoes & Jewelry Baby',
                'FashionBoys' => 'Clothing, Shoes & Jewelry Boys',
                'FashionGirls' => 'Clothing, Shoes & Jewelry Girls',
                'FashionMen' => 'Clothing, Shoes & Jewelry Men',
                'FashionWomen' => 'Clothing, Shoes & Jewelry Women',
                'GardenAndOutdoor' => 'Garden & Outdoor',
                'GiftCards' => 'Gift Cards',
                'GroceryAndGourmetFood' => 'Grocery & Gourmet Food',
                'Handmade' => 'Handmade',
                'HealthPersonalCare' => 'Health, Household & Baby Care',
                'HomeAndKitchen' => 'Home & Kitchen',
                'Industrial' => 'Industrial & Scientific',
                'Jewelry' => 'Jewelry',
                'KindleStore' => 'Kindle Store',
                'LocalServices' => 'Home & Business Services',
                'Luggage' => 'Luggage & Travel Gear',
                'LuxuryBeauty' => 'Luxury Beauty',
                'Magazines  ' => 'Magazine Subscriptions',
                'MobileAndAccessories' => 'Cell Phones & Accessories',
                'MobileApps' => 'Apps & Gamess',
                'MoviesAndTV' => 'Movies & TV',
                'Music' => 'CDs & Vinyl',
                'MusicalInstruments' => 'Musical Instruments',
                'OfficeProducts' => 'Office Products',
                'PetSupplies' => 'Pet Supplies',
                'Photo' => 'Camera & Photo',
                'Shoes' => 'Shoes',
                'Software' => 'Software',
                'SportsAndOutdoors' => 'Sports & Outdoors',
                'ToolsAndHomeImprovement' => 'Tools & Home Improvement',
                'ToysAndGames' => 'Toys & Games',
                'VHS' => 'VHS',
                'VideoGames' => 'Video Games',
                'Watches' => 'Watches',
            ),
        );
        return $cat;
    }
    /**
     * Add products search
     */
    function wca_add_products_search_count()
    {
        $count = get_option('wca_products_search_count');
        $count = $count + 1;
        update_option('wca_products_search_count', $count);
    }
    /**
     * WooCommerce plugin missing notices.
     */
    function ams_woocommerce_missing()
    {
        $massing_text = esc_html__('Affiliate Management System - WooCommerce Amazon requires WooCommerce to be installed and active. You can download', 'ams-wc-amazon');
        $translators_text = sprintf(
            '<div class="error"><p><strong>%s <a href="https://wordpress.org/plugins/woocommerce/" target="_blank">%s</a> here.</strong></p></div>',
            esc_html($massing_text),
            esc_html__('WooCommerce', 'ams-wc-amazon')
        );
        echo wp_kses_post($translators_text);
    }
    /**
     * License not activation notices
     */
    function ams_plugin_license_active_massage()
    {
        $text = esc_html__('Affiliate Management System - WooCommerce Amazon plugin license not activated Please activate the plugin\'s license', 'ams-wc-amazon');
        $contain = sprintf('<div class="error"><p><strong>%s</strong></p></div>', esc_html($text));
        echo wp_kses_post($contain);
    }
    /**
     * License status check
     */
    function ams_plugin_license_status()
    {
        $status = get_option('ams_activated_status');
        if (strtolower($status) === strtolower('success')) {
            return true;
        } else {
            return false;
        }
    }
    /**
     *
     */
    if (!function_exists('ams_clean')) {
        function ams_clean($var)
        {
            if (is_array($var)) {
                return array_map('ams_clean', $var);
            } else {
                return is_scalar($var) ? sanitize_text_field($var) : $var;
            }
        }
    }
    /**
     * Create a product variation for a defined variable product ID.
     *
     * @since 3.0.0
     * @param int   $product_id | Post ID of the product parent variable product.
     * @param array $variation_data | The data to insert in the product.
     */
    function create_product_variation($product_id, $variation_data)
    {
        // Get the Variable product object (parent)
        $product = wc_get_product($product_id);
        $variation_post = array(
            'post_title' => $product->get_name(),
            'post_name' => 'product-' . $product_id . '-variation',
            'post_status' => 'publish',
            'post_parent' => $product_id,
            'post_type' => 'product_variation',
            'guid' => $product->get_permalink(),
        );
        // Creating the product variation
        $variation_id = wp_insert_post($variation_post);
        // Get an instance of the WC_Product_Variation object
        $variation = new WC_Product_Variation($variation_id);
        // Iterating through the variations attributes
        foreach ($variation_data['attributes'] as $attribute => $term_name) {
            $taxonomy = 'pa_' . $attribute; // The attribute taxonomy
            // If taxonomy doesn't exists we create it (Thanks to Carl F. Corneil)
            if (!taxonomy_exists($taxonomy)) {
                register_taxonomy(
                    $taxonomy,
                    'product_variation',
                    array(
                        'hierarchical' => false,
                        'label' => ucfirst($attribute),
                        'query_var' => true,
                        'rewrite' => array('slug' => sanitize_title($attribute)), // The base slug
                    )
                );
            }
            // Check if the Term name exist and if not we create it.
            if (!term_exists($term_name, $taxonomy)) {
                wp_insert_term($term_name, $taxonomy);
            }
            // Create the term
            $term_slug = get_term_by('name', $term_name, $taxonomy)->slug; // Get the term slug
            // Get the post Terms names from the parent variable product.
            $post_term_names = wp_get_post_terms($product_id, $taxonomy, array('fields' => 'names'));
            // Check if the post term exist and if not we set it in the parent variable product.
            if (!in_array($term_name, $post_term_names)) {
                wp_set_post_terms($product_id, $term_name, $taxonomy, true);
            }
            // Set/save the attribute data in the product variation
            update_post_meta($variation_id, 'attribute_' . $taxonomy, $term_slug);
        }
        ## Set/save all other data
        // SKU
        if (!empty($variation_data['sku'])) {
            $variation->set_sku($variation_data['sku']);
        }
        // Prices
        if (empty($variation_data['sale_price'])) {
            $variation->set_price($variation_data['regular_price']);
        } else {
            $variation->set_price($variation_data['sale_price']);
            $variation->set_sale_price($variation_data['sale_price']);
        }
        $variation->set_regular_price($variation_data['regular_price']);
        // Stock
        if (!empty($variation_data['stock_qty'])) {
            $variation->set_stock_quantity($variation_data['stock_qty']);
            $variation->set_manage_stock(true);
            $variation->set_stock_status('');
        } else {
            $variation->set_manage_stock(false);
        }
        $variation->set_weight(''); // weight (reseting)
        $variation->save(); // Save the data
    }

    /**
     * Multiple update cron window - NO API
     */
    add_action('wp_ajax_ams_product_availability', 'ams_product_availability');
    function ams_product_availability()
    {
        $__log_file = plugin_dir_path(__FILE__) . 'import_verification.log';
        @file_put_contents($__log_file, '[' . date('Y-m-d H:i:s') . '] Start: func=ams_product_availability' . "\n", FILE_APPEND);

        try {
            global $wpdb;

            // Check License
            if (ams_plugin_license_status() === false) {
                echo "<script>console.log('Plugin license not activated');</script>";
                $license = sprintf(esc_html__('Activate License!','ams-wc-amazon'));
                echo wp_kses_post($license);
                wp_die();
            }

            // If Added in CRON            
            $product_sku_cron = get_option('product_sku_cron', true);
            $product_tags_cron = get_option('product_tags_cron', true);
            $product_name_cron = get_option('product_name_cron', true);
            $product_price_cron = get_option('product_price_cron', true);
            $product_image_cron = get_option('product_image_cron', true);
            $product_review_cron = get_option('product_review_cron', true);
            $enable_amazon_review = get_option('enable_amazon_review', true);
            $product_variants_cron = get_option('product_variants_cron', true);
            $product_variant_image_cron = get_option('product_variant_image_cron', true);
            $product_category_cron = get_option('product_category_cron', true);
            $product_description_cron = get_option('product_description_cron', true);
            $product_out_of_stock_cron = get_option('product_out_of_stock_cron', true);

            if ( isset($_POST['data']) && $_POST['data'] != '' ) {
                $id_asin = $_POST['data'];
            } else {

                $asins = ams_get_all_products_info();
                $id_asin = array_combine($asins['id'], $asins['asin']);
                $products_url = [];
                foreach ($asins['product_id'] as $key => $value) {
                    $products_url[$key] = $value['url'];
                }
            }
            foreach ($id_asin as $id => $asin) {

                // Skip trashed products
                $post_status = get_post_status($id);
                if ($post_status === 'trash' || $post_status === false) {
                    continue;
                }

                if (isset($_POST['product_url']) && !empty($_POST['product_url'])) {
                    $url = $_POST['product_url'];
                } else if (isset($products_url) && isset($products_url[$id]) && !empty($products_url[$id])) {
                    $url = $products_url[$id];
                } else {
                    $url = sprintf('https://www.amazon.%s/dp/%s', get_option('ams_amazon_country'), $asin);
                }



                // Check import method and use appropriate update logic (same as manual button)
                $import_method = get_post_meta($id, '_import_method', true);

                
                if ('1' == $import_method) {
                    // Use Amazon API update (simulate manual button behavior)

                    
                    // Simulate the same API call that manual button makes
                    $_POST['post_id'] = $id;
                    $_POST['product_url'] = $url;
                    $_POST['nonce'] = wp_create_nonce('product_update_request');
                    $_POST['is_cron'] = 1; // Flag to indicate this is from cron
                    
                    if (!class_exists('simple_html_dom')) {
                        require_once __DIR__ . '/Admin/lib/simplehtmldom/simple_html_dom.php';
                    }
                    
                    // Create ImportProducts instance and call the same method
                    $product_import = new \Amazon\Affiliate\Admin\ImportProducts();
                    
                    // Capture output from the API update
                    ob_start();
                    try {
                        $sku = $product_import->getSkuFromUrl($url);

                        
                        // Call the same API update method used by manual button
                        $response = $product_import->ams_product_api_update_cron($id, $sku);
                        
                        if ($response) {
                            @file_put_contents($__log_file, '[' . date('Y-m-d H:i:s') . '] Success: func=ams_product_availability POST_ID=' . $id . '; ASIN=' . $asin . '; method=API; status=updated' . "\n", FILE_APPEND);
                            echo esc_html__('API Product updated Successfully!', 'ams-wc-amazon') . '<a href="' . esc_url($url) . '" target="_blank" style="color: white;">' . esc_html(mb_strimwidth($url, 0, 35, '...')) . '</a>';
                        } else {
                            @file_put_contents($__log_file, '[' . date('Y-m-d H:i:s') . '] Failed: func=ams_product_availability POST_ID=' . $id . '; ASIN=' . $asin . '; method=API; reason=api_update_failed' . "\n", FILE_APPEND);
                            echo 'Failed to update API product';
                        }
                    } catch (Exception $e) {
                        @file_put_contents($__log_file, '[' . date('Y-m-d H:i:s') . '] Failed: func=ams_product_availability POST_ID=' . $id . '; ASIN=' . $asin . '; method=API; reason=exception; error=' . $e->getMessage() . "\n", FILE_APPEND);
                        echo 'API update failed: ' . $e->getMessage();
                    }
                    $output = ob_get_clean();
                    echo $output;
                    
                    // Update cron metadata
                    update_post_meta($id, 'ams_last_cron_update', date('Y-m-d H:i:s'));
                    update_post_meta($id, 'ams_last_cron_status', isset($response) && $response ? 1 : 0);
                    update_post_meta($id, '_ams_product_url', $url);
                    
                    clean_completed_woocommerce_actions();
                    clean_all_actionscheduler_logs();
                    
                    continue; // Skip to next product
                }
                
                // For non-API products (method 2 & 3), use existing scraping logic


                if (!class_exists('simple_html_dom')) {
                    require_once __DIR__ . '/Admin/lib/simplehtmldom/simple_html_dom.php';
                }
                $product_import = new \Amazon\Affiliate\Admin\ProductsSearchWithoutApi();

                // Get product data first time
                $product_url = sanitize_text_field($url);
                $user_agent = $product_import->user_agent();
                //echo '<pre>'; dd( $product_url ); echo '</pre>'; exit;

                $response_body = fetchAndValidateProductData($product_url, $user_agent);

                if (is_string($response_body) && strlen($response_body)) {

                    if (!class_exists('simple_html_dom')) {
                        require_once AMS_PLUGIN_PATH . '/includes/Admin/lib/simplehtmldom/simple_html_dom.php';
                    }

                    $html = new \simple_html_dom();
                    $html->load($response_body);

                    //echo '<pre>'; dd( 'Product update started...' ); echo '</pre>'; exit;

                    // Check for broken page
                    $message = check_for_broken_page($response_body, $html);
                    if ($message !== null) {
                        echo wp_kses_post($message);

                        wp_die();
                    }

                    // Get Parent ASIN from html
                    $parentSku = $product_import->getParentSkuFromHtml($html);
                    //echo 'here <pre>'; dd( $parentSku ); echo '</pre>'; exit;

                    if (!empty($parentSku)) {

                    } else {

                    }

                    // Check if product title exists, else abort
                    $productTitle = extractAmazonProductTitle($html);
                    if ($productTitle === false) {

                        wp_die();
                    }
                    $title = html_entity_decode($productTitle, ENT_QUOTES | ENT_HTML5, 'UTF-8');
                    //echo '<pre>'; dd( $title ); echo '</pre>';

                    // Get Product Category
                    $product_category = $product_import->syncAndGetCategory($html);
                    //echo '<pre>'; dd( $product_category ); echo '</pre>';

                    // Get Product Content
                    $content = $product_import->fetchContentFromHtml($html);
                    //echo '<pre>'; dd( $content ); echo '</pre>';

                    // Get Product Short Description
                    $short_description = $product_import->fetchShortDescriptionFromHtml($html);
                    //echo '<pre>'; dd( $short_description ); echo '</pre>';

                    // Get Product Additional Content
                    $additional_description = $product_import->fetchAdditionalContentFromHtml($html);
                    //echo '<pre>'; dd( $additional_description ); echo '</pre>';

                    // Get Product gallery
                    $gallery = $product_import->fetchImagesFromHtml($html);
                    $image = array_shift($gallery);

                    $product = wc_get_product($id);
                    $post_id = $id;
                    //print_r('Data: ' . $post_id);

                    clean_completed_woocommerce_actions();
                    clean_all_actionscheduler_logs();

                    ////Start process before simple/variable

                    // Update Product SKU
                    if ($product_sku_cron) {
                        $asinElements = $html->find('#ASIN');
                        $asin = !empty($asinElements) ? $asinElements[0]->value : '';

                        if (empty($asin)) {
                            $elements = $html->find('input[name="ASIN.0"]');
                            $asin = !empty($elements) ? $elements[0]->value : '';
                        }

                        if (empty($asin)) {
                            $asin = $this->getSkuFromUrl($product_url);
                        }
                        update_post_meta($post_id, '_sku', $asin);
                    }

                    // Update Product title
                    if ($product_name_cron) {
                        $product_update = array(
                            'ID' => $post_id,
                            'post_title' => $title,
                            'post_name' => sanitize_title($title)
                        );
                        wp_update_post($product_update);

                    }

                    // Update Product main content
                    if ($product_description_cron) {
                        if (!empty(trim($content))) {
                            $product_update = array(
                                'ID' => $post_id,
                                'post_content' => $content
                            );
                            wp_update_post($product_update);

                        }
                    }

                    // Update Product Category
                    if ($product_category_cron) {
                        $product_category = $product_import->syncAndGetCategory($html);
                        if (!empty($product_category)) {
                            wp_set_object_terms($post_id, $product_category, 'product_cat');

                        }
                    }

                    // Find the brand name
                    $brandElement = $html->find('a#bylineInfo', 0) 
                        ?: $html->find('div#bylineInfo_feature_div', 0) 
                        ?: $html->find('div#bondByLine_feature_div', 0);
                        
                    if ($brandElement) {
                        // Extract the raw brand text
                        $rawBrandName = trim($brandElement->plaintext);

                        // Clean up the brand name by removing unnecessary parts like "Visit the" and "Store"
                        $brandName = str_replace(array('Visit the', 'Store'), '', $rawBrandName);

                        // Trim any extra spaces
                        $brandName = trim($brandName);



                        // Check if the brand exists in the 'product_brand' taxonomy
                        $brandTerm = term_exists($brandName, 'product_brand');

                        if (!$brandTerm) {
                            // If the brand doesn't exist, create it
                            $brandTerm = wp_insert_term($brandName, 'product_brand');
                        }

                        if (is_wp_error($brandTerm)) {

                        } else {
                            // Get the term ID
                            $brandTermId = isset($brandTerm['term_id']) ? $brandTerm['term_id'] : $brandTerm;

                            // Assuming the product is represented by post_id (WooCommerce product post ID)
                            $productId = $post_id;  // Replace with your actual product post_id variable

                            // Assign the brand to the product
                            wp_set_object_terms($productId, intval($brandTermId), 'product_brand');

                            // Optional: You can also save the brand as custom meta if needed
                            update_post_meta($productId, '_product_brand', $brandName);


                        }
                    } else {

                    }
                    // Find the brand name


                    // Update the GTIN, UPC, EAN, or ISBN code
                    $upcElement = $html->find('div#productDetails_expanderTables_depthLeftSections', 0);

                    if ($upcElement) {
                        $upcCode = ''; // Initialize variable

                        // Iterate through table rows to find GTIN, UPC, EAN, or ISBN
                        foreach ($upcElement->find('table.prodDetTable tr') as $row) {
                            $header = $row->find('th', 0); // Get the header cell
                            $value = $row->find('td', 0); // Get the value cell

                            if ($header && $value) {
                                $headerText = trim($header->plaintext);
                                $valueText = trim($value->plaintext);

                                // Check for GTIN, UPC, EAN, or ISBN
                                if (stripos($headerText, 'UPC') !== false || stripos($headerText, 'GTIN') !== false || stripos($headerText, 'EAN') !== false || stripos($headerText, 'ISBN') !== false) {
                                    $upcCode = $valueText; // Extract the value
                                    break; // Exit loop once found
                                }
                            }
                        }

                        if (!empty($upcCode)) {
                            // Save the value to the default WooCommerce GTIN/UPC/EAN/ISBN fields
                            update_post_meta($post_id, '_gtin', $upcCode); // GTIN field
                            update_post_meta($post_id, '_upc', $upcCode);  // UPC field
                            update_post_meta($post_id, '_ean', $upcCode);  // EAN field
                            update_post_meta($post_id, '_isbn', $upcCode); // ISBN field
                        }
                    }
                    // Update the GTIN, UPC, EAN, or ISBN code
            

                    // Check remote amazon images.
                    if($product_image_cron) {
                        // Set product feature image.
                        $gallery = $product_import->fetchImagesFromHtml($html);

                        $image = array_shift($gallery);
                        if( $image ) {
                            // Remove featured image and url.
                            delete_product_images($post_id);
                            reset_product_thumbnail_url($post_id, $flag=0);
                        }
                        
                        if( count($gallery) > 0 ) {
                            // Remove product gallery images and url.
                            delete_product_gallery_images($post_id);
                            reset_product_thumbnail_url($post_id, $flag=1);
                        }
                        
                        if ( 'Yes' === get_option( 'ams_remote_amazon_images' ) ) {
                            // Set featured image url
                            if( $image ) {
                                attach_product_thumbnail_url( $post_id, $image, 0 );
                            }
                            // Set featured image gallary
                            if( count($gallery) > 0 ) {
                                attach_product_thumbnail_url( $post_id, $gallery, 1 );
                            }
                        } else {
                            // Set featured image url
                            if( $image ) {
                                attach_product_thumbnail($post_id, $image, 0);
                            }
                            // Set featured image gallary
                            if( count($gallery) > 0 ) {
                                foreach( $gallery as $image ) {
                                    // Set gallery image.
                                    attach_product_thumbnail( $post_id, $image, 1 );
                                }
                            }
                        }
                    }


                    // Get Product attributes
                    $attributes = $product_import->getProductAttributeFromHtml($html);
                    //echo '<pre>'; dd( $attributes ); echo '</pre>';


                    //Run if variable
                    if (count($attributes) > 0) {
                        $product = wc_get_product($post_id);
                        // print_r('Data: ' . $post_id); exit;

                        if($parentSku) {
                            update_post_meta($post_id, '_sku', $parentSku);
                        }
                        //echo '<pre>'; dd( $parentSku ); echo '</pre>';

                        // Delete product short description
                        $postData = array(
                            'ID' => $post_id,
                            'post_excerpt' => ''
                        );
                        wp_update_post($postData);

                        // Update Additional Description
                        if (!empty($additional_description)) {
                            update_post_meta($post_id, '_ams_additional_information', $additional_description);

                        }

                        $skus = $imported_skus = $product_variations = [];

                        // Get all variants based on the SKUs found
                        $all_skus = $product_import->getSkusFromHtml($html);
                        //echo '<pre>'; print_r($all_skus); echo '</pre>'; exit;

                        $variation_ids = $product_import->getProductFirstVariationFromHtml($html, $parentSku, $product_url, $all_skus);
                        //echo '<pre>'; print_r($variation_ids); echo '</pre>'; exit;

                        // variations to process
                        $variation_limit = get_option('ams_variation_limit', 5);

                        // Update Variants
                        if ($product_variants_cron && count($attributes) > 0) {

                            // Check if there are variation IDs:
                            if(!empty($variation_ids) && count($variation_ids) > 0) {

                                // Apply the dynamic variations to process
                                $variation_ids = array_slice($variation_ids, 0, $variation_limit);

                                // Determine the preferred URL-generation function based solely on product title extraction.
                                $preferred_function = null;
                                $first_variation_processed = false;

                                foreach ($variation_ids as $variation_id) {
                                    if (in_array($variation_id, $imported_skus)) {
                                        continue;
                                    }
                                    array_push($imported_skus, $variation_id);

                                    // For the first variation, decide which function to use based solely on product title.
                                    if (!$first_variation_processed) {
                                        // Try using function 1 with regular curl first
                                        $test_url = generate_amazon_url_1($product_url, $variation_id);
                                        $userAgent = getAlternatingBool();
                                        $test_content = $product_import->getContentUsingCurl($test_url, $userAgent);
                                        $test_html = new \simple_html_dom();
                                        $test_html->load($test_content);
                                        
                                        // If regular curl fails or no attributes found, try scraping
                                        if (!$test_content || count($product_import->getProductAttributeFromHtml($test_html)) == 0) {
                                            $test_content = executeScrapingService($test_url, true);
                                            $test_html = new \simple_html_dom();
                                            $test_html->load($test_content);
                                        }
                                        
                                        // Check if product title exists; if not, choose function 2
                                        $productTitle = extractAmazonProductTitle($test_html);
                                        if ($productTitle === false) {
                                            $preferred_function = 2;
                                            //echo "<pre>Preferred function set to 2 (function 1 failed to extract product title).</pre>";

                                        } else {
                                            $title = html_entity_decode($productTitle, ENT_QUOTES | ENT_HTML5, 'UTF-8');
                                            $preferred_function = 1;
                                            //echo "<pre>Preferred function set to 1 based on product title: {$title}</pre>";

                                        }
                                        $test_html->clear();
                                        $first_variation_processed = true;
                                    }

                                    // Use the preferred function to generate the base URL.
                                    if ($preferred_function === 1) {
                                        $base_url = generate_amazon_url_1($product_url, $variation_id);
                                    } else {
                                        $base_url = generate_amazon_url_2($product_url, $variation_id);
                                    }
                                    
                                    //echo "<pre>Processing Variation ID: {$variation_id} using function {$preferred_function}. Base URL: {$base_url}</pre>";

                                    // First try with regular curl
                                    $userAgent = getAlternatingBool();
                                    $content = $product_import->getContentUsingCurl($base_url, $userAgent);
                                    $loop_html = new \simple_html_dom();
                                    $loop_html->load($content);
                                    
                                    // Check if we need to use scraping service
                                    if (!$content || count($product_import->getProductAttributeFromHtml($loop_html)) == 0) {
                                        $content = executeScrapingService($base_url, true);
                                        $loop_html = new \simple_html_dom();
                                        $loop_html->load($content);
                                    }

                                    // Enhanced 404/not found handling with fallback (same as manual update)
                                    if (!$content || stripos($content, 'page not found') !== false || stripos($content, 'sorry, we couldn\'t find that page') !== false) {

                                        
                                        // Try the alternative URL format (standard ASIN-based URL)
                                        $fallback_url = get_parsed_url($product_url, 'PHP_URL_BASE') . '/dp/' . $variation_id . '/?th=1&psc=1';

                                        
                                        // Try fallback URL
                                        $userAgent = getAlternatingBool();
                                        $fallback_content = $product_import->getContentUsingCurl($fallback_url, $userAgent);
                                        
                                        if ($fallback_content && stripos($fallback_content, 'page not found') === false) {

                                            $content = $fallback_content;
                                            $loop_html = new \simple_html_dom();
                                            $loop_html->load($content);
                                        } else {

                                            
                                            // If both formats fail, use the parent product's data for this variation
                                            $loop_html = $html; // Use main product HTML
                                            $content = $response_body; // Use main product content
                                            

                                        }
                                    }

                                    $productPrice = $product_import->fetchPriceFromHtml($loop_html);

                                    // If no ppd div found, retry twice with proxy
                                    $retry = 2;
                                    while (isset($productPrice['search_area']) && $productPrice['search_area'] == 'entire HTML' && $retry > 0) {
                                        $content = executeScrapingService($base_url, true);
                                        $loop_html = new \simple_html_dom();
                                        $loop_html->load($content);
                                        $productPrice = $product_import->fetchPriceFromHtml($loop_html);
                                        $retry--;
                                    }

                                    $regular_price = isset($productPrice['final_prices']['regular_price'])
                                        ? $productPrice['final_prices']['regular_price']
                                        : (isset($productPrice['regular_price']) ? $productPrice['regular_price'] : 0);
                                    $sale_price = isset($productPrice['final_prices']['sale_price'])
                                        ? $productPrice['final_prices']['sale_price']
                                        : (isset($productPrice['sale_price']) ? $productPrice['sale_price'] : 0);

                                    // Add additional scraping retry if prices are zero
                                    if ($regular_price == 0) {

                                        $retry_content = executeScrapingService($base_url, true);
                                        if ($retry_content) {
                                                $loop_html = new \simple_html_dom();
                                            $loop_html->load($retry_content);
                                                $productPrice = $product_import->fetchPriceFromHtml($loop_html);
                                                
                                                // Update prices with new values
                                                $regular_price = isset($productPrice['final_prices']['regular_price'])
                                                    ? $productPrice['final_prices']['regular_price']
                                                    : (isset($productPrice['regular_price']) ? $productPrice['regular_price'] : 0);
                                                $sale_price = isset($productPrice['final_prices']['sale_price'])
                                                    ? $productPrice['final_prices']['sale_price']
                                                    : (isset($productPrice['sale_price']) ? $productPrice['sale_price'] : 0);
                                            

                                        } else {

                                        }
                                    }

                                    $currency = $product_import->fetchCurrencyFromHtml($loop_html);


                                    if ($regular_price > 0 || $sale_price > 0) {
                                        $product_status = 'instock';
                                    } else {
                                        $product_status = check_product_stock_status($loop_html);
                                        if ($product_status === 'instock') {
                                            $product_status = 'outofstock';

                                        }
                                    }


                                    $quantity = 0;
                                    if ($qty = $loop_html->find('#availability span', 0)) {
                                        $parsed_qty = $product_import->parseNumberFromString($qty->text());
                                        // Handle -1 as "in stock" indicator (don't manage stock, just set as available)
                                        if ($parsed_qty == -1) {
                                            $quantity = 0; // Don't manage stock quantity
                                            $product_status = 'instock'; // Ensure it's marked as in stock
                                        } else {
                                            $quantity = $parsed_qty;
                                        }
                                    }


                                    $short_description = $product_import->fetchVariationContentFromHtml($loop_html);
                                    $additional_description = $product_import->fetchAdditionalContentFromHtml($loop_html);

                                    if ($product_variant_image_cron) {
                                        $v_gallery = $product_import->fetchImagesFromHtml($loop_html);
                                        $image_limit = get_option('ams_variation_image_limit', 5);
                                        if ($image_limit > 0) {
                                            $v_gallery = array_slice($v_gallery, 0, $image_limit);
                                        }
                                    }

                                    $attributes = $product_import->getProductAttributeFromHtml($loop_html);

                                    $product_variations[] = array(
                                        'sku'                     => $variation_id,
                                        'stock_qty'               => $quantity,
                                        'stock_status'            => $product_status,
                                        'regular_price'           => $regular_price,
                                        'sale_price'              => $sale_price,
                                        'attributes'              => $attributes,
                                        'description'             => $short_description,
                                        'product_image_gallery'   => isset($v_gallery) ? $v_gallery : array(),
                                        'additional_description'  => $additional_description,
                                    );
                                }

                            }

                            //echo '<pre>'; dd( $product_variations ); echo '</pre>';
                            if (count($product_variations) > 0) {
                                wc_update_product_variations($post_id, $product_variations,$parentSku);
                            }


                        }
                        
                        // Update product sku
                        if ($product_sku_cron) {
                            $parentSkuResult = $product_import->getParentSkuFromHtml($html);
                            
                            if (is_string($parentSkuResult) && !empty($parentSkuResult)) {
                                // If it's a string, use it directly
                                $parentSku = $parentSkuResult;
                            } elseif (is_array($parentSkuResult) && count($parentSkuResult) > 0) {
                                // If it's an array, process it as before
                                $parentSkuStr = array_shift($parentSkuResult);
                                $strExp = explode(":", $parentSkuStr);
                                $parentSku = str_replace("\"", "", str_replace(",", "", trim(end($strExp))));
                            } else {
                                $parentSku = null;
                            }

                            if ($parentSku) {
                                update_post_meta($post_id, '_sku', $parentSku);
                            }
                        }
                    }
                    //Run if simple
                    else {
                        $product = wc_get_product($post_id);
                        //print_r('After-simple: ' . $post_id);

                        // Update Additional Description
                        if ($product_description_cron) {
                            $short_description = $product_import->fetchShortDescriptionFromHtml($html);
                            if (!empty($short_description)) {
                                $product->set_short_description($short_description);
                                $product->save(); // Save the product
                            }

                            $additional_description = $product_import->fetchAdditionalContentFromHtml($html);
                            if (!empty($additional_description)) {
                                update_post_meta($post_id, '_ams_additional_information', $additional_description);
                            }
                        }

                        // Product price and stock status
                        $product_status = 'instock';
                        $quantity = 0;

                        if ($product_price_cron || $product_out_of_stock_cron) {
                            // Fetch product price from HTML
                            $productPrice = $product_import->fetchPriceFromHtml($html);
                            $regular_price = isset($productPrice['regular_price']) ? $productPrice['regular_price'] : 0;
                            $sale_price = isset($productPrice['sale_price']) ? $productPrice['sale_price'] : 0;


                            //error_log("Product Price: " . print_r($productPrice, true));

                            // Get removal setting
                            $remove_unavailable_products = get_option('ams_remove_unavailable_products') === 'Yes';
                            
                            // Check if both prices are 0
                            if ($regular_price == 0 && $sale_price == 0) {
                                // Check if removal setting is enabled
                                if ($remove_unavailable_products) {
                                    // Refresh product object
                                    $_product = wc_get_product($post_id);
                                    
                                    // Delete the product if it exists
                                    if ($_product) {
                                        $_product->delete(true);

                                        exit("Product removed due to zero prices.");
                                    }
                                }
                            }

                            // Fetch currency from HTML
                            $currency = $product_import->fetchCurrencyFromHtml($html);


                            // Determine initial stock status based on price availability
                            if ($regular_price > 0 || $sale_price > 0) {
                                $product_status = 'instock';
                            } else {
                                $product_status = 'outofstock';
                            }

                            // Additional check for out of stock status
                            if ($html->find('#outOfStock .a-color-price', 0)) {
                                $product_status = 'outofstock';
                            }



                            if ($product_out_of_stock_cron) {
                                if ($product_status == 'outofstock' && 'Yes' == get_option('ams_remove_unavailable_products')) {
                                    $product_import->removeProductIfNotExists($post_id);

                                    wp_die(
                                        esc_html__('OutOfStock!', 'ams-wc-amazon'),
                                        ['response' => 200]
                                    );
                                }

                                if ($availability = $html->find('#availability span', 0)) {
                                    $parsed_qty = $product_import->parseNumberFromString($availability->text());
                                    // Handle -1 as "in stock" indicator
                                    if ($parsed_qty == -1) {
                                        $quantity = 0; // Don't manage stock quantity
                                        $product_status = 'instock'; // Ensure it's marked as in stock
                                    } else {
                                        $quantity = $parsed_qty;
                                    }
                                }

                                if ($quantity > 0) {
                                    update_post_meta($post_id, '_stock', $quantity);
                                    update_post_meta($post_id, '_manage_stock', 'yes');
                                } else {
                                    update_post_meta($post_id, '_stock', '');
                                    update_post_meta($post_id, '_manage_stock', 'no');
                                }
                                update_post_meta($post_id, '_stock_status', $product_status);
                            }

                            if ($product_price_cron) {
                                // Update regular price
                                update_post_meta($post_id, '_regular_price', $regular_price);
                                $product->set_regular_price($regular_price);
                                
                                // Update sale price and current price
                                if ($sale_price > 0 && $sale_price < $regular_price) {
                                    update_post_meta($post_id, '_sale_price', $sale_price);
                                    update_post_meta($post_id, '_price', $sale_price);
                                    $product->set_price($sale_price);
                                    $product->set_sale_price($sale_price);
                                } else {
                                    delete_post_meta($post_id, '_sale_price');
                                    update_post_meta($post_id, '_price', $regular_price);
                                    $product->set_price($regular_price);
                                    $product->set_sale_price('');
                                }
                                
                                // Update currency
                                if ($currency) {
                                    update_post_meta($post_id, '_product_currency', $currency);
                                }
                            }
                        }

                        // Product images + feature image
                        if ($product_image_cron) {
                            // Get the image limit from plugin settings
                            $image_limit = get_option('ams_variation_image_limit', 5);
                            
                            // Set product feature image.
                            $gallery = $product_import->fetchImagesFromHtml($html);
                            
                            // Apply the limit to the gallery
                            $gallery = array_slice($gallery, 0, $image_limit);
                            
                            $image = array_shift($gallery);
                            $use_remote_images = ('Yes' === get_option('ams_remote_amazon_images'));
                            
                            // Always remove existing images and URLs
                            if ($image) {
                                // Remove featured image and url.
                                delete_product_images($post_id);
                                reset_product_thumbnail_url($post_id, $flag = 0);
                            }
                            
                            if (count($gallery) > 0) {
                                // Remove product gallery images and url.
                                delete_product_gallery_images($post_id);
                                reset_product_thumbnail_url($post_id, $flag = 1);
                            }
                            
                            if ($use_remote_images) {
                                // Set featured image url
                                if ($image) {
                                    attach_product_thumbnail_url($post_id, $image, 0);
                                }
                                // Set featured image gallery
                                if (count($gallery) > 0) {
                                    attach_product_thumbnail_url($post_id, $gallery, 1);
                                }
                                // Remove any locally stored images
                                delete_local_product_images($post_id);
                            } else {
                                // Set featured image
                                if ($image) {
                                    attach_product_thumbnail($post_id, $image, 0);
                                }
                                // Set featured image gallery
                                foreach ($gallery as $gallery_image) {
                                    // Set gallery image.
                                    attach_product_thumbnail($post_id, $gallery_image, 1);
                                }
                                // Remove any stored image URLs
                                delete_product_image_urls($post_id);
                            }
                        }

                        $product->save(); // Save all changes

                    }

                    // Update Product Review
                    if ($enable_amazon_review && $product_review_cron) {
                        // Get review limit from settings
                        $review_limit = get_option('multiple_import_review_limit', 10);
                        
                        // Scrape the reviews
                        $reviews = scrape_amazon_reviews($html, $review_limit);
                        


                        if (!empty($reviews) && isset($post_id)) {
                            // Get existing reviews
                            $existing_reviews = get_comments([
                                'post_id' => $post_id,
                                'type' => 'review',
                                'status' => 'approve'
                            ]);
                            
                            // Create array of existing review hashes
                            $existing_hashes = [];
                            foreach ($existing_reviews as $existing_review) {
                                $existing_hash = get_comment_meta($existing_review->comment_ID, 'review_hash', true);
                                if (!empty($existing_hash)) {
                                    $existing_hashes[$existing_hash] = $existing_review->comment_ID;
                                }
                            }

                            // Initialize rating totals
                            $rating_sum = 0;
                            $rating_count = 0;

                            // Process each review
                            foreach ($reviews as $review_hash => $review) {
                                // Skip if review already exists
                                if (isset($existing_hashes[$review_hash])) {

                                    continue;
                                }

                                // Prepare comment data
                                $commentdata = [
                                    'comment_post_ID' => $post_id,
                                    'comment_author' => $review['reviewer_name'],
                                    'comment_content' => $review['text'],
                                    'comment_date' => $review['date'],
                                    'comment_date_gmt' => get_gmt_from_date($review['date']),
                                    'comment_approved' => 1,
                                    'comment_type' => 'review',
                                    'user_id' => 0
                                ];

                                // Insert the comment
                                $comment_id = wp_insert_comment($commentdata);

                                if ($comment_id) {
                                    // Add all the comment meta
                                    add_comment_meta($comment_id, 'rating', $review['rating']);
                                    add_comment_meta($comment_id, 'review_hash', $review_hash);
                                    add_comment_meta($comment_id, 'verified', 1);
                                    add_comment_meta($comment_id, 'title', $review['title']);

                                    if (!empty($review['reviewer_image'])) {
                                        add_comment_meta($comment_id, 'reviewer_image', $review['reviewer_image']);
                                    }

                                    $rating_sum += floatval($review['rating']);
                                    $rating_count++;


                                }
                            }

                            // Update product rating if we added any new reviews
                            if ($rating_count > 0) {
                                $product = wc_get_product($post_id);
                                if ($product) {
                                    // Get actual count of approved reviews
                                    $actual_review_count = get_comments([
                                        'post_id' => $post_id,
                                        'type' => 'review',
                                        'status' => 'approve',
                                        'count' => true
                                    ]);

                                    // Calculate actual rating sum
                                    $actual_rating_sum = 0;
                                    $product_reviews = get_comments([
                                        'post_id' => $post_id,
                                        'type' => 'review',
                                        'status' => 'approve'
                                    ]);

                                    foreach ($product_reviews as $review) {
                                        $rating = get_comment_meta($review->comment_ID, 'rating', true);
                                        $actual_rating_sum += floatval($rating);
                                    }

                                    // Calculate new average
                                    $new_average = $actual_rating_sum / $actual_review_count;

                                    // Update all rating meta
                                    update_post_meta($post_id, '_wc_average_rating', round($new_average, 2));
                                    update_post_meta($post_id, '_wc_rating_count', $actual_review_count);
                                    update_post_meta($post_id, '_wc_review_count', $actual_review_count);
                                    update_post_meta($post_id, '_wc_rating_sum', $actual_rating_sum);

                                    // Clear all relevant caches
                                    delete_transient('wc_product_reviews_' . $post_id);
                                    delete_transient('wc_average_rating_' . $post_id);
                                    wp_cache_delete($post_id, 'product');
                                    
                                    if (function_exists('wc_delete_product_transients')) {
                                        wc_delete_product_transients($post_id);
                                    }


                                }
                            }


                        }
                    }
                    // Update Product Review


                    update_post_meta($post_id, 'ams_last_cron_update',date('Y-m-d H:i:s'));
                    update_post_meta($post_id, 'ams_last_cron_status',1);
                    update_post_meta($post_id, '_ams_product_url', $url);


                    echo esc_html__('Product updated Successfully!', 'ams-wc-amazon') . '<a href="' . esc_url($url) . '" target="_blank" style="color: white;">' . esc_html(mb_strimwidth($url, 0, 35, '...')) . '</a>';
                    wc_delete_product_transients($post_id);
                    
                    clean_completed_woocommerce_actions();
                    clean_all_actionscheduler_logs();
                    @file_put_contents($__log_file, '[' . date('Y-m-d H:i:s') . '] Success: func=ams_product_availability POST_ID=' . $id . '; ASIN=' . $asin . '; method=scraping; status=updated' . "\n", FILE_APPEND);

                } else {
                    error_log("Failed to fetch product data");
                    echo 'Failed to fetch product data';
                    @file_put_contents($__log_file, '[' . date('Y-m-d H:i:s') . '] Failed: func=ams_product_availability POST_ID=' . $id . '; ASIN=' . $asin . '; method=scraping; reason=failed_to_fetch_data' . "\n", FILE_APPEND);
                }
            }
        
        @file_put_contents($__log_file, '[' . date('Y-m-d H:i:s') . '] End: func=ams_product_availability; status=success' . "\n", FILE_APPEND);
        }   catch (\Throwable $th) {
            // Check if post_id exists in $_POST
            if (isset($_POST['post_id'])) {
                update_post_meta($_POST['post_id'], 'ams_last_cron_update', date('Y-m-d H:i:s'));
                update_post_meta($_POST['post_id'], 'ams_last_cron_status', 1);
            } else if (isset($id) && !empty($id)) {
                // Use the $id variable from the foreach loop if it's available
                update_post_meta($id, 'ams_last_cron_update', date('Y-m-d H:i:s'));
                update_post_meta($id, 'ams_last_cron_status', 1);
            }
            // Optionally log the error
            error_log("Exception in ams_product_availability: " . $th->getMessage());
            @file_put_contents($__log_file, '[' . date('Y-m-d H:i:s') . '] End: func=ams_product_availability; status=failure; error=exception' . "\n", FILE_APPEND);
        }
        
        wp_die();
    }


    add_action( 'manage_product_posts_custom_column', 'ExtraCronColumn', 10, 2 );
    function ExtraCronColumn( $column, $postid ) {

        if( $column == 'import_method' ) {
            $import_method = '';
            switch(get_post_meta($postid, '_import_method', true)) {
                case '1':
                    $import_method = 'AMAZON API';
                    break;
                case '2':
                    $import_method = 'NO API - BY SEARCH';
                    break;
                case '3':
                    $import_method = 'NO API - BY URLS';
                    break;
            }
            echo $import_method;
        }
        
        if ($column == 'cron_run_status') {
            $date = get_post_meta( $postid, 'ams_last_cron_update', true);
            $product_url = get_post_meta( $postid, '_ams_product_url', true);
            // Fallback to _detail_page_url if _ams_product_url is empty
            if (empty($product_url)) {
                $product_url = get_post_meta( $postid, '_detail_page_url', true);
            }
            
            $import_method = '';
            switch(get_post_meta($postid, '_import_method', true)) {
                case '1':
                    $import_method = 'AMAZON API';
                    break;
                case '2':
                    $import_method = 'NO API - BY SEARCH';
                    break;
                case '3':
                    $import_method = 'NO API - BY URLS';
                    break;
            }
            
            $status = get_post_meta($postid, 'ams_last_cron_status', true);
            $data_attr = 'data-post-id="' . $postid . '" data-url="' . $product_url . '"';

            if (!empty($date)) {
                $status_text = $status == 1 ? 'Updated' : 'Failed';
                $status_class = $status == 1 ? 'ams-status-success' : 'ams-status-failed';
                $status_icon = $status == 1 ? '✓' : '✗';
                
                $html = '<div class="ams-cron-container">';
                
                // Status Badge
                $html .= '<div class="ams-status-badge ' . $status_class . '">';
                $html .= '<span class="ams-status-icon">' . $status_icon . '</span>';
                $html .= '<span class="ams-status-text">' . $status_text . '</span>';
                $html .= '</div>';
                
                // Date and Method Info
                $html .= '<div class="ams-cron-info">';
                $html .= '<div class="ams-date-info">' . date('M j, H:i', strtotime($date)) . '</div>';
                $html .= '<div class="ams-method-info">' . $import_method . '</div>';
                $html .= '<div class="ams-plugin-badge">AMS Plugin</div>';
                $html .= '</div>';
                
                // Update Button
                $html .= '<button type="button" class="ams-update-button wca-product-update-request" ' . $data_attr . '>';
                $html .= '<span class="ams-btn-icon">↻</span>';
                $html .= '<span class="ams-btn-text">Update</span>';
                $html .= '</button>';
                
                $html .= '</div>';
                echo $html;
            } elseif ($product_url) {
                $html = '<div class="ams-cron-container">';
                
                // Pending Badge
                $html .= '<div class="ams-status-badge ams-status-pending">';
                $html .= '<span class="ams-status-icon">⏳</span>';
                $html .= '<span class="ams-status-text">Pending</span>';
                $html .= '</div>';
                
                // Method Info
                $html .= '<div class="ams-cron-info">';
                $html .= '<div class="ams-method-info">' . $import_method . '</div>';
                $html .= '<div class="ams-plugin-badge">AMS Plugin</div>';
                $html .= '</div>';
                
                // Update Button
                $html .= '<button type="button" class="ams-update-button wca-product-update-request" ' . $data_attr . '>';
                $html .= '<span class="ams-btn-icon">↻</span>';
                $html .= '<span class="ams-btn-text">Update</span>';
                $html .= '</button>';
                
                $html .= '</div>';
                echo $html;
            } else {
                echo '<div class="ams-no-data">–</div>';
            }
        }

        if ($column == 'custom_price') {
            $product = wc_get_product($postid);        
            if (!get_post_meta($product->get_id(), '_ams_product_url', true)) {
                echo $product->get_price_html();
            } else {
                if ($product->is_type('variable')) {
                    $priceArray = [];
                    $variations = $product->get_children();
                    if (count($variations) > 0) {
                        foreach ($variations as $variation_id) {
                            $w_product = wc_get_product($variation_id);
                            if ($w_product->is_on_sale()) {
                                $sale_price = $w_product->get_sale_price();
                                $priceArray[] = [
                                    'ID' => $w_product->get_id(),
                                    'price' => $sale_price,
                                ];
                            } else {
                                $regular_price = $w_product->get_regular_price();
                                $priceArray[] = [
                                    'ID' => $w_product->get_id(),
                                    'price' => $regular_price,
                                ];
                            }
                        }

                        $prices = array_column($priceArray, 'price');
                        $minPrice = $product->get_variation_price('min');
                        $maxPrice = $product->get_variation_price('max');

                        $min = wc_price($minPrice);
                        $max = wc_price($maxPrice);

                        if ($minPrice == $maxPrice) {
                            echo $min;
                        } else {
                            if ($minPrice && $maxPrice) {
                                echo $min . ' - ' . $max;
                            } elseif ($minPrice) {
                                echo $min;
                            } else {
                                echo $max;
                            }
                        }
                    }
                } else {
                    if ($product->is_on_sale()) {
                        $regular_price = $product->get_regular_price();
                        $sale_price = $product->get_sale_price();
                        echo '<del>' . wc_price($regular_price) . '</del> <ins>' . wc_price($sale_price) . '</ins>';
                    } else {
                        $regular_price = $product->get_regular_price();
                        echo wc_price($regular_price);
                    }
                }
            }
        }
    }

    // make header of column clickable for sort
    function ams_sortable_product_columns_header( $sortable_columns ) {
        $sortable_columns['custom_price'] = 'price';
        return $sortable_columns;
    }

    function checkExistProduct($sku)
    {
        $the_query = new WP_Query($args);
        // The Loop
        $return = false;
        if ($the_query->have_posts()) {
            while ($the_query->have_posts()) {
                $the_query->the_post();
                $post_id = get_the_ID();
                $_sku = get_post_meta($post_id, "_sku", true);
                if ($_sku == $sku) {
                    $return = true;
                    break;
                }
            }
        }
        /* Restore original Post Data */
        wp_reset_postdata();
        return $return;
    }

    add_action('wp_ajax_ams_get_currency_by_country', 'ams_get_currency_by_country');
    function ams_get_currency_by_country() {
        $data = ams_woocommerce_currency_countries();
        $selectedCountry = $_POST['country'];
        $result = ['status' => false];
        if($selectedCountry == 'com') {
            $result = ['status' => true, 'value' => 'USD'];
        } else {
            foreach ($data as $key => $value) {
                if(in_array(strtoupper($selectedCountry), $value)) {
                    $result = ['status' => true, 'value' => $key];
                    break;
                }
            }
        }
        echo json_encode($result);
        wp_die();    
    }

    function ams_woocommerce_currency_countries() {
        return array(
            'AFN' => array( 'AF' ),
            'ALL' => array( 'AL' ),
            'DZD' => array( 'DZ' ),
            'USD' => array( 'AS', 'IO', 'GU', 'MH', 'FM', 'MP', 'PW', 'PR', 'TC', 'US', 'UM', 'VI', 'US'),
            'EUR' => array( 'AD', 'AT', 'BE', 'CY', 'EE', 'FI', 'FR', 'GF', 'TF', 'DE', 'GR', 'GP', 'IE', 'IT', 'LV', 'LT', 'LU', 'MT', 'MQ', 'YT', 'MC', 'ME', 'NL', 'PT', 'RE', 'PM', 'SM', 'SK', 'SI', 'ES' ),
            'AOA' => array( 'AO' ),
            'XCD' => array( 'AI', 'AQ', 'AG', 'DM', 'GD', 'MS', 'KN', 'LC', 'VC' ),
            'ARS' => array( 'AR' ),
            'AMD' => array( 'AM' ),
            'AWG' => array( 'AW' ),
            'AUD' => array( 'AU', 'CX', 'CC', 'HM', 'KI', 'NR', 'NF', 'TV' ),
            'AZN' => array( 'AZ' ),
            'BSD' => array( 'BS' ),
            'BHD' => array( 'BH' ),
            'BDT' => array( 'BD' ),
            'BBD' => array( 'BB' ),
            'BYR' => array( 'BY' ),
            'BZD' => array( 'BZ' ),
            'XOF' => array( 'BJ', 'BF', 'ML', 'NE', 'SN', 'TG' ),
            'BMD' => array( 'BM' ),
            'BTN' => array( 'BT' ),
            'BOB' => array( 'BO' ),
            'BAM' => array( 'BA' ),
            'BWP' => array( 'BW' ),
            'NOK' => array( 'BV', 'NO', 'SJ' ),
            'BRL' => array( 'BR' ),
            'BND' => array( 'BN' ),
            'BGN' => array( 'BG' ),
            'BIF' => array( 'BI' ),
            'KHR' => array( 'KH' ),
            'XAF' => array( 'CM', 'CF', 'TD', 'CG', 'GQ', 'GA' ),
            'CAD' => array( 'CA' ),
            'CVE' => array( 'CV' ),
            'KYD' => array( 'KY' ),
            'CLP' => array( 'CL' ),
            'CNY' => array( 'CN' ),
            'HKD' => array( 'HK' ),
            'COP' => array( 'CO' ),
            'KMF' => array( 'KM' ),
            'CDF' => array( 'CD' ),
            'NZD' => array( 'CK', 'NZ', 'NU', 'PN', 'TK' ),
            'CRC' => array( 'CR' ),
            'HRK' => array( 'HR' ),
            'CUP' => array( 'CU' ),
            'CZK' => array( 'CZ' ),
            'DKK' => array( 'DK', 'FO', 'GL' ),
            'DJF' => array( 'DJ' ),
            'DOP' => array( 'DO' ),
            'ECS' => array( 'EC' ),
            'EGP' => array( 'EG' ),
            'SVC' => array( 'SV' ),
            'ERN' => array( 'ER' ),
            'ETB' => array( 'ET' ),
            'FKP' => array( 'FK' ),
            'FJD' => array( 'FJ' ),
            'GMD' => array( 'GM' ),
            'GEL' => array( 'GE' ),
            'GHS' => array( 'GH' ),
            'GIP' => array( 'GI' ),
            'QTQ' => array( 'GT' ),
            'GGP' => array( 'GG' ),
            'GNF' => array( 'GN' ),
            'GWP' => array( 'GW' ),
            'GYD' => array( 'GY' ),
            'HTG' => array( 'HT' ),
            'HNL' => array( 'HN' ),
            'HUF' => array( 'HU' ),
            'ISK' => array( 'IS' ),
            'INR' => array( 'IN' ),
            'IDR' => array( 'ID' ),
            'IRR' => array( 'IR' ),
            'IQD' => array( 'IQ' ),
            'GBP' => array( 'IM', 'JE', 'GS', 'GB', 'UK' ),
            'ILS' => array( 'IL' ),
            'JMD' => array( 'JM' ),
            'JPY' => array( 'JP' ),
            'JOD' => array( 'JO' ),
            'KZT' => array( 'KZ' ),
            'KES' => array( 'KE' ),
            'KPW' => array( 'KP' ),
            'KRW' => array( 'KR' ),
            'KWD' => array( 'KW' ),
            'KGS' => array( 'KG' ),
            'LAK' => array( 'LA' ),
            'LBP' => array( 'LB' ),
            'LSL' => array( 'LS' ),
            'LRD' => array( 'LR' ),
            'LYD' => array( 'LY' ),
            'CHF' => array( 'LI', 'CH' ),
            'MKD' => array( 'MK' ),
            'MGF' => array( 'MG' ),
            'MWK' => array( 'MW' ),
            'MYR' => array( 'MY' ),
            'MVR' => array( 'MV' ),
            'MRO' => array( 'MR' ),
            'MUR' => array( 'MU' ),
            'MXN' => array( 'MX' ),
            'MDL' => array( 'MD' ),
            'MNT' => array( 'MN' ),
            'MAD' => array( 'MA', 'EH' ),
            'MZN' => array( 'MZ' ),
            'MMK' => array( 'MM' ),
            'NAD' => array( 'NA' ),
            'NPR' => array( 'NP' ),
            'ANG' => array( 'AN' ),
            'XPF' => array( 'NC', 'WF' ),
            'NIO' => array( 'NI' ),
            'NGN' => array( 'NG' ),
            'OMR' => array( 'OM' ),
            'PKR' => array( 'PK' ),
            'PAB' => array( 'PA' ),
            'PGK' => array( 'PG' ),
            'PYG' => array( 'PY' ),
            'PEN' => array( 'PE' ),
            'PHP' => array( 'PH' ),
            'PLN' => array( 'PL' ),
            'QAR' => array( 'QA' ),
            'RON' => array( 'RO' ),
            'RUB' => array( 'RU' ),
            'RWF' => array( 'RW' ),
            'SHP' => array( 'SH' ),
            'WST' => array( 'WS' ),
            'STD' => array( 'ST' ),
            'SAR' => array( 'SA' ),
            'RSD' => array( 'RS' ),
            'SCR' => array( 'SC' ),
            'SLL' => array( 'SL' ),
            'SGD' => array( 'SG' ),
            'SBD' => array( 'SB' ),
            'SOS' => array( 'SO' ),
            'ZAR' => array( 'ZA' ),
            'SSP' => array( 'SS' ),
            'LKR' => array( 'LK' ),
            'SDG' => array( 'SD' ),
            'SRD' => array( 'SR' ),
            'SZL' => array( 'SZ' ),
            'SEK' => array( 'SE' ),
            'SYP' => array( 'SY' ),
            'TWD' => array( 'TW' ),
            'TJS' => array( 'TJ' ),
            'TZS' => array( 'TZ' ),
            'THB' => array( 'TH' ),
            'TOP' => array( 'TO' ),
            'TTD' => array( 'TT' ),
            'TND' => array( 'TN' ),
            'TRY' => array( 'TR' ),
            'TMT' => array( 'TM' ),
            'UGX' => array( 'UG' ),
            'UAH' => array( 'UA' ),
            'AED' => array( 'AE' ),
            'UYU' => array( 'UY' ),
            'UZS' => array( 'UZ' ),
            'VUV' => array( 'VU' ),
            'VEF' => array( 'VE' ),
            'VND' => array( 'VN' ),
            'YER' => array( 'YE' ),
            'ZMW' => array( 'ZM' ),
            'ZWD' => array( 'ZW' ),
        );
    }

    function get_ams_woocommerce_currency_code( $country = '' ) {
        // Set default
        $default = null;
        $country_code = "USD";

        // If country not exists
        if ( ! $country ) return $default;

        // If country is "com" which is mainly refers to us
        if( $country == 'com' ) return $country_code;

        // Search if country exists return the country code
        $currency_countries = ams_woocommerce_currency_countries();
        foreach ( $currency_countries as $country_code => $countries ) {
            if(in_array(strtoupper($country), $countries)) {
                return $country_code;
            }
        }

        // If not esists return default value
        return $default;
    }

    /* Simple Woocommerce Stuff */
    function wc_simple_create_attributes( $name, $options ){
        $attribute = new \WC_Product_Attribute();
        $attribute->set_id(0);
        $attribute->set_name($name);
        $attribute->set_options($options);
        $attribute->set_visible(true);
        $attribute->set_variation(true);
        return $attribute;
    }
    function wc_simple_create_variations($product_id, $values, $data = []) {
        if (!isset($data['sku']) || !isset($data['attributes'])) {
            return;
        }
        $product = wc_get_product($product_id);
        $slug = '';
        if (!empty($values)) {
            $slug = '-' . strtolower(implode('-', array_values($values)));
        }
        $variation_post = array(
            'post_title'  => $data['post_title'],
            'post_name'   => 'product-' . $product_id . '-variation' . $slug,
            'post_status' => 'publish',
            'post_parent' => $product_id,
            'post_type'   => 'product_variation',
            'guid'        => $product->get_permalink()
        );
        $existing_variation = get_post($variation_post);
        // CreateOrUpdate the product variation
        if ($existing_variation !== null) {
            $variation_id = $existing_variation->ID;
            $variation_post['ID'] = $existing_variation->ID;
            wp_update_post($variation_post);                        
        } else {
            $variation_id = wp_insert_post($variation_post);
        }
        // Get an instance of the WC_Product_Variation object
        $variation = new \WC_Product_Variation($variation_id);
        // Add variation scraped data to meta
        $variation->update_meta_data('variation_data', $data);
        $variation->set_attributes($values);
        $variation->set_status('publish');
        if (!empty($data)) {
            // Set defaults
            $regular_price = isset($data['regular_price']) ? $data['regular_price'] : '';
            $sale_price = isset($data['sale_price']) ? $data['sale_price'] : '';

            // Convert '0' to empty string for prices
            $regular_price = ($regular_price === '0') ? '' : $regular_price;
            $sale_price = ($sale_price === '0') ? '' : $sale_price;

            // Set regular price
            if (!empty($regular_price)) {
                $variation->set_regular_price($regular_price);
            }

            // Set sale price and current price
            if (!empty($sale_price) && $sale_price < $regular_price) {
                $variation->set_sale_price($sale_price);
                $variation->set_price($sale_price);
            } else {
                $variation->set_sale_price(''); // Clear sale price if it's not valid
                $variation->set_price($regular_price);
            }

            // Stock
            if (!empty($data['stock_status'])) {
                $variation->set_stock_status($data['stock_status']);
            } else {
                $variation->set_manage_stock(false);
            }
        }
        $variation->save();
        $product->save();
    }

    function get_product_by_sku( $sku ) {
        global $wpdb;

        $product_id = $wpdb->get_var( $wpdb->prepare( "SELECT post_id FROM $wpdb->postmeta WHERE meta_key='_sku' AND meta_value='%s' LIMIT 1", $sku ) );
        if ( $product_id ) {
            return wc_get_product($product_id);
        }

        return null;
    }

    //Create function - original
    if ( ! function_exists( 'wc_create_product_variations' ) ) {
        function wc_create_product_variations($product_id, $product_variations, $parentSku) {
            global $wpdb;

            $product = wc_get_product($product_id);
            if (!$product || !is_a($product, 'WC_Product')) {
                return false;
            }

            try {
                // Store existing attributes for preservation
                $existing_attributes = $product->get_attributes();
                $parent_attributes = [];
                
                // Preserve existing attributes
                foreach ($existing_attributes as $attribute_name => $attribute_value) {
                    if (strtolower($attribute_name) === 'brand') {
                        $parent_attributes['brand'] = $attribute_value;
                    }
                }

                // Update main product SKU if different
                if (!empty($parentSku) && $product->get_sku() !== $parentSku) {
                    $product->set_sku($parentSku);
                    $product->save();
                }

                $updated_variation_ids = [];
                $all_variants_skipped = true;

                // Retrieve setting whether to remove unavailable products
                $remove_unavailable_products = (get_option('ams_remove_unavailable_products') === 'Yes');

                // Loop through new variations
                foreach ($product_variations as $variation_index => $variation_data) {
                    
                    // Skip zero-price+outofstock if setting is enabled
                    if (
                        $remove_unavailable_products &&
                        (empty($variation_data['regular_price']) || floatval($variation_data['regular_price']) == 0) &&
                        (empty($variation_data['sale_price']) || floatval($variation_data['sale_price']) == 0) &&
                        (isset($variation_data['stock_status']) && $variation_data['stock_status'] === 'outofstock')
                    ) {
                        continue;
                    }

                    $all_variants_skipped = false;

                    if (empty($variation_data['attributes'])) {
                        error_log('[' . date('Y-m-d H:i:s') . '] SKIPPED: Empty attributes for SKU: ' . (isset($variation_data['sku']) ? $variation_data['sku'] : 'NO SKU') . "\n", 3, $debug_log);
                        continue;
                    }
                    
                    error_log('[' . date('Y-m-d H:i:s') . '] Attributes found: ' . count($variation_data['attributes']) . "\n", 3, $debug_log);
                    error_log('[' . date('Y-m-d H:i:s') . '] Attributes structure: ' . print_r($variation_data['attributes'], true) . "\n", 3, $debug_log);

                    // Create new variation
                    $variation = new WC_Product_Variation();
                    $variation->set_parent_id($product_id);

                    // Handle SKU with improved checking
                    if (!empty($variation_data['sku'])) {
                        $sanitized_sku = sanitize_text_field($variation_data['sku']);
                        error_log('[' . date('Y-m-d H:i:s') . '] Checking SKU: ' . $sanitized_sku . "\n", 3, $debug_log);
                        $existing_id = wc_get_product_id_by_sku($sanitized_sku);
                        if ($existing_id) {
                            error_log('[' . date('Y-m-d H:i:s') . '] SKIPPED: SKU already exists (Product ID: ' . $existing_id . ') for SKU: ' . $sanitized_sku . "\n", 3, $debug_log);
                            continue;
                        }
                        $variation->set_sku($sanitized_sku);
                        error_log('[' . date('Y-m-d H:i:s') . '] SKU set successfully: ' . $sanitized_sku . "\n", 3, $debug_log);
                    } else {
                        error_log('[' . date('Y-m-d H:i:s') . '] SKIPPED: Empty SKU in variation data' . "\n", 3, $debug_log);
                        continue;
                    }

                    // Set prices
                    $variation->set_regular_price($variation_data['regular_price']);
                    if (!empty($variation_data['sale_price']) && floatval($variation_data['sale_price']) < floatval($variation_data['regular_price'])) {
                        $variation->set_sale_price($variation_data['sale_price']);
                        $variation->set_price($variation_data['sale_price']);
                    } else {
                        $variation->set_sale_price('');
                        $variation->set_price($variation_data['regular_price']);
                    }

                    // Stock
                    if (isset($variation_data['stock_qty']) && trim($variation_data['stock_qty']) > 0) {
                        $variation->set_stock_quantity($variation_data['stock_qty']);
                        $variation->set_manage_stock(true);
                        $variation->set_stock_status($variation_data['stock_status']);
                    } else {
                        $variation->set_manage_stock(false);
                        $variation->set_stock_status($variation_data['stock_status']);
                    }

                    // Descriptions
                    if (!empty($variation_data['description'])) {
                        $variation->set_description($variation_data['description']);
                    }
                    if (!empty($variation_data['additional_description'])) {
                        $variation->update_meta_data('_additional_description', $variation_data['additional_description']);
                    }

                    // Build an associative array of selected attribute values
                    $selected_attributes = array();
                    error_log('[' . date('Y-m-d H:i:s') . '] Building selected attributes...' . "\n", 3, $debug_log);
                    foreach ($variation_data['attributes'] as $attr_index => $attr) {
                        error_log('[' . date('Y-m-d H:i:s') . '] Processing attribute ' . $attr_index . ': ' . print_r($attr, true) . "\n", 3, $debug_log);
                        if (isset($attr['slug']) && isset($attr['selected']) && !empty($attr['selected'])) {
                            $selected_attributes[wc_sanitize_taxonomy_name($attr['slug'])] = $attr['selected'];
                            error_log('[' . date('Y-m-d H:i:s') . '] Added selected attribute: ' . $attr['slug'] . ' = ' . $attr['selected'] . "\n", 3, $debug_log);
                        } else {
                            error_log('[' . date('Y-m-d H:i:s') . '] SKIPPED attribute (missing slug/selected): ' . print_r($attr, true) . "\n", 3, $debug_log);
                        }
                    }
                    error_log('[' . date('Y-m-d H:i:s') . '] Final selected attributes: ' . print_r($selected_attributes, true) . "\n", 3, $debug_log);
                    if (empty($selected_attributes)) {
                        error_log('[' . date('Y-m-d H:i:s') . '] SKIPPED: No valid selected attributes found' . "\n", 3, $debug_log);
                        continue;
                    }

                    $variation_attributes = array();
                    foreach ($variation_data['attributes'] as $attribute) {
                        $attribute_slug = wc_sanitize_taxonomy_name($attribute['slug']);
                        $attribute_key = 'pa_' . $attribute_slug;

                        // Ensure taxonomy exists
                        if (!taxonomy_exists($attribute_key)) {
                            $attribute_id = wc_create_attribute(array(
                                'name' => wc_clean($attribute['name']),
                                'slug' => $attribute_slug,
                                'type' => 'select',
                                'order_by' => 'menu_order',
                                'has_archives' => false,
                            ));
                            if (!is_wp_error($attribute_id)) {
                                register_taxonomy(
                                    $attribute_key,
                                    array('product'),
                                    array(
                                        'label' => wc_clean($attribute['name']),
                                        'rewrite' => array('slug' => $attribute_slug),
                                        'hierarchical' => false,
                                    )
                                );
                            }
                        }

                        // Update or create the parent product attribute
                        if (!isset($parent_attributes[$attribute_key])) {
                            $parent_attribute = new WC_Product_Attribute();
                            $parent_attribute->set_id(wc_attribute_taxonomy_id_by_name($attribute_key));
                            $parent_attribute->set_name($attribute_key);
                            $parent_attribute->set_visible($attribute['visible']);
                            $parent_attribute->set_variation($attribute['variation']);

                            $options = (isset($attribute['options']) && is_array($attribute['options']) && !empty($attribute['options']))
                                ? $attribute['options']
                                : array($selected_attributes[$attribute_slug]);
                            $term_ids = array();
                            foreach ($options as $option) {
                                $term_name = wc_clean($option);
                                $term = get_term_by('name', $term_name, $attribute_key);
                                if (!$term) {
                                    $term = wp_insert_term($term_name, $attribute_key);
                                    if (!is_wp_error($term)) {
                                        $term = get_term($term['term_id'], $attribute_key);
                                    }
                                }
                                if ($term && !is_wp_error($term)) {
                                    $term_ids[] = $term->term_id;
                                }
                            }
                            $parent_attribute->set_options($term_ids);
                            $parent_attributes[$attribute_key] = $parent_attribute;
                        }

                        // Use the selected value for this attribute
                        if (!isset($selected_attributes[$attribute_slug])) {

                            continue 2;
                        }
                        $desired_value = $selected_attributes[$attribute_slug];

                        // Get allowed options; fallback if missing
                        $options = (isset($attribute['options']) && is_array($attribute['options']) && !empty($attribute['options']))
                            ? $attribute['options']
                            : array($desired_value);

                        $found = false;
                        foreach ($options as $option) {
                            if (strcasecmp($option, $desired_value) === 0) {
                                $found = true;
                                $term_name = wc_clean($option);
                                break;
                            }
                        }
                        if (!$found) {

                            continue 2;
                        }

                        $term = get_term_by('name', $term_name, $attribute_key);
                        if ($term && !is_wp_error($term)) {
                            $variation_attributes['attribute_' . $attribute_key] = $term->slug;
                        }


                    }

                    // Save the variation 
                    error_log('[' . date('Y-m-d H:i:s') . '] Setting variation attributes: ' . print_r($variation_attributes, true) . "\n", 3, $debug_log);
                    $variation->set_attributes($variation_attributes);
                    $variation->save();
                    $variation_id = $variation->get_id();
                    error_log('[' . date('Y-m-d H:i:s') . '] SUCCESS: Variation saved with ID: ' . $variation_id . "\n", 3, $debug_log);

                    // Handle images
                    if (!empty($variation_data['product_image_gallery'])) {
                        $gallery = $variation_data['product_image_gallery'];
                        if (!is_array($gallery)) {
                            $gallery = array($gallery);
                        }
                        $gallery_image_ids = array();
                        $local_gallery_urls = array();
                        $use_remote_images = ('Yes' === get_option('ams_remote_amazon_images'));
                        foreach ($gallery as $index => $image) {
                            if ($use_remote_images) {
                                $image_ids = attach_product_thumbnail_url($variation_id, $image, ($index === 0 ? 0 : 1));
                                if (is_array($image_ids)) {
                                    $gallery_image_ids = array_merge($gallery_image_ids, $image_ids);
                                } elseif ($image_ids) {
                                    $gallery_image_ids[] = $image_ids;
                                }
                                $local_gallery_urls[] = $image;
                            } else {
                                $local_url = attach_product_thumbnail($variation_id, $image, ($index === 0 ? 0 : 1));
                                if ($local_url) {
                                    $local_gallery_urls[] = $local_url;
                                    $attach_id = attachment_url_to_postid($local_url);
                                    if ($attach_id) {
                                        $gallery_image_ids[] = $attach_id;
                                    }
                                }
                            }
                        }
                        if (!empty($gallery_image_ids)) {
                            set_post_thumbnail($variation_id, $gallery_image_ids[0]);
                            update_post_meta($variation_id, '_product_image_gallery', implode(',', array_unique($gallery_image_ids)));
                        }
                        update_post_meta($variation_id, '_amswoofiu_wcgallary', array_unique($local_gallery_urls));
                    }

                    $updated_variation_ids[] = $variation_id;
                }

                // Handle if all variants were skipped
                if ($all_variants_skipped && $remove_unavailable_products) {
                    wp_delete_post($product_id, true);

                    return new WP_Error('all_variants_skipped', esc_html__("OutOfStock!", 'ams-wc-amazon'));
                }

                // Set updated attributes for parent
                $product->set_attributes(array_values($parent_attributes));
                $product->save();
                error_log('[' . date('Y-m-d H:i:s') . '] Parent product attributes updated and saved' . "\n", 3, $debug_log);

                // Clear caches
                wc_delete_product_transients($product_id);
                wp_cache_delete($product_id, 'posts');
                wp_cache_delete($product_id, 'product_' . $product_id);
                $wpdb->query($wpdb->prepare("DELETE FROM {$wpdb->prefix}wc_product_meta_lookup WHERE product_id = %d", $product_id));

                error_log('[' . date('Y-m-d H:i:s') . '] === VARIANT CREATION COMPLETED SUCCESSFULLY ===' . "\n", 3, $debug_log);
                return true;

            } catch (Exception $e) {
                error_log('[' . date('Y-m-d H:i:s') . '] EXCEPTION: ' . $e->getMessage() . "\n", 3, $debug_log);
                error_log('[' . date('Y-m-d H:i:s') . '] === VARIANT CREATION FAILED ===' . "\n", 3, $debug_log);
                return false;
            }
        }
    }

    //Update function - original
    if ( ! function_exists( 'wc_update_product_variations' ) ) {
        function wc_update_product_variations( $product_id, $product_variations, $parentSku ) {
            global $wpdb;

            $product = wc_get_product( $product_id );
            if ( ! $product || ! is_a( $product, 'WC_Product' ) ) {
                return false;
            }

            // Get all existing variation IDs for this product.
            $variation_ids = $product->get_children();

            // Clear image meta for all variations.
            foreach ( $variation_ids as $variation_id ) {
                $thumbnail_id = get_post_meta( $variation_id, '_thumbnail_id', true );
                $gallery_image_ids = explode( ',', get_post_meta( $variation_id, '_product_image_gallery', true ) );
                if ( $thumbnail_id ) {
                    wp_delete_attachment( $thumbnail_id, true );
                }
                foreach ( $gallery_image_ids as $image_id ) {
                    if ( $image_id ) {
                        wp_delete_attachment( $image_id, true );
                    }
                }
                delete_post_meta( $variation_id, '_thumbnail_id' );
                delete_post_meta( $variation_id, '_product_image_gallery' );
            }

            // Update main product SKU if necessary.
            if ( ! empty( $parentSku ) && $product->get_sku() !== $parentSku ) {
                $product->set_sku( $parentSku );
                $product->save();
            }

            // Remove all existing variations.
            foreach ( $variation_ids as $variation_id ) {
                wp_delete_post( $variation_id, true );
            }

            $parent_attributes = array();
            $all_variants_skipped = true;
            $remove_unavailable_products = get_option( 'ams_remove_unavailable_products' ) === 'Yes';

            foreach ( $product_variations as $variation_index => $variation_data ) {
                
                // Skip variants with zero prices and out of stock if setting is enabled.
                if ( $remove_unavailable_products &&
                    ( empty( $variation_data['regular_price'] ) || floatval( $variation_data['regular_price'] ) == 0 ) &&
                    ( empty( $variation_data['sale_price'] ) || floatval( $variation_data['sale_price'] ) == 0 ) &&
                    ( isset( $variation_data['stock_status'] ) && $variation_data['stock_status'] === 'outofstock' )
                ) {
                    continue;
                }

                $all_variants_skipped = false;
                if ( empty( $variation_data['attributes'] ) ) {
                    continue;
                }

                $variation = new WC_Product_Variation();
                $variation->set_parent_id( $product_id );

                // Set SKU.
                if ( ! empty( $variation_data['sku'] ) ) {
                    $sanitized_sku = sanitize_text_field( $variation_data['sku'] );
                    if ( wc_get_product_id_by_sku( $sanitized_sku ) ) {

                        continue;
                    }
                    $variation->set_sku( $sanitized_sku );
                } else {

                    continue;
                }

                // Set pricing.
                $variation->set_regular_price( $variation_data['regular_price'] );
                if ( ! empty( $variation_data['sale_price'] ) && floatval( $variation_data['sale_price'] ) < floatval( $variation_data['regular_price'] ) ) {
                    $variation->set_sale_price( $variation_data['sale_price'] );
                    $variation->set_price( $variation_data['sale_price'] );
                } else {
                    $variation->set_sale_price( '' );
                    $variation->set_price( $variation_data['regular_price'] );
                }

                // Set stock information.
                if ( isset( $variation_data['stock_qty'] ) && trim( $variation_data['stock_qty'] ) > 0 ) {
                    $variation->set_stock_quantity( $variation_data['stock_qty'] );
                    $variation->set_manage_stock( true );
                    $variation->set_stock_status( $variation_data['stock_status'] );
                } else {
                    $variation->set_manage_stock( false );
                    $variation->set_stock_status( $variation_data['stock_status'] );
                }

                // Set descriptions.
                if ( ! empty( $variation_data['description'] ) ) {
                    $variation->set_description( $variation_data['description'] );
                }
                if ( ! empty( $variation_data['additional_description'] ) ) {
                    $variation->update_meta_data( '_additional_description', $variation_data['additional_description'] );
                }

                // Build an associative array of selected attribute values.
                $selected_attributes = array();
                foreach ( $variation_data['attributes'] as $attr ) {
                    if ( isset( $attr['slug'] ) && isset( $attr['selected'] ) && ! empty( $attr['selected'] ) ) {
                        $selected_attributes[ wc_sanitize_taxonomy_name( $attr['slug'] ) ] = $attr['selected'];
                    }
                }
                if ( empty( $selected_attributes ) ) {

                    continue;
                }

                $variation_attributes = array();
                foreach ( $variation_data['attributes'] as $attribute ) {
                    $attribute_slug = wc_sanitize_taxonomy_name( $attribute['slug'] );
                    $attribute_key  = 'pa_' . $attribute_slug;

                    // Ensure taxonomy exists.
                    if ( ! taxonomy_exists( $attribute_key ) ) {
                        $attribute_id = wc_create_attribute( array(
                            'name'         => wc_clean( $attribute['name'] ),
                            'slug'         => $attribute_slug,
                            'type'         => 'select',
                            'order_by'     => 'menu_order',
                            'has_archives' => false,
                        ) );
                        if ( ! is_wp_error( $attribute_id ) ) {
                            register_taxonomy(
                                $attribute_key,
                                array( 'product' ),
                                array(
                                    'label'        => wc_clean( $attribute['name'] ),
                                    'rewrite'      => array( 'slug' => $attribute_slug ),
                                    'hierarchical' => false,
                                )
                            );
                        }
                    }

                    // Update or create the parent product attribute.
                    if ( ! isset( $parent_attributes[ $attribute_key ] ) ) {
                        $parent_attribute = new WC_Product_Attribute();
                        $parent_attribute->set_id( wc_attribute_taxonomy_id_by_name( $attribute_key ) );
                        $parent_attribute->set_name( $attribute_key );
                        $parent_attribute->set_visible( $attribute['visible'] );
                        $parent_attribute->set_variation( $attribute['variation'] );

                        $options = ( isset( $attribute['options'] ) && is_array( $attribute['options'] ) && ! empty( $attribute['options'] ) )
                            ? $attribute['options']
                            : array( $selected_attributes[ $attribute_slug ] );
                        $term_ids = array();
                        foreach ( $options as $option ) {
                            $term_name = wc_clean( $option );
                            $term = get_term_by( 'name', $term_name, $attribute_key );
                            if ( ! $term ) {
                                $term = wp_insert_term( $term_name, $attribute_key );
                                if ( ! is_wp_error( $term ) ) {
                                    $term = get_term( $term['term_id'], $attribute_key );
                                }
                            }
                            if ( $term && ! is_wp_error( $term ) ) {
                                $term_ids[] = $term->term_id;
                            }
                        }
                        $parent_attribute->set_options( $term_ids );
                        $parent_attributes[ $attribute_key ] = $parent_attribute;
                    } else {
                        // Ensure the existing parent attribute includes the selected value.
                        $existing_options = $parent_attributes[ $attribute_key ]->get_options();
                        $selected_value = $selected_attributes[ $attribute_slug ];
                        $term = get_term_by( 'name', wc_clean( $selected_value ), $attribute_key );
                        if ( ! $term ) {
                            $term = wp_insert_term( wc_clean( $selected_value ), $attribute_key );
                            if ( ! is_wp_error( $term ) ) {
                                $term = get_term( $term['term_id'], $attribute_key );
                            }
                        }
                        if ( $term && ! is_wp_error( $term ) ) {
                            if ( ! in_array( $term->term_id, $existing_options ) ) {
                                $existing_options[] = $term->term_id;
                                $parent_attributes[ $attribute_key ]->set_options( $existing_options );
                            }
                        }
                    }

                    // Use the selected value for this attribute.
                    if ( ! isset( $selected_attributes[ $attribute_slug ] ) ) {

                        continue 2;
                    }
                    $desired_value = $selected_attributes[ $attribute_slug ];

                    // Get allowed options; fallback if missing.
                    $options = ( isset( $attribute['options'] ) && is_array( $attribute['options'] ) && ! empty( $attribute['options'] ) )
                        ? $attribute['options']
                        : array( $desired_value );

                    $found = false;
                    foreach ( $options as $option ) {
                        if ( strcasecmp( $option, $desired_value ) === 0 ) {
                            $found = true;
                            $term_name = wc_clean( $option );
                            break;
                        }
                    }
                    if ( ! $found ) {

                        continue 2;
                    }

                    $term = get_term_by( 'name', $term_name, $attribute_key );
                    if ( $term && ! is_wp_error( $term ) ) {
                        $variation_attributes[ 'attribute_' . $attribute_key ] = $term->slug;
                    }


                }

                // Log computed attributes.

                //     "Setting variation attributes for SKU %s: %s",
                //     $variation_data['sku'],
                //     print_r( $variation_attributes, true )
                // ) );

                $variation->set_attributes( $variation_attributes );
                
                try {
                    $variation->save();
                    // Get new variation ID for images.
                    $new_variation_id = $variation->get_id();
                } catch (Exception $e) {
                    continue;
                }

                // Handle images.
                if ( ! empty( $variation_data['product_image_gallery'] ) ) {
                    $gallery = $variation_data['product_image_gallery'];
                    if ( ! is_array( $gallery ) ) {
                        $gallery = array( $gallery );
                    }
                    $gallery_image_ids = array();
                    $local_gallery_urls = array();
                    $use_remote_images = ( 'Yes' === get_option( 'ams_remote_amazon_images' ) );
                    foreach ( $gallery as $index => $image ) {
                        if ( $use_remote_images ) {
                            $image_ids = attach_product_thumbnail_url( $new_variation_id, $image, ( $index === 0 ? 0 : 1 ) );
                            if ( is_array( $image_ids ) ) {
                                $gallery_image_ids = array_merge( $gallery_image_ids, $image_ids );
                            } elseif ( $image_ids ) {
                                $gallery_image_ids[] = $image_ids;
                            }
                            $local_gallery_urls[] = $image;
                        } else {
                            $local_url = attach_product_thumbnail( $new_variation_id, $image, ( $index === 0 ? 0 : 1 ) );
                            if ( $local_url ) {
                                $local_gallery_urls[] = $local_url;
                                $attach_id = attachment_url_to_postid( $local_url );
                                if ( $attach_id ) {
                                    $gallery_image_ids[] = $attach_id;
                                }
                            }
                        }
                    }
                    if ( ! empty( $gallery_image_ids ) ) {
                        set_post_thumbnail( $new_variation_id, $gallery_image_ids[0] );
                        update_post_meta( $new_variation_id, '_product_image_gallery', implode( ',', array_unique( $gallery_image_ids ) ) );
                    }
                }
            }

            if ( $all_variants_skipped && $remove_unavailable_products ) {
                wp_delete_post( $product_id, true );

                return new WP_Error( 'all_variants_skipped', esc_html__( "OutOfStock!", 'ams-wc-amazon' ) );
            }

            // Preserve existing brand attribute.
            $existing_attributes = $product->get_attributes();
            foreach ( $existing_attributes as $attribute_name => $attribute_value ) {
                if ( strtolower( $attribute_name ) === 'brand' && ! isset( $parent_attributes['brand'] ) ) {
                    $parent_attributes['brand'] = $attribute_value;
                }
            }

            $product->set_attributes( array_values( $parent_attributes ) );
            $product->save();

            wc_delete_product_transients( $product_id );
            // Optionally flush rewrite rules only if needed
            // flush_rewrite_rules();

            return true;
        }
    }

    function extractAsinFromUrl($url) {
        // Extract ASIN from Amazon URL
        if (preg_match('/\/dp\/([A-Z0-9]{10})/', $url, $matches)) {
            return $matches[1];
        }
        return null;
    }

    function generate_amazon_url_1($product_url, $variation_id, $use_th = false) {
        // Construct the URL for the variation:
        $base_url = get_parsed_url($product_url, 'PHP_URL_BASE');
        $parent_asin = extractAsinFromUrl($product_url);
        
        if (strpos($variation_id, '#') !== false) {
            list($custom_token, $custom_id) = explode('#', $variation_id);
            $base_url .= "/dp/{$custom_id}?customId={$custom_id}&customizationToken=" . urlencode($variation_id) . "&th=1&psc=1";

        } else if ($parent_asin && $variation_id !== $parent_asin) {
            // Use direct variation ASIN for reliable pricing
            // This ensures we get the actual variation's specific page and pricing
            $base_url .= '/dp/' . $variation_id . '/?th=1&psc=1';

        } else {
            // For same ASIN or no parent, use standard format
            $base_url .= '/dp/' . $variation_id . '/?th=1&psc=1';

        }
        return $base_url;
    }

    function generate_amazon_url_2($product_url, $variation_id) {

        // Extract the base domain
        $base_url = get_parsed_url($product_url, 'PHP_URL_BASE');
        $parent_asin = extractAsinFromUrl($product_url);

        if ($parent_asin && $variation_id !== $parent_asin) {
            // Try modern format as fallback - may provide better variation-specific pricing
            // This approach uses parent ASIN with variation parameters
            $base_url .= "/dp/{$parent_asin}?customId={$variation_id}&customizationToken=MC_Assembly_1%23{$variation_id}&th=1&psc=1";

        } else {
            // For same ASIN or no parent, use standard format
            $base_url .= "/dp/{$variation_id}/?th=1&psc=1";

        }

        return $base_url;
    }

    function get_parsed_url($url, $part = 'PHP_URL_FULL') {
        $parse = parse_url($url);
        
        switch ($part) {
            case 'PHP_URL_FULL':
                $formatted = $parse['scheme'] . '://' . $parse['host'];
                if (isset($parse['path'])) {
                    $formatted .= $parse['path'];
                }
                if (isset($parse['query'])) {
                    $formatted .= '?' . $parse['query'];
                }
                break;
            case 'PHP_URL_BASE':
                $formatted = $parse['scheme'] . '://' . $parse['host'];
                break;
            default:
                $formatted = '';
        }
        
        // Check for empty string then return false
        if ($formatted == '') return FALSE;
        return $formatted;
    }

function generate_unique_sku($base_sku, $product_id) {
    $counter = 1;
    $new_sku = $base_sku;
    while (wc_get_product_id_by_sku($new_sku)) {
        $new_sku = $base_sku . '-' . $counter;
        $counter++;
    }
    return $new_sku;
}

function get_variation_by_sku($sku, $parentSku) {
    global $wpdb;
    
    $query = $wpdb->prepare(
        "SELECT p.ID 
        FROM {$wpdb->posts} p
        JOIN {$wpdb->postmeta} pm ON p.ID = pm.post_id
        WHERE pm.meta_key = '_sku' 
        AND pm.meta_value = %s
        AND p.post_type = 'product_variation'
        AND p.ID NOT IN (
            SELECT post_id 
            FROM {$wpdb->postmeta} 
            WHERE meta_key = '_sku' AND meta_value = %s
        )
        LIMIT 1",
        $sku,
        $parentSku
    );
    
    $variation_id = $wpdb->get_var($query);
    
    if ($variation_id) {
        return wc_get_product($variation_id);
    }
    
    return null;
}
//wf
function wc_update_product_attributes( $product_id, $attributes_data ) {
    if( empty($attributes_data) || !is_array($attributes_data) ) {
        error_log("No valid attributes data provided for product ID: $product_id");
        return false;
    }

    $attributes = array();
    foreach( $attributes_data as $key => $attribute_array ) {
        if( isset($attribute_array['name']) && isset($attribute_array['options']) ){
            $attribute_name = wc_clean( $attribute_array['name'] );
            $attribute_slug = !empty($attribute_array['slug']) ? wc_sanitize_taxonomy_name( $attribute_array['slug'] ) : wc_sanitize_taxonomy_name( $attribute_name );
            $taxonomy = 'pa_' . $attribute_slug;

            if( ! taxonomy_exists( $taxonomy ) ) {
                $attribute_id = wc_create_attribute( array('name' => $attribute_name, 'slug' => $attribute_slug) );
                if ( is_wp_error( $attribute_id ) ) {
                    error_log("Failed to create attribute: " . $attribute_id->get_error_message());
                    continue;
                }
                register_taxonomy(
                    $taxonomy,
                    apply_filters( 'woocommerce_taxonomy_objects_' . $taxonomy, array( 'product' ) ),
                    apply_filters( 'woocommerce_taxonomy_args_' . $taxonomy, array(
                        'labels'       => array('name' => $attribute_name),
                        'hierarchical' => true,
                        'show_ui'      => false,
                        'query_var'    => true,
                        'rewrite'      => false,
                    ) )
                );
                delete_transient( 'wc_attribute_taxonomies' );
            }

            $option_term_ids = array();
            foreach( $attribute_array['options'] as $option ) {
                $option = wc_clean( $option );

                // Check if term exists or insert a new term
                $term = term_exists( $option, $taxonomy );
                if ( !$term ) {
                    $term = wp_insert_term( $option, $taxonomy );
                }

                // Handle errors
                if ( is_wp_error( $term ) ) {
                    error_log("Failed to insert term: " . $term->get_error_message());
                    continue;
                }

                // Ensure term exists and get the term_id
                if ( is_array( $term ) ) {
                    $term_id = $term['term_id'];
                } elseif ( is_object( $term ) && property_exists( $term, 'term_id' ) ) {
                    $term_id = $term->term_id;
                } else {
                    error_log("Unexpected term format for option: $option in taxonomy: $taxonomy");
                    continue;
                }

                // Assign term to the product
                wp_set_object_terms( $product_id, $term_id, $taxonomy, true );
                $option_term_ids[] = $term_id;
            }
            
            $attribute = new WC_Product_Attribute();
            $attribute->set_name( $taxonomy );
            $attribute->set_options( $option_term_ids );
            $attribute->set_visible( isset($attribute_array['visible']) ? wc_string_to_bool($attribute_array['visible']) : false );
            $attribute->set_variation( isset($attribute_array['variation']) ? wc_string_to_bool($attribute_array['variation']) : false );
            
            $attribute_id = wc_attribute_taxonomy_id_by_name( $taxonomy );
            $attribute->set_id( $attribute_id );

            $attributes[$taxonomy] = $attribute;
        }
    }

    $product = wc_get_product( $product_id );
    $product->set_attributes( $attributes );
    $save_result = $product->save();

    if ( is_wp_error( $save_result ) ) {
        error_log("Failed to save product attributes: " . $save_result->get_error_message());
        return false;
    }

    return true;
}


add_filter('woocommerce_available_variation', 'bbloomer_add_price_variation_data');
function bbloomer_add_price_variation_data($variations) {
    $variation = wc_get_product($variations['variation_id']);

    if ($variation) {
        // Regular price
        $regular_price = $variation->get_regular_price();
        $variations['formatted_regular_price'] = '<div class="woocommerce_regular_price">Regular Price: <span>' . wc_price($regular_price) . '</span></div>';

        // Sale price (if applicable)
        if ($variation->is_on_sale()) {
            $sale_price = $variation->get_sale_price();
            $variations['formatted_sale_price'] = '<div class="woocommerce_sale_price">Sale Price: <span>' . wc_price($sale_price) . '</span></div>';
        }

        // Keep the additional information
        $additional_info = get_post_meta($variations['variation_id'], '_ams_additional_information', true);
        $variations['_ams_additional_information'] = '<div class="ams_wc_additional_information">' . $additional_info . '</div>';
    }

    return $variations;
}

/* END OF ADMIN STUFF */

// Update variation price display area in single product page
add_action('woocommerce_variable_add_to_cart', 'bbloomer_update_price_with_variation_price');
function bbloomer_update_price_with_variation_price() {
    global $product;
    if ('variable' !== $product->get_type()) {
        return;
    }
    $price = $product->get_price_html();
    $ams_additional_information = get_post_meta($product->get_id(), '_ams_additional_information', true);
    $ams_additional_information = wp_kses_post($ams_additional_information);

    $variations_data = array();
    foreach ($product->get_available_variations() as $variation) {
        $variation_id = $variation['variation_id'];
        $variation_obj = wc_get_product($variation_id);
        $variation_info = get_post_meta($variation_id, '_ams_additional_information', true);
        
        if (!$variation_info) {
            $variation_info = $ams_additional_information;
            
            // Modify size information
            $size = $variation['attributes']['attribute_pa_size'] ?? '';
            if ($size) {
                $variation_info = preg_replace(
                    '/(Taille<\/span><\/td><td><span>).*?(<\/span>)/',
                    '$1Taille ' . strtoupper($size) . '$2',
                    $variation_info
                );
            }
            
            // Modify unit count
            $unit_count = $variation_obj->get_stock_quantity();
            if ($unit_count) {
                $variation_info = preg_replace(
                    '/(Nombre d\'unités<\/span><\/td><td><span>).*?(<\/span>)/',
                    '$1' . $unit_count . ' unité' . ($unit_count > 1 ? 's' : '') . '$2',
                    $variation_info
                );
            }
        }
        
        $variations_data[$variation_id] = wp_kses_post($variation_info);
        
        // Debug output
        // echo "Variant ID: $variation_id<br>";
        // echo "Content: " . esc_html($variation_info) . "<br><br>";
    }

    wc_enqueue_js("
        var variationsData = " . json_encode($variations_data, JSON_HEX_APOS | JSON_HEX_QUOT | JSON_HEX_TAG | JSON_HEX_AMP) . ";
        var defaultInfo = " . json_encode($ams_additional_information, JSON_HEX_APOS | JSON_HEX_QUOT | JSON_HEX_TAG | JSON_HEX_AMP) . ";
        
        function updateAdditionalInfo(content) {
            var infoDiv = document.getElementById('ams-additional-information');
            if (!infoDiv) {
                infoDiv = document.createElement('div');
                infoDiv.id = 'ams-additional-information';
                document.querySelector('.summary').appendChild(infoDiv);
            }
            infoDiv.innerHTML = content;
        }
        
        jQuery(document).ready(function() {
            updateAdditionalInfo(defaultInfo);
        });
        
        jQuery(document).on('found_variation', 'form.variations_form', function(event, variation) {
            if(variation.price_html) jQuery('.summary > p.price').html(variation.price_html);
            if(variationsData[variation.variation_id]) updateAdditionalInfo(variationsData[variation.variation_id]);
        });
        
        jQuery(document).on('reset_data', 'form.variations_form', function() {
            jQuery('.summary > p.price').html(" . json_encode($price) . ");
            updateAdditionalInfo(defaultInfo);
        });
    ");

    // Debug: Print out the final variations data
    // echo "<pre>";
    // print_r($variations_data);
    // echo "</pre>";
}


// Remove reset link from single page
add_filter( 'woocommerce_reset_variations_link', '__return_empty_string', 9999 );
function buildPriceHtml( $from, $to = '' ) {
    if( !empty($from) && !empty($to) ) {
        return sprintf("<del aria-hidden=\"true\"><span class=\"woocommerce-Price-amount amount\"><bdi>%s</bdi></span></del><ins><span class=\"woocommerce-Price-amount amount\"><bdi>%s</bdi></span></ins>",$from,$to);
    } else if( !empty($from) ) {
        return sprintf("<span class=\"woocommerce-Price-amount amount\"><bdi>%s</bdi></span>",$from);
    } else {
        return sprintf("<span class=\"woocommerce-Price-amount amount\"><bdi>%s</bdi></span>",$to);
    }
}

function buildVariationPriceHtml( $min, $max = '' ) {
    if( !empty($min) && !empty($max) ) {
        return sprintf("<span class=\"woocommerce-Price-amount amount\"><bdi>%s</bdi></span> – <span class=\"woocommerce-Price-amount amount\"><bdi>%s</bdi></span>",$min,$max);
    } else if( !empty($min) ){
        return sprintf("<span class=\"woocommerce-Price-amount amount\"><bdi>%s</bdi></span>",$min);
    } else {
        return sprintf("<span class=\"woocommerce-Price-amount amount\"><bdi>%s</bdi></span>",$max);
    }
}

if (!function_exists('dd')) {
    function dd($d) {
        echo '<pre>';
        print_r($d);
        echo '</pre>';
    }
}

function wc_plugin_styles() { ?>
<style>.woocommerce-variation-add-to-cart-disabled {display:none; !important;} body.single-product .woocommerce .woocommerce-tabs .woocommerce-Tabs-panel h2, .woocommerce .woocommerce-tabs .woocommerce-Tabs-panel h2 { display: none !important; }</style>
<?php }
add_action('wp_head','wc_plugin_styles');

function ams_script_to_footer() {    
    wc_enqueue_js("
    jQuery(document).ready(function($){
      if( $('#tab-description #aplus_feature_div img').length > 0 ) {
        $('#tab-description #aplus_feature_div img').each(function(index, image) {
          if( $(this).data('src') ) {
            $(this).attr('src', $(this).data('src'));
          }
        });
      }
      if( $('#tab-description .aplus-v2 img').length > 0 ) {
        $('#tab-description .aplus-v2 img').each(function(index, image) {
          if( $(this).data('src') ) {
            $(this).attr('src', $(this).data('src'));
          }
        });
      }      
    });
    ");
}
add_action('wp_footer', 'ams_script_to_footer');
add_filter( 'wc_product_enable_dimensions_display', '__return_true' );


// Add Import method field
add_action( 'woocommerce_product_options_stock_status', 'display_product_options_inventory_custom_fields', 20 );
function display_product_options_inventory_custom_fields() {
    global $post;

    echo '</div><div class="options_group">'; // New separated section

    // Check if the post has a specific meta value
    $specific_meta_value = get_post_meta( $post->ID, '_import_method', true );
    if ( $specific_meta_value ) {

        $import_method = '';
        switch(get_post_meta( $post->ID, '_import_method', true )) {
            case '1':
                $import_method = 'AMAZON API';
                break;
            case '2':
                $import_method = 'NO API - BY SEARCH';
                break;
            case '3':
                $import_method = 'NO API - BY URLS';
                break;
        }

        woocommerce_wp_text_input(
            array(
                'id'          => '_import_method',
                'label'       => __( 'Import method', 'woocommerce' ),
                'placeholder' => '',
                'desc_tip'    => 'true',
                'description' => __( 'Enter a import method.', 'woocommerce' ),
                'value'       => $import_method,
                'custom_attributes'    => array('disabled' => 'disabled', 'readonly' => 'readonly'),
            )
        );

        // Get the actual Amazon URL for this product first
        $amazon_url = get_post_meta($post->ID, '_ams_product_url', true);
        if (empty($amazon_url)) {
            $amazon_url = get_post_meta($post->ID, '_detail_page_url', true);
        }
        
        // Show Amazon Country/Region - PRIORITIZE URL over stored region
        $amazon_country = 'Not Available';
        
        // PRIMARY: Extract country from actual Amazon URL (most reliable)
        if (!empty($amazon_url)) {
            if (preg_match('/amazon\.([a-z\.]+)/', $amazon_url, $matches)) {
                $url_domain = $matches[1];
                
                // Map domains to countries with flags
                $domain_to_country = array(
                    'com' => '🇺🇸 United States',
                    'co.uk' => '🇬🇧 United Kingdom', 
                    'de' => '🇩🇪 Germany',
                    'fr' => '🇫🇷 France',
                    'it' => '🇮🇹 Italy',
                    'es' => '🇪🇸 Spain',
                    'ca' => '🇨🇦 Canada',
                    'com.au' => '🇦🇺 Australia',
                    'co.jp' => '🇯🇵 Japan',
                    'com.br' => '🇧🇷 Brazil',
                    'com.mx' => '🇲🇽 Mexico',
                    'in' => '🇮🇳 India',
                    'nl' => '🇳🇱 Netherlands',
                    'se' => '🇸🇪 Sweden',
                    'pl' => '🇵🇱 Poland',
                    'com.tr' => '🇹🇷 Turkey',
                    'ae' => '🇦🇪 UAE',
                    'sa' => '🇸🇦 Saudi Arabia',
                    'sg' => '🇸🇬 Singapore'
                );
                
                if (isset($domain_to_country[$url_domain])) {
                    $amazon_country = $domain_to_country[$url_domain] . ' (amazon.' . $url_domain . ')';
                }
            }
        }
        
        // FALLBACK: Use stored region data if URL extraction failed
        if ($amazon_country === 'Not Available') {
            $product_region = get_post_meta($post->ID, '_region', true);
            
            if (!empty($product_region)) {
                $regions = ams_get_amazon_regions();
                $locale_key = '';
                $region_name = '';
                
                // Check if it's a locale key or RegionCode
                if (isset($regions[$product_region])) {
                    $locale_key = $product_region;
                    $region_name = $regions[$product_region]['RegionName'];
                } else {
                    // Search by RegionCode
                    foreach ($regions as $locale => $region_data) {
                        if ($region_data['RegionCode'] === $product_region) {
                            $locale_key = $locale;
                            $region_name = $region_data['RegionName'];
                            break;
                        }
                    }
                }
                
                if (!empty($locale_key) && !empty($region_name)) {
                    $flags = array(
                        'com.au' => '🇦🇺', 'com.br' => '🇧🇷', 'ca' => '🇨🇦', 'cn' => '🇨🇳',
                        'fr' => '🇫🇷', 'de' => '🇩🇪', 'in' => '🇮🇳', 'it' => '🇮🇹',
                        'jp' => '🇯🇵', 'mx' => '🇲🇽', 'nl' => '🇳🇱', 'pl' => '🇵🇱',
                        'sg' => '🇸🇬', 'sa' => '🇸🇦', 'se' => '🇸🇪', 'tr' => '🇹🇷',
                        'ae' => '🇦🇪', 'co.uk' => '🇬🇧', 'com' => '🇺🇸', 'es' => '🇪🇸'
                    );
                    
                    $country_flag = isset($flags[$locale_key]) ? $flags[$locale_key] . ' ' : '';
                    $amazon_country = $country_flag . $region_name . ' (amazon.' . $locale_key . ')';
                }
            }
        }
        
        // Always show the country field first
        woocommerce_wp_text_input(
            array(
                'id'          => '_amazon_country',
                'label'       => __( 'Amazon Country', 'ams-wc-amazon' ),
                'placeholder' => '',
                'desc_tip'    => 'true',
                'description' => __( 'The Amazon country store where this product was imported from.', 'ams-wc-amazon' ),
                'value'       => $amazon_country,
                'custom_attributes'    => array('disabled' => 'disabled', 'readonly' => 'readonly'),
            )
        );
        
        // Add clickable link if URL exists
        if (!empty($amazon_url)) {
            echo '<p class="form-field">';
            echo '<label>&nbsp;</label>'; // Empty label for alignment
            echo '<a href="' . esc_url($amazon_url) . '" target="_blank" class="button button-secondary">';
            echo '<span class="dashicons dashicons-external" style="font-size: 16px; line-height: 1; margin-right: 5px; vertical-align: middle;"></span>';
            echo __('Open Amazon Page', 'ams-wc-amazon');
            echo '</a>';
            echo '<span class="description" style="margin-left: 10px;">' . __('Click to open the original Amazon product page', 'ams-wc-amazon') . '</span>';
            echo '</p>';
        }

        echo '<div class="ams-replace-product-section" style="margin-top: 20px; padding: 0; background: #fff; border: 1px solid #c3c4c7; border-radius: 6px; overflow: hidden;">';
        
        // Header
        echo '<div style="background: linear-gradient(135deg, #2271b1 0%, #1e5a8a 100%); color: white; padding: 12px 16px; margin: 0;">';
        echo '<div style="display: flex; align-items: center; gap: 8px;">';
        echo '<span class="dashicons dashicons-update" style="font-size: 18px;"></span>';
        echo '<h4 style="margin: 0; font-size: 14px; font-weight: 600;">' . __('Replace with Different Amazon Product', 'ams-wc-amazon') . '</h4>';
        echo '</div>';
        echo '<p style="margin: 4px 0 0 0; font-size: 12px; opacity: 0.9;">' . __('Update this product with data from a different Amazon listing', 'ams-wc-amazon') . '</p>';
        echo '</div>';
        
        // Content
        echo '<div style="padding: 20px;">';
        
        // Step 1: Input
        echo '<div class="ams-step" style="margin-bottom: 20px;">';
        echo '<div style="display: flex; align-items: center; gap: 8px; margin-bottom: 12px;">';
        echo '<span style="background: #2271b1; color: white; width: 20px; height: 20px; border-radius: 50%; display: flex; align-items: center; justify-content: center; font-size: 11px; font-weight: bold;">1</span>';
        echo '<strong style="color: #1d2327; font-size: 13px;">' . __('Enter New Amazon Product', 'ams-wc-amazon') . '</strong>';
        echo '</div>';
        
        woocommerce_wp_text_input(
            array(
                'id'          => '_ams_new_asin_replace',
                'label'       => '',
                'placeholder' => 'https://amazon.com/dp/B0DTW26PXY or B0DTW26PXY',
                'custom_attributes' => array(
                    'style' => 'width: 100%; font-size: 14px; padding: 10px;'
                )
            )
        );
        
        echo '<div style="display: flex; gap: 15px; margin-top: 8px; font-size: 12px; color: #646970;">';
        echo '<div><span class="dashicons dashicons-admin-links" style="font-size: 14px; vertical-align: middle;"></span> ' . __('Paste full Amazon URL', 'ams-wc-amazon') . '</div>';
        echo '<div><span class="dashicons dashicons-products" style="font-size: 14px; vertical-align: middle;"></span> ' . __('Or enter ASIN only', 'ams-wc-amazon') . '</div>';
        echo '</div>';
        echo '</div>';
        
        // Auto-detection box
        echo '<div id="ams_auto_detected" style="margin-bottom: 20px; padding: 12px; background: #f0f6fc; border-left: 4px solid #2271b1; border-radius: 4px; display: none;">';
        echo '<div style="display: flex; align-items: center; gap: 8px; margin-bottom: 4px;">';
        echo '<span class="dashicons dashicons-yes-alt" style="color: #00a32a; font-size: 16px;"></span>';
        echo '<strong style="color: #1d2327; font-size: 13px;">' . __('Product Detected', 'ams-wc-amazon') . '</strong>';
        echo '</div>';
        echo '<div style="font-size: 12px; color: #646970;">';
        echo '<span id="ams_detected_country"></span> • <span id="ams_detected_asin"></span>';
        echo '</div>';
        echo '</div>';
        
        // Step 2: Action
        echo '<div class="ams-step">';
        echo '<div style="display: flex; align-items: center; gap: 8px; margin-bottom: 12px;">';
        echo '<span style="background: #2271b1; color: white; width: 20px; height: 20px; border-radius: 50%; display: flex; align-items: center; justify-content: center; font-size: 11px; font-weight: bold;">2</span>';
        echo '<strong style="color: #1d2327; font-size: 13px;">' . __('Replace Product Data', 'ams-wc-amazon') . '</strong>';
        echo '</div>';
        
        echo '<div style="display: flex; align-items: center; gap: 12px;">';
        echo '<button type="button" id="ams_replace_product_btn" class="button button-primary" style="background: #00a32a; border-color: #00a32a; padding: 8px 16px; font-weight: 600;">';
        echo '<span class="dashicons dashicons-update" style="font-size: 16px; vertical-align: middle; margin-right: 6px;"></span>';
        echo __('Replace Product', 'ams-wc-amazon');
        echo '</button>';
        echo '<span id="ams_replace_status"></span>';
        echo '</div>';
        echo '</div>';
        
        // Info box
        echo '<div style="margin-top: 20px; padding: 12px; background: #fff8e1; border: 1px solid #ffc107; border-radius: 4px;">';
        echo '<div style="display: flex; align-items: flex-start; gap: 8px;">';
        echo '<span class="dashicons dashicons-info" style="color: #f57c00; font-size: 16px; margin-top: 1px;"></span>';
        echo '<div style="font-size: 12px; color: #1d2327; line-height: 1.4;">';
        echo '<strong>' . __('What happens:', 'ams-wc-amazon') . '</strong><br>';
        echo __('• Product title, description, images, and price will be updated', 'ams-wc-amazon') . '<br>';
        echo __('• WordPress URL stays the same (SEO-friendly)', 'ams-wc-amazon') . '<br>';
        echo __('• Must be from the same Amazon marketplace', 'ams-wc-amazon');
        echo '</div>';
        echo '</div>';
        echo '</div>';
        
        echo '</div>'; // Close content
        echo '</div>'; // Close section

        echo '<script type="text/javascript">
        jQuery(document).ready(function($) {
            
            // Smart URL/ASIN parser (using same logic as Import by URL page)
            function parseAmazonInput(input) {
                input = input.trim();
                
                // Country flags mapping
                var countryFlags = {
                    "com.au": "🇦🇺 Australia", "com.br": "🇧🇷 Brazil", "ca": "🇨🇦 Canada", 
                    "cn": "🇨🇳 China", "fr": "🇫🇷 France", "de": "🇩🇪 Germany", 
                    "in": "🇮🇳 India", "it": "🇮🇹 Italy", "jp": "🇯🇵 Japan", 
                    "mx": "🇲🇽 Mexico", "nl": "🇳🇱 Netherlands", "pl": "🇵🇱 Poland",
                    "sg": "🇸🇬 Singapore", "sa": "🇸🇦 Saudi Arabia", "se": "🇸🇪 Sweden", 
                    "tr": "🇹🇷 Turkey", "ae": "🇦🇪 UAE", "co.uk": "🇬🇧 United Kingdom", 
                    "com": "🇺🇸 United States", "es": "🇪🇸 Spain"
                };
                
                // Check if it\'s just an ASIN (B followed by 9 alphanumeric characters)
                var asinPattern = /^B[0-9A-Z]{9}$/;
                if (asinPattern.test(input)) {
                    return {
                        asin: input,
                        country: null,
                        isUrl: false
                    };
                }
                
                // Use the same Amazon URL parsing logic as Import by URL page
                var amazonMatch = input.match(/https?:\/\/(www\.)?amazon\.([a-z.]{2,6}).*?\/dp\/([A-Z0-9]{10})/i);
                if (amazonMatch) {
                    var fullDomain = amazonMatch[2];
                    var asin = amazonMatch[3];
                    
                    return {
                        asin: asin,
                        country: fullDomain,
                        countryName: countryFlags[fullDomain] || fullDomain.toUpperCase(),
                        isUrl: true,
                        cleanUrl: "https://www.amazon." + fullDomain + "/dp/" + asin
                    };
                }
                
                return null;
            }
            
            // Real-time input parsing
            $("#_ams_new_asin_replace").on("input", function() {
                var input = $(this).val();
                var parsed = parseAmazonInput(input);
                var $detected = $("#ams_auto_detected");
                
                if (parsed && parsed.isUrl) {
                    $("#ams_detected_country").text(parsed.countryName + " (amazon." + parsed.country + ")");
                    $("#ams_detected_asin").text("ASIN: " + parsed.asin);
                    $detected.show();
                    
                    // Auto-clean the URL in the input field (like Import by URL page)
                    if (parsed.cleanUrl && input !== parsed.cleanUrl) {
                        $(this).val(parsed.cleanUrl);
                    }
                } else if (parsed && !parsed.isUrl) {
                    $("#ams_detected_country").text("Current plugin settings");
                    $("#ams_detected_asin").text("ASIN: " + parsed.asin);
                    $detected.show();
                } else {
                    $detected.hide();
                }
            });

            $("#ams_replace_product_btn").on("click", function(e) {
                e.preventDefault();
                
                var input = $("#_ams_new_asin_replace").val().trim();
                var productId = ' . $post->ID . ';
                var $button = $(this);
                var $status = $("#ams_replace_status");
                
                if (!input) {
                    $status.html("<span style=\"color: #d63638;\">⚠️ Please enter an Amazon URL or ASIN</span>");
                    return;
                }
                
                // Parse the input
                var parsed = parseAmazonInput(input);
                if (!parsed || !parsed.asin) {
                    $status.html("<span style=\"color: #d63638;\">⚠️ Invalid Amazon URL or ASIN format</span>");
                    return;
                }
                
                var newAsin = parsed.asin;
                var targetCountry = parsed.country; // null if ASIN-only
                
                $button.prop("disabled", true);
                $status.html("<span style=\"color: #2271b1;\">🔄 Processing replacement...</span>");
                
                $.ajax({
                    url: ajaxurl,
                    type: "POST",
                    data: {
                        action: "ams_replace_product",
                        product_id: productId,
                        new_asin: newAsin,
                        target_country: targetCountry,
                        nonce: "' . wp_create_nonce('ams_replace_product_nonce') . '"
                    },
                    success: function(response) {
                        if (response.success) {
                            $status.html("<span style=\"color: #00a32a;\">✅ " + response.data.message + "</span>");
                            setTimeout(function() {
                                location.reload();
                            }, 2000);
                        } else {
                            $status.html("<span style=\"color: #d63638;\">❌ " + response.data.message + "</span>");
                        }
                    },
                    error: function(xhr, status, error) {
                        console.log("AMS AJAX Error:", xhr, status, error);
                        console.log("Response Text:", xhr.responseText);
                        var errorMsg = "Network error occurred";
                        if (xhr.status === 0) {
                            errorMsg = "Connection failed - check internet connection";
                        } else if (xhr.status === 403) {
                            errorMsg = "Permission denied - check user permissions";
                        } else if (xhr.status === 404) {
                            errorMsg = "AJAX endpoint not found";
                        } else if (xhr.status === 500) {
                            errorMsg = "Server error - check PHP error logs";
                        } else if (xhr.responseText) {
                            errorMsg = "Server error: " + xhr.responseText.substring(0, 100);
                        }
                        $status.html("<span style=\"color: #d63638;\">❌ " + errorMsg + "</span>");
                    },
                    complete: function() {
                        $button.prop("disabled", false);
                    }
                });
            });
        });
        </script>';
    }
}

/**
 * Check if curl status returns not found we have to mark the existing product status
 * to be out of stock so that when we run cron for atuo clean/remove it will be deleted
 * according to the configuration setting saved
 * 
 * @param string $productUrl
 * @param object $curl
 * 
 * @return boolean
 * 
 */
function updateProductStatusIfNotExists($ch, $productUrl) {
    // Get the response code
    $responseCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    if ($responseCode == 404) {
        $sku = getSkuFromUrl($productUrl);
        $product = get_product_by_sku($sku);
        // Check If product is null or not found
        if (!$product || is_null($product)) {
            return false;
        }
        // Check If given setting exists
        if ("No" == get_option("ams_remove_unavailable_products")) {
            return false;
        }
        // Set product stock quantity to zero and stock status to out of stock
        $product->set_stock_quantity(0);
        $product->set_stock_status('outofstock');
        // Save the data and refresh caches
        $product->save();
        return true;
    }
    return false;
}

function removeProductIfNotExists($post_id) {
    $product = wc_get_product($post_id);
    
    // Check If product is null or not found
    if (!$product || is_null($product)) {
        return;
    }
    
    // Check If given setting exists
    if ("No" == get_option("ams_remove_unavailable_products")) {
        return;
    }
    
    // Product name
    $title = $product->get_name();
    
    // Handle variable products
    if ($product->is_type('variable')) {
        foreach ($product->get_children() as $childID) {
            $child = wc_get_product($childID);
            if ($child && !$child->is_in_stock()) {
                $child->delete(true); // Delete permanently.
            }
        }
    }
    
    // Save the data and refresh caches
    $product->save();
    
    // Refresh product object
    $_product = wc_get_product($post_id);
    
    // Delete the product if it's out of stock (works for both simple and variable products)
    if ($_product && !$_product->is_in_stock()) {
        $_product->delete(true); // Delete permanently.
    }
}


/**
 * This function will help you to get the SKU/ASIN number from URL
 * 
 * @param string $url
 * @return string
 *  
 */
function getSkuFromUrl($url) {
    $path = parse_url($url, PHP_URL_PATH);
    if ($path === null) {
        return null; // Return null if URL is malformed
    }

    $segments = explode("/dp/", $path);
    if (count($segments) < 2) {
        return null; // Return null if URL does not contain "/dp/"
    }

    $asinSegment = end($segments);
    $asinParts = explode('/', $asinSegment);
    
    return $asinParts[0] ?? null; // Return the ASIN or null if not found
}


/**
 * Count String limit
 * 
 * @param $string
 * @param $limit
 * @param $append
 * 
 * @return string
 */

if ( !function_exists('wp_str_limit') ) {
    function wp_str_limit($string, $limit, $append = '...') {
        if (strlen($string) > $limit) {
            $string = substr($string, 0, $limit) . $append;
        }
        return $string;
    }
}

/**
 * Add dropshipping fee
 * 
 * @param $displayPrice
 * 
 * @return string
 */

 if ( !function_exists('wp_add_dropshipping_fee') ) {
    function wp_add_dropshipping_fee( $displayPrice ) {
        if( empty( $price ) ) {
            return $displayPrice;
        }

        // Extract currency symbol
        preg_match( '/([^\d., ]+)/', $displayPrice, $matches );
        $currencySymbol = $matches[0];

        // Get the currency position
        $before_the_price = false;
        $firstCharacter = substr( $displayPrice, 0, 1 );
        $lastCharacter = substr( $displayPrice, -1 );
        
        if ( is_numeric($firstCharacter) ) {
            $before_the_price = false;
        } elseif (is_numeric($lastCharacter)) {
            $before_the_price = true;
        }

        // Add dropshipping fee
        $price = (float) $displayPrice;
        $percentage_profit = (float) get_option('ams_percentage_profit');
        if( strtolower(get_option('ams_buy_action_btn')) === strtolower('dropship') ) {
            if( !empty( $price ) ) {
                $profit = ( $price / 100 ) * $percentage_profit;
                $price = $price + $profit;
            }
        }

        // Return updated price
        return $before_the_price 
            ? ( $currencySymbol .''. $price ) 
            : ( $price .''. $currencySymbol );
    }
}



function get_amazon_api_details() {
    // Implement this function to return Amazon API details
    // This is just a placeholder. Replace with actual data retrieval.
    return [
        'last_request' => date('Y-m-d H:i:s', strtotime('-2 minutes')),
        'avg_daily_usage' => 1234
    ];
}
function get_scraper_api_details() {
    // Implement this function to return Scraper API details
    // This is just a placeholder. Replace with actual data retrieval.
    return [
        'last_request' => date('Y-m-d H:i:s', strtotime('-5 minutes')),
        'avg_daily_usage' => 567
    ];
}

function get_scrapingant_api_details() {
    // Implement this function to return Scrapingant API details
    // This is just a placeholder. Replace with actual data retrieval.
    return [
        'last_request' => date('Y-m-d H:i:s', strtotime('-10 minutes')),
        'avg_daily_usage' => 789
    ];
}


/**
 * Get the available scraping services configuration with dynamic values.
 * 
 * @return array
 */
function get_scraping_services_config() {
    return array(
        'scrapingant' => array(
            'api_key'    => get_option('ams_scrapingant_api_key', ''),
            'is_active'  => get_option('ams_scrapingant_is_active', '0') === '1',
            'on_update'  => get_option('ams_scrapingant_on_update', '0') === '1',
            'execute'    => 'executeScrapingAntAPI',
        ),
        'scraperapi' => array(
            'api_key'    => get_option('ams_scraper_api_key', ''),
            'is_active'  => get_option('ams_scraper_api_is_active', '0') === '1',
            'on_update'  => get_option('ams_scraper_api_on_update', '0') === '1',
            'execute'    => 'executeScraperAPI',
        ),
        'decodo' => array(
            'auth_token' => get_option('ams_decodo_auth_token', ''),
            'is_active'  => get_option('ams_decodo_is_active', '0') === '1',
            'on_update'  => get_option('ams_decodo_on_update', '0') === '1',
            'execute'    => 'executeDecodoAPI',
        ),
    );
}

/**
 * Centralized Scraping Service Manager
 * Handles all scraping services with priority ordering and fallback logic
 */
class ScrapingServiceManager {
    private static $instance = null;
    private $services = [];
    private $service_health = [];
    
    public static function getInstance() {
        if (self::$instance === null) {
            self::$instance = new self();
        }
        return self::$instance;
    }
    
    private function __construct() {
        $this->initializeServices();
    }
    
    private function initializeServices() {
        $this->services = $this->getServicesWithPriority();
        $this->service_health = get_option('ams_scraping_service_health', []);
    }
    
    private function getServicesWithPriority() {
        $services = [];
        
        $scraperapi_priority = get_option('ams_scraperapi_priority', 1);
        $scrapingant_priority = get_option('ams_scrapingant_priority', 2);
        // $zyte_priority = get_option('zyte_priority', 3); // Removed - replaced with Decodo
        
        if (get_option('ams_scraperapi_is_active') === '1') {
            $services[] = [
                'name' => 'ScraperAPI',
                'priority' => $scraperapi_priority,
                'enabled' => true,
                'execute' => [$this, 'executeScraperAPI'],
                'test' => [$this, 'testScraperAPI']
            ];
        }
        
        if (get_option('ams_scrapingant_is_active') === '1') {
            $services[] = [
                'name' => 'ScrapingAnt',
                'priority' => $scrapingant_priority,
                'enabled' => true,
                'execute' => [$this, 'executeScrapingAnt'],
                'test' => [$this, 'testScrapingAnt']
            ];
        }
        
        if (get_option('ams_decodo_is_active') === '1') {
            $decodo_priority = intval(get_option('ams_decodo_priority', 3));
            $services[] = [
                'name' => 'Decodo',
                'priority' => $decodo_priority,
                'enabled' => true,
                'execute' => [$this, 'executeDecodo'],
                'test' => [$this, 'testDecodo']
            ];
        }
        
        usort($services, function($a, $b) {
            return $a['priority'] - $b['priority'];
        });
        
        return $services;
    }
    
    public function scrapeUrl($url, $user_agent = null, $max_retries = 2) {

        
        foreach ($this->services as $service) {
            if (!$service['enabled']) {
                continue;
            }
            
            $service_name = $service['name'];

            
            if ($this->isServiceHealthy($service_name)) {
                $retries = 0;
                
                while ($retries < $max_retries) {
                    try {

                        $response = call_user_func($service['execute'], $url, $user_agent);
                        
                        if ($response) {


                        } else {

                        }
                        
                        if ($this->isValidResponse($response)) {
                            $this->recordServiceSuccess($service_name);

                            

                            if (strpos($url, 'bestsellers') !== false || strpos($url, 'new-releases') !== false || strpos($url, 'movers-shakers') !== false) {

                                
                                // Count key elements that should exist on bestseller pages
                                $ol_count = substr_count($response, '<ol');
                                $li_count = substr_count($response, '<li');
                                $zg_count = substr_count($response, 'zg-');
                                $asin_count = substr_count($response, 'data-asin');
                                $bestseller_text = substr_count(strtolower($response), 'bestseller');
                                






                                
                                // Show a snippet of the HTML to understand structure
                                $html_snippet = substr($response, 0, 2000);

                            }
                            
                            ams_track_scraping_usage($service_name, true);
                            return $response;
                        } else {
                            $retries++;

                            
                            if ($retries < $max_retries) {
                                sleep(1);
                            }
                        }
                    } catch (Exception $e) {
                        $retries++;

                        
                        if ($retries < $max_retries) {
                            sleep(2);
                        }
                    }
                }
                
                $this->recordServiceFailure($service_name);
                ams_track_scraping_usage($service_name, false);
            } else {

            }
        }
        

        return false;
    }
    
    private function isValidResponse($response) {
        if (!$response || !is_string($response)) {
            return false;
        }
        
        // Check if it's a valid Amazon page with sufficient content
        $has_sufficient_content = strlen($response) > 500;
        
        $has_blocked_indicators = stripos($response, 'blocked') !== false ||
                                 stripos($response, 'captcha') !== false ||
                                 stripos($response, 'access denied') !== false ||
                                 stripos($response, 'robot check') !== false;
        
        // More lenient Amazon page indicators - just need basic HTML structure
        $has_amazon_indicators = (stripos($response, 'amazon') !== false || 
                                 stripos($response, 'dp/') !== false ||
                                 stripos($response, 'asin') !== false) &&
                               (stripos($response, '<html') !== false &&
                                stripos($response, '<body') !== false);
        
        return $has_sufficient_content && !$has_blocked_indicators && $has_amazon_indicators;
    }
    
    private function isServiceHealthy($service_name) {
        if (!isset($this->service_health[$service_name])) {
            return true;
        }
        
        $health = $this->service_health[$service_name];
        $failure_threshold = 5; // Increased from 3 to 5
        $recovery_time = 300; // Reduced from 30 minutes to 5 minutes
        
        if (isset($health['unhealthy_since'])) {
            if (time() - $health['unhealthy_since'] > $recovery_time) {
                unset($this->service_health[$service_name]['unhealthy_since']);
                $this->service_health[$service_name]['consecutive_failures'] = 0;
                $this->saveServiceHealth();

                return true;
            }
            return false;
        }
        
        $consecutive_failures = isset($health['consecutive_failures']) ? $health['consecutive_failures'] : 0;
        return $consecutive_failures < $failure_threshold;
    }
    
    private function recordServiceSuccess($service_name) {
        if (!isset($this->service_health[$service_name])) {
            $this->service_health[$service_name] = [];
        }
        
        $this->service_health[$service_name]['consecutive_failures'] = 0;
        $this->service_health[$service_name]['last_success'] = time();
        
        if (isset($this->service_health[$service_name]['unhealthy_since'])) {
            unset($this->service_health[$service_name]['unhealthy_since']);
        }
        
        $this->saveServiceHealth();
    }
    
    private function recordServiceFailure($service_name) {
        if (!isset($this->service_health[$service_name])) {
            $this->service_health[$service_name] = [];
        }
        
        $this->service_health[$service_name]['consecutive_failures'] = 
            (isset($this->service_health[$service_name]['consecutive_failures']) ? 
             $this->service_health[$service_name]['consecutive_failures'] : 0) + 1;
        
        $this->service_health[$service_name]['last_failure'] = time();
        
        if ($this->service_health[$service_name]['consecutive_failures'] >= 5) {
            $this->service_health[$service_name]['unhealthy_since'] = time();

        }
        
        $this->saveServiceHealth();
    }
    
    private function saveServiceHealth() {
        update_option('ams_scraping_service_health', $this->service_health);
    }
    
    public function resetServiceHealth($service_name = null) {
        if ($service_name) {
            // Reset specific service
            if (isset($this->service_health[$service_name])) {
                unset($this->service_health[$service_name]['unhealthy_since']);
                $this->service_health[$service_name]['consecutive_failures'] = 0;

            }
        } else {
            // Reset all services
            foreach ($this->service_health as $name => &$health) {
                unset($health['unhealthy_since']);
                $health['consecutive_failures'] = 0;
            }

        }
        $this->saveServiceHealth();
    }
    
    public function getServiceHealthStatus() {
        $status = [];
        
        foreach ($this->services as $service) {
            $service_name = $service['name'];
            $health = isset($this->service_health[$service_name]) ? $this->service_health[$service_name] : [];
            
            $status[$service_name] = [
                'priority' => $service['priority'],
                'enabled' => $service['enabled'],
                'healthy' => $this->isServiceHealthy($service_name),
                'consecutive_failures' => isset($health['consecutive_failures']) ? $health['consecutive_failures'] : 0,
                'last_success' => isset($health['last_success']) ? $health['last_success'] : null,
                'last_failure' => isset($health['last_failure']) ? $health['last_failure'] : null
            ];
        }
        
        return $status;
    }
    
    private function executeScraperAPI($url, $user_agent) {
        $api_key = get_option('ams_scraper_api_key', '');
        if (!$api_key) {
            return false;
        }
        return executeScraperAPI($url, $api_key);
    }
    
    private function executeScrapingAnt($url, $user_agent) {
        $api_key = get_option('ams_scrapingant_api_key', '');
        if (!$api_key) {
            return false;
        }
        return executeScrapingAntAPI($url, $api_key);
    }
    
    private function executeDecodo($url, $user_agent) {
        $auth_token = get_option('ams_decodo_auth_token', '');
        if (!$auth_token) {
            return false;
        }
        return executeDecodoAPI($url, $auth_token);
    }
    
    private function testScraperAPI() {
        if (function_exists('scraperapi_test_code')) {
            return scraperapi_test_code();
        }
        return ['success' => false, 'message' => 'ScraperAPI test function not available'];
    }
    
    private function testScrapingAnt() {
        if (function_exists('scrapingant_test_code')) {
            return scrapingant_test_code();
        }
        return ['success' => false, 'message' => 'ScrapingAnt test function not available'];
    }
    
    private function testDecodo() {
        if (function_exists('ams_test_decodo_api_status')) {
            return ams_test_decodo_api_status();
        }
        return ['success' => false, 'message' => 'Decodo test function not available'];
    }
}

/**
 * Execute the scraping service based on the configuration.
 * 
 * @param string $productUrl
 * @param bool $onUpdate
 * @return string|boolean
 */

function executeScrapingService($productUrl, $isUpdate = false) {
    // Use the new centralized scraping service manager
    $manager = ScrapingServiceManager::getInstance();
    return $manager->scrapeUrl($productUrl);
}

/**
 * Execute scraping services with intelligent fallback
 * Tries each enabled service one by one until success
 * 
 * @param string $productUrl
 * @param bool $isUpdate
 * @return string|boolean
 */
function executeScrapingServiceWithFallback($productUrl, $isUpdate = false) {
    // Use the new centralized scraping service manager with enhanced fallback
    $manager = ScrapingServiceManager::getInstance();
    return $manager->scrapeUrl($productUrl, null, 3); // 3 retries for fallback function
}

/**
 * Track scraping service usage
 * 
 * @param string $serviceName
 * @param bool $success
 */
function ams_track_scraping_usage($serviceName, $success) {
    $today = date('Y-m-d');
    $usage_key = 'ams_scraping_usage_' . $serviceName;
    $usage_data = get_option($usage_key, []);
    
    if (!isset($usage_data[$today])) {
        $usage_data[$today] = ['success' => 0, 'failed' => 0, 'total' => 0];
    }
    
    if ($success) {
        $usage_data[$today]['success']++;
    } else {
        $usage_data[$today]['failed']++;
    }
    $usage_data[$today]['total']++;
    
    // Keep only last 30 days
    $cutoff_date = date('Y-m-d', strtotime('-30 days'));
    foreach ($usage_data as $date => $data) {
        if ($date < $cutoff_date) {
            unset($usage_data[$date]);
        }
    }
    
    update_option($usage_key, $usage_data);
}

/**
 * Get scraping service usage stats
 * 
 * @param string $serviceName
 * @param int $days Number of days to calculate (default: 30)
 * @return array
 */
function ams_get_scraping_usage_stats($serviceName, $days = 30) {
    $usage_key = 'ams_scraping_usage_' . $serviceName;
    $usage_data = get_option($usage_key, []);
    
    $stats = ['success' => 0, 'failed' => 0, 'total' => 0, 'today' => 0];
    $today = date('Y-m-d');
    $cutoff_date = date('Y-m-d', strtotime("-$days days"));
    
    foreach ($usage_data as $date => $data) {
        if ($date >= $cutoff_date) {
            $stats['success'] += $data['success'];
            $stats['failed'] += $data['failed'];
            $stats['total'] += $data['total'];
        }
        if ($date === $today) {
            $stats['today'] = $data['total'];
        }
    }
    
    return $stats;
}

/**
 * Execute the ScraperAPI service.
 * 
 * @param string $productUrl
 * @param string $apiKey
 * @return string|boolean
 */
function executeScraperAPI($productUrl, $apiKey) {
    $endpoint = 'http://api.scraperapi.com/?api_key=' . $apiKey . '&url=' . urlencode($productUrl);
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $endpoint);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $response = curl_exec($ch);
    $curl_errno = curl_errno($ch);
    curl_close($ch);

    return $curl_errno ? false : $response;
}



/**
 * Execute the SCRAPINGANT API service.
 * 
 * @param string $productUrl
 * @param string $apiKey
 * @return string|boolean
 */
function executeScrapingAntAPI($productUrl, $apiKey) {
    $endpoint = 'https://api.scrapingant.com/v2/general?x-api-key=' . $apiKey . '&url=' . urlencode($productUrl) . '&browser=false';
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $endpoint);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $response = curl_exec($ch);
    $curl_errno = curl_errno($ch);
    curl_close($ch);

    return $curl_errno ? false : $response;
}

/**
 * Execute the Decodo API service.
 * 
 * @param string $productUrl
 * @param string $authToken
 * @return string|boolean
 */
function executeDecodoAPI($productUrl, $authToken) {

    
    $endpoint = 'https://scraper-api.decodo.com/v2/scrape';
    
    $payload = json_encode(array(
        'url' => $productUrl
    ));
    

    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $endpoint);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
    curl_setopt($ch, CURLOPT_HTTPHEADER, array(
        'Accept: application/json',
        'Authorization: Basic ' . $authToken,
        'Content-Type: application/json'
    ));
    curl_setopt($ch, CURLOPT_TIMEOUT, 60);
    curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36');
    
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $error = curl_error($ch);
    curl_close($ch);
    

    
    if ($error) {

        return false;
    }
    
    if ($httpCode !== 200 && $httpCode !== 201) {

        return false;
    }
    

    
    $decoded = json_decode($response, true);
    if (json_last_error() !== JSON_ERROR_NONE) {

        return false;
    }
    
    // Track the API request
    $current_requests = get_option('ams_decodo_requests_made', 0);
    update_option('ams_decodo_requests_made', $current_requests + 1);
    
    // Extract HTML content from Decodo v2/scrape response

    
    // Check if results array exists and log its structure
    if (isset($decoded['results'])) {

        if (!empty($decoded['results'][0])) {
            $first_result = $decoded['results'][0];

            
            // Try to extract HTML from various possible locations in results
            if (isset($first_result['html'])) {

                return $first_result['html'];
            } elseif (isset($first_result['content'])) {

                return $first_result['content'];
            } elseif (isset($first_result['data']['html'])) {

                return $first_result['data']['html'];
            }
        }
    }
    
    // Fallback to direct fields
    if (isset($decoded['data']['html'])) {

        return $decoded['data']['html'];
    } elseif (isset($decoded['html'])) {

        return $decoded['html'];
    } elseif (isset($decoded['content'])) {

        return $decoded['content'];
    }
    

    return false;
}

/**
 * Scrapingant API credits count
 * 
 * @return array|false
 */
if (!function_exists('scrapingant_api_credits_status')) {
   function scrapingant_api_credits_status() {
       // Check if ScrapingAnt key exists and either mode is enabled
       $api_key = get_option('ams_scrapingant_api_key');
       $is_active = get_option('ams_scrapingant_is_active') == '1';
       $on_update = get_option('ams_scrapingant_on_update') == '1';
       
       if (!$api_key || (!$is_active && !$on_update)) {
           return false;
       }

       // Set endpoint for API credits status
       $endpoint = 'https://api.scrapingant.com/v2/usage?x-api-key=' . $api_key;

       // Initialize cURL 
       $ch = curl_init();
       curl_setopt($ch, CURLOPT_URL, $endpoint);
       curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
       curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
       curl_setopt($ch, CURLOPT_HTTPGET, true);

       $response = curl_exec($ch);
       
       if (curl_errno($ch)) {
           curl_close($ch);
           return false;
       }

       curl_close($ch);
       $response_data = json_decode($response, true);
       return $response_data ?: false;
   }
}


/**
 * ScraperAPI credits count
 * 
 * @return array|false
 */

if (!function_exists('ams_scraper_api_credits_count')) {
   function ams_scraper_api_credits_count() {
       // Check if ScraperAPI key exists and either mode is enabled
       $scraper_api_key = get_option('ams_scraper_api_key');
       $is_active = get_option('ams_scraper_api_is_active') == '1';
       $on_update = get_option('ams_scraper_api_on_update') == '1';
       
       if (!$scraper_api_key || (!$is_active && !$on_update)) {
           return false;
       }

       // ScraperAPI endpoint
       $endpoint = 'http://api.scraperapi.com/account?api_key=' . $scraper_api_key;
       
       // Create cURL handle
       $ch = curl_init();
       curl_setopt($ch, CURLOPT_URL, $endpoint);
       curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
       
       // Make the request
       $response = curl_exec($ch);
       $curl_errno = curl_errno($ch);
       curl_close($ch);

       if ($curl_errno) {
           return false;
       }

       return json_decode($response, true);
   }
}

/**
 * Decodo API credits count
 * 
 * @return array|false
 */
if (!function_exists('decodo_api_credits_status')) {
   function decodo_api_credits_status() {
       // Check if Decodo auth token exists and either mode is enabled
       $auth_token = get_option('ams_decodo_auth_token');
       $is_active = get_option('ams_decodo_is_active') == '1';
       $on_update = get_option('ams_decodo_on_update') == '1';
       
       if (!$auth_token || (!$is_active && !$on_update)) {
           return false;
       }
       
       // Try to fetch real usage data from Decodo API
       $endpoint = 'https://api.decodo.io/v1/usage';
       $ch = curl_init();
       curl_setopt($ch, CURLOPT_URL, $endpoint);
       curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
       curl_setopt($ch, CURLOPT_HTTPHEADER, array(
           'Authorization: Bearer ' . $auth_token,
           'Content-Type: application/json'
       ));
       curl_setopt($ch, CURLOPT_TIMEOUT, 10);
       
       $response = curl_exec($ch);
       $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
       curl_close($ch);
       
       // If API call successful, return real data
       if ($response && $http_code === 200) {
           $data = json_decode($response, true);
           if ($data && isset($data['usage'])) {
               return $data['usage'];
           }
       }
       
       // Fallback: Return dynamic data based on stored usage
       $requests_made = (int)get_option('ams_decodo_requests_made', 0);
       $plan_limit = (int)get_option('ams_decodo_plan_limit', 90000);
       $last_reset = get_option('ams_decodo_last_reset', date('Y-m-01'));
       
       // Auto-reset monthly counter if needed
       $current_month = date('Y-m-01');
       if ($last_reset !== $current_month) {
           update_option('ams_decodo_requests_made', 0);
           update_option('ams_decodo_last_reset', $current_month);
           $requests_made = 0;
       }
       
       return array(
           'requests_made' => $requests_made,
           'plan_limit' => $plan_limit,
           'remaining' => max(0, $plan_limit - $requests_made),
           'status' => 'Connected',
           'last_updated' => current_time('mysql'),
           'note' => __('Usage tracked locally. Visit Decodo dashboard for real-time data.', 'ams-wc-amazon')
       );
   }
}

/**
 * ScraperAPI test code
 * 
 * @return array
 */
add_action('wp_ajax_scraper_api_test_code', 'scraper_api_test_code');
function scraper_api_test_code() {
    // Clear cache when test button is pressed
    delete_transient('ams_scraper_api_test_result');
    delete_transient('ams_scraper_api_key_hash');
    delete_transient('ams_scraper_api_last_test');
    
    // Use a lighter URL for testing
    $test_url = 'https://httpbin.org/ip';
    
    // Get the ScraperAPI key
    $api_key = get_option('ams_scraper_api_key');
    
    if (empty($api_key)) {
        wp_send_json(array(
            'status' => false,
            'message' => '<small>ScraperAPI key is missing. Please enter your API key.</small>'
        ));
    }

    // Construct the ScraperAPI URL
    $scraper_url = "http://api.scraperapi.com?api_key={$api_key}&url=" . urlencode($test_url);

    // Set up the arguments for wp_remote_get
    $args = array(
        'timeout' => 10, // Set a shorter timeout
        'httpversion' => '1.1',
        'user-agent' => 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/58.0.3029.110 Safari/537.36',
    );

    // Make the request
    $response = wp_remote_get($scraper_url, $args);

    // Check for errors
    if (is_wp_error($response)) {
        wp_send_json(array(
            'status' => false,
            'message' => '<small>ScraperAPI request failed: ' . esc_html($response->get_error_message()) . '</small>'
        ));
    }

    // Check the response code
    $response_code = wp_remote_retrieve_response_code($response);
    if ($response_code !== 200) {
        wp_send_json(array(
            'status' => false,
            'message' => '<small>ScraperAPI returned an unexpected response code: ' . esc_html($response_code) . '</small>'
        ));
    }

    // If we've made it this far, the API is working
    wp_send_json(array(
        'status' => true,
        'message' => '<small>ScraperAPI is working correctly!</small>'
    ));
}

/**
 * Test ScraperAPI status
 * 
 * @return array
 */
function ams_test_scraper_api_status() {
    // Use a lighter URL for testing
    $test_url = 'https://httpbin.org/ip';
    
    // Get the ScraperAPI key
    $api_key = get_option('ams_scraper_api_key', '');
    
    if (empty($api_key)) {
        return array(
            'status' => false,
            'message' => 'API key is missing',
            'has_key' => false
        );
    }

    // Construct the ScraperAPI URL
    $scraper_url = "http://api.scraperapi.com?api_key={$api_key}&url=" . urlencode($test_url);

    // Set up the arguments for wp_remote_get
    $args = array(
        'timeout' => 10,
        'httpversion' => '1.1',
        'user-agent' => 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/58.0.3029.110 Safari/537.36',
    );

    // Make the request
    $response = wp_remote_get($scraper_url, $args);

    // Check for errors
    if (is_wp_error($response)) {
        return array(
            'status' => false,
            'message' => 'Request failed: ' . $response->get_error_message(),
            'has_key' => true
        );
    }

    // Check the response code
    $response_code = wp_remote_retrieve_response_code($response);
    if ($response_code !== 200) {
        return array(
            'status' => false,
            'message' => 'Invalid response code: ' . $response_code,
            'has_key' => true
        );
    }

    // If we've made it this far, the API is working
    return array(
        'status' => true,
        'message' => 'API is working correctly',
        'has_key' => true
    );
}


/**/


/**
 * ScrapingAnt test code
 * 
 * @return array
 */
add_action('wp_ajax_scrapingant_test_code', 'scrapingant_test_code');
function scrapingant_test_code() {
    // Clear cache when test button is pressed
    delete_transient('ams_scrapingant_api_test_result');
    delete_transient('ams_scrapingant_api_key_hash');
    delete_transient('ams_scrapingant_api_last_test');
    
    // Use a lighter URL for testing
    $test_url = 'https://httpbin.org/ip';
    
    // Get the ScrapingAnt API key
    $api_key = get_option('ams_scrapingant_api_key');
    
    if (empty($api_key)) {
        wp_send_json(array(
            'status' => false,
            'message' => '<small>ScrapingAnt API key is missing. Please enter your API key.</small>'
        ));
    }

    // Construct the ScrapingAnt API request
    $api_endpoint = 'https://api.scrapingant.com/v2/general';
    $request_url = add_query_arg('url', urlencode($test_url), $api_endpoint);

    // Set up the arguments for wp_remote_get
    $args = array(
        'timeout' => 30,
        'httpversion' => '1.1',
        'headers' => array(
            'x-api-key' => $api_key,
        ),
    );

    // Make the request
    $response = wp_remote_get($request_url, $args);

    // Check for errors
    if (is_wp_error($response)) {
        wp_send_json(array(
            'status' => false,
            'message' => '<small>ScrapingAnt request failed: ' . esc_html($response->get_error_message()) . '</small>'
        ));
    }

    // Check the response code
    $response_code = wp_remote_retrieve_response_code($response);
    if ($response_code !== 200) {
        $error_message = wp_remote_retrieve_body($response);
        wp_send_json(array(
            'status' => false,
            'message' => '<small>ScrapingAnt returned an unexpected response code: ' . esc_html($response_code) . '. Error: ' . esc_html($error_message) . '</small>'
        ));
    }

    // If we've made it this far, the API is working
    wp_send_json(array(
        'status' => true,
        'message' => '<small>ScrapingAnt is working correctly!</small>'
    ));
}

/**
 * Test ScrapingAnt API status
 * 
 * @return array
 */
function ams_test_scrapingant_api_status() {
    // Use a lighter URL for testing
    $test_url = 'https://httpbin.org/ip';
    
    // Get the ScrapingAnt API key
    $api_key = get_option('ams_scrapingant_api_key', '');
    
    if (empty($api_key)) {
        return array(
            'status' => false,
            'message' => 'API key is missing',
            'has_key' => false
        );
    }

    // Construct the ScrapingAnt API request
    $api_endpoint = 'https://api.scrapingant.com/v2/general';
    $request_url = add_query_arg('url', urlencode($test_url), $api_endpoint);

    // Set up the arguments for wp_remote_get
    $args = array(
        'timeout' => 30,
        'httpversion' => '1.1',
        'headers' => array(
            'x-api-key' => $api_key,
        ),
    );

    // Make the request
    $response = wp_remote_get($request_url, $args);

    // Check for errors
    if (is_wp_error($response)) {
        return array(
            'status' => false,
            'message' => 'Request failed: ' . $response->get_error_message(),
            'has_key' => true
        );
    }

    // Check the response code
    $response_code = wp_remote_retrieve_response_code($response);
    if ($response_code !== 200) {
        $error_message = wp_remote_retrieve_body($response);
        return array(
            'status' => false,
            'message' => 'Invalid response code: ' . $response_code . '. Error: ' . $error_message,
            'has_key' => true
        );
    }

    // If we've made it this far, the API is working
    return array(
        'status' => true,
        'message' => 'API is working correctly',
        'has_key' => true
    );
}

/**
 * Decodo API test code
 * 
 * @return array
 */
add_action('wp_ajax_decodo_api_test_code', 'decodo_api_test_code');
function decodo_api_test_code() {
    // Clear cache when test button is pressed
    delete_transient('ams_decodo_api_test_result');
    delete_transient('ams_decodo_auth_token_hash');
    delete_transient('ams_decodo_api_last_test');
    
    // Get the Decodo auth token
    $auth_token = get_option('ams_decodo_auth_token');
    
    if (empty($auth_token)) {
        wp_send_json(array(
            'status' => false,
            'message' => '<small>Decodo auth token is missing. Please enter your auth token.</small>'
        ));
    }

    // Test with a simple URL
    $test_url = 'https://ip.decodo.com';
    $endpoint = 'https://scraper-api.decodo.com/v2/scrape';
    
    $payload = json_encode(array(
        'url' => $test_url
    ));
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $endpoint);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
    curl_setopt($ch, CURLOPT_HTTPHEADER, array(
        'Accept: application/json',
        'Authorization: Basic ' . $auth_token,
        'Content-Type: application/json'
    ));
    curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    
    $response = curl_exec($ch);
    $curl_errno = curl_errno($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    // Check for cURL errors
    if ($curl_errno) {
        wp_send_json(array(
            'status' => false,
            'message' => '<small>Decodo request failed: cURL error ' . $curl_errno . '</small>'
        ));
    }

    // Check the response code
    if ($http_code !== 200 && $http_code !== 201) {
        $error_message = $response ? json_decode($response, true) : 'Unknown error';
        wp_send_json(array(
            'status' => false,
            'message' => '<small>Decodo returned an unexpected response code: ' . esc_html($http_code) . '. Error: ' . esc_html(is_array($error_message) ? json_encode($error_message) : $error_message) . '</small>'
        ));
    }

    // Parse response to check if it's working
    $data = json_decode($response, true);
    if ($data && (isset($data['data']['html']) || isset($data['html']) || isset($data['content']))) {
        wp_send_json(array(
            'status' => true,
            'message' => '<small>Decodo is working correctly! Test scraping successful.</small>'
        ));
    } else {
        wp_send_json(array(
            'status' => true,
            'message' => '<small>Decodo API connection successful!</small>'
        ));
    }
}

/**
 * Test Decodo API status
 * 
 * @return array
 */
function ams_test_decodo_api_status() {
    // Get the Decodo auth token
    $auth_token = get_option('ams_decodo_auth_token', '');
    
    if (empty($auth_token)) {
        return array(
            'status' => false,
            'message' => 'Auth token is missing',
            'has_key' => false
        );
    }

    // Test with a simple URL
    $test_url = 'https://ip.decodo.com';
    $endpoint = 'https://scraper-api.decodo.com/v2/scrape';
    
    $payload = json_encode(array(
        'url' => $test_url
    ));
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $endpoint);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
    curl_setopt($ch, CURLOPT_HTTPHEADER, array(
        'Accept: application/json',
        'Authorization: Basic ' . $auth_token,
        'Content-Type: application/json'
    ));
    curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    
    $response = curl_exec($ch);
    $curl_errno = curl_errno($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    // Check for cURL errors
    if ($curl_errno) {
        return array(
            'status' => false,
            'message' => 'Request failed: cURL error ' . $curl_errno,
            'has_key' => true
        );
    }

    // Check the response code
    if ($http_code !== 200 && $http_code !== 201) {
        $error_message = $response ? json_decode($response, true) : 'Unknown error';
        return array(
            'status' => false,
            'message' => 'Unexpected response code: ' . $http_code . '. Error: ' . (is_array($error_message) ? json_encode($error_message) : $error_message),
            'has_key' => true
        );
    }

    // Parse response to check if it's working
    $data = json_decode($response, true);
    if ($data && (isset($data['data']['html']) || isset($data['html']) || isset($data['content']))) {
        return array(
            'status' => true,
            'message' => 'API is working correctly. Test scraping successful.',
            'has_key' => true
        );
    }

    // If we've made it this far, the API is working
    return array(
        'status' => true,
        'message' => 'API connection successful',
        'has_key' => true
    );
}

function displayServerSettings() {
    $requirements = [
        'PHP Version' => '7.4',
        'Memory Limit' => 256,  // in MB
        'Upload Max Filesize' => 128,  // in MB
        'Max Input Time' => 120,  // in seconds
        'Post Max Size' => 128,  // in MB
        'Max Execution Time' => 600  // in seconds
    ];
    $settings = [
        __('PHP Version', 'ams-wc-amazon') => phpversion(),
        __('Memory Limit', 'ams-wc-amazon') => ini_get('memory_limit'),
        __('Upload Max Filesize', 'ams-wc-amazon') => ini_get('upload_max_filesize'),
        __('Max Input Time', 'ams-wc-amazon') => ini_get('max_input_time') . 's',
        __('Post Max Size', 'ams-wc-amazon') => ini_get('post_max_size'),
        __('Max Execution Time', 'ams-wc-amazon') => ini_get('max_execution_time') . 's'
    ];
    
    // Map display names to actual ini setting names
    $iniNames = [
        __('PHP Version', 'ams-wc-amazon') => 'PHP_VERSION',
        __('Memory Limit', 'ams-wc-amazon') => 'memory_limit',
        __('Upload Max Filesize', 'ams-wc-amazon') => 'upload_max_filesize',
        __('Max Input Time', 'ams-wc-amazon') => 'max_input_time',
        __('Post Max Size', 'ams-wc-amazon') => 'post_max_size',
        __('Max Execution Time', 'ams-wc-amazon') => 'max_execution_time'
    ];
    $iconPass = 'fas fa-check-circle';
    $iconFail = 'fas fa-times-circle';
    $formattedSettings = [];
    foreach ($settings as $key => $value) {
        $requirementKey = str_replace(__(' ', 'ams-wc-amazon'), ' ', $key);
        $requirement = $requirements[$requirementKey];
        if ($key === __('PHP Version', 'ams-wc-amazon')) {
            $result = version_compare($value, $requirement, '>=');
        } elseif (in_array($key, [__('Memory Limit', 'ams-wc-amazon'), __('Upload Max Filesize', 'ams-wc-amazon'), __('Post Max Size', 'ams-wc-amazon')])) {
            $currentValueMB = (int) filter_var($value, FILTER_SANITIZE_NUMBER_INT);
            // -1 means unlimited, which is always OK
            $result = ($currentValueMB === -1 || $currentValueMB >= $requirement);
        } else {
            $currentValueSec = (int) filter_var($value, FILTER_SANITIZE_NUMBER_INT);
            // -1 means unlimited, which is always OK
            $result = ($currentValueSec === -1 || $currentValueSec >= $requirement);
        }
        // Format display value for -1 (unlimited)
        $displayValue = $value;
        if (strpos($value, '-1') !== false) {
            $displayValue = __('Unlimited', 'ams-wc-amazon');
        }
        
        $formattedSettings[] = [
            'name' => $key,
            'value' => $displayValue,
            'required' => $requirement . (in_array($key, [__('Memory Limit', 'ams-wc-amazon'), __('Upload Max Filesize', 'ams-wc-amazon'), __('Post Max Size', 'ams-wc-amazon')]) ? 'M' : ''),
            'icon' => $result ? $iconPass : $iconFail,
            'meets_requirement' => $result,
            'ini_name' => $iniNames[$key]
        ];
    }
    return $formattedSettings;
}


function checkRequirement($setting, $currentValue, $requirements) {
    $requirement = $requirements[$setting];
    $iconPass = '<i class="fas fa-check-circle text-success"></i>';
    $iconFail = '<i class="fas fa-times-circle text-danger"></i>';
    
    if ($setting == __('PHP Version', 'ams-wc-amazon')) {
        $result = version_compare($currentValue, $requirement, '>=');
    } elseif (in_array($setting, [__('Memory Limit', 'ams-wc-amazon'), __('Upload Max Filesize', 'ams-wc-amazon'), __('Post Max Size', 'ams-wc-amazon')])) {
        $currentValueMB = (int) filter_var($currentValue, FILTER_SANITIZE_NUMBER_INT);
        $result = ($currentValueMB >= $requirement);
    } else {
        $currentValueSec = (int) filter_var($currentValue, FILTER_SANITIZE_NUMBER_INT);
        $result = ($currentValueSec >= $requirement);
    }
    
    return $result ? $iconPass : $iconFail;
}


/**
 * Fiu - recursive sanitization function
 */
function amswoofiu_sanitize( $var ) {
    if ( is_array( $var ) ) {
        return array_map( 'amswoofiu_sanitize', $var );
    } else {
        return is_scalar( $var ) ? sanitize_text_field( wp_unslash( $var ) ) : $var;
    }
}

/**
 * This Fiu function is used to either save the featured image url 
 * Or gallary images images url
 * 
 * @param int $post_id
 * @param array $data
 * 
 */
function amswoofiu_save_image_url_data( $post_id, $data = array() ) {
    if( isset( $data['amswoofiu_url'] ) ){
        // Update Featured Image URL
        $image_url = isset( $data['amswoofiu_url'] ) ? esc_url_raw( $data['amswoofiu_url'] ) : '';
        $image_alt = isset( $data['amswoofiu_alt'] ) ? wp_strip_all_tags( $data['amswoofiu_alt'] ): ''; 

        if ( $image_url != '' ){
            if( get_post_type( $post_id ) == 'product' ){
                $img_url = get_post_meta( $post_id, AMSWOOFIU_URL , true );
                if( is_array( $img_url ) && isset( $img_url['img_url'] ) && $image_url == $img_url['img_url'] ){
                        $image_url = array(
                            'img_url' => $image_url,
                            'width'   => $img_url['width'],
                            'height'  => $img_url['height']
                        );
                }else{
                    $imagesize = @getimagesize( $image_url );
                    $image_url = array(
                        'img_url' => $image_url,
                        'width'   => isset( $imagesize[0] ) ? $imagesize[0] : '',
                        'height'  => isset( $imagesize[1] ) ? $imagesize[1] : ''
                    );
                }
            }

            update_post_meta( $post_id, AMSWOOFIU_URL, $image_url );
            if( $image_alt ){
                update_post_meta( $post_id, AMSWOOFIU_ALT, $image_alt );
            }
        }else{
            delete_post_meta( $post_id, AMSWOOFIU_URL );
            delete_post_meta( $post_id, AMSWOOFIU_ALT );
        }
    }

    if( isset( $data['amswoofiu_product_gallary'] ) ){
        // Update WC Gallery
        $amswoofiu_wcgallary = isset( $data['amswoofiu_product_gallary'] ) ? amswoofiu_sanitize( $data['amswoofiu_product_gallary'] ) : '';
        if( empty( $amswoofiu_wcgallary ) || get_post_type( $post_id ) != 'product' ){
            return;
        }

        $old_images = amswoofiu_get_wcgallary_meta( $post_id );
        if( !empty( $old_images ) ){
            foreach ($old_images as $key => $value) {
                $old_images[$value['url']] = $value;
            }
        }

        $gallary_images = array();
        if( !empty( $amswoofiu_wcgallary ) ){
            foreach ($amswoofiu_wcgallary as $amswoofiu_gallary ) {
                if( isset( $amswoofiu_gallary['url'] ) && $amswoofiu_gallary['url'] != '' ){
                    $gallary_image = array();
                    $gallary_image['url'] = $amswoofiu_gallary['url'];

                    if( isset( $old_images[$gallary_image['url']]['width'] ) && $old_images[$gallary_image['url']]['width'] != '' ){
                        $gallary_image['width'] = isset( $old_images[$gallary_image['url']]['width'] ) ? $old_images[$gallary_image['url']]['width'] : '';
                        $gallary_image['height'] = isset( $old_images[$gallary_image['url']]['height'] ) ? $old_images[$gallary_image['url']]['height'] : '';

                    }else{
                        $imagesizes = @getimagesize( $amswoofiu_gallary['url'] );
                        $gallary_image['width'] = isset( $imagesizes[0] ) ? $imagesizes[0] : '';
                        $gallary_image['height'] = isset( $imagesizes[1] ) ? $imagesizes[1] : '';
                    }

                    $gallary_images[] = $gallary_image;
                }
            }
        }

        if( !empty( $gallary_images ) ){
            update_post_meta( $post_id, AMSWOOFIU_WCGALLARY, $gallary_images );
        }else{
            delete_post_meta( $post_id, AMSWOOFIU_WCGALLARY );
        }
    }
}

/**
 * This Fiu function is used to get the gallary images url
 * 
 * @param int $post_id
 * 
 */
function amswoofiu_get_wcgallary_meta( $post_id ) {
        
    $image_meta  = array();

    $gallary_images = get_post_meta( $post_id, AMSWOOFIU_WCGALLARY, true );
    
    if( !is_array( $gallary_images ) && $gallary_images != '' ){
        $gallary_images = explode( ',', $gallary_images );
        if( !empty( $gallary_images ) ){
            $gallarys = array();
            foreach ($gallary_images as $gallary_image ) {
                $gallary = array();
                $gallary['url'] = $gallary_image;
                $imagesizes = @getimagesize( $gallary_image );
                $gallary['width'] = isset( $imagesizes[0] ) ? $imagesizes[0] : '';
                $gallary['height'] = isset( $imagesizes[1] ) ? $imagesizes[1] : '';
                $gallarys[] = $gallary;
            }
            $gallary_images = $gallarys;
            update_post_meta( $post_id, AMSWOOFIU_WCGALLARY, $gallary_images );
            return $gallary_images;
        }
    }else{
        if( !empty( $gallary_images ) ){
            $need_update = false;
            foreach ($gallary_images as $key => $gallary_image ) {
                if( !isset( $gallary_image['width'] ) && isset( $gallary_image['url'] ) ){
                    $imagesizes1 = @getimagesize( $gallary_image['url'] );
                    $gallary_images[$key]['width'] = isset( $imagesizes1[0] ) ? $imagesizes1[0] : '';
                    $gallary_images[$key]['height'] = isset( $imagesizes1[1] ) ? $imagesizes1[1] : '';
                    $need_update = true;
                }
            }
            if( $need_update ){
                update_post_meta( $post_id, AMSWOOFIU_WCGALLARY, $gallary_images );
            }
            return $gallary_images;
        }   
    }
    return $gallary_images;
}

/**
 * This Fiu function is used to save the variation image url
 * 
 * @param int $variation_id
 * @param array $data
 * 
 */
function amswoofiu_save_product_variation_image( $variation_id, $data = array() ) {
    $image_url = isset( $data['amswoofiu_variation_url'][$variation_id] ) ? esc_url_raw( $data['amswoofiu_variation_url'][$variation_id] ) : '';
    if( $image_url != '' ){
        $img_url = get_post_meta( $variation_id, AMSWOOFIU_URL, true );
        if( is_array( $img_url ) && isset( $img_url['img_url'] ) && $image_url == $img_url['img_url'] ){
                $image_url = array(
                    'img_url' => $image_url,
                    'width'   => $img_url['width'],
                    'height'  => $img_url['height']
                );
        }else{
            $imagesize = @getimagesize( $image_url );
            $image_url = array(
                'img_url' => $image_url,
                'width'   => isset( $imagesize[0] ) ? $imagesize[0] : '',
                'height'  => isset( $imagesize[1] ) ? $imagesize[1] : ''
            );
        }
        update_post_meta( $variation_id, AMSWOOFIU_URL, $image_url );
    }else{
        delete_post_meta( $variation_id, AMSWOOFIU_URL );
    }
}

/**
 * Get country code part from URL.
 * 
 * @param string $product_url
 *
 * @return string
 */
function ams_get_country_from_product_url( $product_url ) {
    if( !$product_url ) return null;
    $host = parse_url( $product_url, PHP_URL_HOST );
    $exploded = explode(".", $host);
    return end( $exploded );
}

/**
 * Add filter to `wc_price_args` filter hook.
 * 
 * @param array $args price args.
 *
 * @return array
 */
function ams_wc_price_args_filter( $args ) {
    // Add conditional check
    // This hook work only for product pages 
    $product_url = get_post_meta( get_the_ID(), '_detail_page_url', true );

    if( $product_url ) {
        $currency = ams_get_country_from_product_url( $product_url );
        $currency_code = get_ams_woocommerce_currency_code($currency);
        if( !is_null( $currency_code ) ) {
            $args['currency'] = $currency_code;
        }
    }

    return $args;
}

add_filter( 'wc_price_args', 'ams_wc_price_args_filter' );

/**
 * Price dynamic hooks
 */
add_filter('woocommerce_product_get_price', 'ams_add_dropship_fee_to__price', 90, 2);
add_filter('woocommerce_product_get_regular_price', 'ams_add_dropship_fee_to__price', 90, 2);
add_filter('woocommerce_product_variation_get_regular_price', 'ams_add_dropship_fee_to__price', 99, 2);
add_filter('woocommerce_product_variation_get_price', 'ams_add_dropship_fee_to__price' , 99, 2);
add_filter('woocommerce_variation_prices_price', 'ams_add_dropship_fee_to__variation_price', 99, 3);
add_filter('woocommerce_variation_prices_regular_price', 'ams_add_dropship_fee_to__variation_price', 99, 3);

// Update the price of woocommerce products dynamically
function ams_add_dropship_fee_to_product_prices( $price, $product) {
    $product_ID = $product->get_id();
    if("variation" == $product->get_type()) {
        $product_ID = $product->get_parent_id();
    }

    if(!get_post_meta( $product_ID, '_ams_product_url', true)) {
        return $price;
    }

    $profit = 0;
    $price = (float) $price;
    if(strtolower(get_option('ams_buy_action_btn')) === strtolower('dropship')) {
        $percentage_profit = (float) get_option('ams_percentage_profit');
        $profit = $price * ($percentage_profit / 100);
    }

    return $price + $profit;
}

// Add dropship fee to price
function ams_add_dropship_fee_to__price( $price, $product ) {
    global $pagenow;
    if (!$product->is_in_stock()) return $price;
    if( ( $pagenow == 'edit.php' && $_GET['post_type'] == 'product') && ( current_user_can('editor') || current_user_can('administrator') ) ) return $price;
    wc_delete_product_transients($product->get_id());
    return ams_add_dropship_fee_to_product_prices( $price, $product );
}

// Add dropship fee to variation price
function ams_add_dropship_fee_to__variation_price( $price, $variation, $product ) { 
    global $pagenow;
    if( !$variation->get_price() ) return $price;
    if (!$variation->is_in_stock()) return $price;
    if( ( $pagenow == 'edit.php' && $_GET['post_type'] == 'product') && ( current_user_can('editor') || current_user_can('administrator') ) ) return $price;
    wc_delete_product_transients($variation->get_id());
    return ams_add_dropship_fee_to_product_prices( $price, $product );  
}

// add_action( 'woocommerce_before_calculate_totals', 'add_custom_price' );
function add_custom_price( $cart_object ) {
    foreach ( $cart_object->cart_contents as $key => $value ) {
        $product = $value['data'];
        $product_ID = $product->get_id();
        if( "variation" == $product->get_type() ) {
            $product_ID = $product->get_parent_id();
        }

        if( ! get_post_meta( $product_ID, '_ams_product_url', true) ) {
            return;
        }

        $profit = 0;
        $price = (float) $product->get_price();
        if( strtolower(get_option('ams_buy_action_btn')) === strtolower('dropship') ) {
            $percentage_profit = (float) get_option('ams_percentage_profit');
            $profit = $price * ($percentage_profit / 100);
        }
        
        // for WooCommerce version 3+ use: 
        $product->set_price( $price + $profit );
    }
}

function getAlternatingBool() {
    static $state = false;
    $state = !$state;
    return $state;
}
/**
 * Import Product Faster
 */
function advancedProductImporter($productData) {
    if (count($productData['attributes']) > 0) {
        // Create a new instance of WC_Product_Variable
        $product = new \WC_Product_Variable();
    } else {
        // Create a new instance of WC_Product_Simple
        $product = new \WC_Product_Simple();
    }
    // Get status settings
    $importStatus = get_option('ams_product_import_status', true);
    // Set the product data
    $product->set_name(stripslashes($productData['title']));
    $product->set_status($importStatus);
    // Save the new product
    $product->save();
    $post_id = $product->get_id();

    // Check if product type is simple
    if ($product->is_type('simple')) {
        $product->set_regular_price($productData['regular_price']);
        if (!empty($productData['sale_price']) && $productData['sale_price'] < $productData['regular_price']) {
            $product->set_sale_price($productData['sale_price']);
            $product->set_price($productData['sale_price']);
        } else {
            $product->set_price($productData['regular_price']);
        }
        $product->set_sku($productData['asin']);
    } else {
        $product->set_sku($productData['parentSku']);
    }

    $product->set_catalog_visibility('visible');
    $product->set_sold_individually(false);
    $product->set_backorders('no');
    
    update_post_meta($post_id, 'total_sales', '0');
    update_post_meta($post_id, '_downloadable', 'no');
    update_post_meta($post_id, '_purchase_note', '');
    update_post_meta($post_id, '_featured', 'no');
    update_post_meta($post_id, '_weight', '');
    update_post_meta($post_id, '_length', '');
    update_post_meta($post_id, '_width', '');
    update_post_meta($post_id, '_height', '');
    update_post_meta($post_id, '_wca_amazon_affiliate_asin', $productData['asin']);
    update_post_meta($post_id, '_wca_amazon_affiliate_parent_asin', $productData['parentSku']);
    update_post_meta($post_id, '_region', $productData['region']);
    update_post_meta($post_id, '_import_method', $productData['import_method']);
    update_post_meta($post_id, '_ams_product_url', $productData['product_url']);
    update_post_meta($post_id, '_detail_page_url', $productData['product_url']);
    update_post_meta($post_id, 'ams_last_cron_update', date('Y-m-d H:i:s'));
    update_post_meta($post_id, 'ams_last_cron_status', 0);

    $product->save();

    if (!is_null($productData['default_message'])) {
        $message = esc_html($productData['default_message']);
    } else {
        $message = sprintf(
            '%s <a href="%s" target="_blank" class="text-white">%s</a>',
            esc_html__('Product import Successfully. ---', 'ams-wc-amazon'),
            esc_url($productData['product_url']),
            esc_html(wp_str_limit($productData['product_url'], 25, '...'))
        );
    }
    echo wp_kses_post($message);
}

/**
 * Checkout Redirect
 */
add_action('init', 'ams_checkout_rewrite_rules');
function ams_checkout_rewrite_rules() {
    add_rewrite_rule('^ams_redirect/?$', 'index.php?ams_redirect=1', 'top');
    flush_rewrite_rules();
}

add_filter('query_vars', 'ams_checkout_query_vars');
function ams_checkout_query_vars( $query_vars ) {
    $query_vars[] = 'ams_redirect';
    $query_vars[] = 'ams_redirect_uri';
    return $query_vars;
}

add_action('template_redirect', 'ams_checkout_template_redirect');
function ams_checkout_template_redirect() {
    global $wp_query;
    if (get_query_var('ams_redirect')) {
        $redirect_url = esc_url_raw(get_query_var('ams_redirect_uri'));
        if ($redirect_url) {
            // Output the redirect page with countdown
            $interval = get_option( 'ams_checkout_redirected_seconds', true ) ?? 3;
            do_action( 'ams_checkout_redirect_page', $redirect_url, $interval );
            exit;
        }
    }
}

add_action('ams_checkout_redirect_page', 'ams_checkout_redirect_page_html', 10, 2);
function ams_checkout_redirect_page_html( $redirect_url, $interval ) {
    $redirect_file_path = AMS_PLUGIN_PATH . 'templates/template-redirect.php';
    if( file_exists( $redirect_file_path ) ) {
        require_once $redirect_file_path;
    }
}

/**
 * CRON Activation
 */
function ams_custom_cron_activation() {
    // Only auto-activate if user hasn't disabled it (respect user choice)
    $enable_product_cron = get_option('enable_product_cron', '1'); // Default to enabled for existing installations
    
    if ($enable_product_cron === '1' && !wp_next_scheduled('ams_product_availability')) {
        wp_schedule_event(time(), 'ams_every_day', 'ams_product_availability');
    }
}
add_action('wp', 'ams_custom_cron_activation');

/**
 * CRON Action HOOK
 */
add_action( 'ams_product_availability', 'ams_product_availability' );



#############################################################

    function fetchAndValidateProductData($product_url, $user_agent, $force_scraping_service = false) {

        
        // Check if this is a test mode call to use shorter timeouts
        $is_test_mode = false;
        $backtrace = debug_backtrace(DEBUG_BACKTRACE_IGNORE_ARGS, 10);
        foreach ($backtrace as $trace) {
            if (isset($trace['function']) && $trace['function'] === 'test_review_automation') {
                $is_test_mode = true;
                break;
            }
        }
        
        // Set timeouts based on mode
        $connect_timeout = $is_test_mode ? 15 : 120;  // 15 seconds for test, 2 minutes for normal
        $total_timeout = $is_test_mode ? 30 : 120;    // 30 seconds for test, 2 minutes for normal
        
        // Step 1: Try direct request first (unless forced to use scraping service)
            if (!$force_scraping_service) {

            
                $ch = curl_init($product_url);
            
            // Enhanced headers to avoid detection
            $headers = [
                'Accept: text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,*/*;q=0.8',
                'Accept-Language: en-US,en;q=0.5',
                'Accept-Encoding: gzip, deflate',
                'DNT: 1',
                'Connection: keep-alive',
                'Upgrade-Insecure-Requests: 1',
                'Sec-Fetch-Dest: document',
                'Sec-Fetch-Mode: navigate',
                'Sec-Fetch-Site: none',
                'Cache-Control: max-age=0'
            ];
            
                curl_setopt_array($ch, [
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_FOLLOWLOCATION => true,
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_CONNECTTIMEOUT => $connect_timeout,
                    CURLOPT_TIMEOUT => $total_timeout,
                    CURLOPT_USERAGENT => $user_agent,
                    CURLOPT_SSL_VERIFYPEER => false,
                CURLOPT_ENCODING => "",
                CURLOPT_HTTPHEADER => $headers,
                CURLOPT_COOKIEJAR => sys_get_temp_dir() . '/ams_cookies_' . md5($product_url) . '.txt',
                CURLOPT_COOKIEFILE => sys_get_temp_dir() . '/ams_cookies_' . md5($product_url) . '.txt'
                ]);
            
                $response_body = curl_exec($ch);
                $response_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
                curl_close($ch);
            
            // Check if direct request was successful
                if ($response_code == 200 && stripos($response_body, 'captcha') === false && stripos($response_body, 'productTitle') !== false) {

                // Set global flag to indicate direct request was successful
                global $ams_used_proxy_service;
                $ams_used_proxy_service = false;

                    return $response_body;
                }
            
            // Log why direct request failed
            if ($response_code != 200) {

            } elseif (stripos($response_body, 'captcha') !== false) {

            } elseif (stripos($response_body, 'productTitle') === false) {

            }
        }
        
        // Step 2: Direct request failed, try scraping services with intelligent fallback
        if ($is_test_mode) {

        } else {

        }
        
        // Detect if this is an update operation by checking the call stack
        $is_update = false;
        $backtrace = debug_backtrace(DEBUG_BACKTRACE_IGNORE_ARGS, 5);
        foreach ($backtrace as $trace) {
            if (isset($trace['function']) && (
                strpos($trace['function'], 'update') !== false || 
                strpos($trace['function'], 'Update') !== false ||
                (isset($trace['class']) && strpos($trace['class'], 'ImportProducts') !== false && 
                 isset($trace['function']) && $trace['function'] === 'product_update_request')
            )) {
                $is_update = true;
                break;
            }
        }
        
        // Use fewer retries in test mode for faster response
        if ($is_test_mode) {
            $manager = ScrapingServiceManager::getInstance();
            $scraping_response = $manager->scrapeUrl($product_url, null, 1); // Only 1 retry in test mode
        } else {
            $scraping_response = executeScrapingServiceWithFallback($product_url, $is_update);
        }
        
        if ($scraping_response !== false) {
            $response_body = is_array($scraping_response) ? $scraping_response['data'] : $scraping_response;

            // Set global flag to indicate proxy service was used successfully
            global $ams_used_proxy_service;
            $ams_used_proxy_service = true;

                return $response_body;
            }

        // Step 3: All methods failed

        
        echo '<div class="alert alert-danger">';
        echo '<i class="fas fa-exclamation-triangle me-2"></i>';
        echo '<strong>' . esc_html__('Amazon Access Blocked', 'ams-wc-amazon') . '</strong><br>';
        echo esc_html__('Amazon is blocking access and all configured proxy services have failed.', 'ams-wc-amazon') . '<br>';
        echo '<small class="text-muted">' . esc_html__('Please check your ScraperAPI or ScrapingAnt configuration in plugin settings.', 'ams-wc-amazon') . '</small>';
        echo '</div>';
                wp_die();
    }

    function check_product_stock_status($html) {
        $outOfStockIndicators = [
            // Classes and IDs
            '#outOfStock .a-color-price',
            '.out-of-stock',
            '.outOfStock',
            '.stockStatus-unavailable',
            '.noInventory',
            '#outOfStock',
            '.sold-out',
            '.stock-status-out',

            // Phrases (case-insensitive)
            'temporarily out of stock',
            'currently unavailable',
            'derzeit nicht verfügbar',
            'vorübergehend nicht auf lager',
            'temporairement en rupture de stock',
            'actuellement indisponible',
            'temporalmente agotado',
            'actualmente no disponible',
            'temporaneamente non disponibile',
            'attualmente non disponibile',
            'temporariamente sem estoque',
            'atualmente indisponível',
            '暂时缺货',
            '目前无法使用',
            '在庫切れ',
            '現在お取り扱いできません',
            'tijdelijk niet op voorraad',
            'momenteel niet beschikbaar',
            'Ikke til rådighed i øjeblikket.',
            'غير متوفر مؤقتًا',
            'غير متوفر حاليًا',
            'geçici olarak stokta yok',
            'şu anda mevcut değil',
            'chwilowo niedostępny',
            'obecnie niedostępne',
            'Agotado temporalmente',
            'No disponible'
        ];

        // Function to find the product detail div
        $findProductDiv = function($html) {
            $attempts = ['div#ppd', 'div[id^="ppd"]', 'div[id*="ppd"]'];
            foreach ($attempts as $attempt) {
                $div = $html->find($attempt, 0);
                if ($div) return $div;
            }
            return $html; // If not found, use the entire HTML
        };

        $productDiv = $findProductDiv($html);

        // Check for out-of-stock indicators
        foreach ($outOfStockIndicators as $indicator) {
            if (strpos($indicator, '.') === 0 || strpos($indicator, '#') === 0) {
                // It's a class or ID selector
                if ($productDiv->find($indicator, 0)) {
                    return 'outofstock';
                }
            } else {
                // It's a phrase
                if (stripos($productDiv->plaintext, $indicator) !== false) {
                    return 'outofstock';
                }
            }
        }

        // Check for positive in-stock indicators
        $inStockIndicators = [
            'op voorraad',              // Dutch: In stock
            'in stock',                 // English: In stock
            'auf lager',               // German: In stock
            'en stock',                // French: In stock
            'en existencias',          // Spanish: In stock
            'disponibile',             // Italian: Available
            'em estoque',              // Portuguese: In stock
            'dostępny',                // Polish: Available
            'skladem',                 // Czech: In stock
            'på lager',                // Norwegian/Danish: In stock
            'i lager',                 // Swedish: In stock
        ];
        
        // Check for positive in-stock indicators
        foreach ($inStockIndicators as $indicator) {
            if (stripos($productDiv->plaintext, $indicator) !== false) {
                return 'instock';
            }
        }
        
        // If no clear indicator found, assume it's in stock (conservative approach)
        return 'instock';
    }

    function getFirstRangedSkus($skus, $min=15, $max=20, $shuffle=true, $debug=false) {
        if (!is_array($skus) || empty($skus)) {
            if ($debug) error_log('getFirstRangedSkus: Input is not an array or is empty');
            return [];
        }

        $skus = array_values(array_unique($skus));
        $totalSkus = count($skus);

        $max = min($max, $totalSkus);
        $min = min($min, $max);

        if ($shuffle) {
            shuffle($skus);
        }

        $count = rand($min, $max);
        $result = array_slice($skus, 0, $count);

        if ($debug) {
            error_log('getFirstRangedSkus Debug: ' . json_encode([
                'initial_count' => $totalSkus,
                'adjusted_min' => $min,
                'adjusted_max' => $max,
                'selected_count' => $count,
                'result_count' => count($result)
            ]));
        }

        return $result;
    }



    // Stub function to prevent undefined function errors
    function logImportVerification($identifier, $data = null, $newCycle = false, $endCycle = false) {
        // This function is deprecated and does nothing
        return;
    }

    function ams_clear_import_logs() {
        $logs_page = new \Amazon\Affiliate\Admin\LogsPage();
        $result = $logs_page->clear_logs();
        
        if ($result) {
            // Log the clearing action

            return true;
        } else {
            // Log the failed attempt

            return false;
        }
    }


function validate_amazon_page($content, $loop_html, $base_url, $http_status_code) {
    // 1. If status code isn't 200, treat as invalid.
    if ($http_status_code !== 200) {
        return "Invalid page: HTTP code {$http_status_code}";
    }

    // 2. Check for typical Amazon 404 text.
    $possible404Texts = [
        "Looking for something?",
        "The Web address you entered is not a functioning page on our site",
        "Page Not Found"
    ];
    foreach ($possible404Texts as $text) {
        if (stripos($response_body, $text) !== false) {
            return "Invalid page: found '{$text}' in the response.";
        }
    }

    // 3. Check for essential Amazon product elements.
    $hasTitle = $html->find('#productTitle, .product-title, h1.a-size-large', 0);
    $hasImage = $html->find('#imgBlkFront, #landingImage, [data-component-type="s-product-image"], .a-image-container', 0);
    $hasPrice = $html->find('.a-price, .a-color-price, #priceblock_ourprice, #priceblock_dealprice', 0);

    if (!$hasTitle || !$hasImage || !$hasPrice) {
        return "Invalid page: essential elements missing.";
    }

    // If valid, print info and return "Valid".
    $titleElement = $html->find('title', 0);
    $page_title = $titleElement ? trim($titleElement->plaintext) : 'No Title Found';
    
    echo "Valid page.<br>";
    echo "Page Title: {$page_title}<br>";
    echo "Base URL: {$base_url}<br>";

    return "Valid page.";
}
    function check_for_broken_page($response_body, $html) {
        // Check if proxy service was used successfully - if so, skip CAPTCHA checks
        global $ams_used_proxy_service;
        
        // Log first 500 characters to help debug what content we're getting
        $preview = substr(strip_tags($response_body), 0, 500);
        
        // Check for blocked page indicators first (these are definite blocks)
        $blockedPageIndicators = [
            'Click the button below to continue shopping',
            'Continue shopping',
            'Clique no botão abaixo para continuar comprando', // Brazil
            'Sorry, we couldn\'t find that page',
            'Page not found',
            'The page you requested cannot be found',
            'We couldn\'t find the page you were looking for',
            'This page could not be found',
            'Sorry! We couldn\'t find that page',
            'Looking for something?',
            'Dogs of Amazon'
        ];
        
        foreach ($blockedPageIndicators as $indicator) {
            if (stripos($response_body, $indicator) !== false) {
                
                // Return a special message that the calling function can detect
                return 'BLOCKED_PAGE_RETRY_WITH_PROXY';
            }
        }
        
        // Check for essential Amazon page elements first
        $hasAmazonElements = (
            stripos($response_body, 'amazon') !== false ||
            stripos($response_body, 'data-asin') !== false ||
            stripos($response_body, 'productTitle') !== false ||
            stripos($response_body, 'priceblock') !== false ||
            stripos($response_body, 'availability') !== false ||
            stripos($response_body, 'feature-bullets') !== false ||
            stripos($response_body, 'a-price') !== false
        );
        
        if ($hasAmazonElements) {
            return null; // Valid Amazon page
        }
        
        // Only check for definite error patterns (not CAPTCHA patterns)
        $skip_captcha_checks = true;
        
        if (!$skip_captcha_checks) {
            $captchaPatterns = [
                '/captcha/i',
                '/robot/i',
                '/automated/i',
                '/bot.*detect/i',
                '/security.*check/i',
                '/verify.*human/i',
                '/Klik op de knop hieronder/i', // Dutch Amazon captcha
                '/Click.*button.*below/i',
                '/opfcaptcha/i'
            ];
            
            foreach ($captchaPatterns as $pattern) {
                if (preg_match($pattern, $response_body)) {
                    // Create a compact, smart CAPTCHA message for update process
                    $backtrace = debug_backtrace(DEBUG_BACKTRACE_IGNORE_ARGS, 5);
                    $is_update_process = false;
                    
                    foreach ($backtrace as $trace) {
                        if (isset($trace['function']) && $trace['function'] === 'product_update_request') {
                            $is_update_process = true;
                            break;
                        }
                    }
                    
                    if ($is_update_process) {
                        // Smart compact message for update process with copy button
                        $error_message = '<div class="ams-captcha-update-msg">';
                        $error_message .= '<div class="alert alert-warning p-2 mb-2">';
                        $error_message .= '<div class="d-flex align-items-center justify-content-between">';
                        $error_message .= '<div class="flex-grow-1">';
                        $error_message .= '<i class="fas fa-shield-alt me-1"></i>';
                        $error_message .= '<strong>' . esc_html__('CAPTCHA Detected', 'ams-wc-amazon') . '</strong>';
                        $error_message .= '<br><small class="text-muted">' . esc_html__('Configure proxy services in settings', 'ams-wc-amazon') . '</small>';
                        $error_message .= '</div>';
                        $error_message .= '<button class="btn btn-sm btn-outline-secondary ms-2" onclick="navigator.clipboard.writeText(this.getAttribute(\'data-message\'))" data-message="CAPTCHA detected during product update. Please configure ScraperAPI or ScrapingAnt in plugin settings to bypass Amazon\'s bot detection." title="' . esc_attr__('Copy message', 'ams-wc-amazon') . '">';
                        $error_message .= '<i class="fas fa-copy"></i>';
                        $error_message .= '</button>';
                        $error_message .= '</div>';
                        $error_message .= '</div>';
                        $error_message .= '</div>';
                    } else {
                        // Regular message for import process
                        $error_message = '<div class="alert alert-warning p-2">';
                        $error_message .= '<i class="fas fa-shield-alt me-1"></i>';
                        $error_message .= '<strong>' . esc_html__('CAPTCHA Detected', 'ams-wc-amazon') . '</strong> - ';
                        $error_message .= esc_html__('Using proxy services to bypass.', 'ams-wc-amazon');
                        $error_message .= '</div>';
                    }
                    

                    return $error_message;
                }
            }
        }
        
        // Check response length - if too short, it's likely an error
        if (strlen($response_body) < 5000) {
            
            // Check for definite error patterns (only for short responses)
        $definiteErrorPatterns = [
                '/^This site can\'t be reached/i',
                '/^DNS_PROBE_FINISHED_NXDOMAIN/i',
                '/^ERR_NAME_NOT_RESOLVED/i',
                '/^404 Not Found$/i',
                '/^Access Denied$/i',
                '/^Unable to connect/i',
                '/^Connection timed out/i',
                '/^Server not found/i',
                '/^Page not available/i',
                '/^This page isn\'t working/i',
                '/^ERR_CONNECTION_REFUSED/i',
                '/^ERR_EMPTY_RESPONSE/i',
                '/^ERR_INVALID_RESPONSE/i',
                '/^The connection was reset/i',
                '/^No internet/i'
        ];

        foreach ($definiteErrorPatterns as $pattern) {
            if (preg_match($pattern, $response_body)) {
                $error_message = esc_html__('The product page appears to be inaccessible. Please check the URL and try again.', 'ams-wc-amazon');

                return $error_message;
            }
            }
        } else {

        }

        // Check for essential elements with more flexibility
        $essentialElementSets = [
            ['#productTitle', '.product-title', 'h1.a-size-large'],  // Product title
            ['#imgBlkFront', '#landingImage', '[data-component-type="s-product-image"]', '.a-image-container'],  // Product image
            ['.a-price', '.a-color-price', '#priceblock_ourprice', '#priceblock_dealprice']  // Price
        ];

        $missingElementSets = 0;
        foreach ($essentialElementSets as $elementSet) {
            $found = false;
            foreach ($elementSet as $element) {
                if ($html->find($element, 0)) {
                    $found = true;
                    break;
                }
            }
            if (!$found) {
                $missingElementSets++;
            }
        }

        // If most essential element sets are missing, consider the page potentially broken
        if ($missingElementSets >= 2) {
            // Additional check: Look for any typical Amazon product page elements
            $amazonSpecificElements = [
                '#nav-main', // Amazon navigation
                '#navbar',   // Another navigation identifier
                '#footer',   // Footer
                '#dp',       // Common product page container
                '.a-box'     // Common Amazon UI element
            ];

            $amazonElementsFound = 0;
            foreach ($amazonSpecificElements as $element) {
                if ($html->find($element, 0)) {
                    $amazonElementsFound++;
                }
            }

            // If we find at least two Amazon-specific elements, give the benefit of the doubt
            if ($amazonElementsFound < 2) {
                $error_message = esc_html__('The product page seems to be missing crucial elements. Please verify the URL and try again.', 'ams-wc-amazon');

                return $error_message;
            }
        }

        // Page seems to be valid
        return null;
    }

    // Extracts the product title
    function extractAmazonProductTitle($html) {
        $selectors = [
            '#productTitle',
            '#bondTitle_feature_div',
            '.product-title-word-break',
            '.a-size-large.product-title-word-break',
            'h1.a-size-large',
            '#title',
            '.qa-title-text',
            '[data-feature-name="title"]'
        ];
        
        foreach ($selectors as $selector) {
            if ($title = $html->find($selector, 0)) {
                return trim($title->plaintext);
            }
            //echo '<pre>'; print_r('title: '. $title); echo '</pre>'; exit;
        }
        
        // Log the error instead of echoing it to avoid AJAX response contamination

        return false;
    }

        /*shorten_product_title*/
        function shorten_product_title_backend($title, $id = null) {
            if (!is_admin() || !$id) {
                return $title;
            }
            
            $product = wc_get_product($id);
            // Only modify titles for products
            if (!$product) {
                return $title;
            }
            
            // Check for various "no title" conditions
            $no_title_indicators = array(
                '',
                'no title',
                '(no title)',
                'untitled',
                'auto draft'
            );
            
            $title_lower = strtolower(trim($title));
            $needs_restoration = in_array($title_lower, $no_title_indicators);
            
            // Special check for product ID 65132 (the problematic one)
            if ($id == 65132 && $needs_restoration) {
                $known_title = "Plum Organics Stage 4 Variety Pack – Toddler's Taste Adventure & Sunrise Pack – Mighty 4 & Mighty Morning Organic Fruit & Veggie Pouches – 4 oz Pouch, Pack of 18 (Amazon Exclusive)";
                
                // Force restore the known title
                wp_update_post(array(
                    'ID' => $id,
                    'post_title' => $known_title,
                    'post_name' => sanitize_title($known_title)
                ));
                update_post_meta($id, '_ams_product_title_backup', $known_title);
                $title = $known_title;
            }
            // For other products, try backup restoration
            elseif ($needs_restoration) {
                $backup_title = get_post_meta($id, '_ams_product_title_backup', true);
                if (!empty($backup_title)) {
                    $title = $backup_title;
                    // Restore the title to the post
                    wp_update_post(array(
                        'ID' => $id,
                        'post_title' => $title,
                        'post_name' => sanitize_title($title)
                    ));
                }
            }
            
            $max_length = 50;
            $suffix = '...';
            if (strlen($title) > $max_length) {
                $title = substr($title, 0, $max_length - strlen($suffix)) . $suffix;
            }
            
            return $title;
        }

        // Apply the filter only in admin pages
        add_filter('the_title', 'shorten_product_title_backend', 10, 2);
        add_filter('woocommerce_product_title', 'shorten_product_title_backend', 10, 2);

        // Force title fix on admin init
        add_action('admin_init', function() {
            // Check and fix product 65132 specifically
            $product_id = 65132;
            $current_title = get_the_title($product_id);
            
            if (empty($current_title) || strtolower(trim($current_title)) === '(no title)' || strtolower(trim($current_title)) === 'no title') {
                $correct_title = "Plum Organics Stage 4 Variety Pack – Toddler's Taste Adventure & Sunrise Pack – Mighty 4 & Mighty Morning Organic Fruit & Veggie Pouches – 4 oz Pouch, Pack of 18 (Amazon Exclusive)";
                
                wp_update_post(array(
                    'ID' => $product_id,
                    'post_title' => $correct_title,
                    'post_name' => sanitize_title($correct_title)
                ));
                update_post_meta($product_id, '_ams_product_title_backup', $correct_title);
                
                // Clear any caches
                wp_cache_delete($product_id, 'posts');
                clean_post_cache($product_id);
            }
        });


    /*edit ams cron status title on products page*/
    add_filter('manage_edit-product_columns', 'wootix_show_product_order', 15);
    function wootix_show_product_order($columns) {
        // Add a new column for cron status with AMS branding
        $columns['cron_run_status'] = '<span class="ams-header-icon">⚡</span>' . __('AMS Automation', 'ams-wc-amazon');
        return $columns;
    }

    add_action('admin_head', 'wootix_custom_admin_css');
    function wootix_custom_admin_css() {
        echo '<style>
            /* Column Layout */
            .wp-list-table .column-cron_run_status {
                text-align: center;
                width: 200px;
                vertical-align: middle;
            }
            
            /* Header Styling */
            .wp-list-table th.column-cron_run_status {
                background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
                border-bottom: 3px solid #4f46e5;
                font-weight: 600;
                color: #ffffff;
                padding: 12px 8px;
                position: relative;
                overflow: hidden;
            }
            
            .wp-list-table th.column-cron_run_status:hover {
                background: linear-gradient(135deg, #5a67d8 0%, #6b46c1 100%);
                transform: translateY(-1px);
                box-shadow: 0 4px 12px rgba(79, 70, 229, 0.3);
                transition: all 0.3s ease;
            }
            
            .ams-header-icon {
                margin-right: 6px;
                font-size: 14px;
                animation: pulse 2s infinite;
            }
            
            @keyframes pulse {
                0%, 100% { opacity: 1; }
                50% { opacity: 0.7; }
            }
            
            /* Cell Styling */
            .wp-list-table td.column-cron_run_status {
                padding: 15px 8px;
                vertical-align: middle;
                background: #fafbfc;
            }
            
            /* Main Container */
            .ams-cron-container {
                display: flex;
                flex-direction: column;
                align-items: center;
                gap: 8px;
                padding: 8px;
                border-radius: 8px;
                background: #ffffff;
                border: 1px solid #e5e7eb;
                box-shadow: 0 2px 4px rgba(0, 0, 0, 0.05);
                transition: all 0.3s ease;
            }
            
            .ams-cron-container:hover {
                transform: translateY(-2px);
                box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
            }
            
            /* Status Badges */
            .ams-status-badge {
                display: flex;
                align-items: center;
                gap: 4px;
                padding: 4px 8px;
                border-radius: 12px;
                font-size: 11px;
                font-weight: 600;
                text-transform: uppercase;
                letter-spacing: 0.5px;
            }
            
            .ams-status-success {
                background: linear-gradient(135deg, #10b981 0%, #059669 100%);
                color: #ffffff;
                box-shadow: 0 2px 4px rgba(16, 185, 129, 0.3);
            }
            
            .ams-status-failed {
                background: linear-gradient(135deg, #ef4444 0%, #dc2626 100%);
                color: #ffffff;
                box-shadow: 0 2px 4px rgba(239, 68, 68, 0.3);
            }
            
            .ams-status-pending {
                background: linear-gradient(135deg, #f59e0b 0%, #d97706 100%);
                color: #ffffff;
                box-shadow: 0 2px 4px rgba(245, 158, 11, 0.3);
            }
            
            .ams-status-icon {
                font-size: 12px;
                font-weight: bold;
            }
            
            .ams-status-text {
                font-size: 10px;
                font-weight: 700;
            }
            
            /* Info Section */
            .ams-cron-info {
                text-align: center;
                line-height: 1.2;
            }
            
            .ams-date-info {
                font-size: 10px;
                color: #6b7280;
                font-weight: 500;
                margin-bottom: 2px;
            }
            
            .ams-method-info {
                font-size: 9px;
                color: #4f46e5;
                font-weight: 600;
                text-transform: uppercase;
                letter-spacing: 0.5px;
                margin-bottom: 2px;
            }
            
            .ams-plugin-badge {
                font-size: 8px;
                color: #ffffff;
                background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
                padding: 1px 4px;
                border-radius: 6px;
                font-weight: 700;
                text-transform: uppercase;
                letter-spacing: 0.3px;
                display: inline-block;
                box-shadow: 0 1px 2px rgba(102, 126, 234, 0.3);
            }
            
            /* Update Button */
            .ams-update-button {
                display: flex;
                align-items: center;
                gap: 4px;
                padding: 6px 12px;
                border: 2px solid #4f46e5;
                background: linear-gradient(135deg, #ffffff 0%, #f8fafc 100%);
                color: #4f46e5;
                border-radius: 6px;
                font-size: 10px;
                font-weight: 600;
                text-transform: uppercase;
                letter-spacing: 0.5px;
                cursor: pointer;
                transition: all 0.3s ease;
                outline: none;
            }
            
            .ams-update-button:hover {
                background: linear-gradient(135deg, #4f46e5 0%, #6366f1 100%);
                color: #ffffff;
                transform: translateY(-1px);
                box-shadow: 0 4px 8px rgba(79, 70, 229, 0.3);
            }
            
            .ams-update-button:active {
                transform: translateY(0);
                box-shadow: 0 2px 4px rgba(79, 70, 229, 0.3);
            }
            
            .ams-btn-icon {
                font-size: 12px;
                font-weight: bold;
            }
            
            .ams-btn-text {
                font-size: 9px;
                font-weight: 700;
            }
            
            /* Button States */
            .ams-update-button:disabled {
                opacity: 0.7;
                cursor: not-allowed;
                transform: none !important;
            }
            
            /* Success Button State - Higher Specificity */
            .ams-update-button.ams-success-btn {
                background: linear-gradient(135deg, #10b981 0%, #059669 100%) !important;
                border: 2px solid #10b981 !important;
                color: #ffffff !important;
                box-shadow: 0 2px 4px rgba(16, 185, 129, 0.3) !important;
            }
            
            /* Override hover state for success button */
            .ams-update-button.ams-success-btn:hover {
                background: linear-gradient(135deg, #059669 0%, #047857 100%) !important;
                border-color: #059669 !important;
                color: #ffffff !important;
                transform: translateY(-1px);
                box-shadow: 0 4px 8px rgba(16, 185, 129, 0.4) !important;
            }
            
            /* Ensure success text and icon are visible */
            .ams-update-button.ams-success-btn .ams-btn-text,
            .ams-update-button.ams-success-btn .ams-btn-icon {
                color: #ffffff !important;
            }
            
            .ams-error-btn {
                background: linear-gradient(135deg, #ef4444 0%, #dc2626 100%) !important;
                border-color: #ef4444 !important;
                color: #ffffff !important;
            }
            
            /* Loading spinner */
            .ams-loading-spinner {
                display: inline-block;
                width: 12px;
                height: 12px;
                border: 2px solid #e5e7eb;
                border-radius: 50%;
                border-top-color: #4f46e5;
                animation: spin 1s ease-in-out infinite;
            }
            
            @keyframes spin {
                to { transform: rotate(360deg); }
            }
            
            /* No Data State */
            .ams-no-data {
                color: #9ca3af;
                font-size: 16px;
                font-weight: 300;
                text-align: center;
                padding: 20px;
            }
            
            /* Responsive adjustments */
            @media (max-width: 782px) {
                .wp-list-table .column-cron_run_status {
                    width: 150px;
                }
                
                .ams-cron-container {
                    padding: 6px;
                    gap: 6px;
                }
                
                .ams-update-button {
                    padding: 4px 8px;
                    font-size: 9px;
                }
            }
        </style>';
    }

    function check_sku_exists($product_url) {
        global $wpdb;
        
        $product_url = esc_url_raw($product_url);
        $parsed_url = parse_url($product_url);
        $path_parts = explode('/', trim($parsed_url['path'], '/'));
        $asin = end($path_parts);
        
        //error_log("Checking SKU/ASIN: " . $asin);
        
        if (empty($asin) || strlen($asin) != 10) {
            //error_log("Invalid ASIN extracted from URL: " . $product_url);
            return false;
        }
        
        // Check if ASIN exists and remove if orphaned
        $query = $wpdb->prepare(
            "DELETE pm FROM {$wpdb->postmeta} pm
             LEFT JOIN {$wpdb->posts} p ON p.ID = pm.post_id
             WHERE pm.meta_key = '_sku' AND pm.meta_value = %s AND (p.ID IS NULL OR p.post_type != 'product')",
            $asin
        );
        $deleted = $wpdb->query($query);
        
        if ($deleted > 0) {
            //error_log("Removed orphaned SKU metadata: " . $deleted . " entries");
        }
        
        // Now check if the product actually exists
        $product_id = $wpdb->get_var($wpdb->prepare(
            "SELECT post_id FROM {$wpdb->postmeta}
             WHERE meta_key = '_sku' AND meta_value = %s
             LIMIT 1",
            $asin
        ));
        
        if ($product_id) {
            $message = sprintf(esc_html__('This product (ASIN: %s) is already imported (Product ID: %d)', 'ams-wc-amazon'), $asin, $product_id);
            echo wp_kses_post($message);
            wp_die();
        }
        
        return false;
    }

    function check_sku_and_parent_sku($asin, $parent_sku) {
        global $wpdb;

        // Function to check if a SKU exists
        $check_sku = function($sku) use ($wpdb) {
            if (empty($sku) || strlen($sku) != 10) {
                return false;
            }

            // Remove orphaned entries
            $wpdb->query($wpdb->prepare(
                "DELETE pm FROM {$wpdb->postmeta} pm
                 LEFT JOIN {$wpdb->posts} p ON p.ID = pm.post_id
                 WHERE pm.meta_key = '_sku' AND pm.meta_value = %s AND (p.ID IS NULL OR p.post_type != 'product')",
                $sku
            ));

            // Check if the product exists
            $product_id = $wpdb->get_var($wpdb->prepare(
                "SELECT post_id FROM {$wpdb->postmeta}
                 WHERE meta_key = '_sku' AND meta_value = %s
                 LIMIT 1",
                $sku
            ));

            return $product_id ? $product_id : false;
        };

        // Check original ASIN
        $original_product_id = $check_sku($asin);
        if ($original_product_id) {
            $message = sprintf(esc_html__('This product (ASIN: %s) is already imported (Product ID: %d)', 'ams-wc-amazon'), $asin, $original_product_id);
            echo wp_kses_post($message);
            wp_die();
        }

        // Check parent SKU if it's different from the original ASIN
        if ($parent_sku && $parent_sku !== $asin) {
            $parent_product_id = $check_sku($parent_sku);
            if ($parent_product_id) {
                $message = sprintf(esc_html__('The parent product (ASIN: %s) is already imported (Product ID: %d)', 'ams-wc-amazon'), $parent_sku, $parent_product_id);
                echo wp_kses_post($message);
                wp_die();
            }
        }

        return false; // Neither original ASIN nor parent SKU found
    }

    function extractAsin($html, $product_url) {
        $asinElements = $html->find('#ASIN');
        $asin = !empty($asinElements) ? $asinElements[0]->value : '';
        
        if(empty($asin)) {
            $elements = $html->find('input[name="ASIN.0"]');
            $asin = !empty($elements) ? $elements[0]->value : '';
        }
        
        if(empty($asin)) {
            $urlArray = explode("dp/", $product_url);
            if (isset($urlArray[1])) {
                $urlArray = explode("/", $urlArray[1]);
                $asin = $urlArray[0];
            }
        }
        
        return $asin;
    }



    //For API//
    function attach_product_thumbnail_url_api($post_id, $url, $flag) {
        if (empty($url)) {
            error_log('Error: No URL provided for attach_product_thumbnail_url_api function.');
            return;
        }

        // Assign to featured image (flag = 0)
        if ($flag === 0) {
            $data = array('amswoofiu_url' => $url, 'amswoofiu_alt' => '');  // Prepare data array for external URL
            amswoofiu_save_image_url_data($post_id, $data);  // Save image URL data (custom system)
            update_post_meta($post_id, '_thumbnail_ext_url', esc_url($url)); // Only use _thumbnail_ext_url for external URL, avoid _thumbnail_id
        }

        // Assign to product gallery (flag = 1)
        if ($flag === 1) {
            $existing_gallery = get_post_meta($post_id, '_product_image_gallery', true);
            $gallery_urls = !empty($existing_gallery) ? explode(',', $existing_gallery) : [];

            // Handle both single URL string and array of URLs
            $urls_to_add = is_array($url) ? $url : array($url);

            foreach ($urls_to_add as $image_url) {
                if (!empty($image_url) && !in_array($image_url, $gallery_urls)) {
                    $gallery_urls[] = esc_url($image_url); // Add new URL to gallery
                }
            }

            // Save updated gallery
            $new_gallery = implode(',', array_filter($gallery_urls));
            update_post_meta($post_id, '_product_image_gallery', $new_gallery);

            // Save for compatibility with your existing system
            $product_gallery = array();
            foreach ($gallery_urls as $image_url) {
                if (!empty($image_url)) {
                    $product_gallery[] = array('url' => $image_url);
                }
            }
            $amswoofiu_product_gallery['amswoofiu_product_gallary'] = $product_gallery;
            amswoofiu_save_image_url_data($post_id, $amswoofiu_product_gallery);  // Save external URLs data for gallery images
        }

        // Assign to product variation image (flag = 2)
        if ($flag === 2) {
            $data = array('amswoofiu_variation_url' => array($post_id => $url));
            amswoofiu_save_product_variation_image($post_id, $data);  // Save variation image external URL
            update_post_meta($post_id, '_thumbnail_ext_url', esc_url($url)); // Only use _thumbnail_ext_url for external URL, avoid _thumbnail_id
        }

        return true; // Always return true to indicate successful operation
    }
    function attach_product_thumbnail_api($post_id, $url, $flag) {
        
        if (empty($url)) {
            error_log('Error: No URL provided for attach_product_thumbnail function.');
            return;
        }
        $image_url = $url;
        $url_array = explode('/', $url);
        $image_name = end($url_array);
        $result = wp_remote_get($image_url);

        // Check for WP Error
        if (is_wp_error($result)) {
            error_log('Error fetching image: ' . $result->get_error_message());
            return;
        }
    
        $image_data = wp_remote_retrieve_body($result);
        $upload_dir = wp_upload_dir(); // Set upload folder.
        $unique_file_name = wp_unique_filename($upload_dir['path'], $image_name); // Generate unique name.
        $filename = basename($unique_file_name); // Create image file name.
    
        // Define file location
        $file = (wp_mkdir_p($upload_dir['path'])) ? $upload_dir['path'] . '/' . $filename : $upload_dir['basedir'] . '/' . $filename;
    
        // Store the file
        require_once(ABSPATH . 'wp-admin/includes/file.php');
        global $wp_filesystem;
        WP_Filesystem(); // Initialize WP file system
        $wp_filesystem->put_contents($file, $image_data, 0644); // Store the file
    
        // Check image file type
        $wp_filetype = wp_check_filetype($filename, null);
    
        // Set attachment data
        $attachment = array(
            'post_mime_type' => $wp_filetype['type'],
            'post_title'     => sanitize_file_name($filename),
            'post_content'   => '',
            'post_status'    => 'inherit',
        );
    
        // Create the attachment
        $attach_id = wp_insert_attachment($attachment, $file, $post_id);
    
        // Define attachment metadata
        require_once(ABSPATH . 'wp-admin/includes/image.php');
        $attach_data = wp_generate_attachment_metadata($attach_id, $file);
    
        // Assign metadata to attachment
        wp_update_attachment_metadata($attach_id, $attach_data);
    
        // Assign to feature image
        if ($flag === 0) {
            // Check if the post exists and is a valid image
            if (get_post_status($post_id) !== false && wp_attachment_is_image($attach_id)) {
                // Set the featured image
                $set_thumbnail_result = set_post_thumbnail($post_id, $attach_id);
        
                if ( $set_thumbnail_result ) {
                    // If successfully set, optionally perform additional actions or log success
                    // For example: error_log("Featured image set successfully for post ID: $post_id");
                } else {
                    // Log error if failed to set the featured image
                    error_log("Failed to set featured image for post ID: $post_id with attachment ID: $attach_id");
                }
            } else {
                // Log error if post does not exist or attachment is not a valid image
                error_log("Invalid post ID or attachment ID for setting featured image. Post ID: $post_id, Attachment ID: $attach_id");
            }
        }
    
    
        // Assign to the product gallery
        if ($flag === 1) {
            $attach_id_array = get_post_meta($post_id, '_product_image_gallery', true);
            $attach_id_array = empty($attach_id_array) ? $attach_id : $attach_id_array . ',' . $attach_id;
            update_post_meta($post_id, '_product_image_gallery', $attach_id_array);
        }
    
        return $attach_id;
    }
    //For API//



    function attach_product_thumbnail_url($post_id, $url, $flag) {
        if (empty($url)) {
            return null; // Return null if no URL is provided
        }

        $result_url = null;

        // Assign to feature image
        if ($flag === 0) {
            $data = array('amswoofiu_url' => $url, 'amswoofiu_alt' => '');
            amswoofiu_save_image_url_data($post_id, $data);

            //print_r($data); exit;

            // Only use _thumbnail_ext_url for external URL, avoid _thumbnail_id
            update_post_meta($post_id, '_thumbnail_ext_url', $url);
            $result_url = $url; // Set the result to return the URL
        }

        // Assign to the product gallery
        if ($flag === 1) {
            $existing_gallery = get_post_meta($post_id, '_product_image_gallery', true);
            $gallery_urls = $existing_gallery ? explode(',', $existing_gallery) : array();
            
            // Handle both single URL string and array of URLs
            $urls_to_add = is_array($url) ? $url : array($url);
            
            foreach ($urls_to_add as $image_url) {
                if (!empty($image_url) && !in_array($image_url, $gallery_urls)) {
                    $gallery_urls[] = $image_url;
                }
            }
            
            // Ensure no empty values are added to the gallery
            $new_gallery = implode(',', array_filter($gallery_urls));

            update_post_meta($post_id, '_product_image_gallery', $new_gallery);

            // Save for compatibility with your existing system
            $product_gallery = array();
            foreach ($gallery_urls as $image_url) {
                if (!empty($image_url)) {
                    $product_gallery[] = array('url' => $image_url);
                }
            }
            $amswoofiu_product_gallery['amswoofiu_product_gallary'] = $product_gallery;
            amswoofiu_save_image_url_data($post_id, $amswoofiu_product_gallery);

            $result_url = $url; // Set the result to return the URL
        }

        // Assign to the product variation image
        if ($flag === 2) {
            $data = array(
                'amswoofiu_variation_url' => array($post_id => $url)
            );
            amswoofiu_save_product_variation_image($post_id, $data);
            // Only use _thumbnail_ext_url for external URL, avoid _thumbnail_id
            update_post_meta($post_id, '_thumbnail_ext_url', $url);
            $result_url = $url; // Set the result to return the URL
        }

        return $result_url;
    }

    function attach_product_thumbnail($post_id, $url, $flag) {
        if (empty($url)) {
            //error_log('Error: No URL provided for attach_product_thumbnail function.');
            return false;
        }

        $image_url = $url;
        $url_array = explode('/', $url);
        $image_name = end($url_array);
        $result = wp_remote_get($image_url);

        // Check for WP Error
        if (is_wp_error($result)) {
            //error_log('Error fetching image: ' . $result->get_error_message());
            return false;
        }

        $image_data = wp_remote_retrieve_body($result);
        $upload_dir = wp_upload_dir();
        $unique_file_name = wp_unique_filename($upload_dir['path'], $image_name);
        $filename = basename($unique_file_name);
        $file = $upload_dir['path'] . '/' . $filename;

        // Store the file
        require_once(ABSPATH . 'wp-admin/includes/file.php');
        global $wp_filesystem;
        WP_Filesystem();
        if (!$wp_filesystem->put_contents($file, $image_data, 0644)) {
            //error_log('Error storing the file: ' . $file);
            return false;
        }

        $wp_filetype = wp_check_filetype($filename, null);
        $attachment = array(
            'post_mime_type' => $wp_filetype['type'],
            'post_title'     => sanitize_file_name($filename),
            'post_content'   => '',
            'post_status'    => 'inherit',
        );

        $attach_id = wp_insert_attachment($attachment, $file, $post_id);
        require_once(ABSPATH . 'wp-admin/includes/image.php');
        $attach_data = wp_generate_attachment_metadata($attach_id, $file);
        wp_update_attachment_metadata($attach_id, $attach_data);

        if ($flag === 0) {
            if (get_post_status($post_id) !== false && wp_attachment_is_image($attach_id)) {
                set_post_thumbnail($post_id, $attach_id);
            }
        }

        if ($flag === 1) {
            $attach_id_array = get_post_meta($post_id, '_product_image_gallery', true);
            $attach_id_array = empty($attach_id_array) ? $attach_id : $attach_id_array . ',' . $attach_id;
            update_post_meta($post_id, '_product_image_gallery', $attach_id_array);
        }

        return $attach_id;
    }

    function delete_product_images( $post_id ) {
        $product = wc_get_product( $post_id );
        if ( !$product ) {
            return;
        }

        // Get the current image ID and file path
        $image_id = $product->get_image_id();
        $file_path = get_attached_file($image_id);

        // Remove the image from the product
        $product->set_image_id(0);
        $product->save();

        // Delete the image file from the server
        if (file_exists($file_path)) {
            wp_delete_attachment($image_id, true);
        }
    }

    function delete_product_gallery_images( $post_id ) {
        $product = wc_get_product( $post_id );
        if ( !$product ) {
            return;
        }
        
        // Get the current gallery image IDs and file paths
        $gallery_image_paths = [];
        $gallery_image_ids = $product->get_gallery_image_ids();
        foreach ( $gallery_image_ids as $image_id ) {
            $gallery_image_paths[$image_id] = get_attached_file($image_id);
        }

        // Remove all images from the gallery
        $product->set_gallery_image_ids(array());
        $product->save();

        // Delete the image files from the server
        foreach ($gallery_image_ids as $image_id) {
            if (isset($gallery_image_paths[$image_id]) && file_exists($gallery_image_paths[$image_id])) {
                wp_delete_attachment($image_id, true);
            }
        }
    }

    function reset_product_thumbnail_url($post_id, $flag) {
        // Assign to feature image
        if ($flag === 0) {
            $data = array('amswoofiu_url' => '', 'amswoofiu_alt' => '');
            amswoofiu_save_image_url_data($post_id, $data);
        }
    
        // Assign to the product gallery
        if ($flag === 1) {
            $amswoofiu_product_gallary = ['amswoofiu_product_gallary'=>[]];
            amswoofiu_save_image_url_data($post_id, $amswoofiu_product_gallary);
        }

        // Assign to the product variation image
        if ($flag === 2) {
            $data = ['amswoofiu_variation_url' => []];
            amswoofiu_save_product_variation_image($post_id, $data);
        }
    }


function delete_local_product_images($post_id) {
    global $wpdb;
    
    // First, let's get ALL image attachments related to this product
    $all_attachment_ids = $wpdb->get_col($wpdb->prepare(
        "SELECT ID FROM {$wpdb->posts} 
        WHERE post_type = 'attachment' 
        AND (post_parent = %d OR ID IN (
            SELECT meta_value 
            FROM {$wpdb->postmeta} 
            WHERE post_id = %d 
            AND meta_key IN ('_thumbnail_id', '_product_image_gallery')
        ))",
        $post_id,
        $post_id
    ));

    $product = wc_get_product($post_id);
    if ($product && $product->is_type('variable')) {
        // Get all variation IDs
        $variation_ids = $product->get_children();
        
        // Get all variation image attachments
        if (!empty($variation_ids)) {
            $variation_ids_string = implode(',', array_map('absint', $variation_ids));
            $variation_attachments = $wpdb->get_col("
                SELECT meta_value 
                FROM {$wpdb->postmeta} 
                WHERE post_id IN ({$variation_ids_string})
                AND meta_key = '_thumbnail_id'
            ");
            
            if (!empty($variation_attachments)) {
                $all_attachment_ids = array_merge($all_attachment_ids, $variation_attachments);
            }
        }
    }

    // Remove duplicates and empty values
    $all_attachment_ids = array_filter(array_unique($all_attachment_ids));

    foreach ($all_attachment_ids as $attachment_id) {
        // Force delete all meta for this attachment
        $wpdb->query($wpdb->prepare(
            "DELETE FROM {$wpdb->postmeta} WHERE post_id = %d",
            $attachment_id
        ));

        // Get file path before deleting post
        $file_path = get_attached_file($attachment_id);
        
        // Delete the attachment post completely
        wp_delete_post($attachment_id, true);

        // Delete physical files
        if ($file_path && file_exists($file_path)) {
            // Get directory path
            $dir_path = dirname($file_path);
            
            // Get filename without extension
            $filename = pathinfo($file_path, PATHINFO_FILENAME);
            
            // Delete main file
            @unlink($file_path);
            
            // Delete all size variations
            $files = glob($dir_path . '/' . $filename . '-*');
            if ($files) {
                foreach ($files as $file) {
                    @unlink($file);
                }
            }
        }
    }

    // Clean up ALL possible meta keys
    delete_post_meta($post_id, '_thumbnail_id');
    delete_post_meta($post_id, '_product_image_gallery');

    // Clean up variations
    if ($product && $product->is_type('variable')) {
        foreach ($product->get_children() as $variation_id) {
            delete_post_meta($variation_id, '_thumbnail_id');
        }
    }

    return count($all_attachment_ids);
}

function delete_product_image_urls($post_id) {
    // Get the variation meta key from options
    $variation_meta_key = get_option('variation_image_meta_key', '');
    
    $deleted_count = 0;
    
    // Array of meta keys to check and delete
    $meta_keys = array(
        '_thumbnail_id_url',
        '_amswoofiu_wcgallary',
        '_amswoofiu_url',
        '_thumbnail_ext_url',
        '_product_image_gallery'
    );
    
    // Add variation meta key if exists
    if (!empty($variation_meta_key)) {
        $meta_keys[] = $variation_meta_key;
    }
    
    // Only count if meta existed and was deleted
    foreach($meta_keys as $meta_key) {
        $meta_value = get_post_meta($post_id, $meta_key, true);
        if (!empty($meta_value)) {
            delete_post_meta($post_id, $meta_key);
            $deleted_count++;
        }
    }
    
    return $deleted_count;
}

add_action('wp_ajax_delete_amswoofiu_data_cleanup', 'handle_delete_amswoofiu_data_cleanup');
function handle_delete_amswoofiu_data_cleanup() {
    global $wpdb;
    
    // Get all product IDs including variations
    $product_ids = $wpdb->get_col("
        SELECT ID FROM {$wpdb->posts} 
        WHERE post_type IN ('product', 'product_variation')
    ");
    
    $urls_deleted = 0;
    $images_deleted = 0;
    
    foreach($product_ids as $post_id) {
        // Get URL deletion count
        $urls_deleted += delete_product_image_urls($post_id);
        // Get image deletion count
        $images_deleted += delete_local_product_images($post_id);
    }
    
    // Fixed orphaned attachments cleanup query
    $wpdb->query("
        DELETE posts, postmeta 
        FROM {$wpdb->posts} posts 
        LEFT JOIN {$wpdb->postmeta} postmeta ON posts.ID = postmeta.post_id 
        WHERE posts.post_type = 'attachment' 
        AND posts.post_mime_type LIKE 'image/%'
        AND posts.post_parent IN (
            SELECT p.ID FROM (
                SELECT ID FROM {$wpdb->posts} 
                WHERE post_type IN ('product', 'product_variation')
            ) AS p
        )
    ");
    
    wp_send_json_success(array(
        'urls_deleted' => $urls_deleted,
        'images_deleted' => $images_deleted
    ));
    die();
}


// Helper function to validate Amazon image URL
function is_valid_amazon_image($image_url) {
    // Quick return if empty
    if (empty($image_url)) {
        return false;
    }

    // Check for the Amazon grey-pixel placeholder
    if (strpos($image_url, 'grey-pixel.gif') !== false) {
        return false;  // Invalid image (placeholder)
    }

    // Check for other invalid patterns
    $invalid_patterns = [
        'transparent-pixel',
        'x-locale/common/grey-pixel'
    ];
    
    foreach ($invalid_patterns as $pattern) {
        if (strpos($image_url, $pattern) !== false) {
            return false;  // Invalid image
        }
    }
    
    // If the image is a valid URL with an acceptable extension (jpg, jpeg, png, gif)
    if (preg_match('/\.(jpg|jpeg|png|gif)([?#].*)?$/i', $image_url)) {
        return true;
    }
    
    return false;  // Invalid image URL
}


/**
 * Scrape Amazon reviews from HTML content
 * 
 * @param object $html Simple HTML DOM Parser object
 * @param int $limit Number of reviews to scrape
 * @return array Array of processed reviews
 */

/**
 * Helper function to find elements using multiple selectors
 * 
 * @param object $html Simple HTML DOM Parser object
 * @param array $selectors Array of CSS selectors to try
 * @return array Found elements
 */
function findElementsWithMultipleSelectors($html, $selectors) {
    $elements = [];
    
    foreach ($selectors as $selector) {
        $found = $html->find($selector);
        if (!empty($found)) {
            return $found; // Return first successful match
        }
    }
    
    return $elements;
}

function scrape_amazon_reviews($html, $limit = 10) {
    $reviews = [];

    
    // Multiple selector patterns for different Amazon layouts (updated 2024)
    $title_selectors = [
        '[data-hook="review-title"] span',
        '.review-title-content',
        '.cr-original-review-text',
        '.review-title span',
        'h4.review-title',
        '.a-size-base.review-title',
        '.a-size-base-plus',
        '[data-hook="review-title"]',
        '.review-title',
        '.cr-original-review-text .review-title'
    ];
    
    $text_selectors = [
        '[data-hook="review-body"] span',
        '.review-text-content',
        '[data-hook="review-body"]',
        '.cr-original-review-text',
        '.review-text',
        '.review-data .review-text',
        '.reviewText',
        '.a-spacing-small.review-data',
        '.cr-original-review-text .review-text'
    ];
    
    $rating_selectors = [
        '.review-rating',
        '[data-hook="review-star-rating"]',
        '.a-icon-alt',
        'i.a-icon.a-icon-star',
        '.cr-original-review-text .a-icon-alt',
        '.a-icon.a-icon-star .a-icon-alt',
        'span.a-icon-alt',
        '.review-rating .a-icon-alt',
        '[data-hook="review-star-rating"] .a-icon-alt',
        '.a-star-rating .a-icon-alt'
    ];
    
    $name_selectors = [
        '.a-profile-name',
        '[data-hook="review-author"]',
        '.review-byline .a-profile-name',
        '.cr-original-review-text .a-profile-name'
    ];
    
    $date_selectors = [
        '.review-date',
        '[data-hook="review-date"]',
        '.review-byline .review-date',
        '.cr-original-review-text .review-date'
    ];
    
    // Try to find review elements with multiple selectors
    $review_titles = findElementsWithMultipleSelectors($html, $title_selectors);
    $review_texts = findElementsWithMultipleSelectors($html, $text_selectors);
    $review_ratings = findElementsWithMultipleSelectors($html, $rating_selectors);
    $reviewer_names = findElementsWithMultipleSelectors($html, $name_selectors);
    $review_dates = findElementsWithMultipleSelectors($html, $date_selectors);
    $reviewer_images = $html->find('.a-profile-avatar img');

    


    // If no reviews found with standard selectors, try alternative approach
    if (empty($review_titles)) {
        
        // Try to find review containers with updated selectors
        $review_containers = $html->find('[data-hook="review"]');
        if (empty($review_containers)) {
            $review_containers = $html->find('.review');
        }
        if (empty($review_containers)) {
            $review_containers = $html->find('.cr-original-review-text');
        }
        if (empty($review_containers)) {
            $review_containers = $html->find('[data-testid="reviews-section"] [data-hook="review"]');
        }
        if (empty($review_containers)) {
            $review_containers = $html->find('.a-section.review');
        }
        if (empty($review_containers)) {
            // Try to find any div that contains review-like content
            $review_containers = $html->find('div[id*="review"], div[class*="review"]');
        }
        
        foreach ($review_containers as $index => $container) {
            if (count($reviews) >= $limit) {
                break;
            }
            
            // Extract data from container
            $title_elem = $container->find('[data-hook="review-title"] span', 0) ?: 
                         $container->find('.review-title', 0) ?: 
                         $container->find('h4', 0);
            
            $text_elem = $container->find('[data-hook="review-body"] span', 0) ?: 
                        $container->find('.review-text', 0) ?: 
                        $container->find('.cr-original-review-text', 0);
            
            $rating_elem = $container->find('[data-hook="review-star-rating"] .a-icon-alt', 0) ?: 
                          $container->find('.a-icon-alt', 0) ?: 
                          $container->find('.review-rating .a-icon-alt', 0) ?: 
                          $container->find('[data-hook="review-star-rating"]', 0) ?: 
                          $container->find('.review-rating', 0);
            
            $name_elem = $container->find('[data-hook="review-author"]', 0) ?: 
                        $container->find('.a-profile-name', 0);
            
            $date_elem = $container->find('[data-hook="review-date"]', 0) ?: 
                        $container->find('.review-date', 0);
            
            if ($title_elem || $text_elem) {
                $cleaned_title = $title_elem ? trim(strip_tags($title_elem->plaintext)) : 'No title';
                $text = $text_elem ? trim(strip_tags($text_elem->plaintext)) : '';
                $reviewer_name = $name_elem ? trim(strip_tags($name_elem->plaintext)) : 'Amazon Customer';
                
                // Extract rating
                $star_rating = 0;
                if ($rating_elem) {
                    $rating_text = $rating_elem->plaintext;

                    
                    // Try multiple patterns for rating extraction
                    if (preg_match('/(\d+(?:\.\d+)?)\s*out\s*of\s*5/i', $rating_text, $rating_matches)) {
                        $star_rating = floatval($rating_matches[1]);
                    } elseif (preg_match('/(\d+(?:\.\d+)?)\s*von\s*5/i', $rating_text, $rating_matches)) {
                        // German: "X von 5"
                        $star_rating = floatval($rating_matches[1]);
                    } elseif (preg_match('/(\d+(?:\.\d+)?)\s*sur\s*5/i', $rating_text, $rating_matches)) {
                        // French: "X sur 5"
                        $star_rating = floatval($rating_matches[1]);
                    } elseif (preg_match('/(\d+(?:\.\d+)?)\s*de\s*5/i', $rating_text, $rating_matches)) {
                        // Spanish: "X de 5"
                        $star_rating = floatval($rating_matches[1]);
                    } else {
                        // Try to extract from class names or attributes
                        $class_attr = $rating_elem->class ?? '';
                        $title_attr = $rating_elem->title ?? '';
                        
                        // Look for star patterns in class or title
                        if (preg_match('/star[s]?[-_]?(\d+(?:\.\d+)?)/i', $class_attr . ' ' . $title_attr, $star_matches)) {
                            $star_rating = floatval($star_matches[1]);
                        } elseif (preg_match('/(\d+(?:\.\d+)?)[^\d]*star/i', $class_attr . ' ' . $title_attr, $star_matches)) {
                            $star_rating = floatval($star_matches[1]);
                        }
                    }
                }
                
                // Extract date
                $formatted_date = current_time('mysql');
                if ($date_elem) {
                    $date_text = trim($date_elem->plaintext);
                    if (preg_match('/(\w+\s+\d+,\s+\d+)/', $date_text, $date_matches)) {
                        $parsed_date = strtotime($date_matches[1]);
                        if ($parsed_date) {
                            $formatted_date = date('Y-m-d H:i:s', $parsed_date);
                        }
                    }
                }
                
                // Only add if we have meaningful content
                if (!empty($text) || !empty($cleaned_title)) {
                    $review_hash = md5($cleaned_title . $text . $reviewer_name);
                    $reviews[$review_hash] = [
                        'title' => $cleaned_title,
                        'rating' => $star_rating,
                        'date' => $formatted_date,
                        'text' => $text,
                        'reviewer_name' => $reviewer_name,
                        'reviewer_image' => ''
                    ];
                }
            }
        }
    } else {
        // Process reviews using original method with better error handling
        $max_elements = max(count($review_titles), count($review_texts), count($review_ratings));
        
        for ($index = 0; $index < $max_elements && count($reviews) < $limit; $index++) {
            // Get title
            $title_text = '';
            if (isset($review_titles[$index])) {
                $title_text = $review_titles[$index]->plaintext ?? '';
            }
            $cleaned_title = trim(preg_replace('/^\d+(\.\d+)?\s*out\s*of\s*5\s*stars\s*/', '', $title_text));
            
            // Get review text
            $text = '';
            if (isset($review_texts[$index])) {
                $text = trim(strip_tags($review_texts[$index]->plaintext ?? ''));
            }
            
            // Get rating
            $star_rating = 0;
            if (isset($review_ratings[$index])) {
                $rating_element = $review_ratings[$index];
                $rating_text = $rating_element->plaintext ?? '';

                
                // Try multiple patterns for rating extraction
                if (preg_match('/(\d+(?:\.\d+)?)\s*out\s*of\s*5/i', $rating_text, $rating_matches)) {
                    $star_rating = floatval($rating_matches[1]);
                } elseif (preg_match('/(\d+(?:\.\d+)?)\s*von\s*5/i', $rating_text, $rating_matches)) {
                    // German: "X von 5"
                    $star_rating = floatval($rating_matches[1]);
                } elseif (preg_match('/(\d+(?:\.\d+)?)\s*sur\s*5/i', $rating_text, $rating_matches)) {
                    // French: "X sur 5"
                    $star_rating = floatval($rating_matches[1]);
                } elseif (preg_match('/(\d+(?:\.\d+)?)\s*de\s*5/i', $rating_text, $rating_matches)) {
                    // Spanish: "X de 5"
                    $star_rating = floatval($rating_matches[1]);
                } else {
                    // Try to extract from class names or attributes
                    $class_attr = $rating_element->class ?? '';
                    $title_attr = $rating_element->title ?? '';
                    
                    // Look for star patterns in class or title
                    if (preg_match('/star[s]?[-_]?(\d+(?:\.\d+)?)/i', $class_attr . ' ' . $title_attr, $star_matches)) {
                        $star_rating = floatval($star_matches[1]);
                    } elseif (preg_match('/(\d+(?:\.\d+)?)[^\d]*star/i', $class_attr . ' ' . $title_attr, $star_matches)) {
                        $star_rating = floatval($star_matches[1]);
                    }
                }
            }
            
            // Get reviewer name
            $reviewer_name = 'Amazon Customer';
            if (isset($reviewer_names[$index])) {
                $reviewer_name = trim($reviewer_names[$index]->plaintext ?? 'Amazon Customer');
            }
            
            // Get date
            $formatted_date = current_time('mysql');
            if (isset($review_dates[$index])) {
                $date_text = trim($review_dates[$index]->plaintext ?? '');
                if (preg_match('/(\w+\s+\d+,\s+\d+)/', $date_text, $date_matches)) {
                    $parsed_date = strtotime($date_matches[1]);
                    if ($parsed_date) {
                        $formatted_date = date('Y-m-d H:i:s', $parsed_date);
                    }
                }
            }
            
            // Get reviewer image
            $reviewer_image = '';
            if (isset($reviewer_images[$index])) {
                $potential_image = $reviewer_images[$index]->src ?? '';
                if (!empty($potential_image)) {
                    $potential_image = str_replace('._CR0,0,0,0_', '', $potential_image);
                    $potential_image = preg_replace('/\._.*?_\./', '.', $potential_image);
                    
                    if (is_valid_amazon_image($potential_image)) {
                        $reviewer_image = $potential_image;
                    }
                }
            }
            
            // Only add if we have meaningful content
            if (!empty($text) || !empty($cleaned_title)) {
                $review_hash = md5($cleaned_title . $text . $reviewer_name);
                $reviews[$review_hash] = [
                    'title' => $cleaned_title,
                    'rating' => $star_rating,
                    'date' => $formatted_date,
                    'text' => $text,
                    'reviewer_name' => $reviewer_name,
                    'reviewer_image' => $reviewer_image
                ];
            }
        }
    }

    return $reviews;
}
/**
 * Get unlinked variants/products
 * 
 * Queries the database to find SKUs in the `wp_postmeta` table
 * that are not linked to a valid product or variation in the `wp_posts` table.
 * 
 * @return array List of unlinked variants (SKUs and post IDs).
 */
function get_unlinked_variants() {
    global $wpdb;

    $results = $wpdb->get_results("
        SELECT pm.meta_value AS sku, pm.post_id
        FROM {$wpdb->postmeta} pm
        LEFT JOIN {$wpdb->posts} p ON pm.post_id = p.ID
        WHERE pm.meta_key = '_sku'
        AND (p.ID IS NULL OR p.post_status NOT IN ('publish', 'draft', 'pending'))
    ");

    return $results;
}


/**
 * Handle Unlinked Variants Cleanup via AJAX
 */
function handle_unlinked_variants_cleanup() {
    global $wpdb;

    if (!current_user_can('manage_options')) {
        wp_send_json_error(['message' => 'Unauthorized access']);
    }

    // Perform cleanup query
    $deleted_rows = $wpdb->query("
        DELETE pm
        FROM {$wpdb->postmeta} pm
        LEFT JOIN {$wpdb->posts} p ON pm.post_id = p.ID
        WHERE pm.meta_key = '_sku'
        AND (p.ID IS NULL OR p.post_status NOT IN ('publish', 'draft', 'pending'))
    ");

    if ($deleted_rows === false) {
        wp_send_json_error(['message' => 'Cleanup query failed: ' . $wpdb->last_error]);
    }

    wp_send_json_success(['deleted_count' => $deleted_rows]);
}
add_action('wp_ajax_delete_unlinked_variants_cleanup', 'handle_unlinked_variants_cleanup');



// Shortcode feature: Auto create pages/posts
add_action('wp_ajax_auto_create_pages', 'ams_wc_auto_create_pages');
function ams_wc_auto_create_pages() {
    check_ajax_referer('auto_create_pages_nonce', '_ajax_nonce');

    $type = sanitize_text_field($_POST['type']); // "page" or "post"

    // Prevent duplicates by checking for existing pages/posts
    $existing_single = get_posts([
        'post_type'   => $type,
        'title'       => __('Single Product Display', 'ams-wc-amazon'),
        'post_status' => 'any',
        'numberposts' => 1,
    ]);

    $existing_grid = get_posts([
        'post_type'   => $type,
        'title'       => __('Grid Product Display', 'ams-wc-amazon'),
        'post_status' => 'any',
        'numberposts' => 1,
    ]);

    if ($existing_single || $existing_grid) {
        wp_send_json_error(['message' => __('Pages/Posts already exist.', 'ams-wc-amazon')]);
        return;
    }

    // Create pages/posts
    $single_shortcode_page_id = wp_insert_post([
        'post_title'   => __('Single Product Display', 'ams-wc-amazon'),
        'post_content' => '[ams_display_products ids="123" layout="single"]',
        'post_status'  => 'publish',
        'post_type'    => $type,
    ]);

    $grid_shortcode_page_id = wp_insert_post([
        'post_title'   => __('Grid Product Display', 'ams-wc-amazon'),
        'post_content' => '[ams_display_products ids="123,456,789" columns="3" layout="grid"]',
        'post_status'  => 'publish',
        'post_type'    => $type,
    ]);

    if ($single_shortcode_page_id && $grid_shortcode_page_id) {
        wp_send_json_success();
    } else {
        wp_send_json_error(['message' => __('Error creating Pages/Posts.', 'ams-wc-amazon')]);
    }
}

// Shortcode feature: Delete pages/posts
add_action('wp_ajax_delete_existing_pages', 'ams_wc_delete_existing_pages');
function ams_wc_delete_existing_pages() {
    check_ajax_referer('delete_pages_nonce', '_ajax_nonce');

    $titles = [__('Single Product Display', 'ams-wc-amazon'), __('Grid Product Display', 'ams-wc-amazon')];
    $deleted = false;

    foreach ($titles as $title) {
        $existing = get_posts([
            'post_type'   => ['page', 'post'],
            'title'       => $title,
            'post_status' => 'any',
            'numberposts' => 1,
        ]);

        if (!empty($existing)) {
            wp_delete_post($existing[0]->ID, true); // Force delete
            $deleted = true;
        }
    }

    if ($deleted) {
        wp_send_json_success();
    } else {
        wp_send_json_error(['message' => __('No pages/posts to delete.', 'ams-wc-amazon')]);
    }
}

// ams_deactivation_popup_script
function ams_deactivation_popup_script() {
    $plugin_file = plugin_basename(AMS_PLUGIN_FILE);
    ?>
    <style>
        .ams-modal {
            display: none;
            position: fixed;
            z-index: 1000;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0,0,0,0.4);
        }
        .ams-modal-content {
            background-color: #fefefe;
            margin: 15% auto;
            padding: 20px;
            border: 1px solid #888;
            width: 50%;
            max-width: 500px;
            border-radius: 5px;
            box-shadow: 0 4px 8px rgba(0,0,0,0.1);
        }
        .ams-modal-content h3 {
            margin-top: 0;
            color: #23282d;
        }
        .ams-modal-content p {
            line-height: 1.6;
            margin-bottom: 15px;
            color: #444;
        }
        .ams-modal-content ul {
            margin-left: 20px;
            margin-bottom: 15px;
            color: #444;
        }
        .ams-modal-buttons {
            text-align: right;
            margin-top: 20px;
        }
        .ams-modal-buttons button {
            margin-left: 10px;
            padding: 8px 15px;
            border-radius: 3px;
            cursor: pointer;
            font-size: 14px;
        }
        .ams-modal-cancel {
            background-color: #f7f7f7;
            border: 1px solid #ccc;
            color: #555;
        }
        .ams-modal-confirm {
            background-color: #0085ba;
            color: white;
            border: none;
        }
        .ams-modal-confirm:hover {
            background-color: #006799;
        }
        .ams-important {
            font-weight: bold;
            color: #d63638;
        }
        .ams-highlight {
            background-color: #ffeb3b;
            padding: 2px 4px;
            border-radius: 3px;
        }
        .ams-modal-confirm:disabled {
            background-color: #cccccc;
            cursor: not-allowed;
        }
        .ams-loading::after {
            content: "...";
            animation: loading 1.5s infinite;
        }
        @keyframes loading {
            0% { content: "."; }
            33% { content: ".."; }
            66% { content: "..."; }
        }
    </style>
    <div id="ams-deactivation-modal" class="ams-modal">
        <div class="ams-modal-content">
            <h3><?php esc_html_e('Deactivate AMS Plugin', 'ams-wc-amazon'); ?></h3>
            <p><span class="ams-important"><?php esc_html_e('Important:', 'ams-wc-amazon'); ?></span> <?php esc_html_e("We're about to deactivate your license. Here's what you need to know:", 'ams-wc-amazon'); ?></p>
            <ul>
                <li><span class="ams-highlight"><?php esc_html_e('Your license will be automatically deactivated for this site.', 'ams-wc-amazon'); ?></span></li>
                <li><?php esc_html_e('This allows you to', 'ams-wc-amazon'); ?> <span class="ams-important"><?php esc_html_e('reuse the license on another domain', 'ams-wc-amazon'); ?></span> <?php esc_html_e('if needed.', 'ams-wc-amazon'); ?></li>
                <li><?php esc_html_e('Perfect for moving your site or setting up a new installation.', 'ams-wc-amazon'); ?></li>
            </ul>
            <p><span class="ams-important"><?php esc_html_e("When you reactivate the plugin, you'll need to enter your license key again.", 'ams-wc-amazon'); ?></span> <?php esc_html_e("Don't worry, it's a simple process to ensure your license is always where you need it.", 'ams-wc-amazon'); ?></p>
            <p><span class="ams-highlight"><?php esc_html_e('This action helps manage your license across multiple sites.', 'ams-wc-amazon'); ?></span></p>
            <div class="ams-modal-buttons">
                <button class="ams-modal-cancel"><?php esc_html_e('Cancel', 'ams-wc-amazon'); ?></button>
                <button class="ams-modal-confirm"><?php esc_html_e('Confirm Deactivation', 'ams-wc-amazon'); ?></button>
            </div>
        </div>
    </div>
    <script type="text/javascript">
    jQuery(document).ready(function($) {
        var $modal = $('#ams-deactivation-modal');
        var $confirmButton = $('.ams-modal-confirm');
        var deactivateUrl = '';

        $('tr[data-plugin="<?php echo esc_js($plugin_file); ?>"] .deactivate a').on('click', function(e) {
            e.preventDefault();
            deactivateUrl = $(this).attr('href');
            $modal.show();
        });

        $('.ams-modal-cancel').on('click', function() {
            $modal.hide();
        });

        $confirmButton.on('click', function() {
            var $button = $(this);
            $button.prop('disabled', true).addClass('ams-loading').text('<?php esc_js(_e('Deactivating', 'ams-wc-amazon')); ?>');

            $.ajax({
                type: 'POST',
                url: amsbackend.ajax_url,
                data: {
                    'nonce': amsbackend.nonce_ams_de_activated,
                    'action': 'ams_license_deactivated',
                },
                success: function(response) {
                    window.location.href = deactivateUrl;
                },
                error: function() {
                    alert('<?php esc_js(_e('Failed to deactivate license. Plugin will still be deactivated.', 'ams-wc-amazon')); ?>');
                    window.location.href = deactivateUrl;
                }
            });
        });

        $(window).on('click', function(e) {
            if ($(e.target).is($modal)) {
                $modal.hide();
            }
        });
    });
    </script>
    <?php
}

// Enhanced Page Speed Test Display
function show_page_load_time() {
    // Check if the feature is enabled
    if (get_option('enable_page_speed_test') !== '1') {
        return;
    }
    
    // Check mobile display setting (default to show on mobile)
    if (wp_is_mobile() && get_option('show_on_mobile', '1') !== '1') {
        return;
    }

    // Check user permissions: 
    // - If debug mode is enabled, show to all users
    // - If debug mode is disabled, show only to administrators
    if (get_option('speed_test_debug') !== '1' && !current_user_can('administrator')) {
        return;
    }

    // Start timing at the beginning
    global $timestart;
    $timestart = microtime(true);

    // Add to appropriate hook based on display position
    $position = get_option('display_position', 'footer_left');
    
    switch($position) {
        case 'sidebar':
            add_action('dynamic_sidebar_before', 'ams_render_speed_test_display');
            break;
        case 'footer_left':
        case 'footer_right':
        case 'top_left':
        case 'top_right':
        case 'footer':
        default:
            add_action('wp_footer', 'ams_render_speed_test_display');
            break;
    }
}

// Render the speed test display
function ams_render_speed_test_display() {
    global $timestart;
    
    // Debug logging removed to prevent log clutter
    
    // Calculate metrics
    $load_time = number_format((microtime(true) - $timestart), 2);
    $load_time_ms = number_format((microtime(true) - $timestart) * 1000, 2);
    $memory_usage = round(memory_get_usage() / 1024 / 1024, 2);
    $page_size = ams_estimate_page_size();
    $request_count = ams_estimate_request_count();
    
    // Calculate performance score (0-100)
    $performance_score = ams_calculate_performance_score($load_time, $memory_usage, $page_size);
    
    // Get display settings
    $style = get_option('page_speed_test_style', 'style1');
    $show_score = get_option('show_performance_score', '1') === '1';
    $show_load_time = get_option('show_load_time', '1') === '1';
    $show_page_size = get_option('show_page_size', '1') === '1';
    $show_requests = get_option('show_requests_count', '1') === '1';
    $position = get_option('display_position', 'footer_left');
    
    // Don't show if no metrics are enabled
    if (!$show_score && !$show_load_time && !$show_page_size && !$show_requests) {
        return;
    }
    
    // Generate CSS classes and positioning
    $fixed_positions = ['footer_left', 'footer_right', 'top_left', 'top_right', 'footer'];
    $position_class = in_array($position, $fixed_positions) ? 'ams-speed-test-fixed' : 'ams-speed-test-inline';
    $container_class = "ams-speed-test ams-speed-{$style} {$position_class} ams-position-{$position}";
    
    // Generate content based on style
    $content = ams_generate_speed_test_content($style, [
        'score' => $performance_score,
        'load_time' => $load_time,
        'load_time_ms' => $load_time_ms,
        'memory' => $memory_usage,
        'page_size' => $page_size,
        'requests' => $request_count,
        'show_score' => $show_score,
        'show_load_time' => $show_load_time,
        'show_page_size' => $show_page_size,
        'show_requests' => $show_requests
    ]);
    
    echo '<div class="' . esc_attr($container_class) . '">' . $content . '</div>';
}

// Generate speed test content based on style
function ams_generate_speed_test_content($style, $data) {
    $score_color = $data['score'] >= 90 ? 'success' : ($data['score'] >= 70 ? 'warning' : 'danger');
    
    switch($style) {
        case 'style1': // Dark Theme
            $content = '<div class="ams-speed-dark">';
            if ($data['show_score']) {
                $content .= '<div class="d-flex justify-content-between align-items-center">';
                $content .= '<span class="small">Performance</span>';
                $content .= '<span class="badge bg-' . $score_color . '">' . $data['score'] . '</span>';
                $content .= '</div>';
            }
            if ($data['show_load_time']) {
                $content .= '<div class="small text-light">Load Time: ' . $data['load_time'] . 's</div>';
            }
            if ($data['show_page_size']) {
                $content .= '<div class="small text-light">Size: ' . $data['page_size'] . '</div>';
            }
            if ($data['show_requests']) {
                $content .= '<div class="small text-light">Requests: ' . $data['requests'] . '</div>';
            }
            $content .= '</div>';
            break;
            
        case 'style2': // Light Theme
            $content = '<div class="ams-speed-light">';
            if ($data['show_score']) {
                $content .= '<div class="d-flex justify-content-between align-items-center">';
                $content .= '<span class="small">Performance</span>';
                $content .= '<span class="badge bg-primary">' . $data['score'] . '</span>';
                $content .= '</div>';
            }
            if ($data['show_load_time']) {
                $content .= '<div class="small text-muted">Load Time: ' . $data['load_time'] . 's</div>';
            }
            if ($data['show_page_size']) {
                $content .= '<div class="small text-muted">Size: ' . $data['page_size'] . '</div>';
            }
            if ($data['show_requests']) {
                $content .= '<div class="small text-muted">Requests: ' . $data['requests'] . '</div>';
            }
            $content .= '</div>';
            break;
            
        case 'style3': // Compact
            $content = '<div class="ams-speed-compact text-center">';
            if ($data['show_score']) {
                $content .= '<div class="h5 mb-0">' . $data['score'] . '</div><small>Score</small>';
            }
            if ($data['show_load_time']) {
                $content .= '<div class="mt-2"><small>' . $data['load_time'] . 's load</small></div>';
            }
            $content .= '</div>';
            break;
            
        case 'style4': // Detailed
            $content = '<div class="ams-speed-detailed">';
            $content .= '<div class="row text-center">';
            if ($data['show_score']) {
                $content .= '<div class="col-6"><div class="h6 mb-0 text-' . $score_color . '">' . $data['score'] . '</div><small>Score</small></div>';
            }
            if ($data['show_load_time']) {
                $content .= '<div class="col-6"><div class="h6 mb-0">' . $data['load_time'] . 's</div><small>Load</small></div>';
            }
            $content .= '</div>';
            if ($data['show_page_size']) {
                $content .= '<div class="text-center mt-2"><small>Size: ' . $data['page_size'] . '</small></div>';
            }
            if ($data['show_requests']) {
                $content .= '<div class="text-center"><small>' . $data['requests'] . ' requests</small></div>';
            }
            $content .= '</div>';
            break;
            
        case 'style5': // Badge Style
            $content = '<div class="ams-speed-badge">';
            $content .= '<div class="d-flex align-items-center">';
            $content .= '<i class="bi bi-speedometer2 me-2"></i>';
            $content .= '<div>';
            $content .= '<div class="fw-bold">Fast Site</div>';
            if ($data['show_load_time']) {
                $content .= '<small>' . $data['load_time'] . 's load time</small>';
            }
            $content .= '</div></div></div>';
            break;
            
        case 'style6': // Minimal
            $content = '<div class="ams-speed-minimal text-center">';
            $content .= '<i class="bi bi-lightning-charge fs-4"></i>';
            $content .= '<div class="small">Optimized Performance</div>';
            if ($data['show_load_time']) {
                $content .= '<div class="small mt-1">Fast Loading</div>';
            }
            $content .= '</div>';
            break;
            
        default:
            $content = '<div class="ams-speed-default">Performance: ' . $data['score'] . '</div>';
    }
    
    return $content;
}

// Helper functions for metrics calculation
function ams_estimate_page_size() {
    $size = strlen(ob_get_contents());
    if ($size < 1024) {
        return $size . 'B';
    } elseif ($size < 1024 * 1024) {
        return round($size / 1024, 1) . 'KB';
    } else {
        return round($size / (1024 * 1024), 1) . 'MB';
    }
}

function ams_estimate_request_count() {
    // Estimate based on typical WordPress page structure
    $base_requests = 15; // HTML, CSS, JS, images
    $plugin_requests = 5; // Additional plugin resources
    return $base_requests + $plugin_requests + rand(5, 15);
}

function ams_calculate_performance_score($load_time, $memory, $page_size_raw) {
    $score = 100;
    
    // Deduct points for slow load time
    if ($load_time > 3) $score -= 30;
    elseif ($load_time > 2) $score -= 20;
    elseif ($load_time > 1) $score -= 10;
    
    // Deduct points for high memory usage
    if ($memory > 128) $score -= 20;
    elseif ($memory > 64) $score -= 10;
    
    // Ensure score is between 0-100
    return max(0, min(100, $score));
}

// Register shortcode for displaying products in a grid or single product layout
function ams_display_products_grid_shortcode($atts) {
    try {
        // Initialize WooCommerce if not already done
        if (!function_exists('wc_get_product')) {
            return '<p>WooCommerce is not active.</p>';
        }

        $atts = shortcode_atts(
            [
                'ids' => '',       // Comma-separated list of product IDs
                'columns' => 4,    // Number of products per row for multiple products
                'layout' => 'grid' // Layout type: 'grid' (default) or 'single'
            ],
            $atts,
            'ams_display_products'
        );

        // Validate and sanitize inputs
        $product_ids = array_filter(array_map('intval', explode(',', $atts['ids'])));
        $columns = max(1, intval($atts['columns']));

        if (empty($product_ids)) {
            return '<p>No valid product IDs provided.</p>';
        }

        // Get custom button settings
        $use_custom_button = get_option('ams_use_custom_button', '0') === '1';
        $theme_hook = get_option('ams_theme_hook', 'woocommerce_after_shop_loop_item');

        // Create instance of WooCommerceCart class
        $woocommerce_cart = new \Amazon\Affiliate\Frontend\WooCommerceCart();

        ob_start();

        // Legal Notice Logic
        $enable_legal_notice = get_option('enable_legal_notice', '1');
        $legal_notice_text = get_option('legal_notice_text', 'Affiliate-Produkte | Anzeige | Werbung');

        if ($enable_legal_notice === '1') {
            echo '<p class="legal-notice text-muted mb-3" style="font-size: 12px; text-align: left;">'
                . esc_html($legal_notice_text) . '</p>';
        }

        $latest_update = null;
        $alignment = get_option('message_alignment', 'left');
        $alignment_class = $alignment === 'right' ? 'text-end' : 'text-start';

        $enable_product_last_updated = get_option('enable_product_last_updated', '1');
        $product_last_updated_message = get_option('product_last_updated_message', 'Last updated: {date}');

        $enable_global_last_updated = get_option('enable_global_last_updated', '1');
        $global_last_updated_message = get_option('global_last_updated_message', 'Last updated on {date}.');

        if ($atts['layout'] === 'single') {
            // Single product layout
            $product_id = $product_ids[0];
            $product = wc_get_product($product_id);

            if (!$product) {
                ob_end_clean();
                return sprintf('<p>Product ID %d not found.</p>', $product_id);
            }

            $last_updated = get_post_modified_time('F j, Y, g:i a', false, $product_id);
            $latest_update = $last_updated;

            echo '<div class="ams-single-product">';
            echo '<div class="product">';
            
            // Product image with error handling
            $image_html = $product->get_image();
            if (!empty($image_html)) {
                echo '<a href="' . esc_url($product->get_permalink()) . '" class="product-image">' . $image_html . '</a>';
            }
            
            echo '<a href="' . esc_url($product->get_permalink()) . '"><h2 class="product-title">' . esc_html($product->get_name()) . '</h2></a>';
            
            // Rating display with validation
            $rating = $product->get_average_rating();
            if ($rating > 0) {
                echo '<div class="rating-stars" title="' . esc_attr($product->get_rating_count() . ' reviews') . '">'
                    . str_repeat('★', min(5, floor($rating))) 
                    . str_repeat('☆', max(0, 5 - floor($rating))) 
                    . ' <span class="rating-number">(' . esc_html(number_format($rating, 1)) . ')</span></div>';
            }

            // Price display
            $price_html = $product->get_price_html();
            if (!empty($price_html)) {
                echo '<span class="price">' . $price_html . '</span>';
            }

            // Custom button logic
            if ($product->is_purchasable() && $product->is_in_stock()) {
                if ($use_custom_button) {
                    $default_button = sprintf(
                        '<a href="%s" class="button add_to_cart_button">%s</a>',
                        esc_url($product->add_to_cart_url()),
                        esc_html__('Add to Cart', 'woocommerce')
                    );
                    echo $woocommerce_cart->buy_now_button_actions_category($default_button, $product);
                } else {
                    $button_args = [
                        'quantity' => 1,
                        'class' => 'button add_to_cart_button',
                        'attributes' => []
                    ];
                    
                    echo apply_filters(
                        'woocommerce_loop_add_to_cart_link',
                        sprintf(
                            '<a href="%s" data-quantity="%s" class="button add_to_cart_button %s" %s>%s</a>',
                            esc_url($product->add_to_cart_url()),
                            esc_attr($button_args['quantity']),
                            esc_attr($product->is_purchasable() ? 'ajax_add_to_cart' : ''),
                            isset($button_args['attributes']) ? wc_implode_html_attributes($button_args['attributes']) : '',
                            esc_html($product->add_to_cart_text())
                        ),
                        $product,
                        $button_args
                    );
                }
            }

            if ($enable_product_last_updated === '1' && $last_updated) {
                echo '<p class="last-updated ' . esc_attr($alignment_class) . '">'
                    . esc_html(str_replace('{date}', $last_updated, $product_last_updated_message)) . '</p>';
            }

            echo '</div>';
            echo '</div>';
        } else {
            // Grid layout
            echo '<div class="ams-custom-grid">';
            echo '<ul class="ams-grid columns-' . esc_attr($columns) . '" style="--ams-columns: ' . esc_attr($columns) . ';">';

            foreach ($product_ids as $product_id) {
                $product = wc_get_product($product_id);

                if (!$product) {
                    continue;
                }

                $last_updated = get_post_modified_time('F j, Y, g:i a', false, $product_id);
                if (!$latest_update || strtotime($last_updated) > strtotime($latest_update)) {
                    $latest_update = $last_updated;
                }

                echo '<li class="product">';
                
                // Product image with error handling
                $image_html = $product->get_image();
                if (!empty($image_html)) {
                    echo '<a href="' . esc_url($product->get_permalink()) . '" class="product-image">' . $image_html . '</a>';
                }
                
                echo '<a href="' . esc_url($product->get_permalink()) . '"><h2 class="product-title">' . esc_html($product->get_name()) . '</h2></a>';
                
                // Rating display with validation
                $rating = $product->get_average_rating();
                if ($rating > 0) {
                    echo '<div class="rating-stars" title="' . esc_attr($product->get_rating_count() . ' reviews') . '">'
                        . str_repeat('★', min(5, floor($rating))) 
                        . str_repeat('☆', max(0, 5 - floor($rating))) 
                        . ' <span class="rating-number">(' . esc_html(number_format($rating, 1)) . ')</span></div>';
                }

                // Price display
                $price_html = $product->get_price_html();
                if (!empty($price_html)) {
                    echo '<span class="price">' . $price_html . '</span>';
                }

                // Custom button logic
                if ($product->is_purchasable() && $product->is_in_stock()) {
                    if ($use_custom_button) {
                        $default_button = sprintf(
                            '<a href="%s" class="button add_to_cart_button">%s</a>',
                            esc_url($product->add_to_cart_url()),
                            esc_html__('Add to Cart', 'woocommerce')
                        );
                        echo $woocommerce_cart->buy_now_button_actions_category($default_button, $product);
                    } else {
                        $button_args = [
                            'quantity' => 1,
                            'class' => 'button add_to_cart_button',
                            'attributes' => []
                        ];
                        
                        echo apply_filters(
                            'woocommerce_loop_add_to_cart_link',
                            sprintf(
                                '<a href="%s" data-quantity="%s" class="button add_to_cart_button %s" %s>%s</a>',
                                esc_url($product->add_to_cart_url()),
                                esc_attr($button_args['quantity']),
                                esc_attr($product->is_purchasable() ? 'ajax_add_to_cart' : ''),
                                isset($button_args['attributes']) ? wc_implode_html_attributes($button_args['attributes']) : '',
                                esc_html($product->add_to_cart_text())
                            ),
                            $product,
                            $button_args
                        );
                    }
                }

                if ($enable_product_last_updated === '1' && $last_updated) {
                    echo '<p class="last-updated ' . esc_attr($alignment_class) . '">'
                        . esc_html(str_replace('{date}', $last_updated, $product_last_updated_message)) . '</p>';
                }

                echo '</li>';
            }

            echo '</ul>';
            echo '</div>';
        }

        if ($enable_global_last_updated === '1' && $latest_update) {
            echo '<div class="last-updated-overall ' . esc_attr($alignment_class) . '">'
                . esc_html(str_replace('{date}', $latest_update, $global_last_updated_message)) . '</div>';
        }

        $output = ob_get_clean();
        return $output;

    } catch (Exception $e) {
        if (ob_get_level() > 0) {
            ob_end_clean();
        }
        return '<p>Error displaying products: ' . esc_html($e->getMessage()) . '</p>';
    }
}

// Append custom notification at the end of the content
function append_custom_notification_to_content($content) {
    try {
        // Check if the option is enabled
        if (get_option('enable_custom_notification') === '1') {
            // Determine if we are on a WooCommerce page or a page using the shortcode
            if (is_woocommerce() || has_shortcode($content, 'ams_display_products')) {
                $alignment = get_option('message_alignment', 'left');
                $alignment_class = $alignment === 'right' ? 'text-end' : 'text-start';
                $custom_notification_message = get_option('custom_notification_message', 'Please note: Product details may change.');

                $custom_notification = '<div class="custom-notification ' . esc_attr($alignment_class) . '">';
                $custom_notification .= wp_kses_post($custom_notification_message);
                $custom_notification .= '</div>';

                return $content . $custom_notification;
            }
        }

        return $content;
    } catch (Exception $e) {
        // Log error but return original content to prevent breaking the page
        error_log('Custom notification error: ' . $e->getMessage());
        return $content;
    }
}

// Add last updated date and a static notice to WooCommerce product page
function display_last_updated_date() {
    // Check if the feature is enabled
    if (get_option('enable_last_updated_date') !== '1') {
        return;
    }

    global $product, $post;
    
    // Use product ID if available, otherwise use post ID
    $product_id = $product ? $product->get_id() : ($post ? $post->ID : 0);
    if (!$product_id) return;
    
    // Smart display logic - check if we should show for old products only
    if (get_option('show_only_old_products') === '1') {
        $old_product_days = get_option('old_product_days', 30);
        $last_modified_timestamp = get_post_modified_time('U', false, $product_id);
        $days_since_update = (time() - $last_modified_timestamp) / (24 * 60 * 60);
        
        if ($days_since_update < $old_product_days) {
            return; // Don't show for recently updated products
        }
    }

    // Check if the custom message is enabled
    if (get_option('enable_custom_message') === '1') {
        // Retrieve the custom message or use the default
        $custom_message = get_option('last_updated_custom_message', 'Product details may change - check for updates.');

        // Get the selected style
        $selected_style = get_option('last_updated_notice_style', 'style1');



        // Get the icon for the selected style
        $style_icons = [
            'style1' => 'ℹ️',
            'style2' => '⚠️', 
            'style3' => '✅',
            'style4' => '⚠️',
            'style5' => '📋',
            'style6' => 'ℹ️',
            'style7' => '🔔',
            'style8' => '⚡',
            'style9' => '📅',
            'style10' => '⚠️'
        ];
        
        $icon = isset($style_icons[$selected_style]) ? $style_icons[$selected_style] : 'ℹ️';
        
        // Display the message with the selected style - Simple text only, no icons
        echo '<div class="woocommerce-info custom-dynamic-notice ' . esc_attr($selected_style) . '" id="lastUpdatedNotice">';
        echo wp_kses_post($custom_message);
        echo '</div>';
        

    }

    // Get formatted date based on settings
    $formatted_date = ams_get_formatted_last_updated_date($product_id);
    
    // Get the last updated date message format
    $product_last_updated_message = get_option('product_last_updated_message', 'Last updated: {date}');

    // Replace {date} placeholder with the formatted date
    $message = str_replace('{date}', $formatted_date, $product_last_updated_message);

    // Display the last updated date message
    echo '<p class="product-last-updated">' . esc_html($message) . '</p>';
    

}

// Get formatted last updated date based on user settings
function ams_get_formatted_last_updated_date($product_id) {
    $date_format_type = get_option('date_format_type', 'standard');
    $last_modified_timestamp = get_post_modified_time('U', false, $product_id);
    
    switch ($date_format_type) {
        case 'relative':
            return human_time_diff($last_modified_timestamp, current_time('timestamp')) . ' ago';
            
        case 'short':
            return date('d/m/Y', $last_modified_timestamp);
            
        case 'custom':
            $custom_format = get_option('custom_date_format', 'F j, Y');
            return date($custom_format, $last_modified_timestamp);
            
        case 'standard':
        default:
            return date('F j, Y', $last_modified_timestamp);
    }
}




// Filter review title display
function custom_review_title($comment) {
    if (get_option('enable_review_title') == '1') {
        $title = get_comment_meta($comment->comment_ID, 'title', true);
        if (!empty($title)) {
            echo '<strong class="woocommerce-review__title">' . esc_html($title) . '</strong>';
        }
    }
}

// Filter reviewer image
function custom_reviewer_image_url($url, $id_or_email, $args) {
    if (get_option('enable_reviewer_image') != '1') {
        return $url;
    }

    if (is_object($id_or_email) && isset($id_or_email->comment_ID)) {
        $reviewer_image = get_comment_meta($id_or_email->comment_ID, 'reviewer_image', true);
        if (!empty($reviewer_image)) {
            return esc_url($reviewer_image);
        }
    }
    return $url;
}

// Filter reviewer image size
function custom_reviewer_image_data($args, $id_or_email) {
    if (get_option('enable_reviewer_image') != '1') {
        return $args;
    }

    if (is_object($id_or_email) && isset($id_or_email->comment_ID)) {
        $reviewer_image = get_comment_meta($id_or_email->comment_ID, 'reviewer_image', true);
        if (!empty($reviewer_image)) {
            $args['url'] = esc_url($reviewer_image);
            $args['size'] = 60;
        }
    }
    return $args;
}

// Display the GTIN, UPC, EAN, or ISBN code
function display_gtin_in_inventory_tab() {
    global $post;

    // Retrieve the saved GTIN value from post meta
    $gtin = get_post_meta($post->ID, '_gtin', true);

    // Check if GTIN is available and populate the default field
    if ($gtin) {
        ?>
        <script type="text/javascript">
            jQuery(document).ready(function($) {
                // Set the value of the existing field '_global_unique_id'
                $('#_global_unique_id').val('<?php echo esc_js($gtin); ?>');
            });
        </script>
        <?php
    }
}

// Image Fit - shop, category, and product pages
function ams_enqueue_image_fit_css() {
    $image_fit = get_option('ams_image_fit', 'cover'); // Default to 'cover'

    if ($image_fit !== 'none') {
        // Apply the fit styles only if it's not set to 'none'
        $custom_css = "
        /* Product single page images */
        .woocommerce div.product div.images img, 
        .woocommerce div.product div.images img.wp-post-image, 
        .woocommerce-product-gallery__image img {
            object-fit: {$image_fit} !important;
            max-width: 100% !important;
            max-height: 500px !important;
            width: auto !important;
            height: auto !important;
            display: block;
            margin: 0 auto;
        }
        .woocommerce-product-gallery__image {
            max-height: 500px;
            overflow: hidden;
        }

        /* Shop and category page product images */
        .woocommerce ul.products li.product img,
        .woocommerce-page ul.products li.product img,
        .woocommerce ul.products li.product .woocommerce-loop-product__link img,
        .woocommerce-page ul.products li.product .woocommerce-loop-product__link img {
            object-fit: {$image_fit} !important;
            max-width: 100% !important;
            max-height: 300px !important; /* Smaller height for shop/category pages */
            width: auto !important; /* Allow images to keep aspect ratio */
            height: auto !important; /* Auto height for consistent proportions */
            display: block;
            margin: 0 auto;
        }

        /* Container for shop/category page images */
        .woocommerce ul.products li.product .woocommerce-loop-product__link,
        .woocommerce-page ul.products li.product .woocommerce-loop-product__link {
            display: block;
            overflow: hidden; /* Ensure image fits within its container */
        }
        ";
        wp_add_inline_style('wp-block-library', $custom_css);
    } 
}

//Code for variants gallery custom theme

// Universal AJAX handler for theme variation gallery requests
function ams_universal_variation_gallery_ajax() {
    error_log('AMS Debug: Universal AJAX handler called for action: ' . ($_POST['action'] ?? 'unknown'));
    
    if (!isset($_POST['variation_id'])) {
        error_log('AMS Debug: No variation_id provided');
        wp_die();
    }
    
    $variation_id = intval($_POST['variation_id']);
    $is_quickview = isset($_POST['is_quickview']) ? intval($_POST['is_quickview']) : 0;
    
    error_log("AMS Debug: Processing variation_id: $variation_id, is_quickview: $is_quickview");
    
    // Get the custom meta key from plugin settings
    $variation_meta_key = get_option('variation_image_meta_key', '_product_image_gallery');
    
    // Get gallery data from the configured meta key
    $gallery_data = get_post_meta($variation_id, $variation_meta_key, true);
    
    if (!empty($gallery_data) && is_array($gallery_data)) {
        $product_id = wp_get_post_parent_id($variation_id);
        
        // Get theme data format settings
        $theme_image_format = get_option('theme_image_format', 'html');
        $theme_thumb_format = get_option('theme_thumb_format', 'empty');
        $theme_full_format = get_option('theme_full_format', 'array_dimensions');
        $theme_thumb_url_format = get_option('theme_thumb_url_format', 'url');
        
        // Prepare images data based on theme format settings
        $images_data = array();
        foreach ($gallery_data as $index => $image_url) {
            if (filter_var($image_url, FILTER_VALIDATE_URL)) {
                // Prepare main image based on theme format
                $image_data = '';
                switch ($theme_image_format) {
                    case 'html':
                        $image_data = sprintf('<img src="%s" alt="" class="wp-post-image" />', esc_url($image_url));
                        break;
                    case 'url':
                        $image_data = $image_url;
                        break;
                    case 'array':
                        $image_data = array($image_url, 600, 600);
                        break;
                }
                
                // Prepare full image based on theme format
                $full_data = '';
                switch ($theme_full_format) {
                    case 'array_url':
                        $full_data = array($image_url, 600, 600); // Always provide width/height for themes that expect them
                        break;
                    case 'array_dimensions':
                        $full_data = array($image_url, 600, 600);
                        break;
                    case 'url':
                        $full_data = $image_url;
                        break;
                }
                
                // Prepare thumbnail based on theme format
                $thumb_data = '';
                switch ($theme_thumb_format) {
                    case 'url':
                        $thumb_data = $image_url;
                        break;
                    case 'html':
                        $thumb_data = sprintf('<img src="%s" alt="" class="wp-post-image" />', esc_url($image_url));
                        break;
                    case 'empty':
                        $thumb_data = '';
                        break;
                }
                
                // Prepare thumb_url based on theme format
                $thumb_url_data = ($theme_thumb_url_format === 'url') ? $image_url : '';
                
                $images_data[] = array(
                    'image_id' => 'url_' . $index,
                    'image' => $image_data,
                    'full' => $full_data,
                    'thumb' => $thumb_data,
                    'thumb_url' => $thumb_url_data,
                    'attachment_id' => 0  // No attachment ID for remote images
                );
            }
        }
        
        // Auto-detect expected response format based on theme patterns
        $response_format = get_option('theme_response_format', 'auto');
        $current_action = isset($_POST['action']) ? $_POST['action'] : '';
        
        // Auto-detect format if not set
        if ($response_format === 'auto') {
            // Check if theme has variation_images in action name (common pattern for HTML response)
            if (strpos($current_action, 'variation_images') !== false) {
                $response_format = 'html';
            } else {
                $response_format = 'json';
            }
        }
        
        if ($response_format === 'html' && !empty($images_data)) {
            // For themes expecting HTML template output
            // Use WooCommerce template with our processed images
            wc_get_template('single-product/product-image.php', array(
                'has_variation_gallery_images' => true,
                'product_id' => $product_id,
                'images' => $images_data, // Our processed remote images
            ));
            wp_die();
        } else {
            // For themes expecting JSON data
            if (!empty($images_data)) {
                wp_send_json_success(array(
                'images' => $images_data,
                    'product_id' => $product_id,
                    'has_variation_gallery_images' => true,
                    // Additional formats for theme compatibility
                    'gallery_urls' => array_column($images_data, 'thumb_url'),
                    'main_images' => array_column($images_data, 'image'),
                    'full_images' => array_column($images_data, 'full'),
                    'thumbnails' => array_column($images_data, 'thumb'),
                ));
            } else {
                wp_send_json_error('No gallery images found');
            }
        }
    } else {
        wp_send_json_error('No gallery data found');
    }
    
    wp_die();
}


// Filter function to skip irrelevant AJAX actions
function ams_should_skip_ajax_action($action) {
    // Skip actions that are clearly not related to variation galleries
    $skip_patterns = array(
        'elementor-ai-', // Elementor AI actions
        'elementor-', // General Elementor actions (unless specifically variation related)
        'gutenberg-', // Gutenberg editor actions
        'wp-admin-', // WordPress admin actions
        'wp-editor-', // WordPress editor actions
        'wp-media-', // WordPress media actions (unless variation related)
        'wp-customize-', // WordPress customizer actions
        'wp-ajax-', // Avoid recursive patterns
        'heartbeat', // WordPress heartbeat
        'wp-auth-', // WordPress authentication
        'wp-cron-', // WordPress cron
        'wp-mail-', // WordPress mail
        'wp-backup-', // Backup actions
        'wp-security-', // Security actions
        'wp-seo-', // SEO actions
        'wp-cache-', // Cache actions
        'wp-update-', // Update actions
        'wp-plugin-', // Plugin management actions
        'wp-theme-', // Theme management actions
        'wp-user-', // User management actions
        'wp-comment-', // Comment actions
        'wp-post-', // Post management actions (unless variation related)
        'wp-page-', // Page management actions
        'wp-menu-', // Menu actions
        'wp-widget-', // Widget actions
        'wp-search-', // Search actions (unless variation related)
        'wp-import-', // Import actions (unless variation related)
        'wp-export-', // Export actions
        'wp-log-', // Logging actions
        'wp-debug-', // Debug actions
        'wp-analytics-', // Analytics actions
        'wp-tracking-', // Tracking actions
        'wp-social-', // Social media actions
        'wp-newsletter-', // Newsletter actions
        'wp-contact-', // Contact form actions
        'wp-form-', // Form actions (unless variation related)
        'wp-payment-', // Payment actions (unless variation related)
        'wp-shipping-', // Shipping actions
        'wp-tax-', // Tax actions
        'wp-coupon-', // Coupon actions
        'wp-review-', // Review actions
        'wp-rating-', // Rating actions
        'wp-wishlist-', // Wishlist actions
        'wp-compare-', // Compare actions
        'wp-filter-', // Filter actions (unless variation related)
        'wp-sort-', // Sort actions
        'wp-pagination-', // Pagination actions
        'wp-ajax-test', // Test actions
        'wp-ajax-demo', // Demo actions
        'wp-ajax-example', // Example actions
    );
    
    foreach ($skip_patterns as $pattern) {
        if (strpos($action, $pattern) === 0) {
            return true;
        }
    }
    
    // Skip if action contains certain keywords that indicate it's not variation related
    $skip_keywords = array(
        'login', 'logout', 'register', 'password', 'email', 'newsletter', 
        'contact', 'form', 'search', 'filter', 'sort', 'pagination',
        'backup', 'restore', 'import', 'export', 'migrate', 'sync',
        'cache', 'optimize', 'compress', 'minify', 'lazy',
        'analytics', 'tracking', 'stats', 'report', 'log',
        'security', 'firewall', 'spam', 'captcha', 'block',
        'seo', 'sitemap', 'robots', 'meta', 'schema',
        'social', 'share', 'like', 'tweet', 'facebook',
        'payment', 'checkout', 'cart', 'order', 'invoice',
        'shipping', 'delivery', 'tracking', 'fulfillment',
        'tax', 'vat', 'discount', 'coupon', 'promo',
        'review', 'rating', 'comment', 'feedback', 'testimonial',
        'wishlist', 'favorite', 'bookmark', 'save',
        'compare', 'versus', 'diff', 'match',
        'notification', 'alert', 'message', 'popup',
        'modal', 'dialog', 'tooltip', 'help',
        'admin', 'dashboard', 'settings', 'config',
        'user', 'profile', 'account', 'member',
        'post', 'page', 'article', 'blog',
        'menu', 'navigation', 'breadcrumb', 'sidebar',
        'widget', 'shortcode', 'block', 'element',
        'template', 'layout', 'design', 'style',
        'color', 'font', 'size', 'position',
        'animation', 'transition', 'effect', 'hover',
        'mobile', 'tablet', 'desktop', 'responsive',
        'api', 'webhook', 'endpoint', 'service',
        'database', 'query', 'table', 'field',
        'file', 'upload', 'download', 'attachment',
        'editor', 'wysiwyg', 'tinymce', 'gutenberg',
        'customizer', 'preview', 'live', 'instant'
    );
    
    $action_lower = strtolower($action);
    foreach ($skip_keywords as $keyword) {
        if (strpos($action_lower, $keyword) !== false) {
            // But allow if it also contains variation/gallery/image keywords
            if (strpos($action_lower, 'variation') !== false || 
                strpos($action_lower, 'gallery') !== false || 
                strpos($action_lower, 'image') !== false) {
                continue; // Don't skip, it might be relevant
            }
            return true;
        }
    }
    
    return false;
}

// Enhanced AJAX action detection for variation gallery
function ams_detect_theme_ajax_action() {
    $paths = array_unique(array_filter(array(
        get_stylesheet_directory(),
        get_template_directory(),
        WP_PLUGIN_DIR, // Also scan plugins for AJAX actions
    )));

    $matches_count = array();
    $prioritized = array();
    $debug_info = array();

    foreach ($paths as $base) {
        if (!is_dir($base)) continue;
        $it = new RecursiveIteratorIterator(new RecursiveDirectoryIterator($base, FilesystemIterator::SKIP_DOTS));
        foreach ($it as $fileInfo) {
            $ext = strtolower(pathinfo($fileInfo->getFilename(), PATHINFO_EXTENSION));
            if (!in_array($ext, array('php','js'))) continue;
            $content = @file_get_contents($fileInfo->getPathname());
            if ($content === false) continue;

            $relative_path = str_replace($base, '', $fileInfo->getPathname());

            // Pattern 1: Enhanced wp_ajax detection
            if (preg_match_all("/wp_ajax(?:_nopriv)?_([a-zA-Z0-9_\-]+)/", $content, $m1)) {
                foreach ($m1[1] as $act) {
                    // Skip irrelevant actions
                    if (ams_should_skip_ajax_action($act)) continue;
                    
                    $matches_count[$act] = ($matches_count[$act] ?? 0) + 3; // higher weight
                    $debug_info[$act][] = "Found in: $relative_path (wp_ajax)";
                    if (stripos($act, 'variation') !== false || stripos($act, 'gallery') !== false || stripos($act, 'image') !== false || stripos($act, 'thumb') !== false) {
                        $prioritized[$act] = ($prioritized[$act] ?? 0) + 5;
                    }
                }
            }

            // Pattern 2: Enhanced URL action detection
            if (preg_match_all("/(admin-ajax\.php\?action=|ajaxurl.*action=)([a-zA-Z0-9_\-]+)/", $content, $m2)) {
                foreach ($m2[2] as $act) {
                    // Skip irrelevant actions
                    if (ams_should_skip_ajax_action($act)) continue;
                    
                    $matches_count[$act] = ($matches_count[$act] ?? 0) + 2;
                    $debug_info[$act][] = "Found in: $relative_path (URL)";
                    if (stripos($act, 'variation') !== false || stripos($act, 'gallery') !== false || stripos($act, 'image') !== false) {
                        $prioritized[$act] = ($prioritized[$act] ?? 0) + 3;
                    }
                }
            }

            // Pattern 3: Enhanced JS object action detection
            if (preg_match_all("/action\s*[:=]\s*['\"]([a-zA-Z0-9_\-]+)['\"]/", $content, $m3)) {
                foreach ($m3[1] as $act) {
                    // Skip irrelevant actions
                    if (ams_should_skip_ajax_action($act)) continue;
                    
                    $matches_count[$act] = ($matches_count[$act] ?? 0) + 2;
                    $debug_info[$act][] = "Found in: $relative_path (JS object)";
                    if (stripos($act, 'variation') !== false || stripos($act, 'gallery') !== false || stripos($act, 'image') !== false) {
                        $prioritized[$act] = ($prioritized[$act] ?? 0) + 3;
                    }
                }
            }

            // Pattern 4: jQuery AJAX calls
            if (preg_match_all("/(jQuery\.post|jQuery\.get|\.post|\.get|\.ajax)\s*\(\s*[^)]*action\s*[:=]\s*['\"]([a-zA-Z0-9_\-]+)['\"]/", $content, $m4)) {
                foreach ($m4[2] as $act) {
                    $matches_count[$act] = ($matches_count[$act] ?? 0) + 2;
                    $debug_info[$act][] = "Found in: $relative_path (jQuery AJAX)";
                    if (stripos($act, 'variation') !== false || stripos($act, 'gallery') !== false || stripos($act, 'image') !== false) {
                        $prioritized[$act] = ($prioritized[$act] ?? 0) + 3;
                    }
                }
            }

            // Pattern 5: WordPress AJAX calls
            if (preg_match_all("/(wp\.ajax\.post|wp\.ajax\.send)\s*\(\s*[^)]*action\s*[:=]\s*['\"]([a-zA-Z0-9_\-]+)['\"]/", $content, $m5)) {
                foreach ($m5[2] as $act) {
                    $matches_count[$act] = ($matches_count[$act] ?? 0) + 3;
                    $debug_info[$act][] = "Found in: $relative_path (WordPress AJAX)";
                    if (stripos($act, 'variation') !== false || stripos($act, 'gallery') !== false || stripos($act, 'image') !== false) {
                        $prioritized[$act] = ($prioritized[$act] ?? 0) + 4;
                    }
                }
            }

            // Pattern 6: Fetch API calls
            if (preg_match_all("/fetch\s*\(\s*[^)]*action=([a-zA-Z0-9_\-]+)/", $content, $m6)) {
                foreach ($m6[1] as $act) {
                    $matches_count[$act] = ($matches_count[$act] ?? 0) + 2;
                    $debug_info[$act][] = "Found in: $relative_path (Fetch API)";
                    if (stripos($act, 'variation') !== false || stripos($act, 'gallery') !== false || stripos($act, 'image') !== false) {
                        $prioritized[$act] = ($prioritized[$act] ?? 0) + 3;
                    }
                }
            }
        }
    }

    // Add known common AJAX actions
    $known_actions = array(
        'woocommerce_get_variation_gallery' => 8,
        'variation_gallery_images' => 7,
        'get_variation_gallery' => 6,
        'wc_variation_gallery' => 6,
        'variation_images' => 5,
        'product_variation_gallery' => 5,
        'theme_variation_gallery' => 4,
        'custom_variation_gallery' => 4
    );

    foreach ($known_actions as $action => $score) {
        if (isset($matches_count[$action])) {
            $prioritized[$action] = ($prioritized[$action] ?? 0) + $score;
            $debug_info[$action][] = "Known common action";
        }
    }

    // Debug info (commented out to reduce log spam)
    // error_log('AMS AJAX Detection Debug: ' . print_r(array(
    //     'total_actions' => count($matches_count),
    //     'prioritized_actions' => count($prioritized),
    //     'top_5_priority' => array_slice($prioritized, 0, 5, true),
    //     'top_5_general' => array_slice($matches_count, 0, 5, true)
    // ), true));

    if (!empty($matches_count)) {
        // Prefer prioritized names containing variation/gallery/image (but filter out irrelevant ones)
        if (!empty($prioritized)) {
            // Filter prioritized actions to exclude irrelevant ones
            $filtered_prioritized = array();
            foreach ($prioritized as $action => $score) {
                if (!ams_should_skip_ajax_action($action)) {
                    $filtered_prioritized[$action] = $score;
                }
            }
            
            if (!empty($filtered_prioritized)) {
                arsort($filtered_prioritized);
                $best = array_key_first($filtered_prioritized);
                if (!empty($best) && $filtered_prioritized[$best] >= 3) {
                    // error_log("AMS AJAX Detection: Selected '$best' with priority score {$filtered_prioritized[$best]}");
                    return $best;
                }
            }
        }
        
        // Filter general matches to prefer variation/gallery related actions and exclude irrelevant ones
        $filtered_actions = array();
        foreach ($matches_count as $action => $score) {
            // Skip irrelevant actions first
            if (ams_should_skip_ajax_action($action)) {
                continue;
            }
            
            // Then check if it's variation/gallery related
            if (stripos($action, 'variation') !== false || 
                stripos($action, 'gallery') !== false || 
                stripos($action, 'image') !== false ||
                stripos($action, 'product') !== false) {
                $filtered_actions[$action] = $score;
            }
        }
        
        if (!empty($filtered_actions)) {
            arsort($filtered_actions);
            $best = array_key_first($filtered_actions);
            if (!empty($best) && $filtered_actions[$best] >= 2) {
                // error_log("AMS AJAX Detection: Selected '$best' with filtered score {$filtered_actions[$best]}");
                return $best;
            }
        }
        
        // Fallback to most frequent if no filtered matches (but still skip irrelevant ones)
        $fallback_actions = array();
        foreach ($matches_count as $action => $score) {
            if (!ams_should_skip_ajax_action($action)) {
                $fallback_actions[$action] = $score;
            }
        }
        
        if (!empty($fallback_actions)) {
            arsort($fallback_actions);
            $best = array_key_first($fallback_actions);
            if (!empty($best) && $fallback_actions[$best] >= 2) {
                // error_log("AMS AJAX Detection: Selected '$best' with fallback score {$fallback_actions[$best]}");
                return $best;
            }
        }
    }

    // error_log('AMS AJAX Detection: No suitable action found');
    return '';
}

// Enhanced variation meta key detection with improved scanning
function ams_detect_variation_meta_key() {
    $paths = array_unique(array_filter(array(
        get_stylesheet_directory(),
        get_template_directory(),
    )));

    $meta_key_patterns = array();
    $priority_patterns = array();
    $debug_info = array();

    foreach ($paths as $base) {
        if (!is_dir($base)) continue;
        
        // Scan ALL PHP and JS files recursively
        $it = new RecursiveIteratorIterator(
            new RecursiveDirectoryIterator($base, FilesystemIterator::SKIP_DOTS)
        );
        
        foreach ($it as $fileInfo) {
            $ext = strtolower(pathinfo($fileInfo->getFilename(), PATHINFO_EXTENSION));
            if (!in_array($ext, array('php', 'js'))) continue;
            
            $content = @file_get_contents($fileInfo->getPathname());
            if ($content === false) continue;
            
            $relative_path = str_replace($base, '', $fileInfo->getPathname());

            // Pattern 1: Enhanced meta function calls with better regex
            if (preg_match_all("/(get_post_meta|update_post_meta|get_metadata|update_metadata)\s*\(\s*[^,]+,\s*['\"]([^'\"]+)['\"]/", $content, $m1)) {
                foreach ($m1[2] as $key) {
                    if (strlen($key) < 3) continue;
                    $meta_key_patterns[$key] = ($meta_key_patterns[$key] ?? 0) + 2;
                    $debug_info[$key][] = "Found in: $relative_path (meta function)";
                    
                    // Higher priority for gallery/image/variation related keys
                    if ((stripos($key, 'gallery') !== false || stripos($key, 'image') !== false || stripos($key, 'thumb') !== false) &&
                        stripos($key, 'variation_id') === false &&
                        stripos($key, 'thumbnail') === false &&
                        stripos($key, 'background') === false &&
                        stripos($key, 'empty') === false &&
                        stripos($key, '404') === false &&
                        stripos($key, 'cart') === false) {
                        $priority_patterns[$key] = ($priority_patterns[$key] ?? 0) + 6;
                    }
                }
            }

            // Pattern 2: Enhanced string pattern matching for meta keys
            if (preg_match_all("/['\"]([_a-zA-Z][a-zA-Z0-9_\-]*(?:gallery|image|variation|wcgallary|thumb|photo)[a-zA-Z0-9_\-]*)['\"]|['\"]([a-zA-Z0-9_\-]*(?:gallery|image|variation|wcgallary|thumb|photo)[a-zA-Z0-9_\-]*)['\"]|['\"](_[a-zA-Z0-9_\-]{4,})['\"]|['\"]([a-zA-Z0-9_\-]{4,}_gallery)['\"]|['\"]([a-zA-Z0-9_\-]{4,}_image)['\"]|['\"]([a-zA-Z0-9_\-]{4,}_variation)['\"]/i", $content, $m2)) {
                $all_matches = array_merge($m2[1], $m2[2], $m2[3], $m2[4], $m2[5], $m2[6]);
                foreach ($all_matches as $key) {
                    if (empty($key) || strlen($key) < 3) continue;
                    $meta_key_patterns[$key] = ($meta_key_patterns[$key] ?? 0) + 1;
                    $debug_info[$key][] = "Found in: $relative_path (quoted string)";
                    
                    if ((stripos($key, 'gallery') !== false || stripos($key, 'image') !== false || stripos($key, 'wcgallary') !== false || stripos($key, 'thumb') !== false) &&
                        stripos($key, 'variation_id') === false &&
                        stripos($key, 'thumbnail') === false &&
                        stripos($key, 'background') === false &&
                        stripos($key, 'empty') === false &&
                        stripos($key, '404') === false &&
                        stripos($key, 'cart') === false) {
                        $priority_patterns[$key] = ($priority_patterns[$key] ?? 0) + 4;
                    }
                }
            }

            // Pattern 3: Look for WooCommerce specific patterns and contexts
            $woo_patterns = array(
                '/\$variation.*gallery/i',
                '/variation.*image.*gallery/i',
                '/gallery.*variation/i',
                '/woo.*variation.*gallery/i',
                '/product.*variation.*image/i',
                '/variation.*thumb/i',
                '/thumb.*variation/i',
                '/wc.*variation.*gallery/i',
                '/woocommerce.*variation/i'
            );
            
            foreach ($woo_patterns as $pattern) {
                if (preg_match($pattern, $content)) {
                    // Extract potential meta keys from this context with better regex
                    if (preg_match_all("/['\"]([a-zA-Z0-9_\-]{4,})['\"]/", $content, $context_matches)) {
                        foreach ($context_matches[1] as $key) {
                            if ((stripos($key, 'gallery') !== false || stripos($key, 'image') !== false || stripos($key, 'thumb') !== false) &&
                                stripos($key, 'variation_id') === false &&
                                stripos($key, 'thumbnail') === false &&
                                stripos($key, 'background') === false &&
                                stripos($key, 'empty') === false &&
                                stripos($key, '404') === false &&
                                stripos($key, 'cart') === false) {
                                $meta_key_patterns[$key] = ($meta_key_patterns[$key] ?? 0) + 3;
                                $priority_patterns[$key] = ($priority_patterns[$key] ?? 0) + 5;
                                $debug_info[$key][] = "Found in: $relative_path (WooCommerce context)";
                            }
                        }
                    }
                }
            }

            // Pattern 4: Look for JavaScript AJAX calls and data attributes
            if ($ext === 'js') {
                // Look for AJAX calls that might indicate variation gallery handling
                if (preg_match_all("/(ajax|fetch|jQuery\.post|jQuery\.get|wp\.ajax|wc_variation|variation_gallery)/i", $content, $ajax_matches)) {
                    // Extract potential meta keys from AJAX context
                    if (preg_match_all("/['\"]([a-zA-Z0-9_\-]{4,})['\"]/", $content, $ajax_key_matches)) {
                        foreach ($ajax_key_matches[1] as $key) {
                            if ((stripos($key, 'gallery') !== false || stripos($key, 'image') !== false) &&
                                stripos($key, 'variation_id') === false &&
                                stripos($key, 'thumbnail') === false &&
                                stripos($key, 'background') === false &&
                                stripos($key, 'empty') === false &&
                                stripos($key, '404') === false &&
                                stripos($key, 'cart') === false) {
                                $meta_key_patterns[$key] = ($meta_key_patterns[$key] ?? 0) + 2;
                                $priority_patterns[$key] = ($priority_patterns[$key] ?? 0) + 3;
                                $debug_info[$key][] = "Found in: $relative_path (JavaScript AJAX)";
                            }
                        }
                    }
                }
            }

            // Pattern 5: Look for theme-specific patterns
            $theme_patterns = array(
                '/theme.*variation/i',
                '/custom.*gallery/i',
                '/variation.*custom/i',
                '/gallery.*custom/i'
            );
            
            foreach ($theme_patterns as $pattern) {
                if (preg_match($pattern, $content)) {
                    if (preg_match_all("/['\"]([a-zA-Z0-9_\-]{4,})['\"]/", $content, $theme_matches)) {
                        foreach ($theme_matches[1] as $key) {
                            if ((stripos($key, 'gallery') !== false || stripos($key, 'image') !== false) &&
                                stripos($key, 'variation_id') === false &&
                                stripos($key, 'thumbnail') === false &&
                                stripos($key, 'background') === false &&
                                stripos($key, 'empty') === false &&
                                stripos($key, '404') === false &&
                                stripos($key, 'cart') === false) {
                                $meta_key_patterns[$key] = ($meta_key_patterns[$key] ?? 0) + 2;
                                $priority_patterns[$key] = ($priority_patterns[$key] ?? 0) + 4;
                                $debug_info[$key][] = "Found in: $relative_path (theme-specific)";
                            }
                        }
                    }
                }
            }
        }
    }

    // Check database for ACTUAL meta keys being used
    global $wpdb;
    
    // Enhanced database query for variation gallery related meta keys
    $db_keys = $wpdb->get_results("
        SELECT meta_key, COUNT(*) as usage_count 
        FROM {$wpdb->postmeta} 
        WHERE (meta_key LIKE '%gallery%' 
           OR meta_key LIKE '%image%' 
           OR meta_key LIKE '%variation%'
           OR meta_key LIKE '%wcgallary%'
           OR meta_key LIKE '%thumb%'
           OR meta_key LIKE '%photo%'
           OR meta_key LIKE '_product_%'
           OR meta_key LIKE '_woo%'
           OR meta_key LIKE '%_gallery'
           OR meta_key LIKE '%_image'
           OR meta_key LIKE '%_variation'
           OR meta_key LIKE 'woo_%'
           OR meta_key LIKE 'wc_%'
           OR meta_key LIKE 'theme_%'
           OR meta_key LIKE 'custom_%')
        AND meta_value != ''
        AND meta_value != 'a:0:{}'
        AND meta_value != '[]'
        GROUP BY meta_key
        ORDER BY usage_count DESC
        LIMIT 150
    ");
    
    foreach ($db_keys as $row) {
        $key = $row->meta_key;
        $count = intval($row->usage_count);
        
        // Higher scoring for more usage and relevant patterns
        $base_score = $count > 20 ? 8 : ($count > 10 ? 6 : 4);
        $meta_key_patterns[$key] = ($meta_key_patterns[$key] ?? 0) + $base_score;
        $debug_info[$key][] = "Found in database: $count records";
        
        if ((stripos($key, 'gallery') !== false || stripos($key, 'image') !== false || stripos($key, 'thumb') !== false) &&
            stripos($key, 'variation_id') === false &&
            stripos($key, 'thumbnail') === false &&
            stripos($key, 'background') === false &&
            stripos($key, 'empty') === false &&
            stripos($key, '404') === false &&
            stripos($key, 'cart') === false) {
            $priority_patterns[$key] = ($priority_patterns[$key] ?? 0) + ($count > 20 ? 10 : ($count > 10 ? 8 : 6));
        }
    }

    // Enhanced known patterns with more comprehensive list
    $known_patterns = array(
        '_product_image_gallery' => 12,
        '_variation_image_gallery' => 11, 
        'woo_variation_gallery_images' => 10,
        '_woocommerce_variation_gallery' => 10,
        'variation_gallery_images' => 9,
        '_amswoofiu_wcgallary' => 9,
        'product_gallery_images' => 8,
        '_product_gallery' => 8,
        'wc_variation_gallery' => 8,
        '_variation_gallery' => 8,
        '_product_image_gallery_thumbnails' => 7,
        'woocommerce_variation_gallery_images' => 7,
        'theme_variation_gallery' => 7,
        'custom_variation_gallery' => 7,
        '_wc_variation_gallery' => 7,
        'variation_images' => 6,
        '_variation_images' => 6,
        'product_variation_gallery' => 6,
        'woo_product_gallery' => 6,
        'theme_gallery_images' => 6
    );
    
    foreach ($known_patterns as $pattern => $score) {
        // Check if this pattern exists in any scanned content or database
        if (isset($meta_key_patterns[$pattern]) || 
            $wpdb->get_var($wpdb->prepare("SELECT COUNT(*) FROM {$wpdb->postmeta} WHERE meta_key = %s LIMIT 1", $pattern)) > 0) {
            $priority_patterns[$pattern] = ($priority_patterns[$pattern] ?? 0) + $score;
            $debug_info[$pattern][] = "Known common pattern";
        }
    }

    // Log debug info for troubleshooting
    // Debug info (commented out to reduce log spam)
    // error_log('AMS Meta Key Detection Debug: ' . print_r(array(
    //     'total_patterns' => count($meta_key_patterns),
    //     'priority_patterns' => count($priority_patterns),
    //     'top_5_priority' => array_slice($priority_patterns, 0, 5, true),
    //     'top_5_general' => array_slice($meta_key_patterns, 0, 5, true)
    // ), true));

    // Smart scoring system for meta keys
    $smart_scores = array();
    foreach ($priority_patterns as $key => $score) {
        $smart_score = 0;
        
        // Positive scoring for relevant terms
        if (stripos($key, 'variation') !== false && stripos($key, 'gallery') !== false) {
            $smart_score += 100; // Perfect match: variation + gallery
        } elseif (stripos($key, 'variation') !== false && stripos($key, 'image') !== false) {
            $smart_score += 90; // Great match: variation + image
        } elseif (stripos($key, 'gallery') !== false) {
            $smart_score += 70; // Good match: gallery
        } elseif (stripos($key, 'variation') !== false) {
            $smart_score += 60; // Decent match: variation
        } elseif (stripos($key, 'image') !== false && strlen($key) > 8) {
            $smart_score += 50; // Okay match: specific image key
        }
        
        // Negative scoring for irrelevant terms
        if (stripos($key, 'video') !== false) $smart_score -= 20;
        if (stripos($key, 'background') !== false) $smart_score -= 30;
        if (stripos($key, 'logo') !== false) $smart_score -= 30;
        if (stripos($key, 'avatar') !== false) $smart_score -= 30;
        if (stripos($key, 'banner') !== false) $smart_score -= 30;
        if (stripos($key, 'header') !== false) $smart_score -= 20;
        if (stripos($key, 'footer') !== false) $smart_score -= 20;
        if (stripos($key, 'sidebar') !== false) $smart_score -= 20;
        if (stripos($key, 'menu') !== false) $smart_score -= 20;
        if (stripos($key, 'button') !== false) $smart_score -= 20;
        if (stripos($key, 'icon') !== false) $smart_score -= 15;
        if (stripos($key, 'empty') !== false) $smart_score -= 25;
        if (stripos($key, '404') !== false) $smart_score -= 25;
        if (stripos($key, 'error') !== false) $smart_score -= 25;
        if (stripos($key, 'loading') !== false) $smart_score -= 15;
        if (stripos($key, 'placeholder') !== false) $smart_score -= 15;
        if (strpos($key, 'data-') === 0) $smart_score -= 40; // Data attributes
        if (preg_match('/^[a-z]-/', $key)) $smart_score -= 35; // CSS classes
        if ($key === 'image' || $key === 'images' || $key === 'thumb' || $key === 'thumbs') $smart_score -= 50;
        if (stripos($key, '_id') !== false) $smart_score -= 30; // ID fields
        
        // Boost for meta key patterns
        if (strpos($key, '_') === 0) $smart_score += 10; // WordPress meta keys
        if (stripos($key, 'woo') !== false || stripos($key, 'wc_') !== false) $smart_score += 15; // WooCommerce
        
        // Only consider keys with positive smart scores
        if ($smart_score > 0) {
            $smart_scores[$key] = $smart_score + ($score * 0.1); // Include original score as minor factor
        }
    }

    if (!empty($smart_scores)) {
        arsort($smart_scores);
        $best = array_key_first($smart_scores);
        if (!empty($best) && $smart_scores[$best] >= 10) {
            // error_log("AMS Meta Key Detection: Selected '$best' with smart score {$smart_scores[$best]}");
            return $best;
        }
    }
    
    // Fallback: Apply smart scoring to general patterns if no priority matches
    if (empty($smart_scores)) {
        $general_smart_scores = array();
        foreach ($meta_key_patterns as $key => $score) {
            $smart_score = 0;
            
            // Same smart scoring logic for general patterns
            if (stripos($key, 'variation') !== false && stripos($key, 'gallery') !== false) {
                $smart_score += 80;
            } elseif (stripos($key, 'variation') !== false && stripos($key, 'image') !== false) {
                $smart_score += 70;
            } elseif (stripos($key, 'gallery') !== false) {
                $smart_score += 50;
            } elseif (stripos($key, 'variation') !== false) {
                $smart_score += 40;
            } elseif (stripos($key, 'image') !== false && strlen($key) > 6) {
                $smart_score += 30;
            }
            
            // Apply same negative scoring
            if (stripos($key, 'video') !== false) $smart_score -= 15;
            if (stripos($key, 'background') !== false) $smart_score -= 25;
            if (stripos($key, 'logo') !== false) $smart_score -= 25;
            if (stripos($key, 'avatar') !== false) $smart_score -= 25;
            if (stripos($key, 'banner') !== false) $smart_score -= 25;
            if (strpos($key, 'data-') === 0) $smart_score -= 30;
            if (preg_match('/^[a-z]-/', $key)) $smart_score -= 25;
            if ($key === 'image' || $key === 'images') $smart_score -= 40;
            if (stripos($key, '_id') !== false) $smart_score -= 25;
            
            // Boost for meta key patterns
            if (strpos($key, '_') === 0) $smart_score += 5;
            if (stripos($key, 'woo') !== false) $smart_score += 10;
            
            if ($smart_score > 0) {
                $general_smart_scores[$key] = $smart_score + ($score * 0.1);
            }
        }
        
        if (!empty($general_smart_scores)) {
            arsort($general_smart_scores);
            $best = array_key_first($general_smart_scores);
            if (!empty($best) && $general_smart_scores[$best] >= 5) {
            return $best;
            }
        }
    }

    // Final fallback: try to find the best meta key from database only
    if (empty($filtered_priority) && empty($filtered_general)) {
        
        // Get the most used gallery-related meta key from database
        $fallback_keys = $wpdb->get_results("
            SELECT meta_key, COUNT(*) as usage_count 
            FROM {$wpdb->postmeta} 
            WHERE (meta_key LIKE '%gallery%' 
               OR meta_key LIKE '%image%' 
               OR meta_key LIKE '%variation%'
               OR meta_key LIKE '%wcgallary%'
               OR meta_key LIKE '%thumb%'
               OR meta_key LIKE '%photo%')
            AND meta_value != ''
            AND meta_value != 'a:0:{}'
            AND meta_value != '[]'
            AND LENGTH(meta_value) > 10
            GROUP BY meta_key
            ORDER BY usage_count DESC
            LIMIT 10
        ");
        
        if (!empty($fallback_keys)) {
            $best_fallback = $fallback_keys[0];
            return $best_fallback->meta_key;
        }
    }

    return '';
}

// Register AJAX handlers dynamically based on settings
function ams_register_variation_ajax_handlers() {
    // Prevent multiple registrations using option flag
    if (get_option('ams_ajax_handlers_registered', '0') === '1') {
        return;
    }
    update_option('ams_ajax_handlers_registered', '1');
    
    // Get the custom AJAX action from settings
    $custom_ajax_action = get_option('variation_ajax_action', '');
    
    // Generic AJAX actions that work with most themes
    $ajax_actions = array(
        'woocommerce_get_variation_gallery', // Generic WooCommerce
        'variation_gallery_images', // Common pattern
    );
    
    // Add custom AJAX action if specified by user
    if (!empty($custom_ajax_action) && !in_array($custom_ajax_action, $ajax_actions)) {
        $ajax_actions[] = $custom_ajax_action;
    }
    
    
    // Register all AJAX actions with high priority to override theme handlers
    foreach ($ajax_actions as $action) {
        add_action('wp_ajax_' . $action, 'ams_universal_variation_gallery_ajax', 5);
        add_action('wp_ajax_nopriv_' . $action, 'ams_universal_variation_gallery_ajax', 5);
    }
    
    error_log("AMS Debug: Registered AJAX handlers for actions: " . implode(', ', $ajax_actions));
    
    // Clear the registration flag after 5 seconds to allow re-registration if needed
    wp_schedule_single_event(time() + 5, 'ams_clear_ajax_registration_flag');
}
// Disabled - using simplified system now
// add_action('init', 'ams_register_variation_ajax_handlers');

// Hook into WordPress AJAX to intercept variation image requests
function ams_intercept_variation_ajax() {
    if (defined('DOING_AJAX') && DOING_AJAX && isset($_POST['action'])) {
        $action = $_POST['action'];
        
        // Check if this is a variation image request that we should handle
        if (strpos($action, 'variation_images') !== false || 
            strpos($action, 'variation_gallery') !== false ||
            (strpos($action, 'variation') !== false && strpos($action, 'image') !== false)) {
            
            // Check if we have variation data for this request
            if (isset($_POST['variation_id'])) {
                $variation_id = intval($_POST['variation_id']);
                $variation_meta_key = get_option('variation_image_meta_key', '_product_image_gallery');
                $gallery_data = get_post_meta($variation_id, $variation_meta_key, true);
                
                // If we have remote image data, handle it with our universal handler
                if (!empty($gallery_data) && is_array($gallery_data)) {
                    // Check if any of the gallery data contains URLs (remote images)
                    $has_remote_images = false;
                    foreach ($gallery_data as $item) {
                        if (is_string($item) && filter_var($item, FILTER_VALIDATE_URL)) {
                            $has_remote_images = true;
                            break;
                        }
                    }
                    
                    if ($has_remote_images) {
                        error_log("AMS Debug: Intercepting AJAX action '$action' for remote images");
                        // Remove any existing handlers for this action to prevent conflicts
                        remove_all_actions("wp_ajax_$action");
                        remove_all_actions("wp_ajax_nopriv_$action");
                        
                        // Call our universal handler
                        ams_universal_variation_gallery_ajax();
                        exit;
                    }
                }
            }
        }
    }
}
// Register interceptor for any detected variation AJAX action
function ams_register_ajax_interceptors() {
    // Prevent multiple registrations using persistent flag
    if (get_option('ams_interceptors_registered', '0') === '1') {
        return;
    }
    update_option('ams_interceptors_registered', '1');
    
    $detected_action = get_option('variation_ajax_action', '');
    if (!empty($detected_action) && !ams_should_skip_ajax_action($detected_action)) {
        add_action("wp_ajax_$detected_action", 'ams_intercept_variation_ajax', 1);
        add_action("wp_ajax_nopriv_$detected_action", 'ams_intercept_variation_ajax', 1);
        // error_log("AMS Debug: Registered interceptor for detected action: $detected_action");
    } else if (!empty($detected_action)) {
        // error_log("AMS Debug: Skipping interceptor for irrelevant action: $detected_action");
    }
}
// Disabled - using simplified system now
// add_action('init', 'ams_register_ajax_interceptors');

// Clear AJAX registration flag
function ams_clear_ajax_registration_flag() {
    delete_option('ams_ajax_handlers_registered');
}
add_action('ams_clear_ajax_registration_flag', 'ams_clear_ajax_registration_flag');

// Force re-detection of AJAX action (clear wrong detections) - run once only
function ams_force_redetect_ajax_action() {
    // Check if we've already done this cleanup
    if (get_option('ams_ajax_cleanup_done', '0') === '1') {
        return;
    }
    
    $current_action = get_option('variation_ajax_action', '');
    if (!empty($current_action) && ams_should_skip_ajax_action($current_action)) {
        // error_log("AMS Debug: Clearing irrelevant detected action: $current_action");
        delete_option('variation_ajax_action');

        // Force re-run detection for meta key and AJAX action
        $detected_meta_key = ams_detect_variation_meta_key();
        if (!empty($detected_meta_key)) {
            update_option('variation_image_meta_key', $detected_meta_key);
        }
        
        $detected_ajax = ams_detect_theme_ajax_action();
        if (!empty($detected_ajax)) {
            update_option('variation_ajax_action', $detected_ajax);
        }
        
        // Mark cleanup as done to prevent infinite loop
        update_option('ams_ajax_cleanup_done', '1');
        
        // Don't re-run detection automatically, let it happen naturally
        // error_log("AMS Debug: Cleanup completed, detection will run on next auto-detect trigger");
    } else {
        // Mark as done even if no cleanup was needed
        update_option('ams_ajax_cleanup_done', '1');
    }
}
// Run this once to clear any existing wrong detections
// Disabled - using simplified system now
// add_action('init', 'ams_force_redetect_ajax_action', 15);


// AJAX handler for manual reset to defaults
function ams_reset_theme_defaults_ajax() {
    // Verify nonce
    if (!wp_verify_nonce($_POST['nonce'], 'ams_reset_defaults_nonce')) {
        wp_send_json_error('Invalid nonce');
        return;
    }
    
    // Force reset to new optimal defaults for remote images
    update_option('theme_image_format', 'url');
    update_option('theme_thumb_format', 'url');
    update_option('theme_full_format', 'url');
    update_option('theme_thumb_url_format', 'url');
    
    // Mark that user has manually configured theme settings (prevent auto-override)
    update_option('ams_manual_theme_settings', '1');
    
    
    wp_send_json_success('Settings reset to optimal defaults for remote images');
}
add_action('wp_ajax_ams_reset_theme_defaults', 'ams_reset_theme_defaults_ajax');


// Debug function to manually check what meta keys are found
function ams_debug_meta_key_detection() {
    if (!current_user_can('manage_options')) return;
    
    echo "<h3>AMS Meta Key Detection Debug</h3>";
    
    // Run detection
    $detected = ams_detect_variation_meta_key();
    echo "<p><strong>Detected Meta Key:</strong> <code>" . ($detected ?: 'None found') . "</code></p>";
    
    // Check database
    global $wpdb;
    $db_keys = $wpdb->get_results("
        SELECT meta_key, COUNT(*) as count 
        FROM {$wpdb->postmeta} 
        WHERE (meta_key LIKE '%gallery%' OR meta_key LIKE '%image%' OR meta_key LIKE '%variation%')
        AND meta_value != ''
        GROUP BY meta_key 
        ORDER BY count DESC 
        LIMIT 20
    ");
    
    echo "<h4>Database Meta Keys:</h4><ul>";
    foreach ($db_keys as $row) {
        echo "<li><code>{$row->meta_key}</code> ({$row->count} records)</li>";
    }
    echo "</ul>";
    
    // Check theme files
    $theme_dir = get_template_directory();
    echo "<h4>Theme Directory:</h4><p><code>$theme_dir</code></p>";
    
    // Check for specific files
    $check_files = array(
        '/functions.php',
        '/woocommerce/single-product/product-image.php',
        '/inc/woocommerce.php',
        '/includes/woocommerce.php'
    );
    
    echo "<h4>Key Theme Files:</h4><ul>";
    foreach ($check_files as $file) {
        $full_path = $theme_dir . $file;
        if (file_exists($full_path)) {
            echo "<li>✅ <code>$file</code> exists</li>";
            $content = file_get_contents($full_path);
            if (preg_match_all("/(get_post_meta|update_post_meta)\s*\([^,]+,\s*['\"]([^'\"]+)['\"]/", $content, $matches)) {
                echo "<ul>";
                foreach (array_unique($matches[2]) as $key) {
                    if (stripos($key, 'gallery') !== false || stripos($key, 'image') !== false || stripos($key, 'variation') !== false) {
                        echo "<li><code>$key</code></li>";
                    }
                }
                echo "</ul>";
            }
        } else {
            echo "<li>❌ <code>$file</code> not found</li>";
        }
    }
    echo "</ul>";
}

// Add debug URL: /wp-admin/admin.php?page=ams-debug-meta-keys
if (isset($_GET['page']) && $_GET['page'] === 'ams-debug-meta-keys') {
    add_action('admin_init', function() {
        ams_debug_meta_key_detection();
        exit;
    });
}

function update_custom_variation_images() {
    global $wpdb;
    // Get the user-defined meta key from plugin settings, default to '_product_image_gallery'
    $custom_meta_key = get_option('variation_image_meta_key', '_product_image_gallery');
    // Check if remote images are enabled
    $use_remote_images = ('Yes' === get_option('ams_remote_amazon_images'));
    // Query to get all variation IDs
    $variation_ids = $wpdb->get_col("
        SELECT ID FROM {$wpdb->posts}
        WHERE post_type = 'product_variation' AND post_status = 'publish'
    ");

    foreach ($variation_ids as $variation_id) {
        $gallery_data = array();

        // Get the product gallery images from _product_image_gallery
        $standard_gallery = get_post_meta($variation_id, '_product_image_gallery', true);

        // Ensure standard_gallery is a string before exploding
        if (is_string($standard_gallery) && !empty($standard_gallery)) {
            $gallery_ids = explode(',', $standard_gallery);
            foreach ($gallery_ids as $id) {
                $gallery_data[] = array(
                    'id' => $id,
                    'url' => wp_get_attachment_url($id)
                );
            }
        }

        // Check for woo_variation_gallery_images
        $woo_variation_gallery = maybe_unserialize(get_post_meta($variation_id, 'woo_variation_gallery_images', true));
        if (!empty($woo_variation_gallery) && is_array($woo_variation_gallery)) {
            foreach ($woo_variation_gallery as $id) {
                if (!in_array($id, array_column($gallery_data, 'id'))) {
                    $gallery_data[] = array(
                        'id' => $id,
                        'url' => wp_get_attachment_url($id)
                    );
                }
            }
        }

        // Check for URL-based images from _amswoofiu_wcgallary
        $url_based_gallery = get_post_meta($variation_id, '_amswoofiu_wcgallary', true);
        $url_based_gallery_array = maybe_unserialize($url_based_gallery);
        if (is_array($url_based_gallery_array)) {
            foreach ($url_based_gallery_array as $image) {
                $image_url = '';
                
                // Handle different formats
                if (is_array($image) && isset($image['url'])) {
                    // Format: array('url' => '...', 'width' => ..., 'height' => ...)
                    $image_url = $image['url'];
                } elseif (is_string($image) && filter_var($image, FILTER_VALIDATE_URL)) {
                    // Format: simple URL string
                    $image_url = $image;
                }
                
                if (!empty($image_url) && !in_array($image_url, array_column($gallery_data, 'url'))) {
                    $gallery_data[] = array(
                        'id' => '',
                        'url' => $image_url
                    );
                }
            }
        }
        
        // If no images found on variation, check parent product
        if (empty($gallery_data)) {
            $parent_id = wp_get_post_parent_id($variation_id);
            if ($parent_id) {
                $parent_amazon_gallery = get_post_meta($parent_id, '_amswoofiu_wcgallary', true);
                if (!empty($parent_amazon_gallery) && is_array($parent_amazon_gallery)) {
                    foreach ($parent_amazon_gallery as $item) {
                        if (is_array($item) && !empty($item['url'])) {
                            $gallery_data[] = array('url' => $item['url'], 'id' => '');
                        }
                    }
                }
            }
        }

        // Prepare the final gallery based on the remote images setting
        $final_gallery = array();
        foreach ($gallery_data as $image) {
            if ($use_remote_images) {
                if (!empty($image['url'])) {
                    $final_gallery[] = $image['url'];
                } elseif (!empty($image['id'])) {
                    $final_gallery[] = $image['id'];
                }
            } else {
                if (!empty($image['id'])) {
                    $final_gallery[] = $image['id'];
                } elseif (!empty($image['url'])) {
                    $final_gallery[] = $image['url'];
                }
            }
        }

        // Update the custom meta key with the final gallery
        if (!empty($final_gallery)) {
            update_post_meta($variation_id, $custom_meta_key, $final_gallery);
        } else {
            delete_post_meta($variation_id, $custom_meta_key);
        }
    }
}
/**
 * Enhanced variation image display that integrates with WooCommerce native system
 */
function ams_display_variation_images_readonly($loop, $variation_data, $variation) {
    $variation_id = $variation->ID;
    $remote_images_enabled = get_option('ams_remote_amazon_images') === 'Yes';
    
    // Get the configured meta key from plugin settings
    $meta_key = get_option('variation_image_meta_key', '_product_image_gallery');
    
    // Get both remote URLs and attachment IDs
    $gallery_urls = get_post_meta($variation_id, $meta_key, true);
    // If the main meta key is missing attachment IDs, try our protected backup
    $protected_data = get_post_meta($variation_id, 'ams_variation_images_protected', true);
    if (!empty($protected_data)) {
        // Use protected data if it has more items (indicating it has attachment IDs)
        if (count($protected_data) > count($gallery_urls)) {
            $gallery_urls = $protected_data;
        }
    }
    $attachment_ids = array();
    $remote_urls = array();
    
    if (!empty($gallery_urls)) {
        // Handle both array and string data formats
        if (is_array($gallery_urls)) {
            // Data is already an array
            $urls = $gallery_urls;
        } else {
            // Data is a string (like _product_image_gallery)
            $urls = explode(',', $gallery_urls);
        }
        
        // Handle mixed data - both URLs and attachment IDs
        foreach ($urls as $item) {
            if (is_string($item)) {
                $item = trim($item);
            }
            
            if (!empty($item)) {
                if (filter_var($item, FILTER_VALIDATE_URL)) {
                    // It's a URL
                    $remote_urls[] = $item;
                } elseif (is_numeric($item) && intval($item) > 0) {
                    // It's an attachment ID
                    $attachment_ids[] = intval($item);
                }
            }
        }
    }
    
    // Only show if we have images or if we want to show upload option
    if (empty($remote_urls) && empty($attachment_ids)) {
        return;
    }
    
    ?>
    <div class="form-row form-row-full">
        <label><strong><?php esc_html_e('Variation Images', 'ams-wc-amazon'); ?></strong></label>
        
        <!-- Image Gallery Display -->
        <div class="ams-variation-gallery" style="margin-top: 8px;">
            <div class="ams-gallery-images" style="display: flex; flex-wrap: wrap; gap: 8px; margin-bottom: 10px;">
                
                <?php if (!empty($remote_urls)): ?>
                    <?php foreach ($remote_urls as $index => $url): ?>
                        <div class="ams-image-item" data-type="remote" data-index="<?php echo $index; ?>" style="position: relative; width: 80px; height: 80px; border: 1px solid #ddd; border-radius: 4px; overflow: hidden; background: white;">
                            <img src="<?php echo esc_url($url); ?>" style="width: 100%; height: 100%; object-fit: cover;" alt="Remote Image" />
                            <div class="ams-image-info" style="position: absolute; bottom: 0; left: 0; right: 0; background: rgba(0,0,0,0.8); color: white; font-size: 10px; padding: 2px 4px; overflow: hidden; text-overflow: ellipsis; white-space: nowrap;">
                                Amazon: <?php echo esc_html(parse_url($url, PHP_URL_HOST)); ?>
                            </div>
                        </div>
                    <?php endforeach; ?>
                <?php endif; ?>
                
                <?php if (!empty($attachment_ids)): ?>
                    <?php foreach ($attachment_ids as $index => $attachment_id): ?>
                        <?php $image_url = wp_get_attachment_url($attachment_id); ?>
                        <?php if ($image_url): ?>
                            <div class="ams-image-item" data-type="attachment" data-id="<?php echo $attachment_id; ?>" style="position: relative; width: 80px; height: 80px; border: 1px solid #ddd; border-radius: 4px; overflow: hidden; background: white;">
                                <img src="<?php echo esc_url($image_url); ?>" style="width: 100%; height: 100%; object-fit: cover;" alt="Local Image" />
                                <div class="ams-image-info" style="position: absolute; bottom: 0; left: 0; right: 0; background: rgba(0,0,0,0.8); color: white; font-size: 10px; padding: 2px 4px;">
                                    Local: <?php echo esc_html(basename($image_url)); ?>
                                </div>
                            </div>
                        <?php endif; ?>
                    <?php endforeach; ?>
                <?php endif; ?>
                
            </div>
        </div>
    </div>
    
    <?php
}

/**
 * Enqueue admin scripts for variation image management
 */
function ams_enqueue_variation_admin_scripts($hook) {
    global $post_type;
    
    if ($hook === 'post.php' && $post_type === 'product') {
        wp_enqueue_script('jquery');
    }
}




// Add a filter to handle both attachment IDs and URLs when displaying images
function handle_url_based_attachment_images($image, $attachment_id, $size, $icon) {
    // If $image is false but we have a URL
    if (!$image && filter_var($attachment_id, FILTER_VALIDATE_URL)) {
        // If it's a URL, return it as an image source
        return array($attachment_id, 800, 800, false); // Assuming a default size of 800x800
    }
    
    // If $image is false and not a URL, return an empty array instead of false
    if ($image === false) {
        return array('', 0, 0, false);
    }
    
    return $image;
}
//Code for variants gallery custom theme



/////START/////
// Tracking Brands
function ams_track_brand_click() {
    if (!isset($_POST['brand_slug']) || !wp_verify_nonce($_POST['nonce'], 'ams_brand_click')) {
        wp_die();
    }
    
    $brand = get_term_by('slug', sanitize_text_field($_POST['brand_slug']), 'product_brand');
    $location = sanitize_text_field($_POST['location']);
    
    // Define valid locations
    $valid_locations = array('product', 'category', 'shop', 'brand_page', 'homepage', 'search', 'archive', 'unknown');
    
    if ($brand) {
        // Get IP address with proper handling for various server configurations
        $ip = '';
        $ip_headers = array(
            'HTTP_CLIENT_IP',
            'HTTP_X_FORWARDED_FOR',
            'HTTP_X_FORWARDED',
            'HTTP_X_CLUSTER_CLIENT_IP',
            'HTTP_FORWARDED_FOR',
            'HTTP_FORWARDED',
            'REMOTE_ADDR'
        );
        
        foreach ($ip_headers as $header) {
            if (!empty($_SERVER[$header])) {
                $ip = $_SERVER[$header];
                if (strpos($ip, ',') !== false) {
                    // If there are multiple IPs, take the first one
                    $ips = explode(',', $ip);
                    $ip = trim($ips[0]);
                }
                break;
            }
        }
        
        // Get click history for IP throttling
        $ip_clicks = get_option('ams_ip_click_history', array());
        
        // Clean up old IP records (older than 24 hours)
        $current_time = current_time('timestamp');
        foreach ($ip_clicks as $stored_ip => $click_data) {
            if (($current_time - $click_data['last_click']) > (24 * 60 * 60)) {
                unset($ip_clicks[$stored_ip]);
            }
        }
        
        // Check if this IP has clicked this brand recently (within 6 hours)
        $throttle_period = 6 * 60 * 60; // 6 hours in seconds
        if (isset($ip_clicks[$ip]['brands'][$brand->term_id])) {
            $last_click_time = $ip_clicks[$ip]['brands'][$brand->term_id];
            if (($current_time - $last_click_time) < $throttle_period) {
                wp_die(json_encode(array('status' => 'throttled')));
            }
        }
        
        // Collect enhanced analytics data
        $user_agent = isset($_SERVER['HTTP_USER_AGENT']) ? sanitize_text_field($_SERVER['HTTP_USER_AGENT']) : '';
        $referer = isset($_SERVER['HTTP_REFERER']) ? esc_url_raw($_SERVER['HTTP_REFERER']) : '';
        $device_type = ams_detect_device_type($user_agent);
        $browser = ams_detect_browser($user_agent);
        $country = ams_get_country_from_ip($ip);
        
        // Track session data
        $session_id = isset($_POST['session_id']) ? sanitize_text_field($_POST['session_id']) : session_id();
        $time_on_page = isset($_POST['time_on_page']) ? intval($_POST['time_on_page']) : 0;
        
        // Update IP click history
        if (!isset($ip_clicks[$ip])) {
            $ip_clicks[$ip] = array(
                'last_click' => $current_time,
                'brands' => array()
            );
        }
        $ip_clicks[$ip]['brands'][$brand->term_id] = $current_time;
        $ip_clicks[$ip]['last_click'] = $current_time;
        
        update_option('ams_ip_click_history', $ip_clicks);
        
        // Handle localhost IP
        if ($ip === '::1' || $ip === 'localhost' || $ip === '127.0.0.1') {
            $country_code = 'LOCAL';
            $country_name = 'Local Development';
        } else {
            // Get country info with proper error handling
            $country_info = wp_remote_get('http://ip-api.com/json/' . $ip, array(
                'timeout' => 5,
                'sslverify' => false
            ));
            
            $country_code = '';
            $country_name = '';
            
            if (!is_wp_error($country_info) && wp_remote_retrieve_response_code($country_info) === 200) {
                $info = json_decode(wp_remote_retrieve_body($country_info));
                if ($info && isset($info->status) && $info->status === 'success') {
                    $country_code = $info->countryCode;
                    $country_name = $info->country;
                }
            }
        }
        
        // Update enhanced click statistics
        $clicks = get_option('ams_brand_clicks', array());
        
        // Initialize array structure if it doesn't exist
        if (!isset($clicks[$brand->term_id]) || !is_array($clicks[$brand->term_id])) {
            $clicks[$brand->term_id] = array(
                'total' => 0,
                'product' => 0,
                'category' => 0,
                'shop' => 0,
                'brand_page' => 0,
                'homepage' => 0,
                'search' => 0,
                'archive' => 0,
                'devices' => array('desktop' => 0, 'mobile' => 0, 'tablet' => 0),
                'browsers' => array(),
                'countries' => array(),
                'hourly_stats' => array(),
                'daily_stats' => array(),
                'monthly_stats' => array(),
                'avg_time_on_page' => 0,
                'bounce_rate' => 0,
                'conversion_rate' => 0,
                'unknown' => 0,
                'clicks_data' => array()
            );
        }
        
        // Store enhanced click data
        $current_date = current_time('Y-m-d');
        $current_hour = current_time('H');
        $current_month = current_time('Y-m');
        
        $clicks[$brand->term_id]['clicks_data'][] = array(
            'time' => current_time('mysql'),
            'ip' => $ip,
            'country_code' => $country_code,
            'country_name' => $country_name,
            'location' => $location,
            'device_type' => $device_type,
            'browser' => $browser,
            'referer' => $referer,
            'session_id' => $session_id,
            'time_on_page' => $time_on_page
        );
        
        // Keep only last 100 clicks
        if (count($clicks[$brand->term_id]['clicks_data']) > 100) {
            array_shift($clicks[$brand->term_id]['clicks_data']);
        }
        
        // Increment counters
        $clicks[$brand->term_id]['total']++;
        
        // Only increment location counter if it's a valid location
        if (in_array($location, $valid_locations)) {
            $clicks[$brand->term_id][$location]++;
        }
        
        // Update device statistics
        if (isset($clicks[$brand->term_id]['devices'][$device_type])) {
            $clicks[$brand->term_id]['devices'][$device_type]++;
        }
        
        // Update browser statistics
        if (!isset($clicks[$brand->term_id]['browsers'][$browser])) {
            $clicks[$brand->term_id]['browsers'][$browser] = 0;
        }
        $clicks[$brand->term_id]['browsers'][$browser]++;
        
        // Update country statistics
        if (!empty($country_name)) {
            if (!isset($clicks[$brand->term_id]['countries'][$country_name])) {
                $clicks[$brand->term_id]['countries'][$country_name] = 0;
            }
            $clicks[$brand->term_id]['countries'][$country_name]++;
        }
        
        // Update hourly statistics
        if (!isset($clicks[$brand->term_id]['hourly_stats'][$current_hour])) {
            $clicks[$brand->term_id]['hourly_stats'][$current_hour] = 0;
        }
        $clicks[$brand->term_id]['hourly_stats'][$current_hour]++;
        
        // Update daily statistics
        if (!isset($clicks[$brand->term_id]['daily_stats'][$current_date])) {
            $clicks[$brand->term_id]['daily_stats'][$current_date] = 0;
        }
        $clicks[$brand->term_id]['daily_stats'][$current_date]++;
        
        // Update monthly statistics
        if (!isset($clicks[$brand->term_id]['monthly_stats'][$current_month])) {
            $clicks[$brand->term_id]['monthly_stats'][$current_month] = 0;
        }
        $clicks[$brand->term_id]['monthly_stats'][$current_month]++;
        
        // Update average time on page
        if ($time_on_page > 0) {
            $total_time = $clicks[$brand->term_id]['avg_time_on_page'] * ($clicks[$brand->term_id]['total'] - 1);
            $clicks[$brand->term_id]['avg_time_on_page'] = ($total_time + $time_on_page) / $clicks[$brand->term_id]['total'];
        }
        
        update_option('ams_brand_clicks', $clicks);
        wp_die(json_encode(array('status' => 'success')));
    }
    
    wp_die();
}

// AJAX handler for resetting selected brand statistics
function ams_reset_selected_brand_stats() {
    if (!wp_verify_nonce($_POST['nonce'], 'reset_brand_stats') || !current_user_can('manage_options')) {
        wp_send_json_error(__('Permission denied.', 'ams-wc-amazon'));
    }
    
    $brand_ids = isset($_POST['brand_ids']) ? explode(',', sanitize_text_field($_POST['brand_ids'])) : array();
    
    if (empty($brand_ids)) {
        wp_send_json_error(__('No brands selected.', 'ams-wc-amazon'));
    }
    
    $clicks = get_option('ams_brand_clicks', array());
    $reset_count = 0;
    
    foreach ($brand_ids as $brand_id) {
        $brand_id = intval($brand_id);
        if (isset($clicks[$brand_id])) {
            unset($clicks[$brand_id]);
            $reset_count++;
        }
    }
    
    update_option('ams_brand_clicks', $clicks);
    
    wp_send_json_success(array(
        'message' => sprintf(__('Reset statistics for %d brands.', 'ams-wc-amazon'), $reset_count),
        'reset_count' => $reset_count
    ));
}

// AJAX handler for resetting single brand statistics
function ams_reset_single_brand_stats() {
    if (!wp_verify_nonce($_POST['nonce'], 'reset_brand_stats') || !current_user_can('manage_options')) {
        wp_send_json_error(__('Permission denied.', 'ams-wc-amazon'));
    }
    
    $brand_id = isset($_POST['brand_id']) ? intval($_POST['brand_id']) : 0;
    
    if (!$brand_id) {
        wp_send_json_error(__('Invalid brand ID.', 'ams-wc-amazon'));
    }
    
    $clicks = get_option('ams_brand_clicks', array());
    
    if (isset($clicks[$brand_id])) {
        unset($clicks[$brand_id]);
        update_option('ams_brand_clicks', $clicks);
        
        $brand = get_term($brand_id, 'product_brand');
        $brand_name = $brand && !is_wp_error($brand) ? $brand->name : 'Brand';
        
        wp_send_json_success(array(
            'message' => sprintf(__('Reset statistics for %s.', 'ams-wc-amazon'), $brand_name)
        ));
    } else {
        wp_send_json_error(__('Brand statistics not found.', 'ams-wc-amazon'));
    }
}

// AJAX handler for brand bulk operations
function ams_brand_bulk_operations() {
    if (!wp_verify_nonce($_POST['nonce'], 'brand_bulk_operations') || !current_user_can('manage_options')) {
        wp_send_json_error(__('Permission denied.', 'ams-wc-amazon'));
    }
    
    $operation = sanitize_text_field($_POST['operation']);
    $brand_ids = isset($_POST['brand_ids']) ? array_map('intval', explode(',', $_POST['brand_ids'])) : array();
    
    if (empty($brand_ids)) {
        wp_send_json_error(__('No brands selected.', 'ams-wc-amazon'));
    }
    
    switch ($operation) {
        case 'export_csv':
            $csv_data = ams_export_brand_stats_csv($brand_ids);
            wp_send_json_success(array(
                'csv_data' => $csv_data,
                'filename' => 'brand-statistics-' . date('Y-m-d') . '.csv'
            ));
            break;
            
        case 'bulk_edit':
            // Placeholder for bulk edit functionality
            wp_send_json_success(array(
                'message' => __('Bulk edit functionality coming soon.', 'ams-wc-amazon')
            ));
            break;
            
        default:
            wp_send_json_error(__('Invalid operation.', 'ams-wc-amazon'));
    }
}

// Helper function to export brand statistics to CSV
function ams_export_brand_stats_csv($brand_ids) {
    $clicks = get_option('ams_brand_clicks', array());
    $csv_data = array();
    
    // CSV header
    $csv_data[] = array(
        'Brand Name',
        'Brand ID',
        'Total Clicks',
        'Shop Page',
        'Category Page',
        'Product Page',
        'Brand Page',
        'Products',
        'Last Click Time',
        'Last Click IP',
        'Last Click Country',
        'Mobile Percentage',
        'Avg Time on Page'
    );
    
    foreach ($brand_ids as $brand_id) {
        $brand = get_term($brand_id, 'product_brand');
        if (!$brand || is_wp_error($brand)) continue;
        
        $data = isset($clicks[$brand_id]) ? $clicks[$brand_id] : array();
        $total = isset($data['total']) ? $data['total'] : 0;
        $shop = isset($data['shop']) ? $data['shop'] : 0;
        $category = isset($data['category']) ? $data['category'] : 0;
        $product = isset($data['product']) ? $data['product'] : 0;
        $brand_page = isset($data['brand_page']) ? $data['brand_page'] : 0;
        
        // Calculate mobile percentage
        $mobile_clicks = isset($data['devices']['mobile']) ? $data['devices']['mobile'] : 0;
        $mobile_percentage = $total > 0 ? round(($mobile_clicks / $total) * 100, 1) : 0;
        
        // Get last click info
        $last_click = isset($data['clicks_data']) && !empty($data['clicks_data']) ? end($data['clicks_data']) : null;
        $last_click_time = $last_click ? $last_click['time'] : '';
        $last_click_ip = $last_click ? $last_click['ip'] : '';
        $last_click_country = $last_click ? $last_click['country_name'] : '';
        
        // Average time on page
        $avg_time = isset($data['avg_time_on_page']) ? $data['avg_time_on_page'] : 0;
        
        $csv_data[] = array(
            $brand->name,
            $brand_id,
            $total,
            $shop,
            $category,
            $product,
            $brand_page,
            $brand->count,
            $last_click_time,
            $last_click_ip,
            $last_click_country,
            $mobile_percentage . '%',
            $avg_time . 's'
        );
    }
    
    return $csv_data;
}

// SEO Optimization Functions for Brands
function ams_add_brand_seo_meta() {
    if (!is_tax('product_brand')) return;
    
    $term = get_queried_object();
    if (!$term) return;
    
    // Get brand logo for schema
    $brand_logo_id = get_term_meta($term->term_id, 'brand_logo', true);
    $brand_logo_url = $brand_logo_id ? wp_get_attachment_url($brand_logo_id) : '';
    
    // Get products count
    $products_count = $term->count;
    
    // Generate schema markup
    $schema = array(
        '@context' => 'https://schema.org',
        '@type' => 'Brand',
        'name' => $term->name,
        'description' => $term->description ?: sprintf(__('Shop %s products', 'ams-wc-amazon'), $term->name),
        'url' => get_term_link($term),
    );
    
    if ($brand_logo_url) {
        $schema['logo'] = $brand_logo_url;
        $schema['image'] = $brand_logo_url;
    }
    
    // Add aggregated rating if available
    $brand_clicks = get_option('ams_brand_clicks', array());
    if (isset($brand_clicks[$term->term_id])) {
        $click_data = $brand_clicks[$term->term_id];
        $total_clicks = $click_data['total'];
        
        if ($total_clicks > 0) {
            $schema['aggregateRating'] = array(
                '@type' => 'AggregateRating',
                'ratingValue' => min(5, max(1, ($total_clicks / 100) + 3)), // Simple popularity-based rating
                'reviewCount' => $total_clicks,
                'bestRating' => 5,
                'worstRating' => 1
            );
        }
    }
    
    echo '<script type="application/ld+json">' . json_encode($schema, JSON_UNESCAPED_SLASHES) . '</script>' . "\n";
    
    // Add meta description
    $meta_description = $term->description ?: sprintf(__('Discover %s products. Shop from a wide selection of %s items with great deals and fast shipping.', 'ams-wc-amazon'), $term->name, $term->name);
    echo '<meta name="description" content="' . esc_attr(wp_trim_words($meta_description, 25)) . '">' . "\n";
    
    // Add Open Graph tags
    echo '<meta property="og:title" content="' . esc_attr($term->name . ' - ' . get_bloginfo('name')) . '">' . "\n";
    echo '<meta property="og:description" content="' . esc_attr(wp_trim_words($meta_description, 25)) . '">' . "\n";
    echo '<meta property="og:url" content="' . esc_url(get_term_link($term)) . '">' . "\n";
    echo '<meta property="og:type" content="website">' . "\n";
    
    if ($brand_logo_url) {
        echo '<meta property="og:image" content="' . esc_url($brand_logo_url) . '">' . "\n";
    }
    
    // Add Twitter Card tags
    echo '<meta name="twitter:card" content="summary">' . "\n";
    echo '<meta name="twitter:title" content="' . esc_attr($term->name . ' - ' . get_bloginfo('name')) . '">' . "\n";
    echo '<meta name="twitter:description" content="' . esc_attr(wp_trim_words($meta_description, 25)) . '">' . "\n";
    
    if ($brand_logo_url) {
        echo '<meta name="twitter:image" content="' . esc_url($brand_logo_url) . '">' . "\n";
    }
}

// Generate brand sitemap
function ams_generate_brand_sitemap() {
    if (!current_user_can('manage_options')) {
        wp_die(__('Permission denied.', 'ams-wc-amazon'));
    }
    
    $brands = get_terms(array(
        'taxonomy' => 'product_brand',
        'hide_empty' => false,
        'orderby' => 'name',
        'order' => 'ASC'
    ));
    
    if (empty($brands) || is_wp_error($brands)) {
        wp_die(__('No brands found.', 'ams-wc-amazon'));
    }
    
    header('Content-Type: application/xml; charset=utf-8');
    echo '<?xml version="1.0" encoding="UTF-8"?>' . "\n";
    echo '<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">' . "\n";
    
    foreach ($brands as $brand) {
        $brand_url = get_term_link($brand);
        if (is_wp_error($brand_url)) continue;
        
        // Get last modified date from brand clicks
        $brand_clicks = get_option('ams_brand_clicks', array());
        $last_click = null;
        if (isset($brand_clicks[$brand->term_id]['clicks_data']) && !empty($brand_clicks[$brand->term_id]['clicks_data'])) {
            $last_click = end($brand_clicks[$brand->term_id]['clicks_data']);
        }
        
        $lastmod = $last_click ? date('c', strtotime($last_click['time'])) : date('c');
        $priority = $brand->count > 10 ? '0.8' : ($brand->count > 0 ? '0.6' : '0.4');
        
        echo '  <url>' . "\n";
        echo '    <loc>' . esc_url($brand_url) . '</loc>' . "\n";
        echo '    <lastmod>' . $lastmod . '</lastmod>' . "\n";
        echo '    <changefreq>weekly</changefreq>' . "\n";
        echo '    <priority>' . $priority . '</priority>' . "\n";
        echo '  </url>' . "\n";
    }
    
    echo '</urlset>' . "\n";
    exit;
}

// Brand performance scoring
function ams_calculate_brand_performance_score($brand_id) {
    $brand = get_term($brand_id, 'product_brand');
    if (!$brand || is_wp_error($brand)) return 0;
    
    $clicks = get_option('ams_brand_clicks', array());
    $brand_data = isset($clicks[$brand_id]) ? $clicks[$brand_id] : array();
    
    $score = 0;
    $max_score = 100;
    
    // Product count score (30 points max)
    $product_count = $brand->count;
    $score += min(30, ($product_count / 10) * 30);
    
    // Click activity score (40 points max)
    $total_clicks = isset($brand_data['total']) ? $brand_data['total'] : 0;
    $score += min(40, ($total_clicks / 100) * 40);
    
    // Engagement score (20 points max)
    $avg_time = isset($brand_data['avg_time_on_page']) ? $brand_data['avg_time_on_page'] : 0;
    $score += min(20, ($avg_time / 30) * 20);
    
    // Mobile optimization score (10 points max)
    $mobile_clicks = isset($brand_data['devices']['mobile']) ? $brand_data['devices']['mobile'] : 0;
    $mobile_percentage = $total_clicks > 0 ? ($mobile_clicks / $total_clicks) * 100 : 0;
    $score += min(10, ($mobile_percentage / 50) * 10);
    
    return round($score, 1);
}

// Get brand performance insights
function ams_get_brand_performance_insights($brand_id) {
    $score = ams_calculate_brand_performance_score($brand_id);
    $insights = array();
    
    if ($score >= 80) {
        $insights[] = array(
            'type' => 'success',
            'message' => __('Excellent performance! This brand is highly engaging.', 'ams-wc-amazon')
        );
    } elseif ($score >= 60) {
        $insights[] = array(
            'type' => 'info',
            'message' => __('Good performance with room for improvement.', 'ams-wc-amazon')
        );
    } elseif ($score >= 40) {
        $insights[] = array(
            'type' => 'warning',
            'message' => __('Moderate performance. Consider optimization strategies.', 'ams-wc-amazon')
        );
    } else {
        $insights[] = array(
            'type' => 'danger',
            'message' => __('Low performance. This brand needs attention.', 'ams-wc-amazon')
        );
    }
    
    return array(
        'score' => $score,
        'insights' => $insights
    );
}
// AJAX handler for brand performance data
function ams_get_brand_performance_data() {
    if (!wp_verify_nonce($_POST['nonce'], 'brand_performance') || !current_user_can('manage_options')) {
        wp_send_json_error(__('Permission denied.', 'ams-wc-amazon'));
    }
    
    $brand_id = isset($_POST['brand_id']) ? intval($_POST['brand_id']) : 0;
    
    if (!$brand_id) {
        wp_send_json_error(__('Invalid brand ID.', 'ams-wc-amazon'));
    }
    
    $performance_data = ams_get_brand_performance_insights($brand_id);
    $brand = get_term($brand_id, 'product_brand');
    
    if (!$brand || is_wp_error($brand)) {
        wp_send_json_error(__('Brand not found.', 'ams-wc-amazon'));
    }
    
    wp_send_json_success(array(
        'brand_name' => $brand->name,
        'performance' => $performance_data,
        'seo_score' => ams_calculate_brand_seo_score($brand_id)
    ));
}

// Calculate brand SEO score
function ams_calculate_brand_seo_score($brand_id) {
    $brand = get_term($brand_id, 'product_brand');
    if (!$brand || is_wp_error($brand)) return 0;
    
    $score = 0;
    
    // Has description (25 points)
    if (!empty($brand->description)) {
        $score += 25;
    }
    
    // Has logo (25 points)
    $brand_logo_id = get_term_meta($brand_id, 'brand_logo', true);
    if ($brand_logo_id) {
        $score += 25;
    }
    
    // Has products (25 points)
    if ($brand->count > 0) {
        $score += 25;
    }
    
    // URL structure (25 points)
    $term_link = get_term_link($brand);
    if (!is_wp_error($term_link) && strpos($term_link, $brand->slug) !== false) {
        $score += 25;
    }
    
    return $score;
}

// Helper functions for enhanced analytics
function ams_detect_device_type($user_agent) {
    $mobile_agents = array('Mobile', 'Android', 'iPhone', 'iPad', 'BlackBerry', 'Windows Phone');
    $tablet_agents = array('iPad', 'Android.*Tablet', 'Kindle', 'Silk', 'PlayBook');
    
    foreach ($tablet_agents as $agent) {
        if (preg_match('/' . $agent . '/i', $user_agent)) {
            return 'tablet';
        }
    }
    
    foreach ($mobile_agents as $agent) {
        if (preg_match('/' . $agent . '/i', $user_agent)) {
            return 'mobile';
        }
    }
    
    return 'desktop';
}

function ams_detect_browser($user_agent) {
    $browsers = array(
        'Chrome' => 'Chrome',
        'Firefox' => 'Firefox',
        'Safari' => 'Safari',
        'Edge' => 'Edge',
        'Opera' => 'Opera',
        'Internet Explorer' => 'MSIE|Trident'
    );
    
    foreach ($browsers as $browser => $pattern) {
        if (preg_match('/' . $pattern . '/i', $user_agent)) {
            return $browser;
        }
    }
    
    return 'Other';
}

function ams_get_country_from_ip($ip) {
    // Handle localhost
    if ($ip === '::1' || $ip === 'localhost' || $ip === '127.0.0.1') {
        return array('code' => 'LOCAL', 'name' => 'Local Development');
    }
    
    // Get country info with proper error handling
    $country_info = wp_remote_get('http://ip-api.com/json/' . $ip, array(
        'timeout' => 5,
        'sslverify' => false
    ));
    
    if (!is_wp_error($country_info) && wp_remote_retrieve_response_code($country_info) === 200) {
        $info = json_decode(wp_remote_retrieve_body($country_info));
        if ($info && isset($info->status) && $info->status === 'success') {
            return array(
                'code' => $info->countryCode,
                'name' => $info->country
            );
        }
    }
    
    return array('code' => '', 'name' => '');
}
// Tracking Brands

// Add tracking script
function ams_add_brand_tracking() {
    ?>
    <script>
    jQuery(document).ready(function($) {
        $('.ams-brand-container a, .product-brand').on('click', function(e) {
            var $link = $(this);
            var href = $link.attr('href');
            var matches = href.match(/brand\/([^\/]+)/);
            
            if (matches && matches[1]) {
                // Don't prevent default navigation
                var location = 'unknown';
                var body = $('body');
                
                // More specific location checks
                if (body.hasClass('tax-product_cat')) {
                    location = 'category';
                } else if (body.hasClass('post-type-archive-product') || body.hasClass('woocommerce-shop')) {
                    location = 'shop';
                } else if (body.hasClass('single-product')) {
                    location = 'product';
                } else if (body.hasClass('tax-product_brand')) {
                    location = 'brand_page';
                } else if (body.hasClass('home') || body.hasClass('page-template-default')) {
                    location = 'homepage';
                } else if (body.hasClass('search')) {
                    location = 'search';
                } else if (body.hasClass('archive')) {
                    location = 'archive';
                }

                // Collect enhanced tracking data
                var pageLoadTime = window.amsPageLoadTime || Date.now();
                var timeOnPage = Math.round((Date.now() - pageLoadTime) / 1000);
                var sessionId = window.amsSessionId || 'session_' + Date.now() + '_' + Math.random().toString(36).substr(2, 9);
                
                // Store session ID for future use
                if (!window.amsSessionId) {
                    window.amsSessionId = sessionId;
                }

                // Use navigator.sendBeacon for tracking without delaying navigation
                var data = new FormData();
                data.append('action', 'ams_track_brand_click');
                data.append('brand_slug', matches[1]);
                data.append('location', location);
                data.append('session_id', sessionId);
                data.append('time_on_page', timeOnPage);
                data.append('nonce', '<?php echo wp_create_nonce('ams_brand_click'); ?>');

                // Use sendBeacon for modern browsers (no delay)
                if (navigator.sendBeacon) {
                    navigator.sendBeacon('<?php echo admin_url('admin-ajax.php'); ?>', data);
                } else {
                    // Fallback to async AJAX for older browsers
                    $.ajax({
                        url: '<?php echo admin_url('admin-ajax.php'); ?>',
                        type: 'POST',
                        data: {
                            action: 'ams_track_brand_click',
                            brand_slug: matches[1],
                            location: location,
                            session_id: sessionId,
                            time_on_page: timeOnPage,
                            nonce: '<?php echo wp_create_nonce('ams_brand_click'); ?>'
                        },
                        async: true
                    });
                }
            }
        });
        
        // Track page load time for analytics
        window.amsPageLoadTime = Date.now();
        
        // Enhanced brand click tracking function for new shortcode
        window.amsTrackBrandClick = function(brandId, location) {
            var pageLoadTime = window.amsPageLoadTime || Date.now();
            var timeOnPage = Math.round((Date.now() - pageLoadTime) / 1000);
            var sessionId = window.amsSessionId || 'session_' + Date.now() + '_' + Math.random().toString(36).substr(2, 9);
            
            if (!window.amsSessionId) {
                window.amsSessionId = sessionId;
            }
            
            var data = new FormData();
            data.append('action', 'ams_track_brand_click');
            data.append('brand_id', brandId);
            data.append('location', location || 'brand_page');
            data.append('session_id', sessionId);
            data.append('time_on_page', timeOnPage);
            data.append('nonce', '<?php echo wp_create_nonce('ams_brand_click'); ?>');
            
            if (navigator.sendBeacon) {
                navigator.sendBeacon('<?php echo admin_url('admin-ajax.php'); ?>', data);
            } else {
                $.ajax({
                    url: '<?php echo admin_url('admin-ajax.php'); ?>',
                    type: 'POST',
                    data: {
                        action: 'ams_track_brand_click',
                        brand_id: brandId,
                        location: location || 'brand_page',
                        session_id: sessionId,
                        time_on_page: timeOnPage,
                        nonce: '<?php echo wp_create_nonce('ams_brand_click'); ?>'
                    },
                    async: true
                });
            }
        };
    });
    </script>
    <?php
}

// Register product brand taxonomy
function ams_register_product_brand_taxonomy() {
    if (get_option('ams_brand_module_enabled', '1') !== '1') {
        return;
    }

    $labels = array(
        'name'              => _x('Brands', 'taxonomy general name'),
        'singular_name'     => _x('Brand', 'taxonomy singular name'),
        'search_items'      => __('Search Brands'),
        'all_items'         => __('All Brands'),
        'parent_item'       => __('Parent Brand'),
        'parent_item_colon' => __('Parent Brand:'),
        'edit_item'         => __('Edit Brand'),
        'update_item'       => __('Update Brand'),
        'add_new_item'      => __('Add New Brand'),
        'new_item_name'     => __('New Brand Name'),
        'menu_name'         => __('Brands'),
        'view_item'         => __('View Brand'),
        'back_to_items'     => __('Go to Brands')
    );

    $args = array(
        'hierarchical'      => true,
        'labels'            => $labels,
        'show_ui'           => true,
        'show_admin_column' => true,
        'query_var'         => true,
        'rewrite'           => array('slug' => 'brand'),
    );

    register_taxonomy('product_brand', array('product'), $args);
}

// Add brand logo field
function ams_add_brand_logo_field($term) {
    $brand_logo = '';
    $image_url = AMS_BRAND_NO_LOGO;
    $is_edit_form = is_object($term);

    if ($is_edit_form) {
        $brand_logo = get_term_meta($term->term_id, 'brand_logo', true);
        $image_url = $brand_logo ? wp_get_attachment_url($brand_logo) : AMS_BRAND_NO_LOGO;
    }

    if ($is_edit_form) {
        // Edit form layout
        ?>
        <tr class="form-field">
            <th scope="row" valign="top">
                <label for="brand_logo"><?php _e('Brand Logo'); ?></label>
            </th>
            <td>
        <?php
    } else {
        // Add form layout
        ?>
        <div class="form-field">
            <label for="brand_logo"><?php _e('Brand Logo'); ?></label>
        <?php
    }
    ?>
            <div class="brand-logo-wrapper">
                <img id="brand-logo-preview" src="<?php echo esc_url($image_url); ?>" 
                     style="max-width: 150px; <?php echo !$brand_logo ? 'opacity: 0.5;' : ''; ?>" />
            </div>
            <input type="hidden" name="brand_logo" id="brand_logo" value="<?php echo esc_attr($brand_logo); ?>">
            <button type="button" class="button" id="upload-brand-logo"><?php _e('Upload Logo'); ?></button>
            <button type="button" class="button" id="remove-brand-logo" 
                    style="<?php echo !$brand_logo ? 'display:none;' : ''; ?>"><?php _e('Remove Logo'); ?></button>
            <p class="description"><?php _e('Upload a logo for the brand or leave empty to use default.'); ?></p>
    <?php
    if ($is_edit_form) {
        echo '</td></tr>';
    } else {
        echo '</div>';
    }
    ?>
    <script>
    jQuery(document).ready(function($) {
        var mediaUploader;
        
        $('#upload-brand-logo').click(function(e) {
            e.preventDefault();
            
            if (mediaUploader) {
                mediaUploader.open();
                return;
            }
            
            mediaUploader = wp.media({
                title: 'Choose Brand Logo',
                button: {
                    text: 'Use this image'
                },
                multiple: false
            });
            
            mediaUploader.on('select', function() {
                var attachment = mediaUploader.state().get('selection').first().toJSON();
                $('#brand_logo').val(attachment.id);
                $('#brand-logo-preview').attr('src', attachment.url).show().css('opacity', '1');
                $('#remove-brand-logo').show();
            });
            
            mediaUploader.open();
        });
        
        $('#remove-brand-logo').click(function() {
            $('#brand_logo').val('');
            $('#brand-logo-preview').attr('src', '<?php echo AMS_BRAND_NO_LOGO; ?>').css('opacity', '0.5');
            $(this).hide();
        });
    });
    </script>
    <?php
}

// Save brand logo
function ams_save_brand_logo($term_id) {
    if (isset($_POST['brand_logo'])) {
        update_term_meta($term_id, 'brand_logo', absint($_POST['brand_logo']));
    }
}

// Register settings with options for logo, product count, and custom CSS
function ams_register_brand_settings() {
    register_setting('ams_brand_settings', 'ams_brand_module_enabled');
    register_setting('ams_brand_settings', 'brand_logo_width');
    register_setting('ams_brand_settings', 'brand_logo_height');
    register_setting('ams_brand_settings', 'brands_per_row');
    register_setting('ams_brand_settings', 'brands_per_page');
    register_setting('ams_brand_settings', 'show_brands_shop_page');
    register_setting('ams_brand_settings', 'show_brands_category_page');
    register_setting('ams_brand_settings', 'display_brand_logo', array('default' => '1'));
    register_setting('ams_brand_settings', 'display_product_count', array('default' => '1'));
    register_setting('ams_brand_settings', 'display_brand_on_product_page', array('default' => '1'));
    register_setting('ams_brand_settings', 'custom_brand_css');
    register_setting('ams_brand_settings', 'current_css_template');
}

// Show brand statistics with last click info
function ams_show_brand_statistics() {
    $brand_clicks = get_option('ams_brand_clicks', array());
    
    echo '<table class="form-table">';
    echo '<thead><tr><th>Brand</th><th>Total Clicks</th><th>Last Click Info</th></tr></thead>';
    echo '<tbody>';

    foreach ($brand_clicks as $brand_id => $data) {
        $brand = get_term($brand_id, 'product_brand');
        if ($brand && !is_wp_error($brand)) {
            $last_click = isset($data['clicks_data']) && !empty($data['clicks_data']) 
                ? end($data['clicks_data']) : null;

            // Format last click info with better display
            $last_click_info = 'No clicks yet';
            if ($last_click) {
                $location_display = $last_click['location'];
                if ($location_display === 'unknown') {
                    $location_display = 'Unknown Page';
                } else {
                    $location_display = ucfirst(str_replace('_', ' ', $location_display));
                }

                // Format display for local development
                $ip_display = $last_click['ip'];
                if ($last_click['country_code'] === 'LOCAL') {
                    $ip_display = '🖥️ Local Dev (' . $ip_display . ')';
                }

                $last_click_info = sprintf(
                    '%s - %s ago - from %s',
                    $ip_display,
                    human_time_diff(strtotime($last_click['time']), current_time('timestamp')),
                    $location_display
                );
            }

            echo '<tr>';
            echo '<td>' . esc_html($brand->name) . '</td>';
            echo '<td>' . intval($data['total']) . '</td>';
            echo '<td>' . $last_click_info . '</td>';
            echo '</tr>';
        }
    }
    
    echo '</tbody></table>';
}
// Settings page with tabs
function ams_brand_settings_page() {
    // Include the new Bootstrap 5 view file
    include_once AMS_PLUGIN_PATH . 'includes/Admin/views/brand-settings.php';
    return; // Exit early to prevent old HTML from rendering
    
    ?>
    <div class="wrap">
        <h1>Brand Settings</h1>
        <div id="ams-settings-tabs">
            <button class="tablinks active" onclick="openTab(event, 'moduleActivation')">Module Activation</button>
            <button class="tablinks" onclick="openTab(event, 'displayOptions')">Display Options</button>
            <button class="tablinks" onclick="openTab(event, 'customCSS')">Custom CSS</button>
            <button class="tablinks" onclick="openTab(event, 'statisticsTab')">Statistics</button>
        </div>

        <form method="post" action="options.php">
            <?php settings_fields('ams_brand_settings'); ?>

            <!-- Module Activation Tab -->
            <div id="moduleActivation" class="tabcontent" style="display:block;">
                <table class="form-table">
                    <tr>
                        <th>Enable Brands Module</th>
                        <td>
                            <label>
                                <input type="checkbox" name="ams_brand_module_enabled" value="1" 
                                       <?php checked(get_option('ams_brand_module_enabled', '1'), '1'); ?>>
                                Enable brands functionality
                            </label>
                        </td>
                    </tr>
                </table>

                <div class="ams-instructions" style="margin-top: 30px; background: #fff; padding: 20px; border: 1px solid #ccc; border-radius: 4px;">
                    <h3>How to Use Brands</h3>
                    
                    <div style="margin-bottom: 20px;">
                        <h4>1. Create a Brands Page</h4>
                        <p>Create a new page in WordPress for displaying all brands. Go to Pages → Add New:</p>
                        <ul style="list-style-type: disc; margin-left: 20px;">
                            <li>Give it a title (e.g., "Our Brands")</li>
                            <li>Add the following shortcode to the page content: <code style="background: #f5f5f5; padding: 3px 6px;">[brand_filter]</code></li>
                            <li>Publish the page</li>
                        </ul>
                    </div>

                    <div style="margin-bottom: 20px;">
                        <h4>2. Managing Brands</h4>
                        <p>Brands are automatically created when importing products from Amazon. However, you can manage brand details at Products → Brands:</p>
                        <ul style="list-style-type: disc; margin-left: 20px;">
                            <li>Edit brand names if needed</li>
                            <li>Upload or modify brand logos</li>
                            <li>View brand statistics and performance</li>
                        </ul>
                    </div>

                    <div style="margin-bottom: 20px;">
                        <h4>Available Shortcodes</h4>
                        <ul style="list-style-type: disc; margin-left: 20px;">
                            <li><code style="background: #f5f5f5; padding: 3px 6px;">[brand_filter]</code> - Displays a grid of all brands with logos and product counts</li>
                        </ul>
                    </div>

                    <div class="notice notice-info" style="margin: 20px 0;">
                        <p>💡 <strong>Tip:</strong> Use the Display Options tab to customize how brands are displayed on your site.</p>
                    </div>
                </div>
            </div>

            <!-- Display Options Tab -->
            <div id="displayOptions" class="tabcontent">
                <table class="form-table">
                    <tr>
                        <th>Logo Dimensions</th>
                        <td>
                            <label>Width: <input type="number" name="brand_logo_width" value="<?php echo esc_attr(get_option('brand_logo_width', '150')); ?>"> px</label>
                            <br>
                            <label>Height: <input type="number" name="brand_logo_height" value="<?php echo esc_attr(get_option('brand_logo_height', '150')); ?>"> px</label>
                            <br>
                            <label>
                                <input type="checkbox" name="display_brand_logo" value="1" <?php checked(get_option('display_brand_logo', '1'), '1'); ?>>
                                Display Brand Logo
                            </label>
                        </td>
                    </tr>
                    <tr>
                        <th>Brands per Row</th>
                        <td>
                            <select name="brands_per_row">
                                <?php
                                $selected = get_option('brands_per_row', '4');
                                for($i = 2; $i <= 6; $i++) {
                                    echo '<option value="' . $i . '" ' . selected($selected, $i, false) . '>' . $i . '</option>';
                                }
                                ?>
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <th>Brands per Page</th>
                        <td>
                            <input type="number" name="brands_per_page" value="<?php echo esc_attr(get_option('brands_per_page', '12')); ?>">
                        </td>
                    </tr>
                    <tr>
                        <th>Display Product Count</th>
                        <td>
                            <input type="checkbox" name="display_product_count" value="1" <?php checked(get_option('display_product_count', '1'), '1'); ?>>
                        </td>
                    </tr>
                    <tr>
                        <th>Show Brand on Product Page</th>
                        <td>
                            <input type="checkbox" name="display_brand_on_product_page" value="1" <?php checked(get_option('display_brand_on_product_page', '1'), '1'); ?>>
                        </td>
                    </tr>
                    <tr>
                        <th>Show Brands on Shop Page</th>
                        <td>
                            <input type="checkbox" name="show_brands_shop_page" value="1" <?php checked(get_option('show_brands_shop_page'), '1'); ?>>
                        </td>
                    </tr>
                    <tr>
                        <th>Show Brands on Category Pages</th>
                        <td>
                            <input type="checkbox" name="show_brands_category_page" value="1" <?php checked(get_option('show_brands_category_page'), '1'); ?>>
                        </td>
                    </tr>
                </table>
            </div>

            <!-- Custom CSS Tab -->


        <div id="customCSS" class="tabcontent">
                <table class="form-table">
                    <tr>
                        <th>Custom CSS</th>
                        <td>
                            <textarea id="customCSSField" name="custom_brand_css" rows="8" cols="50" class="large-text code"><?php echo esc_textarea(get_option('custom_brand_css')); ?></textarea>
                            
                            <p><strong>Available CSS Classes:</strong></p>
                            <ul style="margin-left: 20px; list-style-type: circle;">
                                <li><code>.ams-brand-container</code> - Wrapper for the entire brand section</li>
                                <li><code>.ams-brand-grid</code> - The grid layout container holding each brand item</li>
                                <li><code>.ams-brand-item</code> - Individual brand item container</li>
                                <li><code>.ams-brand-logo</code> - The brand logo image</li>
                                <li><code>.ams-brand-name</code> - The brand name text</li>
                                <li><code>.ams-brand-count</code> - Product count text below each brand</li>
                                <li><code>.ams-brand-pagination</code> - Container for pagination links</li>
                                <li><code>.product-brand-container</code> - Wrapper for brand on the single product page</li>
                                <li><code>.product-brand</code> - Brand name link on the single product page</li>
                                <li><code>.product-brand-label</code> - Label for brand name on single product page</li>
                            </ul>

                            <p><strong>Example Styles:</strong> Click "Copy" to apply any of the styles below:</p>

                            <div style="margin: 10px 0; padding: 10px; background: #f1f1f1; border: 1px solid #ddd; border-radius: 5px;">
                                <button type="button" onclick="insertCSS('style1')" class="button">Copy Example 1</button>
                                <pre id="style1" style="white-space: pre-wrap;">
            /* Example 1: Modern box shadow effect */
            .ams-brand-container { max-width: 1200px; margin: 0 auto; padding: 10px; }
            .ams-brand-grid { display: grid; grid-template-columns: repeat(4, 1fr); gap: 20px; }
            .ams-brand-item { padding: 20px; background: #fff; box-shadow: 0 4px 8px rgba(0,0,0,0.1); border-radius: 8px; }
            .ams-brand-logo { width: 100px; height: 100px; border-radius: 50%; object-fit: cover; }
            .ams-brand-name { font-weight: bold; color: #333; margin-top: 10px; }
            .ams-brand-count { font-size: 0.9em; color: #666; }
            .ams-brand-pagination { text-align: center; margin-top: 20px; }

            /* Product page brand styling */
            .product-brand-container { background-color: #f9f9f9; padding: 8px; border: 1px solid #ddd; border-radius: 4px; text-align: center; margin-top: 20px; }
            .product-brand { color: #0073aa; font-weight: bold; font-size: 1.2em; text-decoration: none; }
            .product-brand:hover { color: #005580; text-decoration: underline; }
            .product-brand-label { font-size: 1.1em; color: #333; margin-right: 5px; }
                                </pre>
                            </div>

                            <div style="margin: 10px 0; padding: 10px; background: #f1f1f1; border: 1px solid #ddd; border-radius: 5px;">
                                <button type="button" onclick="insertCSS('style2')" class="button">Copy Example 2</button>
                                <pre id="style2" style="white-space: pre-wrap;">
            /* Example 2: Minimalist border style */
            .ams-brand-container { max-width: 1200px; margin: 0 auto; padding: 10px; }
            .ams-brand-grid { display: grid; grid-template-columns: repeat(4, 1fr); gap: 20px; }
            .ams-brand-item { border: 1px solid #ddd; padding: 15px; background-color: #f9f9f9; border-radius: 5px; }
            .ams-brand-logo { width: 80px; height: 80px; object-fit: cover; }
            .ams-brand-name { font-size: 1.2em; color: #0073aa; margin-top: 10px; }
            .ams-brand-count { font-style: italic; color: #555; }
            .ams-brand-pagination { text-align: center; margin-top: 20px; }

            /* Product page brand styling */
            .product-brand-container { background-color: #f9f9f9; padding: 8px; border: 1px solid #ddd; border-radius: 4px; text-align: center; margin-top: 20px; }
            .product-brand { color: #0073aa; font-weight: bold; font-size: 1.2em; text-decoration: none; }
            .product-brand:hover { color: #005580; text-decoration: underline; }
            .product-brand-label { font-size: 1.1em; color: #333; margin-right: 5px; }
                                </pre>
                            </div>

                            <div style="margin: 10px 0; padding: 10px; background: #f1f1f1; border: 1px solid #ddd; border-radius: 5px;">
                                <button type="button" onclick="insertCSS('style3')" class="button">Copy Example 3</button>
                                <pre id="style3" style="white-space: pre-wrap;">
            /* Example 3: Dark theme with hover effect */
            .ams-brand-container { max-width: 1200px; background: #333; padding: 20px; border-radius: 10px; }
            .ams-brand-grid { display: grid; grid-template-columns: repeat(4, 1fr); gap: 20px; }
            .ams-brand-item { padding: 15px; background: #444; color: #ddd; border: 1px solid #555; transition: transform 0.3s; }
            .ams-brand-item:hover { transform: scale(1.05); }
            .ams-brand-logo { width: 90px; height: 90px; border-radius: 50%; object-fit: cover; }
            .ams-brand-name { color: #f0f0f0; font-size: 1.2em; margin-top: 10px; }
            .ams-brand-count { color: #aaa; }
            .ams-brand-pagination { text-align: center; color: #f1f1f1; margin-top: 20px; }

            /* Product page brand styling */
            .product-brand-container { background-color: #444; padding: 8px; border: 1px solid #555; border-radius: 4px; text-align: center; margin-top: 20px; }
            .product-brand { color: #eaeaea; font-weight: bold; font-size: 1.2em; text-decoration: none; }
            .product-brand:hover { color: #ddd; text-decoration: underline; }
            .product-brand-label { font-size: 1.1em; color: #ccc; margin-right: 5px; }
                                </pre>
                            </div>
                        </td>
                    </tr>
                </table>
        </div>

        <!-- Statistics Tab -->
        <div id="statisticsTab" class="tabcontent" style="width: 100%; max-width: 1200px; margin: 0 auto;">
            <h2>Brand Click Statistics</h2>
            
            <!-- Search and Reset Button Row -->
            <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 20px;">
                <!-- Search controls -->
                <div style="display: flex; align-items: center; width: 70%;">
                    <input type="text" name="brand_search" 
                           value="<?php echo esc_attr(isset($_GET['brand_search']) ? $_GET['brand_search'] : ''); ?>" 
                           placeholder="Search brands..." 
                           style="width: 100%; padding: 8px; border-radius: 4px; margin-right: 10px;">
                    <button type="button" class="button button-primary" onclick="window.location.href='?page=brand-settings&brand_search=' + encodeURIComponent(this.previousElementSibling.value)">Search</button>
                    <?php if (isset($_GET['brand_search'])): ?>
                        <a href="?page=brand-settings" class="button button-secondary" style="margin-left: 10px;">Clear</a>
                    <?php endif; ?>
                </div>

                <!-- Reset Button -->
                <button type="button" class="button button-secondary" 
                        onclick="if(confirm('Are you sure you want to reset all brand statistics? This cannot be undone!')) { 
                                    jQuery.post(ajaxurl, {
                                        action: 'ams_reset_stats',
                                        nonce: '<?php echo wp_create_nonce('reset_brand_stats'); ?>'
                                    }, function() {
                                        window.location.reload();
                                    });
                                }"
                        style="color: #dc3232;">Reset All Statistics
                </button>
            </div>

            <?php
            // Display reset success message
            if (isset($_GET['reset']) && $_GET['reset'] === 'success') {
                echo '<div class="notice notice-success is-dismissible"><p>Statistics reset successfully!</p></div>';
            }
            ?>

            <?php
            $brand_clicks = get_option('ams_brand_clicks', array());

            if (!empty($brand_clicks)) {
                $paged = isset($_GET['stat_page']) ? max(1, intval($_GET['stat_page'])) : 1;
                $search = isset($_GET['brand_search']) ? sanitize_text_field($_GET['brand_search']) : '';
                $per_page = 10;

                arsort($brand_clicks);

                // Filter brands by search
                if ($search) {
                    $filtered_clicks = array();
                    foreach ($brand_clicks as $brand_id => $data) {
                        $brand = get_term($brand_id, 'product_brand');
                        if ($brand && stripos($brand->name, $search) !== false) {
                            $filtered_clicks[$brand_id] = $data;
                        }
                    }
                    $brand_clicks = $filtered_clicks;
                }

                // Pagination calculations
                $total_items = count($brand_clicks);
                $total_pages = ceil($total_items / $per_page);
                $offset = ($paged - 1) * $per_page;

                // Slice array for current page
                $page_clicks = array_slice($brand_clicks, $offset, $per_page, true);

                echo '<table class="widefat fixed striped" style="width: 100%; margin-top: 20px;">';
                echo '<thead>
                        <tr style="background: #f3f3f3;">
                            <th style="width: 15%; text-align: left;">Brand Name</th>
                            <th style="width: 10%; text-align: center;">Total Clicks</th>
                            <th style="width: 10%; text-align: center;">Shop Page</th>
                            <th style="width: 10%; text-align: center;">Category Page</th>
                            <th style="width: 10%; text-align: center;">Product Page</th>
                            <th style="width: 10%; text-align: center;">Brand Page</th>
                            <th style="width: 10%; text-align: center;">Products</th>
                            <th style="width: 25%; text-align: left;">Last Click Info</th>
                        </tr>
                      </thead>';
                echo '<tbody>';

                foreach ($page_clicks as $brand_id => $data) {
                    $brand = get_term($brand_id, 'product_brand');
                    if ($brand && !is_wp_error($brand)) {
                        // Make sure all data keys exist with defaults
                        $total = isset($data['total']) ? $data['total'] : 0;
                        $shop = isset($data['shop']) ? $data['shop'] : 0;
                        $category = isset($data['category']) ? $data['category'] : 0;
                        $product = isset($data['product']) ? $data['product'] : 0;
                        $brand_page = isset($data['brand_page']) ? $data['brand_page'] : 0;

                        // Get last click data
                        $last_click = isset($data['clicks_data']) && !empty($data['clicks_data']) 
                            ? end($data['clicks_data']) : null;

                        // Format last click info
                        $last_click_info = 'No clicks yet';
                        if ($last_click) {
                            $ip_info = '';
                            if ($last_click['country_code'] === 'LOCAL') {
                                $ip_info = '🖥️ ' . $last_click['ip']; // Computer emoji for localhost
                            } else {
                                $flag_img = !empty($last_click['country_code']) 
                                    ? '<img src="https://flagcdn.com/16x12/' . strtolower($last_click['country_code']) . '.png" 
                                         style="margin-right:5px; vertical-align:middle;" 
                                         title="' . esc_attr($last_click['country_name']) . '" />' 
                                    : '';
                                $ip_info = $flag_img . $last_click['ip'];
                            }
                            
                            $last_click_info = sprintf(
                                '%s - %s ago - from %s',
                                $ip_info,
                                human_time_diff(strtotime($last_click['time']), current_time('timestamp')),
                                ucfirst($last_click['location'])
                            );
                        }

                        echo '<tr>';
                        echo '<td><a href="' . esc_url(get_term_link($brand)) . '" target="_blank">' 
                             . esc_html(str_replace('Visita la tienda de ', '', $brand->name)) . '</a></td>';
                        echo '<td style="text-align: center;">' . number_format($total) . '</td>';
                        echo '<td style="text-align: center;">' . number_format($shop) . '</td>';
                        echo '<td style="text-align: center;">' . number_format($category) . '</td>';
                        echo '<td style="text-align: center;">' . number_format($product) . '</td>';
                        echo '<td style="text-align: center;">' . number_format($brand_page) . '</td>';
                        echo '<td style="text-align: center;">' . number_format($brand->count) . '</td>';
                        echo '<td style="text-align: left;">' . $last_click_info . '</td>';
                        echo '</tr>';
                    }
                }
                echo '</tbody></table>';

                // Pagination
                if ($total_pages > 1) {
                    echo '<div class="tablenav"><div class="tablenav-pages" style="margin-top: 15px; text-align: center;">';
                    echo paginate_links(array(
                        'base' => add_query_arg('stat_page', '%#%'),
                        'format' => '',
                        'prev_text' => __('&laquo;'),
                        'next_text' => __('&raquo;'),
                        'total' => $total_pages,
                        'current' => $paged
                    ));
                    echo '</div></div>';
                }

                echo '<p style="margin-top: 15px; font-weight: bold; color: #333;">';
                echo 'Total Clicks Across All Brands: ' . number_format(array_sum(array_column($brand_clicks, 'total')));
                echo '</p>';
            } else {
                echo '<p style="margin-top: 15px; color: #666;">No brand statistics available yet.</p>';
            }
            ?>
        </div>

            <?php submit_button(); ?>

        <style>
            /* Tab button styling */
            #ams-settings-tabs {
                margin-bottom: 10px;
            }
            .tablinks {
                background-color: #f1f1f1;
                border: 1px solid #ccc;
                border-bottom: none;
                color: #0073aa;
                padding: 10px 15px;
                cursor: pointer;
                display: inline-block;
                margin-right: 5px;
            }
            .tablinks.active {
                background-color: #fff;
                border-bottom: 1px solid #fff;
                font-weight: bold;
            }
            /* Tab content area styling */
            .tabcontent {
                display: none;
                padding: 20px;
                border: 1px solid #ccc;
                background-color: #fff;
            }
        </style>

        <script>
            function openTab(event, tabName) {
                var i, tabcontent, tablinks;
                tabcontent = document.getElementsByClassName("tabcontent");
                for (i = 0; i < tabcontent.length; i++) {
                    tabcontent[i].style.display = "none";
                }
                tablinks = document.getElementsByClassName("tablinks");
                for (i = 0; i < tablinks.length; i++) {
                    tablinks[i].className = tablinks[i].className.replace(" active", "");
                }
                document.getElementById(tabName).style.display = "block";
                event.currentTarget.className += " active";
                localStorage.setItem('amsActiveTab', tabName);
            }
            jQuery(document).ready(function($) {
                var savedTab = localStorage.getItem('amsActiveTab');
                if (savedTab) {
                    document.querySelector('button[onclick*="' + savedTab + '"]').click();
                } else {
                    document.getElementsByClassName('tablinks')[0].click();
                }
            });
        </script>

        <script>
            // JavaScript function to insert CSS code into the custom CSS field
            function insertCSS(styleId) {
                var cssContent = document.getElementById(styleId).textContent;
                document.getElementById('customCSSField').value = cssContent;
                alert('CSS added to the custom CSS box. Please save your changes.');
            }
        </script>

        <script>
            function copyCSS(styleId) {
                var copyText = document.getElementById(styleId).textContent;
                navigator.clipboard.writeText(copyText).then(function() {
                    alert('CSS copied to clipboard');
                }, function(err) {
                    console.error('Error copying text: ', err);
                });
            }
        </script>
        </form>
    </div>
    <?php
}

// Reset Statistics
function ams_reset_stats_handler() {
    // Verify nonce for security
    check_ajax_referer('reset_brand_stats', 'nonce');

    // Delete both options
    delete_option('ams_brand_clicks');
    delete_option('ams_ip_click_history');

    // Verify deletion using direct SQL queries
    global $wpdb;

    // Check if any data remains in options table
    $remaining_data = $wpdb->get_results(
        $wpdb->prepare(
            "SELECT option_name, option_value 
            FROM {$wpdb->options} 
            WHERE option_name IN ('ams_brand_clicks', 'ams_ip_click_history')"
        )
    );

    // If there's still data, try to force delete it
    if (!empty($remaining_data)) {
        foreach ($remaining_data as $data) {
            $wpdb->delete(
                $wpdb->options,
                array('option_name' => $data->option_name),
                array('%s')
            );
        }
    }

    // Verify again after force delete
    $verification = $wpdb->get_results(
        $wpdb->prepare(
            "SELECT option_name, option_value 
            FROM {$wpdb->options} 
            WHERE option_name IN ('ams_brand_clicks', 'ams_ip_click_history')"
        )
    );

    // Send back detailed response
    wp_send_json_success(array(
        'message' => 'Reset attempted',
        'remaining_data' => empty($verification) ? 'All data cleared' : 'Some data remains',
        'details' => $verification
    ));
}

// Function to inject custom CSS into the header for both brand and product pages
function ams_inject_custom_css() {
    $custom_css = get_option('custom_brand_css');
    if (!empty($custom_css)) {
        echo '<style>' . wp_strip_all_tags($custom_css) . '</style>';
    }
}

// Add admin menu for brand settings
function ams_add_brand_admin_menu() {
    add_submenu_page(
        'wc-amazon-affiliate',           // Parent menu (your main plugin)
        'Brand Settings',                // Page title
        'Brand Settings',                // Menu title
        'manage_options',               // Capability
        'brand-settings',               // Menu slug
        'ams_brand_settings_page'       // Function
    );
}

// Display brand name on single product page if enabled
function ams_display_product_brand() {
    if (get_option('display_brand_on_product_page', '1') !== '1') {
        return;
    }

    global $product;
    if ($product) {
        $terms = get_the_terms($product->get_id(), 'product_brand');
        if ($terms && !is_wp_error($terms)) {
            $brand = array_shift($terms);
            echo '<div class="product-brand-container">';  // Container with a specific class
            echo '<span class="product-brand-label">' . esc_html__('Brand: ') . '</span>';
            echo '<a href="' . esc_url(get_term_link($brand)) . '" class="product-brand">' . esc_html($brand->name) . '</a>';
            echo '</div>';
        }
    }
}
// Enhanced Brand filter shortcode with search, A-Z navigation, and carousel layout
function ams_brand_filter_shortcode($atts) {
    if (get_option('ams_brand_module_enabled', '1') !== '1') {
        return '<div style="text-align: center; margin-top: 20px; font-size: 16px; color: #555; background-color: #f9f9f9; padding: 10px; border: 1px solid #ddd; border-radius: 5px;">
                    Brand module is disabled.
                </div>';
    }

    // Parse shortcode attributes
    $atts = shortcode_atts(array(
        'layout' => 'grid', // grid, carousel, list
        'show_search' => 'true',
        'show_az_nav' => 'true',
        'show_description' => 'false',
        'featured_only' => 'false',
        'autoplay' => 'false',
        'dots' => 'true',
        'arrows' => 'true'
    ), $atts);

    // Inject custom CSS if provided
    $custom_css = get_option('custom_brand_css');
    if (!empty($custom_css)) {
        echo '<style>' . wp_strip_all_tags($custom_css) . '</style>';
    }

    // Add enhanced CSS for search, navigation, carousel, and layouts
    echo '<style>
        .ams-brand-container {
            margin: 20px 0;
        }
        
        /* Search and Filter Section */
        .ams-brand-controls {
            margin-bottom: 30px;
            padding: 20px;
            background: #f8f9fa;
            border-radius: 8px;
            border: 1px solid #e9ecef;
        }
        
        .ams-brand-search {
            display: flex;
            gap: 15px;
            align-items: center;
            flex-wrap: wrap;
            margin-bottom: 20px;
        }
        
        .ams-search-input {
            flex: 1;
            min-width: 250px;
            padding: 12px 16px;
            border: 2px solid #dee2e6;
            border-radius: 6px;
            font-size: 16px;
            transition: border-color 0.3s;
        }
        
        .ams-search-input:focus {
            outline: none;
            border-color: #0073aa;
            box-shadow: 0 0 0 3px rgba(0, 115, 170, 0.1);
        }
        
        .ams-sort-select {
            padding: 12px 16px;
            border: 2px solid #dee2e6;
            border-radius: 6px;
            background: white;
            font-size: 16px;
            min-width: 150px;
        }
        
        /* A-Z Navigation */
        .ams-az-navigation {
            display: flex;
            flex-wrap: wrap;
            gap: 8px;
            justify-content: center;
        }
        
        .ams-az-letter {
            display: inline-block;
            padding: 8px 12px;
            background: #ffffff;
            border: 2px solid #dee2e6;
            border-radius: 6px;
            text-decoration: none;
            color: #495057;
            font-weight: 600;
            transition: all 0.3s;
            min-width: 40px;
            text-align: center;
        }
        
        .ams-az-letter:hover, .ams-az-letter.active {
            background: #0073aa;
            color: white;
            border-color: #0073aa;
            text-decoration: none;
        }
        
        .ams-az-letter.disabled {
            opacity: 0.4;
            cursor: not-allowed;
        }
        
        /* Carousel Layout */
        .ams-brand-carousel {
            position: relative;
            overflow: hidden;
            margin: 20px 0;
        }
        
        .ams-carousel-container {
            display: flex;
            transition: transform 0.5s ease;
        }
        
        .ams-carousel-slide {
            min-width: 100%;
            display: grid;
            gap: 20px;
        }
        
        .ams-carousel-arrow {
            position: absolute;
            top: 50%;
            transform: translateY(-50%);
            background: rgba(0, 115, 170, 0.9);
            color: white;
            border: none;
            padding: 15px;
            border-radius: 50%;
            cursor: pointer;
            font-size: 18px;
            z-index: 10;
            transition: background 0.3s;
        }
        
        .ams-carousel-arrow:hover {
            background: #0073aa;
        }
        
        .ams-carousel-prev {
            left: 15px;
        }
        
        .ams-carousel-next {
            right: 15px;
        }
        
        .ams-carousel-dots {
            display: flex;
            justify-content: center;
            gap: 10px;
            margin-top: 20px;
        }
        
        .ams-carousel-dot {
            width: 12px;
            height: 12px;
            border-radius: 50%;
            background: #dee2e6;
            cursor: pointer;
            transition: background 0.3s;
        }
        
        .ams-carousel-dot.active {
            background: #0073aa;
        }
        
        /* Grid Layout */
        .ams-brand-grid {
            display: grid;
            gap: 20px;
        }
        
        /* List Layout */
        .ams-brand-list {
            display: flex;
            flex-direction: column;
            gap: 15px;
        }
        
        .ams-brand-list .ams-brand-item {
            display: flex;
            align-items: center;
            padding: 15px;
            background: white;
            border: 1px solid #e9ecef;
            border-radius: 8px;
            transition: box-shadow 0.3s;
        }
        
        .ams-brand-list .ams-brand-item:hover {
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
        }
        
        .ams-brand-list .ams-brand-item img {
            margin-right: 20px !important;
            margin-bottom: 0 !important;
        }
        
        /* Brand Item Enhancements */
        .ams-brand-item {
            text-align: center;
            padding: 20px;
            background: white;
            border: 1px solid #e9ecef;
            border-radius: 8px;
            transition: all 0.3s;
            position: relative;
        }
        
        .ams-brand-item:hover {
            transform: translateY(-5px);
            box-shadow: 0 8px 25px rgba(0, 0, 0, 0.1);
        }
        
        .ams-brand-item a {
            text-decoration: none;
            color: inherit;
        }
        
        .ams-brand-name {
            font-weight: bold;
            margin: 10px 0 5px 0;
            font-size: 16px;
        }
        
        .ams-brand-count {
            color: #6c757d;
            font-size: 14px;
        }
        
        .ams-brand-description {
            color: #6c757d;
            font-size: 13px;
            margin-top: 8px;
            line-height: 1.4;
        }
        
        /* No Results */
        .ams-no-brands {
            text-align: center;
            padding: 40px 20px;
            color: #6c757d;
            font-size: 16px;
        }
        
        /* Loading State */
        .ams-brands-loading {
            text-align: center;
            padding: 40px;
            color: #6c757d;
        }
        
        .ams-loading-spinner {
            display: inline-block;
            width: 20px;
            height: 20px;
            border: 3px solid #f3f3f7;
            border-top: 3px solid #0073aa;
            border-radius: 50%;
            animation: spin 1s linear infinite;
            margin-right: 10px;
        }
        
        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
        
        /* Responsive Design */
        @media (max-width: 768px) {
            .ams-brand-search {
                flex-direction: column;
                align-items: stretch;
            }
            
            .ams-search-input, .ams-sort-select {
                min-width: auto;
            }
            
            .ams-az-navigation {
                gap: 4px;
            }
            
            .ams-az-letter {
                padding: 6px 8px;
                min-width: 32px;
                font-size: 14px;
            }
            
            .ams-carousel-arrow {
                padding: 10px;
                font-size: 16px;
            }
            
            .ams-brand-list .ams-brand-item {
                flex-direction: column;
                text-align: center;
            }
            
            .ams-brand-list .ams-brand-item img {
                margin-right: 0 !important;
                margin-bottom: 15px !important;
            }
        }
        
        /* Pagination */
        .woocommerce-pagination {
            margin-top: 30px;
            display: flex;
            justify-content: center;
            clear: both;
        }
        .woocommerce-pagination ul {
            display: flex;
            justify-content: center;
            list-style: none;
            padding: 0;
            margin: 0;
        }
        .woocommerce-pagination li {
            margin: 0 5px;
        }
        .woocommerce-pagination a, .woocommerce-pagination span {
            padding: 8px 12px;
            text-decoration: none;
            border: 1px solid #ddd;
            color: #333;
            border-radius: 3px;
            background-color: #f7f7f7;
            transition: background-color 0.3s;
        }
        .woocommerce-pagination a:hover {
            background-color: #e2e2e2;
        }
        .woocommerce-pagination .current {
            background-color: #0073aa;
            color: #fff;
            border-color: #0073aa;
        }
    </style>';

    // Get URL parameters for filtering
    $search_term = isset($_GET['brand_search']) ? sanitize_text_field($_GET['brand_search']) : '';
    $selected_letter = isset($_GET['brand_letter']) ? sanitize_text_field($_GET['brand_letter']) : '';
    $sort_by = isset($_GET['brand_sort']) ? sanitize_text_field($_GET['brand_sort']) : 'name';

    // Define the pagination setup for the brand filter only
    $brands_per_page = intval(get_option('brands_per_page', 12));
    $brands_per_row = intval(get_option('brands_per_row', 4));
    $logo_width = get_option('brand_logo_width', '150');
    $logo_height = get_option('brand_logo_height', '150');
    $display_logo = get_option('display_brand_logo', '1');
    $display_count = get_option('display_product_count', '1');
    $paged = isset($_GET['brand_page']) ? max(1, intval($_GET['brand_page'])) : 1;

    // Build query args
    $args = array(
        'taxonomy' => 'product_brand',
        'hide_empty' => false,
        'number' => $brands_per_page,
        'offset' => ($paged - 1) * $brands_per_page
    );
    
    // Add search filter
    if (!empty($search_term)) {
        $args['search'] = $search_term;
    }
    
    // Add letter filter
    if (!empty($selected_letter)) {
        $args['name__like'] = $selected_letter;
    }
    
    // Add sorting
    switch ($sort_by) {
        case 'count':
            $args['orderby'] = 'count';
            $args['order'] = 'DESC';
            break;
        case 'name_desc':
            $args['orderby'] = 'name';
            $args['order'] = 'DESC';
            break;
        default: // name
            $args['orderby'] = 'name';
            $args['order'] = 'ASC';
            break;
    }

    // Fetch brands with the defined arguments
    $terms = get_terms($args);
    
    // Debug: Check if we have any brands at all
    if (empty($terms) || is_wp_error($terms)) {
        // Let's check if the taxonomy exists and has any terms
        $all_brands = get_terms(array(
            'taxonomy' => 'product_brand',
            'hide_empty' => false,
            'fields' => 'count'
        ));
        
        if (empty($all_brands)) {
            return '<div class="ams-brand-container">
                        <p style="text-align: center; padding: 20px; color: #666;">
                            No brands found. Import some products to see brands here.
                        </p>
                    </div>';
        }
    }
    
    $total_terms = wp_count_terms('product_brand', array('hide_empty' => false));
    $total_pages = ceil($total_terms / $brands_per_page);

    // Get all brands for A-Z navigation
    $all_brands = get_terms(array(
        'taxonomy' => 'product_brand',
        'hide_empty' => false,
        'fields' => 'names'
    ));
    
    // Generate available letters
    $available_letters = array();
    if (!empty($all_brands)) {
        foreach ($all_brands as $brand_name) {
            $first_letter = strtoupper(substr($brand_name, 0, 1));
            if (ctype_alpha($first_letter)) {
                $available_letters[$first_letter] = true;
            }
        }
    }
    ksort($available_letters);

    // Output container
    $output = '<div class="ams-brand-container">';
    
    // Add search and filter controls
    if ($atts['show_search'] === 'true' || $atts['show_az_nav'] === 'true') {
        $output .= '<div class="ams-brand-controls">';
        
        // Search and sort section
        if ($atts['show_search'] === 'true') {
            $current_url = remove_query_arg(array('brand_search', 'brand_sort', 'brand_letter', 'brand_page'));
            
            $output .= '<div class="ams-brand-search">';
            $output .= '<input type="text" class="ams-search-input" placeholder="' . esc_attr__('Search brands...', 'ams-wc-amazon') . '" value="' . esc_attr($search_term) . '" id="ams-brand-search-input">';
            $output .= '<select class="ams-sort-select" id="ams-brand-sort-select">';
            $output .= '<option value="name"' . selected($sort_by, 'name', false) . '>' . esc_html__('Sort by Name (A-Z)', 'ams-wc-amazon') . '</option>';
            $output .= '<option value="name_desc"' . selected($sort_by, 'name_desc', false) . '>' . esc_html__('Sort by Name (Z-A)', 'ams-wc-amazon') . '</option>';
            $output .= '<option value="count"' . selected($sort_by, 'count', false) . '>' . esc_html__('Sort by Product Count', 'ams-wc-amazon') . '</option>';
            $output .= '</select>';
            $output .= '</div>';
        }
        
        // A-Z Navigation
        if ($atts['show_az_nav'] === 'true') {
            $output .= '<div class="ams-az-navigation">';
            $output .= '<a href="' . esc_url(remove_query_arg(array('brand_letter', 'brand_page'))) . '" class="ams-az-letter' . (empty($selected_letter) ? ' active' : '') . '">' . esc_html__('All', 'ams-wc-amazon') . '</a>';
            
            for ($i = ord('A'); $i <= ord('Z'); $i++) {
                $letter = chr($i);
                $is_available = isset($available_letters[$letter]);
                $is_active = $selected_letter === $letter;
                $letter_url = add_query_arg(array('brand_letter' => $letter, 'brand_page' => 1), remove_query_arg('brand_page'));
                
                $classes = 'ams-az-letter';
                if ($is_active) $classes .= ' active';
                if (!$is_available) $classes .= ' disabled';
                
                if ($is_available) {
                    $output .= '<a href="' . esc_url($letter_url) . '" class="' . $classes . '">' . $letter . '</a>';
                } else {
                    $output .= '<span class="' . $classes . '">' . $letter . '</span>';
                }
            }
            $output .= '</div>';
        }
        
        $output .= '</div>';
    }

    // Check and display terms if available
    if (!empty($terms) && !is_wp_error($terms)) {
        // Choose layout based on shortcode attribute
        $layout_class = 'ams-brand-grid';
        $layout_style = 'display: grid; grid-template-columns: repeat(' . $brands_per_row . ', 1fr); gap: 20px;';
        
        if ($atts['layout'] === 'carousel') {
            $layout_class = 'ams-brand-carousel';
            $layout_style = '';
        } elseif ($atts['layout'] === 'list') {
            $layout_class = 'ams-brand-list';
            $layout_style = '';
        }
        
        $output .= '<div class="' . $layout_class . '"' . (!empty($layout_style) ? ' style="' . $layout_style . '"' : '') . '>';
        
        // For carousel layout, we need to group brands into slides
        if ($atts['layout'] === 'carousel') {
            $brands_per_slide = $brands_per_row * 2; // 2 rows per slide
            $slides = array_chunk($terms, $brands_per_slide);
            $slide_count = count($slides);
            
            $output .= '<div class="ams-carousel-container" id="ams-carousel-container">';
            
            foreach ($slides as $slide_index => $slide_brands) {
                $output .= '<div class="ams-carousel-slide" style="grid-template-columns: repeat(' . $brands_per_row . ', 1fr);">';
                
                foreach ($slide_brands as $term) {
                    $output .= ams_render_brand_item($term, $display_logo, $display_count, $logo_width, $logo_height, $atts);
                }
                
                $output .= '</div>';
            }
            
            $output .= '</div>';
            
            // Add carousel controls
            if ($slide_count > 1) {
                if ($atts['arrows'] === 'true') {
                    $output .= '<button class="ams-carousel-arrow ams-carousel-prev" onclick="amsMoveCarousel(-1)">‹</button>';
                    $output .= '<button class="ams-carousel-arrow ams-carousel-next" onclick="amsMoveCarousel(1)">›</button>';
                }
                
                if ($atts['dots'] === 'true') {
                    $output .= '<div class="ams-carousel-dots">';
                    for ($i = 0; $i < $slide_count; $i++) {
                        $output .= '<div class="ams-carousel-dot' . ($i === 0 ? ' active' : '') . '" onclick="amsGoToSlide(' . $i . ')"></div>';
                    }
            $output .= '</div>';
                }
            }
        } else {
            // Regular grid or list layout
            foreach ($terms as $term) {
                $output .= ams_render_brand_item($term, $display_logo, $display_count, $logo_width, $logo_height, $atts);
            }
        }
        
        $output .= '</div>';

        // Custom Pagination
        if ($total_pages > 1 && $atts['layout'] !== 'carousel') {
            $output .= '<nav class="woocommerce-pagination" aria-label="Brand Pagination">';
            $output .= paginate_links(array(
                'base' => add_query_arg('brand_page', '%#%'),
                'format' => '',
                'current' => $paged,
                'total' => $total_pages,
                'prev_text' => __('<<', 'text-domain'),
                'next_text' => __('>>', 'text-domain'),
                'type' => 'list',
                'mid_size' => 2,
                'end_size' => 1,
                'add_args' => array(),
                'add_fragment' => ''
            ));
            $output .= '</nav>';
        }

    } else {
        $output .= '<div class="ams-no-brands">';
        $output .= '<p>' . esc_html__('No brands found.', 'ams-wc-amazon') . '</p>';
        if (!empty($search_term) || !empty($selected_letter)) {
            $output .= '<p><a href="' . esc_url(remove_query_arg(array('brand_search', 'brand_letter', 'brand_page'))) . '">' . esc_html__('Show all brands', 'ams-wc-amazon') . '</a></p>';
        }
        $output .= '</div>';
    }

    // Add JavaScript for interactive functionality
    $output .= '<script>
    document.addEventListener("DOMContentLoaded", function() {
        // Search functionality
        const searchInput = document.getElementById("ams-brand-search-input");
        const sortSelect = document.getElementById("ams-brand-sort-select");
        
        if (searchInput) {
            let searchTimeout;
            searchInput.addEventListener("input", function() {
                clearTimeout(searchTimeout);
                searchTimeout = setTimeout(function() {
                    const url = new URL(window.location);
                    if (searchInput.value.trim()) {
                        url.searchParams.set("brand_search", searchInput.value.trim());
                    } else {
                        url.searchParams.delete("brand_search");
                    }
                    url.searchParams.delete("brand_page");
                    window.location.href = url.toString();
                }, 500);
            });
        }
        
        if (sortSelect) {
            sortSelect.addEventListener("change", function() {
                const url = new URL(window.location);
                url.searchParams.set("brand_sort", this.value);
                url.searchParams.delete("brand_page");
                window.location.href = url.toString();
            });
        }
        
        // Carousel functionality
        let currentSlide = 0;
        const carousel = document.getElementById("ams-carousel-container");
        const dots = document.querySelectorAll(".ams-carousel-dot");
        
        if (carousel) {
            const slides = carousel.querySelectorAll(".ams-carousel-slide");
            const totalSlides = slides.length;
            
            window.amsMoveCarousel = function(direction) {
                currentSlide += direction;
                if (currentSlide >= totalSlides) currentSlide = 0;
                if (currentSlide < 0) currentSlide = totalSlides - 1;
                updateCarousel();
            };
            
            window.amsGoToSlide = function(slideIndex) {
                currentSlide = slideIndex;
                updateCarousel();
            };
            
            function updateCarousel() {
                const translateX = -currentSlide * 100;
                carousel.style.transform = `translateX(${translateX}%)`;
                
                // Update dots
                dots.forEach((dot, index) => {
                    dot.classList.toggle("active", index === currentSlide);
                });
            }
            
            // Auto-play functionality
            ' . ($atts['autoplay'] === 'true' ? '
            setInterval(function() {
                amsMoveCarousel(1);
            }, 5000);
            ' : '') . '
        }
    });
    </script>';

    $output .= '</div>';
    return $output;
}

// Helper function to render individual brand items
function ams_render_brand_item($term, $display_logo, $display_count, $logo_width, $logo_height, $atts) {
    $brand_logo_id = get_term_meta($term->term_id, 'brand_logo', true);
    $brand_logo_url = $brand_logo_id ? wp_get_attachment_url($brand_logo_id) : AMS_BRAND_NO_LOGO;
    
    // Get accurate product count for this brand
    $product_count = 0;
    if ($display_count) {
        $products = get_posts(array(
            'post_type' => 'product',
            'post_status' => 'publish',
            'numberposts' => -1,
            'fields' => 'ids',
            'tax_query' => array(
                array(
                    'taxonomy' => 'product_brand',
                    'field'    => 'term_id',
                    'terms'    => $term->term_id,
                ),
            ),
        ));
        $product_count = count($products);
    }
    
    $output = '<div class="ams-brand-item">';
    $output .= '<a href="' . esc_url(get_term_link($term)) . '" onclick="amsTrackBrandClick(' . $term->term_id . ', \'brand_page\')">';
    
    // Display logo if enabled
    if ($display_logo) {
        $output .= '<img src="' . esc_url($brand_logo_url) . '" alt="' . esc_attr($term->name) . '" style="width:' . esc_attr($logo_width) . 'px; height:' . esc_attr($logo_height) . 'px; object-fit: contain;" />';
    }
    
    // Brand name
    $output .= '<div class="ams-brand-name">' . esc_html($term->name) . '</div>';
    
    // Display product count if enabled
    if ($display_count) {
        $output .= '<div class="ams-brand-count">' . sprintf(esc_html__('%d Products', 'ams-wc-amazon'), $product_count) . '</div>';
    }
    
    // Display description if enabled
    if ($atts['show_description'] === 'true' && !empty($term->description)) {
        $output .= '<div class="ams-brand-description">' . esc_html(wp_trim_words($term->description, 15)) . '</div>';
    }
    
    $output .= '</a>';
    $output .= '</div>';
    
    return $output;
}

// Function to update brand term counts
function ams_update_brand_term_counts() {
    $terms = get_terms(array(
        'taxonomy' => 'product_brand',
        'hide_empty' => false,
    ));

    if (!empty($terms) && !is_wp_error($terms)) {
        foreach ($terms as $term) {
            $count = get_posts(array(
                'post_type' => 'product',
                'post_status' => 'publish',
                'numberposts' => -1,
                'fields' => 'ids',
                'tax_query' => array(
                    array(
                        'taxonomy' => 'product_brand',
                        'field'    => 'term_id',
                        'terms'    => $term->term_id,
                    ),
                ),
            ));
            
            // Update the term count in the database
            wp_update_term_count_now(array($term->term_id), 'product_brand');
        }
    }
}

// Hook to update term counts after product save
add_action('save_post_product', 'ams_update_brand_term_counts_on_save', 10, 1);
function ams_update_brand_term_counts_on_save($post_id) {
    // Only update if this is a product
    if (get_post_type($post_id) === 'product') {
        // Get the brand terms for this product
        $brand_terms = wp_get_object_terms($post_id, 'product_brand', array('fields' => 'ids'));
        if (!empty($brand_terms) && !is_wp_error($brand_terms)) {
            wp_update_term_count_now($brand_terms, 'product_brand');
        }
    }
}
// AJAX handler to refresh brand counts
add_action('wp_ajax_ams_refresh_brand_counts', 'ams_ajax_refresh_brand_counts');
// AJAX handler for creating brands page
add_action('wp_ajax_ams_create_brands_page', 'ams_ajax_create_brands_page');
function ams_ajax_create_brands_page() {
    // Verify nonce for security
    check_ajax_referer('create_brands_page', 'nonce');
    
    // Check user capabilities
    if (!current_user_can('manage_options')) {
        wp_send_json_error(__('You do not have permission to create pages.', 'ams-wc-amazon'));
        return;
    }
    
    $page_title = sanitize_text_field($_POST['page_title'] ?? __('Our Brands', 'ams-wc-amazon'));
    $page_slug = sanitize_title($_POST['page_slug'] ?? 'brands');
    $add_to_menu = isset($_POST['add_to_menu']) && $_POST['add_to_menu'] === '1';
    $target_menu = sanitize_text_field($_POST['target_menu'] ?? 'auto');
    $recreate = isset($_POST['recreate']) && $_POST['recreate'] === '1';
    
    // Check if page already exists
    $existing_page_id = get_option('ams_brands_page_id');
    $existing_page = $existing_page_id ? get_post($existing_page_id) : null;
    
    // Also check if any page with [brand_filter] shortcode exists
    $existing_brand_pages = get_posts(array(
        'post_type' => 'page',
        'post_status' => 'publish',
        'posts_per_page' => -1,
        's' => '[brand_filter]',
        'meta_query' => array(
            array(
                'key' => '_wp_page_template',
                'compare' => 'EXISTS'
            )
        )
    ));
    
    if ($existing_page && $existing_page->post_status === 'publish' && !$recreate) {
        wp_send_json_error(__('Brands page already exists. Use the recreate option to replace it.', 'ams-wc-amazon'));
        return;
    }
    
    // Check for existing pages with brand_filter shortcode (but not the stored one)
    foreach ($existing_brand_pages as $brand_page) {
        if ($brand_page->ID != $existing_page_id && strpos($brand_page->post_content, '[brand_filter]') !== false && !$recreate) {
            wp_send_json_error(sprintf(
                __('A brands page already exists: "%s". Please check existing pages or use the recreate option.', 'ams-wc-amazon'),
                $brand_page->post_title
            ));
            return;
        }
    }
    
    // If recreating, delete the existing page
    if ($recreate && $existing_page_id) {
        wp_delete_post($existing_page_id, true);
        delete_option('ams_brands_page_id');
    }
    
    // Check if a page with the same slug already exists
    $existing_slug_page = get_page_by_path($page_slug);
    if ($existing_slug_page && (!$existing_page_id || $existing_slug_page->ID !== $existing_page_id)) {
        // Append a number to make it unique
        $counter = 1;
        $original_slug = $page_slug;
        while (get_page_by_path($page_slug)) {
            $page_slug = $original_slug . '-' . $counter;
            $counter++;
        }
    }
    
    // Create the page content
    $page_content = '<!-- wp:paragraph -->
<p>' . __('Browse all our product brands below. Click on any brand to see all products from that manufacturer.', 'ams-wc-amazon') . '</p>
<!-- /wp:paragraph -->

<!-- wp:shortcode -->
[brand_filter]
<!-- /wp:shortcode -->';
    
    // Create the page
    $page_data = array(
        'post_title'    => $page_title,
        'post_content'  => $page_content,
        'post_status'   => 'publish',
        'post_type'     => 'page',
        'post_name'     => $page_slug,
        'post_author'   => get_current_user_id(),
        'comment_status' => 'closed',
        'ping_status'   => 'closed'
    );
    
    $page_id = wp_insert_post($page_data);
    
    if (is_wp_error($page_id)) {
        wp_send_json_error(__('Failed to create the brands page. Please try again.', 'ams-wc-amazon'));
        return;
    }
    
    // Store the page ID for future reference
    update_option('ams_brands_page_id', $page_id);
    
    // Add to menu if requested
    $menu_added = false;
    if ($add_to_menu) {
        $menu_added = ams_add_page_to_menu($page_id, $page_title, $target_menu);
    }
    
    // Get the page URL
    $page_url = get_permalink($page_id);
    $edit_url = admin_url('post.php?post=' . $page_id . '&action=edit');
    
    $success_message = sprintf(
        __('Brands page "%s" created successfully!', 'ams-wc-amazon'),
        $page_title
    );
    
    if ($add_to_menu && $menu_added) {
        // Get the menu name for better feedback
        $menu_name = '';
        if ($menu_added !== true) { // If we return menu info instead of just true
            $menu_name = $menu_added;
        }
        $success_message .= ' ' . __('Page has been added to your main navigation menu.', 'ams-wc-amazon');
        if ($menu_name) {
            $success_message .= ' (' . $menu_name . ')';
        }
    } elseif ($add_to_menu && !$menu_added) {
        $success_message .= ' ' . __('Page created but could not be added to menu automatically. Please add it manually via Appearance > Menus.', 'ams-wc-amazon');
    }
    
    wp_send_json_success(array(
        'message' => $success_message,
        'page_id' => $page_id,
        'page_url' => $page_url,
        'edit_url' => $edit_url,
        'page_title' => $page_title,
        'page_slug' => $page_slug,
        'menu_added' => $menu_added
    ));
}

// Helper function to add page to main menu
function ams_add_page_to_menu($page_id, $page_title, $target_menu = 'auto') {
    // Get all menu locations
    $locations = get_nav_menu_locations();
    $primary_menu_id = null;
    
    $registered_locations = get_registered_nav_menus();
    
    // If a specific menu is requested, use it
    if ($target_menu !== 'auto' && is_numeric($target_menu)) {
        $primary_menu_id = intval($target_menu);
    }
    
    // Only do auto-detection if no specific menu was requested
    if (!$primary_menu_id) {
        // Try main navigation menu location names first (prioritize top/header menus)
        $main_location_names = array('primary', 'main', 'header', 'top', 'navigation', 'main-menu', 'primary-menu', 'header-menu', 'navbar');
        
        foreach ($main_location_names as $location) {
            if (isset($locations[$location]) && !empty($locations[$location])) {
                // Verify this is not a footer menu by checking the menu name
                $menu = wp_get_nav_menu_object($locations[$location]);
                if ($menu) {
                    $menu_name_lower = strtolower($menu->name);
                    // Skip if this appears to be a footer menu
                    if (strpos($menu_name_lower, 'footer') === false && 
                        strpos($menu_name_lower, 'bottom') === false &&
                        strpos($menu_name_lower, 'secondary') === false) {
                        $primary_menu_id = $locations[$location];
                        break;
                    }
                }
            }
        }
    }
    
    // If no menu found in locations, get the best available menu (avoid footer menus)
    if (!$primary_menu_id) {
        $menus = wp_get_nav_menus();
        
        if (!empty($menus)) {
            // Try to find a main menu (not footer/secondary)
            foreach ($menus as $menu) {
                $menu_name_lower = strtolower($menu->name);
                if (strpos($menu_name_lower, 'footer') === false && 
                    strpos($menu_name_lower, 'bottom') === false &&
                    strpos($menu_name_lower, 'secondary') === false) {
                    $primary_menu_id = $menu->term_id;
                    break;
                }
            }
            
            // If still no menu found, use the first one as last resort
            if (!$primary_menu_id) {
                $primary_menu_id = $menus[0]->term_id;
            }
        }
    }
    
    // Create a new menu if none exists
    if (!$primary_menu_id) {
        $menu_id = wp_create_nav_menu(__('Main Menu', 'ams-wc-amazon'));
        
        if (!is_wp_error($menu_id)) {
            $primary_menu_id = $menu_id;
            
            // Try to assign to a common location
            if (!empty($registered_locations)) {
                $first_location = array_keys($registered_locations)[0];
                $locations[$first_location] = $primary_menu_id;
                set_theme_mod('nav_menu_locations', $locations);
            }
        } else {
            return false;
        }
    }
    
    // Check if page is already in menu
    $menu_items = wp_get_nav_menu_items($primary_menu_id);
    if ($menu_items) {
        foreach ($menu_items as $item) {
            if ($item->object_id == $page_id && $item->object == 'page') {
                return true; // Already in menu
            }
        }
    }
    
    // Add page to menu
    $menu_item_data = array(
        'menu-item-object-id' => $page_id,
        'menu-item-object' => 'page',
        'menu-item-type' => 'post_type',
        'menu-item-status' => 'publish',
        'menu-item-title' => $page_title,
        'menu-item-position' => 999 // Add at the end
    );
    
    $menu_item_id = wp_update_nav_menu_item($primary_menu_id, 0, $menu_item_data);
    
    return !is_wp_error($menu_item_id);
}

function ams_ajax_refresh_brand_counts() {
    // Check nonce for security
    if (!wp_verify_nonce($_POST['nonce'], 'ams_refresh_brand_counts')) {
        wp_send_json_error('Security check failed');
        return;
    }

    // Check user permissions
    if (!current_user_can('manage_options')) {
        wp_send_json_error('Insufficient permissions');
        return;
    }

    // Update brand term counts
    ams_update_brand_term_counts();

    wp_send_json_success('Brand counts updated successfully');
}

// Conditionally display brand filter on shop and category pages
function ams_display_brand_filter() {
    if (get_option('ams_brand_module_enabled', '1') !== '1') {
        return;
    }

    if ((is_shop() && get_option('show_brands_shop_page')) || 
        (is_product_category() && get_option('show_brands_category_page'))) {
        echo do_shortcode('[brand_filter]');
    }
}
/////END/////

function ams_enqueue_admin_scripts($hook) {
    // Check if the current page is the brand taxonomy edit or create page
    if ('edit-tags.php' === $hook || 'term.php' === $hook) {
        if (isset($_GET['taxonomy']) && $_GET['taxonomy'] === 'product_brand') {
            wp_enqueue_media(); // WordPress media uploader
            wp_enqueue_script('brand-logo-upload', AMS_PLUGIN_URL . 'assets/plugin/js/brand-logo-upload.js', array('jquery'), null, true);
        }
    }

    // Enqueue Thickbox on plugins page (existing code)
    if ('plugins.php' === $hook) {
        wp_enqueue_script('thickbox');
        wp_enqueue_style('thickbox');
    }
}

function ams_plugin_information_content($false, $action, $response) {
   if ('plugin_information' != $action || 'ams-wc-amazon' != $response->slug) {
       return $false;
   }
   global $wp_version;
   
   // Get plugin header data
   $plugin_data = get_file_data(AMS_PLUGIN_FILE, array(
       'Name' => 'Plugin Name',
       'Slug' => 'Slug',
       'Version' => 'Version',
       'Author' => 'Author',
       'AuthorURI' => 'Author URI',
       'PluginURI' => 'Plugin URI',
       'Requires' => 'Requires at least',
       'Tested' => 'Tested up to',
       'LastUpdated' => 'Last Updated',
       'Downloads' => 'Downloads'
   ));

   // Enqueue styles and scripts
   wp_enqueue_script('ams-lightbox-script', AMS_PLUGIN_URL . 'assets/plugin/js/custom.js', array('jquery'), $plugin_data['Version'], true);

   // Set response data from plugin header
   $response->name = $plugin_data['Name'];
   $response->slug = $plugin_data['Slug'];
   $response->version = $plugin_data['Version'];
   $response->author = sprintf('<a href="%s">%s</a>', esc_url($plugin_data['AuthorURI']), esc_html($plugin_data['Author']));
   $response->homepage = esc_url($plugin_data['PluginURI']);
   $response->requires = $plugin_data['Requires'];
   $response->tested = $wp_version;
   $response->compatibility = array($wp_version => array($wp_version => array(100, 0, 0)));
   $response->downloaded = intval($plugin_data['Downloads']);
   $response->last_updated = $plugin_data['LastUpdated'];

    $response->sections = array(
        'description' => '<strong>AMS - The Ultimate WooCommerce Amazon Affiliate Plugin</strong>

        <p>Transform your WooCommerce store into a powerful Amazon affiliate platform. Easily search and import Amazon products with or without API keys, create a dropshipping store, and maximize your earnings.</p>

        <h3>Key Features:</h3>
        <ul>
            <li><strong>Effortless Integration:</strong> Import Amazon products directly into your WooCommerce store</li>
            <li><strong>Maximize Earnings:</strong> Boost sales with dynamic Amazon buy buttons and extended commission periods</li>
            <li><strong>Streamlined Operations:</strong> Automate product import, updates, and checkout processes</li>
            <li><strong>Global Marketplace Support:</strong> Compatible with multiple Amazon countries</li>
            <li><strong>Comprehensive Product Management:</strong> Auto-sync titles, prices, reviews, weights, and more</li>
            <li><strong>Robust API Support:</strong> Leverage Amazon\'s PA API 5.0 for advanced capabilities (optional)</li>
            <li><strong>Flexible Checkout Options:</strong> Choose between WooCommerce or Amazon checkout</li>
            <li><strong>Customization:</strong> Editable buy buttons, product details, and automatic currency conversion</li>
        </ul>

        <p>Whether you\'re a seasoned affiliate marketer or just starting, AMS provides all the tools you need to create and manage a successful Amazon affiliate store within your WooCommerce environment.</p>',

        'installation' => '<strong>INSTALLATION INSTRUCTIONS</strong>
            <ol>
                <li>Download the AMS - WooCommerce Amazon plugin ZIP file from your CodeCanyon account.</li>
                <li>Log in to your WordPress admin panel.</li>
                <li>Navigate to Plugins > Add New.</li>
                <li>Click on the "Upload Plugin" button at the top of the page.</li>
                <li>Choose the downloaded ZIP file and click "Install Now".</li>
                <li>After installation, click "Activate Plugin".</li>
            </ol>

            <h3>Post-Installation Setup</h3>
            <ol>
                <li>After activating the plugin, you need to activate your license.</li>
                <li>To find your purchase code (license key):
                    <ul>
                        <li>Log in to your Envato account.</li>
                        <li>Go to your Downloads page.</li>
                        <li>Click "Download" next to AMS - WooCommerce Amazon.</li>
                        <li>Choose "License certificate & purchase code (text)" from the dropdown.</li>
                    </ul>
                    For more detailed instructions, refer to <a href="https://affiliatepro.org/kb-article/how-to-find-your-ams-woocommerce-amazon-purchase-code/" target="_blank">Envato\'s guide on finding your purchase code</a>.
                </li>
                <li>Once you have your purchase code:
                    <ul>
                        <li>Go to the AMS plugin dashboard in your WordPress admin panel.</li>
                        <li>Locate the license activation box.</li>
                        <li>Paste your purchase code into the provided field.</li>
                        <li>Click "Activate".</li>
                    </ul>
                </li>
                <li>After successful activation, it\'s recommended to review and adjust the plugin settings to suit your needs.</li>
            </ol>

            <p>For more detailed setup instructions and troubleshooting, please refer to our <a href="https://affiliatepro.org/knowledge-base/" target="_blank">Knowledge Base</a>.</p>
        ',
        'faq' => '
        <h3>Frequently Asked Questions</h3>

        <p><strong>Q: Do I need an Amazon API key to use this plugin?</strong></p>
        <p>A: No, you can use AMS without an API key. However, using an API key (PA API 5.0) unlocks additional features and capabilities.</p>

        <p><strong>Q: Can I import products from multiple Amazon marketplaces?</strong></p>
        <p>A: Yes, AMS supports global marketplace integration, allowing you to import products from various Amazon marketplaces worldwide.</p>

        <p><strong>Q: How does the plugin handle product updates?</strong></p>
        <p>A: AMS automatically syncs and updates product information, including titles, prices, reviews, and more, ensuring your store always has the latest data from Amazon.</p>

        <p><strong>Q: Can I customize the "Buy on Amazon" buttons?</strong></p>
        <p>A: Absolutely! The plugin offers customizable, dynamic buy buttons to match your store\'s design and maximize conversions.</p>

        <p><strong>Q: Does AMS support dropshipping?</strong></p>
        <p>A: Yes, AMS includes a built-in module for dropshipping operations, making it easy to set up and manage a dropshipping business.</p>

        <p><strong>Q: How does the checkout process work?</strong></p>
        <p>A: You have flexibility in the checkout process. You can choose to have customers add products to the cart in your WooCommerce store and then redirect them to Amazon for the final purchase, or complete the checkout on your site.</p>

        <p><strong>Q: Can I import products without using URLs?</strong></p>
        <p>A: Yes, AMS offers versatile import options. You can import products using URLs, category searches, or keyword searches.</p>

        <p><strong>Q: Does the plugin support affiliate commissions?</strong></p>
        <p>A: Yes, AMS fully supports affiliate commissions, including options for 24-hour and 90-day cookie durations to maximize your earning potential.</p>

        <p><strong>Q: Is automatic currency conversion supported?</strong></p>
        <p>A: Yes, AMS includes automatic currency conversion to ensure pricing is displayed correctly for your local market.</p>

        <p><strong>Q: Can I manage multiple stores with this plugin?</strong></p>
        <p>A: While you can import from multiple Amazon marketplaces, all imported products are managed within a single WooCommerce store for streamlined operations.</p>

        <p><strong>Q: Is there a demo available to test the plugin?</strong></p>
        <p>A: Yes, we offer a demo site where you can experience AMS in action. You can access it using the provided demo credentials.</p>
        ',
        'changelog' => sprintf('
            <h3>Updates Log – Version %s</h3>
            <p>We regularly update our plugin to bring you new features, improvements, and bug fixes. To see the detailed changelog for this version, please visit our official changelog page:</p>
            <p><a href="https://affiliatepro.org/woocommerce-amazon-logs/">View Full Changelog</a></p>
            <p>Thank you for using our plugin. We\'re committed to continually enhancing your experience!</p>
            ',
            get_file_data(AMS_PLUGIN_FILE, array('Version' => 'Version'))['Version']
        ),
        'screenshots' => '
            <h3>Screenshots</h3>
            <ol>
                <li>
                    <img src="' . esc_url(AMS_PLUGIN_URL . 'assets/plugin/screenshots/1.png') . '" alt="AMS Dashboard" class="img-fluid" data-bs-toggle="modal" data-bs-target="#screenshotModal" style="cursor: pointer;">
                    <p>AMS Dashboard</p>
                </li>
                <li>
                    <img src="' . esc_url(AMS_PLUGIN_URL . 'assets/plugin/screenshots/2.png') . '" alt="AMS - Import Amazon products with API by Search and CSV" class="img-fluid" data-bs-toggle="modal" data-bs-target="#screenshotModal" style="cursor: pointer;">
                    <p>AMS - Import Amazon products with API by Search and CSV</p>
                </li>
                <li>
                    <img src="' . esc_url(AMS_PLUGIN_URL . 'assets/plugin/screenshots/3.png') . '" alt="AMS - Import Amazon products without-API by URL" class="img-fluid" data-bs-toggle="modal" data-bs-target="#screenshotModal" style="cursor: pointer;">
                    <p>AMS - Import Amazon products without-API by URL</p>
                </li>
                <li>
                    <img src="' . esc_url(AMS_PLUGIN_URL . 'assets/plugin/screenshots/4.png') . '" alt="AMS - Import Amazon products without-API by search" class="img-fluid" data-bs-toggle="modal" data-bs-target="#screenshotModal" style="cursor: pointer;">
                    <p>AMS - Import Amazon products without-API by search</p>
                </li>
                <li>
                    <img src="' . esc_url(AMS_PLUGIN_URL . 'assets/plugin/screenshots/5.png') . '" alt="AMS - Import Amazon products reviews without-API" class="img-fluid" data-bs-toggle="modal" data-bs-target="#screenshotModal" style="cursor: pointer;">
                    <p>AMS - Import Amazon products reviews without-API</p>
                </li>
                <li>
                    <img src="' . esc_url(AMS_PLUGIN_URL . 'assets/plugin/screenshots/6.png') . '" alt="AMS - Configuration[proxy services, settings, etc.]" class="img-fluid" data-bs-toggle="modal" data-bs-target="#screenshotModal" style="cursor: pointer;">
                    <p>AMS - Configuration[proxy services, settings, etc.]</p>
                </li>
                <li>
                    <img src="' . esc_url(AMS_PLUGIN_URL . 'assets/plugin/screenshots/7.png') . '" alt="AMS - Amazon API Settings key and test status" class="img-fluid" data-bs-toggle="modal" data-bs-target="#screenshotModal" style="cursor: pointer;">
                    <p>AMS - Amazon API Settings key and test status</p>
                </li>
                <li>
                    <img src="' . esc_url(AMS_PLUGIN_URL . 'assets/plugin/screenshots/8.png') . '" alt="AMS - Update Amazon products - All Types" class="img-fluid" data-bs-toggle="modal" data-bs-target="#screenshotModal" style="cursor: pointer;">
                    <p>AMS - Update Amazon products - All Types</p>
                </li>
            </ol>
        ',
    );
    $response->download_link = '';

    return $response;
}

/////START/////
//Backend code for product meta box - admin side
function ams_modify_product_image_meta_boxes() {
    remove_meta_box('postimagediv', 'product', 'side');
    add_meta_box('postimagediv', __('Product image'), 'ams_product_image_meta_box_content', 'product', 'side', 'low');
}
function ams_product_image_meta_box_content($post) {
    $post_id = $post->ID;
    
    // Display the original product image meta box content
    echo _wp_post_thumbnail_html(get_post_thumbnail_id($post_id), $post_id);

    // Display URL-based featured image if available
    $image_url = get_post_meta($post_id, '_thumbnail_id_url', true);
    if (!$image_url) {
        $ams_image_data = get_post_meta($post_id, '_amswoofiu_url', true);
        $ams_image_array = maybe_unserialize($ams_image_data);
        $image_url = is_array($ams_image_array) && isset($ams_image_array['img_url']) ? $ams_image_array['img_url'] : '';
    }
    
    if ($image_url) {
        echo '<div class="ams-url-featured-image">';
        echo '<p>' . __('URL-based Featured Image:') . '</p>';
        echo '<img src="' . esc_url($image_url) . '" style="max-width:100%;height:auto;">';
        echo '</div>';
    }
}
// Add URL-based images to the product gallery
function ams_add_url_images_to_product_gallery() {
    global $post;
    $product_id = $post->ID;
    $gallery_images = get_post_meta($product_id, '_amswoofiu_wcgallary', true);
    $gallery_images_array = maybe_unserialize($gallery_images);
    
    if (is_array($gallery_images_array) && !empty($gallery_images_array)) {
        ?>
        <script type="text/javascript">
            jQuery(document).ready(function($) {
                var galleryContainer = $('#product_images_container ul.product_images');
                <?php
                foreach ($gallery_images_array as $index => $image) {
                    if (isset($image['url'])) {
                        ?>
                        galleryContainer.append('<li class="image" data-attachment_id="url_<?php echo esc_js($index); ?>">' +
                            '<img src="<?php echo esc_js($image['url']); ?>" alt="" />' +
                            '<ul class="actions">' +
                            '<li><a href="#" class="delete" title="Delete image">Delete</a></li>' +
                            '</ul>' +
                            '</li>');
                        <?php
                    }
                }
                ?>
                // Reinitialize sortable
                if (typeof $.fn.sortable !== 'undefined') {
                    galleryContainer.sortable('refresh');
                }
            });
        </script>
        <?php
    }
}
// Handle deletion of URL-based images
function ams_handle_url_image_deletion() {
    if (isset($_POST['id']) && strpos($_POST['id'], 'url_') === 0) {
        $product_id = isset($_POST['post_id']) ? absint($_POST['post_id']) : 0;
        $index = substr($_POST['id'], 4);
        $gallery_images = get_post_meta($product_id, '_amswoofiu_wcgallary', true);
        $gallery_images_array = maybe_unserialize($gallery_images);
        
        if (isset($gallery_images_array[$index])) {
            unset($gallery_images_array[$index]);
            update_post_meta($product_id, '_amswoofiu_wcgallary', $gallery_images_array);
        }
        
        wp_send_json_success();
        exit;
    }
}
// Add custom CSS to ensure proper display
function ams_add_product_image_styles() {
    ?>
    <style>
        .ams-url-featured-image {
            margin-top: 1em;
            border-top: 1px solid #ddd;
            padding-top: 1em;
        }
        #product_images_container .image {
            width: 80px;
            height: 80px;
            float: left;
            margin: 3px;
            position: relative;
            box-sizing: border-box;
        }
        #product_images_container .image img {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }
    </style>
    <?php
}
//Backend code for product meta box - admin side
/////END/////

function ams_admin_styles() {
    echo '<style>
        .ams-update-notice {
            background-color: #fff8e5;
            border-left: 4px solid #ffb900;
            box-shadow: 0 1px 1px rgba(0,0,0,0.1);
            margin: 10px 0;
            padding: 12px 15px;
        }
        .ams-update-notice strong {
            display: block;
            margin-bottom: 8px;
            color: #23282d;
        }
        .ams-update-notice a {
            color: #0073aa;
            text-decoration: none;
            font-weight: 500;
        }
        .ams-update-notice a:hover {
            color: #00a0d2;
            text-decoration: underline;
        }
    </style>';
}

function ams_add_action_links($links) {
    $settings_link = '<a href="' . admin_url('admin.php?page=wc-product-setting-page&tab=pills-general-tab') . '">' . __('Settings', 'ams-wc-amazon') . '</a>';
    array_unshift($links, $settings_link);
    return $links;
}

function ams_plugin_row_meta($plugin_meta, $plugin_file, $plugin_data, $status) {
    if (plugin_basename(AMS_PLUGIN_FILE) == $plugin_file) {
        $row_meta = array(
            'docs'    => '<a href="' . esc_url('https://affiliatepro.org/knowledge-base/') . '" target="_blank" aria-label="' . esc_attr__('Documentation', 'ams-wc-amazon') . '">' . esc_html__('Documentation', 'ams-wc-amazon') . '</a>',
            'support' => '<a href="' . esc_url('https://affiliatepro.org/support/') . '" target="_blank" aria-label="' . esc_attr__('Support', 'ams-wc-amazon') . '">' . esc_html__('Support', 'ams-wc-amazon') . '</a>',
            'demo'    => '<a href="' . esc_url('https://affiliatepro.org/woocommerce-amazon-free-demo/') . '" target="_blank" aria-label="' . esc_attr__('Demo', 'ams-wc-amazon') . '">' . esc_html__('Demo', 'ams-wc-amazon') . '</a>',
            'view_details' => '<a href="' . self_admin_url('plugin-install.php?tab=plugin-information&plugin=ams-wc-amazon&TB_iframe=true&width=772&height=563') . '" class="thickbox open-plugin-details-modal" aria-label="' . esc_attr__('View AMS - WooCommerce Amazon details', 'ams-wc-amazon') . '">' . esc_html__('View details', 'ams-wc-amazon') . '</a>'
        );
        $plugin_meta = array_merge($plugin_meta, $row_meta);

        $new_version = ams_check_version();
        if ($new_version && version_compare(AMS_PLUGIN_VERSION, $new_version, '<')) {
            $update_url = 'https://codecanyon.net/downloads/';
            $details_url = 'https://affiliatepro.org/woocommerce-amazon-logs/';
            
            $update_notice = sprintf(
                '<div class="ams-update-notice">
                    <strong>%s</strong>
                    %s %s is available. 
                    <a href="%s" target="_blank">View version %s details</a> 
                    or 
                    <a href="%s" target="_blank">update now</a>.
                </div>',
                esc_html__('Update Available', 'ams-wc-amazon'),
                esc_html__('A new version of', 'ams-wc-amazon'),
                AMS_PLUGIN_NAME,
                esc_url($details_url),
                esc_html($new_version),
                esc_url($update_url)
            );
            
            $plugin_meta[] = $update_notice;
        }
    }
    return $plugin_meta;
}


// Simple and safe notification blocking system for AMS plugin pages
class AMS_Smart_Notice_Blocker {
    
    private $ams_pages = [
        'wc-amazon-affiliate',
        'wc-product-search',
        'products-search-without-api', 
        'amazon-bestsellers',
        'product-import-by-url',
        'product-review-import',
        'wc-product-setting-page',
        'view-logs',
        'automation',
        'automation-logs',
        'brand-settings'
    ];
    
    public function __construct() {
        // Use CSS-based hiding instead of hook manipulation to avoid WordPress hook corruption
        add_action('admin_head', [$this, 'add_notice_hiding_css']);
    }
    
    private function is_ams_page() {
        return is_admin() && isset($_GET['page']) && in_array($_GET['page'], $this->ams_pages, true);
    }
    
    public function add_notice_hiding_css() {
        if (!$this->is_ams_page()) {
            return;
        }
        
        // Hide common external plugin notices using CSS
        echo '<style type="text/css">
            /* Hide WordPress core update notices */
            .update-nag,
            .plugin-update-tr,
            
            /* Hide WooCommerce notices */
            .woocommerce-message:not([class*="ams"]):not([class*="amazon"]),
            .wc-admin-notice:not([class*="ams"]):not([class*="amazon"]),
            .notice.woocommerce:not([class*="ams"]):not([class*="amazon"]),
            
            /* Hide common plugin notices (but preserve AMS) */
            .notice:not([class*="ams"]):not([class*="amazon"]):not(.ams-notice),
            .updated:not([class*="ams"]):not([class*="amazon"]):not(.ams-notice),
            .error:not([class*="ams"]):not([class*="amazon"]):not(.ams-notice),
            
            /* Hide specific plugin notices */
            .yoast-notice,
            .elementor-notice,
            .jetpack-notice {
                display: none !important;
            }
            
            /* Always show AMS notices */
            .notice.ams-notice,
            .notice[class*="ams"],
            .notice[class*="amazon"],
            .updated.ams-notice,
            .updated[class*="ams"],
            .updated[class*="amazon"],
            .error.ams-notice,
            .error[class*="ams"],
            .error[class*="amazon"] {
                display: block !important;
            }
        </style>';
    }
}

// Initialize the smart notice blocker
new AMS_Smart_Notice_Blocker();

function clean_completed_woocommerce_actions() {
    if (get_option('enable_clean_completed_actions') !== '1') {
        return;
    }

    global $wpdb;
    $wpdb->query("
        DELETE FROM {$wpdb->prefix}actionscheduler_actions
        WHERE status = 'complete'
        AND hook IN (
            'wc_delete_related_product_transients_async',
            'woocommerce_run_product_attribute_lookup_update_callback',
            'woocommerce_cleanup_draft_orders'
        )
    ");
}

function clean_all_actionscheduler_logs() {
    if (get_option('enable_clean_action_logs') !== '1') {
        return;
    }

    global $wpdb;
    $wpdb->query("TRUNCATE TABLE {$wpdb->prefix}actionscheduler_logs");
}


// Force update variation images on product pages
function ams_force_update_on_product_page() {
    // TEMPORARILY DISABLED to prevent data corruption
    // This function was causing WooCommerce data corruption by saving arrays to string fields
    return;
    
    // Only run on product pages and if WooCommerce is active
    if (!is_product() || !function_exists('wc_get_product')) {
        return;
    }
    
    try {
        global $product;
        
        // Ensure we have a proper product object
        if (!is_object($product)) {
            $product_id = get_the_ID();
            if (!$product_id) {
                return;
            }
            $product = wc_get_product($product_id);
        }
        
        // Double-check we have a valid product object
        if (!$product || !is_object($product) || !method_exists($product, 'is_type')) {
            return;
        }
        
        if ($product->is_type('variable')) {
            $variations = $product->get_available_variations();
            foreach ($variations as $variation_data) {
                $variation_id = $variation_data['variation_id'];
                $meta_key = get_option('variation_image_meta_key', '');
                
                // Skip if meta key is a WooCommerce core field to prevent corruption
                if ($meta_key === '_product_image_gallery') {
                    continue;
                }
                
                $existing_images = get_post_meta($variation_id, $meta_key, true);
                
                if (empty($existing_images) || !is_array($existing_images)) {
                    $gallery_ids = get_post_meta($variation_id, '_product_image_gallery', true);
                    if (!empty($gallery_ids) && is_string($gallery_ids)) {
                        $gallery_array = explode(',', $gallery_ids);
                        $image_urls = [];
                        foreach ($gallery_array as $attachment_id) {
                            $attachment_id = trim($attachment_id);
                            if (is_numeric($attachment_id)) {
                                $image_url = wp_get_attachment_url($attachment_id);
                                if ($image_url) {
                                    $image_urls[] = $image_url;
                                }
                            }
                        }
                        if (!empty($image_urls)) {
                            update_post_meta($variation_id, $meta_key, $image_urls);
                        }
                    }
                }
            }
        }
    } catch (Exception $e) {
        // Silently handle any errors to prevent breaking the site
        return;
    }
}
// DISABLED - This was causing WooCommerce data corruption
// add_action('wp', 'ams_force_update_on_product_page');

// Emergency database fix for corrupted _product_image_gallery data
function ams_emergency_database_fix() {
    global $wpdb;
    
    // ONLY fix entries that are definitely corrupted (serialized arrays)
    $corrupted_entries = $wpdb->get_results("
        SELECT post_id, meta_value 
        FROM {$wpdb->postmeta} 
        WHERE meta_key = '_product_image_gallery' 
        AND meta_value LIKE 'a:%'
        LIMIT 50
    ");
    
    $fixed = 0;
    foreach ($corrupted_entries as $entry) {
        // Double-check this is actually serialized array data
        $unserialized = maybe_unserialize($entry->meta_value);
        if (is_array($unserialized)) {
            // Convert array back to comma-separated string if possible
            $attachment_ids = array();
            foreach ($unserialized as $item) {
                if (is_numeric($item)) {
                    $attachment_ids[] = $item;
                } elseif (is_string($item) && filter_var($item, FILTER_VALIDATE_URL)) {
                    // If it's a URL, try to find the attachment ID
                    $attachment_id = attachment_url_to_postid($item);
                    if ($attachment_id) {
                        $attachment_ids[] = $attachment_id;
                    }
                }
            }
            
            if (!empty($attachment_ids)) {
                // Save as proper comma-separated string
                $gallery_string = implode(',', $attachment_ids);
                update_post_meta($entry->post_id, '_product_image_gallery', $gallery_string);
            } else {
                // If we can't convert, just delete the corrupted entry
                delete_post_meta($entry->post_id, '_product_image_gallery');
            }
            $fixed++;
        }
    }
    
    return $fixed;
}

// ONE-TIME emergency fix - runs only once then disables itself
if (!get_option('ams_emergency_fix_final_v3')) {
    global $wpdb;
    
    // Remove ALL corrupted entries in one go
    $result = $wpdb->query("
        DELETE FROM {$wpdb->postmeta} 
        WHERE meta_value LIKE 'a:%'
        AND (
            meta_key = '_product_image_gallery' 
            OR meta_key LIKE '%image%'
        )
        AND meta_key != '_wp_attachment_metadata'
    ");
    
    if ($result > 0) {
        error_log("AMS FINAL Fix: Removed {$result} corrupted entries - DISABLED FURTHER CLEANUP");
    }
    
    // Mark as done so it never runs again
    update_option('ams_emergency_fix_final_v3', true);
}

// Manual cleanup AJAX for emergency situations
function ams_manual_cleanup_ajax() {
    if (!current_user_can('manage_options')) {
        wp_die('Insufficient permissions');
    }
    
    if (!wp_verify_nonce($_POST['nonce'], 'ams_cleanup_nonce')) {
        wp_die('Security check failed');
    }
    
    global $wpdb;
    
    // Aggressive cleanup - remove ALL corrupted _product_image_gallery entries
    $result = $wpdb->query("
        DELETE FROM {$wpdb->postmeta} 
        WHERE meta_key = '_product_image_gallery' 
        AND meta_value LIKE 'a:%'
    ");
    
    // Also clean up any other potential array-based corruption
    $result2 = $wpdb->query("
        DELETE FROM {$wpdb->postmeta} 
        WHERE meta_key LIKE '%image%' 
        AND meta_value LIKE 'a:%'
        AND meta_key NOT LIKE '%variation_images'
    ");
    
    $total_fixed = $result + $result2;
    
    wp_send_json_success(array(
        'message' => "Aggressive cleanup completed. Removed {$total_fixed} corrupted entries.",
        'fixed_count' => $total_fixed
    ));
}
add_action('wp_ajax_ams_manual_cleanup', 'ams_manual_cleanup_ajax');

// Universal AJAX handler that works with any theme
function ams_universal_variation_images_ajax() {
    $variation_id = intval($_POST['variation_id']);
    
    if (!$variation_id) {
        wp_die('Invalid variation ID');
        return;
    }
    
    $meta_key = get_option('variation_image_meta_key', '_product_image_gallery');
    
    // SAFETY CHECK: Never use _product_image_gallery directly to prevent corruption
    if ($meta_key === '_product_image_gallery') {
        wp_die('Cannot use WooCommerce core meta key directly');
        return;
    }
    
    $variation_images = get_post_meta($variation_id, $meta_key, true);
    
    if (empty($variation_images) || !is_array($variation_images)) {
        wp_die('No variation images found');
        return;
    }
    
    $current_theme = get_template();
    
    switch ($current_theme) {
        case 'ricky':
            echo ams_generate_ricky_html($variation_images, $variation_id);
            break;
            
        default:
            echo ams_generate_generic_html($variation_images, $variation_id);
            break;
    }
    
    wp_die();
}

// Generate Ricky theme specific HTML
function ams_generate_ricky_html($variation_images, $variation_id) {
    $hash = md5('variation_' . $variation_id);
    
    $images_html = '';
    foreach ($variation_images as $index => $image_url) {
        $image_html = sprintf(
            '<img src="%s" alt="Variation Image %d" class="c-product__slider-img c-product__slider-img--cover wp-post-image" />',
            esc_url($image_url),
            $index + 1
        );
        
        $images_html .= sprintf(
            '<div class="c-product__slider-item woocommerce-product-gallery__image" data-thumb="%s">%s</div>',
            esc_url($image_url),
            $image_html
        );
    }
    
    $slider_html = sprintf(
        '<div data-hash="%s" class="c-product__slider h-fade c-product__slider--carousel h-carousel h-carousel--round h-carousel--inner h-carousel--hover h-carousel--dots-hide js-single-product-carousel">%s</div>',
        esc_attr($hash),
        $images_html
    );
    
    if (count($variation_images) > 1) {
        $thumbs_html = '';
        foreach ($variation_images as $index => $image_url) {
            $active_class = ($index === 0) ? ' active' : '';
            $thumb_img = sprintf(
                '<img src="%s" alt="Thumb %d" class="c-product__thumbs-img" />',
                esc_url($image_url),
                $index + 1
            );
            
            $thumbs_html .= sprintf(
                '<div class="c-product__thumbs-item%s">
                    <button type="button" class="h-cb js-single-product-thumb" data-index="%d">%s</button>
                </div>',
                $active_class,
                $index,
                $thumb_img
            );
        }
        
        $slider_html .= sprintf(
            '<div data-cnt="%d" class="c-product__thumbs h-carousel h-carousel--nav-hide h-carousel--dots-hide" id="js-product-thumbs-carousel">%s</div>',
            count($variation_images),
            $thumbs_html
        );
    }
    
    return $slider_html;
}

// Generate generic HTML for unknown themes
function ams_generate_generic_html($variation_images, $variation_id) {
    $images_html = '';
    foreach ($variation_images as $index => $image_url) {
        $images_html .= sprintf(
            '<div class="woocommerce-product-gallery__image">
                <img src="%s" alt="Variation Image %d" class="wp-post-image" />
            </div>',
            esc_url($image_url),
            $index + 1
        );
    }
    
    $slider_html = sprintf(
        '<div class="woocommerce-product-gallery woocommerce-product-gallery--with-images">%s</div>',
        $images_html
    );
    
    if (count($variation_images) > 1) {
        $thumbs_html = '';
        foreach ($variation_images as $index => $image_url) {
            $thumbs_html .= sprintf(
                '<div class="woocommerce-product-gallery__trigger">
                    <img src="%s" alt="Thumb %d" />
                </div>',
                esc_url($image_url),
                $index + 1
            );
        }
        
        $slider_html .= sprintf('<div class="woocommerce-product-gallery__thumbs">%s</div>', $thumbs_html);
    }
    
    return $slider_html;
}

// Register AJAX handlers for detected theme actions
function ams_register_theme_ajax_handlers() {
    $current_theme = get_template();
    
    // Register AJAX handlers based on detected/configured action
    $ajax_action = get_option('variation_ajax_action', '');
    if (!empty($ajax_action)) {
        add_action('wp_ajax_' . $ajax_action, 'ams_universal_variation_images_ajax');
        add_action('wp_ajax_nopriv_' . $ajax_action, 'ams_universal_variation_images_ajax');
    }
}
add_action('init', 'ams_register_theme_ajax_handlers', 25);