<?php include "common-header.php";

$results_limit = get_option('ams_results_limit', '50');
?>

<?php

if ( class_exists( 'WooCommerce' ) ) {
    $currency_symbol = get_woocommerce_currency_symbol();
} else {
    $currency_symbol = '$';
}
?>

<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            
            <!-- Proxy Service Status Notification -->
            <div id="proxy-notification-area" class="mb-3">
                <?php 
                // Get smart service status
                $services_status = $this->get_proxy_services_status();
                
                if ($services_status['show_setup_notification']) {
                ?>
                    <div class="card border-warning shadow-sm ams-common-card-fix mb-3">
                        <div class="card-body p-4">
                            <div class="row align-items-center">
                                <div class="col-md-8">
                                    <div class="d-flex align-items-start">
                                        <div class="me-3">
                                            <div class="bg-warning bg-opacity-10 rounded-circle p-3">
                                                <i class="bi bi-shield-exclamation text-warning fs-3"></i>
                                            </div>
                                        </div>
                                        <div>
                                            <h5 class="text-warning mb-2 fw-bold">
                                                <i class="bi bi-cloud-arrow-down me-2"></i>
                                                <?php esc_html_e('Proxy Service Required', 'ams-wc-amazon'); ?>
                                            </h5>
                                            <p class="text-muted mb-2">
                                                <?php esc_html_e('For reliable product importing, we recommend setting up a proxy service to prevent Amazon from blocking your searches.', 'ams-wc-amazon'); ?>
                                            </p>
                                            <div class="d-flex flex-wrap gap-2 mb-2">
                                                <span class="badge bg-light text-dark border">
                                                    <i class="bi bi-circle me-1"></i><?php esc_html_e('Decodo Service', 'ams-wc-amazon'); ?>
                                                </span>
                                                <span class="badge bg-light text-dark border">
                                                    <i class="bi bi-circle me-1"></i><?php esc_html_e('ScraperAPI Service', 'ams-wc-amazon'); ?>
                                                </span>
                                                <span class="badge bg-light text-dark border">
                                                    <i class="bi bi-circle me-1"></i><?php esc_html_e('ScrapingAnt Service', 'ams-wc-amazon'); ?>
                                                </span>
                                            </div>
                                            <small class="text-muted">
                                                <i class="bi bi-info-circle me-1"></i>
                                                <?php esc_html_e('Choose one of the proxy services above for better success rates', 'ams-wc-amazon'); ?>
                                            </small>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4 text-md-end mt-3 mt-md-0">
                                    <div class="d-flex flex-column gap-2">
                                        <a href="<?php echo admin_url('admin.php?page=wc-product-setting-page&tab=pills-general-tab'); ?>" 
                                           class="btn btn-warning btn-lg shadow-sm">
                                            <i class="bi bi-gear-fill me-2"></i>
                                            <?php esc_html_e('Configure Proxy', 'ams-wc-amazon'); ?>
                                        </a>
                                        <small class="text-muted text-center">
                                            <?php esc_html_e('Recommended for reliable scraping', 'ams-wc-amazon'); ?>
                                        </small>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php 
                }
                ?>
            </div>

            <!-- Main Search Card -->
            <div class="card shadow-sm ams-common-card-fix">
                <div class="card-header bg-light border-bottom">
                    <div class="d-flex align-items-center justify-content-between">
                        <h5 class="mb-0 fw-bold text-dark">
                            <i class="bi bi-search text-primary me-2"></i>
                            <?php esc_html_e('Product Search Without API', 'ams-wc-amazon'); ?>
                            <?php 
                            // Get detailed service status for smart badges
                            $services_status = $this->get_proxy_services_status();
                            foreach ($services_status['services'] as $service) {
                                // Create detailed tooltip with symbol explanations
                                $tooltip = $service['title'];
                                if ($service['status'] === 'enabled') {
                                    $tooltip .= ' | Symbols: ';
                                    if (strpos($service['symbols'], '↓') !== false) {
                                        $tooltip .= '↓=Import ';
                                    }
                                    if (strpos($service['symbols'], '↻') !== false) {
                                        $tooltip .= '↻=Update ';
                                    }
                                    if ($service['symbols'] === '○') {
                                        $tooltip .= '○=Configured but no operations';
                                    }
                                } else {
                                    $tooltip .= ' | ✕=Disabled or not configured';
                                }
                            ?>
                                <span class="badge <?php echo esc_attr($service['badge_class']); ?> text-white ms-1" 
                                      title="<?php echo esc_attr($tooltip); ?>"
                                      data-bs-toggle="tooltip" 
                                      data-bs-placement="bottom">
                                    <i class="<?php echo esc_attr($service['icon']); ?> me-1" 
                                       alt="<?php echo esc_attr($service['status'] === 'enabled' ? 'Service enabled' : 'Service disabled'); ?>"></i>
                                    <?php echo esc_html($service['name']); ?>
                                    <small class="ms-1" 
                                           title="<?php 
                                           if ($service['status'] === 'enabled') {
                                               $symbol_tooltip = '';
                                               if (strpos($service['symbols'], '↓') !== false) {
                                                   $symbol_tooltip .= 'Import enabled ';
                                               }
                                               if (strpos($service['symbols'], '↻') !== false) {
                                                   $symbol_tooltip .= 'Update enabled ';
                                               }
                                               if ($service['symbols'] === '○') {
                                                   $symbol_tooltip = 'Configured but no operations enabled';
                                               }
                                               echo esc_attr(trim($symbol_tooltip));
                                           } else {
                                               echo esc_attr('Service disabled or not configured');
                                           }
                                           ?>">
                                        <?php echo esc_html($service['symbols']); ?>
                                    </small>
                                </span>
                            <?php } ?>
                        </h5>
                        <div class="d-flex gap-2 align-items-center">
                            <span class="text-muted small me-2"><?php esc_html_e('Results Limit:', 'ams-wc-amazon'); ?></span>
                            <select id="quick-results-limit" class="form-select form-select-sm w-auto">
                                <option value="5" <?php selected($results_limit, '5', true); ?>><?php esc_html_e('5', 'ams-wc-amazon'); ?></option>
                                <option value="10" <?php selected($results_limit, '10', true); ?>><?php esc_html_e('10', 'ams-wc-amazon'); ?></option>
                                <option value="20" <?php selected($results_limit, '20', true); ?>><?php esc_html_e('20', 'ams-wc-amazon'); ?></option>
                                <option value="50" <?php selected($results_limit, '50', true); ?>><?php esc_html_e('50', 'ams-wc-amazon'); ?></option>
                                <option value="100" <?php selected($results_limit, '100', true); ?>><?php esc_html_e('100', 'ams-wc-amazon'); ?></option>
                                <option value="200" <?php selected($results_limit, '200', true); ?>><?php esc_html_e('200', 'ams-wc-amazon'); ?></option>
                                <option value="500" <?php selected($results_limit, '500', true); ?>><?php esc_html_e('500', 'ams-wc-amazon'); ?></option>
                            </select>
                            <button type="button" class="btn btn-outline-primary btn-sm" id="save-results-limit">
                                <i class="bi bi-floppy me-1"></i><?php esc_html_e('Save', 'ams-wc-amazon'); ?>
                            </button>
                        </div>
                    </div>
                </div>
                <div class="card-body p-0">
                    <!-- Search Form Section -->
                    <div class="p-4 border-bottom bg-light bg-opacity-25">
                        <form action="" class="wca-product-without-api-search" method="POST">
                        <div class="row g-3 align-items-end">
                            <!-- Category Filter -->
                            <div class="col-lg-2 col-md-6">
                                <label for="ams_amazon_cat" class="form-label fw-medium text-dark mb-2">
                                    <i class="bi bi-list me-2 text-primary"></i><?php esc_html_e('Category', 'ams-wc-amazon'); ?>
                                </label>
                                <select name="ams_amazon_cat" id="ams_amazon_cat" class="form-select" >
                                    <option value=""><?php esc_html_e('All Categories', 'ams-wc-amazon'); ?></option>
                                    <?php foreach ( $this->get_amazon_cat() as $key => $value ) { ?>
                                    <option value="<?php echo esc_attr( $key ); ?>"><?php echo esc_html( $value ); ?></option>
                                    <?php } ?>
                                </select>
                            </div>
                            
                            <!-- Keywords -->
                            <div class="col-lg-3 col-md-6">
                                <label for="keyword" class="form-label fw-medium text-dark mb-2">
                                    <i class="bi bi-search me-2 text-primary"></i><?php esc_html_e('Keywords', 'ams-wc-amazon'); ?>
                                </label>
                                <input name="keyword" id="keyword" class="form-control" 
                                       placeholder="<?php echo esc_attr__( 'Enter product name or keywords...', 'ams-wc-amazon' ); ?>" type="text">
                            </div>
                            
                            <!-- Price Range -->
                            <div class="col-lg-2 col-md-6">
                                <label class="form-label fw-medium text-dark mb-2">
                                    <i class="bi bi-currency-euro me-2 text-primary"></i><?php esc_html_e('Price Range', 'ams-wc-amazon'); ?>
                                </label>
                                <div class="row g-1">
                                    <div class="col-6">
                                        <input name="min_price" id="min_price" class="form-control" type="number" min="0" 
                                               placeholder="<?php esc_attr_e('Min', 'ams-wc-amazon'); ?>">
                                    </div>
                                    <div class="col-6">
                                        <input name="max_price" id="max_price" class="form-control" type="number" min="0" 
                                               placeholder="<?php esc_attr_e('Max', 'ams-wc-amazon'); ?>">
                                    </div>
                                </div>
                            </div>
                            
                            <!-- Rating Filter -->
                            <div class="col-lg-2 col-md-6">
                                <label for="star_rating" class="form-label fw-medium text-dark mb-2">
                                    <i class="bi bi-star me-2 text-primary"></i><?php esc_html_e('Min Rating', 'ams-wc-amazon'); ?>
                                </label>
                                <select name="star_rating" id="star_rating" class="form-select" >
                                    <option value=""><?php esc_html_e('Any Rating', 'ams-wc-amazon'); ?></option>
                                    <option value="4"><?php esc_html_e('4+ Stars (Excellent)', 'ams-wc-amazon'); ?></option>
                                    <option value="3"><?php esc_html_e('3+ Stars (Good)', 'ams-wc-amazon'); ?></option>
                                    <option value="2"><?php esc_html_e('2+ Stars (Fair)', 'ams-wc-amazon'); ?></option>
                                </select>
                            </div>
                            
                            <!-- Product Type -->
                            <div class="col-lg-2 col-md-6">
                                <label for="variant-filter-main" class="form-label fw-medium text-dark mb-2">
                                    <i class="bi bi-boxes me-2 text-primary"></i><?php esc_html_e('Product Type', 'ams-wc-amazon'); ?>
                                </label>
                                <select name="variant_type" id="variant-filter-main" class="form-select" >
                                    <option value=""><?php esc_html_e('All Types', 'ams-wc-amazon'); ?></option>
                                    <option value="simple"><?php esc_html_e('Simple Products', 'ams-wc-amazon'); ?></option>
                                    <option value="variants"><?php esc_html_e('Variable Products', 'ams-wc-amazon'); ?></option>
                                </select>
                            </div>

                            <!-- Brand Filter -->
                            <div class="col-lg-1 col-md-6">
                                <label for="brand-filter" class="form-label fw-medium text-dark mb-2">
                                    <i class="bi bi-tag me-2 text-primary"></i><?php esc_html_e('Brand', 'ams-wc-amazon'); ?>
                                </label>
                                <select name="brand_filter" id="brand-filter" class="form-select" >
                                    <option value=""><?php esc_html_e('All Brands', 'ams-wc-amazon'); ?></option>
                                    <!-- Brands will be populated dynamically -->
                                </select>
                            </div>
                        </div>
                        
                        <!-- Second Row: Sort and Actions -->
                        <div class="row g-3 mt-2 align-items-end">
                            <!-- Sort Options -->
                            <div class="col-lg-3 col-md-6">
                                <label for="sort_by" class="form-label fw-medium text-dark mb-2">
                                    <i class="bi bi-sort-down me-2 text-primary"></i><?php esc_html_e('Sort By', 'ams-wc-amazon'); ?>
                                </label>
                                <select name="sort_by" id="sort_by" class="form-select" >
                                    <option value="relevance"><?php esc_html_e('Relevance', 'ams-wc-amazon'); ?></option>
                                    <option value="price-low"><?php esc_html_e('Price: Low to High', 'ams-wc-amazon'); ?></option>
                                    <option value="price-high"><?php esc_html_e('Price: High to Low', 'ams-wc-amazon'); ?></option>
                                    <option value="rating"><?php esc_html_e('Customer Rating', 'ams-wc-amazon'); ?></option>
                                    <option value="discount"><?php esc_html_e('Discount Percentage', 'ams-wc-amazon'); ?></option>
                                    <option value="newest"><?php esc_html_e('Newest First', 'ams-wc-amazon'); ?></option>
                                </select>
                                </div>

                            <!-- Title Filter -->
                            <div class="col-lg-6 col-md-6">
                                <label for="title_search" class="form-label fw-medium text-dark mb-2">
                                    <i class="bi bi-funnel me-2 text-primary"></i><?php esc_html_e('Filter Results', 'ams-wc-amazon'); ?>
                                </label>
                                <input name="title_search" id="title_search" class="form-control" 
                                       placeholder="<?php echo esc_attr__( 'Filter results by title (real-time filtering)', 'ams-wc-amazon' ); ?>" type="text">
                            </div>

                            <!-- Action Buttons -->
                            <div class="col-lg-3 col-md-12">
                                <label class="form-label fw-medium text-dark mb-2">
                                    <i class="bi bi-gears me-2 text-primary"></i><?php esc_html_e('Actions', 'ams-wc-amazon'); ?>
                                </label>
                                <div class="d-flex gap-2">
                                    <button type="submit" class="btn btn-primary flex-fill" >
                                        <i class="bi bi-search me-2"></i><?php esc_html_e('Search', 'ams-wc-amazon'); ?>
                                    </button>
                                    <button type="button" class="btn btn-outline-secondary" id="clear-all-filters-btn" >
                                        <i class="bi bi-eraser me-2"></i><?php esc_html_e('Clear All', 'ams-wc-amazon'); ?>
                                    </button>
                                </div>
                            </div>
                        </div>

                            <input type="hidden" name="action" value="<?php echo esc_attr('search_products'); ?>">
                            <?php wp_nonce_field( 'wca_search_product' ); ?>
                        </form>
                    </div>
                    
                    <!-- Results Section -->
                    <div class="p-4">
                        <!-- Validation Error Message -->
                        <div id="validation-error-message" class="alert alert-danger text-center d-none mb-3" role="alert"></div>
                        
                        <!-- Enhanced View Mode Controls & Filters -->
                        <div class="view-mode-controls mb-3 d-none" id="view-mode-controls">
                            <div class="card border-0 bg-light">
                                <div class="card-body p-3">
                                    <!-- Top Row: View Modes & Results Count -->
                                    <div class="d-flex align-items-center justify-content-between mb-3">
                                        <div class="d-flex align-items-center">
                                            <small class="text-muted me-3 fw-bold">
                                                <i class="bi bi-search me-1"></i>
                                                <span id="results-count">0 products found</span>
                                            </small>
                                        </div>
                                        
                                        <div class="d-flex align-items-center gap-3">
                                            <!-- View Mode Buttons -->
                                            <div class="d-flex align-items-center">
                                                <small class="text-muted me-2 fw-bold"><?php esc_html_e('View:', 'ams-wc-amazon'); ?></small>
                                                <div class="btn-group btn-group-sm" role="group" aria-label="<?php esc_attr_e('View mode options', 'ams-wc-amazon'); ?>">
                                                    <input type="radio" class="btn-check" name="view_mode" id="grid_view" value="grid" checked>
                                                    <label class="btn btn-outline-primary" for="grid_view" title="<?php esc_attr_e('Grid View', 'ams-wc-amazon'); ?>">
                                                        <i class="bi bi-grid"></i>
                                                    </label>
                                                    
                                                    <input type="radio" class="btn-check" name="view_mode" id="list_view" value="list">
                                                    <label class="btn btn-outline-primary" for="list_view" title="<?php esc_attr_e('List View', 'ams-wc-amazon'); ?>">
                                                        <i class="bi bi-list"></i>
                                                    </label>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <!-- Filters Panel (Collapsible) -->
                                    <div class="filters-panel d-none" id="filters-panel">
                                        <hr class="my-3">
                                        <div class="row g-3">
                                            <!-- Price Range Filter -->
                                            <div class="col-md-3">
                                                <label class="form-label fw-bold small text-muted">
                                                    <i class="bi bi-currency-dollar me-1"></i><?php esc_html_e('Price Range', 'ams-wc-amazon'); ?>
                                                </label>
                                                <div class="d-flex gap-2">
                                                    <input type="number" class="form-control form-control-sm" id="price-min" placeholder="Min" min="0" step="0.01">
                                                    <input type="number" class="form-control form-control-sm" id="price-max" placeholder="Max" min="0" step="0.01">
                                                </div>
                                            </div>
                                            
                                            <!-- Rating Filter -->
                                            <div class="col-md-2">
                                                <label class="form-label fw-bold small text-muted">
                                                    <i class="bi bi-star me-1"></i><?php esc_html_e('Min Rating', 'ams-wc-amazon'); ?>
                                                </label>
                                                <select class="form-select form-select-sm" id="rating-filter">
                                                    <option value=""><?php esc_html_e('Any Rating', 'ams-wc-amazon'); ?></option>
                                                    <option value="4">4+ Stars</option>
                                                    <option value="3">3+ Stars</option>
                                                    <option value="2">2+ Stars</option>
                                                    <option value="1">1+ Stars</option>
                                                </select>
                                            </div>
                                            
                                            <!-- Stock Status Filter -->
                                            <div class="col-md-2">
                                                <label class="form-label fw-bold small text-muted">
                                                    <i class="bi bi-boxes me-1"></i><?php esc_html_e('Availability', 'ams-wc-amazon'); ?>
                                                </label>
                                                <select class="form-select form-select-sm" id="stock-filter">
                                                    <option value=""><?php esc_html_e('All Items', 'ams-wc-amazon'); ?></option>
                                                    <option value="in_stock"><?php esc_html_e('In Stock', 'ams-wc-amazon'); ?></option>
                                                    <option value="limited_stock"><?php esc_html_e('Limited Stock', 'ams-wc-amazon'); ?></option>
                                                    <option value="out_of_stock"><?php esc_html_e('Out of Stock', 'ams-wc-amazon'); ?></option>
                                                </select>
                                            </div>
                                            
                                            <!-- Product Type Filter (NEW) -->
                                            <div class="col-md-2">
                                                <label class="form-label fw-bold small text-muted">
                                                    <i class="bi bi-layers me-1"></i><?php esc_html_e('Product Type', 'ams-wc-amazon'); ?>
                                                </label>
                                                <select class="form-select form-select-sm" id="variant-filter">
                                                    <option value=""><?php esc_html_e('All Products', 'ams-wc-amazon'); ?></option>
                                                    <option value="simple"><?php esc_html_e('Simple Products', 'ams-wc-amazon'); ?></option>
                                                    <option value="variants"><?php esc_html_e('With Variants', 'ams-wc-amazon'); ?></option>
                                                </select>
                                            </div>
                                            
                                            <!-- Prime Filter -->
                                            <div class="col-md-1">
                                                <label class="form-label fw-bold small text-muted">
                                                    <i class="bi bi-truck me-1"></i><?php esc_html_e('Prime', 'ams-wc-amazon'); ?>
                                                </label>
                                                <div class="form-check">
                                                    <input class="form-check-input" type="checkbox" id="prime-filter" value="prime">
                                                    <label class="form-check-label small" for="prime-filter">
                                                        Prime Only
                                                    </label>
                                                </div>
                                            </div>
                                            
                                            <!-- Brand Filter -->
                                            <div class="col-md-2">
                                                <label class="form-label fw-bold small text-muted">
                                                    <i class="bi bi-building me-1"></i><?php esc_html_e('Brand', 'ams-wc-amazon'); ?>
                                                </label>
                                                <select class="form-select form-select-sm" id="brand-filter">
                                                    <option value=""><?php esc_html_e('All Brands', 'ams-wc-amazon'); ?></option>
                                                    <!-- Brands will be populated dynamically -->
                                                </select>
                                            </div>
                                        </div>
                                        
                                        <!-- Active Filters Display -->
                                        <div class="active-filters mt-3 d-none" id="active-filters">
                                            <small class="text-muted fw-bold me-2"><?php esc_html_e('Active Filters:', 'ams-wc-amazon'); ?></small>
                                            <div class="d-inline-flex flex-wrap gap-1" id="active-filters-list">
                                                <!-- Active filter badges will appear here -->
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Recent Searches Section -->
                        <div class="recent-searches mb-4" id="recent-searches">
                            <div class="card border-0 bg-light bg-opacity-50">
                                <div class="card-body p-3">
                                    <div class="d-flex align-items-center justify-content-between mb-3">
                                        <h6 class="mb-0 fw-bold text-dark">
                                            <i class="bi bi-clock-history me-2 text-primary"></i><?php esc_html_e('Recent Searches', 'ams-wc-amazon'); ?>
                                        </h6>
                                        <button type="button" class="btn btn-sm btn-outline-secondary" id="clear-recent-searches">
                                            <i class="bi bi-trash me-1"></i><?php esc_html_e('Clear All', 'ams-wc-amazon'); ?>
                                        </button>
                                    </div>
                                    <div class="recent-searches-list" id="recent-searches-list">
                                        <!-- Recent searches will be populated here -->
                                        <div class="d-flex flex-wrap gap-2">
                                            <!-- Example recent search tags - these would be populated by JavaScript -->
                                            <span class="badge bg-light text-dark border px-3 py-2 rounded-pill">
                                                <i class="bi bi-search me-1"></i>laptop computers
                                                <button type="button" class="btn-close btn-close-sm ms-2" aria-label="Remove"></button>
                                            </span>
                                            <span class="badge bg-light text-dark border px-3 py-2 rounded-pill">
                                                <i class="bi bi-search me-1"></i>wireless headphones
                                                <button type="button" class="btn-close btn-close-sm ms-2" aria-label="Remove"></button>
                                            </span>
                                            <span class="badge bg-light text-dark border px-3 py-2 rounded-pill">
                                                <i class="bi bi-search me-1"></i>gaming mouse
                                                <button type="button" class="btn-close btn-close-sm ms-2" aria-label="Remove"></button>
                                            </span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Products Container -->
                        <div class="product_cards d-none">
                            <div class="row wca-amazon-product g-3 grid-view" id="products-container">
                                <!-- Product cards will be dynamically inserted here -->
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
            </div>
</div>



<script>
// Initialize Bootstrap tooltips for proxy service badges
jQuery(document).ready(function($) {
    // Initialize tooltips
    var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
    var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
        return new bootstrap.Tooltip(tooltipTriggerEl);
    });
});
</script>

<?php include "common-footer.php"; ?>