<?php include "common-header.php"; ?>

<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            
            <!-- API Status Notification -->
            <div id="notification-area" class="mb-3">
                <?php 
                $api_missing = empty(get_option('ams_access_key_id')) || empty(get_option('ams_secret_access_key')) || empty(get_option('ams_associate_tag'));
                if($api_missing) { 
                ?>
                    <div class="card border-warning shadow-sm mb-3 ams-common-card-fix" id="api-setup-card">
                        <div class="card-body p-4">
                            <div class="row align-items-center">
                                <div class="col-md-8">
                                    <div class="d-flex align-items-start">
                                        <div class="me-3">
                                            <div class="bg-warning bg-opacity-10 rounded-circle p-3">
                                                <i class="bi bi-key-fill text-warning fs-3"></i>
                                            </div>
                                        </div>
                                        <div>
                                            <h5 class="text-warning mb-2 fw-bold">
                                                <i class="bi bi-amazon me-2"></i>
                                                <?php esc_html_e('Amazon API Setup Required', 'ams-wc-amazon'); ?>
                                            </h5>
                                            <p class="text-muted mb-2">
                                                <?php esc_html_e('To start importing products from Amazon, you need to configure your API credentials first.', 'ams-wc-amazon'); ?>
                                            </p>
                                            <div class="d-flex flex-wrap gap-2 mb-2">
                                                <span class="badge bg-light text-dark border">
                                                    <i class="bi bi-circle me-1"></i><?php esc_html_e('Access Key ID', 'ams-wc-amazon'); ?>
                                                </span>
                                                <span class="badge bg-light text-dark border">
                                                    <i class="bi bi-circle me-1"></i><?php esc_html_e('Secret Access Key', 'ams-wc-amazon'); ?>
                                                </span>
                                                <span class="badge bg-light text-dark border">
                                                    <i class="bi bi-circle me-1"></i><?php esc_html_e('Associate Tag', 'ams-wc-amazon'); ?>
                                                </span>
                                            </div>
                                            <small class="text-muted">
                                                <i class="bi bi-info-circle me-1"></i>
                                                <?php esc_html_e('Get your credentials from Amazon Associate Program', 'ams-wc-amazon'); ?>
                                            </small>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4 text-md-end mt-3 mt-md-0">
                                    <div class="d-flex flex-column gap-2">
                                        <a href="<?php echo admin_url('admin.php?page=wc-product-setting-page&tab=pills-az-settings-tab'); ?>" 
                                           class="btn btn-warning btn-lg shadow-sm">
                                            <i class="bi bi-gear-fill me-2"></i>
                                            <?php esc_html_e('Configure API Now', 'ams-wc-amazon'); ?>
                                        </a>
                                        <a href="https://affiliate-program.amazon.com/" target="_blank" 
                                           class="btn btn-outline-secondary btn-sm">
                                            <i class="bi bi-box-arrow-up-right me-1"></i>
                                            <?php esc_html_e('Get Amazon API Keys', 'ams-wc-amazon'); ?>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php 
                } else {
                    // API credentials exist, show validation status
                ?>
                    <!-- API validation will now use toast notifications -->
                <?php 
                }
                ?>
                <!-- Validation errors will now use toast notifications -->
            </div>

            <!-- Main Search Card -->
            <div class="card shadow-sm ams-common-card-fix">
                <div class="card-header bg-light border-bottom py-2">
                    <div class="d-flex align-items-center justify-content-between">
                        <h6 class="mb-0 fw-bold text-dark">
                            <i class="bi bi-cloud-upload text-primary me-2"></i>
                            <?php esc_html_e('Product Search & Import', 'ams-wc-amazon'); ?>
                            <?php if(empty(get_option('ams_access_key_id')) || empty(get_option('ams_secret_access_key')) || empty(get_option('ams_associate_tag'))) { ?>
                                <span class="badge bg-warning text-dark ms-2"><?php esc_html_e('API Required', 'ams-wc-amazon'); ?></span>
                            <?php } ?>
                        </h6>
                        <div class="d-flex gap-2">
                            <a href="<?php echo admin_url('admin.php?page=wc-product-setting-page&tab=pills-az-settings-tab'); ?>" class="btn btn-outline-primary btn-sm">
                                <i class="bi bi-gear me-1"></i><?php esc_html_e('API Settings', 'ams-wc-amazon'); ?>
                            </a>
                        </div>
                    </div>
                </div>
                <div class="card-body p-0">
                    <div class="p-3">
                    <?php $api_missing = empty(get_option('ams_access_key_id')) || empty(get_option('ams_secret_access_key')) || empty(get_option('ams_associate_tag')); ?>
                    <form id="wca-product-search" method="POST">
                        
                        <!-- Enhanced Search Method Tabs -->
                        <div class="btn-group w-100 shadow-sm mb-3 ams-common-card-fix" role="group" aria-label="Search methods">
                            <input type="radio" class="btn-check" name="wca_search_by" id="keyword" value="keyword" checked>
                            <label class="btn btn-outline-primary btn-lg d-flex align-items-center justify-content-center py-3" for="keyword">
                                <i class="bi bi-search fs-5 me-2"></i>
                                <div class="text-start">
                                    <div class="fw-bold"><?php esc_html_e('Keywords', 'ams-wc-amazon'); ?></div>
                                    <small class="text-muted"><?php esc_html_e('Search by name', 'ams-wc-amazon'); ?></small>
                                </div>
                            </label>

                            <input type="radio" class="btn-check" name="wca_search_by" id="asin" value="asin">
                            <label class="btn btn-outline-info btn-lg d-flex align-items-center justify-content-center py-3" for="asin">
                                <i class="bi bi-upc-scan fs-5 me-2"></i>
                                <div class="text-start">
                                    <div class="fw-bold"><?php esc_html_e('ASIN Codes', 'ams-wc-amazon'); ?></div>
                                    <small class="text-muted"><?php esc_html_e('Import by ID', 'ams-wc-amazon'); ?></small>
                                </div>
                            </label>

                            <input type="radio" class="btn-check" name="wca_search_by" id="csv" value="csv">
                            <label class="btn btn-outline-success btn-lg d-flex align-items-center justify-content-center py-3" for="csv">
                                <i class="bi bi-file-earmark-spreadsheet fs-5 me-2"></i>
                                <div class="text-start">
                                    <div class="fw-bold"><?php esc_html_e('CSV Import', 'ams-wc-amazon'); ?></div>
                                    <small class="text-muted"><?php esc_html_e('Bulk upload', 'ams-wc-amazon'); ?></small>
                                </div>
                            </label>
                        </div>

                        <!-- Recent Searches Section -->
                        <div id="recent-searches-section" class="mb-3">
                            <div class="d-flex align-items-center justify-content-between mb-2">
                                <h6 class="mb-0 text-muted fw-semibold">
                                    <i class="bi bi-clock-history me-1"></i>
                                    <?php esc_html_e('Recent Searches', 'ams-wc-amazon'); ?>
                                </h6>
                                <button type="button" class="btn btn-outline-secondary btn-sm" id="clear-recent-searches">
                                    <i class="bi bi-trash3 me-1"></i>
                                    <?php esc_html_e('Clear All', 'ams-wc-amazon'); ?>
                                </button>
                            </div>
                            <div id="recent-searches-container" class="d-flex flex-wrap gap-2 mb-2">
                                <!-- Recent search tags will be inserted here -->
                                <span class="badge bg-light text-dark border px-2 py-1 recent-search-tag" data-type="keyword" data-value="wireless headphones" data-category="" data-sort="Relevance">
                                    <i class="bi bi-search me-1"></i>wireless headphones
                                    <button type="button" class="btn-close btn-close-sm ms-2" style="font-size: 0.6em;"></button>
                                </span>
                                <span class="badge bg-light text-dark border px-2 py-1 recent-search-tag" data-type="asin" data-value="B08N5WRWNW">
                                    <i class="bi bi-upc-scan me-1"></i>B08N5WRWNW
                                    <button type="button" class="btn-close btn-close-sm ms-2" style="font-size: 0.6em;"></button>
                                </span>
                                <span class="badge bg-light text-dark border px-2 py-1 recent-search-tag" data-type="keyword" data-value="bluetooth speaker" data-category="Electronics" data-sort="Price:HighToLow">
                                    <i class="bi bi-search me-1"></i>bluetooth speaker
                                    <button type="button" class="btn-close btn-close-sm ms-2" style="font-size: 0.6em;"></button>
                                </span>
                            </div>
                            <div id="show-more-searches" class="text-center" style="display: none;">
                                <button type="button" class="btn btn-link btn-sm text-decoration-none p-0 text-muted" id="toggle-more-searches">
                                    <i class="bi bi-chevron-down me-1"></i>
                                    <?php esc_html_e('Show More', 'ams-wc-amazon'); ?> (<span id="hidden-searches-count">0</span>)
                                </button>
                            </div>
                        </div>
                
                                                    <!-- Search Content Areas -->
                        <div id="search-content">
                            
                            <!-- Keyword Search -->
                            <div id="keyword-content" class="search-box">
                                        <div class="input-group">
                                            <span class="input-group-text"><i class="bi bi-search"></i></span>
                                            <input name="keyword" class="form-control" placeholder="<?php esc_attr_e('Enter product keywords...', 'ams-wc-amazon'); ?>" type="text">
                                    <select name="ams_amazon_cat" id="ams_amazon_cat" class="form-select" style="max-width: 200px;">
                                            <option value=""><?php esc_html_e('All Categories', 'ams-wc-amazon'); ?></option>
                                            <?php
                                            foreach ($this->get_amazon_cat() as $key => $value) {
                                                echo '<option value="' . esc_attr($key) . '">' . esc_html($value) . '</option>';
                                            }
                                            ?>
                                        </select>
                                                                        <select name="sort_by" id="sort_by" class="form-select" style="max-width: 180px;">
                                            <option value="Relevance"><?php esc_html_e('Relevance', 'ams-wc-amazon'); ?></option>
                                            <option value="AvgCustomerReviews"><?php esc_html_e('Customer Reviews', 'ams-wc-amazon'); ?></option>
                                            <option value="Featured"><?php esc_html_e('Featured', 'ams-wc-amazon'); ?></option>
                                            <option value="NewestArrivals"><?php esc_html_e('Newest Arrivals', 'ams-wc-amazon'); ?></option>
                                        <option value="Price:LowToHigh"><?php esc_html_e('Price: Low to High', 'ams-wc-amazon'); ?></option>
                                            <option value="Price:HighToLow"><?php esc_html_e('Price: High to Low', 'ams-wc-amazon'); ?></option>
                                        </select>
                                    </div>
                                
                                <!-- PA-API 5 Supported Filters -->
                                <div class="mt-3">
                                    <div class="d-flex align-items-center justify-content-between mb-2">
                                        <button type="button" class="btn btn-link btn-sm text-decoration-none p-0 text-muted" id="toggle-api-filters">
                                            <i class="bi bi-chevron-right me-1" id="api-filters-icon"></i>
                                            <i class="bi bi-sliders me-1"></i><?php esc_html_e('Advanced Filters', 'ams-wc-amazon'); ?>
                                        </button>
                                        <small class="text-muted"><?php esc_html_e('PA-API 5', 'ams-wc-amazon'); ?></small>
                                    </div>
                                    
                                    <div class="collapse" id="api-filters-panel">
                                        <!-- PA-API 5 Filter Controls -->
                                        <div class="row g-2 mb-3">
                                            <!-- Brand Filter -->
                                            <div class="col-md-3">
                                                <label class="form-label small fw-semibold"><?php esc_html_e('Brand', 'ams-wc-amazon'); ?></label>
                                                <input type="text" name="api_brand" class="form-control form-control-sm" placeholder="<?php esc_attr_e('e.g., Samsung, Apple', 'ams-wc-amazon'); ?>">
                                            </div>
                                            
                                            <!-- Price Range -->
                                            <div class="col-md-3">
                                                <label class="form-label small fw-semibold"><?php esc_html_e('Price Range (€)', 'ams-wc-amazon'); ?></label>
                                                <div class="d-flex gap-1">
                                                    <input type="number" name="api_min_price" class="form-control form-control-sm" placeholder="Min" step="0.01">
                                                    <span class="align-self-center text-muted">-</span>
                                                    <input type="number" name="api_max_price" class="form-control form-control-sm" placeholder="Max" step="0.01">
                                                </div>
                                            </div>
                                            
                                            <!-- Condition -->
                                            <div class="col-md-3">
                                                <label class="form-label small fw-semibold"><?php esc_html_e('Condition', 'ams-wc-amazon'); ?></label>
                                                <select name="api_condition" class="form-select form-select-sm">
                                                    <option value=""><?php esc_html_e('All Conditions', 'ams-wc-amazon'); ?></option>
                                                    <option value="New"><?php esc_html_e('New', 'ams-wc-amazon'); ?></option>
                                                    <option value="Used"><?php esc_html_e('Used', 'ams-wc-amazon'); ?></option>
                                                    <option value="Collectible"><?php esc_html_e('Collectible', 'ams-wc-amazon'); ?></option>
                                                    <option value="Refurbished"><?php esc_html_e('Refurbished', 'ams-wc-amazon'); ?></option>
                                                </select>
                                            </div>
                                            
                                            <!-- Delivery Flags -->
                                            <div class="col-md-3">
                                                <label class="form-label small fw-semibold"><?php esc_html_e('Delivery', 'ams-wc-amazon'); ?></label>
                                                <select name="api_delivery_flags" class="form-select form-select-sm">
                                                    <option value=""><?php esc_html_e('All Products', 'ams-wc-amazon'); ?></option>
                                                    <option value="Prime"><?php esc_html_e('Prime Eligible', 'ams-wc-amazon'); ?></option>
                                                    <option value="FreeShipping"><?php esc_html_e('Free Shipping', 'ams-wc-amazon'); ?></option>
                                                </select>
                                            </div>
                                        </div>
                                        
                                        <!-- Client-Side Quick Filters -->
                                        <div class="mb-2">
                                            <small class="text-muted mb-2 d-block"><?php esc_html_e('Quick Filters (applied to current results)', 'ams-wc-amazon'); ?></small>
                                            <div class="d-flex flex-wrap gap-2">
                                                <button type="button" class="btn btn-outline-success btn-sm rounded-pill filter-pill" data-filter="discount" data-value="20">
                                                    <i class="bi bi-percent me-1"></i>20%+ <?php esc_html_e('Off', 'ams-wc-amazon'); ?>
                                                </button>
                                                <button type="button" class="btn btn-outline-info btn-sm rounded-pill filter-pill" data-filter="trending" data-value="1">
                                                    <i class="bi bi-graph-up me-1"></i><?php esc_html_e('Trending', 'ams-wc-amazon'); ?>
                                                </button>
                                                <button type="button" class="btn btn-outline-secondary btn-sm rounded-pill" id="clear-client-filters">
                                                    <i class="bi bi-x-circle me-1"></i><?php esc_html_e('Clear Filters', 'ams-wc-amazon'); ?>
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <!-- API Settings -->
                                    <div class="mt-3 pt-2 border-top">
                                        <div class="d-flex align-items-center justify-content-between mb-2">
                                            <button type="button" class="btn btn-link btn-sm text-decoration-none p-0 text-muted" id="toggle-api-settings">
                                                <i class="bi bi-chevron-right me-1" id="api-settings-icon"></i>
                                                <i class="bi bi-gear me-1"></i><?php esc_html_e('API Settings', 'ams-wc-amazon'); ?>
                                            </button>
                                        </div>
                                        
                                        <div class="collapse" id="api-settings-panel">
                                            <div class="row g-2 mb-2">
                                                <div class="col-md-4">
                                                    <label class="form-label small fw-semibold"><?php esc_html_e('Results Per Page', 'ams-wc-amazon'); ?></label>
                                                    <select name="products_per_page" class="form-select form-select-sm" id="products-per-page-setting">
                                                        <option value="5" <?php selected(get_option('ams_product_per_page', 10), 5); ?>>5 <?php esc_html_e('Products', 'ams-wc-amazon'); ?></option>
                                                        <option value="10" <?php selected(get_option('ams_product_per_page', 10), 10); ?>>10 <?php esc_html_e('Products', 'ams-wc-amazon'); ?></option>
                                                    </select>
                                                    <small class="text-muted"><?php esc_html_e('Max 10 per request', 'ams-wc-amazon'); ?></small>
                                                </div>
                                                <div class="col-md-4">
                                                    <label class="form-label small fw-semibold"><?php esc_html_e('Auto-Load More', 'ams-wc-amazon'); ?></label>
                                                    <select name="auto_load_more" class="form-select form-select-sm" id="auto-load-more-setting">
                                                        <option value="0" <?php selected(get_option('ams_auto_load_more', 0), 0); ?>><?php esc_html_e('Disabled', 'ams-wc-amazon'); ?></option>
                                                        <option value="1" <?php selected(get_option('ams_auto_load_more', 0), 1); ?>><?php esc_html_e('Enabled', 'ams-wc-amazon'); ?></option>
                                                    </select>
                                                    <small class="text-muted"><?php esc_html_e('Auto-scroll loading', 'ams-wc-amazon'); ?></small>
                                                </div>
                                                <div class="col-md-4">
                                                    <label class="form-label small fw-semibold"><?php esc_html_e('Max Pages', 'ams-wc-amazon'); ?></label>
                                                    <select name="max_pages" class="form-select form-select-sm" id="max-pages-setting">
                                                        <option value="1" <?php selected(get_option('ams_max_pages', 3), 1); ?>>1 <?php esc_html_e('Page', 'ams-wc-amazon'); ?></option>
                                                        <option value="2" <?php selected(get_option('ams_max_pages', 3), 2); ?>>2 <?php esc_html_e('Pages', 'ams-wc-amazon'); ?></option>
                                                        <option value="3" <?php selected(get_option('ams_max_pages', 3), 3); ?>>3 <?php esc_html_e('Pages', 'ams-wc-amazon'); ?></option>
                                                        <option value="5" <?php selected(get_option('ams_max_pages', 3), 5); ?>>5 <?php esc_html_e('Pages', 'ams-wc-amazon'); ?></option>
                                                        <option value="10" <?php selected(get_option('ams_max_pages', 3), 10); ?>>10 <?php esc_html_e('Pages', 'ams-wc-amazon'); ?></option>
                                                    </select>
                                                    <small class="text-muted"><?php esc_html_e('10 products × pages', 'ams-wc-amazon'); ?></small>
                                                </div>
                                            </div>
                                            
                                            <div class="d-flex gap-2">
                                                <button type="button" class="btn btn-primary btn-sm" id="save-api-settings">
                                                    <i class="bi bi-check2 me-1"></i><?php esc_html_e('Save', 'ams-wc-amazon'); ?>
                                                </button>
                                                <button type="button" class="btn btn-outline-secondary btn-sm" id="reset-api-settings">
                                                    <i class="bi bi-arrow-clockwise me-1"></i><?php esc_html_e('Reset', 'ams-wc-amazon'); ?>
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                            </div>
                            
                                                                    <!-- ASIN Search -->
                            <div id="asin-content" class="search-box" style="display: none;">
                                <div class="row justify-content-center">
                                    <div class="col-lg-8">
                                        <div class="input-group">
                                            <span class="input-group-text"><i class="bi bi-upc"></i></span>
                                            <textarea name="asin_id" class="form-control" rows="3" placeholder="<?php esc_attr_e('Enter ASIN numbers separated by commas (e.g., B0813RK123, B08G8BT456)', 'ams-wc-amazon'); ?>"></textarea>
                                        </div>
                                        <div class="form-text text-center mt-2">
                                            <i class="bi bi-info-circle me-1"></i>
                                            <?php esc_html_e('Separate multiple ASINs with commas for batch import', 'ams-wc-amazon'); ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                                                                    <!-- CSV Import -->
                            <div id="csv-content" class="search-box" style="display: none;">
                                <div class="row justify-content-center">
                                    <div class="col-lg-8">
                                        <div class="input-group mb-3">
                                            <input type="file" class="form-control" id="csv" name="csv" accept=".csv">
                                            <label class="input-group-text bg-primary text-white" for="csv">
                                                <i class="bi bi-upload me-1"></i><?php esc_html_e('Choose File', 'ams-wc-amazon'); ?>
                                            </label>
                                        </div>
                                        <div class="text-center">
                                            <a href="<?php echo AMS_PLUGIN_URL; ?>templates/sample-data/sample-data.csv" target="_blank" class="btn btn-outline-primary btn-sm">
                                                <i class="bi bi-download me-1"></i><?php esc_html_e('Download Sample CSV', 'ams-wc-amazon'); ?>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                                                </div>

                        <!-- Search Action Button -->
                        <div class="text-center mt-3 pt-2 border-top">
                            <input type="hidden" name="action" id="action" value="search_products">
                            <?php wp_nonce_field('wca_search_product'); ?>
                            <button type="submit" id="submit-button" class="btn btn-primary px-4 py-2">
                                <i class="bi bi-search me-2"></i>
                                <?php esc_html_e('Search Products', 'ams-wc-amazon'); ?>
                            </button>
                        </div>
                    </form>
                    </div>
                </div>
            </div>

                                    <!-- Results Section -->
            <div class="product_cards d-none mt-3">
                <div class="card shadow-sm ams-common-card-fix">
                    <div class="card-header bg-white border-bottom">
                        <div class="d-flex align-items-center justify-content-between">
                            <div class="d-flex align-items-center">
                                <i class="bi bi-grid-3x3-gap-fill text-primary me-2 fs-5"></i>
                                <div>
                                    <h5 class="mb-0 fw-bold text-dark"><?php esc_html_e('Search Results', 'ams-wc-amazon'); ?></h5>
                                    <small class="text-muted" id="results-count">0 <?php esc_html_e('products found', 'ams-wc-amazon'); ?></small>
                    </div>
                            </div>
                            <div class="d-flex align-items-center gap-2">
                                <!-- View Toggle - Simplified -->
                                <div class="btn-group btn-group-sm" role="group">
                                    <button type="button" class="btn btn-outline-secondary active" id="grid-view-btn" title="<?php esc_attr_e('Grid View', 'ams-wc-amazon'); ?>">
                                        <i class="bi bi-grid-3x3-gap"></i>
                                    </button>
                                    <button type="button" class="btn btn-outline-secondary" id="list-view-btn" title="<?php esc_attr_e('List View', 'ams-wc-amazon'); ?>">
                                        <i class="bi bi-list"></i>
                                    </button>
                                </div>
                                <!-- Sort Options -->
                                <select class="form-select form-select-sm w-auto" id="results-sort">
                                    <option value="relevance"><?php esc_html_e('Sort by Relevance', 'ams-wc-amazon'); ?></option>
                                    <option value="price-low"><?php esc_html_e('Price: Low to High', 'ams-wc-amazon'); ?></option>
                                    <option value="price-high"><?php esc_html_e('Price: High to Low', 'ams-wc-amazon'); ?></option>
                                    <option value="rating"><?php esc_html_e('Customer Rating', 'ams-wc-amazon'); ?></option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="card-body p-0">
                        <!-- Search Summary Bar -->
                        <div class="bg-light bg-opacity-50 p-3 border-bottom" id="search-summary" style="display: none;">
                            <div class="d-flex align-items-center justify-content-between">
                                <div class="d-flex align-items-center gap-3">
                                    <span class="badge bg-primary px-3 py-2" id="search-term-badge">
                                        <i class="bi bi-search me-1"></i>
                                        <span id="current-search-term"></span>
                                    </span>
                                    <small class="text-muted" id="search-time"></small>
                                </div>
                                <button type="button" class="btn btn-outline-primary btn-sm" id="refine-search">
                                    <i class="bi bi-funnel me-1"></i>
                                    <?php esc_html_e('Refine Search', 'ams-wc-amazon'); ?>
                                </button>
                            </div>
                        </div>
                        
                        <!-- Results Container -->
                        <div class="p-3">
                            <div class="row wca-amazon-product g-3 grid-view" id="products-grid">
                                <!-- Product cards will be dynamically inserted here via AJAX -->
                            </div>
                            
                            <!-- Empty State -->
                            <div class="text-center py-5" id="empty-state" style="display: none;">
                                <div class="mb-3">
                                    <i class="bi bi-search text-muted" style="font-size: 3rem;"></i>
                                </div>
                                <h5 class="text-muted mb-2"><?php esc_html_e('No products found', 'ams-wc-amazon'); ?></h5>
                                <p class="text-muted mb-3"><?php esc_html_e('Try adjusting your search terms or browse different categories', 'ams-wc-amazon'); ?></p>
                                <button type="button" class="btn btn-outline-primary" id="clear-search">
                                    <i class="bi bi-arrow-clockwise me-1"></i>
                                    <?php esc_html_e('Start New Search', 'ams-wc-amazon'); ?>
                                </button>
                        </div>
                        
                        <!-- Loading State -->
                            <div class="text-center py-5" id="loading-state">
                            <div class="wca-loading-icon" style="display:none;">
                                    <div class="d-flex flex-column align-items-center">
                                        <div class="spinner-border text-primary mb-3" role="status" style="width: 3rem; height: 3rem;">
                                    <span class="visually-hidden"><?php esc_html_e('Loading...', 'ams-wc-amazon'); ?></span>
                                </div>
                                        <h5 class="text-primary mb-2"><?php esc_html_e('Searching Amazon...', 'ams-wc-amazon'); ?></h5>
                                        <p class="text-muted mb-0"><?php esc_html_e('Finding the best products for you', 'ams-wc-amazon'); ?></p>
                                        <div class="progress mt-3" style="width: 200px; height: 4px;">
                                            <div class="progress-bar progress-bar-striped progress-bar-animated" role="progressbar" style="width: 100%"></div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- Load More Button -->
                            <div class="text-center mt-4" id="load-more-container" style="display: none;">
                                <button type="button" class="btn btn-outline-primary" id="load-more-results">
                                    <i class="bi bi-plus-circle me-1"></i>
                                    <?php esc_html_e('Load More Products', 'ams-wc-amazon'); ?>
                                </button>
                                <div class="mt-2">
                                    <small class="text-muted" id="load-more-info">
                                        <?php esc_html_e('Page', 'ams-wc-amazon'); ?> <span id="current-page">1</span> <?php esc_html_e('of', 'ams-wc-amazon'); ?> <span id="max-pages-display">1</span>
                                    </small>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php include "common-footer.php"; ?>

<script>
jQuery(document).ready(function($) {
    const storageKey = 'wcaProductSearch';
    const recentSearchesKey = 'wcaRecentSearches';
    const maxRecentSearches = 10;

    // Recent Searches Management
    function getRecentSearches() {
        return JSON.parse(localStorage.getItem(recentSearchesKey)) || [];
    }

    function addRecentSearch(searchData) {
        let searches = getRecentSearches();
        
        // Remove duplicate if exists
        searches = searches.filter(search => 
            !(search.type === searchData.type && search.value === searchData.value)
        );
        
        // Add to beginning
        searches.unshift({
            ...searchData,
            timestamp: Date.now()
        });
        
        // Keep only max items
        searches = searches.slice(0, maxRecentSearches);
        
        localStorage.setItem(recentSearchesKey, JSON.stringify(searches));
        renderRecentSearches();
    }

    function removeRecentSearch(index) {
        let searches = getRecentSearches();
        searches.splice(index, 1);
        localStorage.setItem(recentSearchesKey, JSON.stringify(searches));
        renderRecentSearches();
    }

    function clearAllRecentSearches() {
        localStorage.removeItem(recentSearchesKey);
        renderRecentSearches();
    }

    function renderRecentSearches() {
        const searches = getRecentSearches();
        const container = $('#recent-searches-container');
        const maxVisible = 4; // Show first 4 searches by default
        
        if (searches.length === 0) {
            container.html('<small class="text-muted fst-italic"><?php esc_html_e("No recent searches yet. Start searching to see your history here.", "ams-wc-amazon"); ?></small>');
            $('#show-more-searches').hide();
            $('#clear-recent-searches').hide();
            return;
        }
        
        // Show Clear All button when there are searches
        $('#clear-recent-searches').show();
        
        let html = '';
        searches.forEach((search, index) => {
            const icon = search.type === 'asin' ? 'bi-upc-scan' : 'bi-search';
            const displayValue = search.type === 'keyword' && search.category ? 
                `${search.value} (${search.category})` : search.value;
            
            const isHidden = index >= maxVisible;
            const hiddenClass = isHidden ? 'recent-search-hidden' : '';
            const hiddenStyle = isHidden ? 'display: none;' : '';
            
            html += `
                <span class="badge bg-light text-dark border px-2 py-1 recent-search-tag cursor-pointer ${hiddenClass}" 
                      data-index="${index}"
                      data-type="${search.type}" 
                      data-value="${search.value}"
                      data-category="${search.category || ''}"
                      data-sort="${search.sort || 'Relevance'}"
                      style="${hiddenStyle}"
                      title="<?php esc_attr_e('Click to search again', 'ams-wc-amazon'); ?>">
                    <i class="bi ${icon} me-1"></i>${displayValue}
                    <button type="button" class="btn-close btn-close-sm ms-2 remove-search" 
                            data-index="${index}" style="font-size: 0.6em;"
                            title="<?php esc_attr_e('Remove from history', 'ams-wc-amazon'); ?>"></button>
                </span>
            `;
        });
        
        container.html(html);
        
        // Show/hide the "Show More" button based on number of searches
        const hiddenCount = searches.length - maxVisible;
        if (hiddenCount > 0) {
            $('#hidden-searches-count').text(hiddenCount);
            $('#show-more-searches').show();
        } else {
            $('#show-more-searches').hide();
        }
    }

    function applyRecentSearch(searchData) {
        setActiveTab(searchData.type);
        
        if (searchData.type === 'keyword') {
            $('[name="keyword"]').val(searchData.value);
            $('#ams_amazon_cat').val(searchData.category || '');
            $('#sort_by').val(searchData.sort || 'Relevance');
        } else if (searchData.type === 'asin') {
            $('[name="asin_id"]').val(searchData.value);
        }
        
        saveState(searchData.type, getTabContent(searchData.type));
    }

    // State Management
    function saveState(tab, content) {
        localStorage.setItem(storageKey, JSON.stringify({ tab, content }));
    }

    function loadState() {
        const state = JSON.parse(localStorage.getItem(storageKey)) || { tab: 'keyword', content: {} };
        setActiveTab(state.tab);
        if (state.content) {
            Object.keys(state.content).forEach(key => {
                $(`[name="${key}"]`).val(state.content[key]);
            });
        }
    }

    function setActiveTab(tab) {
        $(`#${tab}`).prop('checked', true);
        $('.search-box').hide();
        $(`#${tab}-content`).show();
        updateSubmitButton(tab);
    }

    function updateSubmitButton(tab) {
        const isCSV = tab === 'csv';
        $('#submit-button').html(`<i class="bi bi-${isCSV ? 'upload' : 'search'} me-2"></i> ${isCSV ? '<?php esc_html_e("Import", "ams-wc-amazon"); ?>' : '<?php esc_html_e("Search", "ams-wc-amazon"); ?>'} <?php esc_html_e("Products", "ams-wc-amazon"); ?>`);
        $('#csv').attr('required', isCSV);
        $('#action').val(isCSV ? 'import_products' : 'search_products');
        $('#wca-product-search').attr('enctype', isCSV ? 'multipart/form-data' : null)
            .toggleClass('wca-product-import', isCSV)
            .toggleClass('wca-product-search', !isCSV);
    }

    function getTabContent(tab) {
        switch(tab) {
            case 'keyword':
                return {
                    ams_amazon_cat: $('#ams_amazon_cat').val(),
                    keyword: $('[name="keyword"]').val(),
                    sort_by: $('#sort_by').val()
                };
            case 'asin':
                return { asin_id: $('[name="asin_id"]').val() };
            default:
                return {};
        }
    }

    // Helper functions for CSV import
    function showResults() {
        $('#search-results').removeClass('d-none');
        $('#empty-state').hide();
    }

    function showLoadingState(message) {
        $('#products-grid').html(`
            <div class="col-12 text-center py-5">
                <div class="spinner-border text-primary mb-3" role="status">
                    <span class="visually-hidden">Loading...</span>
                </div>
                <h5 class="text-muted" id="loading-message">${message}</h5>
            </div>
        `);
    }

    function hideLoadingState() {
        $('#products-grid .col-12.text-center.py-5').remove();
    }

    function updateLoadingMessage(message) {
        $('#loading-message').text(message);
    }

    // Results UI Management
    
    // Count and update results on page load
    function countAndUpdateResults() {
        const $grid = $('#products-grid');
        
        // Try different selectors to find products
        const productCount1 = $('#products-grid .col-xl-3').length;
        const productCount2 = $('#products-grid .col-lg-4').length;
        const productCount3 = $('#products-grid .col-md-6').length;
        const productCount4 = $('#products-grid .col-12').length;
        const productCountAll = $('#products-grid .col-xl-3, #products-grid .col-lg-4, #products-grid .col-md-6, #products-grid .col-12').length;
        const productCountCards = $('#products-grid .card').length;
        const productCountAny = $('#products-grid > div').length;
        
        const productCount = productCountAll;
        updateResultsCount(productCount);
        
        // Also show/hide results section based on count
        if (productCount > 0) {
            $('.product_cards').removeClass('d-none').show();
            
            // Show load more button if max pages > 1 and we have results
            const maxPages = parseInt($('#max-pages-setting').val()) || 1;
            if (maxPages > 1 && productCount > 0) {
                $('#load-more-container').show();
                $('#current-page').text('1');
                $('#max-pages-display').text(maxPages);
                $('#load-more-results').prop('disabled', false).html('<i class="bi bi-plus-circle me-1"></i><?php esc_html_e("Load More Products", "ams-wc-amazon"); ?>');
                
                // Initialize current search data for load more functionality
                const tab = $('input[name="wca_search_by"]:checked').val() || 'keyword';
                if (tab === 'keyword') {
                    currentSearchData = {
                        type: 'keyword',
                        keyword: $('[name="keyword"]').val(),
                        category: $('#ams_amazon_cat').val(),
                        sort: $('#sort_by').val(),
                        filters: {
                            api_brand: $('[name="api_brand"]').val(),
                            api_min_price: $('[name="api_min_price"]').val(),
                            api_max_price: $('[name="api_max_price"]').val(),
                            api_condition: $('[name="api_condition"]').val(),
                            api_delivery_flags: $('[name="api_delivery_flags"]').val()
                        }
                    };
                }
                currentPage = 1; // Reset to page 1
            } else {
                $('#load-more-container').hide();
            }
        } else {
            $('.product_cards').addClass('d-none').hide();
            $('#load-more-container').hide();
        }
    }
    
    // Enhanced count function that waits for DOM to be fully ready
    function countResultsWithDelay() {
        // Try immediately
        countAndUpdateResults();
        
        // Try again after a short delay to catch any dynamically loaded content
        setTimeout(() => {
            countAndUpdateResults();
        }, 100);
        setTimeout(() => {
            countAndUpdateResults();
        }, 500);
        setTimeout(() => {
            countAndUpdateResults();
        }, 1000);
    }

    function showSearchSummary(searchTerm, searchType) {
        const icon = searchType === 'asin' ? 'bi-upc-scan' : 'bi-search';
        $('#search-term-badge').html(`<i class="bi ${icon} me-1"></i>${searchTerm}`);
        $('#search-time').text(`<?php esc_html_e("Searched at", "ams-wc-amazon"); ?> ${new Date().toLocaleTimeString()}`);
        $('#search-summary').show();
    }

    // Event Listeners
    
    // Initial load
    loadState();
    renderRecentSearches();
    
    // Validate API credentials on page load
    <?php if(!$api_missing) { ?>
    validateApiCredentials();
    <?php } ?>

    // Tab switching
    $('input[name="wca_search_by"]').change(function() {
        const tab = $(this).val();
        setActiveTab(tab);
        saveState(tab, getTabContent(tab));
    });

    // Form submission
    $('#wca-product-search').submit(function(e) {
        e.preventDefault(); // Prevent page reload
        
        // Check if API is configured
        <?php if($api_missing) { ?>
        showToast('<?php esc_html_e("Please configure your Amazon API credentials first", "ams-wc-amazon"); ?>', 'warning');
        return false;
        <?php } else { ?>
        <?php } ?>
        
        const tab = $('input[name="wca_search_by"]:checked').val();
        
        // Validation for keyword search
        if (tab === 'keyword') {
            if ($('select[name=ams_amazon_cat]').val() === '' || $('input[name=keyword]').val() === '') {
                if (typeof showToast === 'function') {
                    showToast('Both the keyword and category are required fields.', 'error');
                }
                return false;
            }
        } else if (tab === 'asin') {
            if ($('input[name=asin_id]').val() === '') {
                if (typeof showToast === 'function') {
                    showToast('ASIN Number is required.', 'error');
                }
                return false;
            }
        }
        const content = getTabContent(tab);
        
        // Sync PA-API 5 filter values to hidden fields for keyword search
        if (tab === 'keyword') {
            const apiBrand = $('[name="api_brand"]').val();
            const apiMinPrice = $('[name="api_min_price"]').val();
            const apiMaxPrice = $('[name="api_max_price"]').val();
            const apiCondition = $('[name="api_condition"]').val();
            const apiDeliveryFlags = $('[name="api_delivery_flags"]').val();
            
            // Create hidden fields if they don't exist
            if ($('#hidden_api_brand').length === 0) {
                $(this).append('<input type="hidden" name="api_brand" id="hidden_api_brand">');
                $(this).append('<input type="hidden" name="api_min_price" id="hidden_api_min_price">');
                $(this).append('<input type="hidden" name="api_max_price" id="hidden_api_max_price">');
                $(this).append('<input type="hidden" name="api_condition" id="hidden_api_condition">');
                $(this).append('<input type="hidden" name="api_delivery_flags" id="hidden_api_delivery_flags">');
            }
            
            // Set values
            $('#hidden_api_brand').val(apiBrand);
            $('#hidden_api_min_price').val(apiMinPrice);
            $('#hidden_api_max_price').val(apiMaxPrice);
            $('#hidden_api_condition').val(apiCondition);
            $('#hidden_api_delivery_flags').val(apiDeliveryFlags);
        }
        
        // Add to recent searches (except CSV)
        if (tab !== 'csv' && (content.keyword || content.asin_id)) {
            const searchData = {
                type: tab,
                value: tab === 'keyword' ? content.keyword : content.asin_id,
                category: tab === 'keyword' ? content.ams_amazon_cat : undefined,
                sort: tab === 'keyword' ? content.sort_by : undefined
            };
            
            if (searchData.value.trim()) {
                addRecentSearch(searchData);
                showSearchSummary(searchData.value, searchData.type);
                
                // Store current search data for load more functionality
                if (tab === 'keyword') {
                    currentSearchData = {
                        type: 'keyword',
                        keyword: content.keyword,
                        category: content.ams_amazon_cat,
                        sort: content.sort_by,
                        filters: {
                            api_brand: $('[name="api_brand"]').val(),
                            api_min_price: $('[name="api_min_price"]').val(),
                            api_max_price: $('[name="api_max_price"]').val(),
                            api_condition: $('[name="api_condition"]').val(),
                            api_delivery_flags: $('[name="api_delivery_flags"]').val()
                        }
                    };
                    currentPage = 1; // Reset page counter
                    
                    // Show load more button if max pages > 1
                    const maxPages = parseInt($('#max-pages-setting').val()) || 1;
                    if (maxPages > 1) {
                        $('#load-more-container').show();
                        $('#current-page').text('1');
                        $('#max-pages-display').text(maxPages);
                        $('#load-more-results').prop('disabled', false).html('<i class="bi bi-plus-circle me-1"></i><?php esc_html_e("Load More Products", "ams-wc-amazon"); ?>');
                    } else {
                        $('#load-more-container').hide();
                    }
                }
            }
        }
        
        saveState(tab, content);
        
        // Remove filter indicator since search is being executed
        $('#filter-indicator').remove();
        
        // Show results container and loading state
        $('.product_cards').removeClass('d-none').show();
        showLoadingState('Searching for products...');
        
        // Prepare AJAX data based on search type
        let ajaxData = {
            action: 'search_products',
            wca_search_by: tab,
            _wpnonce: $('input[name="_wpnonce"]').val()
        };
        
        // Add specific data based on search type
        if (tab === 'keyword') {
            ajaxData.wca_keyword = content.keyword;
            ajaxData.wca_amazon_cat = content.ams_amazon_cat;
            ajaxData.wca_sort_by = content.sort_by;
            ajaxData.wca_item_page = 1;
            
            // Add PA-API 5 filters
            ajaxData.api_brand = $('[name="api_brand"]').val();
            ajaxData.api_min_price = $('[name="api_min_price"]').val();
            ajaxData.api_max_price = $('[name="api_max_price"]').val();
            ajaxData.api_condition = $('[name="api_condition"]').val();
            ajaxData.api_delivery_flags = $('[name="api_delivery_flags"]').val();
        } else if (tab === 'asin') {
            ajaxData.asin_id = content.asin_id;
        } else if (tab === 'csv') {
            // CSV is handled separately, don't make AJAX call
            return;
        }
        

        
        // Make AJAX call
        $.ajax({
            url: amsbackend.ajax_url,
            type: 'POST',
            data: ajaxData,
            success: function(response) {
                if (response && response.trim()) {
                    // Replace loading spinner with results
                    $('#products-grid').html(response);
                    
                    // Show results container and update count
                    $('.product_cards').removeClass('d-none').show();
                    countAndUpdateResults();
                    
                    // Apply saved view preference
                    setTimeout(() => {
                        restoreViewPreference();
                    }, 100);
                } else {
                    // No results found
                    $('#products-grid').html('<div class="col-12"><div class="text-center py-5"><i class="bi bi-search fs-1 text-muted mb-3"></i><h5 class="text-muted"><?php esc_html_e("No products found", "ams-wc-amazon"); ?></h5><p class="text-muted"><?php esc_html_e("Try different keywords or adjust your filters", "ams-wc-amazon"); ?></p></div></div>');
                    $('.product_cards').removeClass('d-none').show();
                    updateResultsCount(0);
                }
            },
            error: function(xhr, status, error) {
                $('#products-grid').html('<div class="col-12"><div class="alert alert-danger"><i class="bi bi-exclamation-triangle me-2"></i><?php esc_html_e("Search failed. Please try again.", "ams-wc-amazon"); ?></div></div>');
                $('.product_cards').removeClass('d-none').show();
                updateResultsCount(0);
            }
        });
    });

    // Handle CSV import success - Process ASINs automatically
    $(document).on('wca_csv_import_success', function(event, asinChunks) {
        if (asinChunks && asinChunks.length > 0) {
            // Show results section
            showResults();
            
            // Show loading state
            showLoadingState('Processing ' + asinChunks.flat().length + ' ASINs from CSV...');
            
            // Process each chunk of ASINs
            processCSVChunks(asinChunks, 0);
        }
    });

    // Process CSV ASIN chunks sequentially
    function processCSVChunks(chunks, chunkIndex) {
        if (chunkIndex >= chunks.length) {
            hideLoadingState();
            return;
        }

        const currentChunk = chunks[chunkIndex];
        const asinString = currentChunk.join(',');
        
        // Update loading message
        updateLoadingMessage(`Processing chunk ${chunkIndex + 1} of ${chunks.length}...`);

        // Make AJAX call to get products for this chunk
        $.ajax({
            url: amsbackend.ajax_url,
            type: 'POST',
            data: {
                action: 'search_products',
                wca_search_by: 'asin',
                asin_id: asinString,
                _wpnonce: $('#_wpnonce').val()
            },
            success: function(response) {
                if (response) {
                    // Append products to results
                    $('#products-grid').append(response);
                    
                    // Update results count
                    const currentCount = $('#products-grid .col-xl-3').length;
                    updateResultsCount(currentCount);
                }
                
                // Process next chunk after a short delay
                setTimeout(() => {
                    processCSVChunks(chunks, chunkIndex + 1);
                }, 500);
            },
            error: function() {
                console.error('Error processing ASIN chunk:', currentChunk);
                // Continue with next chunk even if this one fails
                setTimeout(() => {
                    processCSVChunks(chunks, chunkIndex + 1);
                }, 500);
            }
        });
    }

    // Form field changes
    $('#ams_amazon_cat, [name="keyword"], #sort_by, [name="asin_id"]').change(function() {
        const tab = $('input[name="wca_search_by"]:checked').val();
        saveState(tab, getTabContent(tab));
    });

    // Recent searches interactions
    $(document).on('click', '.recent-search-tag', function(e) {
        if ($(e.target).hasClass('remove-search') || $(e.target).hasClass('btn-close')) {
            return; // Don't trigger search if remove button clicked
        }
        
        const searchData = {
            type: $(this).data('type'),
            value: $(this).data('value'),
            category: $(this).data('category'),
            sort: $(this).data('sort')
        };
        
        applyRecentSearch(searchData);
    });

    $(document).on('click', '.remove-search', function(e) {
        e.stopPropagation();
        const index = $(this).data('index');
        removeRecentSearch(index);
    });

    $('#clear-recent-searches').click(function() {
        if (confirm('<?php esc_html_e("Are you sure you want to clear all recent searches?", "ams-wc-amazon"); ?>')) {
            clearAllRecentSearches();
        }
    });

    // Results view toggle - Simple Bootstrap 5 approach
    $('#grid-view-btn, #list-view-btn').click(function() {
        const isListView = $(this).attr('id') === 'list-view-btn';
        const $grid = $('#products-grid');
        const $gridCols = $grid.find('.col-xl-3, .col-lg-4, .col-md-6, .col-12');
        
        // Update button states
        $('#grid-view-btn, #list-view-btn').removeClass('active');
        $(this).addClass('active');
        
        if (isListView) {
            // Switch to list view - make cards full width and horizontal
            $gridCols.removeClass('col-xl-3 col-lg-4 col-md-6').addClass('col-12');
            
            // Make cards horizontal using Bootstrap flex classes
            $grid.find('.card').each(function() {
                const $card = $(this);
                const $imageContainer = $card.find('.position-relative').first();
                const $cardBody = $card.find('.card-body');
                
                // Make card horizontal with proper layout
                $card.addClass('d-flex flex-row align-items-stretch');
                
                // Image container - fixed width and height
                $imageContainer.removeClass('d-flex align-items-center justify-content-center')
                              .addClass('flex-shrink-0 d-flex align-items-center justify-content-center border-end')
                              .css({'height': '140px', 'width': '140px', 'min-width': '140px'});
                
                // Card body - flexible with better spacing
                $cardBody.addClass('flex-fill d-flex flex-column justify-content-between')
                         .css({'min-height': '140px'});
                
                // Reorganize content for horizontal layout
                const $title = $cardBody.find('.card-title');
                const $brand = $cardBody.find('.badge.bg-light.text-dark.border').parent();
                const $rating = $cardBody.find('.d-flex.align-items-center.mb-2').first();
                const $price = $cardBody.find('.d-flex.align-items-center.justify-content-between.mb-2');
                const $availability = $cardBody.find('.mb-2').has('.text-warning');
                const $actions = $cardBody.find('.d-flex.align-items-center.justify-content-between.mb-3');
                const $importBtn = $cardBody.find('.mt-auto');
                
                // Create horizontal layout structure
                const $leftContent = $('<div class="flex-fill pe-3"></div>');
                const $rightContent = $('<div class="d-flex flex-column justify-content-between" style="min-width: 200px;"></div>');
                
                // Move content to left side
                if ($brand.length) $leftContent.append($brand);
                if ($title.length) $leftContent.append($title);
                if ($rating.length) $leftContent.append($rating);
                if ($availability.length) $leftContent.append($availability);
                
                // Move content to right side
                if ($price.length) $rightContent.append($price);
                if ($actions.length) $rightContent.append($actions);
                if ($importBtn.length) $rightContent.append($importBtn);
                
                // Clear card body and add new structure
                $cardBody.empty().append($leftContent).append($rightContent);
            });
        } else {
            // Switch to grid view - restore original layout
            $gridCols.removeClass('col-12').addClass('col-xl-3 col-lg-4 col-md-6');
            
            // Restore vertical card layout
            $grid.find('.card').each(function() {
                const $card = $(this);
                const $imageContainer = $card.find('.position-relative').first();
                const $cardBody = $card.find('.card-body');
                
                // Remove horizontal layout classes and styles
                $card.removeClass('d-flex flex-row align-items-stretch');
                $imageContainer.removeClass('flex-shrink-0 border-end')
                              .addClass('d-flex align-items-center justify-content-center')
                              .css({'height': '200px', 'width': 'auto', 'min-width': 'auto'});
                $cardBody.removeClass('flex-fill d-flex flex-column justify-content-between')
                         .css({'min-height': 'auto'});
                
                // If the card body was restructured, we need to restore it
                // For now, just remove the custom styles - the original structure should work
                $cardBody.find('.flex-fill.pe-3, .d-flex.flex-column.justify-content-between').each(function() {
                    $(this).children().unwrap();
                });
            });
        }
        
        // Save view preference
        const viewMode = isListView ? 'list' : 'grid';
        localStorage.setItem('wcaProductViewMode', viewMode);
        localStorage.setItem('ams_view_mode', viewMode); // Keep both storage keys in sync
    });
    
    // Load saved view preference
    function loadViewPreference() {
        // Check both storage keys and use the most recent one
        const wcaViewMode = localStorage.getItem('wcaProductViewMode');
        const amsViewMode = localStorage.getItem('ams_view_mode');
        
        // Use whichever key has a value, preferring ams_view_mode if both exist
        const savedView = amsViewMode || wcaViewMode || 'grid';
        
        // Sync both storage keys to ensure consistency
        localStorage.setItem('wcaProductViewMode', savedView);
        localStorage.setItem('ams_view_mode', savedView);
        
        const $viewBtn = savedView === 'list' ? $('#list-view-btn') : $('#grid-view-btn');
        $viewBtn.click();
    }
    
    // Initialize view preference on page load
    setTimeout(loadViewPreference, 100);

    // Results sorting
    $('#results-sort').change(function() {
        const sortValue = $(this).val();
        // Add sorting logic here when implementing backend
    });

    // Refine search button
    $('#refine-search').click(function() {
        $('#search-summary').hide();
        $('html, body').animate({
            scrollTop: $('#wca-product-search').offset().top - 100
        }, 500);
    });

    // Clear search button
    $('#clear-search').click(function() {
        $('#wca-product-search')[0].reset();
        $('.product_cards').addClass('d-none');
        $('#search-summary').hide();
        loadState(); // Reset to saved state
    });
    
    // PA-API 5 Filter System
    
    // Client-side quick filter pills (for rating and discount only)
    $('.filter-pill').click(function() {
        const $pill = $(this);
        const filter = $pill.data('filter');
        const value = $pill.data('value');
        
        // Toggle active state
        $pill.toggleClass('active');
        
        if ($pill.hasClass('active')) {
            // Apply client-side filter
            applyClientSideFilter(filter, value);
            $pill.removeClass('btn-outline-success btn-outline-info')
                 .addClass(filter === 'discount' ? 'btn-success' : 'btn-info');
        } else {
            // Remove client-side filter
            removeClientSideFilter(filter);
            $pill.removeClass('btn-success btn-info')
                 .addClass(filter === 'discount' ? 'btn-outline-success' : 'btn-outline-info');
        }
    });
    
    // Clear client-side filters
    $('#clear-client-filters').click(function() {
        // Clear filter pills
        $('.filter-pill').removeClass('active btn-success btn-info')
                         .each(function() {
                             const $pill = $(this);
                             const filter = $pill.data('filter');
                             $pill.addClass(filter === 'discount' ? 'btn-outline-success' : 'btn-outline-info');
                         });
        
        // Re-show all products
        $('#products-grid .col-xl-3, #products-grid .col-lg-4, #products-grid .col-md-6, #products-grid .col-12').show();
        $('#no-filter-results').remove();
        updateResultsCount($('#products-grid .col-xl-3:visible, #products-grid .col-lg-4:visible, #products-grid .col-md-6:visible, #products-grid .col-12:visible').length);
    });
    
    // Auto-apply PA-API 5 filters when form fields change
    $('[name="api_brand"], [name="api_min_price"], [name="api_max_price"], [name="api_condition"], [name="api_delivery_flags"]').on('change input', function() {
        // Add visual indicator that filters will be applied on next search
        const hasFilters = $('[name="api_brand"]').val() || 
                          $('[name="api_min_price"]').val() || 
                          $('[name="api_max_price"]').val() || 
                          $('[name="api_condition"]').val() || 
                          $('[name="api_delivery_flags"]').val();
        
        if (hasFilters) {
            if ($('#filter-indicator').length === 0) {
                $('#submit-button').after('<small id="filter-indicator" class="d-block text-info mt-1"><i class="bi bi-info-circle me-1"></i><?php esc_html_e("API filters will be applied on next search", "ams-wc-amazon"); ?></small>');
            }
        } else {
            $('#filter-indicator').remove();
        }
    });
    
    // Recent Searches are now always visible - no toggle needed
    
    // Show More/Less searches toggle
    $(document).on('click', '#toggle-more-searches', function() {
        const $hiddenSearches = $('.recent-search-hidden');
        const $icon = $(this).find('i');
        const $text = $(this);
        
        if ($hiddenSearches.is(':visible')) {
            // Hide additional searches
            $hiddenSearches.hide();
            $icon.removeClass('bi-chevron-up').addClass('bi-chevron-down');
            const hiddenCount = $hiddenSearches.length;
            $text.html(`<i class="bi bi-chevron-down me-1"></i><?php esc_html_e('Show More', 'ams-wc-amazon'); ?> (${hiddenCount})`);
        } else {
            // Show additional searches
            $hiddenSearches.show();
            $icon.removeClass('bi-chevron-down').addClass('bi-chevron-up');
            $text.html(`<i class="bi bi-chevron-up me-1"></i><?php esc_html_e('Show Less', 'ams-wc-amazon'); ?>`);
        }
    });
    
    // API Filters toggle functionality
    $('#toggle-api-filters').click(function() {
        $('#api-filters-panel').toggleClass('show');
        const isVisible = $('#api-filters-panel').hasClass('show');
        $('#api-filters-icon').toggleClass('bi-chevron-right bi-chevron-down');
    });
    
    // API Settings functionality
    $('#toggle-api-settings').click(function() {
        $('#api-settings-panel').toggleClass('show');
        const isVisible = $('#api-settings-panel').hasClass('show');
        $('#api-settings-icon').toggleClass('bi-chevron-right bi-chevron-down');
    });
    
    // Save API Settings
    $('#save-api-settings').click(function() {
        const $button = $(this);
        const originalText = $button.html();
        
        $button.html('<span class="spinner-border spinner-border-sm me-1"></span><?php esc_html_e("Saving...", "ams-wc-amazon"); ?>').prop('disabled', true);
        
        $.ajax({
            url: amsbackend.ajax_url,
            type: 'POST',
            data: {
                action: 'save_results_limit',
                products_per_page: $('#products-per-page-setting').val(),
                auto_load_more: $('#auto-load-more-setting').val(),
                max_pages: $('#max-pages-setting').val(),
                _wpnonce: $('input[name="_wpnonce"]').val()
            },
            success: function(response) {
                if (response.success) {
                    showToast('<?php esc_html_e("Settings saved successfully!", "ams-wc-amazon"); ?>', 'success');
                } else {
                    showToast('<?php esc_html_e("Failed to save settings", "ams-wc-amazon"); ?>', 'error');
                }
            },
            error: function() {
                showToast('<?php esc_html_e("Error saving settings", "ams-wc-amazon"); ?>', 'error');
            },
            complete: function() {
                $button.html(originalText).prop('disabled', false);
            }
        });
    });
    
    // Reset API Settings
    $('#reset-api-settings').click(function() {
        $('#products-per-page-setting').val('10');
        $('#auto-load-more-setting').val('0');
        $('#max-pages-setting').val('1');
        showToast('<?php esc_html_e("Settings reset to defaults", "ams-wc-amazon"); ?>', 'info');
    });
    
    // Load More Results functionality
    let currentPage = 1;
    let currentSearchData = null;
    
    $('#load-more-results').click(function() {
        if (!currentSearchData) return;
        
        const maxPages = parseInt($('#max-pages-setting').val()) || 1;
        if (currentPage >= maxPages) {
            $(this).prop('disabled', true).html('<i class="bi bi-check-circle me-1"></i><?php esc_html_e("All pages loaded", "ams-wc-amazon"); ?>');
            return;
        }
        
        const $button = $(this);
        const originalText = $button.html();
        
        $button.prop('disabled', true).html('<span class="spinner-border spinner-border-sm me-1"></span><?php esc_html_e("Loading...", "ams-wc-amazon"); ?>');
        
        currentPage++;
        
        // Prepare form data for next page
        const formData = {
            action: 'search_products',
            wca_search_by: currentSearchData.type,
            wca_keyword: currentSearchData.keyword,
            wca_amazon_cat: currentSearchData.category,
            wca_sort_by: currentSearchData.sort,
            wca_item_page: currentPage,
            _wpnonce: $('input[name="_wpnonce"]').val()
        };
        
        // Add PA-API 5 filters if they exist
        if (currentSearchData.filters) {
            Object.assign(formData, currentSearchData.filters);
        }
        
        $.ajax({
            url: amsbackend.ajax_url,
            type: 'POST',
            data: formData,
            success: function(response) {
                if (response && response.trim()) {
                    // Append new products to existing grid
                    $('#products-grid').append(response);
                    
                    // Update results count
                    const newCount = $('#products-grid .col-xl-3').length;
                    updateResultsCount(newCount);
                    
                    // Apply saved view preference to new products
                    const wcaViewMode = localStorage.getItem('wcaProductViewMode');
                    const amsViewMode = localStorage.getItem('ams_view_mode');
                    const savedViewMode = amsViewMode || wcaViewMode || 'grid';
                    if (savedViewMode === 'list' && typeof applyListView === 'function') {
                        setTimeout(() => {
                            applyListView();
                        }, 100);
                    }
                    
                    // Update page info
                    $('#current-page').text(currentPage);
                    $('#max-pages-display').text(maxPages);
                    
                    // Check if we've reached the max pages
                    if (currentPage >= maxPages) {
                        $button.prop('disabled', true).html('<i class="bi bi-check-circle me-1"></i><?php esc_html_e("All pages loaded", "ams-wc-amazon"); ?>');
                    } else {
                        $button.prop('disabled', false).html(originalText);
                    }
                } else {
                    // No more results
                    $button.prop('disabled', true).html('<i class="bi bi-info-circle me-1"></i><?php esc_html_e("No more results", "ams-wc-amazon"); ?>');
                }
            },
            error: function() {
                showToast('<?php esc_html_e("Failed to load more results", "ams-wc-amazon"); ?>', 'error');
                $button.prop('disabled', false).html(originalText);
            }
        });
    });
    
    // Restore last view preference (grid/list) on page load
    restoreViewPreference();
    
    // Count and update results if any exist on page load
    countResultsWithDelay();
    
    // Also check after a longer delay to catch any dynamically loaded content
    setTimeout(() => {
        const wcaViewMode = localStorage.getItem('wcaProductViewMode');
        const amsViewMode = localStorage.getItem('ams_view_mode');
        const savedViewMode = amsViewMode || wcaViewMode || 'grid';
        if (savedViewMode === 'list' && $('#products-grid .card').length > 0) {
            // Check if cards are still in grid format and need list view applied
            const $firstCard = $('#products-grid .card').first();
            if (!$firstCard.hasClass('d-flex')) {
                applyListView();
            }
        }
        // Update count again in case products were loaded dynamically
        countAndUpdateResults();
    }, 1000);
});

// Function to restore the last view preference
function restoreViewPreference() {
    // Check both storage keys and use the most recent one
    const wcaViewMode = localStorage.getItem('wcaProductViewMode');
    const amsViewMode = localStorage.getItem('ams_view_mode');
    
    // Use whichever key has a value, preferring ams_view_mode if both exist
    const savedViewMode = amsViewMode || wcaViewMode || 'grid';
    
    // Sync both storage keys to ensure consistency
    localStorage.setItem('wcaProductViewMode', savedViewMode);
    localStorage.setItem('ams_view_mode', savedViewMode);
    
    if (savedViewMode === 'list') {
        // Set list view as active
        $('#grid-view-btn').removeClass('active');
        $('#list-view-btn').addClass('active');
        
        // Apply list view to any existing products immediately and with retries
        applyListViewWithRetry();
    } else {
        // Default to grid view
        $('#grid-view-btn').addClass('active');
        $('#list-view-btn').removeClass('active');
    }
}

// Function to apply list view with retry mechanism
function applyListViewWithRetry(attempts = 0) {
    const maxAttempts = 10;
    const $cards = $('#products-grid .card');
    
    if ($cards.length > 0) {
        applyListView();
    } else if (attempts < maxAttempts) {
        // Retry after a short delay if no cards found yet
        setTimeout(() => {
            applyListViewWithRetry(attempts + 1);
        }, 200);
    }
}

// Function to apply list view formatting
function applyListView() {
    const $grid = $('#products-grid');
    const $gridCols = $grid.find('.col-xl-3, .col-lg-4, .col-md-6, .col-12');
    
    // Switch to list view - make cards full width and horizontal
    $gridCols.removeClass('col-xl-3 col-lg-4 col-md-6').addClass('col-12');
    
    // Make cards horizontal using Bootstrap flex classes
    $grid.find('.card').each(function() {
        const $card = $(this);
        const $imageContainer = $card.find('.position-relative').first();
        const $cardBody = $card.find('.card-body');
        
        // Make card horizontal with proper layout
        $card.addClass('d-flex flex-row align-items-stretch');
        
        // Image container - fixed width and height
        $imageContainer.removeClass('d-flex align-items-center justify-content-center')
                      .addClass('flex-shrink-0 d-flex align-items-center justify-content-center border-end')
                      .css({'height': '140px', 'width': '140px', 'min-width': '140px'});
        
        // Card body - flexible with better spacing
        $cardBody.addClass('flex-fill d-flex flex-column justify-content-between')
                 .css({'min-height': '140px'});
        
        // Reorganize content for horizontal layout
        const $title = $cardBody.find('.card-title');
        const $brand = $cardBody.find('.badge.bg-light.text-dark.border').parent();
        const $rating = $cardBody.find('.d-flex.align-items-center.mb-2').first();
        const $price = $cardBody.find('.d-flex.align-items-center.justify-content-between.mb-2');
        const $availability = $cardBody.find('.mb-2').has('.text-warning');
        const $actions = $cardBody.find('.d-flex.align-items-center.justify-content-between.mb-3');
        const $importBtn = $cardBody.find('.mt-auto');
        
        // Create horizontal layout structure
        const $leftContent = $('<div class="flex-fill pe-3"></div>');
        const $rightContent = $('<div class="d-flex flex-column justify-content-between" style="min-width: 200px;"></div>');
        
        // Move content to left side
        if ($brand.length) $leftContent.append($brand);
        if ($title.length) $leftContent.append($title);
        if ($rating.length) $leftContent.append($rating);
        if ($availability.length) $leftContent.append($availability);
        
        // Move content to right side
        if ($price.length) $rightContent.append($price);
        if ($actions.length) $rightContent.append($actions);
        if ($importBtn.length) $rightContent.append($importBtn);
        
        // Clear card body and add new structure
        $cardBody.empty().append($leftContent).append($rightContent);
    });
}

// Client-side filtering function
// Global function for updating results count (used by client-side filters)
function updateResultsCount(count) {
    $('#results-count').text(`${count} <?php esc_html_e("products found", "ams-wc-amazon"); ?>`);
}

function applyClientSideFilters() {
    const filters = {
        brand: $('[name="filter_brand"]').val().toLowerCase(),
        minPrice: parseFloat($('[name="min_price"]').val()) || 0,
        maxPrice: parseFloat($('[name="max_price"]').val()) || Infinity,
        minDiscount: parseInt($('[name="min_discount"]').val()) || 0,
        minRating: parseFloat($('[name="min_rating"]').val()) || 0,
        primeOnly: $('[name="prime_only"]').val(),
        condition: $('[name="condition"]').val()
    };
    
    let visibleCount = 0;
    
    $('#products-grid .col-xl-3, #products-grid .col-lg-4, #products-grid .col-md-6, #products-grid .col-12').each(function() {
        const $card = $(this);
        const $cardContent = $card.find('.card');
        let showCard = true;
        
        // Brand filter
        if (filters.brand) {
            const brandText = $cardContent.find('.badge.bg-primary.bg-opacity-10').text().toLowerCase();
            if (!brandText.includes(filters.brand)) {
                showCard = false;
            }
        }
        
        // Price filter
        if (filters.minPrice > 0 || filters.maxPrice < Infinity) {
            const priceText = $cardContent.find('.fw-bold.text-success').text();
            const priceMatch = priceText.match(/[\d,]+\.?\d*/);
            if (priceMatch) {
                const price = parseFloat(priceMatch[0].replace(',', ''));
                if (price < filters.minPrice || price > filters.maxPrice) {
                    showCard = false;
                }
            }
        }
        
        // Discount filter
        if (filters.minDiscount > 0) {
            const discountText = $cardContent.find('.badge.bg-danger').text();
            const discountMatch = discountText.match(/(\d+)%/);
            if (!discountMatch || parseInt(discountMatch[1]) < filters.minDiscount) {
                showCard = false;
            }
        }
        
        // Rating filter
        if (filters.minRating > 0) {
            const starCount = $cardContent.find('.bi-star-fill').length;
            const halfStar = $cardContent.find('.bi-star-half').length * 0.5;
            const totalRating = starCount + halfStar;
            if (totalRating < filters.minRating) {
                showCard = false;
            }
        }
        
        // Prime filter
        if (filters.primeOnly !== '') {
            const hasPrime = $cardContent.find('.badge.bg-primary').length > 0;
            if ((filters.primeOnly === '1' && !hasPrime) || (filters.primeOnly === '0' && hasPrime)) {
                showCard = false;
            }
        }
        
        // Condition filter
        if (filters.condition) {
            const conditionBadge = $cardContent.find('.badge.bg-info').text();
            if (filters.condition === 'New' && conditionBadge) {
                showCard = false; // New products don't have condition badge
            } else if (filters.condition !== 'New' && !conditionBadge.includes(filters.condition)) {
                showCard = false;
            }
        }
        
        // Show/hide card
        if (showCard) {
            $card.show();
            visibleCount++;
        } else {
            $card.hide();
        }
    });
    
    // Update results count
    updateResultsCount(visibleCount);
    
    // Show message if no results
    if (visibleCount === 0) {
        if ($('#no-filter-results').length === 0) {
            $('#products-grid').append(`
                <div class="col-12 text-center py-5" id="no-filter-results">
                    <div class="mb-3">
                        <i class="bi bi-funnel text-muted" style="font-size: 3rem;"></i>
                    </div>
                    <h5 class="text-muted mb-2">No products match your filters</h5>
                    <p class="text-muted mb-3">Try adjusting your filter criteria or clear all filters</p>
                    <button type="button" class="btn btn-outline-primary" id="clear-filters-from-empty">
                        <i class="bi bi-x-circle me-1"></i>Clear All Filters
                    </button>
                </div>
            `);
        }
    } else {
        $('#no-filter-results').remove();
    }
}

// Handle clear filters from empty state
$(document).on('click', '#clear-filters-from-empty', function() {
    $('#clear-client-filters').click();
});

// Client-side filter functions (for discount and trending)
function applyClientSideFilter(filter, value) {
    let visibleCount = 0;
    
    $('#products-grid .col-xl-3, #products-grid .col-lg-4, #products-grid .col-md-6, #products-grid .col-12').each(function() {
        const $card = $(this);
        const $cardContent = $card.find('.card');
        let showCard = true;
        
        switch(filter) {
            case 'discount':
                const discountText = $cardContent.find('.badge.bg-danger').text();
                const discountMatch = discountText.match(/(\d+)%/);
                if (!discountMatch || parseInt(discountMatch[1]) < parseInt(value)) {
                    showCard = false;
                }
                break;
                
            case 'trending':
                // Check if product has trending badge
                const hasTrendingBadge = $cardContent.find('.badge.bg-warning').length > 0;
                if (!hasTrendingBadge) {
                    showCard = false;
                }
                break;
        }
        
        if (showCard) {
            $card.show();
            visibleCount++;
        } else {
            $card.hide();
        }
    });
    
    updateResultsCount(visibleCount);
    handleEmptyResults(visibleCount);
}

function removeClientSideFilter(filter) {
    // Show all products when removing a client-side filter
    $('#products-grid .col-xl-3, #products-grid .col-lg-4, #products-grid .col-md-6, #products-grid .col-12').show();
    $('#no-filter-results').remove();
    updateResultsCount($('#products-grid .col-xl-3:visible, #products-grid .col-lg-4:visible, #products-grid .col-md-6:visible, #products-grid .col-12:visible').length);
}

    function handleEmptyResults(visibleCount) {
        if (visibleCount === 0) {
            if ($('#no-filter-results').length === 0) {
                $('#products-grid').append(`
                    <div class="col-12 text-center py-5" id="no-filter-results">
                        <div class="mb-3">
                            <i class="bi bi-funnel text-muted" style="font-size: 3rem;"></i>
                        </div>
                        <h5 class="text-muted mb-2">No products match your filters</h5>
                        <p class="text-muted mb-3">Try adjusting your filter criteria or clear filters</p>
                        <button type="button" class="btn btn-outline-primary" id="clear-filters-from-empty">
                            <i class="bi bi-x-circle me-1"></i>Clear Client Filters
                        </button>
                    </div>
                `);
            }
        } else {
            $('#no-filter-results').remove();
        }
    }
    
    // API Validation Function
    function validateApiCredentials() {
        // Show compact loading state
        // Show persistent loading toast for API validation
        if (typeof showToast === 'function') {
            showToast('<?php esc_html_e('Validating API credentials...', 'ams-wc-amazon'); ?>', 'success', true);
        }
        
        // Make AJAX call to validate API (100% backend processing)
        $.ajax({
            url: amsbackend.ajax_url,
            type: 'POST',
            data: {
                action: 'validate_amazon_api',
                _wpnonce: $('input[name="_wpnonce"]').val()
            },
            success: function(response) {
                if (response.success) {
                    // API is valid - show success toast
                    if (typeof showToast === 'function') {
                        showToast('<?php esc_html_e('API Connected', 'ams-wc-amazon'); ?> - ' + response.data.message, 'success');
                    }
                    
                    // Enable search form
                    $('#wca-product-search').css('pointer-events', 'auto').removeClass('opacity-50');
                    $('.card.ams-common-card-fix').removeClass('opacity-50');
                    
                } else {
                    // API validation failed - show compact error message
                    const errorType = response.data.type || 'api_error';
                    const errorMessage = response.data.message || '<?php esc_html_e('API validation failed', 'ams-wc-amazon'); ?>';
                    
                    let alertClass = 'alert-danger';
                    let iconClass = 'bi-exclamation-triangle';
                    let title = '<?php esc_html_e('API Error', 'ams-wc-amazon'); ?>';
                    let btnClass = 'btn-danger';
                    
                    if (errorType === 'country_mismatch') {
                        alertClass = 'alert-warning';
                        iconClass = 'bi-globe';
                        title = '<?php esc_html_e('Country Mismatch', 'ams-wc-amazon'); ?>';
                        btnClass = 'btn-warning';
                    } else if (errorType === 'rate_limit') {
                        alertClass = 'alert-info';
                        iconClass = 'bi-clock';
                        title = '<?php esc_html_e('Rate Limited', 'ams-wc-amazon'); ?>';
                        btnClass = 'btn-info';
                    }
                    
                    // Show error toast
                    if (typeof showToast === 'function') {
                        // For country mismatch, show just the server message (it's already descriptive)
                        if (errorType === 'country_mismatch') {
                            showToast(errorMessage, 'error');
                        } else {
                            showToast(title + ': ' + errorMessage, 'error');
                        }
                    }
                    
                    // Show warning but allow interaction - don't block the entire form
                    if (typeof showToast === 'function') {
                        showToast('<?php esc_html_e('API credentials are invalid. Please configure them in settings before searching.', 'ams-wc-amazon'); ?>', 'warning');
                    }
                }
            },
            error: function() {
                // Show connection error toast
                if (typeof showToast === 'function') {
                    showToast('<?php esc_html_e('Unable to validate API credentials. Please check your connection.', 'ams-wc-amazon'); ?>', 'error');
                }
            }
        });
    }
</script>